/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.sys.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.dao.sys.SecPermissionMapper;
import cn.smarthse.modules.health.entity.base.company.CompanyCaseInfoParam;
import cn.smarthse.modules.health.entity.sys.SecPermission;
import cn.smarthse.modules.health.entity.sys.SysUser;
import cn.smarthse.modules.health.entity.sys.v3.SysMenuV3Vo;
import cn.smarthse.modules.health.entity.sys.vo.SecPermissionGroup;
import cn.smarthse.modules.health.entity.sys.vo.SecPermissionGroupDetail;
import cn.smarthse.modules.health.entity.sys.vo.SecPermissionParam;
import cn.smarthse.modules.health.entity.sys.vo.SecPermissionVO;
import cn.smarthse.modules.health.enums.sys.CompanyMenuTypeEnum;
import cn.smarthse.modules.health.enums.sys.PermissionTypeEnum;
import cn.smarthse.modules.health.service.base.ICompanyService;
import cn.smarthse.modules.health.service.sys.ISecPermissionService;
import cn.smarthse.modules.health.service.sys.ISysUserService;
import cn.smarthse.modules.health.supervise.service.sys.v3.ISysMenuAreaV3Service;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class SecPermissionServiceImpl
extends BaseServiceImpl<SecPermissionMapper, SecPermission>
implements ISecPermissionService {
    @Autowired
    private ISysUserService sysUserService;
    @Autowired
    private ICompanyService companyService;
    @DubboReference
    private ISysMenuAreaV3Service menuAreaService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;
    @Autowired
    private RedisClient redisClient;
    private static final String NEW_COMPANY_MENU_CACHE = "companyMenuCache_newCompany";
    private static final String MICRO_COMPANY_MENU_CACHE = "companyMenuCache_microCompany";
    private static final String EXIST_RADIOACTIVITY_MENU_CACHE = "companyMenuCache_existRadioactivity";
    private static final Long COMPANY_MENU_CACHE_TIME = 86400L;

    public SecPermission getByIDWithEntity(Long id) {
        if (id == null || id == 0L) {
            return null;
        }
        SecPermission permission = (SecPermission)this.getById(id);
        if (permission.getParentId() != null && permission.getParentId() > 0L) {
            SecPermission parent = (SecPermission)this.getById(permission.getParentId());
            permission.setParent(parent);
        }
        return permission;
    }

    public List<SecPermission> getSecPermissionGroupList(List<Long> perIds) {
        Example example = new Example(SecPermission.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("parentId", (Object)"0").andEqualTo("isValid", (Object)Global.TRUE);
        if (perIds != null && perIds.size() > 0) {
            c.andIn("id", perIds);
        }
        return this.getListByExample(example);
    }

    public List<SecPermission> getSecPermissionItemList(List<Long> parentIds) {
        Example example = new Example(SecPermission.class);
        example.createCriteria().andIn("parentId", parentIds).andEqualTo("isValid", (Object)Global.TRUE);
        return this.getListByExample(example);
    }

    public PageInfo<SecPermission> getSecPermissionList(JqGridParam gparam, SecPermissionParam query) {
        if (gparam == null) {
            return new PageInfo();
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        List<SecPermission> list = ((SecPermissionMapper)this.dao).getListByQuery(query);
        return new PageInfo(list);
    }

    public Map<Long, SecPermissionGroup> getPermissionGroups(SecPermissionParam query) {
        TreeMap<Long, SecPermissionGroup> groupMap = new TreeMap<Long, SecPermissionGroup>();
        if (query == null || query.getParentId() == null) {
            return groupMap;
        }
        List<SecPermissionVO> list = ((SecPermissionMapper)this.dao).getPermissionDetailList(query);
        if (list == null || list.size() == 0) {
            return groupMap;
        }
        for (SecPermissionVO l : list) {
            SecPermissionGroupDetail detail;
            SecPermissionGroup group;
            Long permissionId;
            if (query.getParentId() == 1L && (l.getPermissionName().equals("\u7ba1\u7406\u673a\u6784") || l.getPermissionName().equals("\u8bbe\u5907\u8bbe\u65bd\u4fe1\u606f\u4e0e\u5206\u7c7b")) || query.getParentId() == 2L && l.getPermissionName().equals("\u8bc4\u4ef7\u5de5\u4f5c\u7ba1\u7406")) continue;
            if (query.getParentId() == 7L && l.getPermissionName().equals("\u81ea\u6211\u8bc4\u5b9a")) {
                l.setPermissionName("\u5206\u7c7b\u81ea\u67e5");
                permissionId = l.getPermissionId();
                group = (SecPermissionGroup)groupMap.get(permissionId);
                if (group == null) {
                    group = new SecPermissionGroup();
                    group.setPermissionId(permissionId);
                    group.setPermissionName(l.getPermissionName());
                }
                detail = group.getDetail();
                this.setPermissionGroupDetail(l, detail);
                groupMap.put(permissionId, group);
                continue;
            }
            permissionId = l.getPermissionId();
            group = (SecPermissionGroup)groupMap.get(permissionId);
            if (group == null) {
                group = new SecPermissionGroup();
                group.setPermissionId(permissionId);
                group.setPermissionName(l.getPermissionName());
            }
            detail = group.getDetail();
            this.setPermissionGroupDetail(l, detail);
            groupMap.put(permissionId, group);
        }
        return groupMap;
    }

    private void setPermissionGroupDetail(SecPermissionVO l, SecPermissionGroupDetail detail) {
        Byte permissionType = l.getPermissionType();
        if (permissionType == null) {
            return;
        }
        Long permissionDetailId = l.getPermissionDetailId();
        if (PermissionTypeEnum.edit.value.byteValue() == permissionType.byteValue()) {
            detail.setPermissionEditId(permissionDetailId);
        } else if (PermissionTypeEnum.view.value.byteValue() == permissionType.byteValue()) {
            detail.setPermissionViewId(permissionDetailId);
        }
    }

    public List<SecPermissionVO> getRolePermissionDetailList(SecPermissionParam query) {
        if (query == null || query.getRoleId() == null) {
            return null;
        }
        List<SecPermissionVO> list = ((SecPermissionMapper)this.dao).getPermissionDetailList(query);
        return list;
    }

    public Set<String> getRolePermission(Long userId) {
        if (userId == null) {
            return CollUtil.newHashSet((Object[])new String[0]);
        }
        return ((SecPermissionMapper)this.dao).selectRolePermission(userId);
    }

    public Set<String> getMenuPermission(Integer systemWideMenu, Long userId) {
        if (systemWideMenu == null || userId == null) {
            return CollUtil.newHashSet((Object[])new String[0]);
        }
        return ((SecPermissionMapper)this.dao).selectMenuPermission(systemWideMenu, userId);
    }

    public List<SysMenuV3Vo> getSysMenuByUserId(CompanyCaseInfoParam param) {
        List<SysMenuV3Vo> menuList;
        boolean isRiskBeta;
        Integer systemWide = param.getSystemWide();
        Long userId = param.getUserId();
        Boolean isNewCompany = param.getIsNewCompany();
        Boolean isYcProjMicroCompany = param.getIsYcProjMicroCompany();
        Boolean isExistRadioactivity = param.getIsExistRadioactivity();
        Boolean isDec = param.getIsDec();
        List companyCaseList = param.getCompanyCaseList();
        boolean bl = isRiskBeta = CollUtil.isNotEmpty((Collection)companyCaseList) && companyCaseList.contains("2");
        if (systemWide == null || userId == null) {
            return CollUtil.newArrayList((Object[])new SysMenuV3Vo[0]);
        }
        SysUser user = (SysUser)this.sysUserService.getById(userId);
        if (user == null) {
            return CollUtil.newArrayList((Object[])new SysMenuV3Vo[0]);
        }
        HashSet<SysMenuV3Vo> menuCollection = new HashSet<SysMenuV3Vo>();
        if (Boolean.TRUE.equals(isNewCompany)) {
            menuList = this.getCompanyCaseMenuList(systemWide, CompanyMenuTypeEnum.NEW_COMPANY);
            menuCollection.addAll(menuList);
        } else if (Boolean.TRUE.equals(isYcProjMicroCompany)) {
            menuList = this.getCompanyCaseMenuList(systemWide, CompanyMenuTypeEnum.MICRO_COMPANY);
            menuCollection.addAll(menuList);
        } else {
            menuList = ((SecPermissionMapper)this.dao).selectMCListByUserId(systemWide, userId);
            menuCollection.addAll(menuList);
        }
        if (Boolean.TRUE.equals(isRiskBeta) && Boolean.TRUE.equals(isExistRadioactivity)) {
            menuList = this.getCompanyCaseMenuList(systemWide, CompanyMenuTypeEnum.EXIST_RADIOACTIVITY);
            menuCollection.addAll(menuList);
        }
        if (Boolean.TRUE.equals(isRiskBeta)) {
            menuList = this.getCompanyCaseMenuList(systemWide, CompanyMenuTypeEnum.RISK_BETA);
            menuCollection.addAll(menuList);
        }
        Long cid = user.getCid();
        Company company = (Company)this.companyService.getById(cid);
        Set menuIdSet = this.menuAreaService.selectMenuAreaListByAreaId(systemWide, company.getRegionId());
        return menuCollection.stream().filter(menu -> menuIdSet.contains(menu.getMenuId())).filter(menu -> menu.getIsTest() == 0).distinct().collect(Collectors.toList());
    }

    private List<SysMenuV3Vo> getCompanyCaseMenuList(Integer systemWide, CompanyMenuTypeEnum menuType) {
        List<SysMenuV3Vo> menuList;
        boolean hasKey;
        String redisKey = switch (menuType) {
            case CompanyMenuTypeEnum.NEW_COMPANY -> NEW_COMPANY_MENU_CACHE;
            case CompanyMenuTypeEnum.MICRO_COMPANY -> MICRO_COMPANY_MENU_CACHE;
            case CompanyMenuTypeEnum.EXIST_RADIOACTIVITY -> EXIST_RADIOACTIVITY_MENU_CACHE;
            default -> "";
        };
        boolean bl = hasKey = StrUtil.isNotBlank((CharSequence)redisKey) && this.redisClient.hasKey(redisKey);
        if (hasKey) {
            menuList = (List<SysMenuV3Vo>)this.redisClient.get(redisKey);
        } else {
            List<String> menuCodeList = ((SecPermissionMapper)this.dao).selectCompanyMenuCodeList(menuType.getType());
            menuList = ((SecPermissionMapper)this.dao).selectMcListByMenuCodeList(systemWide, menuCodeList);
            this.redisClient.set(redisKey, menuList, COMPANY_MENU_CACHE_TIME.longValue());
        }
        return menuList;
    }

    private List<SysMenuV3Vo> getCompanyCaseMenuList(Integer systemWide, Byte menuType) {
        List<String> menuCodeList = ((SecPermissionMapper)this.dao).selectCompanyMenuCodeList(menuType);
        List<SysMenuV3Vo> menuList = ((SecPermissionMapper)this.dao).selectMcListByMenuCodeList(systemWide, menuCodeList);
        return menuList;
    }

    public Set<String> getAllMenuPermission(Integer systemWide) {
        if (systemWide == null) {
            return CollUtil.newHashSet((Object[])new String[0]);
        }
        return ((SecPermissionMapper)this.dao).selectAllMenuPermission(systemWide);
    }

    @Transactional
    public void judgeAndInsertSysUserRoleV3(Long userId) {
        if (userId == null) {
            return;
        }
        ((SecPermissionMapper)this.dao).judgeAndInsertSysUserRoleV3(userId);
    }

    public boolean judgeCurrentIsNewCompany(Long cid) {
        if (cid == null) {
            return Boolean.FALSE;
        }
        return ((SecPermissionMapper)this.dao).judgeCurrentIsNewCompany(cid);
    }

    public boolean judgeCurrentIsYcProjMicroCompany(Long cid) {
        if (cid == null) {
            return Boolean.FALSE;
        }
        return ((SecPermissionMapper)this.dao).judgeCurrentIsYcProjMicroCompany(cid);
    }
}

