/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.sys.impl;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.dao.sys.ProjectFeedBackMapper;
import cn.smarthse.modules.health.entity.sys.ProjectFeedBack;
import cn.smarthse.modules.health.pojo.FeedBackSearchVo;
import cn.smarthse.modules.health.pojo.FeedBackVo;
import cn.smarthse.modules.health.service.sys.IProjectFeedBackService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class ProjectFeedBackServiceImpl
extends BaseServiceImpl<ProjectFeedBackMapper, ProjectFeedBack>
implements IProjectFeedBackService {
    public ProjectFeedBack getFeedBackByIdAndType(Long projectId, Byte type) {
        if (projectId == null) {
            return null;
        }
        Example example = new Example(ProjectFeedBack.class);
        example.createCriteria().andEqualTo("projectId", (Object)projectId).andEqualTo("type", (Object)type).andEqualTo("isValid", (Object)Global.TRUE);
        List list = this.getListByExample(example);
        if (list.size() == 0) {
            return null;
        }
        return (ProjectFeedBack)list.get(0);
    }

    @Transactional(readOnly=false)
    public ProjectFeedBack addFeedBack(ProjectFeedBack data) {
        if (data == null) {
            return null;
        }
        ProjectFeedBack feedBack = this.getFeedBackByIdAndType(data.getProjectId(), data.getType());
        if (feedBack != null) {
            this.deleteFeedBack(feedBack.getProjectId(), feedBack.getType());
        }
        ProjectFeedBack resultData = this.add(data);
        return resultData;
    }

    public void deleteFeedBack(Long projectId, Byte type) {
        ProjectFeedBack project = new ProjectFeedBack();
        project.setIsValid(Global.FALSE);
        Example example = new Example(ProjectFeedBack.class);
        example.createCriteria().andEqualTo("projectId", (Object)projectId).andEqualTo("type", (Object)type).andEqualTo("isValid", (Object)Global.TRUE);
        ((ProjectFeedBackMapper)this.dao).updateByExampleSelective(project, example);
    }

    public List<Long> queryHaveFeedBackResultCheckIds(Byte type) {
        Example example = new Example(ProjectFeedBack.class);
        example.createCriteria().andEqualTo("type", (Object)type).andEqualTo("isValid", (Object)Global.TRUE);
        List listByExample = this.getListByExample(example);
        List<Long> list = listByExample.stream().map(item -> item.getProjectId()).collect(Collectors.toList());
        return list;
    }

    public PageInfo<FeedBackVo> queryByCompanyAndType(JqGridParam gparam, FeedBackSearchVo searchVo) {
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        List<FeedBackVo> list = ((ProjectFeedBackMapper)this.dao).queryByCompanyAndType(searchVo);
        PageInfo page = new PageInfo(list);
        return page;
    }

    @Transactional(readOnly=false)
    public void updateStatus(Integer status, Long id, Long userId) {
        ((ProjectFeedBackMapper)this.dao).updateStatus(id, status, userId);
    }
}

