/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.standard.impl;

import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.entity.standard.L07LawStandard1List;
import cn.smarthse.modules.health.entity.standard.L07LawStandard2Relation;
import cn.smarthse.modules.health.entity.standard.L07LawStandard3Content;
import cn.smarthse.modules.health.entity.standard.L082OccupationalRiskFactorsHxSw;
import cn.smarthse.modules.health.entity.standard.L083OccupationalRiskFactorsFc;
import cn.smarthse.modules.health.service.standard.IL07LawStandard1listService;
import cn.smarthse.modules.health.service.standard.IL07LawStandard2relationService;
import cn.smarthse.modules.health.service.standard.IL07LawStandard3contentService;
import cn.smarthse.modules.health.service.standard.IL082occupationalRiskFactorsHxSwService;
import cn.smarthse.modules.health.service.standard.IL083occupationalRiskFactorsFcService;
import cn.smarthse.modules.health.service.standard.IStandardService;
import cn.smarthse.modules.health.vo.archive.LimitValueTable;
import cn.smarthse.modules.health.vo.archive.LimitValueTableField;
import cn.smarthse.modules.health.vo.archive.ResultAttributeName;
import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class StandardServiceImpl
implements IStandardService {
    @Autowired
    private IL07LawStandard1listService standardListService;
    @Autowired
    private IL07LawStandard2relationService standardRelationServcie;
    @Autowired
    private IL07LawStandard3contentService standardContentService;
    @Autowired
    private IL083occupationalRiskFactorsFcService factorsFcService;
    @Autowired
    private IL082occupationalRiskFactorsHxSwService factorsHxSwService;

    public List<L07LawStandard1List> searchByTitleNo(String titleNo) {
        return this.standardListService.searchByTitleNo(titleNo);
    }

    public Boolean hasStandardRelationSub(Integer id) {
        if (id == null) {
            return false;
        }
        return this.standardRelationServcie.hasStandardRelationSub(id);
    }

    public List<L07LawStandard3Content> getStandardContentListByStandardIdAndPid(Integer standardId, Integer pid) {
        if (standardId == null || pid == null) {
            return null;
        }
        List list = this.standardContentService.getStandardContentListByStandardIdAndPid(standardId, pid);
        for (L07LawStandard3Content c : list) {
            c.setHasSubContent(this.hasStandardRelationSub(c.getId()));
        }
        return list;
    }

    public L07LawStandard2Relation getL07LawStandard2RelationByPrimaryKey(Integer parmaryKey) {
        if (parmaryKey == null || parmaryKey == 0) {
            return null;
        }
        return this.standardRelationServcie.getById(parmaryKey);
    }

    public List<L07LawStandard3Content> getStandardContentListByStandardIdAndPidChildren(Integer standardId, Integer pid) {
        ArrayList<L07LawStandard3Content> allList = new ArrayList<L07LawStandard3Content>();
        L07LawStandard3Content content = this.standardContentService.getById(pid);
        boolean hasSubContent = this.getContentChildren(standardId, pid, allList);
        if (content != null) {
            content.setHasSubContent(Boolean.valueOf(hasSubContent));
            allList.add(content);
        }
        return allList;
    }

    private boolean getContentChildren(Integer standardId, Integer pid, List<L07LawStandard3Content> allList) {
        List<L07LawStandard3Content> subList = this.getStandardContentListByStandardIdAndPid(standardId, pid);
        if (subList == null || subList.isEmpty()) {
            return false;
        }
        boolean hasSubContent = true;
        for (L07LawStandard3Content c : subList) {
            boolean hasSub = this.getContentChildren(standardId, c.getId(), allList);
            if (hasSub) {
                c.setHasSubContent(Boolean.valueOf(true));
            } else {
                c.setHasSubContent(Boolean.valueOf(false));
            }
            allList.add(c);
        }
        return hasSubContent;
    }

    public String getLimitValueByHarmfactorParamCodeAndAttribute(String paramCode, ResultAttributeName attributeName) {
        if (StringUtils.isEmpty((CharSequence)paramCode) || attributeName == null || attributeName.getType().getLimitValueTable() == null) {
            return null;
        }
        if (attributeName.getType().getLimitValueTable().ordinal() == LimitValueTable.l_08_2_occupational_risk_factors_hx_sw.ordinal()) {
            return this.getLimitValueByParamCodeFromFactorHxSw(paramCode, attributeName);
        }
        if (attributeName.getType().getLimitValueTable().ordinal() == LimitValueTable.l_08_3_occupational_risk_factors_fc.ordinal()) {
            return this.getLimitValueByParamCodeFromFactorFc(paramCode, attributeName);
        }
        return null;
    }

    private String getLimitValueByParamCodeFromFactorFc(String paramCode, ResultAttributeName attributeName) {
        List list = this.factorsFcService.getListByParamCode(paramCode);
        if (list.isEmpty()) {
            return null;
        }
        if (LimitValueTableField.PC_TWA_TOTAL.ordinal() == attributeName.getField().ordinal()) {
            return String.valueOf(((L083OccupationalRiskFactorsFc)list.get(0)).getPcTwaTotalDust() == null ? "" : ((L083OccupationalRiskFactorsFc)list.get(0)).getPcTwaTotalDust());
        }
        if (LimitValueTableField.Max_excursion_limit.ordinal() == attributeName.getField().ordinal()) {
            return String.valueOf(((L083OccupationalRiskFactorsFc)list.get(0)).getMaxExcursionLimitFc() == null ? "" : ((L083OccupationalRiskFactorsFc)list.get(0)).getMaxExcursionLimitFc());
        }
        if (LimitValueTableField.PC_TWA_Respirable.ordinal() == attributeName.getField().ordinal()) {
            return String.valueOf(((L083OccupationalRiskFactorsFc)list.get(0)).getPcTwaRespirableDust() == null ? "" : ((L083OccupationalRiskFactorsFc)list.get(0)).getPcTwaRespirableDust());
        }
        if (LimitValueTableField.Peakcontactconcentration_TOTAL.ordinal() == attributeName.getField().ordinal()) {
            if (((L083OccupationalRiskFactorsFc)list.get(0)).getPcTwaTotalDust() != null) {
                return String.valueOf(((L083OccupationalRiskFactorsFc)list.get(0)).getPcTwaTotalDust().floatValue() * 5.0f);
            }
            return "";
        }
        if (LimitValueTableField.Peakcontactconcentration_Respirable.ordinal() == attributeName.getField().ordinal()) {
            if (((L083OccupationalRiskFactorsFc)list.get(0)).getPcTwaRespirableDust() != null) {
                return String.valueOf(((L083OccupationalRiskFactorsFc)list.get(0)).getPcTwaRespirableDust().floatValue() * 5.0f);
            }
            return "";
        }
        return null;
    }

    private String getLimitValueByParamCodeFromFactorHxSw(String paramCode, ResultAttributeName attributeName) {
        List list = this.factorsHxSwService.getListByParamCode(paramCode);
        if (list.isEmpty()) {
            return null;
        }
        if (LimitValueTableField.MAC.ordinal() == attributeName.getField().ordinal()) {
            return String.valueOf(((L082OccupationalRiskFactorsHxSw)list.get(0)).getMac() == null ? "" : ((L082OccupationalRiskFactorsHxSw)list.get(0)).getMac());
        }
        if (LimitValueTableField.Max_excursion_limit.ordinal() == attributeName.getField().ordinal()) {
            return String.valueOf(((L082OccupationalRiskFactorsHxSw)list.get(0)).getMaxExcursionLimit() == null ? "" : ((L082OccupationalRiskFactorsHxSw)list.get(0)).getMaxExcursionLimit());
        }
        if (LimitValueTableField.PC_STEL.ordinal() == attributeName.getField().ordinal()) {
            return String.valueOf(((L082OccupationalRiskFactorsHxSw)list.get(0)).getPcStel() == null ? "" : ((L082OccupationalRiskFactorsHxSw)list.get(0)).getPcStel());
        }
        if (LimitValueTableField.PC_TWA.ordinal() == attributeName.getField().ordinal()) {
            return String.valueOf(((L082OccupationalRiskFactorsHxSw)list.get(0)).getPcTwa() == null ? "" : ((L082OccupationalRiskFactorsHxSw)list.get(0)).getPcTwa());
        }
        if (LimitValueTableField.Peakcontactconcentration.ordinal() == attributeName.getField().ordinal()) {
            if (((L082OccupationalRiskFactorsHxSw)list.get(0)).getPcTwa() != null) {
                return String.valueOf(((L082OccupationalRiskFactorsHxSw)list.get(0)).getPcTwa().floatValue() * 5.0f);
            }
            return "";
        }
        return null;
    }
}

