/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.provider;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.util.Digests;
import cn.smarthse.common.util.Encodes;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.entity.base.company.CompanySoft;
import cn.smarthse.modules.health.entity.sys.SysUser;
import cn.smarthse.modules.health.entity.sys.SysUserLogin;
import cn.smarthse.modules.health.provider.IHealthCorpService;
import cn.smarthse.modules.health.service.base.ICompanyService;
import cn.smarthse.modules.health.service.base.company.ICompanySoftService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.sys.ISecUserRoleService;
import cn.smarthse.modules.health.service.sys.ISysUserLoginService;
import cn.smarthse.modules.health.service.sys.ISysUserService;
import cn.smarthse.modules.platform.model.CorpInfoModel;
import cn.smarthse.modules.platform.model.CorpModel;
import cn.smarthse.modules.platform.model.CorpSoftModel;
import cn.smarthse.modules.platform.model.UserModel;
import java.util.Date;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@com.alibaba.dubbo.config.annotation.Service(version="1.0.0")
@Transactional(readOnly=true)
public class HealthCorpServiceImpl
implements IHealthCorpService {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    ISysUserService sysUserService;
    @Autowired
    ISysUserLoginService userLoginService;
    @Autowired
    ICompanyService companyService;
    @Autowired
    ICompanySoftService companySoftService;
    @Autowired
    IStaffInfoService staffInfoService;
    @DubboReference
    ISysFileProvideService fileService;
    @Autowired
    ISecUserRoleService userRoleService;

    @Transactional(readOnly=false)
    public void regAndOpenCorp(CorpModel corpmodel) {
        if (corpmodel == null) {
            throw new HealthException("\u53c2\u6570\u9519\u8bef!");
        }
        if (corpmodel.getCorpInfo() == null) {
            throw new HealthException("\u4f01\u4e1a\u4fe1\u606f\u9519\u8bef!");
        }
        if (corpmodel.getCorpSoft() == null) {
            throw new HealthException("\u4f01\u4e1a\u8f6f\u4ef6\u4fe1\u606f\u9519\u8bef!");
        }
        CompanySoft csoft = this.companySoftService.getByplatformCid(corpmodel.getCorpInfo().getCorpId());
        if (csoft != null) {
            this.companySoftService.updateCompanySoftByPlatform(csoft, corpmodel.getCorpSoft());
        } else {
            csoft = this.companySoftService.addCompanySoftByPlatform(corpmodel.getCorpInfo().getCorpId(), corpmodel.getCorpInfo().getCorpId(), corpmodel.getCorpSoft());
        }
    }

    @Transactional(readOnly=false)
    public void updateUserManger(UserModel userModel) {
        if (userModel == null) {
            throw new HealthException("\u4f01\u4e1a\u8f6f\u4ef6\u7ba1\u7406\u5458\u4fe1\u606f\u9519\u8bef!");
        }
        CompanySoft csoft = this.companySoftService.getByplatformCid(userModel.getCorpId());
        if (csoft == null) {
            throw new HealthException("\u4f01\u4e1a\u8f6f\u4ef6\u672a\u5f00\u901a,\u64cd\u4f5c\u5931\u8d25!");
        }
        this.updateManager(userModel);
    }

    private void updateManager(UserModel userModel) {
        if (userModel.getIsManger() == null || !userModel.getIsManger().booleanValue()) {
            throw new HealthException("\u975e\u7ba1\u7406\u5458\u64cd\u4f5c,\u64cd\u4f5c\u5931\u8d25!");
        }
        SysUserLogin sysUserLogin = this.getUserLoginByToken(userModel.getUsertoken());
        if (sysUserLogin == null) {
            throw new HealthException("\u627e\u4e0d\u5230\u7528\u6237\u767b\u5f55\u4fe1\u606f,\u64cd\u4f5c\u5931\u8d25!");
        }
        SysUser sysUser = this.getUserById(sysUserLogin.getUserId());
        if (sysUser == null) {
            throw new HealthException("\u8be5\u7528\u6237\u4e0d\u5b58\u5728,\u64cd\u4f5c\u5931\u8d25!");
        }
        this.sysUserService.clearUserManger(sysUser.getCid());
        sysUser.setIsManger(Global.TRUE);
        sysUser.setIsValid(Global.TRUE);
        this.sysUserService.update((Object)sysUser);
        this.userRoleService.addSuperManagerRole(sysUser.getId(), null, null);
    }

    private SysUserLogin getUserLoginByToken(String token) {
        if (StringUtils.isEmpty((CharSequence)token)) {
            throw new HealthException("usertoken\u4e3a\u7a7a,\u64cd\u4f5c\u5931\u8d25!");
        }
        SysUserLogin sysUserLogin = this.userLoginService.getByToken(token);
        return sysUserLogin;
    }

    private SysUser getUserById(Long userId) {
        SysUser sysUser = (SysUser)this.sysUserService.getById(userId);
        return sysUser;
    }

    @Transactional(readOnly=false)
    public void updateUserInfo(UserModel userModel) {
        this.logger.info("\u3010\u5e73\u53f0\u540c\u6b65\u63a5\u53e3\u3011\u2014\u2014\u66f4\u65b0\u3001\u521b\u5efa\u7528\u6237");
        CompanySoft csoft = this.companySoftService.getByplatformCid(userModel.getCorpId());
        if (csoft == null) {
            throw new HealthException("\u4f01\u4e1a\u8f6f\u4ef6\u672a\u5f00\u901a,\u64cd\u4f5c\u5931\u8d25!");
        }
        this.updateUserInfoByUserModel(userModel, csoft.getCid());
    }

    private void updateUserInfoByUserModel(UserModel userModel, Long cid) {
        SysUserLogin sysUserLogin = this.getUserLoginByToken(userModel.getUsertoken());
        SysUser sysUser = null;
        if (sysUserLogin == null) {
            Boolean isManager = userModel.getIsManger();
            if (isManager != null && isManager.booleanValue()) {
                this.sysUserService.clearUserManger(cid);
            }
            sysUser = this.sysUserService.addManger(cid, null, userModel);
            sysUserLogin = new SysUserLogin();
            sysUserLogin.setCid(cid);
            sysUserLogin.setIsValid(Global.TRUE);
            sysUserLogin.setToken(userModel.getUsertoken());
            sysUserLogin.setUserId(sysUser.getId());
            sysUserLogin.setPlatformUserId(userModel.getUserId());
            sysUserLogin.setPlatformIsManger(isManager);
            this.userLoginService.add((Object)sysUserLogin);
        } else {
            sysUser = this.getUserById(sysUserLogin.getUserId());
            if (sysUser == null) {
                throw new HealthException("\u7528\u6237\u4e0d\u5b58\u5728,\u64cd\u4f5c\u5931\u8d25!");
            }
            Boolean isManager = userModel.getIsManger();
            if (isManager != null && isManager.booleanValue()) {
                this.sysUserService.clearUserManger(sysUser.getCid());
                this.userRoleService.addSuperManagerRole(sysUser.getId(), null, cid);
            }
            sysUser.setIsValid(Global.TRUE);
            sysUser.setUpdateDate(new Date());
            sysUser.setIsManger(userModel.getIsManger());
            sysUser.setUsername(StringUtils.isBlank((CharSequence)userModel.getUsername()) ? null : userModel.getUsername());
            this.entryptPassword(sysUser, userModel.getPassword());
            this.sysUserService.update((Object)sysUser);
        }
    }

    public SysUser entryptPassword(SysUser user, String plainPassword) {
        String plain = Encodes.unescapeHtml((String)plainPassword);
        byte[] salt = Digests.generateSalt((int)8);
        user.setSalt(Encodes.hexEncode((byte[])salt));
        byte[] hashPassword = Digests.sha1((byte[])plain.getBytes(), (byte[])salt, (int)1024);
        user.setPassword(Encodes.hexEncode((byte[])hashPassword));
        return user;
    }

    @Transactional(readOnly=false)
    public void deleteUser(UserModel userModel) {
        if (userModel == null) {
            throw new HealthException("\u4f01\u4e1a\u8f6f\u4ef6\u7ba1\u7406\u5458\u4fe1\u606f\u9519\u8bef!");
        }
        CompanySoft csoft = this.companySoftService.getByplatformCid(userModel.getCorpId());
        if (csoft == null) {
            throw new HealthException("\u4f01\u4e1a\u8f6f\u4ef6\u672a\u5f00\u901a,\u64cd\u4f5c\u5931\u8d25!");
        }
        SysUserLogin sysUserLogin = this.getUserLoginByToken(userModel.getUsertoken());
        if (sysUserLogin == null) {
            throw new HealthException("\u627e\u4e0d\u5230\u7528\u6237\u767b\u5f55\u4fe1\u606f,\u64cd\u4f5c\u5931\u8d25!");
        }
        SysUser user = this.getUserById(sysUserLogin.getUserId());
        if (user == null) {
            throw new HealthException("\u8d26\u53f7\u4e0d\u5b58\u5728,\u64cd\u4f5c\u5931\u8d25!");
        }
        if (user != null && !user.getCid().equals(csoft.getCid())) {
            throw new HealthException("\u8be5\u8d26\u53f7\u4e0d\u5c5e\u4e8e\u672c\u4f01\u4e1a,\u64cd\u4f5c\u5931\u8d25!");
        }
        user.setIsValid(Global.FALSE);
        user.setUpdateDate(new Date());
        this.sysUserService.update((Object)user);
    }

    public float getSoftUsedSpace(CorpSoftModel corpSoft) {
        CompanySoft csoft = this.companySoftService.getByplatformCid(corpSoft.getCorpId());
        if (csoft == null) {
            throw new HealthException("\u4f01\u4e1a\u8f6f\u4ef6\u672a\u5f00\u901a,\u64cd\u4f5c\u5931\u8d25!");
        }
        Long cid = csoft.getCid();
        Long allSpaceSum = this.fileService.sumSpaceByCid(cid);
        return (float)allSpaceSum.longValue() / 1.0737418E9f;
    }

    @Transactional(readOnly=false)
    public void updateCorpInfo(CorpInfoModel corpInfo) {
        CompanySoft csoft = this.companySoftService.getByplatformCid(corpInfo.getCorpId());
        if (csoft != null) {
            this.companyService.updateCompanyByCorpInfoModel(corpInfo, csoft.getCid());
        }
    }
}

