/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.litearchive.imp.simple;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.dao.litearchive.LiteArchiveMapper;
import cn.smarthse.modules.health.entity.litearchive.LiteArchive;
import cn.smarthse.modules.health.entity.work.thirdtime.LiteArchiveTsLink;
import cn.smarthse.modules.health.entity.work.thirdtime.TsProjectSimple;
import cn.smarthse.modules.health.enums.archive.ArchiveType;
import cn.smarthse.modules.health.enums.thirdtime.TsProgressEnum;
import cn.smarthse.modules.health.enums.thirdtime.TsProjectSimpleStateEnum;
import cn.smarthse.modules.health.enums.thirdtime.TsProjectSimpleStatusEnum;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveFileItemService;
import cn.smarthse.modules.health.service.litearchive.simple.ILiteArchiveSimpleService;
import cn.smarthse.modules.health.service.work.thirdtime.ILiteArchiveTsLinkService;
import cn.smarthse.modules.health.service.work.thirdtime.simple.ITsProjectSimpleService;
import cn.smarthse.modules.health.vo.litearchive.LiteArchiveFileDetailVo;
import cn.smarthse.modules.health.vo.litearchive.TsLiteArchiveVo;
import cn.smarthse.util.common.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Transactional(readOnly=true)
@DubboService
public class LiteArchiveSimpleServiceImpl
extends BaseServiceImpl<LiteArchiveMapper, LiteArchive>
implements ILiteArchiveSimpleService {
    @Autowired(required=false)
    @Lazy
    private ILiteArchiveFileItemService fileItemService;
    @Autowired(required=false)
    @Lazy
    private ILiteArchiveTsLinkService liteArchiveTsLinkService;
    @Autowired
    private ITsProjectSimpleService tsProjectSimpleService;

    public PageInfo<TsLiteArchiveVo> pageTsLiteArchiveVo(JqGridParam jqGridParam, String kw, Long cid, Boolean finish) {
        if (finish.booleanValue()) {
            return this.pageTsLiteArchiveVo(jqGridParam, kw, cid);
        }
        Example example = new Example(LiteArchive.class);
        Example.Criteria criteria = example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("archiveType", (Object)1).andEqualTo("cid", (Object)cid);
        if (StringUtils.isNotBlank((CharSequence)kw)) {
            criteria.andLike("title", "%" + kw + "%");
        }
        PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows());
        List resultList = finish == null || finish == false ? this.getListByExample(example) : this.getCompletedListByCondition(kw, cid);
        PageInfo liteArchivePageInfo = new PageInfo(resultList);
        PageInfo pageVo = new PageInfo();
        BeanUtils.copyProperties((Object)liteArchivePageInfo, (Object)pageVo);
        if (CollectionUtils.isNotEmpty((Collection)liteArchivePageInfo.getList())) {
            ArrayList<TsLiteArchiveVo> voList = new ArrayList<TsLiteArchiveVo>();
            for (LiteArchive liteArchive : liteArchivePageInfo.getList()) {
                TsLiteArchiveVo vo = new TsLiteArchiveVo();
                BeanUtils.copyProperties((Object)liteArchive, (Object)vo);
                LiteArchiveTsLink archiveTsLink = this.liteArchiveTsLinkService.getTsLinkByArchiveId(liteArchive.getId());
                if (archiveTsLink != null) {
                    TsProjectSimple tsProjectSimple = (TsProjectSimple)this.tsProjectSimpleService.getById(archiveTsLink.getTsId());
                    vo.setTsProjectSimple(tsProjectSimple);
                }
                voList.add(vo);
                List fileDetailVos = this.fileItemService.queryDetailList(liteArchive.getId());
                long count = fileDetailVos.stream().filter(f -> f.getNeedCollect() != null && f.getNeedCollect() != false).count();
                List noFinishFileDetail = fileDetailVos.stream().filter(f -> {
                    boolean b = f.getNeedCollect() != null && f.getNeedCollect() != false && StringUtils.isBlank((CharSequence)f.getFileIds());
                    return b;
                }).collect(Collectors.toList());
                if (noFinishFileDetail.size() > 0) {
                    vo.setProgressRate("\u672a\u5b8c\u5584  " + (count - (long)noFinishFileDetail.size()) + "/" + count);
                } else {
                    vo.setProgressRate("\u5df2\u5b8c\u5584");
                }
                vo.setProgressRateTips(noFinishFileDetail.stream().map(LiteArchiveFileDetailVo::getFileName).collect(Collectors.toList()));
            }
            pageVo.setList(voList);
        }
        return pageVo;
    }

    public List<TsLiteArchiveVo> tsLiteArchiveVo(String kw, Long cid) {
        List<TsLiteArchiveVo> tsArchiveList = ((LiteArchiveMapper)this.dao).getTsLiteArchiveList(kw, cid, null);
        if (CollUtil.isEmpty(tsArchiveList)) {
            return Collections.emptyList();
        }
        List tsArchiveIdList = tsArchiveList.stream().map(LiteArchive::getId).filter(Objects::nonNull).collect(Collectors.toList());
        Map tsDetailGroup = this.fileItemService.queryTsArchiveDetailGroup(tsArchiveIdList, Boolean.FALSE);
        return tsArchiveList.stream().map(t -> {
            boolean noneCollect;
            TsProjectSimpleStatusEnum status = TsProjectSimpleStatusEnum.getEnum((Byte)t.getTsStatus());
            TsLiteArchiveVo vo = new TsLiteArchiveVo();
            BeanUtils.copyProperties((Object)t, (Object)vo);
            List detailList = (List)tsDetailGroup.get(t.getId());
            boolean bl = noneCollect = CollUtil.isEmpty((Collection)detailList) || detailList.stream().noneMatch(LiteArchiveFileDetailVo::getNeedCollect);
            if (noneCollect) {
                vo.setProgressRate(TsProgressEnum.TS_NO_FINISH_WORK.getValue());
                vo.setHasRequired(Boolean.FALSE);
            } else {
                switch (status) {
                    case AUDITED: 
                    case NO_NEED_AUDITED: {
                        this.setArchiveInfo((TsLiteArchiveVo)t, vo);
                        break;
                    }
                    case CLOSED: {
                        vo.setProgressRate(TsProgressEnum.TS_TERMINATE.getValue());
                        vo.setHasRequired(Boolean.FALSE);
                        break;
                    }
                    case DRAFT: 
                    case AUDIT: 
                    case BACK: {
                        vo.setProgressRate(TsProgressEnum.TS_NO_PERFECT.getValue());
                        vo.setHasRequired(Boolean.TRUE);
                        break;
                    }
                    default: {
                        vo.setProgressRate(TsProgressEnum.TS_ADD_INFO.getValue());
                        vo.setHasRequired(Boolean.FALSE);
                    }
                }
            }
            TsProjectSimple tsProj = new TsProjectSimple();
            tsProj.setId(t.getTsId());
            tsProj.setStatus(t.getTsStatus());
            vo.setTsProjectSimple(tsProj);
            return vo;
        }).collect(Collectors.toList());
    }

    public PageInfo<TsLiteArchiveVo> getTsLiteArchivePage(JqGridParam pageParam, String keyword, Long cid, Boolean finish, Boolean compliance) {
        if (compliance == null || !compliance.booleanValue()) {
            return this.pageTsLiteArchiveVo(pageParam, keyword, cid);
        }
        Page archivePage = PageHelper.startPage((int)pageParam.getPage(), (int)pageParam.getRows());
        List<TsLiteArchiveVo> archiveList = ((LiteArchiveMapper)this.dao).getTsLiteArchiveList(keyword, cid, null);
        List archiveIdList = archiveList.stream().map(LiteArchive::getId).filter(Objects::nonNull).collect(Collectors.toList());
        Map archiveGroup = this.fileItemService.queryTsArchiveDetailGroup(archiveIdList, Boolean.FALSE);
        if (CollUtil.isNotEmpty(archiveList)) {
            for (TsLiteArchiveVo archive : archiveList) {
                boolean noneCollect;
                List detailList = (List)archiveGroup.get(archive.getId());
                boolean bl = noneCollect = CollUtil.isEmpty((Collection)detailList) || detailList.stream().noneMatch(LiteArchiveFileDetailVo::getNeedCollect);
                if (noneCollect) {
                    archive.setProgressRate(TsProgressEnum.TS_NO_FINISH_WORK.getValue());
                    archive.setHasRequired(Boolean.FALSE);
                } else {
                    switch (TsProjectSimpleStatusEnum.getEnum((Byte)archive.getTsStatus())) {
                        case AUDITED: 
                        case NO_NEED_AUDITED: {
                            this.setCompleteTsLiteArchiveInfo(archive);
                            break;
                        }
                        case CLOSED: {
                            archive.setProgressRate(TsProgressEnum.TS_TERMINATE.getValue());
                            archive.setHasRequired(Boolean.FALSE);
                            break;
                        }
                        case DRAFT: 
                        case AUDIT: 
                        case BACK: {
                            archive.setProgressRate(TsProgressEnum.TS_NO_PERFECT.getValue());
                            archive.setHasRequired(Boolean.TRUE);
                            break;
                        }
                        default: {
                            archive.setProgressRate(TsProgressEnum.TS_ADD_INFO.getValue());
                            archive.setHasRequired(Boolean.FALSE);
                        }
                    }
                }
                TsProjectSimple ts = new TsProjectSimple();
                ts.setId(archive.getTsId());
                ts.setStatus(archive.getTsStatus());
                archive.setTsProjectSimple(ts);
            }
        }
        return new PageInfo((List)archivePage);
    }

    private void setArchiveInfo(TsLiteArchiveVo tsArchive, TsLiteArchiveVo vo) {
        if (Objects.nonNull(tsArchive.getMissingItem())) {
            vo.setProgressRate(TsProgressEnum.TS_NO_NEED.getValue());
            vo.setHasRequired(Boolean.FALSE);
        } else if (Objects.isNull(tsArchive.getProjectFinishTime())) {
            vo.setProgressRate(TsProgressEnum.TS_NO_FINISH_WORK.getValue());
            vo.setHasRequired(Boolean.FALSE);
        } else {
            List detailList = this.fileItemService.queryDetailList(tsArchive.getId());
            detailList.forEach(d -> {
                boolean needCollect;
                d.setNeedCollect(Boolean.FALSE);
                boolean bl = needCollect = d.getFileNameId().equals(104L) && TsProjectSimpleStateEnum.FINISH.getCode().equals(tsArchive.getEvalState()) || d.getFileNameId().equals(106L) && TsProjectSimpleStateEnum.FINISH.getCode().equals(tsArchive.getDesignState()) || d.getFileNameId().equals(109L) && TsProjectSimpleStateEnum.FINISH.getCode().equals(tsArchive.getControlState());
                if (needCollect) {
                    vo.setHasRequired(Boolean.TRUE);
                    d.setNeedCollect(Boolean.TRUE);
                }
            });
            long requiredCount = detailList.stream().filter(f -> Boolean.TRUE.equals(f.getNeedCollect())).count();
            long unfinishedCount = detailList.stream().filter(f -> Boolean.TRUE.equals(f.getNeedCollect()) && CharSequenceUtil.isBlank((CharSequence)f.getFileIds())).count();
            if (unfinishedCount > 0L) {
                vo.setProgressRate(String.format("%s  %d/%d", TsProgressEnum.TS_NO_PERFECT.getValue(), requiredCount - unfinishedCount, requiredCount));
                vo.setComplete(Boolean.valueOf(false));
            } else {
                vo.setProgressRate(TsProgressEnum.TS_IS_PERFECT.getValue());
                vo.setComplete(Boolean.TRUE);
            }
        }
    }

    private void setCompleteTsLiteArchiveInfo(TsLiteArchiveVo tsArchive) {
        if (tsArchive.getMissingItem() != null) {
            tsArchive.setProgressRate(TsProgressEnum.TS_NO_NEED.getValue());
            tsArchive.setHasRequired(Boolean.FALSE);
            return;
        }
        if (tsArchive.getProjectFinishTime() == null) {
            tsArchive.setProgressRate(TsProgressEnum.TS_NO_FINISH_WORK.getValue());
            tsArchive.setHasRequired(Boolean.FALSE);
            return;
        }
        List detailList = this.fileItemService.queryComplianceTsDetailList(tsArchive.getId());
        for (LiteArchiveFileDetailVo d2 : detailList) {
            d2.setNeedCollect(Boolean.FALSE);
            Long fileNameId = d2.getFileNameId();
            boolean evalDesignControlRequire = TsProjectSimpleStateEnum.FINISH.getCode().equals(tsArchive.getEvalState()) && CollUtil.toList((Object[])new Long[]{104L, 103L, 105L}).contains(fileNameId) || TsProjectSimpleStateEnum.FINISH.getCode().equals(tsArchive.getDesignState()) && CollUtil.toList((Object[])new Long[]{106L, 107L}).contains(fileNameId) || TsProjectSimpleStateEnum.FINISH.getCode().equals(tsArchive.getControlState()) && CollUtil.toList((Object[])new Long[]{109L, 108L, 110L, 111L, 1120L}).contains(fileNameId);
            boolean completeFinishRequire = CollUtil.toList((Object[])new Long[]{102L, 101L}).contains(fileNameId);
            if (!evalDesignControlRequire && !completeFinishRequire) continue;
            d2.setNeedCollect(Boolean.TRUE);
            tsArchive.setHasRequired(Boolean.TRUE);
        }
        long needCollect = detailList.stream().filter(d -> Boolean.TRUE.equals(d.getNeedCollect())).count();
        long noFinish = detailList.stream().filter(d -> Boolean.TRUE.equals(d.getNeedCollect()) && CharSequenceUtil.isBlank((CharSequence)d.getFileIds())).count();
        if (noFinish > 0L) {
            tsArchive.setProgressRate(TsProgressEnum.TS_NO_PERFECT.getValue() + "  " + (needCollect - noFinish) + "/" + needCollect);
        } else {
            tsArchive.setProgressRate(TsProgressEnum.TS_IS_PERFECT.getValue());
        }
        tsArchive.setComplete(Boolean.valueOf(noFinish == 0L));
    }

    public PageInfo<TsLiteArchiveVo> pageTsLiteArchiveVo(JqGridParam jqGridParam, String kw, Long cid) {
        Page tsArchivePage = PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows());
        List<TsLiteArchiveVo> tsArchiveList = this.tsLiteArchiveVo(kw, cid);
        PageInfo tsArchiveVoPage = new PageInfo();
        BeanUtils.copyProperties((Object)tsArchivePage, (Object)tsArchiveVoPage);
        tsArchiveVoPage.setList(tsArchiveList);
        return tsArchiveVoPage;
    }

    private List<LiteArchive> getCompletedListByCondition(String kw, Long cid) {
        TsLiteArchiveVo archiveVo = new TsLiteArchiveVo();
        archiveVo.setIsValid(Boolean.valueOf(true));
        archiveVo.setArchiveType(Integer.valueOf(ArchiveType.Archive1.getType()));
        archiveVo.setCid(cid);
        archiveVo.setTitle(kw);
        ArrayList<Byte> statusList = new ArrayList<Byte>();
        statusList.add(TsProjectSimpleStatusEnum.NO_NEED_AUDITED.getCode());
        return ((LiteArchiveMapper)this.dao).selectCompletedListByCondition(archiveVo, statusList);
    }

    private static void judgeAndUpdateArchiveFileNameCollect(TsLiteArchiveVo archiveVo, List<LiteArchiveFileDetailVo> fileDetailVos) {
        TsProjectSimple simple = archiveVo.getTsProjectSimple();
        boolean nullOrUnAdd = simple == null || simple.getDataSource() != 1;
        fileDetailVos.stream().filter(f -> 102L == f.getFileNameId()).forEach(f -> f.setNeedCollect(Boolean.valueOf(!nullOrUnAdd)));
    }

    @Transactional(readOnly=false)
    public void addThreeArchiveSimple(TsProjectSimple tsProjectSimple, Long loginStaffId, Long cid) throws Exception {
        this.verifyTsProjectSimple(tsProjectSimple);
        LiteArchive liteArchive = new LiteArchive();
        liteArchive.setArchiveType(Integer.valueOf(1));
        liteArchive.setArchiveUpdateTime(new Date());
        liteArchive.setTitle(tsProjectSimple.getProjectName());
        liteArchive.setStatus(Integer.valueOf(2));
        liteArchive.setProcStatus(Integer.valueOf(0));
        liteArchive.setIsValid(Global.TRUE);
        LiteArchive archive = this.add(liteArchive, loginStaffId, cid);
        LiteArchiveTsLink tsLink = new LiteArchiveTsLink();
        tsLink.setTsId(tsProjectSimple.getId());
        tsLink.setLiteArchiveId(archive.getId());
        tsLink.setIsValid(Global.TRUE);
        this.liteArchiveTsLinkService.add((Object)tsLink, loginStaffId, cid);
    }

    @Transactional(readOnly=false)
    public void updateThreeArchiveSimple(TsProjectSimple tsProjectSimple, Long loginStaffId) throws Exception {
        LiteArchiveTsLink liteArchiveTsLink = this.liteArchiveTsLinkService.getTsLinkByTs(tsProjectSimple.getId());
        if (liteArchiveTsLink == null) {
            return;
        }
        Long liteArchiveId = liteArchiveTsLink.getLiteArchiveId();
        LiteArchive liteArchive = (LiteArchive)this.getById(liteArchiveId);
        if (liteArchive == null) {
            return;
        }
        liteArchive.setTitle(tsProjectSimple.getProjectName());
        if (tsProjectSimple.getIsValid() == Global.FALSE) {
            liteArchive.setIsValid(tsProjectSimple.getIsValid());
            liteArchiveTsLink.setIsValid(tsProjectSimple.getIsValid());
            this.liteArchiveTsLinkService.update((Object)liteArchiveTsLink, loginStaffId);
        }
        this.update(liteArchive, loginStaffId);
    }

    private void verifyTsProjectSimple(TsProjectSimple tsProjectSimple) throws Exception {
        if (tsProjectSimple == null) {
            throw new Exception("\u4e09\u540c\u65f6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (tsProjectSimple.getId() == null) {
            throw new Exception("\u4e09\u540c\u65f6ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.isNotEmpty((String)tsProjectSimple.getProjectName())) {
            throw new Exception("\u4e09\u540c\u65f6\u9879\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

