/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.litearchive.imp;

import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.modules.health.compliance.enums.ComplianceCodeEnum;
import cn.smarthse.modules.health.compliance.service.IBusinessDataUpdateRefreshService;
import cn.smarthse.modules.health.dao.litearchive.LiteArchiveMapper;
import cn.smarthse.modules.health.enums.reform.ReformGenerationSourceEnum;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceCompanyInfoService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveFileItemService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveFileNameService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveUpdateService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicNewService;
import cn.smarthse.modules.health.vo.litearchive.LiteArchiveRefreshVo;
import cn.smarthse.snowflake.IdWorker;
import cn.smarthse.util.common.StringUtils;
import com.xxl.job.core.context.XxlJobHelper;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@DubboService
public class LiteArchiveUpdateServiceImpl
implements ILiteArchiveUpdateService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LiteArchiveUpdateServiceImpl.class);
    @Autowired
    private ILiteArchiveService liteArchiveService;
    @Autowired
    private ILiteArchiveFileNameService fileNameService;
    @Autowired
    private ILiteArchiveFileItemService archiveFileItemService;
    @Autowired
    private IReformItemBasicNewService reformItemBasicNewService;
    @Autowired
    private LiteArchiveMapper liteArchiveMapper;
    @Autowired
    private RedissonClient redissonClient;
    @DubboReference
    private INewComplianceCompanyInfoService companyInfoService;
    @DubboReference
    private IBusinessDataUpdateRefreshService businessDataUpdateRefreshService;
    @Autowired
    private DataSourceTransactionManager txManager;
    @Autowired
    protected IdWorker idworker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshArchive(Long cid, String fileNamdIds) {
        RLock lock;
        String lockKey = "LiteArchiveUpdateServiceImpl:refreshArchive:" + cid;
        if (StringUtils.isNotBlank((CharSequence)fileNamdIds)) {
            lockKey = lockKey + fileNamdIds.hashCode();
        }
        if ((lock = this.redissonClient.getLock(lockKey + ":hot")).tryLock()) {
            try {
                this.syncRefreshArchiveV2(cid, fileNamdIds);
                this.reformItemBasicNewService.changeStatusByCidAndGenerationSource(cid, ReformGenerationSourceEnum.ARCHIVES.getValue(), null, null, null);
            }
            catch (Exception e) {
                log.error("\u6863\u6848\u5237\u65b0\u5f02\u5e38\uff0c cid:{}, fileNamdIds:{}", new Object[]{cid, fileNamdIds, e});
            }
            finally {
                lock.unlock();
            }
        } else {
            log.error("\u6863\u6848\u6b63\u5728\u5237\u65b0\u9501\u83b7\u53d6\u5931\u8d25\uff0c cid:{}, fileNamdIds:{}", (Object)cid, (Object)fileNamdIds);
        }
    }

    public void syncRefreshArchiveV2(Long cid, String fileNamdIds) {
        ArrayList<String> yearsList = new ArrayList<String>();
        yearsList.add(String.valueOf(DateUtil.getYear()));
        yearsList.add(String.valueOf(DateUtil.getYear() - 1));
        yearsList.add(String.valueOf(DateUtil.getYear() - 2));
        List archiveTypeList = this.fileNameService.parseArchiveTypeList(fileNamdIds);
        if (CollectionUtils.isEmpty((Collection)archiveTypeList)) {
            return;
        }
        Set complinaceCidSet = this.companyInfoService.getSubmitComplianceCidSet(List.of(cid));
        LiteArchiveRefreshVo liteArchiveRefreshVo = this.liteArchiveService.handerArchiveRefreshPairV2(Arrays.asList(cid), archiveTypeList, yearsList, complinaceCidSet);
        List needAddList = liteArchiveRefreshVo.getNeedAddList();
        List refreshLiteArchives = liteArchiveRefreshVo.getRefreshLiteArchives();
        if (CollectionUtils.isNotEmpty((Collection)needAddList)) {
            DefaultTransactionDefinition def = new DefaultTransactionDefinition();
            def.setPropagationBehavior(3);
            TransactionStatus status = this.txManager.getTransaction((TransactionDefinition)def);
            try {
                this.liteArchiveMapper.insertList2(needAddList);
                this.txManager.commit(status);
            }
            catch (Exception e) {
                log.error("\u6279\u91cf\u5165\u5e93\u6863\u6848\u4e3b\u8868\u6570\u636e\u51fa\u9519\uff1a", (Throwable)e);
                this.txManager.rollback(status);
                throw e;
            }
            this.archiveFileItemService.handRefreshAchiveV2(needAddList, complinaceCidSet, null, null, Boolean.valueOf(false));
        }
        needAddList.clear();
        HashSet archiveTypeSet = new HashSet();
        if (CollectionUtils.isNotEmpty((Collection)refreshLiteArchives)) {
            this.archiveFileItemService.handRefreshAchiveV2(refreshLiteArchives, complinaceCidSet, null, null, Boolean.valueOf(false));
        }
        HashMap<CallSite, String> params = new HashMap<CallSite, String>();
        params.put((CallSite)((Object)(ComplianceCodeEnum.CODE14.getCode() + ":archiveTypeStr")), StringUtils.join(archiveTypeSet, (String)","));
        this.businessDataUpdateRefreshService.addBusinessDataUpdateMsg(cid, params, new ComplianceCodeEnum[]{ComplianceCodeEnum.CODE14});
    }

    public void asyncRefreshArchiveV2(List<Long> cidList, String fileNamdIds) {
        if (CollectionUtils.isEmpty(cidList)) {
            return;
        }
        List archiveTypeList = this.fileNameService.parseArchiveTypeList(fileNamdIds);
        if (CollectionUtils.isEmpty((Collection)archiveTypeList)) {
            return;
        }
        ArrayList<String> yearsList = new ArrayList<String>();
        yearsList.add(String.valueOf(DateUtil.getYear()));
        yearsList.add(String.valueOf(DateUtil.getYear() - 1));
        yearsList.add(String.valueOf(DateUtil.getYear() - 2));
        Set complinaceCidSet = this.companyInfoService.getSubmitComplianceCidSet(cidList);
        LiteArchiveRefreshVo liteArchiveRefreshVo = this.liteArchiveService.handerArchiveRefreshPairV2(cidList, archiveTypeList, yearsList, complinaceCidSet);
        List needAddList = liteArchiveRefreshVo.getNeedAddList();
        List refreshLiteArchives = liteArchiveRefreshVo.getRefreshLiteArchives();
        if (CollectionUtils.isNotEmpty((Collection)needAddList)) {
            DefaultTransactionDefinition def = new DefaultTransactionDefinition();
            def.setPropagationBehavior(3);
            TransactionStatus status = this.txManager.getTransaction((TransactionDefinition)def);
            try {
                this.liteArchiveMapper.insertList2(needAddList);
                this.txManager.commit(status);
            }
            catch (Exception e) {
                log.error("\u6279\u91cf\u5165\u5e93\u6863\u6848\u4e3b\u8868\u6570\u636e\u51fa\u9519\uff1a", (Throwable)e);
                this.txManager.rollback(status);
                throw e;
            }
            XxlJobHelper.log((String)"\u9700\u65b0\u589e\u6863\u6848\u6570\uff1a{}", (Object[])new Object[]{needAddList.size()});
            refreshLiteArchives.addAll(needAddList);
        }
        if (CollectionUtils.isNotEmpty((Collection)refreshLiteArchives)) {
            XxlJobHelper.log((String)"\u9700\u66f4\u65b0\u6863\u6848\u6570\uff1a{}", (Object[])new Object[]{refreshLiteArchives.size()});
            this.archiveFileItemService.handRefreshAchiveV2(refreshLiteArchives, complinaceCidSet, null, null, Boolean.valueOf(true));
        }
    }
}

