/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.litearchive.imp;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.convert.Convert;
import cn.smarthse.common.framework.enums.FilesTypeEnum;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.CommonUtil;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.dao.litearchive.LiteArchiveFileItemMapper;
import cn.smarthse.modules.health.dao.litearchive.LiteArchiveMapper;
import cn.smarthse.modules.health.entity.litearchive.LiteArchive;
import cn.smarthse.modules.health.entity.litearchive.LiteArchiveFileItem;
import cn.smarthse.modules.health.entity.litearchive.LiteArchiveFileName;
import cn.smarthse.modules.health.entity.work.certificate.CertificateStaffDetail;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalCheckSearchVo;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalStatisticsModel;
import cn.smarthse.modules.health.entity.work.reform.ReformItemBasic;
import cn.smarthse.modules.health.entity.work.thirdtime.LiteArchiveTsLink;
import cn.smarthse.modules.health.entity.work.thirdtime.TsProjectSimple;
import cn.smarthse.modules.health.enums.archive.ArchiveViewStateEnum;
import cn.smarthse.modules.health.enums.certificate.ApprovalStatusEnum;
import cn.smarthse.modules.health.enums.reform.ReformGenerationSourceEnum;
import cn.smarthse.modules.health.enums.thirdtime.TsProgressEnum;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceCompanyInfo;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceCompanyInfoService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveFileItemService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveFileNameService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveFilePersonalService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveService;
import cn.smarthse.modules.health.service.litearchive.simple.ILiteArchiveSimpleService;
import cn.smarthse.modules.health.service.work.certificate.ICertificateStaffDetailService;
import cn.smarthse.modules.health.service.work.check.checkV3221.IPhcPhysicalCheckV3221Service;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.service.work.thirdtime.ILiteArchiveTsLinkService;
import cn.smarthse.modules.health.util.LiteArchiveUtils;
import cn.smarthse.modules.health.vo.litearchive.ArchiveTypeStatusVo;
import cn.smarthse.modules.health.vo.litearchive.LiteArchiveFileDetailVo;
import cn.smarthse.modules.health.vo.litearchive.LiteArchiveRefreshVo;
import cn.smarthse.modules.health.vo.litearchive.LiteArchiveVo;
import cn.smarthse.modules.health.vo.litearchive.TsLiteArchiveVo;
import cn.smarthse.modules.health.vo.litearchive.ZjArchiveCountView;
import cn.smarthse.modules.health.vo.work.KeyCountVO;
import cn.smarthse.util.common.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.PageSerializable;
import com.xxl.job.core.context.XxlJobHelper;
import jakarta.annotation.Resource;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import tk.mybatis.mapper.entity.Example;

@DubboService
public class LiteArchiveServiceImpl
extends BaseServiceImpl<LiteArchiveMapper, LiteArchive>
implements ILiteArchiveService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LiteArchiveServiceImpl.class);
    private static final String LITE_ARCHIVE_KEY = "LiteArchiveServiceImplKey";
    @Autowired
    private ILiteArchiveFileNameService fileNameService;
    @Autowired(required=false)
    @Lazy
    private ILiteArchiveFileItemService fileItemService;
    @Autowired(required=false)
    @Lazy
    private ILiteArchiveTsLinkService liteArchiveTsLinkService;
    @Autowired(required=false)
    @Lazy
    private ILiteArchiveService self;
    @Autowired
    private DataSourceTransactionManager txManager;
    @Lazy
    @Autowired(required=false)
    private ILiteArchiveFilePersonalService liteArchiveFilePersonalService;
    @DubboReference
    ISysFileProvideService sysFileProvideService;
    @Resource
    private ICertificateStaffDetailService certificateStaffDetailService;
    @Autowired
    IPhcPhysicalCheckV3221Service phcPhysicalCheckV3221Service;
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    @DubboReference
    private INewComplianceCompanyInfoService complianceCompanyInfoService;
    @Autowired
    private RedisClient redisClient;
    @Autowired(required=false)
    @Lazy
    private ILiteArchiveSimpleService liteArchiveSimpleService;
    @Autowired
    @Lazy
    private ILiteArchiveFileItemService archiveFileItemService;
    @Autowired
    IReformItemBasicService reformItemBasicService;

    public PageInfo<LiteArchive> queryPage(JqGridParam jqGridParam, Long cid, Integer archiveType) {
        Example example = new Example(LiteArchive.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("archiveType", (Object)archiveType).andEqualTo("cid", (Object)cid);
        example.setOrderByClause(" field(title, '2021\u5e74\u4ee5\u524d')  desc ");
        PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows());
        List list = this.getListByExample(example);
        return new PageInfo(list);
    }

    public PageInfo<LiteArchiveVo> queryVoPage(JqGridParam jqGridParam, Long cid, Integer archiveType, boolean isComplianceCompany) {
        PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows());
        List<Object> list = ((LiteArchiveMapper)this.dao).queryVoPage(cid, archiveType);
        if (isComplianceCompany && com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(list)) {
            list = list.stream().filter(f -> !Objects.equals(f.getTitle(), "2023\u5e74\u4ee5\u524d")).collect(Collectors.toList());
        }
        for (LiteArchiveVo vo : list) {
            List fileDetailVos = this.fileItemService.queryDetailList(vo.getId());
            this.handlerFileList(fileDetailVos);
            long count = 0L;
            List finishFileDetail = new ArrayList();
            List noFinishFileDetail = new ArrayList();
            if (isComplianceCompany) {
                count = LiteArchiveUtils.getHgRequiredListVo((List)fileDetailVos, null).size();
                finishFileDetail = LiteArchiveUtils.getHgRequiredListVo((List)fileDetailVos, (Boolean)true);
                noFinishFileDetail = LiteArchiveUtils.getHgRequiredListVo((List)fileDetailVos, (Boolean)false);
            } else {
                count = LiteArchiveUtils.getCommonRequiredListVo((List)fileDetailVos, null).size();
                finishFileDetail = LiteArchiveUtils.getCommonRequiredListVo((List)fileDetailVos, (Boolean)true);
                noFinishFileDetail = LiteArchiveUtils.getCommonRequiredListVo((List)fileDetailVos, (Boolean)false);
            }
            if ((long)finishFileDetail.size() < count) {
                vo.setProgressRate("\u672a\u5b8c\u5584  " + finishFileDetail.size() + "/" + count);
            } else {
                vo.setProgressRate("\u5df2\u5b8c\u5584");
            }
            vo.setProgressRateTips(noFinishFileDetail.stream().map(LiteArchiveFileDetailVo::getFileName).collect(Collectors.toList()));
        }
        return new PageInfo(list);
    }

    @Transactional(readOnly=false)
    public void tempFindRepeatArchive() {
        List<LiteArchiveVo> list = ((LiteArchiveMapper)this.dao).tempFindRepeatArchive();
        for (LiteArchiveVo vo : list) {
            CompanySuperviseModel companyInfoById;
            Boolean isDec;
            List fileDetailVos = this.fileItemService.queryDetailList(vo.getId());
            this.handlerFileList(fileDetailVos);
            if (Objects.equals(vo.getArchiveType(), 2) && Objects.equals(isDec = (companyInfoById = this.companyProvideBySuperviseService.getCompanyInfoById(vo.getCid())).getIsDec(), true)) {
                for (LiteArchiveFileDetailVo liteArchiveFileDetailVo : fileDetailVos) {
                    if (!liteArchiveFileDetailVo.getFileNameId().equals(206L)) continue;
                    liteArchiveFileDetailVo.setNeedCollect(Boolean.valueOf(false));
                }
            }
            fileDetailVos = fileDetailVos.stream().filter(item -> !Objects.equals(304L, item.getFileNameId())).collect(Collectors.toList());
            long count = fileDetailVos.stream().filter(f -> f.getNeedCollect() != null && f.getNeedCollect() != false).count();
            List finishFileDetail = fileDetailVos.stream().filter(f -> f.getNeedCollect() != null && f.getNeedCollect() != false && (Objects.equals(f.getNeedUpload(), 1) && CollUtil.isNotEmpty((Collection)f.getFileList()) || !Objects.equals(f.getNeedUpload(), 1) && Objects.equals(f.getDataState(), 1))).collect(Collectors.toList());
            List noFinishFileDetail = fileDetailVos.stream().filter(f -> f.getNeedCollect() != null && f.getNeedCollect() != false && (Objects.equals(f.getNeedUpload(), 1) && CollUtil.isEmpty((Collection)f.getFileList()) || !Objects.equals(f.getNeedUpload(), 1) && !Objects.equals(f.getDataState(), 1))).collect(Collectors.toList());
            vo.setCompleteNum(Integer.valueOf(finishFileDetail.size()));
        }
        Map<String, List<LiteArchiveVo>> repeatArchiveMap = list.stream().collect(Collectors.groupingBy(k -> "" + k.getCid() + k.getArchiveType() + k.getTitle()));
        Set<String> repeatArchiveMapSet = repeatArchiveMap.keySet();
        ArrayList<Long> delArchiveIdList = new ArrayList<Long>();
        for (String key : repeatArchiveMapSet) {
            List<LiteArchiveVo> liteArchiveVos = repeatArchiveMap.get(key);
            List sortList = liteArchiveVos.stream().sorted(Comparator.comparing(LiteArchiveVo::getCompleteNum).reversed()).collect(Collectors.toList());
            for (int i = 1; i < sortList.size(); ++i) {
                delArchiveIdList.add(((LiteArchiveVo)sortList.get(i)).getId());
            }
        }
        Example e = new Example(LiteArchive.class);
        e.createCriteria().andIn("id", delArchiveIdList);
        LiteArchive result = new LiteArchive();
        result.setIsValid(Boolean.valueOf(false));
        result.setUpdateDate(new Date());
        result.setUpdateBy(Long.valueOf(7700L));
        ((LiteArchiveMapper)this.dao).updateByExample(result, e);
        log.error("\u9700\u8981\u5220\u9664\u7684\u6863\u6848id: {}", (Object)StringUtils.join(delArchiveIdList, (String)","));
    }

    public Long checkCertStaffValidDataByYear(String title, Long cid) {
        CertificateStaffDetail info = new CertificateStaffDetail();
        int checkYear = StringUtils.isNumber((String)title) ? Integer.parseInt(title) : 2022;
        Date beginTime = DateUtils.getYearFirstTime((int)checkYear);
        Date endTime = DateUtils.getYearLastTime((int)checkYear);
        JqGridParam param = new JqGridParam();
        param.setRows(10000);
        param.setPage(1);
        info.setStatus(ApprovalStatusEnum.PASSED.getValue());
        info.setCid(cid);
        PageInfo passCert = this.certificateStaffDetailService.getLitePageDataByParam(info, param, null, null);
        List passCertList = Optional.ofNullable(passCert).map(PageSerializable::getList).orElse(Collections.emptyList());
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(passCertList)) {
            passCertList = passCertList.stream().filter(item -> this.validityCert((CertificateStaffDetail)item, checkYear)).collect(Collectors.toList());
        }
        info.setStatus(ApprovalStatusEnum.NONEEDAPPROVAL.getValue());
        PageInfo noNeedApprovalCert = this.certificateStaffDetailService.getLitePageDataByParam(info, param, null, null);
        List noNeedApprovalCertList = Optional.ofNullable(noNeedApprovalCert).map(PageSerializable::getList).orElse(Collections.emptyList());
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(noNeedApprovalCertList)) {
            noNeedApprovalCertList = noNeedApprovalCertList.stream().filter(item -> this.validityCert((CertificateStaffDetail)item, checkYear)).collect(Collectors.toList());
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(passCertList) || com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(noNeedApprovalCertList)) {
            return com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(passCertList) ? ((CertificateStaffDetail)passCertList.get(0)).getId() : ((CertificateStaffDetail)noNeedApprovalCertList.get(0)).getId();
        }
        return null;
    }

    private boolean validityCert(CertificateStaffDetail detail, int checkYear) {
        Date certCreateDate = detail.getCertCreateDate();
        Date validityDate = detail.getValidityDate();
        Date now = new Date();
        Date endTime = DateUtils.getYearLastTime((int)checkYear);
        if (checkYear == 2022) {
            if (certCreateDate != null) {
                return endTime.getTime() > certCreateDate.getTime();
            }
        } else if (validityDate != null) {
            Date certValidityTime = DateUtils.parseDate((Object)"2023-09-30");
            return validityDate.getTime() > now.getTime() || checkYear == 2023 && validityDate.getTime() > certValidityTime.getTime();
        }
        return false;
    }

    private void handlerFileList(List<LiteArchiveFileDetailVo> fileDetailVos) {
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(fileDetailVos)) {
            HashSet fileIdSet = new HashSet();
            fileDetailVos.forEach(f -> {
                if (StringUtils.isNotBlank((CharSequence)f.getFileIds())) {
                    fileIdSet.addAll(CommonUtil.str2LongList((String)f.getFileIds(), (String)","));
                }
            });
            Collection fileModels = null;
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(fileIdSet)) {
                fileModels = this.sysFileProvideService.getListByIds(StringUtils.join(fileIdSet, (String)","));
            }
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(fileModels)) {
                Map<Long, SysFileModel> sysFileModelMap = fileModels.stream().collect(Collectors.toMap(SysFileModel::getId, v -> v));
                fileDetailVos.forEach(f -> {
                    if (StringUtils.isNotBlank((CharSequence)f.getFileIds())) {
                        ArrayList<SysFileModel> afileMode = new ArrayList<SysFileModel>();
                        List fileidList = CommonUtil.str2LongList((String)f.getFileIds(), (String)",");
                        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)fileidList)) {
                            for (Long fileId : fileidList) {
                                if (!sysFileModelMap.containsKey(fileId)) continue;
                                afileMode.add((SysFileModel)sysFileModelMap.get(fileId));
                            }
                        }
                        f.setFileList(afileMode);
                    }
                });
            }
        }
    }

    public PageInfo<TsLiteArchiveVo> pageTsLiteArchiveVo(JqGridParam jqGridParam, String kw, Long cid) {
        Example example = new Example(LiteArchive.class);
        Example.Criteria criteria = example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("archiveType", (Object)1).andEqualTo("cid", (Object)cid);
        if (StringUtils.isNotBlank((CharSequence)kw)) {
            criteria.andLike("title", "%" + kw + "%");
        }
        PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows());
        List listByExample = this.getListByExample(example);
        PageInfo liteArchivePageInfo = new PageInfo(listByExample);
        PageInfo pageVo = new PageInfo();
        BeanUtils.copyProperties((Object)liteArchivePageInfo, (Object)pageVo);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)liteArchivePageInfo.getList())) {
            ArrayList<TsLiteArchiveVo> voList = new ArrayList<TsLiteArchiveVo>();
            for (LiteArchive liteArchive : liteArchivePageInfo.getList()) {
                TsLiteArchiveVo vo = new TsLiteArchiveVo();
                BeanUtils.copyProperties((Object)liteArchive, (Object)vo);
                LiteArchiveTsLink archiveTsLink = this.liteArchiveTsLinkService.getTsLinkByArchiveId(liteArchive.getId());
                voList.add(vo);
                List fileDetailVos = this.fileItemService.queryDetailList(liteArchive.getId());
                long count = fileDetailVos.stream().filter(f -> f.getNeedCollect() != null && f.getNeedCollect() != false).count();
                List noFinishFileDetail = fileDetailVos.stream().filter(f -> {
                    boolean b = f.getNeedCollect() != null && f.getNeedCollect() != false && StringUtils.isBlank((CharSequence)f.getFileIds());
                    return b;
                }).collect(Collectors.toList());
                if (noFinishFileDetail.size() > 0) {
                    vo.setProgressRate("\u672a\u5b8c\u5584  " + (count - (long)noFinishFileDetail.size()) + "/" + count);
                } else {
                    vo.setProgressRate("\u5df2\u5b8c\u5584");
                }
                vo.setProgressRateTips(noFinishFileDetail.stream().map(LiteArchiveFileDetailVo::getFileName).collect(Collectors.toList()));
            }
            pageVo.setList(voList);
        }
        return pageVo;
    }

    @Transactional(readOnly=false)
    public void newUpdateStatus(Long archiveId, boolean isComplianceCompany) {
        LiteArchive liteArchive = new LiteArchive();
        liteArchive.setId(archiveId);
        LiteArchive dbArchive = (LiteArchive)this.getById(archiveId);
        List items = this.fileItemService.getByArchiveId(archiveId);
        List requiredList = LiteArchiveUtils.getCommonRequiredList((List)items, null);
        if (CollectionUtil.isEmpty((Collection)requiredList)) {
            liteArchive.setStatus(Integer.valueOf(3));
        } else {
            List finishList = LiteArchiveUtils.getCommonRequiredList((List)items, (Boolean)true);
            if (CollectionUtil.isEmpty((Collection)finishList)) {
                liteArchive.setStatus(Integer.valueOf(1));
            } else if (finishList.size() >= requiredList.size()) {
                liteArchive.setStatus(Integer.valueOf(3));
            } else {
                liteArchive.setStatus(Integer.valueOf(2));
            }
        }
        if (isComplianceCompany) {
            List requiredList2 = LiteArchiveUtils.getHgRequiredList((List)items, null);
            if (CollectionUtil.isEmpty((Collection)requiredList2)) {
                liteArchive.setHgStatus(Integer.valueOf(3));
            } else {
                List finishList2 = LiteArchiveUtils.getHgRequiredList((List)items, (Boolean)true);
                if (CollectionUtil.isEmpty((Collection)finishList2)) {
                    liteArchive.setHgStatus(Integer.valueOf(1));
                } else if (finishList2.size() >= requiredList2.size()) {
                    liteArchive.setHgStatus(Integer.valueOf(3));
                } else {
                    liteArchive.setHgStatus(Integer.valueOf(2));
                }
            }
        }
        liteArchive.setArchiveUpdateTime(new Date());
        liteArchive.setProcStatus(Integer.valueOf(0));
        liteArchive.setUpdateDate(new Date());
        if (dbArchive != null && dbArchive.getUpdateVersion() != null) {
            liteArchive.setUpdateVersion(Integer.valueOf(dbArchive.getUpdateVersion() + 1));
        } else {
            liteArchive.setUpdateVersion(Integer.valueOf(1));
        }
        this.update(liteArchive);
    }

    public void mutilArchiveUpdateStatus(List<LiteArchive> archives, Set<Long> complianceCids) {
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(archives)) {
            return;
        }
        List archiveIds = archives.stream().map(LiteArchive::getId).distinct().collect(Collectors.toList());
        List dbFileItemList = this.fileItemService.selectCompletedItemByArchiveId(archiveIds);
        HashMap<Long, List<LiteArchiveFileItem>> archiveIdFileItemMap = new HashMap<Long, List<LiteArchiveFileItem>>();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)dbFileItemList)) {
            Map<Long, List<LiteArchiveFileItem>> archiveIdFileItemMap2 = dbFileItemList.stream().collect(Collectors.groupingBy(LiteArchiveFileItem::getLiteArchiveId));
            archiveIdFileItemMap.putAll(archiveIdFileItemMap2);
        }
        for (LiteArchive liteArchive : archives) {
            Long archiveId = liteArchive.getId();
            Long cid = liteArchive.getCid();
            List items = (List)archiveIdFileItemMap.get(archiveId);
            List requiredList = LiteArchiveUtils.getCommonRequiredList((List)items, null);
            if (CollectionUtil.isEmpty((Collection)requiredList)) {
                liteArchive.setStatus(Integer.valueOf(3));
            } else {
                List finishList = LiteArchiveUtils.getCommonRequiredList((List)items, (Boolean)true);
                if (CollectionUtil.isEmpty((Collection)finishList)) {
                    liteArchive.setStatus(Integer.valueOf(1));
                } else if (finishList.size() >= requiredList.size()) {
                    liteArchive.setStatus(Integer.valueOf(3));
                } else {
                    liteArchive.setStatus(Integer.valueOf(2));
                }
            }
            if (!complianceCids.contains(cid)) continue;
            List requiredList2 = LiteArchiveUtils.getHgRequiredList((List)items, null);
            if (CollectionUtil.isEmpty((Collection)requiredList2)) {
                liteArchive.setHgStatus(Integer.valueOf(3));
                continue;
            }
            List finishList2 = LiteArchiveUtils.getHgRequiredList((List)items, (Boolean)true);
            if (CollectionUtil.isEmpty((Collection)finishList2)) {
                liteArchive.setHgStatus(Integer.valueOf(1));
                continue;
            }
            if (finishList2.size() >= requiredList2.size()) {
                liteArchive.setHgStatus(Integer.valueOf(3));
                continue;
            }
            liteArchive.setHgStatus(Integer.valueOf(2));
        }
        this.self.domutilArchiveUpdateStatus(archives);
    }

    @Transactional(readOnly=false)
    public void domutilArchiveUpdateStatus(List<LiteArchive> archives) {
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(archives)) {
            return;
        }
        List addList = archives.stream().filter(f -> f.getId() == null).collect(Collectors.toList());
        List<LiteArchive> updateList = archives.stream().filter(f -> f.getId() != null).collect(Collectors.toList());
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(addList)) {
            ((LiteArchiveMapper)this.dao).insertList2(addList);
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(updateList)) {
            ((LiteArchiveMapper)this.dao).batchUpdateLiteArchive(updateList);
        }
    }

    @Transactional(readOnly=false)
    public void updateStatus(Long id) {
        CompanySuperviseModel companyInfoById;
        LiteArchive liteArchive = (LiteArchive)this.getById(id);
        if (liteArchive == null) {
            return;
        }
        Integer archiveType = liteArchive.getArchiveType();
        if (archiveType == null) {
            return;
        }
        List fileNames = this.fileNameService.getByArchiveType(archiveType);
        if (archiveType == 2 && (companyInfoById = this.companyProvideBySuperviseService.getCompanyInfoById(liteArchive.getCid())) != null && Objects.equals(companyInfoById.getIsDec(), true)) {
            for (Object liteArchiveFileDetailVo : fileNames) {
                if (!liteArchiveFileDetailVo.getId().equals(206L)) continue;
                liteArchiveFileDetailVo.setNeedCollect(Boolean.valueOf(false));
            }
        }
        if (archiveType == 5) {
            PhcPhysicalCheckSearchVo vo = new PhcPhysicalCheckSearchVo();
            vo.setCid(liteArchive.getCid());
            vo.setYear(Integer.valueOf(0));
            PhcPhysicalStatisticsModel model = this.phcPhysicalCheckV3221Service.getStatisticsModel(vo);
            if (model.getNumberOfYszyb() > 0) {
                for (LiteArchiveFileName liteArchiveFileDetailVo : fileNames) {
                    liteArchiveFileDetailVo.setNeedCollect(Boolean.valueOf(false));
                    if (liteArchiveFileDetailVo.getId().equals(502L) || liteArchiveFileDetailVo.getId().equals(504L)) {
                        liteArchiveFileDetailVo.setNeedCollect(Boolean.valueOf(true));
                    }
                    if (model.getNumberOfYszyb() <= 0 || !liteArchiveFileDetailVo.getId().equals(505L)) continue;
                    liteArchiveFileDetailVo.setNeedCollect(Boolean.valueOf(true));
                }
            }
        }
        fileNames = fileNames.stream().filter(item -> !Objects.equals(304L, item.getId())).collect(Collectors.toList());
        ArrayList<Long> needCollectIds = new ArrayList<Long>(8);
        for (LiteArchiveFileName fileName : fileNames) {
            if (!Boolean.TRUE.equals(fileName.getNeedCollect())) continue;
            needCollectIds.add(fileName.getId());
        }
        if (needCollectIds.isEmpty()) {
            liteArchive.setStatus(Integer.valueOf(3));
        } else {
            List items = this.fileItemService.getByArchiveId(id);
            if (archiveType == 3) {
                items = items.stream().filter(i -> !Objects.equals(i.getFileNameId(), 302L) || !Objects.equals(i.getDataState(), 0)).collect(Collectors.toList());
            }
            int count = 0;
            block3: for (Long needCollectId : needCollectIds) {
                for (LiteArchiveFileItem item2 : items) {
                    List fileIdsList = CommonUtil.str2LongList((String)item2.getFileIds());
                    if (!item2.getFileNameId().equals(needCollectId) || !CollectionUtils.isNotEmpty((Collection)fileIdsList) && !Objects.equals(item2.getDataState(), 1)) continue;
                    ++count;
                    continue block3;
                }
            }
            if (count == 0) {
                liteArchive.setStatus(Integer.valueOf(1));
            } else if (count >= needCollectIds.size()) {
                liteArchive.setStatus(Integer.valueOf(3));
            } else {
                liteArchive.setStatus(Integer.valueOf(2));
            }
        }
        liteArchive.setArchiveUpdateTime(new Date());
        liteArchive.setProcStatus(Integer.valueOf(0));
        liteArchive.setUpdateDate(new Date());
        this.update(liteArchive);
    }

    public List<ArchiveTypeStatusVo> queryArchiveTypeStatus(Long cid) {
        return ((LiteArchiveMapper)this.dao).queryArchiveTypeStatus(cid);
    }

    @Transactional(readOnly=false)
    public void isExistThisYearArchiveByCidAndType(Long cid, Integer archiveType, Long loginId) {
    }

    public boolean isExistArchiveByCidAndTypeAndYear(Long cid, Integer archiveType, String year) {
        Example example = new Example(LiteArchive.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("archiveType", (Object)archiveType).andEqualTo("cid", (Object)cid).andEqualTo("title", (Object)year);
        int count = this.getCountByExample(example);
        return count > 0;
    }

    public List<KeyCountVO> isExistArchiveByCidAndTypeAndYearBatch(List<LiteArchive> liteArchiveList, Long cid) {
        return (List)this.redisClient.get(LITE_ARCHIVE_KEY, String.valueOf(cid), -301L, () -> ((LiteArchiveMapper)this.dao).countArchiveByCidAndTypeAndYearBatch(liteArchiveList));
    }

    public LiteArchiveRefreshVo handerArchiveRefreshPair(List<Long> cidList, List<Integer> archiveTypeList, List<String> years) {
        ArrayList<LiteArchive> needAddList = new ArrayList<LiteArchive>();
        ArrayList<LiteArchive> refreshLiteArchives = new ArrayList<LiteArchive>();
        List<LiteArchive> liteArchives = this.listLiteArchiveByCids(cidList, archiveTypeList, years);
        List complianceCids = this.complianceCompanyInfoService.getComplianceCids(cidList, null);
        Set<Object> complinaceCidSet = new HashSet();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)complianceCids)) {
            complinaceCidSet = complianceCids.stream().map(c -> c.getCid()).collect(Collectors.toSet());
        }
        Map<Object, Object> titleTypeMap = new HashMap();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(liteArchives)) {
            titleTypeMap = liteArchives.stream().collect(Collectors.toMap(k -> k.getCid() + k.getTitle() + k.getArchiveType(), v -> v, (v1, v2) -> v1));
        }
        for (Long cid : cidList) {
            for (Integer archiveType : archiveTypeList) {
                for (String title : years) {
                    if (!complinaceCidSet.contains(cid) && Objects.equals(title, String.valueOf(DateUtil.getYear() - 2))) continue;
                    String mapKey = cid + title + archiveType;
                    if (titleTypeMap.containsKey(mapKey)) {
                        refreshLiteArchives.add((LiteArchive)titleTypeMap.get(mapKey));
                        continue;
                    }
                    LiteArchive la = new LiteArchive();
                    la.setId(Long.valueOf(this.idworker.nextId()));
                    la.setCid(cid);
                    la.setArchiveType(archiveType);
                    la.setTitle(title);
                    la.setIsValid(Boolean.valueOf(true));
                    la.setCreateDate(new Date());
                    la.setCreateBy(Long.valueOf(7800L));
                    la.setArchiveUpdateTime(new Date());
                    la.setStatus(Integer.valueOf(0));
                    needAddList.add(la);
                }
            }
        }
        return new LiteArchiveRefreshVo(needAddList, refreshLiteArchives);
    }

    public LiteArchiveRefreshVo handerArchiveRefreshPairV2(List<Long> cidList, List<Integer> archiveTypeList, List<String> years, Set<Long> complinaceCidSet) {
        ArrayList<LiteArchive> needAddList = new ArrayList<LiteArchive>();
        ArrayList<LiteArchive> refreshLiteArchives = new ArrayList<LiteArchive>();
        List<LiteArchive> liteArchives = this.listLiteArchiveByCids(cidList, archiveTypeList, years);
        Map<Object, Object> titleTypeMap = new HashMap();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(liteArchives)) {
            titleTypeMap = liteArchives.stream().collect(Collectors.toMap(k -> k.getCid() + k.getTitle() + k.getArchiveType(), v -> v, (v1, v2) -> v1));
        }
        for (Long cid : cidList) {
            for (Integer archiveType : archiveTypeList) {
                for (String title : years) {
                    if (!complinaceCidSet.contains(cid) && Objects.equals(title, String.valueOf(DateUtil.getYear() - 2))) continue;
                    String mapKey = cid + title + archiveType;
                    if (titleTypeMap.containsKey(mapKey)) {
                        refreshLiteArchives.add((LiteArchive)titleTypeMap.get(mapKey));
                        continue;
                    }
                    LiteArchive la = new LiteArchive();
                    la.setId(Long.valueOf(this.idworker.nextId()));
                    la.setCid(cid);
                    la.setArchiveType(archiveType);
                    la.setTitle(title);
                    la.setIsValid(Boolean.valueOf(true));
                    la.setCreateDate(new Date());
                    la.setCreateBy(Long.valueOf(7800L));
                    la.setArchiveUpdateTime(new Date());
                    la.setStatus(Integer.valueOf(0));
                    needAddList.add(la);
                }
            }
        }
        return new LiteArchiveRefreshVo(needAddList, refreshLiteArchives);
    }

    public void batchRefreshAchiveByNameIds(List<Long> cidList, String fileNamdIds) {
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(cidList)) {
            return;
        }
        List archiveTypeList = this.fileNameService.parseArchiveTypeList(fileNamdIds);
        if (CollectionUtils.isEmpty((Collection)archiveTypeList)) {
            return;
        }
        ArrayList<String> yearsList = new ArrayList<String>();
        yearsList.add(String.valueOf(DateUtil.getYear()));
        yearsList.add(String.valueOf(DateUtil.getYear() - 1));
        yearsList.add(String.valueOf(DateUtil.getYear() - 2));
        LiteArchiveRefreshVo liteArchiveRefreshVo = this.handerArchiveRefreshPair(cidList, archiveTypeList, yearsList);
        List refreshLiteArchives = liteArchiveRefreshVo.getRefreshLiteArchives();
        List needAddList = liteArchiveRefreshVo.getNeedAddList();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)needAddList)) {
            DefaultTransactionDefinition def = new DefaultTransactionDefinition();
            def.setPropagationBehavior(3);
            TransactionStatus status = this.txManager.getTransaction((TransactionDefinition)def);
            try {
                ((LiteArchiveMapper)this.dao).insertList2(needAddList);
                this.txManager.commit(status);
            }
            catch (Exception e) {
                log.error("\u6279\u91cf\u5165\u5e93\u6863\u6848\u4e3b\u8868\u6570\u636e\u51fa\u9519\uff1a", (Throwable)e);
                this.txManager.rollback(status);
                throw e;
            }
            XxlJobHelper.log((String)"\u9700\u65b0\u589e\u6863\u6848\u6570\uff1a{}", (Object[])new Object[]{needAddList.size()});
            refreshLiteArchives.addAll(needAddList);
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)refreshLiteArchives)) {
            XxlJobHelper.log((String)"\u9700\u66f4\u65b0\u6863\u6848\u6570\uff1a{}", (Object[])new Object[]{refreshLiteArchives.size()});
            for (LiteArchive liteArchive : refreshLiteArchives) {
                this.archiveFileItemService.autoCreateFileItems(liteArchive, fileNamdIds);
            }
        }
    }

    private String getStateStr(Integer state) {
        if (state == null) {
            return "\u672a\u4e0a\u4f20";
        }
        if (state == 1) {
            return "\u672a\u4e0a\u4f20";
        }
        if (state == 2) {
            return "\u672a\u5b8c\u5584";
        }
        if (state == 3) {
            return "\u5df2\u5b8c\u5584";
        }
        if (state == 4) {
            return "\u5408\u7406\u7f3a\u9879";
        }
        return "";
    }

    public Set<Long> getZjArchiveCountViewByCid(List<Long> cidList) {
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(cidList)) {
            return Collections.emptySet();
        }
        List<Integer> archiveTypeList = Arrays.asList(1, 2, 3, 4);
        List<Long> list234 = ((LiteArchiveMapper)this.dao).get234Completed(cidList, archiveTypeList, DateUtils.getYear());
        List<ReformItemBasic> reformItemBasicList = ((LiteArchiveMapper)this.dao).getReformCompletedList(cidList);
        List reformCidList = reformItemBasicList.parallelStream().filter(Objects::nonNull).map(ReformItemBasic::getCid).collect(Collectors.toList());
        List<Long> personalList = ((LiteArchiveMapper)this.dao).getPersonalCompleted(cidList);
        List<Long> List5 = ((LiteArchiveMapper)this.dao).getDoc5Completed(cidList);
        Set<Long> collect = cidList.parallelStream().filter(item -> {
            if (personalList.contains(item)) {
                return true;
            }
            if (list234.contains(item)) {
                return true;
            }
            if (List5.contains(item)) {
                return true;
            }
            return reformCidList.contains(item);
        }).collect(Collectors.toSet());
        return collect;
    }

    @Transactional
    public Map<Integer, ZjArchiveCountView> getArchiveData(Long cid) {
        int currentYear = LocalDate.now().getYear();
        ZjArchiveCountView prevArchive = this.getLastZjArchiveCountViewByCid(cid);
        ZjArchiveCountView currArchive = this.getZjArchiveCountViewByCid(cid);
        HashMap<Integer, ZjArchiveCountView> archiveMap = new HashMap<Integer, ZjArchiveCountView>(2);
        archiveMap.put(currentYear - 1, prevArchive);
        archiveMap.put(currentYear, currArchive);
        return archiveMap;
    }

    @Transactional
    public ZjArchiveCountView getCurrentYearArchiveData(Long cid) {
        return this.getZjArchiveCountViewByCid(cid);
    }

    @Transactional(readOnly=false)
    public Map<Integer, Integer> getArchiveStatus(Long cid, String year) {
        Example example = new Example(LiteArchive.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("cid", (Object)cid).andEqualTo("title", (Object)year);
        List list = this.getListByExample(example);
        HashMap<Integer, Integer> statusMap = new HashMap<Integer, Integer>();
        statusMap.put(1, 1);
        statusMap.put(2, 1);
        statusMap.put(3, 1);
        statusMap.put(4, 1);
        statusMap.put(5, 1);
        statusMap.put(6, 1);
        for (LiteArchive archive : list) {
            statusMap.put(archive.getArchiveType(), archive.getStatus());
        }
        Example example1 = new Example(LiteArchive.class);
        example1.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("archiveType", (Object)1).andEqualTo("cid", (Object)cid);
        List<LiteArchive> thirdList = this.getListByExample(example1);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(thirdList)) {
            thirdList.forEach(t -> {
                if (t.getStatus() == null) {
                    t.setStatus(Integer.valueOf(1));
                }
            });
            boolean allNotUpdate = thirdList.stream().allMatch(t -> t.getStatus() == 1);
            if (allNotUpdate) {
                statusMap.put(1, 1);
            } else {
                boolean allUpdateed = thirdList.stream().allMatch(t -> t.getStatus() == 3);
                if (allUpdateed) {
                    statusMap.put(1, 3);
                } else {
                    statusMap.put(1, 2);
                }
            }
        }
        ZjArchiveCountView view = new ZjArchiveCountView();
        this.getDoc5FileIdsStatus(view, cid, false);
        statusMap.put(5, view.getPhysicalState());
        int personalArchiveStatus = this.liteArchiveFilePersonalService.getArchiveStatusByCid(cid);
        statusMap.put(6, personalArchiveStatus);
        return statusMap;
    }

    public ZjArchiveCountView getLastZjArchiveCountViewByCid(Long cid) {
        int currentYear = LocalDate.now().getYear();
        ZjArchiveCountView prevView = new ZjArchiveCountView();
        Example example = new Example(LiteArchive.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("title", (Object)(currentYear - 1)).andEqualTo("isValid", (Object)Boolean.TRUE);
        List prevArchiveList = this.getListByExample(example);
        if (CollUtil.isNotEmpty(prevArchiveList)) {
            for (LiteArchive prevArchive : prevArchiveList) {
                FilesTypeEnum type;
                if (prevArchive == null || prevArchive.getArchiveType() == null || (type = FilesTypeEnum.getEnum((Byte)Convert.toByte((Object)prevArchive.getArchiveType()))) == null) continue;
                Integer status = prevArchive.getStatus() == null ? 1 : prevArchive.getStatus();
                switch (type) {
                    case sts: {
                        break;
                    }
                    case zwgl: {
                        prevView.setHseManageState(status);
                        prevView.setHseManageStateStr(this.getStateStr(status));
                        break;
                    }
                    case xcpx: {
                        prevView.setTrainState(status);
                        prevView.setTrainStateStr(this.getStateStr(status));
                        break;
                    }
                    case harmFactorCheck: {
                        prevView.setCheckState(status);
                        prevView.setCheckStateStr(this.getStateStr(status));
                        break;
                    }
                    case companyPhc: {
                        break;
                    }
                    case phc: {
                        prevView.setStaffState(status);
                        prevView.setStaffStateStr(this.getStateStr(prevArchive.getStatus()));
                        break;
                    }
                }
            }
        }
        this.thirdArchiveViewStatusProcess(cid, currentYear - 1, prevView);
        int personalStatus = this.liteArchiveFilePersonalService.getArchiveStatusByCid(cid);
        prevView.setStaffState(Integer.valueOf(personalStatus));
        prevView.setStaffStateStr(this.getStateStr(personalStatus));
        this.getDoc5FileIdsStatus(prevView, cid, Boolean.FALSE);
        return prevView;
    }

    @Transactional(readOnly=false)
    public ZjArchiveCountView getZjArchiveCountViewByCid(Long cid) {
        int currentYear = LocalDate.now().getYear();
        ZjArchiveCountView currView = new ZjArchiveCountView();
        Example example = new Example(LiteArchive.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("title", (Object)currentYear).andEqualTo("isValid", (Object)Boolean.TRUE);
        List currArchiveList = this.getListByExample(example);
        if (CollUtil.isNotEmpty(currArchiveList)) {
            for (LiteArchive currArchive : currArchiveList) {
                FilesTypeEnum type;
                if (currArchive == null || currArchive.getArchiveType() == null || (type = FilesTypeEnum.getEnum((Byte)Convert.toByte((Object)currArchive.getArchiveType()))) == null) continue;
                Integer status = currArchive.getStatus() == null ? 1 : currArchive.getStatus();
                switch (type) {
                    case sts: {
                        break;
                    }
                    case zwgl: {
                        currView.setHseManageState(status);
                        currView.setHseManageStateStr(this.getStateStr(status));
                        break;
                    }
                    case xcpx: {
                        currView.setTrainState(status);
                        currView.setTrainStateStr(this.getStateStr(status));
                        break;
                    }
                    case harmFactorCheck: {
                        currView.setCheckState(status);
                        currView.setCheckStateStr(this.getStateStr(status));
                        break;
                    }
                    case companyPhc: {
                        break;
                    }
                    case phc: {
                        break;
                    }
                }
            }
        }
        this.thirdArchiveViewStatusProcess(cid, currentYear, currView);
        int personalArchiveStatus = this.liteArchiveFilePersonalService.getArchiveStatusByCid(cid);
        currView.setStaffState(Integer.valueOf(personalArchiveStatus));
        currView.setStaffStateStr(this.getStateStr(personalArchiveStatus));
        this.getDoc5FileIdsStatus(currView, cid, false);
        return currView;
    }

    private void thirdArchiveViewStatusProcess(Long cid, int year, ZjArchiveCountView view) {
        ArchiveViewStateEnum tsArchiveState;
        List tsArchiveList = this.liteArchiveSimpleService.tsLiteArchiveVo(null, cid);
        if (CollUtil.isEmpty((Collection)tsArchiveList)) {
            tsArchiveState = ArchiveViewStateEnum.MISSING_ITEM;
        } else {
            boolean allNotNeed;
            boolean allComplete;
            LocalDate yearEnd = LocalDate.of(year, 12, 31);
            List tsYearArchiveList = tsArchiveList.stream().filter(t -> !t.getProjectTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().isAfter(yearEnd)).collect(Collectors.toList());
            List requiredList = tsYearArchiveList.stream().filter(t -> Boolean.TRUE.equals(t.getHasRequired())).collect(Collectors.toList());
            tsArchiveState = CollUtil.isNotEmpty(requiredList) ? ((allComplete = requiredList.stream().allMatch(t -> Boolean.TRUE.equals(t.getComplete()))) ? ArchiveViewStateEnum.IS_COMPLETE : ArchiveViewStateEnum.NO_COMPLETE) : ((allNotNeed = tsYearArchiveList.stream().allMatch(t -> TsProgressEnum.TS_NO_NEED.getValue().equals(t.getProgressRate()))) ? ArchiveViewStateEnum.MISSING_ITEM : ArchiveViewStateEnum.IS_COMPLETE);
        }
        view.setThirdState(Convert.toInt((Object)tsArchiveState.getKey()));
        view.setThirdStateStr(tsArchiveState.getValue());
    }

    @Transactional(readOnly=false)
    public LiteArchive getFirstArchive5ByCid(Long companyId, Long loginStaffId) {
        Example example1 = new Example(LiteArchive.class);
        example1.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("archiveType", (Object)5).andEqualTo("cid", (Object)companyId);
        example1.orderBy("createDate").desc();
        List list = this.getListByExample(example1);
        if (list != null && list.size() > 0) {
            return (LiteArchive)list.get(0);
        }
        LiteArchive liteArchive = new LiteArchive();
        liteArchive.setArchiveType(Integer.valueOf(5));
        liteArchive.setCid(companyId);
        liteArchive.setTitle(DateUtils.getYear());
        liteArchive.setStatus(Integer.valueOf(1));
        this.add(liteArchive, loginStaffId, companyId);
        return liteArchive;
    }

    public List<LiteArchive> getAllArchive(Integer archiveType) {
        Example example1 = new Example(LiteArchive.class);
        example1.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("archiveType", (Object)archiveType);
        example1.orderBy("createDate").desc();
        List<LiteArchive> list = this.getListByExample(example1);
        return list;
    }

    public List<LiteArchive> listLiteArchiveByCid(Long cid, Integer archiveType, String ... years) {
        Example example1 = new Example(LiteArchive.class);
        Example.Criteria criteria = example1.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("cid", (Object)cid);
        if (archiveType != null) {
            criteria.andEqualTo("archiveType", (Object)archiveType);
        }
        if (ArrayUtils.isNotEmpty((Object[])years)) {
            if (years.length > 1) {
                criteria.andIn("title", Arrays.asList(years));
            } else {
                criteria.andEqualTo("title", (Object)years[0]);
            }
        }
        List<LiteArchive> list = this.getListByExample(example1);
        return list;
    }

    public List<LiteArchive> listLiteArchiveByCids(List<Long> cids, List<Integer> archiveTypes, List<String> years) {
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(cids)) {
            return null;
        }
        Set cidSet = cids.stream().filter(c -> c != null).collect(Collectors.toSet());
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(cidSet)) {
            return null;
        }
        Example example1 = new Example(LiteArchive.class);
        Example.Criteria criteria = example1.createCriteria().andEqualTo("isValid", (Object)true).andIn("cid", cidSet);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(archiveTypes)) {
            if (archiveTypes.size() == 1) {
                criteria.andEqualTo("archiveType", (Object)archiveTypes.get(0));
            } else {
                criteria.andIn("archiveType", archiveTypes);
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(years)) {
            if (years.size() > 1) {
                criteria.andIn("title", years);
            } else {
                criteria.andEqualTo("title", (Object)years.get(0));
            }
        }
        List<LiteArchive> list = this.getListByExample(example1);
        return list;
    }

    public List<LiteArchive> getAllArchiveByYear(Integer year) {
        Example example1 = new Example(LiteArchive.class);
        example1.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("title", (Object)year);
        List<LiteArchive> list = this.getListByExample(example1);
        return list;
    }

    @Transactional(readOnly=false)
    public void saveBatch(List<LiteArchive> liteArchiveList) {
        ((LiteArchiveMapper)this.dao).saveBatch(liteArchiveList);
    }

    @Transactional(readOnly=false)
    public Map<String, Integer> getDoc5FileIdsStatus(ZjArchiveCountView view, Long cid, Boolean isCompliance) {
        LiteArchive doc5 = this.getFirstArchive5ByCid(cid, null);
        List doc5Items = this.fileItemService.queryDetailList(doc5.getId(), isCompliance);
        this.handlerFileList(doc5Items);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)doc5Items)) {
            long count = doc5Items.stream().filter(f -> f != null && f.getNeedCollect() != null && f.getNeedCollect() != false).count();
            long finishNum = doc5Items.stream().filter(f -> f != null && f.getNeedCollect() != null && f.getNeedCollect() != false && Objects.equals(f.getDataState(), 1)).count();
            map.put("finsihNum", (int)finishNum);
            map.put("totalNum", (int)count);
            if (finishNum == 0L) {
                view.setPhysicalState(Integer.valueOf(1));
            } else if (finishNum < count) {
                view.setPhysicalState(Integer.valueOf(2));
            } else {
                view.setPhysicalState(Integer.valueOf(3));
            }
        }
        view.setPhysicalStateStr(this.getStateStr(view.getPhysicalState()));
        return map;
    }

    public List<LiteArchive> getAllArchiveByTypeYear(Integer archiveType, String year) {
        Example example = new Example(LiteArchive.class);
        Example.Criteria criteria = example.createCriteria().andEqualTo("isValid", (Object)true);
        if (archiveType != null) {
            criteria.andEqualTo("archiveType", (Object)archiveType);
        }
        if (year != null) {
            criteria.andEqualTo("title", (Object)year);
        }
        List<LiteArchive> listByExample = this.getListByExample(example);
        return listByExample;
    }

    public List<LiteArchive> allLiteArchive(Date date, List<Long> cidList, List<Integer> archiveTypeList, Collection<String> archiveTitleArr) {
        Example example = new Example(LiteArchive.class);
        Example.Criteria criteria = example.createCriteria().andEqualTo("isValid", (Object)true);
        criteria.andIn("archiveType", archiveTypeList);
        if (date != null) {
            criteria.andLessThan("updateDate", (Object)date);
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(cidList)) {
            criteria.andIn("cid", cidList);
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(archiveTitleArr)) {
            criteria.andIn("title", archiveTitleArr);
        }
        example.selectProperties(new String[]{"id", "cid", "archiveType", "title"});
        List<LiteArchive> allLiteArchiveList = this.getListByExample(example);
        return allLiteArchiveList;
    }

    @Transactional(readOnly=false)
    public void syncTsProjectArchive(TsProjectSimple tsProjectSimple) {
        if (tsProjectSimple == null) {
            return;
        }
        LiteArchiveTsLink link = this.liteArchiveTsLinkService.getTsLinkByTs(tsProjectSimple.getId());
        if (link == null) {
            return;
        }
        List list = this.fileItemService.queryDetailAndSetUpdateStaffName(link.getLiteArchiveId(), Integer.valueOf(1));
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        List fileItemList = list.stream().filter(item -> item.getFileNameId().equals(104L) || item.getFileNameId().equals(106L) || item.getFileNameId().equals(109L)).peek(item -> {
            String fileIds;
            if (item.getFileNameId().equals(104L) && StringUtils.isNotEmpty((String)tsProjectSimple.getEvalEvidenceId1())) {
                fileIds = this.getFileIds((LiteArchiveFileDetailVo)item, tsProjectSimple.getEvalEvidenceId1(), tsProjectSimple.getEvalEvidenceId2());
                item.setFileIds(fileIds);
            }
            if (item.getFileNameId().equals(106L) && StringUtils.isNotEmpty((String)tsProjectSimple.getDesignEvidenceId())) {
                fileIds = this.getFileIds((LiteArchiveFileDetailVo)item, tsProjectSimple.getDesignEvidenceId(), null);
                item.setFileIds(fileIds);
            }
            if (item.getFileNameId().equals(109L) && StringUtils.isNotEmpty((String)tsProjectSimple.getControlEvidenceId1())) {
                fileIds = this.getFileIds((LiteArchiveFileDetailVo)item, tsProjectSimple.getControlEvidenceId1(), tsProjectSimple.getControlEvidenceId2());
                item.setFileIds(fileIds);
            }
        }).map(item -> {
            LiteArchiveFileItem fileItem = new LiteArchiveFileItem();
            fileItem.setFileIds(item.getFileIds());
            fileItem.setId(item.getItemId());
            fileItem.setLiteArchiveId(link.getLiteArchiveId());
            fileItem.setFileNameId(item.getFileNameId());
            fileItem.setUploadDate(new Date());
            fileItem.setUploadStaffId(Long.valueOf(0L));
            fileItem.setIsValid(Boolean.valueOf(true));
            fileItem.setCreateDate(new Date());
            fileItem.setUpdateDate(new Date());
            fileItem.setUpdateBy(Long.valueOf(0L));
            fileItem.setCreateBy(Long.valueOf(0L));
            return fileItem;
        }).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(fileItemList)) {
            List addList;
            List modList = fileItemList.stream().filter(i -> i.getId() != null).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(modList)) {
                this.fileItemService.batchUpdateOrInsert(modList, LiteArchiveFileItemMapper.class, (item, mapper) -> mapper.updateByPrimaryKey(item));
            }
            if (CollUtil.isNotEmpty(addList = fileItemList.stream().filter(i -> i.getId() == null).collect(Collectors.toList()))) {
                this.fileItemService.batchUpdateOrInsert(addList, LiteArchiveFileItemMapper.class, (item, mapper) -> {
                    item.setId(Long.valueOf(IdWorker.getId()));
                    return mapper.insert(item);
                });
            }
        }
        int finalStatus = Objects.isNull(tsProjectSimple.getProjectFinishTime()) ? 4 : 3;
        ((LiteArchiveMapper)this.dao).updateStatus(link.getLiteArchiveId(), finalStatus);
        try {
            Long cid = tsProjectSimple.getCid();
            this.reformItemBasicService.changeStatusByCidAndGenerationSource(cid, ReformGenerationSourceEnum.ARCHIVES.getValue(), Byte.valueOf((byte)3), Long.valueOf(0L), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.info("\u6863\u6848\u81ea\u52a8\u9a8c\u6536\u5931\u8d25\uff0c\u62a5\u9519\u65b9\u6cd5\uff1acn.smarthse.web.controller.litearchive.LiteArchiveController.updateArchiveFiles");
        }
    }

    private String getFileIds(LiteArchiveFileDetailVo item, String file1, String file2) {
        Object fileIds = "";
        if (StringUtils.isNotEmpty((String)item.getFileIds())) {
            List oldFileIds = StringUtils.parseToLongList((String)item.getFileIds(), (String)",");
            oldFileIds.add(Long.parseLong(file1));
            if (StringUtils.isNotEmpty((String)file2)) {
                oldFileIds.add(Long.parseLong(file2));
            }
            fileIds = new HashSet(oldFileIds).stream().map(String::valueOf).collect(Collectors.joining(","));
        } else {
            fileIds = file1 + (String)(StringUtils.isNotEmpty((String)file2) ? "," + file2 : "");
        }
        return fileIds;
    }

    public List<LiteArchive> listNoFileItemArchiveByCid(List<Long> cidList) {
        return ((LiteArchiveMapper)this.dao).listNoFileItemArchiveByCid(cidList);
    }

    @Transactional(readOnly=false)
    public int batchInsertArchives(List<LiteArchive> liteArchives) {
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(liteArchives)) {
            return 0;
        }
        int totalNum = 0;
        for (List liteArchiveList : ListUtil.partition(liteArchives, (int)100)) {
            totalNum += ((LiteArchiveMapper)this.dao).insertList2(liteArchiveList);
        }
        return totalNum;
    }

    public Long isComplianceCompany(Long cid) {
        if (cid == null) {
            return null;
        }
        NewComplianceCompanyInfo cacheComplianceByCid = this.complianceCompanyInfoService.getCacheComplianceByCid(cid, null);
        if (cacheComplianceByCid != null) {
            return cacheComplianceByCid.getId();
        }
        return null;
    }

    public List<LiteArchiveFileDetailVo> listArchiveComplianceScoreVo(List<Long> cidList, List<Integer> archiveTypeList, List<String> titleList) {
        if (CollectionUtil.isEmpty(cidList)) {
            return null;
        }
        return ((LiteArchiveMapper)this.dao).listArchiveComplianceScoreVo(cidList, archiveTypeList, titleList);
    }

    public List<LiteArchiveFileItem> queryComplianceArchive5Data(List<Long> cids) {
        return ((LiteArchiveMapper)this.dao).queryComplianceArchive5Data(cids);
    }

    public List<TsLiteArchiveVo> queryComplianceTsLiteArchiveList(List<Long> cidList) {
        if (CollUtil.isEmpty(cidList)) {
            return Collections.emptyList();
        }
        return ((LiteArchiveMapper)this.dao).getTsLiteArchiveList(null, null, cidList);
    }

    public List<LiteArchiveFileDetailVo> queryComplianceArchiveDetailList(List<Long> archiveIdList) {
        if (CollUtil.isEmpty(archiveIdList)) {
            return Collections.emptyList();
        }
        return ((LiteArchiveMapper)this.dao).queryComplianceTsDetailBatchByCidList(archiveIdList);
    }

    public List<LiteArchive> listNoFileItemArchive(List<Long> cidList, List<Integer> archiveTypeList, List<String> titleList, Integer status) {
        return ((LiteArchiveMapper)this.dao).selectNoFileItemArchive(cidList, archiveTypeList, titleList, status);
    }

    public List<LiteArchive> listNoFinishLiteArchive(List<Long> cidList, List<Integer> archiveTypeList, List<String> titleList, List<Integer> statusList) {
        return ((LiteArchiveMapper)this.dao).listNoFinishLiteArchive(cidList, archiveTypeList, titleList, statusList);
    }

    public List<CompanySuperviseModel> selectDecDeclareInfo(List<Long> cidList) {
        return ((LiteArchiveMapper)this.dao).selectDecDeclareInfo(cidList);
    }
}

