/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.litearchive.imp;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.modules.health.dao.litearchive.LiteArchiveHistoryFilePersonalMapper;
import cn.smarthse.modules.health.entity.litearchive.LiteArchiveFilePersonal;
import cn.smarthse.modules.health.entity.litearchive.LiteArchiveHistoryFilePersonal;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveHistoryFilePersonalService;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional(readOnly=true)
public class LiteArchiveHistoryFilePersonalServiceImpl
extends BaseServiceImpl<LiteArchiveHistoryFilePersonalMapper, LiteArchiveHistoryFilePersonal>
implements ILiteArchiveHistoryFilePersonalService {
    @Transactional(readOnly=false)
    public void addHistory(LiteArchiveFilePersonal info, Long staffId) {
        if (info != null) {
            LiteArchiveHistoryFilePersonal historyFilePersonal = new LiteArchiveHistoryFilePersonal();
            historyFilePersonal.setCid(info.getCid());
            historyFilePersonal.setFileIds(info.getFileIds());
            historyFilePersonal.setFilePersonalId(info.getId());
            historyFilePersonal.setDocNo(Long.valueOf(this.getMaxDocNoByFilePersonalId(info.getId()) + 1L));
            this.add(historyFilePersonal, staffId, info.getCid());
        }
    }

    @Transactional(readOnly=false)
    public PageInfo<LiteArchiveHistoryFilePersonal> queryPersonalHistoryDataByPersonId(JqGridParam jqGridParam, Long personId) {
        PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows());
        List<LiteArchiveHistoryFilePersonal> liteArchiveHistoryFilePersonals = ((LiteArchiveHistoryFilePersonalMapper)this.dao).queryPersonalHistoryDataByPersonId(personId);
        if (CollectionUtils.isNotEmpty(liteArchiveHistoryFilePersonals)) {
            for (LiteArchiveHistoryFilePersonal liteArchiveHistoryFilePersonal : liteArchiveHistoryFilePersonals) {
                liteArchiveHistoryFilePersonal.setUpdateByName(SpringEncryptUtils.decrypt((String)liteArchiveHistoryFilePersonal.getUpdateByName()));
            }
        }
        return new PageInfo(liteArchiveHistoryFilePersonals);
    }

    @Transactional(readOnly=false)
    public Boolean delPersonalHistoryDoc(Long id, Long cid, Long staffId) {
        if (id != null) {
            LiteArchiveHistoryFilePersonal historyFilePersonal = new LiteArchiveHistoryFilePersonal();
            historyFilePersonal.setId(id);
            historyFilePersonal.setCid(cid);
            this.delete(historyFilePersonal, staffId);
        }
        return false;
    }

    private Long getMaxDocNoByFilePersonalId(Long filePersonalId) {
        Example example = new Example(LiteArchiveHistoryFilePersonal.class);
        example.createCriteria().andEqualTo("filePersonalId", (Object)filePersonalId);
        List docNos = ((LiteArchiveHistoryFilePersonalMapper)this.dao).selectByExample(example).stream().map(s -> s.getDocNo() == null ? 0L : s.getDocNo()).collect(Collectors.toList());
        if (docNos != null && docNos.size() > 0) {
            return (Long)docNos.stream().max(Long::compareTo).get();
        }
        return 0L;
    }
}

