/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.litearchive.imp;

import cn.smarthse.common.framework.beans.OssClientBean;
import cn.smarthse.common.framework.excel.ExportExcel;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.RandomGenerator;
import cn.smarthse.common.util.StringMixedUtil;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.excel.ExcelUtil;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.modules.common.IDocDataService;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.compliance.enums.ComplianceCodeEnum;
import cn.smarthse.modules.health.compliance.service.IBusinessDataUpdateRefreshService;
import cn.smarthse.modules.health.component.OssUploadComponent;
import cn.smarthse.modules.health.dao.litearchive.LiteArchiveFilePersonalMapper;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.base.staff.vo.StaffBasicVo;
import cn.smarthse.modules.health.entity.base.staff.vo.StaffDocInfoVo;
import cn.smarthse.modules.health.entity.litearchive.CheckResultImportVo;
import cn.smarthse.modules.health.entity.litearchive.LiteArchive;
import cn.smarthse.modules.health.entity.litearchive.LiteArchiveFileItem;
import cn.smarthse.modules.health.entity.litearchive.LiteArchiveFileItemChild;
import cn.smarthse.modules.health.entity.litearchive.LiteArchiveFilePersonal;
import cn.smarthse.modules.health.entity.litearchive.LiteArchiveHistoryFilePersonal;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalStaffCheckInfo;
import cn.smarthse.modules.health.entity.work.reform.ReformItemBasic;
import cn.smarthse.modules.health.enums.archive.PersonalHarmFactorArchiveDataMapKeyEnum;
import cn.smarthse.modules.health.enums.reform.ReformGenerationSourceEnum;
import cn.smarthse.modules.health.enums.staff.StaffInfoImportStateEnum;
import cn.smarthse.modules.health.param.ArchiveSearchParam;
import cn.smarthse.modules.health.service.base.IBusinessNoService;
import cn.smarthse.modules.health.service.base.ICompanyService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.base.workinfo.IWorkRoleInfoService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveFileItemChildService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveFileItemService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveFilePersonalService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveHistoryFilePersonalService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveService;
import cn.smarthse.modules.health.service.litearchive.imp.Doc6GenerateLiteArchiveFile;
import cn.smarthse.modules.health.service.work.check.checkV3221.IPhcPhysicalStaffCheckInfoService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.vo.archive.Archive503BaseInfoVo;
import cn.smarthse.modules.uploader.FileResourceEnum;
import cn.smarthse.services.hfi.api.entity.CheckPlan;
import cn.smarthse.services.hfi.api.model.list.CheckPlanListParam;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import cn.smarthse.util.common.ListUtils;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class LiteArchiveFilePersonalServiceImpl
extends BaseServiceImpl<LiteArchiveFilePersonalMapper, LiteArchiveFilePersonal>
implements ILiteArchiveFilePersonalService {
    @Autowired
    private ILiteArchiveService liteArchiveService;
    @DubboReference
    private ISysFileProvideService sysFileProvideService;
    @Autowired
    ICompanyService companyService;
    @Autowired
    IStaffInfoService staffInfoService;
    @Autowired
    @Qualifier(value="personalPHCArhiveService")
    IDocDataService personalPHCArhiveService;
    @Autowired
    IBusinessNoService businessNoService;
    @Autowired(required=false)
    protected OssClientBean ossClientBean;
    @Autowired
    private IWorkRoleInfoService workRoleInfoService;
    @Autowired
    private OssUploadComponent ossUploadComponent;
    @Autowired
    private ILiteArchiveHistoryFilePersonalService liteArchiveHistoryFilePersonalService;
    @Autowired
    private ILiteArchiveFileItemService liteArchiveFileItemService;
    @Autowired
    IReformItemBasicService reformItemBasicService;
    @Autowired
    private ILiteArchiveFileItemChildService liteArchiveFileItemChildService;
    @DubboReference
    private ISysFileProvideService fileService;
    @Autowired(required=false)
    @Lazy
    private ILiteArchiveFileItemService fileItemService;
    @Autowired
    Doc6GenerateLiteArchiveFile Doc6GenerateLiteArchiveFile;
    @Autowired
    IPhcPhysicalStaffCheckInfoService checkInfoService;
    @DubboReference
    ICheckPlanService checkPlanService;
    @Autowired
    private RedissonClient redissonClient;
    @DubboReference
    private IBusinessDataUpdateRefreshService refreshService;

    public PageInfo<LiteArchiveFilePersonal> queryDetail(JqGridParam jqGridParam, ArchiveSearchParam param) {
        if (param == null) {
            return new PageInfo(new ArrayList());
        }
        Long cid = param.getCid();
        if (param.getIsComplete() != null) {
            param.setStaffInfoIdList(this.getCompletedPersonalByCid(param.getIscompliance(), cid, null));
        }
        PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows());
        param.setSearchNameEncrypt(param.getSearchName());
        if (CollectionUtils.isNotEmpty((Collection)param.getWorkStaffIdCardList())) {
            param.setWorkStaffIdCardList(param.getWorkStaffIdCardList().stream().filter(Objects::nonNull).peek(SpringEncryptUtils::encrypt).toList());
        }
        List<LiteArchiveFilePersonal> personals = ((LiteArchiveFilePersonalMapper)this.dao).queryDetail(param);
        this.convertPersonalList(personals, param);
        return new PageInfo(personals);
    }

    public void convertPersonalList(List<LiteArchiveFilePersonal> personals, ArchiveSearchParam param) {
        if (CollectionUtils.isEmpty(personals)) {
            return;
        }
        Long cid = param.getCid();
        Boolean iscompliance = param.getIscompliance();
        List reformList = Optional.ofNullable(this.get603reformMap(Collections.singletonList(cid), false, iscompliance).get(cid)).orElse(new ArrayList());
        List checkPlanList = Optional.ofNullable(this.get602checkPlanMap(Collections.singletonList(cid), iscompliance).get(cid)).orElse(new ArrayList());
        List<String> idCardList = personals.stream().filter(item -> item != null && StringUtils.isNotBlank((CharSequence)item.getIdCard())).map(LiteArchiveFilePersonal::getIdCard).collect(Collectors.toList());
        Map phcPhysMap = Optional.ofNullable(this.get603phcPhysList(Collections.singletonList(cid), idCardList, iscompliance).get(cid)).orElse(new HashMap());
        for (LiteArchiveFilePersonal arc : personals) {
            if (arc == null) continue;
            if (StringUtils.isNotBlank((CharSequence)arc.getIdCard())) {
                arc.setIdCard(arc.getIdCard().toUpperCase());
            }
            int i = 0;
            ArrayList<String> fileNameList = new ArrayList<String>();
            if (Objects.equals(iscompliance, true)) {
                if (phcPhysMap.get(arc.getIdCard()) == null) {
                    fileNameList.add("\u5386\u6b21\u804c\u4e1a\u5065\u5eb7\u68c0\u67e5\u7ed3\u679c\u53ca\u5904\u7406\u60c5\u51b5");
                    ++i;
                }
                if (CollectionUtils.isEmpty((Collection)checkPlanList)) {
                    fileNameList.add("\u5de5\u4f5c\u573a\u6240\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u68c0\u6d4b\u7ed3\u679c");
                    ++i;
                }
                arc.setUploadNum(Integer.valueOf(3 - i));
            } else {
                if (phcPhysMap.get(arc.getIdCard()) == null && CollectionUtils.isEmpty((Collection)reformList)) {
                    fileNameList.add("\u5386\u6b21\u804c\u4e1a\u5065\u5eb7\u68c0\u67e5\u7ed3\u679c\u53ca\u5904\u7406\u60c5\u51b5");
                    ++i;
                }
                arc.setUploadNum(Integer.valueOf(2 - i));
            }
            arc.setProgressRateTips(fileNameList);
        }
    }

    public Set<Long> getHasArchiveCidList(List<Long> cids) {
        return ((LiteArchiveFilePersonalMapper)this.dao).getHasArchiveCidList(cids);
    }

    public Map<Long, List<CheckPlan>> get602checkPlanMap(List<Long> cidList, Boolean iscompliance) {
        if (CollectionUtils.isEmpty(cidList)) {
            return new HashMap<Long, List<CheckPlan>>();
        }
        List checkPlanList = this.checkPlanService.selectCheckPlanList(new CheckPlanListParam().setCids(cidList).setCheckTypeList(Arrays.asList((byte)2, (byte)3, (byte)4)));
        return checkPlanList.stream().filter(Objects::nonNull).collect(Collectors.groupingBy(CheckPlan::getCid));
    }

    public Map<Long, Map<String, PhcPhysicalStaffCheckInfo>> get603phcPhysList(List<Long> cidList, List<String> idCardList, Boolean iscompliance) {
        if (CollectionUtils.isEmpty(cidList) || CollectionUtils.isEmpty(idCardList)) {
            return new HashMap<Long, Map<String, PhcPhysicalStaffCheckInfo>>();
        }
        List collect = idCardList.stream().map(SpringEncryptUtils::encrypt).collect(Collectors.toList());
        Example phcPhysExample = new Example(PhcPhysicalStaffCheckInfo.class);
        Example.Criteria criteria = phcPhysExample.createCriteria();
        criteria.andIn("cid", cidList);
        criteria.andIn("idcardCode", collect);
        criteria.andEqualTo("isValid", (Object)true);
        phcPhysExample.selectProperties(new String[]{"id", "cid", "idcardCode", "checkTime", "updateDate"});
        return this.checkInfoService.getListByExample(phcPhysExample).stream().filter(Objects::nonNull).peek(info -> {
            if (StringUtils.isNotBlank((CharSequence)info.getIdcardCode())) {
                info.setIdcardCode(info.getIdcardCode().toUpperCase());
            }
        }).collect(Collectors.groupingBy(PhcPhysicalStaffCheckInfo::getCid, Collectors.toMap(PhcPhysicalStaffCheckInfo::getIdcardCode, Function.identity(), (k1, k2) -> k1.getCheckTime().getTime() >= k2.getCheckTime().getTime() ? k1 : k2)));
    }

    public Map<Long, List<ReformItemBasic>> get603reformMap(List<Long> cidList, Boolean isAll, Boolean iscompliance) {
        if (CollectionUtils.isEmpty(cidList)) {
            return new HashMap<Long, List<ReformItemBasic>>();
        }
        Example reformExample = new Example(ReformItemBasic.class);
        Example.Criteria criteria = reformExample.createCriteria();
        criteria.andIn("cid", cidList);
        criteria.andEqualTo("generationSource", (Object)ReformGenerationSourceEnum.TJ.getValue());
        if (isAll == null || !isAll.booleanValue()) {
            criteria.andIn("status", Arrays.asList(3, 4));
        }
        criteria.andEqualTo("isValid", (Object)true);
        reformExample.selectProperties(new String[]{"id", "cid", "generationSource", "status", "findTime", "updateDate"});
        return this.reformItemBasicService.getListByExample(reformExample).stream().filter(Objects::nonNull).collect(Collectors.groupingBy(ReformItemBasic::getCid));
    }

    public Integer getArchiveStatusByCid(Long cid) {
        if (cid == null) {
            return 1;
        }
        Set<Long> hasArchiveCidList = this.getHasArchiveCidList(Collections.singletonList(cid));
        boolean noArchive = CollectionUtils.isEmpty(hasArchiveCidList);
        Integer num601 = ((LiteArchiveFilePersonalMapper)this.dao).getUploadedItemName601(cid);
        Integer num603 = ((LiteArchiveFilePersonalMapper)this.dao).getUploadedItemName603(cid);
        if (noArchive && num601 == 0 && num603 == 0) {
            return 1;
        }
        if (num601 != 0 || num603 != 0) {
            return 3;
        }
        return 2;
    }

    private void setFileModel(List<LiteArchiveFilePersonal> list) {
        for (LiteArchiveFilePersonal detailVo : list) {
            detailVo.setIdCard(StringMixedUtil.mixedIDCard((String)detailVo.getIdCard()));
            List files = this.sysFileProvideService.getListByIds(detailVo.getFileIds());
            detailVo.setFileList(files);
            if (detailVo.getWorkId() == null) continue;
            detailVo.setWorkName(this.workRoleInfoService.getWorkNameIncludeOrgName(detailVo.getWorkId()));
        }
    }

    @Transactional(readOnly=false)
    public Boolean addFile(Long id, Long[] fileId2, Long cid, Long staffid, boolean isNowDoc) {
        LiteArchiveFilePersonal info = (LiteArchiveFilePersonal)this.getById(id);
        if (info != null && fileId2 != null) {
            String fileNewIds = Arrays.asList(fileId2).stream().filter(s -> s != null).map(s -> s.toString()).collect(Collectors.joining(","));
            if (!isNowDoc) {
                if (StringUtils.isNotEmpty((String)info.getFileIds()) && StringUtils.isNotEmpty((String)info.getFileIds().replaceAll(",", ""))) {
                    this.liteArchiveHistoryFilePersonalService.addHistory(info, staffid);
                }
                info.setFileIds(fileNewIds);
            } else {
                String fileIds = info.getFileIds();
                String finalFileIds = (StringUtils.isNotEmpty((String)fileIds) ? fileIds : "") + "," + fileNewIds;
                info.setFileIds(Arrays.stream(finalFileIds.split(",")).filter(s -> StringUtils.isNotEmpty((String)s)).collect(Collectors.joining(",")));
            }
            this.update(info, staffid);
            this.updateLiteArchive(info.getLiteArchiveId(), staffid);
        }
        return false;
    }

    @Transactional(readOnly=false)
    public Boolean delFile(Long id, Long fileId, Long cid, Long staffid) {
        LiteArchiveFilePersonal info = (LiteArchiveFilePersonal)this.getById(id);
        if (info != null) {
            String fileIds = info.getFileIds();
            String fileIdSt = fileId.toString();
            fileIds = Arrays.stream(fileIds.replace(fileIdSt, "").split(",")).filter(s -> StringUtils.isNotEmpty((String)s)).collect(Collectors.joining(","));
            info.setFileIds(fileIds);
            this.update(info, staffid);
            this.updateLiteArchive(info.getLiteArchiveId(), staffid);
            return true;
        }
        return false;
    }

    public Boolean isExist(Long cid, Long staffId) {
        Example example = new Example(LiteArchiveFilePersonal.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("staffId", (Object)staffId).andEqualTo("isValid", (Object)true);
        List list = this.getListByExample(example);
        if (list != null && !list.isEmpty()) {
            return true;
        }
        return false;
    }

    @Transactional(readOnly=false)
    public LiteArchiveFilePersonal addPersionArchive(LiteArchiveFilePersonal info) {
        Boolean isExist = this.isExist(info.getCid(), info.getStaffId());
        if (!isExist.booleanValue()) {
            this.add(info, info.getCreateBy(), info.getCid());
            this.Doc6GenerateLiteArchiveFile.createLiteArchive(info);
        }
        return info;
    }

    @Transactional(readOnly=false)
    public LiteArchiveFilePersonal updatePersionArchive(LiteArchiveFilePersonal info) {
        if (info == null || info.getId() == null) {
            return null;
        }
        int i = ((LiteArchiveFilePersonalMapper)this.dao).updateByPrimaryKeySelective(info);
        return info;
    }

    @Transactional
    public Integer updatePersonalArchive(String archiveIds, Long staffid) {
        List personalList = this.getListByIds(archiveIds);
        if (CollectionUtils.isEmpty(personalList)) {
            return 0;
        }
        this.batchUpdateOrInsert(personalList, LiteArchiveFilePersonalMapper.class, (item, mapper) -> {
            item.setUpdateBy(staffid);
            item.setUpdateDate(new Date());
            return mapper.updateByPrimaryKeySelective(item);
        });
        return personalList.size();
    }

    public Map<String, Object> getPersonalDocMap(Long cid, Long staffId) {
        Map dataMap = this.personalPHCArhiveService.getDocData(cid, staffId.toString());
        return dataMap;
    }

    public Integer addHarmWorkStaffToArchive(Long cid, Long archiveId, Long staffId) {
        return null;
    }

    public PageInfo<LiteArchiveHistoryFilePersonal> queryPersonalHistoryDataByPersonId(JqGridParam jqGridParam, Long personId) {
        return this.liteArchiveHistoryFilePersonalService.queryPersonalHistoryDataByPersonId(jqGridParam, personId);
    }

    @Transactional(readOnly=false)
    public Boolean delPersonalHistoryDoc(Long id, Long cid, Long staffId) {
        return this.liteArchiveHistoryFilePersonalService.delPersonalHistoryDoc(id, cid, staffId);
    }

    public LiteArchiveHistoryFilePersonal getHistoryFilePersonalByHistoryId(Long historyId) {
        return (LiteArchiveHistoryFilePersonal)this.liteArchiveHistoryFilePersonalService.getById(historyId);
    }

    public List<Long> getArchiveStaffIdsByCid(Long cid) {
        return ((LiteArchiveFilePersonalMapper)this.dao).getArchiveStaffIdsByCid(cid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CheckResultImportVo> getCheckResultData(String ossfile, Long loginStaffId, Long cid) {
        HSSFWorkbook wb = null;
        List<CheckResultImportVo> data = new ArrayList<CheckResultImportVo>();
        try {
            wb = new HSSFWorkbook(ExcelUtil.getInstance().getOssInputStream(ossfile));
            HSSFSheet sheet = wb.getSheetAt(0);
            data = this.getCheckResultDatafromExcel(sheet, loginStaffId, cid);
        }
        catch (Exception e) {
            this.logger.error("\u6570\u636e\u5bfc\u5165\u51fa\u9519\uff1a", (Throwable)e);
        }
        finally {
            if (wb != null) {
                try {
                    wb.close();
                }
                catch (IOException iOException) {}
            }
        }
        return data;
    }

    private List<CheckResultImportVo> getCheckResultDatafromExcel(HSSFSheet sheet, Long loginStaffId, Long cid) {
        ArrayList<CheckResultImportVo> list = new ArrayList<CheckResultImportVo>();
        int rowIndex = 0;
        int cellIndex = 8;
        Iterator iter = sheet.rowIterator();
        while (iter.hasNext()) {
            Row row = (Row)iter.next();
            if (++rowIndex == 1) continue;
            CheckResultImportVo vo = new CheckResultImportVo();
            vo.setCid(cid);
            vo.setLoginStaffId(loginStaffId);
            vo.setErrorReason("");
            block12: for (int i = 0; i <= cellIndex; ++i) {
                Cell cell = row.getCell(i);
                if (cell != null) {
                    cell.setCellType(CellType.STRING);
                }
                switch (i) {
                    case 0: {
                        if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) continue block12;
                        String name = cell.getStringCellValue().trim();
                        vo.setName(name);
                        StaffBasicVo staff = this.staffInfoService.getStaffBasicInfoByNameAndIdcard(name, null, cid);
                        if (staff != null) {
                            vo.setStaffId(staff.getStaffId());
                            continue block12;
                        }
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ",\u59d3\u540d\u4eba\u5458\u5728\u4f01\u4e1a\u4e2d\u4e0d\u5b58\u5728;");
                        continue block12;
                    }
                    case 1: {
                        if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) continue block12;
                        vo.setDocNo(cell.getStringCellValue().trim());
                        if (vo.getStaffId() != null) {
                            LiteArchiveFilePersonal file = this.getByStaffId(vo.getStaffId(), cid, loginStaffId);
                            if (StringUtils.isNotBlank((CharSequence)vo.getDocNo()) && file != null && !Objects.equals(vo.getDocNo(), file.getDocNo())) {
                                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ",\u5bfc\u5165\u7684\u6863\u6848\u7f16\u53f7\u8ddf\u7cfb\u7edf\u4e2d\u4eba\u5458\u7684\u6863\u6848\u7f16\u53f7\u4e0d\u4e00\u81f4;");
                            }
                        }
                        if (vo.getDataState() != null && vo.getDataState().byteValue() != StaffInfoImportStateEnum.normal.getValue()) continue block12;
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                        continue block12;
                    }
                    case 2: {
                        if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) continue block12;
                        vo.setWorkName(cell.getStringCellValue().trim());
                        if (vo.getDataState() != null && vo.getDataState().byteValue() != StaffInfoImportStateEnum.normal.getValue()) continue block12;
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                        continue block12;
                    }
                    case 3: {
                        if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) continue block12;
                        vo.setCheckTime(cell.getStringCellValue().trim());
                        if (vo.getDataState() != null && vo.getDataState().byteValue() != StaffInfoImportStateEnum.normal.getValue()) continue block12;
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                        continue block12;
                    }
                    case 4: {
                        if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) continue block12;
                        vo.setCheckOrg(cell.getStringCellValue().trim());
                        if (vo.getDataState() != null && vo.getDataState().byteValue() != StaffInfoImportStateEnum.normal.getValue()) continue block12;
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                        continue block12;
                    }
                    case 5: {
                        if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) continue block12;
                        vo.setHarmName(cell.getStringCellValue().trim());
                        if (vo.getDataState() != null && vo.getDataState().byteValue() != StaffInfoImportStateEnum.normal.getValue()) continue block12;
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                        continue block12;
                    }
                    case 6: {
                        if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) continue block12;
                        vo.setResult(cell.getStringCellValue().trim());
                        if (vo.getDataState() != null && vo.getDataState().byteValue() != StaffInfoImportStateEnum.normal.getValue()) continue block12;
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                        continue block12;
                    }
                    case 7: {
                        if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) continue block12;
                        vo.setProtect(cell.getStringCellValue().trim());
                        if (vo.getDataState() != null && vo.getDataState().byteValue() != StaffInfoImportStateEnum.normal.getValue()) continue block12;
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                        continue block12;
                    }
                    case 8: {
                        if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) continue block12;
                        vo.setRemark(cell.getStringCellValue().trim());
                        if (vo.getDataState() != null && vo.getDataState().byteValue() != StaffInfoImportStateEnum.normal.getValue()) continue block12;
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                }
            }
            if (vo.getName() == null) continue;
            list.add(vo);
        }
        return list;
    }

    private String getExcelColName(int index) {
        if (index <= 26) {
            return String.valueOf((char)(65 + index - 1));
        }
        int a = index / 26;
        int b = index % 26;
        return String.valueOf((char)(65 + a - 1)) + String.valueOf((char)(65 + b - 1));
    }

    private void updateLiteArchive(Long id, Long staffId) {
        Integer notUpNum = ((LiteArchiveFilePersonalMapper)this.dao).getNotUploadedNum(id);
        Integer haveUpNum = ((LiteArchiveFilePersonalMapper)this.dao).getHaveUploadedNum(id);
        LiteArchive archive = (LiteArchive)this.liteArchiveService.getById(id);
        if (notUpNum != null && notUpNum > 0) {
            if (haveUpNum != null && haveUpNum > 0) {
                archive.setStatus(Integer.valueOf(2));
            } else {
                archive.setStatus(Integer.valueOf(1));
            }
        } else if (haveUpNum != null && haveUpNum > 0) {
            archive.setStatus(Integer.valueOf(3));
        } else {
            archive.setStatus(Integer.valueOf(1));
        }
        archive.setArchiveUpdateTime(new Date());
        this.liteArchiveService.update((Object)archive, staffId);
    }

    private Map<Long, List<CheckResultImportVo>> getCheckDataMap(List<CheckResultImportVo> checkData) {
        HashMap<Long, List<CheckResultImportVo>> importMap = new HashMap<Long, List<CheckResultImportVo>>();
        for (CheckResultImportVo vo : checkData) {
            ArrayList<CheckResultImportVo> list = (ArrayList<CheckResultImportVo>)importMap.get(vo.getStaffId());
            if (list == null) {
                list = new ArrayList<CheckResultImportVo>();
            }
            list.add(vo);
            importMap.put(vo.getStaffId(), list);
        }
        return importMap;
    }

    @Transactional(readOnly=false)
    public void updataItemChild(Long fileId, Long archiveId, Long loginStaffId) {
        Integer year = DateUtils.getThisYear();
        LiteArchiveFileItem o = this.fileItemService.getByArchiveAndFileName(archiveId, Long.valueOf(602L));
        LiteArchiveFileItemChild child = this.liteArchiveFileItemChildService.getFileItemChildrenByItemIdAndYear(o.getId(), year, loginStaffId);
        if (fileId != null) {
            child.setReferFileIds(fileId.toString());
        }
        child.setUploadStaffId(loginStaffId.toString());
        this.liteArchiveFileItemChildService.update((Object)child, loginStaffId);
    }

    @Transactional(readOnly=false)
    public void updateAllPersonalArchive() {
        List<LiteArchiveFilePersonal> list = this.getAllPersonalArchive();
        for (LiteArchiveFilePersonal arc : list) {
            this.Doc6GenerateLiteArchiveFile.createLiteArchive(arc);
        }
    }

    public List<LiteArchiveFilePersonal> getAllPersonalArchive() {
        Example example = new Example(LiteArchiveFilePersonal.class);
        example.createCriteria().andEqualTo("isValid", (Object)true);
        List<LiteArchiveFilePersonal> list = this.getListByExample(example);
        return list;
    }

    public List<Long> getNoArchiveStaffIdHasCheck(Long cid) {
        if (cid == null) {
            return Collections.emptyList();
        }
        return ((LiteArchiveFilePersonalMapper)this.dao).getNoArchiveStaffIdHasCheck(cid);
    }

    public List<Archive503BaseInfoVo> getArchive503BaseInfoByCid(Long cid) {
        return ((LiteArchiveFilePersonalMapper)this.dao).getArchive503BaseInfoByCid(cid);
    }

    public Integer getArchiveFileItemNotNull(Long archiveId, Integer fileNameId) {
        if (archiveId == null || fileNameId == null) {
            return -1;
        }
        return ((LiteArchiveFilePersonalMapper)this.dao).getArchiveFileItemNotNull(archiveId, fileNameId);
    }

    @Transactional(readOnly=false)
    public void importCheckResultData(List<CheckResultImportVo> importData, Integer year, Long cid, Long loginStaffId, Long fileId) throws FileNotFoundException, UnsupportedEncodingException {
        LiteArchiveFileItemChild ct = this.liteArchiveFileItemChildService.getFileItemChildrenByItemIdAndYear(cid, year, loginStaffId);
        if (ct.getFileIds() != null) {
            ct.setFileIds(ct.getFileIds() + "," + fileId.toString());
        } else {
            ct.setFileIds(fileId.toString());
        }
        ct.setUploadStaffId(loginStaffId.toString());
        this.liteArchiveFileItemChildService.update((Object)ct, loginStaffId);
        Map<Long, List<CheckResultImportVo>> importMap = this.getCheckDataMap(importData);
        for (Map.Entry<Long, List<CheckResultImportVo>> entry : importMap.entrySet()) {
            Long staffId = entry.getKey();
            List<CheckResultImportVo> list = entry.getValue();
            LiteArchiveFilePersonal file = this.getByStaffId(staffId, cid, loginStaffId);
            LiteArchiveFileItem item = this.liteArchiveFileItemService.getByArchiveAndFileName(file.getId(), Long.valueOf(602L));
            Long cFileId = this.generaExcelFileAndUpLoad(list, file.getStaffName(), cid);
            LiteArchiveFileItemChild child = this.liteArchiveFileItemChildService.getFileItemChildrenByItemIdAndYear(item.getId(), year, loginStaffId);
            if (cFileId != null) {
                if (child.getFileIds() != null) {
                    child.setFileIds(child.getFileIds() + "," + cFileId.toString());
                } else {
                    child.setFileIds(cFileId.toString());
                }
            }
            child.setUploadStaffId(loginStaffId.toString());
            this.liteArchiveFileItemChildService.update((Object)child, loginStaffId);
            item.setFileIds(child.getFileIds());
            item.setUploadStaffId(loginStaffId);
            this.liteArchiveFileItemService.update((Object)item, loginStaffId);
        }
    }

    public List<CheckResultImportVo> getFilePersonalList(Long cid) {
        return ((LiteArchiveFilePersonalMapper)this.dao).getFilePersonalList(cid);
    }

    public LiteArchiveFilePersonal getLiteArchiveFilePersonalByStaffId(Long staffId) {
        Example example = new Example(LiteArchiveFilePersonal.class);
        example.createCriteria().andEqualTo("staffId", (Object)staffId).andEqualTo("isValid", (Object)true);
        List list = this.getListByExample(example);
        if (list != null && list.size() > 0) {
            return (LiteArchiveFilePersonal)list.get(0);
        }
        return null;
    }

    private Long generaExcelFileAndUpLoad(List<CheckResultImportVo> importData, String name, Long cid) throws FileNotFoundException, UnsupportedEncodingException {
        String[] colums = new String[]{"\u59d3\u540d|name", "\u6863\u6848\u53f7|docNo", "\u5c97\u4f4d|workName", "\u68c0\u6d4b\u65f6\u95f4|checkTime", "\u68c0\u6d4b\u673a\u6784|checkOrg", "\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u540d\u79f0|harmName", "\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u68c0\u6d4b\u7ed3\u679c|result", "\u4fdd\u62a4\u63aa\u65bd|protect", "\u5907\u6ce8|remark"};
        ExportExcel listexcel = new ExportExcel();
        String title = "\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u68c0\u6d4b\u7ed3\u679c(" + name + ")" + DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd");
        String tempDir = System.getProperty("java.io.tmpdir") + File.separator;
        String randomString = RandomGenerator.getRandomString((int)4);
        tempDir = tempDir + DateUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss") + File.separator + randomString + File.separator;
        File file = listexcel.generaExcel("\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u68c0\u6d4b\u7ed3\u679c.xls", colums, importData, Integer.valueOf(20000), tempDir);
        SysFileModel sysFileModel1 = this.uploadFile(file, title, "xls", cid);
        if (sysFileModel1 != null) {
            return sysFileModel1.getId();
        }
        return null;
    }

    private SysFileModel uploadFile(File f, String name, String ext, Long cid) {
        SysFileModel file = new SysFileModel();
        String ossPath = cid + "/liteArchive";
        String oss = null;
        try {
            oss = this.ossClientBean.OSSPutObject(String.valueOf(UUID.randomUUID()) + "." + ext, f, ossPath, name + "." + ext, "" + FileUtils.checksumCRC32((File)f));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        file.setFileName(name + "." + ext);
        file.setCid(cid);
        file.setResource(Integer.valueOf(FileResourceEnum.companyHealth_07.getValue()));
        file.setFileSize(FileUtils.byteCountToDisplaySize((long)FileUtils.sizeOf((File)f)));
        file.setFileExt(ext);
        try {
            file.setFileHash("" + FileUtils.checksumCRC32((File)f));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        file.setOssUrl(oss);
        file.setDescription("");
        file = this.fileService.addSysFile(file, Long.valueOf(0L));
        return file;
    }

    private LiteArchiveFilePersonal getByStaffId(Long staffId, Long cid, Long loginStaffId) {
        Example example = new Example(LiteArchiveFilePersonal.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("staffId", (Object)staffId).andEqualTo("isValid", (Object)true);
        List list = this.getListByExample(example);
        if (list != null && list.size() > 0) {
            return (LiteArchiveFilePersonal)list.get(0);
        }
        LiteArchiveFilePersonal info = new LiteArchiveFilePersonal();
        info.setCid(cid);
        info.setStaffId(staffId);
        String name = this.staffInfoService.getStaffNameByStaffId(staffId);
        info.setStaffName(name);
        String docNo = this.businessNoService.getDocNo(cid, "doc6", null);
        info.setDocNo(docNo);
        info.setCreateBy(loginStaffId);
        info = this.addPersionArchive(info);
        return info;
    }

    public List<LiteArchiveFilePersonal> getArchive6Staff(Long staffId, Long areaId, Byte areaLevel, Long cid) {
        PageHelper.startPage((int)1, (int)1000, (boolean)false);
        List<LiteArchiveFilePersonal> archive6StaffId = ((LiteArchiveFilePersonalMapper)this.dao).getArchive6Staff(staffId, areaId, areaLevel, cid);
        if (CollectionUtils.isNotEmpty(archive6StaffId)) {
            for (LiteArchiveFilePersonal liteArchiveFilePersonal : archive6StaffId) {
                liteArchiveFilePersonal.setStaffName(SpringEncryptUtils.decrypt((String)liteArchiveFilePersonal.getStaffName()));
            }
        }
        return archive6StaffId;
    }

    public List<Long> getArchive6StaffId() {
        return ((LiteArchiveFilePersonalMapper)this.dao).getArchive6StaffId();
    }

    public Map<Long, StaffInfo> getCompletedNumByCidPersonal(List<Long> cids, Map<String, Object> map) {
        Integer workStatus;
        if (CollectionUtils.isEmpty(cids)) {
            return Collections.emptyMap();
        }
        Boolean isThirdParty = map.get("isThirdParty") == null ? null : (Boolean)map.get("isThirdParty");
        List<StaffInfo> staffInfoList = ((LiteArchiveFilePersonalMapper)this.dao).getCompletedNumByCidPersonal(cids, isThirdParty, workStatus = map.get("workStatus") == null ? null : (Integer)map.get("workStatus"));
        if (CollectionUtils.isEmpty(staffInfoList)) {
            return Collections.emptyMap();
        }
        Map<Long, StaffInfo> infoMap = staffInfoList.stream().peek(item -> {
            if (item.getLocalWorkNum() == null) {
                item.setLocalWorkNum(Integer.valueOf(0));
            }
            if (item.getOutWorkNum() == null) {
                item.setOutWorkNum(Integer.valueOf(0));
            }
            if (item.getCompletedNum() == null) {
                item.setCompletedNum(Integer.valueOf(0));
            }
            item.setTotalWorkNum(Integer.valueOf(item.getLocalWorkNum() + item.getOutWorkNum()));
        }).collect(Collectors.toMap(StaffInfo::getCid, Function.identity(), (o1, o2) -> o1));
        return infoMap;
    }

    public List<Long> getCompletedPersonalByCid(Boolean iscompliance, Long cid, List<Long> staffIds) {
        List<Long> staffInfoIdList;
        if (cid == null) {
            return List.of(Long.valueOf(-1L));
        }
        if (Objects.equals(iscompliance, true)) {
            staffInfoIdList = ((LiteArchiveFilePersonalMapper)this.dao).getCompletedPersonalByCid(true, cid, staffIds);
        } else {
            Map<Long, List<ReformItemBasic>> reformMap = this.get603reformMap(List.of(cid), false, iscompliance);
            if (MapUtils.isNotEmpty(reformMap)) {
                Example example = new Example(StaffInfo.class);
                Example.Criteria criteria = example.createCriteria();
                criteria.andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true);
                if (CollectionUtils.isNotEmpty(staffIds)) {
                    criteria.andIn("id", staffIds);
                }
                example.selectProperties(new String[]{"id"});
                staffInfoIdList = this.staffInfoService.getListByExample(example).stream().filter(Objects::nonNull).map(StaffInfo::getId).toList();
            } else {
                staffInfoIdList = ((LiteArchiveFilePersonalMapper)this.dao).getCompletedPersonalByCid(false, cid, staffIds);
            }
        }
        if (CollectionUtils.isEmpty(staffInfoIdList)) {
            staffInfoIdList.add(-1L);
        }
        return staffInfoIdList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void addPersonalArchiveByCid(List<Long> staffInfoIdList, Long cid, Long operateId, Map<String, Object> map) {
        RLock lock = this.redissonClient.getLock(String.valueOf(cid));
        if (lock.tryLock()) {
            try {
                this.addPersonalArchiveByCidMethod(staffInfoIdList, cid, operateId, map);
            }
            catch (Exception e) {
                this.logger.error("\u751f\u6210\u4e2a\u4eba\u6863\u6848addPersonalArchiveByCid\u51fa\u9519\uff1a{}", (Throwable)e);
            }
            finally {
                lock.unlock();
            }
        }
    }

    public void addPersonalArchiveByCidMethod(List<Long> staffInfoIdList, Long cid, Long operateId, Map<String, Object> map) {
        Date date = new Date();
        if (cid == null) {
            return;
        }
        if (CollectionUtils.isNotEmpty(staffInfoIdList)) {
            Example example = new Example(LiteArchiveFilePersonal.class);
            example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true);
            example.selectProperties(new String[]{"id", "cid", "staffId"});
            List existStaffInfoIdList = this.getListByExample(example).stream().filter(item -> item != null && item.getStaffId() != null).map(LiteArchiveFilePersonal::getStaffId).collect(Collectors.toList());
            staffInfoIdList.removeAll(existStaffInfoIdList);
        } else {
            staffInfoIdList = new ArrayList<Long>();
            List<Long> noArchiveStaffIdHasCheck = this.getNoArchiveStaffIdHasCheck(cid);
            if (CollectionUtils.isNotEmpty(noArchiveStaffIdHasCheck)) {
                staffInfoIdList.addAll(noArchiveStaffIdHasCheck);
            }
        }
        if (CollectionUtils.isEmpty(staffInfoIdList)) {
            return;
        }
        HashMap<Long, List<Long>> cidAndStaffIdListMap = new HashMap<Long, List<Long>>();
        cidAndStaffIdListMap.put(cid, staffInfoIdList);
        Map staffDocInfoVoMap = this.staffInfoService.getStaffDocInfoVoMap(cidAndStaffIdListMap);
        Map docInfoVoMap = (Map)staffDocInfoVoMap.get(cid);
        if (CollectionUtils.isEmpty((Map)docInfoVoMap)) {
            this.logger.error("\u65b0\u589e\u4e2a\u4eba\u6863\u6848\u9519\u8bef\uff0c\u67e5\u4e0d\u5230\u8fd9\u4e00\u6279\u4eba\u5458\u6570\u636ecid{}", (Object)cid);
            return;
        }
        List<LiteArchiveFilePersonal> personalList = new ArrayList();
        for (Long staffId : staffInfoIdList) {
            if (staffId == null) continue;
            if (docInfoVoMap.get(staffId) == null) {
                this.logger.error("\u65b0\u589e\u4e2a\u4eba\u6863\u6848\u9519\u8bef\uff0c\u67e5\u4e0d\u5230\u8fd9\u4e2a\u4eba\u5458\u6570\u636ecid{}\uff0cstaffInfoId{}", (Object)cid, (Object)staffId);
                continue;
            }
            StaffDocInfoVo staffDocInfoVo = (StaffDocInfoVo)docInfoVoMap.get(staffId);
            LiteArchiveFilePersonal arc = new LiteArchiveFilePersonal();
            arc.setId(Long.valueOf(this.idworker.nextId()));
            arc.setCid(cid);
            arc.setStaffId(staffId);
            arc.setStaffName(staffDocInfoVo.getRealName());
            arc.setIdCard(staffDocInfoVo.getIdCard());
            arc.setCreateBy(operateId);
            arc.setUpdateBy(operateId);
            arc.setCreateDate(date);
            arc.setUpdateDate(date);
            arc.setIsValid(Boolean.valueOf(true));
            personalList.add(arc);
        }
        personalList = this.businessNoService.getPersonalDocNo(personalList);
        ListUtils.split(personalList, (int)2000).forEach(personals -> ((LiteArchiveFilePersonalMapper)this.dao).insertList2((List)personals));
        if (CollectionUtils.isNotEmpty(personalList)) {
            HashMap<CallSite, String> params = new HashMap<CallSite, String>();
            params.put((CallSite)((Object)(ComplianceCodeEnum.CODE14.getCode() + ":archiveTypeStr")), "6");
            this.refreshService.addBusinessDataUpdateMsg(cid, params, new ComplianceCodeEnum[]{ComplianceCodeEnum.CODE14});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public Integer batchUpdatePersonalRegister(List<Long> archiveIds, Long cid, String storageLocation, Long operateId, Map<String, Object> map) {
        if (CollectionUtils.isEmpty(archiveIds)) {
            return 0;
        }
        RLock lock = this.redissonClient.getLock(String.valueOf(cid));
        if (lock.tryLock()) {
            try {
                List list = archiveIds.stream().map(archiveId -> new LiteArchiveFileItem().setLiteArchiveId(archiveId).setFileNameId(Long.valueOf(604L)).setStorageLocation(storageLocation).setUpdateBy(operateId)).collect(Collectors.toList());
                this.liteArchiveFileItemService.batchAppendFileItem(list);
            }
            catch (Exception e) {
                this.logger.error("\u6279\u91cf\u767b\u8bb0\u4e2a\u4eba\u6863\u6848604batchUpdatePersonalRegister\u51fa\u9519\uff1a{}", (Throwable)e);
            }
            finally {
                lock.unlock();
            }
        }
        return 1;
    }

    public File getStaffDocInfoFile(Long cid, Long staffId) {
        HashMap<Long, List<Long>> cidAndStaffIdListMap = new HashMap<Long, List<Long>>();
        cidAndStaffIdListMap.put(cid, Collections.singletonList(staffId));
        Map map = this.staffInfoService.getStaffDocInfoVoMap(cidAndStaffIdListMap);
        Map docInfoVoMap = (Map)map.get(cid);
        if (staffId == null || CollectionUtils.isEmpty((Map)docInfoVoMap) || docInfoVoMap.get(staffId) == null) {
            return null;
        }
        StaffDocInfoVo staffDocInfoVo = (StaffDocInfoVo)docInfoVoMap.get(staffId);
        HashMap<String, Object> infoMap = new HashMap<String, Object>();
        infoMap.put(PersonalHarmFactorArchiveDataMapKeyEnum.staffInfo.name(), staffDocInfoVo);
        File file = this.Doc6GenerateLiteArchiveFile.generaFile2("\u4e2a\u4eba\u4fe1\u606f\u5361(" + staffDocInfoVo.getRealName() + ").doc", infoMap, "liteachive/litedoc6/phcFile.ftl", cid);
        return file;
    }

    @Transactional
    public String handDirtyData(String cids) {
        List<LiteArchiveFilePersonal> dirtyMultData2;
        List personalIdList;
        List deleteList1;
        Object str = "";
        ArrayList<Long> cidList = new ArrayList();
        if (StringUtils.isNotEmpty((String)cids)) {
            cidList = StringUtils.parseToLongList((String)cids);
        }
        if (CollectionUtils.isNotEmpty(deleteList1 = ((LiteArchiveFilePersonalMapper)this.dao).getDirtyMultData(cidList, 2).stream().filter(Objects::nonNull).map(LiteArchiveFilePersonal::getId).collect(Collectors.toList()))) {
            Example example = new Example(LiteArchiveFilePersonal.class);
            example.createCriteria().andIn("id", deleteList1);
            int i = ((LiteArchiveFilePersonalMapper)this.dao).updateByExampleSelective(new LiteArchiveFilePersonal().setIsValid(Boolean.valueOf(false)), example);
            str = "\u4eba\u5458cid\u4e3a\u7a7a\uff0c\u5220\u9664" + i;
        }
        if (CollectionUtils.isEmpty(personalIdList = (dirtyMultData2 = ((LiteArchiveFilePersonalMapper)this.dao).getDirtyMultData(cidList, 1)).stream().filter(personal -> personal != null && !StringUtils.isEmpty((CharSequence)personal.getFileIds())).flatMap(personal -> StringUtils.parseToLongList((String)personal.getFileIds()).stream()).collect(Collectors.toList()))) {
            str = (String)str + "\u6ca1\u6709\u6570\u636e\u4e86";
            return str;
        }
        List personals = this.getListByIds(StringUtils.join(personalIdList, (String)","));
        Map retainListCollect = personals.stream().collect(Collectors.toMap(LiteArchiveFilePersonal::getStaffId, Function.identity(), (v1, v2) -> {
            if (v1.getUpdateDate().equals(v2.getUpdateDate())) {
                return v1.getCreateDate().getTime() >= v2.getCreateDate().getTime() ? v1 : v2;
            }
            return v1.getUpdateDate().getTime() >= v2.getUpdateDate().getTime() ? v1 : v2;
        }));
        ArrayList retainList = new ArrayList(retainListCollect.values());
        personals.removeAll(retainList);
        List deleteList2 = personals.stream().filter(Objects::nonNull).map(LiteArchiveFilePersonal::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(deleteList2)) {
            Example example = new Example(LiteArchiveFilePersonal.class);
            example.createCriteria().andIn("id", deleteList2);
            int n = ((LiteArchiveFilePersonalMapper)this.dao).updateByExampleSelective(new LiteArchiveFilePersonal().setIsValid(Boolean.valueOf(false)), example);
        }
        str = (String)str + "\u6210\u529f\u5904\u7406";
        return str;
    }
}

