/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.litearchive.imp;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.CommonUtil;
import cn.smarthse.modules.health.dao.litearchive.LiteArchiveFileNameMapper;
import cn.smarthse.modules.health.entity.litearchive.LiteArchiveFileName;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveFileNameService;
import cn.smarthse.modules.health.service.litearchive.imp.LiteArchiveServiceImpl;
import jakarta.annotation.PostConstruct;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tk.mybatis.mapper.entity.Example;

@DubboService
public class LiteArchiveFileNameServiceImpl
extends BaseServiceImpl<LiteArchiveFileNameMapper, LiteArchiveFileName>
implements ILiteArchiveFileNameService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LiteArchiveFileNameServiceImpl.class);
    private Map<Long, LiteArchiveFileName> nameId2ArchiveTypeMap;

    @PostConstruct
    public void initFileName() {
        Example e = new Example(LiteArchiveFileName.class);
        e.createCriteria().andEqualTo("isValid", (Object)true);
        List listByExample = this.getListByExample(e);
        Map<Long, LiteArchiveFileName> map = listByExample.stream().collect(Collectors.toMap(LiteArchiveFileName::getId, v -> v));
        this.nameId2ArchiveTypeMap = map;
    }

    public int getCountByType(Integer archiveType) {
        Example example = new Example(LiteArchiveFileName.class);
        example.createCriteria().andEqualTo("archiveType", (Object)archiveType);
        return this.getCountByExample(example);
    }

    public List<LiteArchiveFileName> getByArchiveType(Integer archiveType) {
        Example example = new Example(LiteArchiveFileName.class);
        example.createCriteria().andEqualTo("archiveType", (Object)archiveType);
        return this.getListByExample(example);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public List<Integer> parseArchiveTypeList(String fileNamdIds) {
        List liteArchiveFileNameList;
        List fileNamdIdList = CommonUtil.str2LongList((String)fileNamdIds);
        if (CollectionUtils.isEmpty((Collection)fileNamdIdList)) {
            log.error("\u65e0\u6548\u6863\u6848\u5237\u65b0\u53c2\u6570\uff0c fileNamdIdList\uff1a{}", (Object)fileNamdIdList);
            return null;
        }
        if (MapUtils.isEmpty(this.nameId2ArchiveTypeMap)) {
            log.error("nameId2ArchiveTypeMap \u5b9e\u4f8b\u5316\u4e3a\u7a7a\uff0c \u91cd\u65b0\u52a0\u8f7d\uff0c fileNamdIdList\uff1a{}\uff0c cid:{}", (Object)fileNamdIdList);
            Class<LiteArchiveServiceImpl> clazz = LiteArchiveServiceImpl.class;
            // MONITORENTER : cn.smarthse.modules.health.service.litearchive.imp.LiteArchiveServiceImpl.class
            this.initFileName();
            // MONITOREXIT : clazz
        }
        if (!CollectionUtils.isEmpty(liteArchiveFileNameList = fileNamdIdList.stream().filter(f -> this.nameId2ArchiveTypeMap.containsKey(f)).map(m -> this.nameId2ArchiveTypeMap.get(m)).collect(Collectors.toList()))) return liteArchiveFileNameList.stream().map(LiteArchiveFileName::getArchiveType).distinct().collect(Collectors.toList());
        return null;
    }
}

