/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.litearchive.imp;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.NumberUtil;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.CommonUtil;
import cn.smarthse.common.util.SpringContextHolder;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.compliance.enums.ComplianceCodeEnum;
import cn.smarthse.modules.health.compliance.service.IBusinessDataUpdateRefreshService;
import cn.smarthse.modules.health.dao.litearchive.LiteArchiveFileItemMapper;
import cn.smarthse.modules.health.dao.litearchive.LiteArchiveMapper;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.litearchive.LiteArchive;
import cn.smarthse.modules.health.entity.litearchive.LiteArchiveFileItem;
import cn.smarthse.modules.health.entity.litearchive.LiteArchiveFileName;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalCheckSearchVo;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalStatisticsModel;
import cn.smarthse.modules.health.entity.work.reform.ReformItemBasic;
import cn.smarthse.modules.health.entity.work.thirdtime.LiteArchiveTsLink;
import cn.smarthse.modules.health.entity.work.thirdtime.TsProjectSimple;
import cn.smarthse.modules.health.enums.archive.ArchiveFilteItemDataStateEnum;
import cn.smarthse.modules.health.enums.reform.ReformGenerationSourceEnum;
import cn.smarthse.modules.health.enums.reform.ReformStatusEnum;
import cn.smarthse.modules.health.enums.thirdtime.TsProjectSimpleStateEnum;
import cn.smarthse.modules.health.enums.thirdtime.TsProjectSimpleStatusEnum;
import cn.smarthse.modules.health.model.litearchive.ArchiveFileItemUpdateParam;
import cn.smarthse.modules.health.model.litearchive.LiteArchiveUploadCount;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceCompanyInfoService;
import cn.smarthse.modules.health.service.base.staff.IStaffBasicInfoService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveFileItemService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveFileNameService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveFilePersonalService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveService;
import cn.smarthse.modules.health.service.litearchive.imp.Doc2GenerateLiteArchiveFile2;
import cn.smarthse.modules.health.service.litearchive.imp.Doc3GenerateLiteArchiveFile;
import cn.smarthse.modules.health.service.litearchive.imp.Doc4GenerateLiteArchiveFile;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckService;
import cn.smarthse.modules.health.service.work.check.checkV3221.IPhcPhysicalCheckV3221Service;
import cn.smarthse.modules.health.service.work.check.doc.IPhcPhysicalCompanyService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.service.work.thirdtime.ILiteArchiveTsLinkService;
import cn.smarthse.modules.health.service.work.thirdtime.simple.ITsProjectSimpleService;
import cn.smarthse.modules.health.thirdOrganization.service.org.IThirdOrgQualificationService;
import cn.smarthse.modules.health.vo.litearchive.LiteArchiveFileDetailVo;
import cn.smarthse.modules.health.vo.litearchive.LiteArchiveFileItemArchiveVo;
import cn.smarthse.modules.health.vo.litearchive.LiteArchiveFileItemVo;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.xxl.job.core.context.XxlJobHelper;
import java.lang.invoke.CallSite;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.cn.smarthse.modules.health.exception.HealthException;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StopWatch;
import tk.mybatis.mapper.entity.Example;

@DubboService
public class LiteArchiveFileItemServiceImpl
extends BaseServiceImpl<LiteArchiveFileItemMapper, LiteArchiveFileItem>
implements ILiteArchiveFileItemService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LiteArchiveFileItemServiceImpl.class);
    @Autowired
    @Lazy
    private ILiteArchiveService liteArchiveService;
    @Autowired
    private ILiteArchiveFilePersonalService personalService;
    @DubboReference
    private ISysFileProvideService sysFileProvideService;
    @Autowired
    private Doc2GenerateLiteArchiveFile2 doc2GenerateLiteArchiveFile;
    @Autowired
    private Doc3GenerateLiteArchiveFile doc3Service;
    @Autowired
    private Doc4GenerateLiteArchiveFile doc4Service;
    @Autowired
    private IPhcPhysicalCompanyService phcPhysicalCompanyService;
    @Autowired
    private IPhcPhysicalCheckService phcPhysicalCheckService;
    @DubboReference
    private IThirdOrgQualificationService thirdOrgQualificationService;
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    IPhcPhysicalCheckV3221Service phcPhysicalCheckV3221Service;
    @Autowired
    IReformItemBasicService reformItemBasicService;
    @Autowired
    IStaffBasicInfoService staffBasicInfoService;
    @Autowired
    IStaffInfoService staffInfoService;
    @Autowired
    private LiteArchiveFileItemMapper liteArchiveFileItemMapper;
    @Autowired
    private LiteArchiveMapper archiveMapper;
    @Autowired
    private LiteArchiveFileItemMapper archiveFileItemMapper;
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    @Autowired(required=false)
    @Lazy
    private ILiteArchiveTsLinkService liteArchiveTsLinkService;
    @Autowired
    private ITsProjectSimpleService tsProjectSimpleService;
    @Autowired
    private ILiteArchiveFileNameService fileNameService;
    @Autowired
    private INewComplianceCompanyInfoService complianceCompanyInfoService;
    @DubboReference
    private IBusinessDataUpdateRefreshService businessDataUpdateRefreshService;
    @Autowired
    private RedisClient redisClient;
    @Autowired
    private LiteArchiveFileItemServiceImpl self;
    @Autowired
    @Qualifier(value="liteArchiveFileItemGenerateExecutor")
    private ThreadPoolExecutor liteArchiveFileItemGenerateExecutor;
    private static final String TS_FILE_NAME_TEMPLATE_CACHE = "TsFileNameTemplateCache";
    private static final Long TS_FILE_NAME_TEMPLATE_CACHE_TIME = 86400L;

    public PageInfo<LiteArchiveFileDetailVo> queryDetail(JqGridParam jqGridParam, Long id, Long staffId, Boolean iscompliance) {
        List<LiteArchiveFileDetailVo> detailList;
        LiteArchive archive = (LiteArchive)this.liteArchiveService.getById(id);
        Integer archiveType = archive != null ? archive.getArchiveType() : Integer.valueOf(6);
        if (iscompliance == null) {
            iscompliance = false;
        }
        Page detailPage = PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows());
        if (Objects.equals(iscompliance, true) && archiveType == 1) {
            detailList = ((LiteArchiveFileItemMapper)this.dao).queryComplianceArchiveDetail(id, null, CollUtil.toList((Object[])new Integer[]{1, 11}));
            if (CollectionUtils.isNotEmpty(detailList)) {
                detailList.forEach(d -> d.setUploadStaffName(SpringEncryptUtils.decrypt((String)d.getUploadStaffName())));
            }
        } else {
            detailList = this.queryDetailAndSetUpdateStaffName(id, archiveType);
        }
        if (archiveType == 2 || archiveType == 3 || archiveType == 4) {
            detailList.forEach(item -> item.setExtraJson(archive.getExtraJson()));
        }
        if (archiveType == 5) {
            if (iscompliance != null && iscompliance.booleanValue()) {
                this.setComplianceCompanyArchive5(archive.getCid(), detailList);
            } else {
                this.setArchive5(archive.getCid(), detailList);
            }
        }
        if (archiveType == 6) {
            this.setArchive6(jqGridParam.getCid(), staffId, detailList, iscompliance);
        }
        if (archiveType == 1) {
            if (Objects.equals(iscompliance, true)) {
                this.setComplianceArchive1(archive, detailList);
            } else {
                this.setArchive1(archive, detailList);
            }
        }
        this.setFileModel(detailList, archiveType, archive);
        return new PageInfo((List)detailPage);
    }

    public Map<Long, List<LiteArchiveFileDetailVo>> queryTsArchiveDetailGroup(List<Long> tsArchiveIdList, Boolean iscompliance) {
        List<LiteArchiveFileDetailVo> liteArchiveFileDetailVos;
        if (CollUtil.isEmpty(tsArchiveIdList)) {
            return new HashMap<Long, List<LiteArchiveFileDetailVo>>();
        }
        boolean compliance = Boolean.TRUE.equals(iscompliance);
        String cacheKey = String.format("%s:%s", TS_FILE_NAME_TEMPLATE_CACHE, compliance ? "\u536b\u4f01\u5408\u89c4" : "\u6d59\u91cc\u536b\u4f01");
        List<LiteArchiveFileDetailVo> list2 = liteArchiveFileDetailVos = compliance ? ((LiteArchiveFileItemMapper)this.dao).queryComplianceTsArchiveDetailList(tsArchiveIdList, null, CollUtil.toList((Object[])new Integer[]{1, 11})) : ((LiteArchiveFileItemMapper)this.dao).queryTsArchiveDetailList(tsArchiveIdList);
        if (CollectionUtils.isNotEmpty(liteArchiveFileDetailVos)) {
            for (LiteArchiveFileDetailVo liteArchiveFileDetailVo : liteArchiveFileDetailVos) {
                liteArchiveFileDetailVo.setUploadStaffName(SpringEncryptUtils.decrypt((String)liteArchiveFileDetailVo.getUploadStaffName()));
            }
        }
        Map tsDetailGroup = Optional.ofNullable(liteArchiveFileDetailVos).filter(CollUtil::isNotEmpty).map(list -> list.stream().collect(Collectors.groupingBy(LiteArchiveFileDetailVo::getLiteArchiveId))).orElse(new HashMap());
        List fileNameList = Optional.ofNullable(this.redisClient.get(cacheKey)).map(cacheValue -> (List)cacheValue).orElseGet(() -> {
            Example e = new Example(LiteArchiveFileName.class);
            Example.Criteria c = e.createCriteria().andEqualTo("isValid", (Object)Boolean.TRUE).andIn("archiveType", compliance ? CollUtil.toList((Object[])new Integer[]{1, 11}) : Collections.singletonList(1));
            if (compliance) {
                c.andNotEqualTo("id", (Object)112L);
            }
            List nameList = this.fileNameService.getListByExample(e);
            if (compliance) {
                nameList.forEach(name -> {
                    if (Objects.equals(name.getArchiveType(), 11)) {
                        name.setArchiveType(Integer.valueOf(1));
                    }
                });
            }
            this.redisClient.set(cacheKey, (Object)nameList, TS_FILE_NAME_TEMPLATE_CACHE_TIME.longValue());
            return nameList;
        });
        Map<Long, List<LiteArchiveFileDetailVo>> tsResultDetailGroup = tsArchiveIdList.stream().collect(Collectors.toMap(id -> id, id -> {
            List oneDetailList = tsDetailGroup.getOrDefault(id, new ArrayList());
            return fileNameList.stream().map(fileName -> oneDetailList.stream().filter(d -> Objects.equals(d.getFileNameId(), fileName.getId())).findFirst().orElseGet(() -> this.createDetailVo((Long)id, (LiteArchiveFileName)fileName))).collect(Collectors.toList());
        }, (v1, v2) -> v2));
        if (compliance) {
            this.setComplianceArchive1ByGroup(tsArchiveIdList, tsResultDetailGroup);
        } else {
            this.setArchive1ByGroup(tsArchiveIdList, tsResultDetailGroup);
        }
        return tsResultDetailGroup;
    }

    private LiteArchiveFileDetailVo createDetailVo(Long archiveId, LiteArchiveFileName fileName) {
        LiteArchiveFileDetailVo detail = new LiteArchiveFileDetailVo();
        detail.setLiteArchiveId(archiveId);
        detail.setFileName(fileName.getFileName());
        detail.setTemplatePath(fileName.getTemplatePath());
        detail.setNeedCollect(fileName.getNeedCollect());
        detail.setNeedStorageLocation(fileName.getNeedStorageLocation());
        detail.setFileNameId(fileName.getId());
        detail.setNeedUpload(Convert.toInt((Object)fileName.getNeedUpload()));
        detail.setHgNeedUpload(Convert.toInt((Object)fileName.getHgNeedUpload()));
        detail.setGroupName(fileName.getGroupName());
        detail.setArchiveType(fileName.getArchiveType());
        detail.setTipInfo(fileName.getTipInfo());
        return detail;
    }

    private void setArchive1(LiteArchive archive, List<LiteArchiveFileDetailVo> list) {
        LiteArchiveTsLink archiveTsLink = this.liteArchiveTsLinkService.getTsLinkByArchiveId(archive.getId());
        TsProjectSimple tsProjectSimple = (TsProjectSimple)this.tsProjectSimpleService.getById(archiveTsLink.getTsId());
        if (tsProjectSimple == null || tsProjectSimple.getMissingItem() != null && tsProjectSimple.getMissingItem() == 1) {
            list.forEach(d -> d.setNeedCollect(Boolean.FALSE));
            return;
        }
        list.forEach(item -> {
            item.setNeedCollect(Boolean.valueOf(false));
            if (Objects.nonNull(tsProjectSimple.getProjectFinishTime()) && (TsProjectSimpleStatusEnum.AUDITED.getCode().equals(tsProjectSimple.getStatus()) || TsProjectSimpleStatusEnum.NO_NEED_AUDITED.getCode().equals(tsProjectSimple.getStatus()))) {
                if (item.getFileNameId().equals(104L) && TsProjectSimpleStateEnum.FINISH.getCode().equals(tsProjectSimple.getEvalState())) {
                    item.setNeedCollect(Boolean.valueOf(true));
                }
                if (item.getFileNameId().equals(106L) && TsProjectSimpleStateEnum.FINISH.getCode().equals(tsProjectSimple.getDesignState())) {
                    item.setNeedCollect(Boolean.valueOf(true));
                }
                if (item.getFileNameId().equals(109L) && TsProjectSimpleStateEnum.FINISH.getCode().equals(tsProjectSimple.getControlState())) {
                    item.setNeedCollect(Boolean.valueOf(true));
                }
            }
        });
    }

    private void setArchive1ByGroup(List<Long> archiveIdList, Map<Long, List<LiteArchiveFileDetailVo>> detailGroup) {
        List linkList = this.liteArchiveTsLinkService.getTsLinkByArchiveIdBatch(archiveIdList);
        List tsIdList = linkList.stream().map(LiteArchiveTsLink::getTsId).collect(Collectors.toList());
        String tsIds = tsIdList.stream().map(String::valueOf).collect(Collectors.joining(","));
        List tsList = this.tsProjectSimpleService.getListByIds(tsIds);
        for (Map.Entry<Long, List<LiteArchiveFileDetailVo>> entry : detailGroup.entrySet()) {
            Long archiveId = entry.getKey();
            List<LiteArchiveFileDetailVo> detailList = entry.getValue();
            LiteArchiveTsLink link = linkList.stream().filter(l -> Objects.equals(l.getLiteArchiveId(), archiveId)).findFirst().orElse(null);
            if (link == null) continue;
            TsProjectSimple ts = tsList.stream().filter(t -> Objects.equals(t.getId(), link.getTsId())).findFirst().orElse(null);
            if (ts == null || ts.getMissingItem() != null && ts.getMissingItem() == 1) {
                detailList.forEach(d -> d.setNeedCollect(Boolean.FALSE));
                continue;
            }
            detailList.forEach(item -> {
                item.setNeedCollect(Boolean.FALSE);
                if (ts.getProjectFinishTime() != null && (TsProjectSimpleStatusEnum.AUDITED.getCode().equals(ts.getStatus()) || TsProjectSimpleStatusEnum.NO_NEED_AUDITED.getCode().equals(ts.getStatus()))) {
                    if (item.getFileNameId().equals(104L) && TsProjectSimpleStateEnum.FINISH.getCode().equals(ts.getEvalState())) {
                        item.setNeedCollect(Boolean.TRUE);
                    }
                    if (item.getFileNameId().equals(106L) && TsProjectSimpleStateEnum.FINISH.getCode().equals(ts.getDesignState())) {
                        item.setNeedCollect(Boolean.TRUE);
                    }
                    if (item.getFileNameId().equals(109L) && TsProjectSimpleStateEnum.FINISH.getCode().equals(ts.getControlState())) {
                        item.setNeedCollect(Boolean.TRUE);
                    }
                }
            });
        }
    }

    public void setComplianceArchive1(LiteArchive archive, List<LiteArchiveFileDetailVo> detailList) {
        boolean finish;
        TsProjectSimple ts = this.tsProjectSimpleService.getTsProjectSimpleByArchiveId(archive.getId());
        if (ts == null || ts.getMissingItem() != null && ts.getMissingItem() == 1) {
            detailList.forEach(d -> d.setNeedCollect(Boolean.FALSE));
            return;
        }
        boolean complete = TsProjectSimpleStatusEnum.AUDITED.getCode().equals(ts.getStatus()) || TsProjectSimpleStatusEnum.NO_NEED_AUDITED.getCode().equals(ts.getStatus());
        boolean bl = finish = ts.getProjectFinishTime() != null;
        if (complete && finish) {
            for (LiteArchiveFileDetailVo d2 : detailList) {
                d2.setNeedCollect(Boolean.FALSE);
                Long fileNameId = d2.getFileNameId();
                boolean evalDesignControlRequire = TsProjectSimpleStateEnum.FINISH.getCode().equals(ts.getEvalState()) && CollUtil.toList((Object[])new Long[]{104L, 103L, 105L}).contains(fileNameId) || TsProjectSimpleStateEnum.FINISH.getCode().equals(ts.getDesignState()) && CollUtil.toList((Object[])new Long[]{106L, 107L}).contains(fileNameId) || TsProjectSimpleStateEnum.FINISH.getCode().equals(ts.getControlState()) && CollUtil.toList((Object[])new Long[]{109L, 108L, 110L, 111L, 1120L}).contains(fileNameId);
                boolean completeFinishRequire = CollUtil.toList((Object[])new Long[]{102L, 101L}).contains(fileNameId);
                if (!evalDesignControlRequire && !completeFinishRequire) continue;
                d2.setNeedCollect(Boolean.TRUE);
            }
        } else {
            detailList.forEach(d -> d.setNeedCollect(Boolean.FALSE));
        }
    }

    public void setComplianceArchive1ByGroup(List<Long> archiveIdList, Map<Long, List<LiteArchiveFileDetailVo>> detailGroup) {
        List linkList = this.liteArchiveTsLinkService.getTsLinkByArchiveIdBatch(archiveIdList);
        List tsIdList = linkList.stream().map(LiteArchiveTsLink::getTsId).collect(Collectors.toList());
        String tsIds = tsIdList.stream().map(String::valueOf).collect(Collectors.joining(","));
        List tsList = this.tsProjectSimpleService.getListByIds(tsIds);
        for (Map.Entry<Long, List<LiteArchiveFileDetailVo>> entry : detailGroup.entrySet()) {
            boolean finish;
            Long archiveId = entry.getKey();
            List<LiteArchiveFileDetailVo> detailList = entry.getValue();
            LiteArchiveTsLink link = linkList.stream().filter(l -> Objects.equals(l.getLiteArchiveId(), archiveId)).findFirst().orElse(null);
            if (link == null) continue;
            TsProjectSimple ts = tsList.stream().filter(t -> Objects.equals(t.getId(), link.getTsId())).findFirst().orElse(null);
            if (ts == null || ts.getMissingItem() != null && ts.getMissingItem() == 1) {
                detailList.forEach(d -> d.setNeedCollect(Boolean.FALSE));
                continue;
            }
            boolean complete = TsProjectSimpleStatusEnum.AUDITED.getCode().equals(ts.getStatus()) || TsProjectSimpleStatusEnum.NO_NEED_AUDITED.getCode().equals(ts.getStatus());
            boolean bl = finish = ts.getProjectFinishTime() != null;
            if (complete && finish) {
                for (LiteArchiveFileDetailVo d2 : detailList) {
                    d2.setNeedCollect(Boolean.FALSE);
                    Long fileNameId = d2.getFileNameId();
                    boolean evalDesignControlRequire = TsProjectSimpleStateEnum.FINISH.getCode().equals(ts.getEvalState()) && CollUtil.toList((Object[])new Long[]{104L, 103L, 105L}).contains(fileNameId) || TsProjectSimpleStateEnum.FINISH.getCode().equals(ts.getDesignState()) && CollUtil.toList((Object[])new Long[]{106L, 107L}).contains(fileNameId) || TsProjectSimpleStateEnum.FINISH.getCode().equals(ts.getControlState()) && CollUtil.toList((Object[])new Long[]{109L, 108L, 110L, 111L, 1120L}).contains(fileNameId);
                    boolean completeFinishRequire = CollUtil.toList((Object[])new Long[]{102L, 101L}).contains(fileNameId);
                    if (!evalDesignControlRequire && !completeFinishRequire) continue;
                    d2.setNeedCollect(Boolean.TRUE);
                }
                continue;
            }
            detailList.forEach(d -> d.setNeedCollect(Boolean.FALSE));
        }
    }

    public List<LiteArchiveFileDetailVo> queryDetailAndSetUpdateStaffName(Long id, Integer archiveType) {
        List<LiteArchiveFileDetailVo> list = ((LiteArchiveFileItemMapper)this.dao).queryDetail(id, archiveType);
        if (CollectionUtils.isNotEmpty(list)) {
            for (LiteArchiveFileDetailVo liteArchiveFileDetailVo : list) {
                liteArchiveFileDetailVo.setUploadStaffName(SpringEncryptUtils.decrypt((String)liteArchiveFileDetailVo.getUploadStaffName()));
            }
        }
        return list;
    }

    private void setArchive2(LiteArchive archive, List<LiteArchiveFileDetailVo> list) {
        Long cid;
        CompanySuperviseModel companyInfoById;
        Boolean isDec;
        if (CollectionUtils.isNotEmpty(list) && Objects.equals(isDec = (companyInfoById = this.companyProvideBySuperviseService.getCompanyInfoById(cid = archive.getCid())).getIsDec(), true)) {
            for (LiteArchiveFileDetailVo liteArchiveFileDetailVo : list) {
                if (liteArchiveFileDetailVo.getFileNameId().equals(206L)) {
                    liteArchiveFileDetailVo.setNeedCollect(Boolean.valueOf(false));
                }
                if (liteArchiveFileDetailVo.getFileNameId().equals(201L)) {
                    List fileIds = CommonUtil.str2LongList((String)liteArchiveFileDetailVo.getFileIds());
                    List referFileIds = CommonUtil.str2LongList((String)liteArchiveFileDetailVo.getReferFileIds());
                    ArrayList allList = new ArrayList();
                    allList.addAll(fileIds);
                    allList.addAll(referFileIds);
                    liteArchiveFileDetailVo.setFileIds(cn.smarthse.util.common.StringUtils.join(allList, (String)","));
                    liteArchiveFileDetailVo.setNeedCollect(Boolean.valueOf(false));
                }
                if (liteArchiveFileDetailVo.getNeedCollect() == null) {
                    liteArchiveFileDetailVo.setNeedCollect(Boolean.valueOf(false));
                }
                if (liteArchiveFileDetailVo.getSort() != null) continue;
                liteArchiveFileDetailVo.setSort(Integer.valueOf(10));
            }
            List listtemp = list.stream().sorted(Comparator.comparing(LiteArchiveFileDetailVo::getNeedCollect, Comparator.reverseOrder()).thenComparing(LiteArchiveFileDetailVo::getSort)).collect(Collectors.toList());
            list.clear();
            list.addAll(listtemp);
        }
    }

    private void setArchive3(LiteArchive archive, List<LiteArchiveFileDetailVo> list) {
        assert (archive != null);
        list.forEach(item -> {
            if (Objects.equals(302L, item.getFileNameId())) {
                item.setNeedUpload(Integer.valueOf(0));
                Long certId = this.liteArchiveService.checkCertStaffValidDataByYear(archive.getTitle(), archive.getCid());
                if (certId != null) {
                    item.setDataState(Integer.valueOf(1));
                }
            }
            if (Objects.equals(303L, item.getFileNameId())) {
                Collections.swap(list, 1, 2);
            }
            if (Objects.equals(304L, item.getFileNameId())) {
                item.setNeedCollect(Boolean.valueOf(false));
            }
        });
    }

    private void setComplianceCompanyArchive5(Long cid, List<LiteArchiveFileDetailVo> list) {
        PhcPhysicalStatisticsModel model = new PhcPhysicalStatisticsModel();
        List phcPhysicalStatisticsModels = this.phcPhysicalCheckV3221Service.queryCompliancePhysical5Data(Arrays.asList(cid), Integer.valueOf(DateUtil.getYear() - 2));
        if (CollectionUtils.isNotEmpty((Collection)phcPhysicalStatisticsModels)) {
            model = (PhcPhysicalStatisticsModel)phcPhysicalStatisticsModels.get(0);
        }
        PhcPhysicalStatisticsModel finalModel = model;
        list.forEach(item -> {
            if (item.getFileNameId().equals(502L) || item.getFileNameId().equals(504L) || item.getFileNameId().equals(503L)) {
                item.setNeedCollect(Boolean.valueOf(true));
            } else if (finalModel.getNumberOfYszyb() > 0 && (item.getFileNameId().equals(505L) || item.getFileNameId().equals(506L))) {
                item.setNeedCollect(Boolean.valueOf(true));
            } else {
                item.setNeedCollect(Boolean.valueOf(false));
            }
        });
        this.setDataStateTextTips(cid, list, model, false);
    }

    private void setArchive5(Long cid, List<LiteArchiveFileDetailVo> list) {
        PhcPhysicalCheckSearchVo vo = new PhcPhysicalCheckSearchVo();
        vo.setCid(cid);
        vo.setYear(Integer.valueOf(0));
        PhcPhysicalStatisticsModel model = this.phcPhysicalCheckV3221Service.getStatisticsModel(vo);
        list.forEach(item -> {
            if (item.getFileNameId().equals(502L) || item.getFileNameId().equals(504L)) {
                item.setNeedCollect(Boolean.valueOf(true));
            } else if (model.getNumberOfYszyb() > 0 && item.getFileNameId().equals(505L)) {
                item.setNeedCollect(Boolean.valueOf(true));
            } else {
                item.setNeedCollect(Boolean.valueOf(false));
            }
        });
        this.setDataStateTextTips(cid, list, model, true);
    }

    private void setDataStateTextTips(Long cid, List<LiteArchiveFileDetailVo> list, PhcPhysicalStatisticsModel model, boolean riskAcc) {
        if (model.getNumberOfCheck() > 0) {
            list.forEach(item -> {
                if (item.getFileNameId().equals(502L) || item.getFileNameId().equals(504L)) {
                    item.setDataState(Integer.valueOf(1));
                    item.setContent("\u53bb\u67e5\u770b");
                    item.setJumpUrl("/work/newCheck/toIndex");
                    item.setReference(" ");
                }
            });
        } else if (riskAcc) {
            List archiveData = this.reformItemBasicService.getArchiveData(cid, ReformGenerationSourceEnum.TJ);
            if (CollectionUtils.isNotEmpty((Collection)archiveData)) {
                ReformItemBasic finish = archiveData.stream().filter(item -> item.getStatus().equals(ReformStatusEnum.WC.getValue())).findFirst().orElse(null);
                if (finish != null) {
                    list.forEach(item -> {
                        if (item.getFileNameId().equals(502L) || item.getFileNameId().equals(504L)) {
                            item.setDataState(Integer.valueOf(1));
                            item.setContent("\u53bb\u67e5\u770b");
                            item.setJumpUrl("/riskResolution/riskInfo?id=" + finish.getId());
                            item.setReference(" ");
                        }
                    });
                } else {
                    list.forEach(item -> {
                        if (item.getFileNameId().equals(502L) || item.getFileNameId().equals(504L)) {
                            item.setDataState(Integer.valueOf(0));
                            item.setContent("\u53bb\u8865\u5145");
                            item.setJumpUrl("/riskResolution/riskInfo?id=" + ((ReformItemBasic)archiveData.get(0)).getId());
                            item.setReference("\u8bf7\u6309\u7167\u300a\u804c\u4e1a\u75c5\u9632\u6cbb\u6cd5\u300b\u8981\u6c42\u5f00\u5c55\u804c\u4e1a\u5065\u5eb7\u68c0\u67e5\u5de5\u4f5c\u3002");
                        }
                    });
                }
            } else {
                list.forEach(item -> {
                    if (item.getFileNameId().equals(502L) || item.getFileNameId().equals(504L)) {
                        item.setReference("\u8bf7\u6309\u7167\u300a\u804c\u4e1a\u75c5\u9632\u6cbb\u6cd5\u300b\u8981\u6c42\u5f00\u5c55\u804c\u4e1a\u5065\u5eb7\u68c0\u67e5\u5de5\u4f5c\u3002");
                    }
                });
            }
        } else {
            list.forEach(item -> {
                if (item.getFileNameId().equals(502L) || item.getFileNameId().equals(504L)) {
                    item.setDataState(Integer.valueOf(0));
                    item.setReference("\u8bf7\u6309\u7167\u300a\u804c\u4e1a\u75c5\u9632\u6cbb\u6cd5\u300b\u8981\u6c42\u5f00\u5c55\u804c\u4e1a\u5065\u5eb7\u68c0\u67e5\u5de5\u4f5c\u3002");
                }
            });
        }
        list.forEach(item -> {
            if (item.getFileNameId().equals(505L)) {
                item.setDataState(Integer.valueOf(1));
                item.setContent("\u53bb\u67e5\u770b");
                item.setJumpUrl("/work/newCheck/toYszybList");
                item.setReference(" ");
            }
            if (item.getFileNameId().equals(506L) || item.getFileNameId().equals(503L)) {
                item.setDataState(Integer.valueOf(cn.smarthse.util.common.StringUtils.isNotEmpty((String)item.getFileIds()) ? 1 : 0));
            }
        });
    }

    private void setArchive6(Long cid, Long staffId, List<LiteArchiveFileDetailVo> list, Boolean iscompliance) {
        StaffBasicInfo staffBasicInfo;
        List reformList = Optional.ofNullable((List)this.personalService.get603reformMap(Collections.singletonList(cid), Boolean.valueOf(true), iscompliance).get(cid)).orElse(new ArrayList());
        Map reformCompleteMap = reformList.stream().filter(item -> item != null && Arrays.asList((byte)3, (byte)4).contains(item.getStatus())).collect(Collectors.toMap(ReformItemBasic::getCid, Function.identity(), (v1, v2) -> v1.getFindTime().getTime() >= v2.getFindTime().getTime() ? v1 : v2));
        Map reformUnCompleteMap = reformList.stream().filter(item -> item != null && !Arrays.asList((byte)3, (byte)4, (byte)10).contains(item.getStatus())).collect(Collectors.toMap(ReformItemBasic::getCid, Function.identity(), (v1, v2) -> v1.getFindTime().getTime() >= v2.getFindTime().getTime() ? v1 : v2));
        List checkPlanList = Optional.ofNullable((List)this.personalService.get602checkPlanMap(Collections.singletonList(cid), iscompliance).get(cid)).orElse(new ArrayList());
        Map phcPhysMap = new HashMap();
        StaffInfo staffInfo = (StaffInfo)this.staffInfoService.getById(staffId);
        String idCard = "";
        if (staffInfo != null && (staffBasicInfo = (StaffBasicInfo)this.staffBasicInfoService.getById(staffInfo.getStaffBasicId())) != null && cn.smarthse.util.common.StringUtils.isNotBlank((CharSequence)staffBasicInfo.getIdCard())) {
            idCard = staffBasicInfo.getIdCard();
            phcPhysMap = Optional.ofNullable((Map)this.personalService.get603phcPhysList(Collections.singletonList(cid), Collections.singletonList(idCard), iscompliance).get(cid)).orElse(new HashMap());
        }
        for (LiteArchiveFileDetailVo item2 : list) {
            if (item2.getFileNameId().equals(601L)) {
                item2.setDataState(Integer.valueOf(1));
                item2.setReference(" ");
                item2.setNeedUpload(Integer.valueOf(0));
            }
            if (item2.getFileNameId().equals(602L)) {
                if (Objects.equals(iscompliance, true)) {
                    item2.setNeedCollect(Boolean.valueOf(true));
                }
                if (CollectionUtils.isNotEmpty((Collection)checkPlanList)) {
                    item2.setDataState(Integer.valueOf(1));
                    item2.setContent("\u53bb\u67e5\u770b");
                    item2.setJumpUrl("/work/hccheckplan/HcCheckPlan/getHcCheckPlanResultStatPage");
                    item2.setReference(" ");
                } else {
                    item2.setDataState(Integer.valueOf(0));
                    item2.setReference("\u8bf7\u6309\u7167\u300a\u804c\u4e1a\u75c5\u9632\u6cbb\u6cd5\u300b\u8981\u6c42\u5f00\u5c55\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u5b9a\u671f\u68c0\u6d4b\u5de5\u4f5c\u3002");
                }
            }
            if (!item2.getFileNameId().equals(603L)) continue;
            if (Objects.equals(iscompliance, true)) {
                if (MapUtils.isNotEmpty(phcPhysMap)) {
                    item2.setDataState(Integer.valueOf(1));
                    item2.setContent("\u53bb\u67e5\u770b");
                    item2.setJumpUrl("/base/staff/staffInfo/getStaffInfoPage?staffId=" + staffId);
                    item2.setReference(" ");
                    continue;
                }
                item2.setDataState(Integer.valueOf(0));
                item2.setReference("\u8bf7\u6309\u7167\u300a\u804c\u4e1a\u75c5\u9632\u6cbb\u6cd5\u300b\u8981\u6c42\u5f00\u5c55\u804c\u4e1a\u5065\u5eb7\u68c0\u67e5\u5de5\u4f5c\u3002");
                continue;
            }
            if (MapUtils.isNotEmpty(phcPhysMap)) {
                item2.setDataState(Integer.valueOf(1));
                item2.setContent("\u53bb\u67e5\u770b");
                item2.setJumpUrl("/base/staff/staffInfo/getStaffInfoPage?staffId=" + staffId);
                item2.setReference(" ");
                continue;
            }
            if (reformCompleteMap.get(cid) != null) {
                item2.setDataState(Integer.valueOf(1));
                item2.setContent("\u53bb\u67e5\u770b");
                item2.setJumpUrl("/riskResolution/riskInfo?id=" + ((ReformItemBasic)reformCompleteMap.get(cid)).getId());
                item2.setReference(" ");
                continue;
            }
            if (reformUnCompleteMap.get(cid) != null) {
                item2.setDataState(Integer.valueOf(0));
                item2.setContent("\u53bb\u8865\u5145");
                item2.setJumpUrl("/riskResolution/riskInfo?id=" + ((ReformItemBasic)reformUnCompleteMap.get(cid)).getId());
                item2.setReference("\u8bf7\u6309\u7167\u300a\u804c\u4e1a\u75c5\u9632\u6cbb\u6cd5\u300b\u8981\u6c42\u5f00\u5c55\u804c\u4e1a\u5065\u5eb7\u68c0\u67e5\u5de5\u4f5c\u3002");
                continue;
            }
            item2.setDataState(Integer.valueOf(0));
            item2.setReference("\u8bf7\u6309\u7167\u300a\u804c\u4e1a\u75c5\u9632\u6cbb\u6cd5\u300b\u8981\u6c42\u5f00\u5c55\u804c\u4e1a\u5065\u5eb7\u68c0\u67e5\u5de5\u4f5c\u3002");
        }
    }

    public List<LiteArchiveFileDetailVo> queryDetailList(Long id) {
        LiteArchive archive = (LiteArchive)this.liteArchiveService.getById(id);
        List<LiteArchiveFileDetailVo> list = this.queryDetailAndSetUpdateStaffName(id, archive.getArchiveType());
        return list;
    }

    public List<LiteArchiveFileDetailVo> queryDetailList(Long id, Boolean isCompliance) {
        LiteArchive archive = (LiteArchive)this.liteArchiveService.getById(id);
        List<LiteArchiveFileDetailVo> list = this.queryDetailAndSetUpdateStaffName(id, archive.getArchiveType());
        if (archive.getArchiveType() == 5) {
            if (isCompliance.booleanValue()) {
                this.setComplianceCompanyArchive5(archive.getCid(), list);
            } else {
                this.setArchive5(archive.getCid(), list);
            }
        }
        return list;
    }

    public List<LiteArchiveFileDetailVo> queryComplianceTsDetailList(Long id) {
        if (id == null) {
            return Collections.emptyList();
        }
        return ((LiteArchiveFileItemMapper)this.dao).queryComplianceArchiveDetail(id, null, CollUtil.toList((Object[])new Integer[]{1, 11}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(readOnly=false)
    public Long updateArchiveFiles(ArchiveFileItemUpdateParam param) {
        Long archiveId = param.getArchiveId();
        String lockKey = "LiteArchiveFileItemServiceImpl:updateArchiveFiles:" + archiveId + "::hot";
        RLock lock = this.redissonClient.getLock(lockKey);
        if (lock.tryLock()) {
            try {
                Long itemId = param.getItemId();
                if (itemId == null || itemId <= 0L) {
                    itemId = this.exist(param.getArchiveId(), param.getFileNameId());
                }
                if (itemId != null) {
                    param.setItemId(itemId);
                    if (param.getFileIds() == null || param.getFileIds().isEmpty()) {
                        ((LiteArchiveFileItemMapper)this.dao).updateFileIdsInComplete(param);
                    } else {
                        ((LiteArchiveFileItemMapper)this.dao).updateFileIds(param);
                    }
                } else {
                    LiteArchiveFileItem item = new LiteArchiveFileItem();
                    item.setFileIds(param.getFileIds());
                    item.setLiteArchiveId(param.getArchiveId());
                    item.setFileNameId(param.getFileNameId());
                    if (cn.smarthse.util.common.StringUtils.isNotBlank((CharSequence)param.getFileIds())) {
                        item.setUploadStaffId(param.getStaffId());
                        item.setUploadDate(new Date());
                    }
                    item.setIsValid(Boolean.valueOf(true));
                    item.setCreateDate(new Date());
                    item.setUpdateDate(new Date());
                    item.setUpdateBy(param.getStaffId());
                    item.setCreateBy(param.getStaffId());
                    this.add(item);
                    itemId = item.getId();
                }
                LiteArchive archive = (LiteArchive)this.liteArchiveService.getById(param.getArchiveId());
                if (Objects.equals(archive.getArchiveType(), 2) || Objects.equals(archive.getArchiveType(), 3) || Objects.equals(archive.getArchiveType(), 4)) {
                    this.liteArchiveService.mutilArchiveUpdateStatus(List.of(archive), Set.of(archive.getCid()));
                } else {
                    this.liteArchiveService.updateStatus(param.getArchiveId());
                }
                HashMap<CallSite, String> params = new HashMap<CallSite, String>();
                if (archive != null && archive.getArchiveType() != null) {
                    params.put((CallSite)((Object)(ComplianceCodeEnum.CODE14.getCode() + ":archiveTypeStr")), archive.getArchiveType().toString());
                    this.businessDataUpdateRefreshService.addBusinessDataUpdateMsg(archive.getCid(), params, new ComplianceCodeEnum[]{ComplianceCodeEnum.CODE14});
                }
                Long l = itemId;
                return l;
            }
            catch (Exception e) {
                this.logger.error("\u751f\u6210\u6863\u6848\u51fa\u9519\uff1a{}", (Throwable)e);
            }
            finally {
                lock.unlock();
            }
        } else {
            this.logger.error("autoCreateYearArchive \u65b9\u6cd5\u672a\u83b7\u5f97\u9501\u8d44\u6e90");
        }
        return null;
    }

    @Transactional(readOnly=false)
    public int delArchiveFiles(Long archiveId, Long staffId) {
        Example e = new Example(LiteArchiveFileItem.class);
        e.createCriteria().andEqualTo("liteArchiveId", (Object)archiveId).andEqualTo("isValid", (Object)true);
        LiteArchiveFileItem result = new LiteArchiveFileItem();
        result.setIsValid(Boolean.valueOf(false));
        result.setUpdateBy(staffId);
        result.setUpdateDate(new Date());
        return ((LiteArchiveFileItemMapper)this.dao).updateByExampleSelective(result, e);
    }

    public Integer countByArchive(Long archiveId) {
        return ((LiteArchiveFileItemMapper)this.dao).countByArchive(archiveId);
    }

    public Map<Long, Integer> archiveUploadNum() {
        List<LiteArchiveUploadCount> counts = ((LiteArchiveFileItemMapper)this.dao).archiveUploadNum();
        HashMap<Long, Integer> map = new HashMap<Long, Integer>();
        for (LiteArchiveUploadCount count : counts) {
            map.put(count.getLiteArchiveId(), count.getNum());
        }
        return map;
    }

    public void autoCreateFileItems(LiteArchive archive) {
        try {
            this.autoCreateFileItems(archive, null);
        }
        catch (Exception e) {
            this.logger.error("\u6863\u6848\u751f\u6210\u51fa\u9519:", (Throwable)e);
        }
    }

    public void handRefreshAchiveV2(List<LiteArchive> archives, Set<Long> complianceCids, String fileNamdIds, Boolean forceUpdateFile, Boolean async) {
        if (CollectionUtils.isEmpty(archives)) {
            return;
        }
        Map<Integer, Map<String, List<LiteArchive>>> archiveTypeYearMap = archives.stream().filter(f -> cn.smarthse.util.common.StringUtils.isNotBlank((CharSequence)f.getTitle()) && f.getArchiveType() != null).collect(Collectors.groupingBy(LiteArchive::getArchiveType, Collectors.groupingBy(LiteArchive::getTitle)));
        for (Integer archiveType : archiveTypeYearMap.keySet()) {
            Map<String, List<LiteArchive>> archiveYearMap = archiveTypeYearMap.get(archiveType);
            for (String year : archiveYearMap.keySet()) {
                if ("2023\u5e74\u4ee5\u524d".equals(year)) {
                    int n = 2022;
                }
                if (!NumberUtil.isNumber((CharSequence)year)) {
                    this.logger.error("\u6863\u6848\u6570\u636etitle\u9519\u8bef\uff1a{}", (Object)year);
                    continue;
                }
                int yearInt = Integer.parseInt(year);
                this.callarchiveService(archiveYearMap.get(year), yearInt, archiveType, complianceCids, fileNamdIds, forceUpdateFile, async);
            }
        }
    }

    private void logProgress(int yearInt, Integer archiveType, Boolean async, int totalNum, int remaining, long jobId) {
        if (jobId > 0L) {
            int processed = totalNum - remaining;
            double progress = totalNum > 0 ? (double)processed / (double)totalNum * 100.0 : 0.0;
            String logMsg = String.format("\u6863\u6848\u9879\u5237\u65b0\u8fdb\u5ea6\uff1a\u5e74\u4efd=%d\uff0c\u7c7b\u578b=%d\uff0c\u8fdb\u5ea6=%.1f%%\uff0c\u5df2\u5904\u7406=%d\uff0c\u5269\u4f59=%d", yearInt, archiveType, progress, processed, remaining);
            XxlJobHelper.log((String)logMsg, (Object[])new Object[0]);
        }
    }

    public void callarchiveService(List<LiteArchive> liteArchives, int yearInt, Integer archiveType, Set<Long> complianceCids, String fileNamdIds, Boolean forceUpdateFile, Boolean async) {
        if (CollectionUtils.isEmpty(liteArchives)) {
            return;
        }
        int totalNum = liteArchives.size();
        AtomicInteger remainingCount = new AtomicInteger(totalNum);
        long jobId = XxlJobHelper.getJobId();
        if (jobId > 0L) {
            log.error("\u6863\u6848\u9879\u5237\u65b0\u4fe1\u606f\uff1a\u5e74\u4efd={}\uff0c \u6863\u6848\u7c7b\u578b={}\uff0c async={}, \u603b\u6570={}", new Object[]{yearInt, archiveType, async, totalNum});
            XxlJobHelper.log((String)"\u6863\u6848\u9879\u5237\u65b0\u4fe1\u606f\uff1a\u5e74\u4efd={}\uff0c \u6863\u6848\u7c7b\u578b={}\uff0c async={}, \u603b\u6570={}", (Object[])new Object[]{yearInt, archiveType, async, totalNum});
        }
        int partSize = 1000;
        for (List liteArchiveList : ListUtil.partition(liteArchives, (int)partSize)) {
            try {
                if (Objects.equals(async, true)) {
                    this.liteArchiveFileItemGenerateExecutor.execute(() -> {
                        try {
                            this.docallarchiveService(liteArchiveList, yearInt, archiveType, complianceCids, fileNamdIds, forceUpdateFile);
                        }
                        finally {
                            int newRemaining = remainingCount.addAndGet(-liteArchiveList.size());
                            this.logProgress(yearInt, archiveType, async, totalNum, newRemaining, jobId);
                        }
                    });
                    continue;
                }
                this.docallarchiveService(liteArchiveList, yearInt, archiveType, complianceCids, fileNamdIds, forceUpdateFile);
                int newRemaining = remainingCount.addAndGet(-liteArchiveList.size());
                this.logProgress(yearInt, archiveType, async, totalNum, newRemaining, jobId);
            }
            catch (Exception e) {
                this.logger.error("\u6863\u6848\u6279\u91cf\u5904\u7406\u5931\u8d25:{}", (Throwable)e);
            }
        }
    }

    public void docallarchiveService(List<LiteArchive> liteArchiveList, int yearInt, Integer archiveType, Set<Long> complianceCids, String fileNamdIds, Boolean forceUpdateFile) {
        switch (archiveType) {
            case 2: {
                this.doc2GenerateLiteArchiveFile.doCreateFileItemListV2(liteArchiveList, yearInt, complianceCids, fileNamdIds);
                break;
            }
            case 3: {
                this.doc3Service.doCreateFileItemListv2(liteArchiveList, yearInt, complianceCids, fileNamdIds);
                break;
            }
            case 4: {
                this.doc4Service.autoCreateFileItems4CheckPlanv2(liteArchiveList, yearInt, complianceCids, fileNamdIds, forceUpdateFile);
                break;
            }
            case 5: {
                for (LiteArchive archive : liteArchiveList) {
                    this.removeOldFromSystem(archive.getId());
                    this.phcPhysicalCompanyService.generatorLiteArchive(archive, fileNamdIds);
                }
                break;
            }
        }
    }

    public void autoCreateFileItems(LiteArchive archive, String fileNamdIds) {
        switch (archive.getArchiveType()) {
            case 1: {
                break;
            }
            case 2: {
                this.doc2GenerateLiteArchiveFile.doCreateFileItemList(archive, fileNamdIds);
                break;
            }
            case 3: {
                this.doc3Service.doCreateFileItemList(archive, fileNamdIds);
                break;
            }
            case 4: {
                this.doc4Service.autoCreateFileItems4CheckPlan(archive, fileNamdIds);
                break;
            }
            case 5: {
                this.removeOldFromSystem(archive.getId());
                this.phcPhysicalCompanyService.generatorLiteArchive(archive, fileNamdIds);
                break;
            }
        }
    }

    public void autoRefreshCreateFileItems(Long liteArchiveId) {
        LiteArchive liteArchive = (LiteArchive)this.liteArchiveService.getById(liteArchiveId);
        if (liteArchive == null) {
            return;
        }
        liteArchive.setUpdateDate(new Date());
        this.liteArchiveService.update((Object)liteArchive);
        Integer archiveType = liteArchive.getArchiveType();
        if (Objects.equals(archiveType, 2) || Objects.equals(archiveType, 3) || Objects.equals(archiveType, 4)) {
            Set complinceCidSet = this.complianceCompanyInfoService.getSubmitComplianceCidSet(List.of(liteArchive.getCid()));
            this.handRefreshAchiveV2(List.of(liteArchive), complinceCidSet, null, true, false);
        } else {
            this.autoCreateFileItems(liteArchive);
        }
        LiteArchive procFinish = new LiteArchive();
        procFinish.setId(liteArchiveId);
        procFinish.setProcStatus(Integer.valueOf(0));
        procFinish.setArchiveUpdateTime(new Date());
        this.liteArchiveService.update((Object)procFinish);
        HashMap<CallSite, String> params = new HashMap<CallSite, String>();
        params.put((CallSite)((Object)(ComplianceCodeEnum.CODE14.getCode() + ":archiveTypeStr")), archiveType == null ? null : archiveType.toString());
        this.businessDataUpdateRefreshService.addBusinessDataUpdateMsg(liteArchive.getCid(), params, new ComplianceCodeEnum[]{ComplianceCodeEnum.CODE14});
    }

    @Transactional(readOnly=false)
    public void updateArchiveFileItemStatus(LiteArchive liteArchive) {
        StopWatch sw = new StopWatch();
        sw.start("\u6863\u6848\uff1a" + liteArchive.getId() + "\u5f00\u59cb\u66f4\u65b0");
        this.liteArchiveService.updateStatus(liteArchive.getId());
        sw.stop();
        this.logger.info("\u5355\u4e2a\u6863\u6848\uff1a{}\u72b6\u6001\u5904\u7406\u66f4\u65b0\u5b8c\u6210, \u8017\u65f6\uff1a{}s, \u5904\u7406\u4efb\u52a1\u7ebf\u7a0b\uff1a{}", new Object[]{liteArchive.getId(), sw.getTotalTimeSeconds(), Thread.currentThread().getName()});
    }

    public void removeOldFromSystem(Long liteArchiveId) {
        Example example = new Example(LiteArchiveFileItem.class);
        example.createCriteria().andEqualTo("liteArchiveId", (Object)liteArchiveId);
        List list = this.getListByExample(example);
        StringBuilder sb = new StringBuilder();
        for (LiteArchiveFileItem item : list) {
            String fileIds;
            String referFileIds = item.getReferFileIds();
            if (referFileIds == null || referFileIds.isEmpty() || cn.smarthse.util.common.StringUtils.isBlank((CharSequence)(fileIds = item.getFileIds())) && cn.smarthse.util.common.StringUtils.isBlank((CharSequence)referFileIds)) continue;
            if (cn.smarthse.util.common.StringUtils.isNotBlank((CharSequence)fileIds)) {
                String[] ids;
                for (String id : ids = fileIds.split(",")) {
                    if (referFileIds.contains(id)) continue;
                    sb.append(id);
                    sb.append(",");
                }
            }
            if (sb.length() > 0) {
                item.setFileIds(sb.substring(0, sb.length()));
            } else {
                item.setFileIds("");
            }
            item.setReferFileIds("");
            this.update(item);
            sb.delete(0, sb.length());
        }
    }

    @Transactional
    public void batchRemoveOldFromSystem(List<LiteArchiveFileItem> list) {
        List LiteArchiveIdList = list.stream().filter(item -> item != null && item.getLiteArchiveId() != null && item.getFileNameId() != null).map(LiteArchiveFileItem::getLiteArchiveId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(LiteArchiveIdList)) {
            return;
        }
        Date date = new Date();
        Example example = new Example(LiteArchiveFileItem.class);
        example.createCriteria().andIn("liteArchiveId", LiteArchiveIdList).andEqualTo("isValid", (Object)1);
        Map dbFileItemMap = this.getListByExample(example).stream().filter(item -> item != null && item.getFileNameId() != null).collect(Collectors.groupingBy(LiteArchiveFileItem::getLiteArchiveId, Collectors.toMap(LiteArchiveFileItem::getFileNameId, Function.identity(), (k1, k2) -> k1.getUpdateDate().getTime() >= k2.getUpdateDate().getTime() ? k1 : k2)));
        ArrayList<LiteArchiveFileItem> updateList = new ArrayList<LiteArchiveFileItem>();
        for (LiteArchiveFileItem archiveFileItem : list) {
            String fileIds;
            Map itemMap;
            if (archiveFileItem == null || archiveFileItem.getLiteArchiveId() == null || archiveFileItem.getFileNameId() == null || (itemMap = dbFileItemMap.get(archiveFileItem.getLiteArchiveId())).isEmpty() || itemMap.get(archiveFileItem.getFileNameId()) == null) continue;
            LiteArchiveFileItem item2 = (LiteArchiveFileItem)itemMap.get(archiveFileItem.getFileNameId());
            StringBuilder sb = new StringBuilder();
            String referFileIds = item2.getReferFileIds();
            if (referFileIds == null || referFileIds.isEmpty() || cn.smarthse.util.common.StringUtils.isBlank((CharSequence)(fileIds = item2.getFileIds())) && cn.smarthse.util.common.StringUtils.isBlank((CharSequence)referFileIds)) continue;
            if (cn.smarthse.util.common.StringUtils.isNotBlank((CharSequence)fileIds)) {
                String[] ids;
                for (String id : ids = fileIds.split(",")) {
                    if (referFileIds.contains(id)) continue;
                    sb.append(id);
                    sb.append(",");
                }
            }
            if (sb.length() > 0) {
                item2.setFileIds(sb.substring(0, sb.length()));
            } else {
                item2.setFileIds("");
            }
            item2.setReferFileIds("");
            item2.setUpdateBy(archiveFileItem.getUpdateBy());
            item2.setUpdateDate(date);
            updateList.add(item2);
            sb.delete(0, sb.length());
        }
        if (CollectionUtils.isNotEmpty(updateList)) {
            this.batchUpdateOrInsert(updateList, LiteArchiveFileItemMapper.class, (item, mapper) -> mapper.updateByPrimaryKeySelective(item));
        }
    }

    public Long exist(Long archiveId, Long fileNameId) {
        if (archiveId == null) {
            log.error("\u6863\u6848\u67e5\u8be2\u5fc5\u586b\u9879\u53c2\u6570\u4e3a\u7a7a, fileNameId={}", (Object)fileNameId);
            throw new HealthException("\u6863\u6848\u67e5\u8be2\u5fc5\u586b\u9879\u53c2\u6570\u4e3a\u7a7a");
        }
        Example example = new Example(LiteArchiveFileItem.class);
        example.createCriteria().andEqualTo("liteArchiveId", (Object)archiveId).andEqualTo("fileNameId", (Object)fileNameId).andEqualTo("isValid", (Object)true);
        List list = this.getListByExample(example);
        if (list != null && !list.isEmpty()) {
            return ((LiteArchiveFileItem)list.get(0)).getId();
        }
        return null;
    }

    public LiteArchiveFileItem getByArchiveAndFileName(Long archiveId, Long fileNameId) {
        Example example = new Example(LiteArchiveFileItem.class);
        example.createCriteria().andEqualTo("liteArchiveId", (Object)archiveId).andEqualTo("fileNameId", (Object)fileNameId).andEqualTo("isValid", (Object)true);
        List list = this.getListByExample(example);
        if (list != null && !list.isEmpty()) {
            return (LiteArchiveFileItem)list.get(0);
        }
        return null;
    }

    public List<LiteArchiveFileItem> getByArchiveAndFileName(List<Long> archiveIds, Long fileNameId) {
        if (CollectionUtils.isEmpty(archiveIds)) {
            return null;
        }
        Example example = new Example(LiteArchiveFileItem.class);
        example.createCriteria().andIn("liteArchiveId", archiveIds).andEqualTo("fileNameId", (Object)fileNameId).andEqualTo("isValid", (Object)true);
        List<LiteArchiveFileItem> list = this.getListByExample(example);
        return list;
    }

    public List<LiteArchiveFileItem> listFileItemByType(Long archiveId, Integer archiveType) {
        if (archiveId == null || archiveType == null) {
            return null;
        }
        return ((LiteArchiveFileItemMapper)this.dao).listFileItemByType(archiveId, archiveType);
    }

    @Transactional(readOnly=false)
    public void appendFilesNotUpdateState(Long archiveId, Long fileNameId, String fileIds, String referFileIds, ArchiveFilteItemDataStateEnum dataState) {
        ((ILiteArchiveFileItemService)SpringContextHolder.getBean(ILiteArchiveFileItemService.class)).appendFilesNotUpdateState(archiveId, fileNameId, fileIds, referFileIds, dataState, null);
    }

    @Transactional(readOnly=false)
    public void appendFilesNotUpdateState(Long archiveId, Long fileNameId, String fileIds, String referFileIds, ArchiveFilteItemDataStateEnum dataState, String jumpUrl) {
        this.logger.info("\u8ffd\u52a0\u9644\u4ef6:archiveId\uff1a{},fileNameId\uff1a{},fileIds\uff1a{}", new Object[]{archiveId, fileNameId, fileIds});
        if (archiveId == null || fileNameId == null) {
            this.logger.error("\u5fc5\u586b\u9879\u53c2\u6570\u9519\u8bef:archiveId\uff1a{},fileNameId\uff1a{}", (Object)archiveId, (Object)fileNameId);
            return;
        }
        this.doAppendFilesNotUpdateState(archiveId, fileNameId, fileIds, referFileIds, dataState, jumpUrl);
    }

    @Transactional(readOnly=false)
    public void doAppendFilesNotUpdateState(Long archiveId, Long fileNameId, String fileIds, String referFileIds, ArchiveFilteItemDataStateEnum dataState, String jumpUrl) {
        LiteArchiveFileItem o = this.getByArchiveAndFileName(archiveId, fileNameId);
        if (o != null) {
            if (cn.smarthse.util.common.StringUtils.isNotBlank((CharSequence)fileIds)) {
                if (cn.smarthse.util.common.StringUtils.isNotBlank((CharSequence)o.getFileIds())) {
                    o.setFileIds(o.getFileIds() + "," + fileIds);
                } else {
                    o.setFileIds(fileIds);
                }
            }
            if (cn.smarthse.util.common.StringUtils.isNotBlank((CharSequence)referFileIds)) {
                if (cn.smarthse.util.common.StringUtils.isNotBlank((CharSequence)o.getReferFileIds())) {
                    o.setReferFileIds(o.getReferFileIds() + "," + referFileIds);
                } else {
                    o.setReferFileIds(referFileIds);
                }
            }
            if (dataState != null) {
                o.setDataState(dataState.getValue());
            }
            if (cn.smarthse.util.common.StringUtils.isNotBlank((CharSequence)jumpUrl)) {
                o.setJumpUrl(jumpUrl);
            }
            this.update(o);
        } else {
            LiteArchiveFileItem item = new LiteArchiveFileItem();
            if (cn.smarthse.util.common.StringUtils.isNotBlank((CharSequence)fileIds)) {
                item.setFileIds(fileIds);
            }
            if (cn.smarthse.util.common.StringUtils.isNotBlank((CharSequence)referFileIds)) {
                item.setReferFileIds(referFileIds);
            }
            if (cn.smarthse.util.common.StringUtils.isNotBlank((CharSequence)jumpUrl)) {
                item.setJumpUrl(jumpUrl);
            }
            item.setLiteArchiveId(archiveId);
            item.setFileNameId(fileNameId);
            item.setIsValid(Boolean.valueOf(true));
            item.setCreateDate(new Date());
            item.setUpdateDate(new Date());
            item.setUpdateBy(Long.valueOf(0L));
            item.setCreateBy(Long.valueOf(0L));
            if (dataState != null) {
                item.setDataState(dataState.getValue());
            }
            this.add(item);
        }
    }

    @Transactional
    public void batchAppendFileItem(List<LiteArchiveFileItem> list) {
        List LiteArchiveIdList = list.stream().filter(item -> item != null && item.getLiteArchiveId() != null && item.getFileNameId() != null).map(LiteArchiveFileItem::getLiteArchiveId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(LiteArchiveIdList)) {
            return;
        }
        Date date = new Date();
        Example example = new Example(LiteArchiveFileItem.class);
        example.createCriteria().andIn("liteArchiveId", LiteArchiveIdList).andEqualTo("isValid", (Object)1);
        Map dbFileItemMap = this.getListByExample(example).stream().filter(item -> item != null && item.getFileNameId() != null).collect(Collectors.groupingBy(LiteArchiveFileItem::getLiteArchiveId, Collectors.toMap(LiteArchiveFileItem::getFileNameId, Function.identity(), (k1, k2) -> k1.getUpdateDate().getTime() >= k2.getUpdateDate().getTime() ? k1 : k2)));
        ArrayList<LiteArchiveFileItem> updateList = new ArrayList<LiteArchiveFileItem>();
        ArrayList<LiteArchiveFileItem> addList = new ArrayList<LiteArchiveFileItem>();
        for (LiteArchiveFileItem archiveFileItem : list) {
            if (archiveFileItem == null || archiveFileItem.getLiteArchiveId() == null || archiveFileItem.getFileNameId() == null) continue;
            Map itemMap = dbFileItemMap.get(archiveFileItem.getLiteArchiveId());
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(itemMap) || itemMap.get(archiveFileItem.getFileNameId()) == null) {
                archiveFileItem.setId(Long.valueOf(this.idworker.nextId()));
                archiveFileItem.setIsValid(Boolean.valueOf(true));
                archiveFileItem.setCreateDate(date);
                archiveFileItem.setUpdateDate(date);
                archiveFileItem.setUpdateBy(archiveFileItem.getUpdateBy());
                archiveFileItem.setCreateBy(archiveFileItem.getUpdateBy());
                addList.add(archiveFileItem);
                continue;
            }
            LiteArchiveFileItem item2 = (LiteArchiveFileItem)itemMap.get(archiveFileItem.getFileNameId());
            if (cn.smarthse.util.common.StringUtils.isNotBlank((CharSequence)archiveFileItem.getFileIds())) {
                if (cn.smarthse.util.common.StringUtils.isNotBlank((CharSequence)item2.getFileIds())) {
                    item2.setFileIds(item2.getFileIds() + "," + archiveFileItem.getFileIds());
                } else {
                    item2.setFileIds(archiveFileItem.getFileIds());
                }
            }
            if (cn.smarthse.util.common.StringUtils.isNotBlank((CharSequence)archiveFileItem.getReferFileIds())) {
                if (cn.smarthse.util.common.StringUtils.isNotBlank((CharSequence)item2.getReferFileIds())) {
                    item2.setReferFileIds(item2.getReferFileIds() + "," + archiveFileItem.getReferFileIds());
                } else {
                    item2.setReferFileIds(archiveFileItem.getReferFileIds());
                }
            }
            if (archiveFileItem.getDataState() != null) {
                item2.setDataState(archiveFileItem.getDataState());
            }
            if (archiveFileItem.getHgDataState() != null) {
                item2.setHgDataState(archiveFileItem.getHgDataState());
            }
            if (cn.smarthse.util.common.StringUtils.isNotBlank((CharSequence)archiveFileItem.getJumpUrl())) {
                item2.setJumpUrl(archiveFileItem.getJumpUrl());
            }
            if (cn.smarthse.util.common.StringUtils.isNotBlank((CharSequence)archiveFileItem.getStorageLocation())) {
                item2.setStorageLocation(archiveFileItem.getStorageLocation());
            }
            updateList.add(item2);
        }
        if (CollectionUtils.isNotEmpty(addList)) {
            ((LiteArchiveFileItemMapper)this.dao).insertList2(addList);
        }
        if (CollectionUtils.isNotEmpty(updateList)) {
            this.batchUpdateOrInsert(updateList, LiteArchiveFileItemMapper.class, (item, mapper) -> mapper.updateByPrimaryKeySelective(item));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(readOnly=false)
    public void appendFileItem(Long archiveId, Long fileNameId, String fileIds, String referFileIds, Consumer<LiteArchiveFileItem> consumer) {
        this.logger.info("\u8ffd\u52a0\u9644\u4ef6:archiveId\uff1a{},fileNameId\uff1a{},fileIds\uff1a{}", new Object[]{archiveId, fileNameId, fileIds});
        if (archiveId == null || fileNameId == null) {
            this.logger.error("\u5fc5\u586b\u9879\u53c2\u6570\u9519\u8bef:archiveId\uff1a{},fileNameId\uff1a{}", (Object)archiveId, (Object)fileNameId);
            return;
        }
        String lockKey = "appendFileItem:" + archiveId + ":" + fileNameId + "hot";
        RLock lock = this.redissonClient.getLock(lockKey);
        try {
            if (lock.tryLock(5L, TimeUnit.SECONDS)) {
                this.doAppendFileItem(archiveId, fileNameId, fileIds, referFileIds, consumer);
            }
        }
        catch (Exception e) {
            this.logger.error("\u751f\u6210\u6863\u6848\u51fa\u9519\uff08\u6216\u8d85\u65f6\uff09\uff1a{}", (Throwable)e);
        }
        finally {
            lock.unlock();
        }
    }

    @Transactional(readOnly=false)
    public void doAppendFileItem(Long archiveId, Long fileNameId, String fileIds, String referFileIds, Consumer<LiteArchiveFileItem> consumer) {
        LiteArchiveFileItem o = this.getByArchiveAndFileName(archiveId, fileNameId);
        if (o != null) {
            if (cn.smarthse.util.common.StringUtils.isNotBlank((CharSequence)fileIds)) {
                if (cn.smarthse.util.common.StringUtils.isNotBlank((CharSequence)o.getFileIds())) {
                    o.setFileIds(o.getFileIds() + "," + fileIds);
                } else {
                    o.setFileIds(fileIds);
                }
            }
            if (cn.smarthse.util.common.StringUtils.isNotBlank((CharSequence)referFileIds)) {
                if (cn.smarthse.util.common.StringUtils.isNotBlank((CharSequence)o.getReferFileIds())) {
                    o.setReferFileIds(o.getReferFileIds() + "," + referFileIds);
                } else {
                    o.setReferFileIds(referFileIds);
                }
            }
            consumer.accept(o);
            this.update(o);
        } else {
            LiteArchiveFileItem item = new LiteArchiveFileItem();
            if (cn.smarthse.util.common.StringUtils.isNotBlank((CharSequence)fileIds)) {
                item.setFileIds(fileIds);
            }
            if (cn.smarthse.util.common.StringUtils.isNotBlank((CharSequence)referFileIds)) {
                item.setReferFileIds(referFileIds);
            }
            item.setLiteArchiveId(archiveId);
            item.setFileNameId(fileNameId);
            item.setIsValid(Boolean.valueOf(true));
            item.setCreateDate(new Date());
            item.setUpdateDate(new Date());
            item.setUpdateBy(Long.valueOf(0L));
            item.setCreateBy(Long.valueOf(0L));
            consumer.accept(o);
            this.add(item);
        }
    }

    public void mergeFileItemInfo(List<LiteArchiveFileItem> dbFileItemList, LiteArchiveFileItem newFileItem) {
        if (CollectionUtils.isNotEmpty(dbFileItemList)) {
            Set allfileid = dbFileItemList.stream().map(l -> CommonUtil.str2LongSet((String)l.getFileIds(), (String)",")).flatMap(Collection::stream).collect(Collectors.toSet());
            Set allreferFileIds = dbFileItemList.stream().map(l -> CommonUtil.str2LongSet((String)l.getReferFileIds(), (String)",")).flatMap(Collection::stream).collect(Collectors.toSet());
            List storageLocation = dbFileItemList.stream().filter(f -> cn.smarthse.util.common.StringUtils.isNotBlank((CharSequence)f.getStorageLocation())).map(LiteArchiveFileItem::getStorageLocation).collect(Collectors.toList());
            allfileid.addAll(CommonUtil.str2LongSet((String)newFileItem.getFileIds(), (String)","));
            allreferFileIds.addAll(CommonUtil.str2LongSet((String)newFileItem.getReferFileIds(), (String)","));
            storageLocation.add(newFileItem.getStorageLocation());
            newFileItem.setFileIds(cn.smarthse.util.common.StringUtils.join(allfileid, (String)","));
            newFileItem.setReferFileIds(cn.smarthse.util.common.StringUtils.join(allreferFileIds, (String)","));
            newFileItem.setStorageLocation(cn.smarthse.util.common.StringUtils.join(allreferFileIds, (String)","));
        }
    }

    public void batchAppendFileItem(List<LiteArchiveFileItem> newList, Long archiveId, Integer archiveType, Long loginId) {
        this.logger.info("batchAppendFileItem\u8ffd\u52a0\u9644\u4ef6:archiveId\uff1a{},archiveType\uff1a{}", (Object)archiveId, (Object)archiveType);
        if (archiveId == null || archiveType == null) {
            this.logger.error("\u5fc5\u586b\u9879\u53c2\u6570\u9519\u8bef:archiveId\uff1a{},archiveType\uff1a{}", (Object)archiveId, (Object)archiveType);
            return;
        }
        this.doBatchAppendFileItem(newList, archiveId, archiveType, loginId);
    }

    public void doBatchAppendFileItem(List<LiteArchiveFileItem> newList, Long archiveId, Integer archiveType, Long loginId) {
        List<LiteArchiveFileItem> dbList = this.listFileItemByType(archiveId, archiveType);
        ArrayList needDelFileList = new ArrayList();
        ArrayList<LiteArchiveFileItem> needDelLiteArchiveFileItem = new ArrayList<LiteArchiveFileItem>();
        if (CollectionUtils.isNotEmpty(dbList)) {
            Map<Long, List<LiteArchiveFileItem>> fileNameIdLit = dbList.stream().collect(Collectors.groupingBy(LiteArchiveFileItem::getFileNameId));
            for (LiteArchiveFileItem newFileItem : newList) {
                List<LiteArchiveFileItem> dbFileItemList = fileNameIdLit.get(newFileItem.getFileNameId());
                if (!CollectionUtils.isNotEmpty(dbFileItemList)) continue;
                Set dbfielids = dbFileItemList.stream().map(LiteArchiveFileItem::getFileIds).filter(CharSequenceUtil::isNotBlank).flatMap(ids -> Arrays.stream(cn.smarthse.util.common.StringUtils.splitByWholeSeparator((String)ids, (String)","))).filter(CharSequenceUtil::isNotBlank).filter(s -> NumberUtil.isNumber((CharSequence)s)).map(Long::valueOf).collect(Collectors.toSet());
                Set dbreferFielids = dbFileItemList.stream().map(LiteArchiveFileItem::getReferFileIds).filter(CharSequenceUtil::isNotBlank).flatMap(ids -> Arrays.stream(cn.smarthse.util.common.StringUtils.splitByWholeSeparator((String)ids, (String)","))).filter(CharSequenceUtil::isNotBlank).filter(s -> NumberUtil.isNumber((CharSequence)s)).map(Long::valueOf).collect(Collectors.toSet());
                LiteArchiveFileItem dbdata = dbFileItemList.get(0);
                newFileItem.setId(dbdata.getId());
                Set newFields = CommonUtil.str2LongSetMore((String)",", (String[])new String[]{newFileItem.getFileIds()});
                Collection needDelCollect = CollectionUtils.removeAll(dbreferFielids, (Collection)newFields);
                if (CollectionUtils.isNotEmpty((Collection)needDelCollect)) {
                    needDelFileList.addAll(needDelCollect);
                    dbfielids.removeAll(dbreferFielids);
                }
                newFields.addAll(dbfielids);
                newFileItem.setFileIds(cn.smarthse.util.common.StringUtils.join((Iterable)newFields, (String)","));
                if (dbFileItemList.size() <= 1) continue;
                for (int i = 1; i < dbFileItemList.size(); ++i) {
                    LiteArchiveFileItem liteArchiveFileItem = dbFileItemList.get(i);
                    liteArchiveFileItem.setIsValid(Boolean.valueOf(false));
                    liteArchiveFileItem.setUpdateDate(new Date());
                    needDelLiteArchiveFileItem.add(liteArchiveFileItem);
                }
                this.logger.error("\u6863\u6848\u9644\u4ef6\u5f02\u5e38\u4e86\uff0c \u51fa\u73b0\u4e86\u591a\u6761\u6863\u6848\u9644\u4ef6\u6570\u636e, LiteArchiveId:{}", (Object)newFileItem.getLiteArchiveId());
            }
        }
        ListUtil.partition(needDelFileList, (int)1000).forEach(dellist -> this.sysFileProvideService.updateRecycleFlag(Integer.valueOf(3), dellist));
        this.batchUpdateOrInsert(newList, LiteArchiveFileItemMapper.class, (item, mapper) -> {
            if (item.getId() == null) {
                item.setId(Long.valueOf(this.idworker.nextId()));
                item.setIsValid(Boolean.valueOf(true));
                item.setCreateBy(loginId);
                item.setCreateDate(new Date());
                return mapper.insertSelective(item);
            }
            item.setUpdateBy(loginId);
            item.setUpdateDate(new Date());
            return mapper.updateByPrimaryKeySelective(item);
        });
        this.batchUpdateOrInsert(needDelLiteArchiveFileItem, LiteArchiveFileItemMapper.class, (item, mapper) -> {
            if (item.getId() != null) {
                item.setUpdateBy(loginId);
                item.setUpdateDate(new Date());
                return mapper.updateByPrimaryKeySelective(item);
            }
            return 0;
        });
    }

    public void batchAppendFileItemMutilArchive(List<LiteArchiveFileItem> newList, Long loginId) {
        if (CollectionUtils.isEmpty(newList)) {
            return;
        }
        List<Long> archiveIds = newList.stream().map(LiteArchiveFileItem::getLiteArchiveId).distinct().collect(Collectors.toList());
        List<LiteArchiveFileItem> dbFileItemList = ((LiteArchiveFileItemMapper)this.dao).selectCompletedItemByArchiveId(archiveIds);
        HashMap dbArchiveIdFileNameIdItemMap = dbFileItemList == null ? new HashMap() : dbFileItemList.stream().collect(Collectors.groupingBy(LiteArchiveFileItem::getLiteArchiveId, Collectors.groupingBy(LiteArchiveFileItem::getFileNameId)));
        Map<Long, List<LiteArchiveFileItem>> newArchiveId4FileItemMap = newList.stream().collect(Collectors.groupingBy(LiteArchiveFileItem::getLiteArchiveId));
        ArrayList<Long> needDelFileList = new ArrayList<Long>();
        ArrayList<LiteArchiveFileItem> needDelLiteArchiveFileItem = new ArrayList<LiteArchiveFileItem>();
        for (Long archiveId : newArchiveId4FileItemMap.keySet()) {
            List<LiteArchiveFileItem> newLiteArchiveFileItems = newArchiveId4FileItemMap.get(archiveId);
            Map dbLiteArchiveFileIdItemMaps = (Map)dbArchiveIdFileNameIdItemMap.get(archiveId);
            if (MapUtils.isEmpty((Map)dbLiteArchiveFileIdItemMaps)) continue;
            for (LiteArchiveFileItem newFileItem : newLiteArchiveFileItems) {
                List dbLiteArchiveFileItems = (List)dbLiteArchiveFileIdItemMaps.get(newFileItem.getFileNameId());
                if (!CollectionUtils.isNotEmpty((Collection)dbLiteArchiveFileItems)) continue;
                Set dbfielids = dbLiteArchiveFileItems.stream().map(LiteArchiveFileItem::getFileIds).filter(CharSequenceUtil::isNotBlank).flatMap(ids -> Arrays.stream(cn.smarthse.util.common.StringUtils.splitByWholeSeparator((String)ids, (String)","))).filter(CharSequenceUtil::isNotBlank).filter(s -> NumberUtil.isNumber((CharSequence)s)).map(Long::valueOf).collect(Collectors.toSet());
                Set dbreferFielids = dbLiteArchiveFileItems.stream().map(LiteArchiveFileItem::getReferFileIds).filter(CharSequenceUtil::isNotBlank).flatMap(ids -> Arrays.stream(cn.smarthse.util.common.StringUtils.splitByWholeSeparator((String)ids, (String)","))).filter(CharSequenceUtil::isNotBlank).filter(s -> NumberUtil.isNumber((CharSequence)s)).map(Long::valueOf).collect(Collectors.toSet());
                LiteArchiveFileItem dbdata = (LiteArchiveFileItem)dbLiteArchiveFileItems.get(0);
                newFileItem.setId(dbdata.getId());
                Set newFields = CommonUtil.str2LongSetMore((String)",", (String[])new String[]{newFileItem.getFileIds()});
                Collection needDelCollect = CollectionUtils.removeAll(dbreferFielids, (Collection)newFields);
                if (CollectionUtils.isNotEmpty((Collection)needDelCollect)) {
                    needDelFileList.addAll(needDelCollect);
                    dbfielids.removeAll(dbreferFielids);
                }
                newFields.addAll(dbfielids);
                if (CollectionUtils.isNotEmpty((Collection)newFields)) {
                    newFileItem.setFileIds(cn.smarthse.util.common.StringUtils.join((Iterable)newFields, (String)","));
                }
                if (dbLiteArchiveFileItems.size() <= 1) continue;
                for (int i = 1; i < dbLiteArchiveFileItems.size(); ++i) {
                    LiteArchiveFileItem liteArchiveFileItem = (LiteArchiveFileItem)dbLiteArchiveFileItems.get(i);
                    liteArchiveFileItem.setIsValid(Boolean.valueOf(false));
                    liteArchiveFileItem.setUpdateBy(Long.valueOf(7790L));
                    liteArchiveFileItem.setUpdateDate(new Date());
                    needDelLiteArchiveFileItem.add(liteArchiveFileItem);
                }
                this.logger.error("\u6863\u6848\u9644\u4ef6\u5f02\u5e38\u4e86\uff0c \u51fa\u73b0\u4e86\u591a\u6761\u6863\u6848\u9644\u4ef6\u6570\u636e, LiteArchiveId:{}", (Object)newFileItem.getLiteArchiveId());
            }
        }
        this.self.dobatchAppendFileItemMutilArchive(newList, needDelFileList, needDelLiteArchiveFileItem, loginId);
    }

    @Transactional(readOnly=false)
    public void dobatchAppendFileItemMutilArchive(List<LiteArchiveFileItem> newList, List<Long> needDelFileList, List<LiteArchiveFileItem> needDelLiteArchiveFileItem, Long loginId) {
        ListUtil.partition(needDelFileList, (int)1000).forEach(dellist -> this.sysFileProvideService.updateRecycleFlag(Integer.valueOf(3), dellist));
        this.batchUpdateOrInsert(needDelLiteArchiveFileItem, LiteArchiveFileItemMapper.class, (item, mapper) -> {
            if (item.getId() != null) {
                item.setUpdateBy(loginId);
                item.setUpdateDate(new Date());
                return mapper.updateByPrimaryKeySelective(item);
            }
            return 0;
        });
        if (CollectionUtils.isEmpty(newList)) {
            return;
        }
        List<LiteArchiveFileItem> updateList = newList.stream().filter(f -> f.getId() != null).collect(Collectors.toList());
        List<LiteArchiveFileItem> addList = newList.stream().filter(f -> f.getId() == null).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(updateList)) {
            ((LiteArchiveFileItemMapper)this.dao).batchUpdateFileItem(updateList);
        }
        if (CollectionUtils.isNotEmpty(addList)) {
            addList.forEach(item -> {
                item.setId(Long.valueOf(this.idworker.nextId()));
                item.setIsValid(Boolean.valueOf(true));
            });
            ((LiteArchiveFileItemMapper)this.dao).insertList2(addList);
        }
    }

    @Transactional(readOnly=false)
    public void updateStorageLocation(LiteArchiveFileItem item, Long loginStaffId) {
        if (item.getId() != null) {
            if (cn.smarthse.util.common.StringUtils.isNotBlank((CharSequence)item.getStorageLocation())) {
                this.update(item, loginStaffId);
            } else {
                item = (LiteArchiveFileItem)this.getById(item.getId());
                item.setStorageLocation(null);
                this.updateByPrimaryKey(item, loginStaffId);
            }
        } else {
            LiteArchiveFileItem byArchiveAndFileName = this.getByArchiveAndFileName(item.getLiteArchiveId(), item.getFileNameId());
            if (byArchiveAndFileName != null) {
                item.setUploadStaffId(loginStaffId);
                item.setUploadDate(new Date());
                this.update(item, loginStaffId);
            } else {
                item.setUploadDate(new Date());
                item.setUploadStaffId(loginStaffId);
                this.add(item, loginStaffId, null);
            }
        }
        this.liteArchiveService.newUpdateStatus(item.getLiteArchiveId(), true);
    }

    public List<LiteArchiveFileItem> getDoc5ListByLiteArchiveId(Long liteArchiveId, Integer year) {
        Example e = new Example(LiteArchiveFileItem.class);
        e.createCriteria().andEqualTo("liteArchiveId", (Object)liteArchiveId).andEqualTo("isValid", (Object)true);
        List<LiteArchiveFileItem> list = this.getListByExample(e);
        return list;
    }

    public List<LiteArchiveFileItem> getByArchiveId(Long archiveId) {
        Example e = new Example(LiteArchiveFileItem.class);
        e.createCriteria().andEqualTo("liteArchiveId", (Object)archiveId).andEqualTo("isValid", (Object)true);
        return this.getListByExample(e);
    }

    public List<LiteArchiveFileItemVo> getListByLiteArchiveIds(List<Long> ids, Integer archiveType) {
        return ((LiteArchiveFileItemMapper)this.dao).getListByLiteArchiveIds(ids, archiveType);
    }

    @Transactional(readOnly=false)
    public void saveBatch(List<LiteArchiveFileItem> list) {
        this.batchUpdateOrInsert(list, LiteArchiveFileItemMapper.class, (item, mapper) -> mapper.insertSelective(item));
    }

    public LiteArchiveFileItem getLiteArchiveIdAndFileIds(Long cid, Integer year) {
        LiteArchiveFileItem archiveId = ((LiteArchiveFileItemMapper)this.dao).getLiteArchiveId(cid, year);
        if (archiveId == null) {
            return null;
        }
        LiteArchiveFileItem archiveFileItem = ((LiteArchiveFileItemMapper)this.dao).getFileIdsByLiteArchiveId(archiveId.getLiteArchiveId(), 202L);
        if (archiveFileItem != null && archiveFileItem.getLiteArchiveId() != null) {
            return archiveFileItem;
        }
        return archiveId;
    }

    private void setFileModel(List<LiteArchiveFileDetailVo> list, Integer archiveType, LiteArchive archive) {
        HashSet allFileIdSet = new HashSet();
        list.forEach(item -> {
            Set fileIdSet = CommonUtil.str2LongSet((String)item.getFileIds(), (String)",");
            if (archive != null && Long.valueOf(501L).equals(item.getFileNameId())) {
                int year = LocalDateTime.now().getYear();
                List thirdOrgIds = this.phcPhysicalCheckService.getThirdOrgIdByYear(archive.getCid(), year);
                String qualificationFileIds = this.thirdOrgQualificationService.getHealthCheckQualificationFileIdsByOrgIds(thirdOrgIds);
                item.setReferFileIds(qualificationFileIds);
            }
            Set referfileIdSet = CommonUtil.str2LongSet((String)item.getReferFileIds(), (String)",");
            allFileIdSet.addAll(fileIdSet);
            allFileIdSet.addAll(referfileIdSet);
        });
        if (CollectionUtils.isEmpty(allFileIdSet)) {
            return;
        }
        String sb = cn.smarthse.util.common.StringUtils.join(allFileIdSet, (String)",");
        List files = this.sysFileProvideService.getListByIds(sb);
        if (CollectionUtils.isNotEmpty((Collection)files)) {
            for (SysFileModel file : files) {
                for (LiteArchiveFileDetailVo detailVo : list) {
                    detailVo.setArchiveType(archiveType);
                    if (cn.smarthse.util.common.StringUtils.isNotBlank((CharSequence)detailVo.getFileIds()) && detailVo.getFileIds().contains("" + file.getId())) {
                        detailVo.getFileList().add(file);
                    }
                    if (!cn.smarthse.util.common.StringUtils.isNotBlank((CharSequence)detailVo.getReferFileIds()) || !detailVo.getReferFileIds().contains("" + file.getId())) continue;
                    detailVo.getReferFileList().add(file);
                }
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void mergeData() {
        Map<Long, List<LiteArchiveFileItem>> dataMap;
        Long[][] margeFileNameIdArr = new Long[][]{{204L, 205L}, {212L, 213L, 214L, 215L}};
        List<LiteArchiveFileItem> mergeFileItemList = ((LiteArchiveFileItemMapper)this.dao).getMergeFileItemList();
        if (CollectionUtils.isNotEmpty(mergeFileItemList) && MapUtils.isNotEmpty(dataMap = mergeFileItemList.stream().collect(Collectors.groupingBy(g -> g.getLiteArchiveId())))) {
            ArrayList fristList = new ArrayList();
            dataMap.forEach((k, v) -> {
                for (Long[] margeFileNameId : margeFileNameIdArr) {
                    LiteArchiveFileItem first;
                    Long mergeId = margeFileNameId[0];
                    if (!CollectionUtils.isNotEmpty((Collection)v) || (first = (LiteArchiveFileItem)v.stream().filter(f -> Objects.equals(f.getFileNameId(), mergeId)).findFirst().orElse(null)) == null) continue;
                    List liteArchiveFileItems = v.stream().filter(f -> {
                        for (int i = 0; i < margeFileNameId.length; ++i) {
                            if (!Objects.equals(f.getFileNameId(), margeFileNameId[i])) continue;
                            return true;
                        }
                        return false;
                    }).collect(Collectors.toList());
                    Set allfileid = liteArchiveFileItems.stream().map(l -> CommonUtil.str2LongSet((String)l.getFileIds(), (String)",")).flatMap(Collection::stream).collect(Collectors.toSet());
                    Set allreferFileIds = liteArchiveFileItems.stream().map(l -> CommonUtil.str2LongSet((String)l.getReferFileIds(), (String)",")).flatMap(Collection::stream).collect(Collectors.toSet());
                    List storageLocation = liteArchiveFileItems.stream().filter(f -> cn.smarthse.util.common.StringUtils.isNotBlank((CharSequence)f.getStorageLocation())).map(LiteArchiveFileItem::getStorageLocation).collect(Collectors.toList());
                    StringBuffer locations = new StringBuffer("");
                    storageLocation.stream().forEach(f -> {
                        if (locations.toString().indexOf((String)f) == -1) {
                            if (cn.smarthse.util.common.StringUtils.isNotBlank((CharSequence)locations.toString())) {
                                locations.append(",");
                            }
                            locations.append((String)f);
                        }
                    });
                    first.setFileIds(cn.smarthse.util.common.StringUtils.join(allfileid, (String)","));
                    first.setReferFileIds(cn.smarthse.util.common.StringUtils.join(allreferFileIds, (String)","));
                    first.setStorageLocation(locations.toString());
                    LiteArchiveFileItem maxFileItem = liteArchiveFileItems.stream().filter(f -> f.getUploadDate() != null).max(Comparator.comparing(x -> x.getUploadDate())).orElse(null);
                    if (maxFileItem != null) {
                        first.setUploadStaffId(maxFileItem.getUploadStaffId());
                        first.setUploadDate(maxFileItem.getUploadDate());
                    }
                    fristList.add(first);
                }
            });
            if (CollectionUtils.isNotEmpty(fristList)) {
                this.batchUpdateOrInsert(fristList, LiteArchiveFileItemMapper.class, (item, m) -> m.updateByPrimaryKey(item));
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void mergeYearData() {
        List<LiteArchiveFileItemArchiveVo> mergeFileItemList = ((LiteArchiveFileItemMapper)this.dao).getMergeYearFileItemList();
        LiteArchive result = new LiteArchive();
        result.setIsValid(Boolean.valueOf(false));
        result.setUpdateBy(Long.valueOf(110L));
        result.setUpdateDate(new Date());
        Example e = new Example(LiteArchive.class);
        e.createCriteria().andEqualTo("isValid", (Object)true).andIn("title", Arrays.asList("2023\u5e74\u4ee5\u524d")).andIn("archiveType", Arrays.asList(2, 3, 4));
        this.archiveMapper.updateByExampleSelective(result, e);
        if (CollectionUtils.isNotEmpty(mergeFileItemList)) {
            this.logger.error("mergeFileItemList size:{}", (Object)mergeFileItemList.size());
            Map<String, List<LiteArchiveFileItemArchiveVo>> dataMap = mergeFileItemList.stream().collect(Collectors.groupingBy(g -> StringUtils.concatStr((String)"-", (String[])new String[]{"" + g.getCid(), "" + g.getArchiveType()})));
            if (MapUtils.isNotEmpty(dataMap)) {
                ArrayList fristList = new ArrayList();
                ArrayList archiveList = new ArrayList();
                ArrayList addarchiveList = new ArrayList();
                dataMap.forEach((k, v) -> {
                    if (CollectionUtils.isNotEmpty((Collection)v)) {
                        LiteArchiveFileItem uploadItem = v.stream().filter(f -> f.getUploadDate() != null).max(Comparator.comparing(x -> x.getUploadDate())).orElse(null);
                        LiteArchive archive2023 = new LiteArchive();
                        archive2023.setTitle("2023\u5e74\u4ee5\u524d");
                        archive2023.setArchiveType(((LiteArchiveFileItemArchiveVo)v.get(0)).getArchiveType());
                        archive2023.setCid(((LiteArchiveFileItemArchiveVo)v.get(0)).getCid());
                        archive2023.setArchiveUpdateTime(uploadItem == null ? new Date() : uploadItem.getUploadDate());
                        archive2023.setId(Long.valueOf(this.idworker.nextId()));
                        archive2023.setIsValid(Boolean.valueOf(true));
                        addarchiveList.add(archive2023);
                        this.logger.error("\u6dfb\u52a0\u65b0\u76842023\u5e74\u4ee5\u524d\u6863\u6848 id:{}, cid:{}", (Object)archive2023.getId(), (Object)((LiteArchiveFileItemArchiveVo)v.get(0)).getCid());
                        Map<Long, List<LiteArchiveFileItemArchiveVo>> fileNameIdMapList = v.stream().collect(Collectors.groupingBy(g -> g.getFileNameId()));
                        if (MapUtils.isNotEmpty(fileNameIdMapList)) {
                            LiteArchive finalArchive202 = archive2023;
                            fileNameIdMapList.forEach((nameIdKey, nameIdV) -> {
                                LiteArchiveFileItem first = new LiteArchiveFileItem();
                                first.setId(Long.valueOf(this.idworker.nextId()));
                                first.setFileNameId(nameIdKey);
                                first.setLiteArchiveId(finalArchive202.getId());
                                Set allfileid = nameIdV.stream().map(l -> CommonUtil.str2LongSet((String)l.getFileIds(), (String)",")).flatMap(Collection::stream).collect(Collectors.toSet());
                                Set allreferFileIds = nameIdV.stream().map(l -> CommonUtil.str2LongSet((String)l.getReferFileIds(), (String)",")).flatMap(Collection::stream).collect(Collectors.toSet());
                                List storageLocation = nameIdV.stream().map(LiteArchiveFileItem::getStorageLocation).collect(Collectors.toList());
                                StringBuffer locations = new StringBuffer("");
                                storageLocation.stream().forEach(f -> {
                                    if (cn.smarthse.util.common.StringUtils.isNotBlank((CharSequence)f) && locations.toString().indexOf((String)f) == -1) {
                                        if (cn.smarthse.util.common.StringUtils.isNotBlank((CharSequence)locations.toString())) {
                                            locations.append(",");
                                        }
                                        locations.append((String)f);
                                    }
                                });
                                first.setFileIds(cn.smarthse.util.common.StringUtils.join(allfileid, (String)","));
                                first.setReferFileIds(cn.smarthse.util.common.StringUtils.join(allreferFileIds, (String)","));
                                first.setStorageLocation(locations.toString());
                                LiteArchiveFileItem maxFileItem = nameIdV.stream().filter(f -> f.getUploadDate() != null).max(Comparator.comparing(x -> x.getUploadDate())).orElse(null);
                                if (maxFileItem != null) {
                                    first.setUploadStaffId(maxFileItem.getUploadStaffId());
                                    first.setUploadDate(maxFileItem.getUploadDate());
                                }
                                first.setIsValid(Boolean.valueOf(true));
                                fristList.add(first);
                            });
                        }
                        v.stream().filter(f -> f.getLiteArchiveId() != null).map(LiteArchiveFileItem::getLiteArchiveId).forEach(a -> {
                            LiteArchive delArchive = new LiteArchive();
                            delArchive.setId(a);
                            delArchive.setIsValid(Boolean.valueOf(false));
                            delArchive.setUpdateDate(new Date());
                            delArchive.setUpdateBy(Long.valueOf(110L));
                            archiveList.add(delArchive);
                        });
                    }
                });
                this.logger.error("\u65b0\u589e\u6863\u6848\u6570\u636earchiveList :{}", (Object)archiveList.size());
                if (CollectionUtils.isNotEmpty(addarchiveList)) {
                    ListUtils.partition(addarchiveList, (int)1000).forEach(l -> this.archiveMapper.insertList2((List)l));
                }
                this.logger.error("\u9700\u5165\u5e93LiteArchiveFileItem\u6570\u636e :{}", (Object)fristList.size());
                if (CollectionUtils.isNotEmpty(fristList)) {
                    ListUtils.partition(fristList, (int)1000).forEach(l -> this.archiveFileItemMapper.insertList2((List)l));
                }
                this.logger.error("\u5220\u9664\u6863\u6848\u6570\u636earchiveList :{}", (Object)archiveList.size());
                if (CollectionUtils.isNotEmpty(archiveList)) {
                    this.liteArchiveService.batchUpdateOrInsert(archiveList, LiteArchiveMapper.class, (item, m) -> m.updateByPrimaryKeySelective(item));
                }
            }
        }
        Example e2 = new Example(LiteArchive.class);
        e2.createCriteria().andEqualTo("isValid", (Object)true).andIn("title", Arrays.asList("2021\u5e74\u4ee5\u524d", "2022", "2021")).andIn("archiveType", Arrays.asList(2, 3, 4));
        this.archiveMapper.updateByExampleSelective(result, e2);
    }

    @Transactional(readOnly=false, rollbackFor={Exception.class})
    public void judgeAndUpdateArchiveFilteItemDataState(ArchiveFileItemUpdateParam param, List<Long> fileNameIdList) {
        List<Long> fileNameIds = Arrays.asList(104L, 105L, 106L, 107L, 109L, 110L, 102L);
        if (param != null && param.getArchiveId() != null) {
            Long archiveId = param.getArchiveId();
            Long fileNameId = param.getFileNameId();
            if (!fileNameIds.contains(fileNameId)) {
                return;
            }
            Example example = new Example(LiteArchiveFileItem.class);
            example.createCriteria().andEqualTo("liteArchiveId", (Object)archiveId);
            List LiteArchiveFileItemList = this.getListByExample(example);
            ArrayList<LiteArchiveFileItem> itemParamList = new ArrayList<LiteArchiveFileItem>(16);
            LiteArchiveFileItemList = fileNameIdList.contains(fileNameId) ? LiteArchiveFileItemList.stream().filter(a -> fileNameId.equals(a.getFileNameId())).collect(Collectors.toList()) : LiteArchiveFileItemList;
            for (LiteArchiveFileItem item : LiteArchiveFileItemList) {
                if (!fileNameIdList.contains(item.getFileNameId())) continue;
                String fileIds = param.getFileIds() == null ? item.getFileIds() : param.getFileIds();
                boolean isBlank = cn.smarthse.util.common.StringUtils.isBlank((CharSequence)fileIds);
                if (item.getDataState() == null || !(isBlank ^ 0 == item.getDataState())) continue;
                item.setDataState(isBlank ? ArchiveFilteItemDataStateEnum.UNFULL.getValue() : ArchiveFilteItemDataStateEnum.FULL.getValue());
                LiteArchiveFileItem itemParam = new LiteArchiveFileItem();
                itemParam.setId(item.getId());
                itemParam.setDataState(item.getDataState());
                itemParamList.add(itemParam);
            }
            if (!itemParamList.isEmpty()) {
                this.liteArchiveFileItemMapper.batchUpdateItemDataStateByPriKey(itemParamList);
            }
        }
    }

    public List<LiteArchiveFileItem> selectCompletedItemByArchiveId(List<Long> archiveIdList) {
        if (CollectionUtils.isEmpty(archiveIdList)) {
            return null;
        }
        return ((LiteArchiveFileItemMapper)this.dao).selectCompletedItemByArchiveId(archiveIdList);
    }
}

