/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.litearchive.imp;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.dao.litearchive.LiteArchiveFileItemChildMapper;
import cn.smarthse.modules.health.entity.litearchive.LiteArchiveFileItemChild;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveFileItemChildService;
import cn.smarthse.util.common.StringUtils;
import cn.smarthse.util.common.date.DateUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Transactional(readOnly=true)
@DubboService
public class LiteArchiveFileItemChildServiceImpl
extends BaseServiceImpl<LiteArchiveFileItemChildMapper, LiteArchiveFileItemChild>
implements ILiteArchiveFileItemChildService {
    @DubboReference
    private ISysFileProvideService sysFileProvideService;

    public List<LiteArchiveFileItemChild> getLiteArchiveFileItemChildren(Long itemId) {
        List<LiteArchiveFileItemChild> liteArchiveFileItemChildren = ((LiteArchiveFileItemChildMapper)this.dao).getLiteArchiveFileItemChildren(itemId);
        if (CollectionUtils.isNotEmpty(liteArchiveFileItemChildren)) {
            for (LiteArchiveFileItemChild liteArchiveFileItemChild : liteArchiveFileItemChildren) {
                liteArchiveFileItemChild.setUploadStaffName(SpringEncryptUtils.decrypt((String)liteArchiveFileItemChild.getUploadStaffName()));
            }
        }
        return liteArchiveFileItemChildren;
    }

    public PageInfo<LiteArchiveFileItemChild> queryDetail(JqGridParam jqGridParam, Long itemId) {
        PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows());
        List<LiteArchiveFileItemChild> list = this.getLiteArchiveFileItemChildren(itemId);
        this.setFileModel(list);
        return new PageInfo(list);
    }

    @Transactional(readOnly=false)
    public LiteArchiveFileItemChild addLatelyYearData(Long itemId, Long cid, Long staffId) {
        Integer year = DateUtils.getYear();
        Example example = new Example(LiteArchiveFileItemChild.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("year", (Object)year).andEqualTo("itemId", (Object)itemId);
        List list = this.getListByExample(example);
        if (list == null || list.size() == 0) {
            LiteArchiveFileItemChild child = new LiteArchiveFileItemChild();
            child.setItemId(itemId);
            child.setYear(year.toString());
            child.setUploadStaffId("" + staffId);
            child.setUploadDate(new Date());
            return this.add(child, staffId, cid);
        }
        return (LiteArchiveFileItemChild)list.get(0);
    }

    @Transactional(readOnly=false)
    public LiteArchiveFileItemChild getFileItemChildrenByItemIdAndYear(Long itemId, Integer year, Long staffId) {
        Example example = new Example(LiteArchiveFileItemChild.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("year", (Object)year).andEqualTo("itemId", (Object)itemId);
        List list = this.getListByExample(example);
        if (list != null && list.size() > 0) {
            return (LiteArchiveFileItemChild)list.get(0);
        }
        LiteArchiveFileItemChild child = new LiteArchiveFileItemChild();
        child.setItemId(itemId);
        child.setYear(year.toString());
        child.setUploadStaffId("" + staffId);
        child.setUploadDate(new Date());
        this.add(child, itemId, itemId);
        return child;
    }

    public List<LiteArchiveFileItemChild> getFileItemChildrenByItemIdAndYear(Long itemId, Integer year) {
        Example example = new Example(LiteArchiveFileItemChild.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("year", (Object)year).andEqualTo("itemId", (Object)itemId);
        List<LiteArchiveFileItemChild> list = this.getListByExample(example);
        return list;
    }

    @Transactional(readOnly=false)
    public void updateArchiveFiles(LiteArchiveFileItemChild child) {
        if (child != null && child.getId() != null) {
            LiteArchiveFileItemChild db = (LiteArchiveFileItemChild)this.getById(child.getId());
            if (StringUtils.isNotEmpty((String)db.getFileIds())) {
                child.setFileIds(Arrays.stream((db.getFileIds() + "," + child.getFileIds()).split(",")).distinct().collect(Collectors.joining(",")));
            }
            child.setUploadStaffId("" + child.getUpdateBy());
            child.setUploadDate(new Date());
            this.update(child, child.getUpdateBy());
        }
    }

    private void setFileModel(List<LiteArchiveFileItemChild> list) {
        StringBuilder sb = new StringBuilder();
        list.forEach(item -> {
            if (item.getFileIds() == null || item.getFileIds().isEmpty()) {
                return;
            }
            item.setFileIds(Arrays.stream(item.getFileIds().split(",")).filter(s -> !"0".equals(s) && !"null".equals(s.toLowerCase())).collect(Collectors.joining(",")));
            sb.append(item.getFileIds());
            if (sb.indexOf(",") != sb.length() - 1) {
                sb.append(",");
            }
        });
        if (sb.length() == 0) {
            return;
        }
        List files = this.sysFileProvideService.getListByIds(sb.toString());
        if (CollectionUtils.isNotEmpty((Collection)files)) {
            for (SysFileModel file : files) {
                for (LiteArchiveFileItemChild itemChild : list) {
                    if (itemChild.getFileIds() == null || itemChild.getFileIds().isEmpty() || !itemChild.getFileIds().contains("" + file.getId())) continue;
                    itemChild.getFileList().add(file);
                }
            }
        }
    }

    @Transactional(readOnly=false)
    public void deleteArchiveFiles(Long id, Long fileId, Long staffid) {
        LiteArchiveFileItemChild db;
        if (id != null && fileId != null && (db = (LiteArchiveFileItemChild)this.getById(id)) != null) {
            if (StringUtils.isNotEmpty((String)db.getFileIds())) {
                List fileIds = StringUtils.parseToLongList((String)db.getFileIds(), (String)",");
                fileIds.remove(fileId);
                fileIds.remove(0L);
                StringBuilder fileIdStr = null;
                for (Long fi : fileIds) {
                    if (fileIdStr == null) {
                        fileIdStr = new StringBuilder(fi.toString());
                        continue;
                    }
                    fileIdStr.append(",").append(fi.toString());
                }
                if (fileIdStr != null) {
                    db.setFileIds(fileIdStr.toString());
                } else {
                    db.setFileIds("");
                }
            }
            if (StringUtils.isNotEmpty((String)db.getReferFileIds())) {
                db.setReferFileIds(db.getReferFileIds().replace("" + fileId, ""));
            }
            db.setUploadStaffId("" + staffid);
            db.setUploadDate(new Date());
            this.update(db, staffid);
        }
    }
}

