/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.litearchive.imp;

import cn.smarthse.common.freemarker.OutPutDocStr;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.Java2WordGeneratorTemp;
import cn.smarthse.common.util.RandomGenerator;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.ZipCompressorUtil;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.health.component.OssUploadComponent;
import cn.smarthse.modules.health.component.litearchive.LiteArchiveFileDataDir;
import cn.smarthse.modules.health.entity.base.occriskfactor.OccupationalRiskFactors;
import cn.smarthse.modules.health.entity.base.staff.StaffWorkRole;
import cn.smarthse.modules.health.entity.base.staff.vo.StaffDocInfoVo;
import cn.smarthse.modules.health.entity.litearchive.LiteArchiveFileItem;
import cn.smarthse.modules.health.entity.litearchive.LiteArchiveFilePersonal;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalStaffCheckInfo;
import cn.smarthse.modules.health.entity.work.harmfactor.HarmfactorWorkSource;
import cn.smarthse.modules.health.entity.work.reform.ReformItemBasic;
import cn.smarthse.modules.health.entity.work.shield.vo.ShieldWorkRelation;
import cn.smarthse.modules.health.enums.archive.ArchiveFilteItemDataStateEnum;
import cn.smarthse.modules.health.enums.archive.PersonalHarmFactorArchiveDataMapKeyEnum;
import cn.smarthse.modules.health.enums.reform.ReformGenerationSourceEnum;
import cn.smarthse.modules.health.enums.reform.ReformStatusEnum;
import cn.smarthse.modules.health.service.base.occriskfactor.IOccupationalRiskFactorsService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.base.staff.IStaffWorkRoleService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveFileItemService;
import cn.smarthse.modules.health.service.work.check.checkV3221.IPhcPhysicalStaffCheckInfoService;
import cn.smarthse.modules.health.service.work.harmfactor.IHarmfactorWorkService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.service.work.shield.IShieldEquipRuleService;
import cn.smarthse.modules.health.vo.archive.Doc6WorkPlaceHarmFactor;
import cn.smarthse.modules.health.vo.archive.Doc6WorkPlaceHarmFactorCheckPlan;
import cn.smarthse.modules.health.vo.archive.Doc6WorkPlaceHarmFactorResult;
import cn.smarthse.modules.health.vo.archive.Doc6WorkPlaceHarmFactorValue;
import cn.smarthse.services.hfi.api.entity.CheckPlan;
import cn.smarthse.services.hfi.api.model.list.CheckPlanListParam;
import cn.smarthse.services.hfi.api.model.result.ResultUtils;
import cn.smarthse.services.hfi.api.pojo.vo.HarmFactorCheckResultVo;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import cn.smarthse.services.hfi.api.service.ICheckResultService;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateModel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Component
public class Doc6GenerateLiteArchiveFile {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${isActualize}")
    private String isActualize;
    @Autowired(required=false)
    @Lazy
    ILiteArchiveFileItemService fileItemService;
    @Autowired
    private OssUploadComponent ossUploadComponent;
    @Autowired
    private IStaffInfoService staffInfoService;
    @Autowired
    private IHarmfactorWorkService harmfactorWorkService;
    @Autowired
    private IShieldEquipRuleService shieldEquipRuleService;
    @Autowired
    private IStaffWorkRoleService staffWorkRoleService;
    @DubboReference
    ICheckPlanService checkPlanService;
    @DubboReference
    ICheckResultService checkResultService;
    @Autowired
    IOccupationalRiskFactorsService occupationalRiskFactorsService;
    @Autowired
    ILiteArchiveFileItemService liteArchiveFileItemService;
    @Autowired
    IReformItemBasicService reformItemBasicService;
    @Autowired
    IPhcPhysicalStaffCheckInfoService checkInfoService;
    @Autowired
    private LiteArchiveFileDataDir dataDir;

    private Map<String, Object> getLiteDocData(Long cid, Long staffId) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        StaffDocInfoVo staffVo = this.staffInfoService.getStaffDocInfoVoByStaffIdNew(staffId, cid);
        dataMap.put(PersonalHarmFactorArchiveDataMapKeyEnum.staffInfo.name(), staffVo);
        return dataMap;
    }

    private List<LiteArchiveFileItem> doCreateFileItemList(LiteArchiveFilePersonal archive) {
        Long cid = archive.getCid();
        Map<String, Object> dataMap = this.getLiteDocData(cid, archive.getStaffId());
        String staffName = archive.getStaffName();
        StaffDocInfoVo staffVo = (StaffDocInfoVo)dataMap.get(PersonalHarmFactorArchiveDataMapKeyEnum.staffInfo.name());
        if (staffVo != null) {
            PhcPhysicalStaffCheckInfo checkInfo;
            SysFileModel file = this.generaFile("\u4e2a\u4eba\u4fe1\u606f\u5361(" + staffName + ").doc", dataMap, "liteachive/litedoc6/phcFile.ftl", cid);
            if (file != null) {
                this.fileItemService.removeOldFromSystem(archive.getId());
                this.fileItemService.appendFilesNotUpdateState(archive.getId(), Long.valueOf(601L), file.getId().toString(), file.getId().toString(), ArchiveFilteItemDataStateEnum.FULL);
            }
            if (staffVo.getCheckNum() != null && staffVo.getCheckNum() > 0 && StringUtils.isNotEmpty((String)staffVo.getIdCard()) && (checkInfo = this.checkInfoService.getPhcPhysicalStaffCheckInfoByCardId(staffVo.getIdCard(), cid)) != null) {
                staffVo.setStaffCheckInfoV3221(checkInfo.getId().toString());
            }
        }
        if (staffVo != null && staffVo.getCheckNum() != null && staffVo.getCheckNum() > 0 && StringUtils.isNotEmpty((String)staffVo.getStaffCheckInfoV3221())) {
            this.fileItemService.appendFilesNotUpdateState(archive.getId(), Long.valueOf(603L), null, null, ArchiveFilteItemDataStateEnum.FULL);
        } else {
            List archiveData = this.reformItemBasicService.getArchiveData(cid, ReformGenerationSourceEnum.TJ);
            if (CollectionUtils.isNotEmpty((Collection)archiveData)) {
                ReformItemBasic finish = archiveData.stream().filter(item -> item.getStatus().equals(ReformStatusEnum.WC.getValue())).findFirst().orElse(null);
                if (finish != null) {
                    this.fileItemService.appendFilesNotUpdateState(archive.getId(), Long.valueOf(603L), null, null, ArchiveFilteItemDataStateEnum.FULL);
                } else {
                    this.fileItemService.appendFilesNotUpdateState(archive.getId(), Long.valueOf(603L), null, null, ArchiveFilteItemDataStateEnum.UNFULL);
                }
            } else {
                this.fileItemService.appendFilesNotUpdateState(archive.getId(), Long.valueOf(603L), null, null, ArchiveFilteItemDataStateEnum.UNFULL);
            }
        }
        return null;
    }

    private SysFileModel generaFile(String fileName, Map<String, Object> dataMap, String fileTemplate, Long cid) {
        if (MapUtils.isEmpty(dataMap)) {
            return null;
        }
        String tempDir = this.dataDir.getArchivePath() + File.separator;
        String randomString = RandomGenerator.getRandomString((int)4);
        tempDir = tempDir + DateUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss") + File.separator + randomString + File.separator;
        File targetFile1 = new File(tempDir + fileName);
        File docFile1 = Java2WordGeneratorTemp.createDoc(dataMap, (String)fileTemplate, (String)targetFile1.getAbsolutePath());
        SysFileModel fileModel = this.ossUploadComponent.upload(docFile1, cid);
        return fileModel;
    }

    public File generaFile2(String fileName, Map<String, Object> dataMap, String fileTemplate, Long cid) {
        if (MapUtils.isEmpty(dataMap)) {
            return null;
        }
        String tempDir = this.dataDir.getArchivePath() + File.separator;
        String randomString = RandomGenerator.getRandomString((int)4);
        tempDir = tempDir + DateUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss") + File.separator + randomString + File.separator;
        File targetFile1 = new File(tempDir + fileName);
        File docFile1 = Java2WordGeneratorTemp.createDoc(dataMap, (String)fileTemplate, (String)targetFile1.getAbsolutePath());
        return docFile1;
    }

    public File createDocFile(Map<?, ?> dataMap, String templateName, String templatePath, String fileName) {
        Configuration configuration = new Configuration();
        File f = null;
        try {
            f = File.createTempFile(fileName, ".doc");
            f.deleteOnExit();
            configuration.setDefaultEncoding("UTF-8");
            configuration.setClassForTemplateLoading(this.getClass(), templatePath);
            configuration.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
            configuration.setTemplateExceptionHandler(TemplateExceptionHandler.IGNORE_HANDLER);
            configuration.setSharedVariable("outPutDocStr", (TemplateModel)new OutPutDocStr());
            Template t = configuration.getTemplate(templateName, "UTF-8");
            if (t == null) {
                throw new RuntimeException("\u6a21\u677f\u4e0d\u5b58\u5728!");
            }
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(f), "utf-8");
            t.process(dataMap, (Writer)w);
            ((Writer)w).close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
        return f;
    }

    private SysFileModel RarFile(List<SysFileModel> files, Long cid) {
        String tempDir = System.getProperty("java.io.tmpdir") + File.separator;
        String randomString = RandomGenerator.getRandomString((int)4);
        tempDir = tempDir + DateUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss") + File.separator + randomString + File.separator;
        if (files != null) {
            this.ossUploadComponent.downLoadFile(files, tempDir);
        }
        String subTargetDir = tempDir + File.separator + "\u5386\u6b21\u804c\u4e1a\u5065\u5eb7\u4f53\u68c0\u62a5\u544a\u3001\u804c\u4e1a\u75c5\u8bca\u7597\u7b49\u8d44\u6599";
        String zip = subTargetDir + ".zip";
        ZipCompressorUtil zipCompressorUtil = new ZipCompressorUtil(zip);
        zipCompressorUtil.compressExe(tempDir);
        File sub_zipFile = new File(zip);
        SysFileModel referFileModel = this.ossUploadComponent.upload(sub_zipFile, cid);
        return referFileModel;
    }

    private List<Doc6WorkPlaceHarmFactor> getDoc6WorkPlaceTestResult(Long staffId) {
        ArrayList vos = new ArrayList();
        ArrayList<Doc6WorkPlaceHarmFactor> list = new ArrayList<Doc6WorkPlaceHarmFactor>();
        List localHistories = this.staffWorkRoleService.getLocalStaffWorkRolesByStaffIdOrderByBeginTime(staffId);
        for (StaffWorkRole role : localHistories) {
            if (role.getWorkRoleId() == null) continue;
            Doc6WorkPlaceHarmFactor data = new Doc6WorkPlaceHarmFactor();
            data.setWorkPlace(role.getWorkRoleInfo().getWorkName());
            Object protectiveArticles = "";
            List infos = this.shieldEquipRuleService.getHistoryShieldInfosByWorkId(role.getWorkRoleInfo().getId(), role.getCid(), role.getLeaveTime());
            if (infos != null && !infos.isEmpty()) {
                for (int i = 0; i < infos.size(); ++i) {
                    protectiveArticles = (String)protectiveArticles + ((ShieldWorkRelation)infos.get(i)).getDetailName();
                    if (StringUtils.isNotEmpty((String)((ShieldWorkRelation)infos.get(i)).getShieldDesc())) {
                        protectiveArticles = (String)protectiveArticles + "\u2014" + ((ShieldWorkRelation)infos.get(i)).getShieldDesc();
                    }
                    if (i == infos.size() - 1) continue;
                    protectiveArticles = (String)protectiveArticles + ",";
                }
            }
            data.setProtectiveArticles((String)protectiveArticles);
            if (role.getLeaveTime() == null) {
                role.setLeaveTime(new Date());
            }
            List factorList = new ArrayList();
            factorList = "true".equals(this.isActualize) ? this.harmfactorWorkService.getActualizeArchiveHarmfactorByWork(role.getCid(), role.getWorkRoleId(), role.getLeaveTime()) : this.harmfactorWorkService.getArchiveHarmfactorByWork(role.getCid(), role.getWorkRoleId(), role.getLeaveTime());
            if (factorList != null && factorList.size() > 0) {
                HashMap hcMap = new HashMap();
                HashMap hcHarmSourcesMap = new HashMap();
                for (HarmfactorWorkSource harm : factorList) {
                    if (hcMap.get(harm.getCheckPlanId()) == null) {
                        hcMap.put(harm.getCheckPlanId(), new ArrayList());
                    }
                    if (hcHarmSourcesMap.get(harm.getCheckPlanId()) == null) {
                        hcHarmSourcesMap.put(harm.getCheckPlanId(), new ArrayList());
                    }
                    ((List)hcMap.get(harm.getCheckPlanId())).add(harm.getHarmId());
                    ((List)hcHarmSourcesMap.get(harm.getCheckPlanId())).add(harm.getHazardSource());
                }
                int lineNum = 0;
                ArrayList<Doc6WorkPlaceHarmFactorCheckPlan> checkPlanList = new ArrayList<Doc6WorkPlaceHarmFactorCheckPlan>();
                for (Long key : hcMap.keySet()) {
                    if (key == null) continue;
                    ++lineNum;
                    List harms = (List)hcMap.get(key);
                    List source = (List)hcHarmSourcesMap.get(key);
                    Doc6WorkPlaceHarmFactorCheckPlan plan = new Doc6WorkPlaceHarmFactorCheckPlan();
                    plan.setCheckPlanId(key);
                    CheckPlan check = this.checkPlanService.getDetailById(key);
                    if (check != null) {
                        Long thirdOrgId;
                        plan.setTestOrganization(check.getThirdOrgName());
                        if (check.getThirdOrgName() != null || check.getCheckFrom() == null || !check.getCheckFrom().equals(1) || (thirdOrgId = check.getThirdOrgId()) != null) {
                            // empty if block
                        }
                        if (check.getCheckDateBegin() != null && check.getCheckDateEnd() != null) {
                            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                            plan.setTestTime(check.getCheckDateBegin().format(formatter) + "\u5230" + check.getCheckDateEnd().format(formatter));
                        }
                    }
                    ArrayList<Doc6WorkPlaceHarmFactorResult> resultList = new ArrayList<Doc6WorkPlaceHarmFactorResult>();
                    List harmList = this.checkResultService.queryHarmFactorByCheckAndHarms(key, harms, source);
                    if (harmList != null && harmList.size() > 0) {
                        plan.setLineNum(Integer.valueOf(harmList.size()));
                        for (HarmFactorCheckResultVo vo : harmList) {
                            Doc6WorkPlaceHarmFactorResult result = new Doc6WorkPlaceHarmFactorResult();
                            Long harmId = Long.parseLong(vo.getCheckValue());
                            result.setHarmFactorName(((OccupationalRiskFactors)this.occupationalRiskFactorsService.getById(harmId)).getNameCh());
                            ArrayList<Doc6WorkPlaceHarmFactorValue> values = new ArrayList<Doc6WorkPlaceHarmFactorValue>();
                            List valueList = this.checkResultService.queryHarmFactorByResultNo(vo.getResultNo());
                            for (HarmFactorCheckResultVo value : valueList) {
                                Doc6WorkPlaceHarmFactorValue harmData = new Doc6WorkPlaceHarmFactorValue();
                                if (value.getCheckValueType() == 1) {
                                    harmData.setResult(value.getCheckValue());
                                    if (value.getUnit() != null) {
                                        harmData.setUnit(value.getTargetName() + "(" + value.getUnit() + ")");
                                    } else {
                                        harmData.setUnit(value.getTargetName());
                                    }
                                } else {
                                    String range = ResultUtils.getRange((Integer)value.getCheckValueRangeType(), (String)value.getCheckValueMin(), (String)value.getCheckValueMax());
                                    harmData.setResult(range);
                                    if (value.getUnit() != null) {
                                        harmData.setUnit(value.getTargetName() + "(" + value.getUnit() + ")");
                                    } else {
                                        harmData.setUnit(value.getTargetName());
                                    }
                                }
                                values.add(harmData);
                            }
                            result.setList(values);
                            resultList.add(result);
                        }
                    }
                    plan.setLineNum(Integer.valueOf(resultList.size()));
                    plan.setResultList(resultList);
                    checkPlanList.add(plan);
                }
                data.setLineNum(Integer.valueOf(lineNum));
                data.setCheckPlanList(checkPlanList);
            } else {
                data.setLineNum(Integer.valueOf(0));
            }
            list.add(data);
        }
        return list;
    }

    @Transactional(readOnly=false)
    public void createLiteArchive(LiteArchiveFilePersonal archive) {
        this.doCreateFileItemList(archive);
    }

    @Transactional
    public void createLiteArchiveList(List<LiteArchiveFilePersonal> personalList) {
        if (CollectionUtils.isEmpty(personalList) || personalList.get(0) == null || personalList.get(0).getCid() == null) {
            return;
        }
        List collect = personalList.parallelStream().map(LiteArchiveFilePersonal::getStaffId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            return;
        }
        List staffVoList = this.staffInfoService.getStaffDocInfoVoByStaffIdNewList(collect, personalList.get(0).getCid());
        List archiveData = this.reformItemBasicService.getArchiveData(personalList.get(0).getCid(), ReformGenerationSourceEnum.TJ);
        Map staffDocInfoVoMap = staffVoList.parallelStream().filter(item -> item != null && item.getStaffInfoId() != null).collect(Collectors.toMap(StaffDocInfoVo::getStaffInfoId, Function.identity(), (k1, k2) -> k2));
        for (LiteArchiveFilePersonal archive : personalList) {
            Long cid = archive.getCid();
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            StaffDocInfoVo staffDocInfoVo = (StaffDocInfoVo)staffDocInfoVoMap.get(archive.getStaffId());
            if (staffDocInfoVo == null) continue;
            dataMap.put(PersonalHarmFactorArchiveDataMapKeyEnum.staffInfo.name(), staffDocInfoVo);
            String staffName = archive.getStaffName();
            StaffDocInfoVo staffVo = (StaffDocInfoVo)dataMap.get(PersonalHarmFactorArchiveDataMapKeyEnum.staffInfo.name());
            if (staffVo != null) {
                PhcPhysicalStaffCheckInfo checkInfo;
                SysFileModel file = this.generaFile("\u4e2a\u4eba\u4fe1\u606f\u5361(" + staffName + ").doc", dataMap, "liteachive/litedoc6/phcFile.ftl", cid);
                dataMap.clear();
                if (file != null) {
                    this.fileItemService.removeOldFromSystem(archive.getId());
                    this.fileItemService.appendFilesNotUpdateState(archive.getId(), Long.valueOf(601L), file.getId().toString(), file.getId().toString(), ArchiveFilteItemDataStateEnum.FULL);
                }
                if (staffVo.getCheckNum() != null && staffVo.getCheckNum() > 0 && StringUtils.isNotEmpty((String)staffVo.getIdCard()) && (checkInfo = this.checkInfoService.getPhcPhysicalStaffCheckInfoByCardId(staffVo.getIdCard(), cid)) != null) {
                    staffVo.setStaffCheckInfoV3221(checkInfo.getId().toString());
                }
            }
            if (staffVo != null && staffVo.getCheckNum() != null && staffVo.getCheckNum() > 0 && StringUtils.isNotEmpty((String)staffVo.getStaffCheckInfoV3221())) {
                this.fileItemService.appendFilesNotUpdateState(archive.getId(), Long.valueOf(603L), null, null, ArchiveFilteItemDataStateEnum.FULL);
                continue;
            }
            if (CollectionUtils.isNotEmpty((Collection)archiveData)) {
                ReformItemBasic finish = archiveData.stream().filter(item -> item.getStatus().equals(ReformStatusEnum.WC.getValue())).findFirst().orElse(null);
                if (finish != null) {
                    this.fileItemService.appendFilesNotUpdateState(archive.getId(), Long.valueOf(603L), null, null, ArchiveFilteItemDataStateEnum.FULL);
                    continue;
                }
                this.fileItemService.appendFilesNotUpdateState(archive.getId(), Long.valueOf(603L), null, null, ArchiveFilteItemDataStateEnum.UNFULL);
                continue;
            }
            this.fileItemService.appendFilesNotUpdateState(archive.getId(), Long.valueOf(603L), null, null, ArchiveFilteItemDataStateEnum.UNFULL);
        }
    }

    @Transactional
    public void addOrUpdateArchiveList(List<LiteArchiveFilePersonal> archiveFilePersonals, Map<Long, Map<Long, StaffDocInfoVo>> staffDocInfoVoMap, List<Long> fileNameIdList) {
        List<LiteArchiveFilePersonal> personalList = archiveFilePersonals.stream().filter(item -> item != null && item.getCid() != null && item.getStaffId() != null).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(personalList)) {
            return;
        }
        if (MapUtils.isEmpty(staffDocInfoVoMap) && (fileNameIdList.contains(601L) || fileNameIdList.contains(603L))) {
            Map cidAndStaffIdListMap = personalList.stream().collect(Collectors.groupingBy(LiteArchiveFilePersonal::getCid, Collectors.mapping(LiteArchiveFilePersonal::getStaffId, Collectors.toList())));
            staffDocInfoVoMap = this.staffInfoService.getStaffDocInfoVoMap(cidAndStaffIdListMap);
        }
        ArrayList<LiteArchiveFileItem> list = new ArrayList<LiteArchiveFileItem>();
        if (fileNameIdList.contains(601L)) {
            List<LiteArchiveFileItem> items = this.addOrUpdate601L(personalList, staffDocInfoVoMap);
            list.addAll(items);
            this.liteArchiveFileItemService.batchRemoveOldFromSystem(items);
        }
        if (fileNameIdList.contains(602L)) {
            list.addAll(this.addOrUpdate602L(personalList));
        }
        if (fileNameIdList.contains(603L)) {
            list.addAll(this.addOrUpdate603L(personalList));
        }
        this.liteArchiveFileItemService.batchAppendFileItem(list);
    }

    public List<LiteArchiveFileItem> addOrUpdate601L(List<LiteArchiveFilePersonal> personalList, Map<Long, Map<Long, StaffDocInfoVo>> staffDocInfoVoMap) {
        ArrayList<LiteArchiveFileItem> appendFileItemList = new ArrayList<LiteArchiveFileItem>();
        for (LiteArchiveFilePersonal personal : personalList) {
            Long cid = personal.getCid();
            Long staffId = personal.getStaffId();
            if (staffDocInfoVoMap.get(cid) == null || staffDocInfoVoMap.get(cid).get(staffId) == null) continue;
            StaffDocInfoVo staffDocInfoVo = staffDocInfoVoMap.get(cid).get(staffId);
            HashMap<String, Object> infoMap = new HashMap<String, Object>();
            infoMap.put(PersonalHarmFactorArchiveDataMapKeyEnum.staffInfo.name(), staffDocInfoVo);
            SysFileModel file = this.generaFile("\u4e2a\u4eba\u4fe1\u606f\u5361(" + staffDocInfoVo.getRealName() + ").doc", infoMap, "liteachive/litedoc6/phcFile.ftl", cid);
            if (file == null) continue;
            appendFileItemList.add(new LiteArchiveFileItem().setLiteArchiveId(personal.getId()).setFileNameId(Long.valueOf(601L)).setFileIds(file.getId().toString()).setReferFileIds(file.getId().toString()).setDataState(ArchiveFilteItemDataStateEnum.FULL.getValue()).setHgDataState(ArchiveFilteItemDataStateEnum.FULL.getValue()).setUpdateBy(personal.getUpdateBy()));
        }
        return appendFileItemList;
    }

    public List<LiteArchiveFileItem> addOrUpdate602L(List<LiteArchiveFilePersonal> personalList) {
        List cidList = personalList.stream().map(LiteArchiveFilePersonal::getCid).collect(Collectors.toList());
        Map checkPlanMap = this.checkPlanService.selectCheckPlanList(new CheckPlanListParam().setCids(cidList)).stream().filter(item -> item != null && item.getCheckDateBegin() != null).collect(Collectors.toMap(CheckPlan::getCid, Function.identity(), (k1, k2) -> k1.getCheckDateBegin().isAfter(k2.getCheckDateBegin()) ? k1 : k2));
        ArrayList<LiteArchiveFileItem> appendFileItemList = new ArrayList<LiteArchiveFileItem>();
        for (LiteArchiveFilePersonal personal : personalList) {
            Long cid = personal.getCid();
            if (checkPlanMap.get(cid) == null) continue;
            appendFileItemList.add(new LiteArchiveFileItem().setLiteArchiveId(personal.getId()).setFileNameId(Long.valueOf(602L)).setDataState(ArchiveFilteItemDataStateEnum.FULL.getValue()).setHgDataState(ArchiveFilteItemDataStateEnum.FULL.getValue()).setUpdateBy(personal.getUpdateBy()));
        }
        return appendFileItemList;
    }

    public List<LiteArchiveFileItem> addOrUpdate603L(List<LiteArchiveFilePersonal> personalList) {
        List cidList = personalList.stream().map(LiteArchiveFilePersonal::getCid).collect(Collectors.toList());
        Example reformExample = new Example(ReformItemBasic.class);
        reformExample.createCriteria().andIn("cid", cidList).andEqualTo("generationSource", (Object)ReformGenerationSourceEnum.TJ).andIn("status", Arrays.asList(3, 4)).andEqualTo("isValid", (Object)true);
        reformExample.selectProperties(new String[]{"id", "cid", "generationSource", "findTime", "updateDate"});
        Map reformMap = this.reformItemBasicService.getListByExample(reformExample).stream().filter(item -> item != null && item.getUpdateDate() != null).collect(Collectors.toMap(ReformItemBasic::getCid, Function.identity(), (k1, k2) -> k1.getUpdateDate().getTime() >= k2.getUpdateDate().getTime() ? k1 : k2));
        Example phcPhysExample = new Example(PhcPhysicalStaffCheckInfo.class);
        phcPhysExample.createCriteria().andIn("cid", cidList).andEqualTo("isValid", (Object)true);
        Map phcPhysMap = this.checkInfoService.getListByExample(phcPhysExample).stream().filter(item -> item != null && item.getCheckTime() != null && StringUtils.isNotEmpty((String)item.getIdcardCode())).collect(Collectors.groupingBy(PhcPhysicalStaffCheckInfo::getCid, Collectors.toMap(PhcPhysicalStaffCheckInfo::getIdcardCode, Function.identity(), (k1, k2) -> k1.getCheckTime().getTime() >= k2.getCheckTime().getTime() ? k1 : k2)));
        ArrayList<LiteArchiveFileItem> appendFileItemList = new ArrayList<LiteArchiveFileItem>();
        for (LiteArchiveFilePersonal personal : personalList) {
            PhcPhysicalStaffCheckInfo phcPhysicalStaffCheckInfo;
            Long cid = personal.getCid();
            String idCard = personal.getIdCard();
            Integer dataState = ArchiveFilteItemDataStateEnum.UNFULL.getValue();
            Integer hgDataState = ArchiveFilteItemDataStateEnum.UNFULL.getValue();
            if (reformMap.get(cid) != null || phcPhysMap.get(cid) != null && phcPhysMap.get(cid).get(idCard) != null) {
                dataState = ArchiveFilteItemDataStateEnum.FULL.getValue();
            }
            if (phcPhysMap.get(cid) != null && phcPhysMap.get(cid).get(idCard) != null && DateUtils.getYear((Date)(phcPhysicalStaffCheckInfo = (PhcPhysicalStaffCheckInfo)phcPhysMap.get(cid).get(idCard)).getCheckTime()) >= DateUtils.getYear((Date)new Date()) - 2) {
                hgDataState = ArchiveFilteItemDataStateEnum.FULL.getValue();
            }
            appendFileItemList.add(new LiteArchiveFileItem().setLiteArchiveId(personal.getId()).setFileNameId(Long.valueOf(603L)).setDataState(dataState).setHgDataState(hgDataState).setUpdateBy(personal.getUpdateBy()));
        }
        return appendFileItemList;
    }
}

