/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.litearchive.imp;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.Java2WordGeneratorTemp;
import cn.smarthse.common.util.RandomGenerator;
import cn.smarthse.common.util.SpringContextHolder;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.health.component.OssUploadComponent;
import cn.smarthse.modules.health.component.litearchive.LiteArchiveFileDataDir;
import cn.smarthse.modules.health.entity.base.company.grade.CompanyGradeV3Rec;
import cn.smarthse.modules.health.entity.base.device.DeviceHarmfactor;
import cn.smarthse.modules.health.entity.base.device.DeviceListView;
import cn.smarthse.modules.health.entity.base.device.DeviceWorkrole;
import cn.smarthse.modules.health.entity.litearchive.LiteArchive;
import cn.smarthse.modules.health.entity.litearchive.LiteArchiveFileItem;
import cn.smarthse.modules.health.entity.work.reform.ReformItemBasic;
import cn.smarthse.modules.health.entity.work.reform.param.RiskListSearch;
import cn.smarthse.modules.health.entity.work.shield.ProtectEquipIssueRecord;
import cn.smarthse.modules.health.enums.archive.ArchiveFilteItemDataStateEnum;
import cn.smarthse.modules.health.enums.archive.HarmFactorTestArchiveDataMapKeyEnum;
import cn.smarthse.modules.health.enums.archive.LiteArchiveRequiredEnum;
import cn.smarthse.modules.health.enums.reform.ReformGenerationSourceEnum;
import cn.smarthse.modules.health.model.litearchive.ArchiveFileItemUpdateParam;
import cn.smarthse.modules.health.model.litearchive.DeviceMaterialHarm;
import cn.smarthse.modules.health.pojo.Archive4ExtraModel;
import cn.smarthse.modules.health.pojo.LiteArchiveFileResult;
import cn.smarthse.modules.health.service.base.device.IDeviceHarmfactorService;
import cn.smarthse.modules.health.service.base.device.IDeviceListViewService;
import cn.smarthse.modules.health.service.base.device.IDeviceWorkroleService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveFileItemService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicCommandService;
import cn.smarthse.modules.health.service.work.shield.IProtectEquipIssueRecordDetailService;
import cn.smarthse.modules.health.service.work.shield.IProtectEquipIssueRecordService;
import cn.smarthse.modules.health.supervise.service.company.grade.ICompanyGradeV3RecService;
import cn.smarthse.modules.health.util.LiteArchiveUtils;
import cn.smarthse.modules.health.vo.archive.Doc4041WorkRoleHarmFactorShieldEquipVO;
import cn.smarthse.modules.health.vo.summary.ReformSearchVo;
import cn.smarthse.services.hfi.api.entity.CheckPlan;
import cn.smarthse.services.hfi.api.entity.riskev.RiskExposeEvaluateData;
import cn.smarthse.services.hfi.api.model.CheckResultParseQueryModel;
import cn.smarthse.services.hfi.api.model.list.CheckPlanList;
import cn.smarthse.services.hfi.api.model.list.CheckPlanListParam;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import cn.smarthse.services.hfi.api.service.ICheckResultParseService;
import cn.smarthse.services.hfi.api.service.riskev.IRiskExposeEvaluateDataService;
import cn.smarthse.util.common.JsonUtils;
import com.alibaba.fastjson.JSON;
import java.io.File;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StopWatch;

@Service
public class Doc4GenerateLiteArchiveFile {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @DubboReference
    private ICheckPlanService checkPlanService;
    @Autowired
    private OssUploadComponent ossUploadComponent;
    @Autowired(required=false)
    @Lazy
    private ILiteArchiveFileItemService fileItemService;
    @Autowired
    private IDeviceHarmfactorService deviceHarmfactorService;
    @Autowired
    private IDeviceWorkroleService deviceWorkroleService;
    @Autowired
    private IDeviceListViewService deviceListViewService;
    @Autowired
    private IProtectEquipIssueRecordDetailService protectEquipIssueRecordDetailService;
    @Autowired
    private IProtectEquipIssueRecordService approvalDataSourceService;
    @DubboReference
    private IRiskExposeEvaluateDataService riskExposeEvaluateDataService;
    @DubboReference
    private ICheckPlanService hazardCheckPlanService;
    @Autowired
    private IReformItemBasicCommandService reformItemBasicService;
    @Autowired
    private ILiteArchiveService liteArchiveService;
    @Autowired
    private LiteArchiveFileDataDir dataDir;
    @DubboReference
    private ICheckResultParseService resultParseService;
    @DubboReference
    ICompanyGradeV3RecService gradeV3RecService;
    @DubboReference(version="1.0.0")
    ICompanyProvideBySuperviseService superviseService;

    public void autoCreateFileItems4CheckPlan(LiteArchive archive, String fileNameIds) {
        Long complianceCompany = this.liteArchiveService.isComplianceCompany(archive.getCid());
        boolean isComplianceCompany = complianceCompany != null;
        this.logger.debug("\u751f\u6210[\u6863\u68484]\u5f00\u59cb,archiveId:{}", (Object)archive.getId());
        String title = archive.getTitle();
        if (title.equals("2023\u5e74\u4ee5\u524d")) {
            Date timeEnd = DateUtils.getYearLastTime((int)2022);
        } else {
            Date timeEnd = DateUtils.getYearLastTime((int)Integer.parseInt(title));
        }
        ArchiveFileItemUpdateParam param = new ArchiveFileItemUpdateParam();
        param.setArchiveId(archive.getId());
        param.setStaffId(Long.valueOf(0L));
        StopWatch sw = new StopWatch();
        Archive4ExtraModel extraModel = new Archive4ExtraModel();
        ArrayList<LiteArchiveFileItem> fileItemList = new ArrayList<LiteArchiveFileItem>();
        try {
            if (StringUtils.isBlank((CharSequence)fileNameIds) || StringUtils.contains((CharSequence)fileNameIds, (CharSequence)"403")) {
                fileItemList.add(LiteArchiveUtils.appendFileItem((Long)archive.getId(), (Long)403L, null, null, item -> {
                    item.setIsRequired(LiteArchiveRequiredEnum.NO.getCode());
                    item.setHgIsRequired(LiteArchiveRequiredEnum.UPLOAD.getCode());
                }));
            }
            if (StringUtils.isBlank((CharSequence)fileNameIds) || StringUtils.contains((CharSequence)fileNameIds, (CharSequence)"405")) {
                fileItemList.add(LiteArchiveUtils.appendFileItem((Long)archive.getId(), (Long)405L, null, null, item -> {
                    item.setIsRequired(LiteArchiveRequiredEnum.NO.getCode());
                    item.setHgIsRequired(LiteArchiveRequiredEnum.NO.getCode());
                }));
            }
            if (StringUtils.isBlank((CharSequence)fileNameIds) || StringUtils.contains((CharSequence)fileNameIds, (CharSequence)"406")) {
                fileItemList.add(LiteArchiveUtils.appendFileItem((Long)archive.getId(), (Long)406L, null, null, item -> {
                    item.setIsRequired(LiteArchiveRequiredEnum.NO.getCode());
                    item.setHgIsRequired(LiteArchiveRequiredEnum.NO.getCode());
                }));
            }
            if (StringUtils.isBlank((CharSequence)fileNameIds) || StringUtils.contains((CharSequence)fileNameIds, (CharSequence)"407")) {
                fileItemList.add(LiteArchiveUtils.appendFileItem((Long)archive.getId(), (Long)407L, null, null, item -> {
                    item.setIsRequired(LiteArchiveRequiredEnum.NO.getCode());
                    item.setHgIsRequired(LiteArchiveRequiredEnum.NO.getCode());
                }));
            }
            this.logger.debug("\u751f\u6210[\u6863\u68484-\u63a5\u89e6\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u6c47\u603b\u8868]\u5f00\u59cb");
            if (StringUtils.isBlank((CharSequence)fileNameIds) || StringUtils.contains((CharSequence)fileNameIds, (CharSequence)"404") || StringUtils.contains((CharSequence)fileNameIds, (CharSequence)"401") || StringUtils.contains((CharSequence)fileNameIds, (CharSequence)"402")) {
                sw.start("\u63a5\u89e6\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u6c47\u603b\u8868:\u6570\u636e\u52a0\u8f7d\u4e0e\u9644\u4ef6\u751f\u6210");
                LiteArchiveFileResult result41 = this.generateArchive4Item404(archive.getId(), archive.getCid(), title, extraModel);
                LiteArchiveFileItem fileItem404 = LiteArchiveUtils.appendFileItem((Long)archive.getId(), (Long)404L, (String)result41.getFileId(), (String)result41.getFileId(), item -> {
                    item.setIsRequired(LiteArchiveRequiredEnum.DATA.getCode());
                    item.setHgIsRequired(LiteArchiveRequiredEnum.DATA.getCode());
                    item.setDataState(ArchiveFilteItemDataStateEnum.UNFULL.getValue());
                    item.setHgDataState(ArchiveFilteItemDataStateEnum.UNFULL.getValue());
                });
                sw.stop();
                if (StringUtils.isNotBlank((CharSequence)result41.getFileId()) || Objects.equals(1, result41.getDataState())) {
                    fileItem404.setDataState(ArchiveFilteItemDataStateEnum.FULL.getValue());
                    fileItem404.setHgDataState(ArchiveFilteItemDataStateEnum.FULL.getValue());
                }
                fileItemList.add(fileItem404);
                fileItemList.add(LiteArchiveUtils.appendFileItem((Long)archive.getId(), (Long)401L, null, null, item -> {
                    item.setIsRequired(LiteArchiveRequiredEnum.NO.getCode());
                    item.setHgIsRequired(LiteArchiveRequiredEnum.DATA.getCode());
                    if (extraModel != null && extraModel.getCheckId() != null) {
                        item.setDataState(ArchiveFilteItemDataStateEnum.FULL.getValue());
                        item.setHgDataState(ArchiveFilteItemDataStateEnum.FULL.getValue());
                    } else {
                        item.setDataState(ArchiveFilteItemDataStateEnum.UNFULL.getValue());
                        item.setHgDataState(ArchiveFilteItemDataStateEnum.UNFULL.getValue());
                    }
                }));
                fileItemList.add(LiteArchiveUtils.appendFileItem((Long)archive.getId(), (Long)402L, null, null, item -> {
                    item.setIsRequired(LiteArchiveRequiredEnum.NO.getCode());
                    item.setHgIsRequired(LiteArchiveRequiredEnum.DATA.getCode());
                    if (extraModel != null && extraModel.getCheckId() != null) {
                        item.setDataState(ArchiveFilteItemDataStateEnum.FULL.getValue());
                        item.setHgDataState(ArchiveFilteItemDataStateEnum.FULL.getValue());
                    } else {
                        item.setDataState(ArchiveFilteItemDataStateEnum.UNFULL.getValue());
                        item.setHgDataState(ArchiveFilteItemDataStateEnum.UNFULL.getValue());
                    }
                }));
                this.logger.debug("\u751f\u6210[\u6863\u68484-\u63a5\u89e6\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u6c47\u603b\u8868-\u5c97\u4f4d\u63a5\u89e6\u7684\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u6c47\u603b\u8868]\u5b8c\u6210,fileId:{}", (Object)result41.getFileId());
            }
            if (StringUtils.isBlank((CharSequence)fileNameIds) || StringUtils.contains((CharSequence)fileNameIds, (CharSequence)"410")) {
                sw.start("\u5c97\u4f4d\u914d\u5907\u7684\u4e2a\u4eba\u9632\u62a4\u7528\u54c1\u6c47\u603b\u8868:\u6570\u636e\u52a0\u8f7d\u4e0e\u9644\u4ef6\u751f\u6210");
                LiteArchiveFileResult result42 = this.createHarmFactorTouchSummary4042(archive, title, extraModel);
                sw.stop();
                LiteArchiveFileItem fileItem410 = LiteArchiveUtils.appendFileItem((Long)archive.getId(), (Long)410L, (String)result42.getFileId(), (String)result42.getFileId(), item -> {
                    item.setIsRequired(LiteArchiveRequiredEnum.DATA.getCode());
                    item.setHgIsRequired(LiteArchiveRequiredEnum.DATA.getCode());
                    item.setDataState(ArchiveFilteItemDataStateEnum.UNFULL.getValue());
                    item.setHgDataState(ArchiveFilteItemDataStateEnum.UNFULL.getValue());
                });
                if (StringUtils.isNotBlank((CharSequence)result42.getFileId()) || Objects.equals(1, result42.getDataState())) {
                    fileItem410.setDataState(ArchiveFilteItemDataStateEnum.FULL.getValue());
                    fileItem410.setHgDataState(ArchiveFilteItemDataStateEnum.FULL.getValue());
                }
                fileItemList.add(fileItem410);
                this.logger.debug("\u751f\u6210[\u6863\u68484-\u63a5\u89e6\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u6c47\u603b\u8868-\u5c97\u4f4d\u914d\u5907\u7684\u4e2a\u4eba\u9632\u62a4\u7528\u54c1\u6c47\u603b\u8868]\u5b8c\u6210,fileId:{}", (Object)result42.getFileId());
            }
            this.logger.debug("\u751f\u6210[\u6863\u68484-\u63a5\u89e6\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u6c47\u603b\u8868]\u7ed3\u675f");
            if (StringUtils.isBlank((CharSequence)fileNameIds) || StringUtils.contains((CharSequence)fileNameIds, (CharSequence)"409")) {
                LiteArchiveFileItem fileItem = LiteArchiveUtils.appendFileItem((Long)archive.getId(), (Long)409L, null, null, item -> {
                    item.setIsRequired(LiteArchiveRequiredEnum.NO.getCode());
                    item.setHgIsRequired(LiteArchiveRequiredEnum.NO.getCode());
                });
                if (isComplianceCompany) {
                    List<CheckPlan> checkPlanList;
                    CompanyGradeV3Rec companyGradeV3 = this.gradeV3RecService.getGradeRecByCid(archive.getCid());
                    if (Objects.equals(companyGradeV3.getOccType(), 0)) {
                        fileItem.setHgIsRequired(LiteArchiveRequiredEnum.UPLOAD.getCode());
                    } else if (Objects.equals(companyGradeV3.getOccType(), 2) && CollectionUtils.isEmpty(checkPlanList = this.checkArchive4Item409(archive.getCid(), title))) {
                        fileItem.setHgIsRequired(LiteArchiveRequiredEnum.UPLOAD.getCode());
                    }
                }
                fileItemList.add(fileItem);
            }
        }
        catch (Exception e) {
            this.logger.error("\u751f\u6210[\u6863\u68484-\u63a5\u89e6\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u6c47\u603b\u8868]\u51fa\u9519\uff1a", (Throwable)e);
        }
        sw.start("\u66f4\u65b0\u6863\u6848\u72b6\u6001");
        archive.setExtraJson(JSON.toJSONString((Object)extraModel));
        ((Doc4GenerateLiteArchiveFile)SpringContextHolder.getBean(Doc4GenerateLiteArchiveFile.class)).saveLiteArchive4Data(fileItemList, archive, isComplianceCompany);
        sw.stop();
        this.logger.info(sw.prettyPrint());
        this.logger.info("\u6863\u68484, id:{},\u751f\u6210\u7ed3\u675f\uff0c \u603b\u8017\u65f6\uff1a{}", (Object)archive.getId(), (Object)sw.getTotalTimeSeconds());
        this.logger.debug("\u751f\u6210[\u6863\u68484]\u7ed3\u675f,archiveId:{}", (Object)archive.getId());
    }

    @Transactional(readOnly=false)
    public void saveLiteArchive4Data(List<LiteArchiveFileItem> fileItemList, LiteArchive archive, boolean isComplianceCompany) {
        this.liteArchiveService.update((Object)archive);
        this.fileItemService.batchAppendFileItem(fileItemList, archive.getId(), Integer.valueOf(4), Long.valueOf(7780L));
        this.liteArchiveService.newUpdateStatus(archive.getId(), isComplianceCompany);
    }

    public void autoCreateFileItems4CheckPlanv2(List<LiteArchive> archives, Integer year, Set<Long> complianceCids, String fileNameIds, Boolean forceUpdateFile) {
        List onlyCompanyLists;
        Set newCompliances;
        if (CollectionUtils.isEmpty(archives)) {
            return;
        }
        List cids = archives.stream().map(LiteArchive::getCid).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        CheckPlanListParam param = new CheckPlanListParam();
        param.setStatus(Arrays.asList(new Integer[0]));
        param.setReportStatusList(Arrays.asList(new Integer[0]));
        param.setCheckTypes(Arrays.asList(2, 3, 4));
        param.setCids(cids);
        param.setCheckDateBegin(DateUtils.getYearFirstTime((int)(year - 3)));
        List dblastCheckPlanInfo = this.checkPlanService.getLastCheckPlanInfo(param);
        HashMap dbCidCheckPlanMap = new HashMap();
        Map<Object, Object> dbCidReformItemMap = new HashMap();
        Map<Object, Object> archiveIdFileItem404Map = new HashMap();
        Map<Object, Object> archiveIdFileItem410Map = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)dblastCheckPlanInfo)) {
            List fileItem404List;
            Map collect = dblastCheckPlanInfo.stream().collect(Collectors.toMap(CheckPlan::getCid, Function.identity()));
            dbCidCheckPlanMap.putAll(collect);
            List fileItem404ArchiveIdList = archives.stream().filter(f -> dbCidCheckPlanMap.containsKey(f.getCid())).map(LiteArchive::getId).distinct().collect(Collectors.toList());
            if ((forceUpdateFile == null || Objects.equals(forceUpdateFile, true)) && CollectionUtils.isNotEmpty((Collection)(fileItem404List = this.fileItemService.getByArchiveAndFileName(fileItem404ArchiveIdList, Long.valueOf(404L))))) {
                archiveIdFileItem404Map = fileItem404List.stream().collect(Collectors.toMap(LiteArchiveFileItem::getLiteArchiveId, Function.identity(), LiteArchiveUtils.filteItemMergeFunction));
            }
        }
        Set hasCheckIdCidSet = dbCidCheckPlanMap.keySet();
        List searchReformCidList = cids.stream().filter(f -> !hasCheckIdCidSet.contains(f)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(searchReformCidList)) {
            ReformSearchVo sv = new ReformSearchVo();
            sv.setYear(year);
            sv.setCidList(searchReformCidList);
            sv.setGenerationSource(ReformGenerationSourceEnum.DETECTION.getValue());
            sv.setBackStrName("cidAndStates");
            List reformItemBasicList = this.reformItemBasicService.getReformItemBasicList(sv);
            if (CollectionUtils.isNotEmpty((Collection)reformItemBasicList)) {
                dbCidReformItemMap = reformItemBasicList.stream().collect(Collectors.toMap(ReformItemBasic::getCid, Function.identity()));
            }
        }
        ProtectEquipIssueRecord protectEquParam = new ProtectEquipIssueRecord();
        protectEquParam.setCids(cids);
        protectEquParam.setBeginTime(DateUtils.getYearFirstTime((int)year));
        if (year > 2025) {
            protectEquParam.setEndTime(DateUtils.getYearLastTime((int)year));
        }
        List dbProtectEquipIssueLists = this.protectEquipIssueRecordDetailService.getDataTypeForArchive(protectEquParam);
        HashMap dbProtectEquipIssueMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)dbProtectEquipIssueLists)) {
            List fileItem410List;
            Map collect = dbProtectEquipIssueLists.stream().collect(Collectors.toMap(ProtectEquipIssueRecord::getCid, Function.identity()));
            dbProtectEquipIssueMap.putAll(collect);
            List fileItem410ArchiveIdList = archives.stream().filter(f -> dbProtectEquipIssueMap.containsKey(f.getCid())).map(LiteArchive::getId).distinct().collect(Collectors.toList());
            if ((forceUpdateFile == null || Objects.equals(forceUpdateFile, true)) && CollectionUtils.isNotEmpty((Collection)(fileItem410List = this.fileItemService.getByArchiveAndFileName(fileItem410ArchiveIdList, Long.valueOf(410L))))) {
                archiveIdFileItem410Map = fileItem410List.stream().collect(Collectors.toMap(LiteArchiveFileItem::getLiteArchiveId, Function.identity(), LiteArchiveUtils.filteItemMergeFunction));
            }
        }
        Map<Object, Object> complianceCheckPlanTwoYearMap = new HashMap();
        Map<Object, Object> cidCompanyMap = new HashMap();
        if (CollectionUtils.isNotEmpty(complianceCids) && CollectionUtils.isNotEmpty((Collection)(newCompliances = CollUtil.intersectionDistinct(cids, complianceCids, (Collection[])new Collection[0]))) && CollectionUtils.isNotEmpty((Collection)(onlyCompanyLists = this.superviseService.getOnlyCompanyByCid(new ArrayList(newCompliances))))) {
            cidCompanyMap = onlyCompanyLists.stream().collect(Collectors.toMap(CompanyBaseInfoModel::getId, Function.identity()));
            List occType2CidList = onlyCompanyLists.stream().filter(f -> f != null && Objects.equals(f.getOccupationalRiskClassify(), 2)).map(CompanyBaseInfoModel::getId).distinct().collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(occType2CidList)) {
                CheckPlanListParam checkParam = new CheckPlanListParam();
                checkParam.setStatus(Arrays.asList(new Integer[0]));
                checkParam.setReportStatusList(Arrays.asList(new Integer[0]));
                checkParam.setCheckTypes(Arrays.asList(2, 3, 4));
                checkParam.setCids(occType2CidList);
                checkParam.setCheckDateBegin(DateUtils.getYearFirstTime((int)(year - 2)));
                checkParam.setCheckDateEnd(DateUtils.getYearFirstTime((int)year));
                List lastCheckPlanInfo = this.checkPlanService.getLastCheckPlanInfo(param);
                if (CollectionUtils.isNotEmpty((Collection)lastCheckPlanInfo)) {
                    complianceCheckPlanTwoYearMap = lastCheckPlanInfo.stream().collect(Collectors.toMap(CheckPlan::getCid, Function.identity()));
                }
            }
        }
        ArrayList<LiteArchiveFileItem> fileItemList = new ArrayList<LiteArchiveFileItem>();
        for (LiteArchive archive : archives) {
            String files;
            Long cid = archive.getCid();
            Archive4ExtraModel extraModel = new Archive4ExtraModel();
            if (StringUtils.isBlank((CharSequence)fileNameIds) || StringUtils.contains((CharSequence)fileNameIds, (CharSequence)"403")) {
                fileItemList.add(LiteArchiveUtils.appendFileItem((Long)archive.getId(), (Long)403L, null, null, item -> {
                    item.setIsRequired(LiteArchiveRequiredEnum.NO.getCode());
                    item.setHgIsRequired(LiteArchiveRequiredEnum.UPLOAD.getCode());
                }));
            }
            if (StringUtils.isBlank((CharSequence)fileNameIds) || StringUtils.contains((CharSequence)fileNameIds, (CharSequence)"405")) {
                fileItemList.add(LiteArchiveUtils.appendFileItem((Long)archive.getId(), (Long)405L, null, null, item -> {
                    item.setIsRequired(LiteArchiveRequiredEnum.NO.getCode());
                    item.setHgIsRequired(LiteArchiveRequiredEnum.NO.getCode());
                }));
            }
            if (StringUtils.isBlank((CharSequence)fileNameIds) || StringUtils.contains((CharSequence)fileNameIds, (CharSequence)"406")) {
                fileItemList.add(LiteArchiveUtils.appendFileItem((Long)archive.getId(), (Long)406L, null, null, item -> {
                    item.setIsRequired(LiteArchiveRequiredEnum.NO.getCode());
                    item.setHgIsRequired(LiteArchiveRequiredEnum.NO.getCode());
                }));
            }
            if (StringUtils.isBlank((CharSequence)fileNameIds) || StringUtils.contains((CharSequence)fileNameIds, (CharSequence)"407")) {
                fileItemList.add(LiteArchiveUtils.appendFileItem((Long)archive.getId(), (Long)407L, null, null, item -> {
                    item.setIsRequired(LiteArchiveRequiredEnum.NO.getCode());
                    item.setHgIsRequired(LiteArchiveRequiredEnum.NO.getCode());
                }));
            }
            if (StringUtils.isBlank((CharSequence)fileNameIds) || StringUtils.contains((CharSequence)fileNameIds, (CharSequence)"404") || StringUtils.contains((CharSequence)fileNameIds, (CharSequence)"401") || StringUtils.contains((CharSequence)fileNameIds, (CharSequence)"402")) {
                LiteArchiveFileItem fileItem404 = LiteArchiveUtils.appendFileItem((Long)archive.getId(), (Long)404L, null, null, item -> {
                    item.setIsRequired(LiteArchiveRequiredEnum.DATA.getCode());
                    item.setHgIsRequired(LiteArchiveRequiredEnum.DATA.getCode());
                    item.setDataState(ArchiveFilteItemDataStateEnum.UNFULL.getValue());
                    item.setHgDataState(ArchiveFilteItemDataStateEnum.UNFULL.getValue());
                });
                CheckPlan lastCheckPlanInfo = (CheckPlan)dbCidCheckPlanMap.get(cid);
                if (lastCheckPlanInfo == null) {
                    fileItem404.setFileIds("");
                    fileItem404.setReferFileIds("");
                    ReformItemBasic reformItemBasic = (ReformItemBasic)dbCidReformItemMap.get(cid);
                    if (Objects.nonNull(reformItemBasic)) {
                        Byte status = reformItemBasic.getStatus();
                        extraModel.setRiskId(reformItemBasic.getId());
                        extraModel.setReformStatus(status);
                        if (status != null && (Objects.equals(status, (byte)3) || Objects.equals(status, (byte)4))) {
                            extraModel.setReformFinish(true);
                            fileItem404.setDataState(ArchiveFilteItemDataStateEnum.FULL.getValue());
                            fileItem404.setHgDataState(ArchiveFilteItemDataStateEnum.FULL.getValue());
                        }
                    }
                } else {
                    LiteArchiveFileItem dbfileItem404 = (LiteArchiveFileItem)archiveIdFileItem404Map.get(archive.getId());
                    extraModel.setCheckId(lastCheckPlanInfo.getId());
                    extraModel.setEvId(lastCheckPlanInfo.getRiskExposeEvaluateId());
                    files = this.generateArchive4Item404ArchiveFile(lastCheckPlanInfo, dbfileItem404, forceUpdateFile);
                    fileItem404.setDataState(ArchiveFilteItemDataStateEnum.FULL.getValue());
                    fileItem404.setHgDataState(ArchiveFilteItemDataStateEnum.FULL.getValue());
                    fileItem404.setFileIds(files);
                    fileItem404.setReferFileIds(files);
                }
                fileItemList.add(fileItem404);
                fileItemList.add(LiteArchiveUtils.appendFileItem((Long)archive.getId(), (Long)401L, null, null, item -> {
                    item.setIsRequired(LiteArchiveRequiredEnum.NO.getCode());
                    item.setHgIsRequired(LiteArchiveRequiredEnum.DATA.getCode());
                    if (extraModel != null && extraModel.getCheckId() != null) {
                        item.setDataState(ArchiveFilteItemDataStateEnum.FULL.getValue());
                        item.setHgDataState(ArchiveFilteItemDataStateEnum.FULL.getValue());
                    } else {
                        item.setDataState(ArchiveFilteItemDataStateEnum.UNFULL.getValue());
                        item.setHgDataState(ArchiveFilteItemDataStateEnum.UNFULL.getValue());
                    }
                }));
                fileItemList.add(LiteArchiveUtils.appendFileItem((Long)archive.getId(), (Long)402L, null, null, item -> {
                    item.setIsRequired(LiteArchiveRequiredEnum.NO.getCode());
                    item.setHgIsRequired(LiteArchiveRequiredEnum.DATA.getCode());
                    if (extraModel != null && extraModel.getCheckId() != null) {
                        item.setDataState(ArchiveFilteItemDataStateEnum.FULL.getValue());
                        item.setHgDataState(ArchiveFilteItemDataStateEnum.FULL.getValue());
                    } else {
                        item.setDataState(ArchiveFilteItemDataStateEnum.UNFULL.getValue());
                        item.setHgDataState(ArchiveFilteItemDataStateEnum.UNFULL.getValue());
                    }
                }));
            }
            if (StringUtils.isBlank((CharSequence)fileNameIds) || StringUtils.contains((CharSequence)fileNameIds, (CharSequence)"410")) {
                ProtectEquipIssueRecord protectEquipIssueRecord = (ProtectEquipIssueRecord)dbProtectEquipIssueMap.get(cid);
                LiteArchiveFileItem fileItem410 = LiteArchiveUtils.appendFileItem((Long)archive.getId(), (Long)410L, null, null, item -> {
                    item.setIsRequired(LiteArchiveRequiredEnum.DATA.getCode());
                    item.setHgIsRequired(LiteArchiveRequiredEnum.DATA.getCode());
                    item.setDataState(ArchiveFilteItemDataStateEnum.UNFULL.getValue());
                    item.setHgDataState(ArchiveFilteItemDataStateEnum.UNFULL.getValue());
                });
                if (protectEquipIssueRecord != null) {
                    extraModel.setEquipIssueId(protectEquipIssueRecord.getId());
                    fileItem410.setDataState(ArchiveFilteItemDataStateEnum.FULL.getValue());
                    fileItem410.setHgDataState(ArchiveFilteItemDataStateEnum.FULL.getValue());
                    LiteArchiveFileItem dbfileItem410 = (LiteArchiveFileItem)archiveIdFileItem410Map.get(archive.getId());
                    files = this.generate410FileId(protectEquipIssueRecord, dbfileItem410, forceUpdateFile);
                    fileItem410.setFileIds(files);
                    fileItem410.setReferFileIds(files);
                } else {
                    fileItem410.setFileIds("");
                    fileItem410.setReferFileIds("");
                }
                fileItemList.add(fileItem410);
            }
            if (StringUtils.isBlank((CharSequence)fileNameIds) || StringUtils.contains((CharSequence)fileNameIds, (CharSequence)"409")) {
                LiteArchiveFileItem fileItem = LiteArchiveUtils.appendFileItem((Long)archive.getId(), (Long)409L, null, null, item -> {
                    item.setIsRequired(LiteArchiveRequiredEnum.NO.getCode());
                    item.setHgIsRequired(LiteArchiveRequiredEnum.NO.getCode());
                });
                if (complianceCids.contains(cid)) {
                    CheckPlan checkPlan;
                    CompanySuperviseModel companySuperviseModel = (CompanySuperviseModel)cidCompanyMap.get(cid);
                    if (companySuperviseModel != null && Objects.equals(companySuperviseModel.getOccupationalRiskClassify(), 0)) {
                        fileItem.setHgIsRequired(LiteArchiveRequiredEnum.UPLOAD.getCode());
                    } else if (Objects.equals(companySuperviseModel.getOccupationalRiskClassify(), 2) && (checkPlan = (CheckPlan)complianceCheckPlanTwoYearMap.get(cid)) != null) {
                        fileItem.setHgIsRequired(LiteArchiveRequiredEnum.UPLOAD.getCode());
                    }
                }
                fileItemList.add(fileItem);
            }
            archive.setExtraJson(JSON.toJSONString((Object)extraModel));
        }
        ((Doc4GenerateLiteArchiveFile)SpringContextHolder.getBean(Doc4GenerateLiteArchiveFile.class)).saveLiteArchive4Datav2(fileItemList, archives, complianceCids);
    }

    @Transactional(readOnly=false)
    public void saveLiteArchive4Datav2(List<LiteArchiveFileItem> fileItemList, List<LiteArchive> archives, Set<Long> complianceCids) {
        this.fileItemService.batchAppendFileItemMutilArchive(fileItemList, Long.valueOf(7780L));
        this.liteArchiveService.mutilArchiveUpdateStatus(archives, complianceCids);
    }

    public Long getCheckPlanIdByYear(Integer checkYear, Long cid) {
        List rst;
        JqGridParam jparam = new JqGridParam();
        jparam.setRows(Integer.MAX_VALUE);
        jparam.setPage(1);
        CheckPlanListParam hc = new CheckPlanListParam();
        hc.setCid(cid);
        hc.setCheckTypes(Arrays.asList(2, 3, 4));
        if (Objects.nonNull(checkYear)) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(DateUtils.getYearFirstTime((int)checkYear));
            cal.add(1, -3);
            hc.setCheckDateBegin(cal.getTime());
            hc.setCheckDateEnd(DateUtils.getYearLastTime((int)checkYear));
        }
        return CollUtil.isNotEmpty((Collection)(rst = this.hazardCheckPlanService.getCheckPlanPage(jparam, hc, Boolean.valueOf(false)).getList())) && rst.size() > 0 ? rst.stream().max(Comparator.comparing(CheckPlanList::getCheckBeginTime)).get().getId() : null;
    }

    public Long getCheckPlanIdByYear2(Integer checkYear, Long cid) {
        CheckPlanListParam hc = new CheckPlanListParam();
        hc.setCid(cid);
        hc.setCheckTypes(Arrays.asList(2, 3, 4));
        if (Objects.nonNull(checkYear)) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(DateUtils.getYearFirstTime((int)checkYear));
            cal.add(1, -3);
            hc.setCheckDateBegin(cal.getTime());
            hc.setCheckDateEnd(DateUtils.getYearLastTime((int)checkYear));
        }
        return this.hazardCheckPlanService.getCheckPlanIdBySearch(hc);
    }

    public ReformItemBasic getRiskResolutionCheckPlanIsFinished(Long cid, Integer year) {
        JqGridParam jparam = new JqGridParam();
        jparam.setRows(1);
        jparam.setPage(1);
        RiskListSearch search = new RiskListSearch();
        search.setCid(cid);
        search.setSearchSource(Integer.valueOf(14));
        search.setYear(year);
        ReformSearchVo sv = new ReformSearchVo();
        sv.setYear(year);
        sv.setCid(cid);
        sv.setGenerationSource(ReformGenerationSourceEnum.DETECTION.getValue());
        sv.setBackStrName("cidAndStates");
        List reformItemBasicList = this.reformItemBasicService.getReformItemBasicList(sv);
        return CollectionUtils.isNotEmpty((Collection)reformItemBasicList) ? (ReformItemBasic)reformItemBasicList.get(0) : null;
    }

    private String getTempDir() {
        String tempDir = this.dataDir.getArchivePath() + File.separator + "LiteArchive4" + File.separator;
        String randomString = RandomGenerator.getRandomString((int)4);
        tempDir = tempDir + DateUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss") + File.separator + randomString + File.separator;
        return tempDir;
    }

    public LiteArchiveFileResult generateArchive4Item404(Long archviceId, Long cid, String title, Archive4ExtraModel extraModel) {
        int year = StringUtils.isNumber((String)title) ? Integer.parseInt(title) : 2022;
        CheckPlanListParam param = new CheckPlanListParam();
        param.setStatus(Arrays.asList(new Integer[0]));
        param.setReportStatusList(Arrays.asList(new Integer[0]));
        param.setCheckTypes(Arrays.asList(2, 3, 4));
        param.setCid(cid);
        param.setCheckDateBegin(DateUtils.getYearFirstTime((int)(year - 3)));
        List lastCheckPlanInfo = this.checkPlanService.getLastCheckPlanInfo(param);
        if (CollectionUtils.isEmpty((Collection)lastCheckPlanInfo)) {
            ReformItemBasic reformItemBasic = this.getRiskResolutionCheckPlanIsFinished(cid, year);
            if (Objects.nonNull(reformItemBasic)) {
                Byte status = reformItemBasic.getStatus();
                extraModel.setRiskId(reformItemBasic.getId());
                extraModel.setReformStatus(status);
                if (status != null && (Objects.equals(status, (byte)3) || Objects.equals(status, (byte)4))) {
                    extraModel.setReformFinish(true);
                    return new LiteArchiveFileResult(null, 1, extraModel);
                }
            }
        } else {
            CheckPlan checkPlan = (CheckPlan)lastCheckPlanInfo.get(0);
            LiteArchiveFileItem fileItem404 = this.fileItemService.getByArchiveAndFileName(archviceId, Long.valueOf(404L));
            if (fileItem404 != null && fileItem404.getUpdateDate() != null && checkPlan.getUpdateDate() != null) {
                Date checkUpdate = DateUtil.getDate((LocalDateTime)checkPlan.getUpdateDate());
                if (fileItem404.getUpdateDate().getTime() > checkUpdate.getTime()) {
                    return new LiteArchiveFileResult(fileItem404.getFileIds(), 1, extraModel);
                }
            }
            extraModel.setCheckId(checkPlan.getId());
            extraModel.setEvId(checkPlan.getRiskExposeEvaluateId());
            LinkedList<Doc4041WorkRoleHarmFactorShieldEquipVO> resultList = new LinkedList<Doc4041WorkRoleHarmFactorShieldEquipVO>();
            CheckResultParseQueryModel resultParam = new CheckResultParseQueryModel();
            resultParam.setCheckId(checkPlan.getId());
            resultParam.setCid(checkPlan.getCid());
            List checkRecordFileVos = this.resultParseService.queryCheckRecordByArchive(resultParam);
            if (CollUtil.isNotEmpty((Collection)checkRecordFileVos)) {
                for (Object info : checkRecordFileVos) {
                    Doc4041WorkRoleHarmFactorShieldEquipVO vo = new Doc4041WorkRoleHarmFactorShieldEquipVO();
                    vo.setOrgName(info.getWorkshop().trim());
                    vo.setWorkName(info.getWorkName().trim());
                    vo.setHarmFactorNames(info.getFactorName().trim());
                    vo.setWorkRoleUserCount(info.getWorkNum());
                    resultList.add(vo);
                }
            } else {
                List dataList = this.riskExposeEvaluateDataService.getRiskDataByShopAndPointGroup(checkPlan.getRiskExposeEvaluateId());
                if (CollUtil.isNotEmpty((Collection)dataList)) {
                    for (RiskExposeEvaluateData info : dataList) {
                        Doc4041WorkRoleHarmFactorShieldEquipVO vo = new Doc4041WorkRoleHarmFactorShieldEquipVO();
                        vo.setOrgName(info.getWorkshop().trim());
                        vo.setWorkName(info.getWorkName().trim());
                        vo.setHarmFactorNames(info.getFactorName().trim());
                        vo.setWorkRoleUserCount(info.getWorkNum());
                        resultList.add(vo);
                    }
                }
            }
            if (CollUtil.isEmpty(resultList)) {
                return new LiteArchiveFileResult(null, 1, extraModel);
            }
            HashMap<String, LinkedList<Doc4041WorkRoleHarmFactorShieldEquipVO>> dataMap = new HashMap<String, LinkedList<Doc4041WorkRoleHarmFactorShieldEquipVO>>();
            dataMap.put(HarmFactorTestArchiveDataMapKeyEnum.touchSummary.name(), resultList);
            File f = new File(this.getTempDir() + "\u5c97\u4f4d\u63a5\u89e6\u7684\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u6c47\u603b\u8868.doc");
            File file = Java2WordGeneratorTemp.createDoc(dataMap, (String)"liteachive/litedoc4/4041.ftl", (String)f.getAbsolutePath());
            this.logger.debug("\u4e0a\u4f20\u6587\u4ef6\u540d:" + file.getName());
            SysFileModel fileModel = this.ossUploadComponent.upload(file, cid);
            if (fileModel == null) {
                return new LiteArchiveFileResult(null, 1, extraModel);
            }
            return new LiteArchiveFileResult(String.valueOf(fileModel.getId()), 1, extraModel);
        }
        return new LiteArchiveFileResult(null, 0, extraModel);
    }

    public String generateArchive4Item404ArchiveFile(CheckPlan checkPlan, LiteArchiveFileItem fileItem404, Boolean forceUpdateFile) {
        if (Objects.equals(forceUpdateFile, false)) {
            return null;
        }
        if (forceUpdateFile == null && fileItem404 != null && fileItem404.getUpdateDate() != null && checkPlan.getUpdateDate() != null) {
            Date checkUpdate = DateUtil.getDate((LocalDateTime)checkPlan.getUpdateDate());
            if (fileItem404.getUpdateDate().getTime() > checkUpdate.getTime()) {
                return fileItem404.getFileIds();
            }
        }
        LinkedList<Doc4041WorkRoleHarmFactorShieldEquipVO> resultList = new LinkedList<Doc4041WorkRoleHarmFactorShieldEquipVO>();
        CheckResultParseQueryModel resultParam = new CheckResultParseQueryModel();
        resultParam.setCheckId(checkPlan.getId());
        resultParam.setCid(checkPlan.getCid());
        List checkRecordFileVos = this.resultParseService.queryCheckRecordByArchive(resultParam);
        if (CollUtil.isNotEmpty((Collection)checkRecordFileVos)) {
            for (Object info : checkRecordFileVos) {
                Doc4041WorkRoleHarmFactorShieldEquipVO vo = new Doc4041WorkRoleHarmFactorShieldEquipVO();
                vo.setOrgName(info.getWorkshop().trim());
                vo.setWorkName(info.getWorkName().trim());
                vo.setHarmFactorNames(info.getFactorName().trim());
                vo.setWorkRoleUserCount(info.getWorkNum());
                resultList.add(vo);
            }
        } else {
            List dataList = this.riskExposeEvaluateDataService.getRiskDataByShopAndPointGroup(checkPlan.getRiskExposeEvaluateId());
            if (CollUtil.isNotEmpty((Collection)dataList)) {
                for (RiskExposeEvaluateData info : dataList) {
                    Doc4041WorkRoleHarmFactorShieldEquipVO vo = new Doc4041WorkRoleHarmFactorShieldEquipVO();
                    vo.setOrgName(info.getWorkshop().trim());
                    vo.setWorkName(info.getWorkName().trim());
                    vo.setHarmFactorNames(info.getFactorName().trim());
                    vo.setWorkRoleUserCount(info.getWorkNum());
                    resultList.add(vo);
                }
            }
        }
        if (CollUtil.isEmpty(resultList)) {
            return null;
        }
        HashMap<String, LinkedList<Doc4041WorkRoleHarmFactorShieldEquipVO>> dataMap = new HashMap<String, LinkedList<Doc4041WorkRoleHarmFactorShieldEquipVO>>();
        dataMap.put(HarmFactorTestArchiveDataMapKeyEnum.touchSummary.name(), resultList);
        File f = new File(this.getTempDir() + "\u5c97\u4f4d\u63a5\u89e6\u7684\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u6c47\u603b\u8868.doc");
        File file = Java2WordGeneratorTemp.createDoc(dataMap, (String)"liteachive/litedoc4/4041.ftl", (String)f.getAbsolutePath());
        this.logger.debug("\u4e0a\u4f20\u6587\u4ef6\u540d:" + file.getName());
        SysFileModel fileModel = this.ossUploadComponent.upload(file, checkPlan.getCid());
        if (fileModel == null) {
            return null;
        }
        return String.valueOf(fileModel.getId());
    }

    public List<CheckPlan> checkArchive4Item409(Long cid, String title) {
        int year = StringUtils.isNumber((String)title) ? Integer.parseInt(title) : 2022;
        CheckPlanListParam param = new CheckPlanListParam();
        param.setStatus(Arrays.asList(new Integer[0]));
        param.setReportStatusList(Arrays.asList(new Integer[0]));
        param.setCheckTypes(Arrays.asList(2, 3, 4));
        param.setCid(cid);
        param.setCheckDateBegin(DateUtils.getYearFirstTime((int)(year - 2)));
        param.setCheckDateEnd(DateUtils.getYearFirstTime((int)year));
        List lastCheckPlanInfo = this.checkPlanService.getLastCheckPlanInfo(param);
        return lastCheckPlanInfo;
    }

    public LiteArchiveFileResult createHarmFactorTouchSummary4042(LiteArchive archive, String title, Archive4ExtraModel extraModel) {
        String fileId;
        Long cid = archive.getCid();
        Date yearFirstTime = null;
        yearFirstTime = title.equals("2023\u5e74\u4ee5\u524d") ? DateUtils.getYearFirstTime((int)2022) : DateUtils.getYearFirstTime((int)Integer.parseInt(title));
        ProtectEquipIssueRecord param = new ProtectEquipIssueRecord();
        param.setCid(cid);
        param.setBeginTime(yearFirstTime);
        List dataTypeForArchiveList = this.protectEquipIssueRecordDetailService.getDataTypeForArchive(param);
        if (CollectionUtils.isNotEmpty((Collection)dataTypeForArchiveList)) {
            return new LiteArchiveFileResult();
        }
        ProtectEquipIssueRecord dataTypeForArchive = (ProtectEquipIssueRecord)dataTypeForArchiveList.get(0);
        extraModel.setEquipIssueId(dataTypeForArchive.getId());
        if (Objects.equals(dataTypeForArchive.getReportType(), 1)) {
            List resultList = this.protectEquipIssueRecordDetailService.getDataListForArchive(dataTypeForArchive.getId());
            if (CollUtil.isEmpty((Collection)resultList)) {
                return new LiteArchiveFileResult(null, 1, extraModel);
            }
            LiteArchiveFileItem fileItem410 = this.fileItemService.getByArchiveAndFileName(archive.getId(), Long.valueOf(410L));
            if (fileItem410 != null && fileItem410.getUpdateDate() != null && dataTypeForArchive.getUpdateDate() != null && fileItem410.getUpdateDate().getTime() > dataTypeForArchive.getUpdateDate().getTime()) {
                return new LiteArchiveFileResult(fileItem410.getFileIds(), 1, extraModel);
            }
            this.logger.debug("\u63a5\u89e6\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u6c47\u603b\u8868-\u5c97\u4f4d\u914d\u5907\u7684\u4e2a\u4eba\u9632\u62a4\u7528\u54c1\u6c47\u603b\u8868\u2014\u2014>\u6700\u7ec8\u6570\u636e\u96c6:" + JsonUtils.toJsonString((Object)resultList));
            HashMap<String, List> dataMap = new HashMap<String, List>();
            dataMap.put(HarmFactorTestArchiveDataMapKeyEnum.touchSummary.name(), resultList);
            File f = new File(this.getTempDir() + "\u5c97\u4f4d\u914d\u5907\u7684\u4e2a\u4eba\u9632\u62a4\u7528\u54c1\u6c47\u603b\u8868.doc");
            File file = Java2WordGeneratorTemp.createDoc(dataMap, (String)"liteachive/litedoc4/4042.ftl", (String)f.getAbsolutePath());
            this.logger.debug("\u4e0a\u4f20\u6587\u4ef6\u540d:" + file.getName());
            SysFileModel fileModel = this.ossUploadComponent.upload(file, cid);
            if (fileModel == null) {
                return new LiteArchiveFileResult();
            }
            fileId = String.valueOf(fileModel.getId());
        } else {
            fileId = dataTypeForArchive.getCredentialFileId();
        }
        return new LiteArchiveFileResult(fileId, 1, extraModel);
    }

    public String generate410FileId(ProtectEquipIssueRecord dataTypeForArchive, LiteArchiveFileItem fileItem410, Boolean forceUpdateFile) {
        if (Objects.isNull(dataTypeForArchive) || Objects.equals(forceUpdateFile, false)) {
            return null;
        }
        if (Objects.equals(dataTypeForArchive.getReportType(), 1)) {
            if (forceUpdateFile == null && fileItem410 != null && fileItem410.getUpdateDate() != null && dataTypeForArchive.getUpdateDate() != null && fileItem410.getUpdateDate().getTime() > dataTypeForArchive.getUpdateDate().getTime()) {
                return fileItem410.getFileIds();
            }
            List resultList = this.protectEquipIssueRecordDetailService.getDataListForArchive(dataTypeForArchive.getId());
            if (CollUtil.isEmpty((Collection)resultList)) {
                return null;
            }
            HashMap<String, List> dataMap = new HashMap<String, List>();
            dataMap.put(HarmFactorTestArchiveDataMapKeyEnum.touchSummary.name(), resultList);
            File f = new File(this.getTempDir() + "\u5c97\u4f4d\u914d\u5907\u7684\u4e2a\u4eba\u9632\u62a4\u7528\u54c1\u6c47\u603b\u8868.doc");
            File file = Java2WordGeneratorTemp.createDoc(dataMap, (String)"liteachive/litedoc4/4042.ftl", (String)f.getAbsolutePath());
            this.logger.debug("\u4e0a\u4f20\u6587\u4ef6\u540d:" + file.getName());
            SysFileModel fileModel = this.ossUploadComponent.upload(file, dataTypeForArchive.getCid());
            if (fileModel == null) {
                return null;
            }
            return String.valueOf(fileModel.getId());
        }
        return dataTypeForArchive.getCredentialFileId();
    }

    @Deprecated
    private List<DeviceMaterialHarm> deviceList(Long cid) {
        JqGridParam param = new JqGridParam();
        param.setCid(cid);
        param.setPage(1);
        param.setRows(Integer.MAX_VALUE);
        List list = this.deviceListViewService.getDeviceInfoItemList(param).getList();
        HashMap<Long, DeviceListView> deviceIdToObjMap = new HashMap<Long, DeviceListView>();
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<Long> deviceIds = new LinkedList<Long>();
        for (DeviceListView deviceListView : list) {
            if (!Boolean.TRUE.equals(deviceListView.getIsHarm())) continue;
            deviceIds.add(deviceListView.getId());
            deviceIdToObjMap.put(deviceListView.getId(), deviceListView);
        }
        Map<Long, String> deviceIdToHarmNameMap = this.deviceIdToHarmNameMap(deviceIds);
        Map<Long, String> deviceIdToWorkNameMap = this.deviceIdToWorkNameMap(deviceIds);
        LinkedList<DeviceMaterialHarm> deviceList = new LinkedList<DeviceMaterialHarm>();
        for (Map.Entry<Long, String> entry : deviceIdToHarmNameMap.entrySet()) {
            String useareaName;
            Long dId = entry.getKey();
            DeviceListView deviceListView = (DeviceListView)deviceIdToObjMap.get(dId);
            if (deviceListView == null) continue;
            DeviceMaterialHarm harm = new DeviceMaterialHarm();
            harm.setType(Integer.valueOf(1));
            harm.setName(deviceListView.getDeviceName());
            harm.setId(dId);
            harm.setHarmNames(entry.getValue());
            harm.setCreateDate(deviceListView.getCreateDate());
            String workName = deviceIdToWorkNameMap.get(dId);
            if (workName == null) {
                workName = "";
            }
            if ((useareaName = deviceListView.getUseareaname()) == null) {
                useareaName = "";
            }
            harm.setAreaOrWorkName(workName + " " + useareaName);
            String manufacturer = deviceListView.getManufacturer();
            String supplier = deviceListView.getSupplier();
            if (manufacturer == null) {
                manufacturer = "";
            }
            if (supplier == null) {
                supplier = "";
            }
            harm.setProviderNames(manufacturer + " " + supplier);
            deviceList.add(harm);
        }
        return deviceList;
    }

    @Deprecated
    private Map<Long, String> deviceIdToHarmNameMap(List<Long> deviceIds) {
        List harmList = this.deviceHarmfactorService.getListByDeviceIds(deviceIds);
        HashMap<Long, String> deviceIdToHarmNameMap = new HashMap<Long, String>();
        for (DeviceHarmfactor deviceHarmfactor : harmList) {
            String harmName = deviceHarmfactor.getHarmName();
            if (harmName == null || harmName.isEmpty()) continue;
            Long dId = deviceHarmfactor.getDeviceId();
            String harms = (String)deviceIdToHarmNameMap.get(dId);
            if (harms == null) {
                harms = harmName;
                deviceIdToHarmNameMap.put(dId, harms);
                continue;
            }
            if (harms.contains(harmName)) continue;
            deviceIdToHarmNameMap.put(dId, harms + "," + harmName);
        }
        return deviceIdToHarmNameMap;
    }

    @Deprecated
    private Map<Long, String> deviceIdToWorkNameMap(List<Long> deviceIds) {
        List wroklist = this.deviceWorkroleService.getListByDeviceIds(deviceIds);
        HashMap<Long, String> deviceIdToWorkNameMap = new HashMap<Long, String>();
        for (DeviceWorkrole deviceWorkrole : wroklist) {
            Long dId = deviceWorkrole.getDeviceId();
            String workName = deviceWorkrole.getWorkName();
            if (dId == null || workName == null || workName.isEmpty()) continue;
            String workNames = (String)deviceIdToWorkNameMap.get(dId);
            if (workNames == null) {
                deviceIdToWorkNameMap.put(dId, workName);
                continue;
            }
            if (workNames.contains(workName)) continue;
            deviceIdToWorkNameMap.put(dId, workNames + "," + workName);
        }
        return deviceIdToWorkNameMap;
    }

    @Deprecated
    private String doCrateDeviceHarmFile(Long cid, List<DeviceMaterialHarm> deviceList, List<DeviceMaterialHarm> materialList) {
        HashMap dataMap = new HashMap();
        LinkedList<DeviceMaterialHarm> dataList = new LinkedList<DeviceMaterialHarm>();
        dataList.addAll(materialList);
        dataMap.put("dataList", dataList);
        this.logger.debug("LiteArchiveFileItemServiceImpl::\u53ef\u80fd\u4ea7\u751f\u804c\u4e1a\u75c5\u5371\u5bb3\u7684\u8bbe\u5907\u3001\u6750\u6599\uff08\u5316\u5b66\u54c1\uff09\u4e00\u89c8\u8868-\u6570\u636e\u5927\u5c0f:{}", (Object)dataList.size());
        File f = new File("\u53ef\u80fd\u4ea7\u751f\u804c\u4e1a\u75c5\u5371\u5bb3\u7684\u8bbe\u5907\u3001\u6750\u6599\uff08\u5316\u5b66\u54c1\uff09\u4e00\u89c8\u8868.doc");
        File file = Java2WordGeneratorTemp.createDoc(dataMap, (String)"liteachive/litedoc4/403.ftl", (String)f.getAbsolutePath());
        this.logger.debug("\u4e0a\u4f20\u6587\u4ef6\u540d:" + file.getName());
        SysFileModel fileModel = this.ossUploadComponent.upload(file, cid);
        if (fileModel == null) {
            return "";
        }
        f.delete();
        return String.valueOf(fileModel.getId());
    }
}

