/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.litearchive.imp;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.SpringContextHolder;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.modules.health.dao.work.certificate.CertificateStaffDetailMapper;
import cn.smarthse.modules.health.entity.litearchive.LiteArchive;
import cn.smarthse.modules.health.entity.litearchive.LiteArchiveFileItem;
import cn.smarthse.modules.health.entity.work.certificate.CertificateStaffDetail;
import cn.smarthse.modules.health.enums.archive.ArchiveFilteItemDataStateEnum;
import cn.smarthse.modules.health.enums.archive.LiteArchiveRequiredEnum;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveFileItemService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveService;
import cn.smarthse.modules.health.service.work.certificate.ICertificateStaffDetailService;
import cn.smarthse.modules.health.util.LiteArchiveUtils;
import cn.smarthse.modules.health.vo.work.certificate.CertificateStaffCountVo;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StopWatch;

@Component
public class Doc3GenerateLiteArchiveFile {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired(required=false)
    @Lazy
    ILiteArchiveFileItemService fileItemService;
    @Autowired
    private ILiteArchiveService liteArchiveService;
    @Autowired
    private CertificateStaffDetailMapper certificateStaffDetailMapper;
    @Autowired
    private ICertificateStaffDetailService certificateStaffDetailService;

    public List<LiteArchiveFileItem> doCreateFileItemList(LiteArchive archive, String fileNameIds) {
        Long complianceCompany;
        Long cid = archive.getCid();
        Integer year = 2022;
        String docParamValue = archive.getTitle();
        if (!docParamValue.equals("2023\u5e74\u4ee5\u524d") && StringUtils.isNumber((String)docParamValue)) {
            year = Integer.parseInt(docParamValue);
        }
        boolean isComplianceCompany = (complianceCompany = this.liteArchiveService.isComplianceCompany(cid)) != null;
        StopWatch sw = new StopWatch();
        CertificateStaffDetail param = new CertificateStaffDetail();
        param.setCid(cid);
        ArrayList<LiteArchiveFileItem> fileItemList = new ArrayList<LiteArchiveFileItem>();
        if (StringUtils.isBlank((CharSequence)fileNameIds) || StringUtils.contains((CharSequence)fileNameIds, (CharSequence)"302")) {
            sw.start("\u7528\u4eba\u5355\u4f4d\u8d1f\u8d23\u4eba\u3001\u7ba1\u7406\u4eba\u5458\u804c\u4e1a\u536b\u751f\u57f9\u8bad\u8bc1\u660e");
            LiteArchiveFileItem fileItem302 = LiteArchiveUtils.appendFileItem((Long)archive.getId(), (Long)302L, null, null, item -> {
                item.setIsRequired(LiteArchiveRequiredEnum.DATA.getCode());
                item.setHgIsRequired(LiteArchiveRequiredEnum.DATA.getCode());
                item.setDataState(ArchiveFilteItemDataStateEnum.UNFULL.getValue());
                item.setHgDataState(ArchiveFilteItemDataStateEnum.UNFULL.getValue());
            });
            if (year == 2022) {
                Long certId = this.liteArchiveService.checkCertStaffValidDataByYear("" + year, cid);
                if (certId != null) {
                    fileItem302.setDataState(ArchiveFilteItemDataStateEnum.FULL.getValue());
                    fileItem302.setHgDataState(ArchiveFilteItemDataStateEnum.FULL.getValue());
                } else {
                    fileItem302.setDataState(ArchiveFilteItemDataStateEnum.UNFULL.getValue());
                    fileItem302.setHgDataState(ArchiveFilteItemDataStateEnum.UNFULL.getValue());
                }
            } else {
                Date validityDate = DateUtils.getYearFirstTime((int)year);
                if (year == 2024) {
                    validityDate = DateUtil.getDate((LocalDateTime)cn.hutool.core.date.DateUtil.parseLocalDateTime((CharSequence)"2024-06-01 00:00:00"));
                }
                param.setValidityDate(validityDate);
                int countArchiveCertByCid = this.certificateStaffDetailMapper.countArchiveCertByCid(param);
                if (countArchiveCertByCid > 0) {
                    fileItem302.setDataState(ArchiveFilteItemDataStateEnum.FULL.getValue());
                    fileItem302.setHgDataState(ArchiveFilteItemDataStateEnum.FULL.getValue());
                } else {
                    fileItem302.setDataState(ArchiveFilteItemDataStateEnum.UNFULL.getValue());
                    fileItem302.setHgDataState(ArchiveFilteItemDataStateEnum.UNFULL.getValue());
                }
            }
            fileItemList.add(fileItem302);
            sw.stop();
        }
        if (StringUtils.isBlank((CharSequence)fileNameIds) || StringUtils.contains((CharSequence)fileNameIds, (CharSequence)"301")) {
            sw.start("\u7528\u4eba\u5355\u4f4d\u804c\u4e1a\u536b\u751f\u57f9\u8bad\u8ba1\u5212");
            fileItemList.add(LiteArchiveUtils.appendFileItem((Long)archive.getId(), (Long)301L, null, null, item -> {
                item.setIsRequired(LiteArchiveRequiredEnum.NO.getCode());
                item.setHgIsRequired(LiteArchiveRequiredEnum.UPLOAD.getCode());
            }));
            sw.stop();
        }
        if (StringUtils.isBlank((CharSequence)fileNameIds) || StringUtils.contains((CharSequence)fileNameIds, (CharSequence)"303")) {
            sw.start("\u52b3\u52a8\u8005\u804c\u4e1a\u536b\u751f\u5ba3\u4f20\u57f9\u8bad\u5217\u8868");
            Date yearFirstTime = DateUtils.getYearFirstTime((int)year);
            Date yearLastTime = DateUtils.getYearLastTime((int)year);
            fileItemList.add(LiteArchiveUtils.appendFileItem((Long)archive.getId(), (Long)303L, null, null, item -> {
                item.setIsRequired(LiteArchiveRequiredEnum.NO.getCode());
                item.setHgIsRequired(LiteArchiveRequiredEnum.DATA.getCode());
                if (isComplianceCompany) {
                    Long aLong = this.certificateStaffDetailMapper.countComplianceStaff(cid, yearFirstTime, yearLastTime);
                    if (aLong > 0L) {
                        item.setHgDataState(ArchiveFilteItemDataStateEnum.FULL.getValue());
                    } else {
                        item.setHgDataState(ArchiveFilteItemDataStateEnum.UNFULL.getValue());
                    }
                }
            }));
            sw.stop();
        }
        if (StringUtils.isBlank((CharSequence)fileNameIds) || StringUtils.contains((CharSequence)fileNameIds, (CharSequence)"304")) {
            sw.start("\u5e74\u5ea6\u804c\u4e1a\u536b\u751f\u57f9\u8bad\u5de5\u4f5c\u603b\u7ed3");
            fileItemList.add(LiteArchiveUtils.appendFileItem((Long)archive.getId(), (Long)304L, null, null, item -> {
                item.setIsRequired(LiteArchiveRequiredEnum.NO.getCode());
                item.setHgIsRequired(LiteArchiveRequiredEnum.UPLOAD.getCode());
            }));
            sw.stop();
        }
        sw.start("\u66f4\u65b0\u6863\u6848\u72b6\u6001");
        ((Doc3GenerateLiteArchiveFile)SpringContextHolder.getBean(Doc3GenerateLiteArchiveFile.class)).saveLiteArchive3Data(fileItemList, archive.getId(), isComplianceCompany);
        sw.stop();
        return null;
    }

    @Transactional(readOnly=false)
    public void saveLiteArchive3Data(List<LiteArchiveFileItem> fileItemList, Long archiveId, boolean isComplianceCompany) {
        this.fileItemService.batchAppendFileItem(fileItemList, archiveId, Integer.valueOf(3), Long.valueOf(7780L));
        this.liteArchiveService.newUpdateStatus(archiveId, isComplianceCompany);
    }

    public List<LiteArchiveFileItem> doCreateFileItemListv2(List<LiteArchive> archives, Integer year, Set<Long> complianceCids, String fileNameIds) {
        Date yearLastTime;
        Date yearFirstTime;
        List<CertificateStaffCountVo> staffCountVos;
        Set newCompliances;
        if (CollectionUtils.isEmpty(archives)) {
            return null;
        }
        List cids = archives.stream().map(LiteArchive::getCid).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        ArrayList<LiteArchiveFileItem> fileItemList = new ArrayList<LiteArchiveFileItem>();
        Date validityDate = DateUtils.getYearFirstTime((int)year);
        if (year == 2024) {
            validityDate = DateUtil.getDate((LocalDateTime)cn.hutool.core.date.DateUtil.parseLocalDateTime((CharSequence)"2024-06-01 00:00:00"));
        }
        List certificateStaffCountVos = this.certificateStaffDetailService.countCertByCids(cids, validityDate);
        Set<Object> hasvalidityCertCidSet = new HashSet();
        if (CollectionUtils.isNotEmpty((Collection)certificateStaffCountVos)) {
            hasvalidityCertCidSet = certificateStaffCountVos.stream().map(CertificateStaffCountVo::getCid).filter(Objects::nonNull).collect(Collectors.toSet());
        }
        HashSet certStaffSet = new HashSet();
        if (CollectionUtils.isNotEmpty(complianceCids) && CollectionUtils.isNotEmpty((Collection)(newCompliances = CollUtil.intersectionDistinct(cids, complianceCids, (Collection[])new Collection[0]))) && CollectionUtils.isNotEmpty(staffCountVos = this.certificateStaffDetailMapper.countComplianceStaffByCids(new ArrayList<Long>(newCompliances), yearFirstTime = DateUtils.getYearFirstTime((int)year), yearLastTime = DateUtils.getYearLastTime((int)year)))) {
            Set certStaffSetTemp = staffCountVos.stream().map(CertificateStaffCountVo::getCid).collect(Collectors.toSet());
            certStaffSet.addAll(certStaffSetTemp);
        }
        for (LiteArchive archive : archives) {
            Long cid = archive.getCid();
            LiteArchiveFileItem fileItem302 = LiteArchiveUtils.appendFileItem((Long)archive.getId(), (Long)302L, null, null, item -> {
                item.setIsRequired(LiteArchiveRequiredEnum.DATA.getCode());
                item.setHgIsRequired(LiteArchiveRequiredEnum.DATA.getCode());
                item.setDataState(ArchiveFilteItemDataStateEnum.UNFULL.getValue());
                item.setHgDataState(ArchiveFilteItemDataStateEnum.UNFULL.getValue());
            });
            if (hasvalidityCertCidSet.contains(cid)) {
                fileItem302.setDataState(ArchiveFilteItemDataStateEnum.FULL.getValue());
                fileItem302.setHgDataState(ArchiveFilteItemDataStateEnum.FULL.getValue());
            } else {
                fileItem302.setDataState(ArchiveFilteItemDataStateEnum.UNFULL.getValue());
                fileItem302.setHgDataState(ArchiveFilteItemDataStateEnum.UNFULL.getValue());
            }
            fileItemList.add(fileItem302);
            fileItemList.add(LiteArchiveUtils.appendFileItem((Long)archive.getId(), (Long)301L, null, null, item -> {
                item.setIsRequired(LiteArchiveRequiredEnum.NO.getCode());
                item.setHgIsRequired(LiteArchiveRequiredEnum.UPLOAD.getCode());
            }));
            fileItemList.add(LiteArchiveUtils.appendFileItem((Long)archive.getId(), (Long)303L, null, null, item -> {
                item.setIsRequired(LiteArchiveRequiredEnum.NO.getCode());
                item.setHgIsRequired(LiteArchiveRequiredEnum.DATA.getCode());
                if (complianceCids.contains(cid)) {
                    if (certStaffSet.contains(cid)) {
                        item.setHgDataState(ArchiveFilteItemDataStateEnum.FULL.getValue());
                    } else {
                        item.setHgDataState(ArchiveFilteItemDataStateEnum.UNFULL.getValue());
                    }
                }
            }));
            fileItemList.add(LiteArchiveUtils.appendFileItem((Long)archive.getId(), (Long)304L, null, null, item -> {
                item.setIsRequired(LiteArchiveRequiredEnum.NO.getCode());
                item.setHgIsRequired(LiteArchiveRequiredEnum.UPLOAD.getCode());
            }));
        }
        ((Doc3GenerateLiteArchiveFile)SpringContextHolder.getBean(Doc3GenerateLiteArchiveFile.class)).saveLiteArchive3Data2(fileItemList, archives, complianceCids);
        return null;
    }

    @Transactional(readOnly=false)
    public void saveLiteArchive3Data2(List<LiteArchiveFileItem> fileItemList, List<LiteArchive> archives, Set<Long> complianceCidSet) {
        this.fileItemService.batchAppendFileItemMutilArchive(fileItemList, Long.valueOf(7780L));
        this.liteArchiveService.mutilArchiveUpdateStatus(archives, complianceCidSet);
    }
}

