/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.information;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.dao.information.InformationKeywordMapper;
import cn.smarthse.modules.health.entity.information.InformationKeyword;
import cn.smarthse.modules.health.service.information.IInformationKeywordService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
public class InformationKeywordServiceImp
extends BaseServiceImpl<InformationKeywordMapper, InformationKeyword>
implements IInformationKeywordService {
    @Transactional(readOnly=false)
    public void addWords(List<String> words, Long informationId, Long userId) {
        if (words == null) {
            return;
        }
        for (String word : words) {
            InformationKeyword keyword = new InformationKeyword();
            keyword.setInformationId(informationId);
            keyword.setKeyword(word);
            keyword.setIsValid(Boolean.valueOf(true));
            keyword.setCreateBy(userId);
            keyword.setUpdateBy(userId);
            keyword.setCreateDate(new Date());
            keyword.setUpdateDate(new Date());
            this.add(keyword);
        }
    }

    public List<String> getCurrent(int size) {
        PageHelper.startPage((int)1, (int)size);
        Example example = new Example(InformationKeyword.class);
        example.createCriteria().andEqualTo("isValid", (Object)true);
        example.setOrderByClause("create_date desc");
        List list = this.getListByExample(example);
        PageInfo info = new PageInfo(list);
        return info.getList().stream().map(InformationKeyword::getKeyword).collect(Collectors.toList());
    }

    public List<String> getByInformationId(Long informationId) {
        Example example = new Example(InformationKeyword.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("informationId", (Object)informationId);
        return this.getListByExample(example).stream().map(InformationKeyword::getKeyword).collect(Collectors.toList());
    }

    @Transactional(readOnly=false)
    public void removeByInformationId(Long informationId) {
        ((InformationKeywordMapper)this.dao).removeByInformationId(informationId);
    }
}

