/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.foreign.weChat;

import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.common.IStaffInfoQueryService;
import cn.smarthse.modules.common.model.CompanyModel;
import cn.smarthse.modules.common.model.PageParamModel;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicWork;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffWorkRole;
import cn.smarthse.modules.health.entity.base.workinfo.WorkRoleInfo;
import cn.smarthse.modules.health.entity.work.check.vo.HHealthCheckParam;
import cn.smarthse.modules.health.entity.work.harmfactor.HarmfactorWorkSource;
import cn.smarthse.modules.health.entity.work.harmfactor.Vo.HarmfactorWorkSourceInfoVo;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCheckPlan;
import cn.smarthse.modules.health.entity.work.informmanager.ContractInform;
import cn.smarthse.modules.health.entity.work.informmanager.ContractInformTemplate;
import cn.smarthse.modules.health.entity.work.informmanager.OccupationalDiseaseContraindication;
import cn.smarthse.modules.health.enums.staff.StaffWorkPropertyEnum;
import cn.smarthse.modules.health.model.HContractInfoModel;
import cn.smarthse.modules.health.model.HContractInfoOccModel;
import cn.smarthse.modules.health.model.HDetectionModel;
import cn.smarthse.modules.health.model.HDetectionOccModel;
import cn.smarthse.modules.health.model.HHealthCheckModel;
import cn.smarthse.modules.health.model.HProEquipmentDetailModel;
import cn.smarthse.modules.health.model.HTrainingModel;
import cn.smarthse.modules.health.model.HistoryCompanyModel;
import cn.smarthse.modules.health.model.HistoryWorkRoleModel;
import cn.smarthse.modules.health.provider.IHealthStaffInfoQueryService;
import cn.smarthse.modules.health.service.base.staff.IStaffBasicInfoService;
import cn.smarthse.modules.health.service.base.staff.IStaffBasicWorkService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.base.staff.IStaffWorkRoleService;
import cn.smarthse.modules.health.service.base.workinfo.IWorkRoleInfoService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckService;
import cn.smarthse.modules.health.service.work.harmfactor.IHarmfactorWorkService;
import cn.smarthse.modules.health.service.work.hccheckplan.IHcCheckPlanService;
import cn.smarthse.modules.health.service.work.hccheckplan.IHcCheckResultCollectDataService;
import cn.smarthse.modules.health.service.work.informmanager.IContractInformService;
import cn.smarthse.modules.health.service.work.informmanager.IContractInformTemplateService;
import cn.smarthse.modules.health.service.work.shield.IShieldEquipRuleDetailService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class HealthStaffInfoQueryServiceImpl
implements IHealthStaffInfoQueryService,
IStaffInfoQueryService {
    @Autowired
    private IStaffBasicWorkService staffBasicWorkService;
    @Autowired
    private IHcCheckResultCollectDataService hcCheckResultCollectDataService;
    @Autowired
    private IHcCheckPlanService hcCheckPlanService;
    @Autowired
    private IHarmfactorWorkService harmfactorWorkService;
    @Autowired
    private IContractInformTemplateService contractInformTemplateService;
    @Autowired
    private IWorkRoleInfoService workRoleInfoService;
    @Autowired
    private IContractInformService contractInformService;
    @Autowired
    private IStaffInfoService staffInfoService;
    @Autowired
    private IStaffWorkRoleService staffWorkRoleService;
    @Autowired
    private IStaffBasicInfoService staffBasicInfoService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideByHSEService companyService;
    @Autowired
    private IPhcPhysicalCheckService phcPhysicalCheckService;
    @Autowired
    IShieldEquipRuleDetailService shieldEquipRuleDetailService;

    public List<HContractInfoModel> getContractInfoList(PageParamModel paramModel) {
        List basicInfoList = this.staffBasicInfoService.getStaffBasicInfosByCardIdAndCid(paramModel.getIdCard(), paramModel.getCid());
        ArrayList<Long> basicIds = new ArrayList<Long>();
        for (StaffBasicInfo s : basicInfoList) {
            basicIds.add(s.getId());
        }
        List infoList = this.staffInfoService.getStaffInfosByStaffBasicIds(basicIds, paramModel.getCid());
        Object staffIds = "-9";
        for (StaffInfo s : infoList) {
            staffIds = (String)staffIds + "," + s.getId();
        }
        List works = this.staffWorkRoleService.getStaffWorkRoleByStaffIdsAndStartDateAndEndDateAndCid((String)staffIds, paramModel.getStartDate(), paramModel.getEndDate(), paramModel.getCid());
        staffIds = "-9";
        Object workIds = "-9";
        HashMap<CallSite, StaffWorkRole> map = new HashMap<CallSite, StaffWorkRole>();
        for (StaffWorkRole s : works) {
            staffIds = (String)staffIds + "," + s.getStaffId();
            workIds = (String)workIds + "," + s.getWorkRoleId();
            map.put((CallSite)((Object)(s.getStaffId() + ":" + s.getWorkRoleId())), s);
        }
        List list = this.contractInformService.getContractInformByStaffIdsAndWorkIdsAndCid((String)staffIds, (String)workIds, paramModel.getCid());
        for (HContractInfoModel c : list) {
            WorkRoleInfo w;
            StaffWorkRole s = (StaffWorkRole)map.get(c.getStaffId() + ":" + c.getWorkId());
            if (s == null) continue;
            c.setStartDate(s.getBeginTime());
            c.setEndDate(s.getLeaveTime());
            if (c.getWorkId() == null || (w = (WorkRoleInfo)this.workRoleInfoService.getById(c.getWorkId())) == null) continue;
            c.setWorkRoleName(w.getWorkName());
        }
        return list;
    }

    public PageInfo<HContractInfoModel> getContractInfoPage(PageParamModel paramModel) {
        List basicInfoList = this.staffBasicInfoService.getStaffBasicInfosByCardIdAndCid(paramModel.getIdCard(), paramModel.getCid());
        ArrayList<Long> basicIds = new ArrayList<Long>();
        for (StaffBasicInfo s : basicInfoList) {
            basicIds.add(s.getId());
        }
        List infoList = this.staffInfoService.getStaffInfosByStaffBasicIds(basicIds, paramModel.getCid());
        Object staffIds = "-9";
        for (StaffInfo s : infoList) {
            staffIds = (String)staffIds + "," + s.getId();
        }
        List works = this.staffWorkRoleService.getStaffWorkRoleByStaffIdsAndStartDateAndEndDateAndCid((String)staffIds, paramModel.getStartDate(), paramModel.getEndDate(), paramModel.getCid());
        staffIds = "-9";
        Object workIds = "-9";
        HashMap<CallSite, StaffWorkRole> map = new HashMap<CallSite, StaffWorkRole>();
        for (StaffWorkRole s : works) {
            staffIds = (String)staffIds + "," + s.getStaffId();
            workIds = (String)workIds + "," + s.getWorkRoleId();
            map.put((CallSite)((Object)(s.getStaffId() + ":" + s.getWorkRoleId())), s);
        }
        PageHelper.startPage((int)paramModel.getPageInfo().getPageNum(), (int)paramModel.getPageInfo().getPageSize());
        List list = this.contractInformService.getContractInformByStaffIdsAndWorkIdsAndCid((String)staffIds, (String)workIds, paramModel.getCid());
        for (HContractInfoModel c : list) {
            WorkRoleInfo w;
            StaffWorkRole s = (StaffWorkRole)map.get(c.getStaffId() + ":" + c.getWorkId());
            if (s == null) continue;
            c.setStartDate(s.getBeginTime());
            c.setEndDate(s.getLeaveTime());
            if (c.getWorkId() == null || (w = (WorkRoleInfo)this.workRoleInfoService.getById(c.getWorkId())) == null) continue;
            c.setWorkRoleName(w.getWorkName());
        }
        return new PageInfo(list);
    }

    public List<HHealthCheckModel> getHealthCheckList(PageParamModel paramModel) {
        List models = this.phcPhysicalCheckService.getHealthCheckList(paramModel);
        return models;
    }

    public PageInfo<HHealthCheckModel> getHealthCheckPage(PageParamModel paramModel) {
        return this.phcPhysicalCheckService.getHealthCheckPage(paramModel);
    }

    public HHealthCheckModel getHealthConclusion(Long healthCheckId, Long staffId, String checkType) {
        HHealthCheckParam param = new HHealthCheckParam();
        param.setCheckId(healthCheckId);
        ArrayList<Long> staffIds = new ArrayList<Long>();
        staffIds.add(staffId);
        param.setCheckStaffs(staffIds);
        param.setCheckType(checkType);
        HHealthCheckModel model = this.phcPhysicalCheckService.getHealthCheckList(param);
        return model;
    }

    public List<HTrainingModel> getTrainingList(PageParamModel paramModel) {
        return null;
    }

    public List<HDetectionModel> getDetectionList(PageParamModel paramModel) {
        List basicInfoList = this.staffBasicInfoService.getStaffBasicInfosByCardIdAndCid(paramModel.getIdCard(), paramModel.getCid());
        ArrayList<Long> basicIds = new ArrayList<Long>();
        for (StaffBasicInfo s : basicInfoList) {
            basicIds.add(s.getId());
        }
        List infoList = this.staffInfoService.getStaffInfosByStaffBasicIds(basicIds, paramModel.getCid());
        Object staffIds = "-9";
        for (StaffInfo s : infoList) {
            staffIds = (String)staffIds + "," + s.getId();
        }
        List works = this.staffWorkRoleService.getStaffWorkRoleByStaffIdsAndStartDateAndEndDateAndCid((String)staffIds, paramModel.getStartDate(), paramModel.getEndDate(), paramModel.getCid());
        ArrayList<HDetectionModel> list = new ArrayList<HDetectionModel>();
        for (StaffWorkRole s : works) {
            WorkRoleInfo w;
            HDetectionModel h = new HDetectionModel();
            h.setStartDate(s.getBeginTime());
            h.setEndDate(s.getLeaveTime());
            h.setStaffId(s.getStaffId());
            h.setWorkRoleId(s.getWorkRoleId());
            if (s.getWorkRoleId() != null && (w = (WorkRoleInfo)this.workRoleInfoService.getById(s.getWorkRoleId())) != null) {
                h.setWorkRoleName(w.getWorkName());
            }
            list.add(h);
        }
        return list;
    }

    public PageInfo<HDetectionModel> getDetectionPage(PageParamModel paramModel) {
        List basicInfoList = this.staffBasicInfoService.getStaffBasicInfosByCardIdAndCid(paramModel.getIdCard(), paramModel.getCid());
        ArrayList<Long> basicIds = new ArrayList<Long>();
        for (StaffBasicInfo s : basicInfoList) {
            basicIds.add(s.getId());
        }
        List infoList = this.staffInfoService.getStaffInfosByStaffBasicIds(basicIds, paramModel.getCid());
        Object staffIds = "-9";
        for (StaffInfo s : infoList) {
            staffIds = (String)staffIds + "," + s.getId();
        }
        PageHelper.startPage((int)paramModel.getPageInfo().getPageNum(), (int)paramModel.getPageInfo().getPageSize());
        List works = this.staffWorkRoleService.getStaffWorkRoleByStaffIdsAndStartDateAndEndDateAndCid((String)staffIds, paramModel.getStartDate(), paramModel.getEndDate(), paramModel.getCid());
        ArrayList<HDetectionModel> list = new ArrayList<HDetectionModel>();
        for (StaffWorkRole s : works) {
            HDetectionModel h = new HDetectionModel();
            h.setStartDate(s.getBeginTime());
            h.setEndDate(s.getLeaveTime());
            h.setStaffId(s.getStaffId());
            h.setWorkRoleId(s.getWorkRoleId());
            if (s.getWorkRoleId() != null) {
                WorkRoleInfo w = (WorkRoleInfo)this.workRoleInfoService.getById(s.getWorkRoleId());
                if (w != null) {
                    h.setWorkRoleName(w.getWorkName());
                }
                if (s.getWorkProperty() != null && s.getWorkProperty() == StaffWorkPropertyEnum.PLURALITY.getValue()) {
                    h.setIsPartTime(Boolean.valueOf(true));
                } else {
                    h.setIsPartTime(Boolean.valueOf(false));
                }
            }
            list.add(h);
        }
        return new PageInfo(list);
    }

    public List<HDetectionOccModel> getDetectionOccList(Long workRoleId, String occName, boolean isExceeded, Date workRoleStartDate, Date workRoleendDate, Boolean isPartTime) {
        List hcs;
        List sourceList = this.hcCheckPlanService.getHarmfactorWorkByWorkIdAndHarmName(workRoleId, occName);
        ArrayList<Long> hcIdList = new ArrayList<Long>();
        hcIdList.add(-9L);
        HashMap<Long, CallSite> hcSourceMap = new HashMap<Long, CallSite>();
        HashMap<Long, CallSite> hcHarmIdMap = new HashMap<Long, CallSite>();
        if (sourceList != null && sourceList.size() > 0) {
            for (HarmfactorWorkSource h : sourceList) {
                if (hcHarmIdMap.get(h.getCheckPlanId()) == null) {
                    hcHarmIdMap.put(h.getCheckPlanId(), (CallSite)((Object)("-9," + h.getHarmId())));
                } else {
                    hcHarmIdMap.put(h.getCheckPlanId(), (CallSite)((Object)((String)hcHarmIdMap.get(h.getCheckPlanId()) + "," + h.getHarmId())));
                }
                if (hcSourceMap.get(h.getCheckPlanId()) == null) {
                    hcSourceMap.put(h.getCheckPlanId(), (CallSite)((Object)("'\u9ed8\u8ba4','" + h.getHazardSource() + "'")));
                    continue;
                }
                hcSourceMap.put(h.getCheckPlanId(), (CallSite)((Object)((String)hcSourceMap.get(h.getCheckPlanId()) + ",'" + h.getHazardSource() + "'")));
            }
        }
        if (workRoleendDate == null) {
            workRoleendDate = new Date();
        }
        if ((hcs = this.hcCheckPlanService.getListByIdsAndDesc(hcIdList, workRoleStartDate, workRoleendDate)) != null && hcs.size() > 0) {
            ArrayList<HDetectionOccModel> finalList = new ArrayList<HDetectionOccModel>();
            HashMap map = new HashMap();
            for (HcCheckPlan hc : hcs) {
                List list = this.hcCheckResultCollectDataService.getHDetectionOccModelByharmSourceAndHcIdAndIsExceeded("" + hc.getId(), (String)hcHarmIdMap.get(hc.getId()), (String)hcSourceMap.get(hc.getId()), Boolean.valueOf(isExceeded));
                for (HDetectionOccModel ho : list) {
                    if (!StringUtils.isNotEmpty((String)ho.getAreaName())) continue;
                    if (map.get(ho.getAreaName()) == null) {
                        map.put(ho.getAreaName(), new HashSet());
                    }
                    ((HashSet)map.get(ho.getAreaName())).add(hc.getId());
                }
            }
            Set keys = map.keySet();
            for (String areaName : keys) {
                HDetectionOccModel ho = new HDetectionOccModel();
                ho.setAreaName(areaName);
                ho.setOcc(new ArrayList());
                Set hcIdsList = (Set)map.get(ho.getAreaName());
                for (Long hcId : hcIdsList) {
                    List occ = this.hcCheckResultCollectDataService.getHOccModelByharmSourceAndHcIdAndIsExceeded("" + hcId, (String)hcHarmIdMap.get(hcId), ho.getAreaName().trim(), isExceeded);
                    ho.getOcc().addAll(occ);
                }
                finalList.add(ho);
            }
            return finalList;
        }
        return null;
    }

    public PageInfo<HProEquipmentDetailModel> getProEquipmentDetail(Long workRoleId, PageInfo pageInfo) {
        if (pageInfo != null) {
            PageHelper.startPage((int)pageInfo.getPageNum(), (int)pageInfo.getPageSize());
        }
        List list = this.shieldEquipRuleDetailService.getByWorkId(workRoleId);
        PageInfo page = new PageInfo(list);
        return page;
    }

    public List<CompanyModel> getCompanyListByIdCard(String idCard) {
        List list = this.staffBasicInfoService.getStaffBasicInfosByCardId(idCard);
        ArrayList<CompanyModel> resultList = new ArrayList<CompanyModel>();
        if (list != null && list.size() > 0) {
            for (StaffBasicInfo info : list) {
                CompanyBaseInfoModel c;
                if (info.getCid() == null || (c = this.companyService.getCompanyById(info.getCid())) == null) continue;
                CompanyModel cm = new CompanyModel();
                cm.setFullName(c.getName());
                cm.setShortName(c.getShortName());
                resultList.add(cm);
            }
        }
        return resultList;
    }

    @Transactional(readOnly=false)
    public HContractInfoOccModel getContractInfoOcc(Long contractInfoId) {
        HContractInfoOccModel hcio = new HContractInfoOccModel();
        ContractInform contractInform = this.contractInformService.getContractInformById(contractInfoId);
        if (contractInform != null) {
            ContractInformTemplate template;
            if (contractInform.getInformWorkId() != null) {
                List harmFactorList = this.harmfactorWorkService.getHarmfactorListByWork(contractInform.getCid(), contractInform.getInformWorkId());
                Object harmNames = "";
                if (harmFactorList != null && harmFactorList.size() > 0) {
                    for (HarmfactorWorkSourceInfoVo v : harmFactorList) {
                        harmNames = (String)harmNames + v.getHarmName() + "~&~";
                    }
                }
                if (StringUtils.isNotEmpty((String)harmNames)) {
                    ((String)harmNames).substring(0, ((String)harmNames).lastIndexOf("~&~"));
                }
                hcio.setNameCh((String)harmNames);
            }
            if ((template = (ContractInformTemplate)this.contractInformTemplateService.getById(contractInform.getInformTempId())) != null && template.getInformWorkId() != null) {
                Object contraindication = "";
                Object disease = "";
                List list = this.contractInformService.getOccupationalDiseaseContraindicationListFromBaseData(template.getId(), template.getInformWorkId(), template.getCid(), template.getUpdateBy());
                if (list != null && list.size() > 0) {
                    for (OccupationalDiseaseContraindication o : list) {
                        contraindication = (String)contraindication + o.getContraindication() + "~&~";
                        disease = (String)disease + o.getDisease() + "~&~";
                    }
                }
                if (StringUtils.isNotEmpty((String)contraindication)) {
                    ((String)contraindication).substring(0, ((String)contraindication).lastIndexOf("~&~"));
                }
                if (StringUtils.isNotEmpty((String)disease)) {
                    ((String)disease).substring(0, ((String)disease).lastIndexOf("~&~"));
                }
                hcio.setContraindication((String)contraindication);
                hcio.setDisease((String)disease);
            }
        }
        return hcio;
    }

    public HContractInfoModel getContractInfoById(Long contractId) {
        ContractInform c = (ContractInform)this.contractInformService.getById(contractId);
        HContractInfoModel h = null;
        if (c != null) {
            WorkRoleInfo w;
            h = new HContractInfoModel();
            h.setContractInfoDate(c.getInformDate());
            h.setStaffId(c.getStaffId());
            h.setWorkId(c.getInformWorkId());
            if (c.getInformWorkId() != null && (w = (WorkRoleInfo)this.workRoleInfoService.getById(c.getInformWorkId())) != null) {
                h.setWorkRoleName(w.getWorkName());
            }
        }
        return h;
    }

    public List<HistoryCompanyModel> getHistoryCompanyListByUser(String idCard) {
        List allCompany = this.staffInfoService.getStaffInfoByCardId(idCard, Long.valueOf(0L));
        ArrayList<HistoryCompanyModel> list = new ArrayList<HistoryCompanyModel>();
        for (StaffInfo s : allCompany) {
            StaffWorkRole currentStaffWorkRole;
            if (s == null) continue;
            HistoryCompanyModel h = new HistoryCompanyModel();
            CompanyBaseInfoModel c = this.companyService.getCompanyById(s.getCid());
            if (c == null || c.getId() == null) continue;
            h.setCid(c.getId());
            h.setCompanyName(c.getName());
            h.setStaffId(s.getId());
            h.setIdCard(idCard);
            Integer isZhuji = this.getIszhuji(c.getAreaDetailId());
            h.setZhuji(isZhuji);
            StaffBasicWork staffBasicWork = this.staffBasicWorkService.getStaffBasicWorkIncludeNoIsValidByStaffId(s.getId());
            if (staffBasicWork != null) {
                h.setStartDate(staffBasicWork.getJoinTime());
            }
            if ((currentStaffWorkRole = this.staffWorkRoleService.getCurrentStaffWorkRoleHistoryCompanyIncludeNoIsValidByStaffId(s.getId())) != null && currentStaffWorkRole.getLeaveTime() != null) {
                h.setEndDate(currentStaffWorkRole.getLeaveTime());
            }
            list.add(h);
        }
        return list;
    }

    private Integer getIszhuji(Long areaId) {
        if (areaId == null) {
            return 0;
        }
        if (areaId.toString().startsWith("330681")) {
            return 1;
        }
        return 0;
    }

    @Transactional(readOnly=false)
    public List<HContractInfoOccModel> getContractInfoOccByContractInfoId(Long contractInfoId) {
        List list;
        ContractInformTemplate template;
        ContractInform contractInform = this.contractInformService.getContractInformById(contractInfoId);
        ArrayList<HContractInfoOccModel> finalList = new ArrayList<HContractInfoOccModel>();
        if (contractInform != null && (template = (ContractInformTemplate)this.contractInformTemplateService.getById(contractInform.getInformTempId())) != null && template.getInformWorkId() != null && (list = this.contractInformService.getOccupationalDiseaseContraindicationListFromBaseData(template.getId(), template.getInformWorkId(), template.getCid(), template.getUpdateBy())) != null && list.size() > 0) {
            for (OccupationalDiseaseContraindication o : list) {
                HContractInfoOccModel hcio = new HContractInfoOccModel();
                hcio.setContraindication(o.getContraindication());
                hcio.setDisease(o.getDisease());
                hcio.setNameCh(o.getHarmName());
                finalList.add(hcio);
            }
        }
        return finalList;
    }

    public PageInfo<HistoryWorkRoleModel> getHistoryWorkRolePage(PageParamModel paramModel) {
        List basicInfoList = this.staffBasicInfoService.getStaffBasicInfosByCardIdAndCid(paramModel.getIdCard(), paramModel.getCid());
        ArrayList<Long> basicIds = new ArrayList<Long>();
        for (StaffBasicInfo s : basicInfoList) {
            basicIds.add(s.getId());
        }
        List infoList = this.staffInfoService.getStaffInfosByStaffBasicIds(basicIds, paramModel.getCid());
        Object staffIds = "-9";
        for (StaffInfo s : infoList) {
            staffIds = (String)staffIds + "," + s.getId();
        }
        PageHelper.startPage((int)paramModel.getPageInfo().getPageNum(), (int)paramModel.getPageInfo().getPageSize());
        List works = this.staffWorkRoleService.getStaffWorkRoleByStaffIdsAndStartDateAndEndDateAndCid((String)staffIds, paramModel.getStartDate(), paramModel.getEndDate(), paramModel.getCid());
        ArrayList<HistoryWorkRoleModel> list = new ArrayList<HistoryWorkRoleModel>();
        for (StaffWorkRole s : works) {
            WorkRoleInfo w;
            HistoryWorkRoleModel h = new HistoryWorkRoleModel();
            h.setEndDate(s.getLeaveTime());
            h.setStaffId(s.getStaffId());
            h.setStartDate(s.getBeginTime());
            h.setWorkRoleId(s.getWorkRoleId());
            if (s.getWorkRoleId() != null && (w = (WorkRoleInfo)this.workRoleInfoService.getById(s.getWorkRoleId())) != null) {
                h.setWorkRoleName(w.getWorkName());
            }
            list.add(h);
        }
        return new PageInfo(list);
    }

    public PageInfo<HContractInfoModel> getContractInfoAppPage(PageParamModel paramModel) {
        if (paramModel.getCid() != null && paramModel.getCid() == 0L) {
            paramModel.setCid(null);
        }
        List basicInfoList = this.staffBasicInfoService.getStaffBasicInfosByCardIdAndCid(paramModel.getIdCard(), paramModel.getCid());
        ArrayList<Long> basicIds = new ArrayList<Long>();
        for (StaffBasicInfo s : basicInfoList) {
            basicIds.add(s.getId());
        }
        List infoList = this.staffInfoService.getStaffInfosByStaffBasicIds(basicIds, paramModel.getCid());
        Object staffIds = "-9";
        for (StaffInfo s : infoList) {
            staffIds = (String)staffIds + "," + s.getId();
        }
        List works = this.staffWorkRoleService.getStaffWorkRoleByStaffIdsAndStartDateAndEndDateAndCid((String)staffIds, paramModel.getStartDate(), paramModel.getEndDate(), paramModel.getCid());
        staffIds = "-9";
        Object workIds = "-9";
        HashMap<CallSite, StaffWorkRole> map = new HashMap<CallSite, StaffWorkRole>();
        for (StaffWorkRole s : works) {
            staffIds = (String)staffIds + "," + s.getStaffId();
            workIds = (String)workIds + "," + s.getWorkRoleId();
            map.put((CallSite)((Object)(s.getStaffId() + ":" + s.getWorkRoleId())), s);
        }
        PageHelper.startPage((int)paramModel.getPageInfo().getPageNum(), (int)paramModel.getPageInfo().getPageSize());
        List list = this.contractInformService.getContractInformByStaffIdsAndWorkIdsAndCid((String)staffIds, (String)workIds, paramModel.getCid());
        for (HContractInfoModel c : list) {
            WorkRoleInfo w;
            StaffWorkRole s = (StaffWorkRole)map.get(c.getStaffId() + ":" + c.getWorkId());
            if (s == null) continue;
            c.setStartDate(s.getBeginTime());
            c.setEndDate(s.getLeaveTime());
            if (c.getWorkId() == null || (w = (WorkRoleInfo)this.workRoleInfoService.getById(c.getWorkId())) == null) continue;
            c.setWorkRoleName(w.getWorkName());
        }
        return new PageInfo(list);
    }
}

