/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.zyb;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.health.bx.model.BxZybVo;
import cn.smarthse.modules.health.bx.model.ZybCountUpdateVo;
import cn.smarthse.modules.health.bx.service.IBxZybService;
import cn.smarthse.modules.health.entity.base.staff.StaffInfoSearchParam;
import cn.smarthse.modules.health.param.FcythSearchParam;
import cn.smarthse.modules.health.service.base.zyb.IZybCountUpdateLogService;
import cn.smarthse.snowflake.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class ZybCountUpdateLogServiceImpl
implements IZybCountUpdateLogService {
    @DubboReference
    private IBxZybService bxZybService;
    @Autowired
    private ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    @Autowired
    protected IdWorker idworker;

    @Transactional(readOnly=false)
    public void flushZybCountUpdateLog(List<String> unifiedSocialCcList, Long updateBy, Boolean isSystem) {
        ArrayList<ZybCountUpdateVo> addOrUpdList = new ArrayList<ZybCountUpdateVo>();
        ArrayList<Long> addOrUpdCidList = new ArrayList<Long>();
        List<String> allZybPatientUnifiedSocialCcs = new ArrayList<String>();
        if (CollectionUtils.isEmpty(unifiedSocialCcList)) {
            allZybPatientUnifiedSocialCcs.addAll(this.bxZybService.getAllZybPatientUnifiedSocialCc(null));
        } else {
            allZybPatientUnifiedSocialCcs.addAll(unifiedSocialCcList);
            isSystem = false;
        }
        allZybPatientUnifiedSocialCcs = allZybPatientUnifiedSocialCcs.stream().filter(s -> StringUtils.isNotEmpty((String)s)).collect(Collectors.toList());
        List partitionZybPatientUnifiedSocialCcs = ListUtil.partition(allZybPatientUnifiedSocialCcs, (int)1000);
        for (List partitionZybPatientUnifiedSocialCc : partitionZybPatientUnifiedSocialCcs) {
            List zybVos = new ArrayList();
            FcythSearchParam fcythSearchParam = new FcythSearchParam();
            fcythSearchParam.setUnifiedSocialCcList(partitionZybPatientUnifiedSocialCc);
            PageInfo zybPatientList = this.bxZybService.getZybPatientList(fcythSearchParam, Integer.valueOf(3));
            zybVos = zybPatientList.getList();
            Date date = new Date();
            List<String> idCardList = zybVos.stream().filter(b -> StringUtils.isNotEmpty((String)b.getIdcard())).map(BxZybVo::getIdcard).distinct().collect(Collectors.toList());
            List companyAndCompanySuperviseByUnitCode = this.companyProvideBySuperviseService.getCompanyAndCompanySuperviseByUnitCode(partitionZybPatientUnifiedSocialCc);
            Map<String, Long> companyMap = companyAndCompanySuperviseByUnitCode.stream().collect(Collectors.toMap(CompanyBaseInfoModel::getUnifiedSocialCc, CompanyBaseInfoModel::getId, (c1, c2) -> c1));
            if (!MapUtil.isNotEmpty(companyMap)) continue;
            ArrayList<String> updUnifiedSocialCcs = new ArrayList<String>(companyMap.keySet());
            ArrayList<Long> cids = new ArrayList<Long>(companyMap.values());
            FcythSearchParam param = new FcythSearchParam();
            param.setCidList(cids);
            List zybCountUpdateLogList = this.bxZybService.getZybCountUpdateLog(param);
            Map<Long, ZybCountUpdateVo> zybCountUpdateVoMap = zybCountUpdateLogList.stream().collect(Collectors.toMap(ZybCountUpdateVo::getCid, z -> z, (z1, z2) -> z1));
            List<ZybCountUpdateVo> nowZybStaffCountList = this.getZybStaffCount(cids, idCardList);
            Map<Long, ZybCountUpdateVo> nowZybStaffCountMap = nowZybStaffCountList.stream().collect(Collectors.toMap(ZybCountUpdateVo::getCid, z -> z, (z1, z2) -> z1));
            for (String key : updUnifiedSocialCcs) {
                ZybCountUpdateVo zybCountUpdateVo;
                Long cid = companyMap.get(key);
                Boolean isAdd = false;
                if (!ObjectUtil.isNotNull((Object)cid)) continue;
                addOrUpdCidList.add(cid);
                ZybCountUpdateVo nowZybCountUpdateVo = nowZybStaffCountMap.get(cid);
                if (ObjectUtil.isNull((Object)nowZybCountUpdateVo)) {
                    nowZybCountUpdateVo = new ZybCountUpdateVo();
                }
                if (nowZybCountUpdateVo.getCurrentZybNumber() == null) {
                    nowZybCountUpdateVo.setCurrentZybNumber(Integer.valueOf(0));
                }
                if (ObjectUtil.isNull((Object)(zybCountUpdateVo = zybCountUpdateVoMap.get(cid)))) {
                    zybCountUpdateVo = new ZybCountUpdateVo();
                    isAdd = true;
                }
                zybCountUpdateVo.setUpdateBy(updateBy);
                zybCountUpdateVo.setUpdateDate(date);
                if (ObjectUtil.isNull((Object)zybCountUpdateVo.getCurrentZybNumber()) || zybCountUpdateVo.getCurrentZybNumber() != nowZybCountUpdateVo.getCurrentZybNumber()) {
                    zybCountUpdateVo.setCreateBy(updateBy);
                    zybCountUpdateVo.setCreateDate(date);
                    zybCountUpdateVo.setCurrentZybNumber(nowZybCountUpdateVo.getCurrentZybNumber());
                    zybCountUpdateVo.setCurrentZybNumberUpdate(date);
                }
                if (isSystem.booleanValue() && isAdd.booleanValue()) {
                    zybCountUpdateVo.setCurrentZybNumberUpdate(null);
                }
                if (isAdd.booleanValue()) {
                    zybCountUpdateVo.setCid(cid);
                    zybCountUpdateVo.setId(Long.valueOf(this.idworker.nextId()));
                }
                addOrUpdList.add(zybCountUpdateVo);
            }
        }
        if (CollectionUtils.isNotEmpty(addOrUpdList)) {
            List partition = ListUtil.partition(addOrUpdList, (int)1000);
            for (List zybCountUpdateVos : partition) {
                this.bxZybService.addOrUpdZybCountUpdate(zybCountUpdateVos);
            }
        }
        if (isSystem.booleanValue()) {
            this.bxZybService.setResetAndNumberUpdate(addOrUpdCidList);
        }
    }

    public List<ZybCountUpdateVo> getZybStaffCount(List<Long> cidList, List<String> idCardList) {
        StaffInfoSearchParam param = new StaffInfoSearchParam();
        if (CollectionUtils.isEmpty(idCardList) || CollectionUtils.isEmpty(cidList)) {
            return new ArrayList<ZybCountUpdateVo>();
        }
        param.setCidList(cidList);
        param.setIdCardList(idCardList);
        return this.bxZybService.getZybStaffCount(param);
    }
}

