/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.workinfo;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.jqgrid.ParamSeachFieldVO;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.excel.ExcelUtil;
import cn.smarthse.modules.datacentre.model.system.riskFactors.HarmFactor;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IHarmFactorService;
import cn.smarthse.modules.health.dao.base.workinfo.WorkAreaInfoMapper;
import cn.smarthse.modules.health.dao.base.workinfo.WorkRoleInfoMapper;
import cn.smarthse.modules.health.entity.base.company.CompanyArea;
import cn.smarthse.modules.health.entity.base.company.CompanyOrganization;
import cn.smarthse.modules.health.entity.base.company.grade.vo.CompanyHarmNumVo;
import cn.smarthse.modules.health.entity.base.workinfo.WorkAreaInfo;
import cn.smarthse.modules.health.entity.base.workinfo.WorkInfoImportVo;
import cn.smarthse.modules.health.entity.base.workinfo.WorkRoleInfo;
import cn.smarthse.modules.health.entity.base.workinfo.WorkSearchVo;
import cn.smarthse.modules.health.entity.work.shield.ProtectList;
import cn.smarthse.modules.health.enums.staff.StaffInfoImportStateEnum;
import cn.smarthse.modules.health.model.HProEquipmentDetailModel;
import cn.smarthse.modules.health.service.base.company.ICompanyAreaService;
import cn.smarthse.modules.health.service.base.company.ICompanyOrganizationService;
import cn.smarthse.modules.health.service.base.staff.IStaffWorkRoleService;
import cn.smarthse.modules.health.service.base.workinfo.IWorkRoleInfoService;
import cn.smarthse.modules.health.service.sys.ISysCoreWorkModuleCorrelationService;
import cn.smarthse.modules.health.service.work.shield.IProtectListService;
import cn.smarthse.modules.health.service.work.shield.IShieldEquipRuleDetailService;
import cn.smarthse.services.hfi.api.entity.riskev.RiskExposeEvaluateData;
import cn.smarthse.services.hfi.api.service.riskev.IRiskExposeEvaluateService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class WorkRoleInfoServiceImpl
extends BaseServiceImpl<WorkRoleInfoMapper, WorkRoleInfo>
implements IWorkRoleInfoService {
    @Autowired
    private ISysCoreWorkModuleCorrelationService sysCoreWorkModuleCorrelationService;
    @Autowired
    private WorkRoleInfoMapper workRoleInfoMapper;
    @Autowired
    private IStaffWorkRoleService staffWorkRoleService;
    @Autowired
    private ICompanyOrganizationService companyOrganizationService;
    @Autowired
    private WorkAreaInfoMapper workAreaInfoMapper;
    @Autowired
    private ICompanyAreaService companyAreaService;
    @Autowired
    private IShieldEquipRuleDetailService iShieldEquipRuleDetailService;
    @DubboReference(version="1.0.0")
    private IHarmFactorService harmFactorService;
    @DubboReference
    private IRiskExposeEvaluateService riskExposeEvaluateService;
    @Autowired
    IProtectListService protectListService;

    public PageInfo<WorkRoleInfo> getWorkRoleInfoListByGridParm(JqGridParam param) {
        if (param == null) {
            return new PageInfo();
        }
        if (param.getCid() == null || param.getCid() == 0L) {
            return new PageInfo();
        }
        Example example = new Example(WorkRoleInfo.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("cid", (Object)param.getCid()).andEqualTo("isValid", (Object)true);
        if (param.getPostDatas() != null) {
            for (ParamSeachFieldVO sField : param.getPostDatas()) {
                if (sField.getSearchOper().equals(JqGridParam.operType.eq.name()) && StringUtils.isNotEmpty((String)sField.getSearchValue())) {
                    c.andEqualTo(sField.getSearchField(), (Object)sField.getSearchValue());
                    continue;
                }
                if (!sField.getSearchOper().equals(JqGridParam.operType.like.name())) continue;
                c.andLike(sField.getSearchField(), "%" + sField.getSearchValue() + "%");
            }
        }
        if (StringUtils.isNotEmpty((String)param.getSidx())) {
            example.setOrderByClause(param.getSidx() + " " + param.getSord());
        } else {
            example.setOrderByClause("update_date desc");
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List list = this.getListByExample(example);
        for (WorkRoleInfo work : list) {
            List equips;
            if (work.getOrgId() != null) {
                work.setOrgName(this.companyOrganizationService.getOrgNameById(work.getOrgId()));
                work.setWorkAreaInfoNames(this.getWorkAreaNameByWorkId(work.getId()));
            }
            int staffNum = this.staffWorkRoleService.getWorkerNumByWorkId(work.getId(), work.getCid());
            work.setStaffNum(Integer.valueOf(staffNum));
            int selfNum = this.staffWorkRoleService.getSelfComOrThirdWorkerNumByWorkId(work.getId(), work.getCid(), Boolean.valueOf(false));
            work.setSelfstaffNum(Integer.valueOf(selfNum));
            int thirdNum = this.staffWorkRoleService.getSelfComOrThirdWorkerNumByWorkId(work.getId(), work.getCid(), Boolean.valueOf(true));
            work.setThirdstaffNum(Integer.valueOf(thirdNum));
            if (StringUtils.isNotEmpty((String)work.getHarmFanctorIds())) {
                String harmNames = this.harmFactorService.getHarmNames(work.getHarmFanctorIds());
                work.setRiskFactorNames(harmNames);
            }
            if ((equips = this.iShieldEquipRuleDetailService.getByWorkId(work.getId())) == null || equips.size() <= 0) continue;
            StringBuilder protectiveEquipments = null;
            for (HProEquipmentDetailModel e : equips) {
                if (protectiveEquipments == null) {
                    protectiveEquipments = new StringBuilder(e.getProtectiveName());
                    continue;
                }
                protectiveEquipments.append("\uff0c").append(e.getProtectiveName());
            }
            work.setProtectiveEquipments(protectiveEquipments.toString());
        }
        return new PageInfo(list);
    }

    public PageInfo<WorkRoleInfo> getWorkRoleInfoListByParmPage(JqGridParam gparam, WorkSearchVo param) {
        if (gparam == null) {
            return new PageInfo();
        }
        if (param.getCid() == null) {
            param.setCid(gparam.getCid());
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        List<WorkRoleInfo> list = this.getWorkRoleInfoListByParm(param);
        return new PageInfo(list);
    }

    public List<WorkRoleInfo> getWorkRoleInfoListByParm(WorkSearchVo param) {
        List<WorkRoleInfo> list = ((WorkRoleInfoMapper)this.dao).selectByParam(param);
        for (WorkRoleInfo work : list) {
            if (work.getOrgId() != null) {
                work.setOrgName(this.companyOrganizationService.getOrgNameById(work.getOrgId()));
                work.setWorkAreaInfoNames(this.getWorkAreaNameByWorkId(work.getId()));
            }
            int staffNum = this.staffWorkRoleService.getWorkerNumByWorkId(work.getId(), work.getCid());
            work.setStaffNum(Integer.valueOf(staffNum));
            int selfNum = this.staffWorkRoleService.getSelfComOrThirdWorkerNumByWorkId(work.getId(), work.getCid(), Boolean.valueOf(false));
            work.setSelfstaffNum(Integer.valueOf(selfNum));
            int thirdNum = this.staffWorkRoleService.getSelfComOrThirdWorkerNumByWorkId(work.getId(), work.getCid(), Boolean.valueOf(true));
            work.setThirdstaffNum(Integer.valueOf(thirdNum));
            if (StringUtils.isNotEmpty((String)work.getHarmFanctorIds())) {
                List harmFactorList = this.harmFactorService.getHarmByIds(work.getHarmFanctorIds());
                String factorNames = harmFactorList.stream().map(HarmFactor::getNameCh).filter(StringUtils::isNotEmpty).collect(Collectors.joining(","));
                work.setHarmFactorList(harmFactorList);
                work.setRiskFactorNames(factorNames);
            }
            if (!StringUtils.isNotEmpty((String)work.getProtectIds())) continue;
            List protectLists = this.protectListService.getListByIds(work.getProtectIds());
            String protectNames = protectLists.stream().map(ProtectList::getProName).filter(StringUtils::isNotEmpty).collect(Collectors.joining(","));
            work.setProtectiveEquipments(protectNames);
            work.setProtectList(protectLists);
        }
        return list;
    }

    public List<WorkRoleInfo> getWorkRoleInfoListForArchive(Long cid) {
        if (cid == null) {
            return null;
        }
        WorkSearchVo param = new WorkSearchVo();
        param.setCid(cid);
        List<WorkRoleInfo> list = ((WorkRoleInfoMapper)this.dao).selectByParam(param);
        if (CollUtil.isNotEmpty(list) && list.size() > 0) {
            for (WorkRoleInfo work : list) {
                if (work.getOrgId() != null) {
                    work.setOrgName(this.companyOrganizationService.getOrgNameById(work.getOrgId()));
                }
                if (StringUtils.isNotEmpty((String)work.getHarmFanctorIds())) {
                    String harmNames = this.harmFactorService.getHarmNames(work.getHarmFanctorIds());
                    work.setRiskFactorNames(harmNames);
                }
                int staffNum = this.staffWorkRoleService.getWorkerNumByWorkId(work.getId(), work.getCid());
                work.setStaffNum(Integer.valueOf(staffNum));
                int femaleNum = this.staffWorkRoleService.getFemaleWorkerNumByWorkId(work.getId(), work.getCid());
                work.setFemaleStaffNum(Integer.valueOf(femaleNum));
            }
        }
        return list;
    }

    public List<WorkRoleInfo> selectByParam(Long cid) {
        if (cid == null) {
            return null;
        }
        WorkSearchVo param = new WorkSearchVo();
        param.setCid(cid);
        return ((WorkRoleInfoMapper)this.dao).selectByParam(param);
    }

    public List<WorkRoleInfo> getWorkRoleInfoList(Long cid) {
        Example example = new Example(WorkRoleInfo.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true);
        example.setOrderByClause("update_date desc");
        List<WorkRoleInfo> list = this.getListByExample(example);
        for (WorkRoleInfo work : list) {
            if (work.getOrgId() != null) {
                work.setOrgName(this.companyOrganizationService.getOrgNameById(work.getOrgId()));
                work.setWorkAreaInfoNames(this.getWorkAreaNameByWorkId(work.getId()));
            }
            if (!StringUtils.isNotEmpty((String)work.getHarmFanctorIds())) continue;
            String harmNames = this.harmFactorService.getHarmNames(work.getHarmFanctorIds());
            work.setRiskFactorNames(harmNames);
        }
        return list;
    }

    public List<WorkRoleInfo> getWorkRoleList(JqGridParam param) {
        if (param == null) {
            return null;
        }
        if (param.getCid() == null || param.getCid() == 0L) {
            return null;
        }
        Example example = new Example(WorkRoleInfo.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("cid", (Object)param.getCid()).andEqualTo("isValid", (Object)true);
        if (CollectionUtils.isNotEmpty((Collection)param.getPostDatas())) {
            for (ParamSeachFieldVO sField : param.getPostDatas()) {
                if (sField.getSearchOper().equals(JqGridParam.operType.eq.name()) && StringUtils.isNotEmpty((String)sField.getSearchValue())) {
                    c.andEqualTo(sField.getSearchField(), (Object)sField.getSearchValue());
                    continue;
                }
                if (!sField.getSearchOper().equals(JqGridParam.operType.like.name())) continue;
                c.andLike(sField.getSearchField(), "%" + sField.getSearchValue() + "%");
            }
        }
        if (StringUtils.isNotEmpty((String)param.getSidx())) {
            example.setOrderByClause(param.getSidx() + " " + param.getSord());
        } else {
            example.setOrderByClause("update_date desc");
        }
        List<WorkRoleInfo> list = this.getListByExample(example);
        int serial = 1;
        if (CollectionUtils.isNotEmpty(list)) {
            for (WorkRoleInfo work : list) {
                List equips;
                work.setSerial(serial);
                ++serial;
                if (work.getOrgId() != null) {
                    work.setOrgName(this.companyOrganizationService.getOrgNameById(work.getOrgId()));
                    work.setWorkAreaInfoNames(this.getWorkAreaNameByWorkId(work.getId()));
                }
                int staffNum = this.staffWorkRoleService.getWorkerNumByWorkId(work.getId(), work.getCid());
                work.setStaffNum(Integer.valueOf(staffNum));
                int selfNum = this.staffWorkRoleService.getSelfComOrThirdWorkerNumByWorkId(work.getId(), work.getCid(), Boolean.valueOf(false));
                work.setSelfstaffNum(Integer.valueOf(selfNum));
                int thirdNum = this.staffWorkRoleService.getSelfComOrThirdWorkerNumByWorkId(work.getId(), work.getCid(), Boolean.valueOf(true));
                work.setThirdstaffNum(Integer.valueOf(thirdNum));
                if (work.getHarmFanctorIds() != null) {
                    List factors = this.harmFactorService.getHarmByIds(work.getHarmFanctorIds());
                    StringBuilder harmNames = null;
                    for (HarmFactor harm : factors) {
                        if (!StringUtils.isNotEmpty((String)harm.getNameCh())) continue;
                        if (harmNames == null) {
                            harmNames = new StringBuilder(harm.getNameCh());
                            continue;
                        }
                        harmNames.append("\uff1b").append(harm.getNameCh());
                    }
                    if (harmNames != null) {
                        work.setRiskFactorNames(harmNames.toString());
                    }
                }
                if ((equips = this.iShieldEquipRuleDetailService.getByWorkId(work.getId())) == null || equips.size() <= 0) continue;
                StringBuilder protectiveEquipments = null;
                for (HProEquipmentDetailModel e : equips) {
                    if (!StringUtils.isNotEmpty((String)e.getProtectiveName())) continue;
                    if (protectiveEquipments == null) {
                        protectiveEquipments = new StringBuilder(e.getProtectiveName());
                        continue;
                    }
                    protectiveEquipments.append("\uff0c").append(e.getProtectiveName());
                }
                if (protectiveEquipments == null) continue;
                work.setProtectiveEquipments(protectiveEquipments.toString());
            }
            return list;
        }
        return new ArrayList<WorkRoleInfo>();
    }

    public List<WorkAreaInfo> getWorkAreaInfosByWorkId(Long workId) {
        Example example = new Example(WorkAreaInfo.class);
        example.createCriteria().andCondition("is_valid=1 and work_info_id=" + workId);
        return this.workAreaInfoMapper.selectByExample(example);
    }

    public List<WorkRoleInfo> getWorkRoleInfosByCidAndOrgAndSearch(Long cid, Long orgId, String searchKey, Long reWork) {
        List<WorkRoleInfo> list = this.workRoleInfoMapper.getWorkRoleInfosByCidAndOrgAndSearch(cid, orgId, searchKey, reWork);
        return list;
    }

    public List<WorkRoleInfo> getHarmWorkRoleInfosByCidAndOrgAndSearch(Long cid, Long orgId, String searchKey, Long reWork, List<String> harmTypeList) {
        List<WorkRoleInfo> list = this.workRoleInfoMapper.getHarmWorkRoleInfosByCidAndOrgAndSearch(cid, orgId, searchKey, reWork, harmTypeList);
        return list;
    }

    @Transactional(readOnly=false)
    public int addWorkRoleList(List<WorkRoleInfo> workList) {
        if (CollectionUtils.isNotEmpty(workList)) {
            this.workRoleInfoMapper.insertBatch(workList);
        }
        return 0;
    }

    private String getWorkAreaNameByWorkId(Long workId) {
        List<WorkAreaInfo> list = this.getWorkAreaInfosByWorkId(workId);
        if (list != null && list.size() > 0) {
            ArrayList<String> finalList = new ArrayList<String>();
            for (WorkAreaInfo wai : list) {
                if (wai.getCompanyAreaId() == null) continue;
                finalList.add(this.companyAreaService.getAreaFullName(wai.getCompanyAreaId()));
            }
            return String.join((CharSequence)",", finalList);
        }
        return "";
    }

    @Transactional(readOnly=false)
    public Boolean addWorkRoleInfoSubmit(WorkRoleInfo wForm, Long loginStaffId, Long cid) throws Exception {
        wForm.setIsValid(Global.TRUE);
        wForm.setCid(cid);
        wForm.setId(null);
        if (((WorkRoleInfoMapper)this.dao).selectCount(wForm) == 0) {
            if (wForm.getHarmIds() != null && StringUtils.isNotBlank((CharSequence)wForm.getHarmIds())) {
                wForm.setHarmFanctorIds(wForm.getHarmIds());
            }
            this.add(wForm, loginStaffId, cid);
            if (wForm.getHarmFanctorIds() != null) {
                this.sysCoreWorkModuleCorrelationService.postHarmFactorChange(wForm.getId(), loginStaffId, cid);
            }
            if (wForm.getWorkAreaInfos() != null && wForm.getWorkAreaInfos().size() > 0) {
                for (WorkAreaInfo wri : wForm.getWorkAreaInfos()) {
                    if (wri == null || wri.getCompanyAreaId() == null) continue;
                    wri.setWorkInfoId(wForm.getId());
                    wri.setCid(cid);
                    wri.setIsValid(Boolean.valueOf(true));
                    wri.setCreateDate(new Date());
                    wri.setUpdateDate(new Date());
                    wri.setCreateBy(loginStaffId);
                    wri.setUpdateBy(loginStaffId);
                    this.workAreaInfoMapper.insert(wri);
                }
            }
            return false;
        }
        return true;
    }

    @Transactional(readOnly=false)
    public Boolean editWorkRoleInfoSubmit(WorkRoleInfo wForm, Long loginStaffId, Long cid) throws Exception {
        Example example = new Example(WorkRoleInfo.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("workName", (Object)wForm.getWorkName()).andNotEqualTo("id", (Object)wForm.getId()).andEqualTo("cid", (Object)wForm.getCid()).andEqualTo("isValid", (Object)"1").andEqualTo("orgId", (Object)wForm.getOrgId());
        if (this.getCountByExample(example) == 0) {
            WorkRoleInfo oldWork = this.getById(wForm.getId());
            this.update(wForm, wForm.getCid());
            if (this.isChangeHarmFactor(oldWork, wForm).booleanValue()) {
                this.sysCoreWorkModuleCorrelationService.postHarmFactorChange(wForm.getId(), loginStaffId, cid);
            }
            WorkAreaInfo record = new WorkAreaInfo();
            record.setIsValid(Boolean.valueOf(false));
            record.setUpdateBy(loginStaffId);
            record.setUpdateDate(new Date());
            Example example1 = new Example(WorkAreaInfo.class);
            example1.createCriteria().andCondition("is_valid=1 and cid=" + cid + " and work_info_id=" + wForm.getId());
            this.workAreaInfoMapper.updateByExampleSelective(record, example1);
            if (wForm.getWorkAreaInfos() != null && wForm.getWorkAreaInfos().size() > 0) {
                for (WorkAreaInfo wri : wForm.getWorkAreaInfos()) {
                    if (wri == null || wri.getCompanyAreaId() == null) continue;
                    wri.setWorkInfoId(wForm.getId());
                    wri.setCid(cid);
                    wri.setIsValid(Boolean.valueOf(true));
                    wri.setCreateDate(new Date());
                    wri.setUpdateDate(new Date());
                    wri.setCreateBy(loginStaffId);
                    wri.setUpdateBy(loginStaffId);
                    this.workAreaInfoMapper.insert(wri);
                }
            }
            return false;
        }
        return true;
    }

    private Boolean isChangeHarmFactor(WorkRoleInfo oldWork, WorkRoleInfo newWork) {
        if (oldWork != null && oldWork.getHarmFanctorIds() != null) {
            if (newWork.getHarmFanctorIds() == null) {
                return true;
            }
            return !oldWork.getHarmFanctorIds().equals(newWork.getHarmFanctorIds());
        }
        return newWork.getHarmFanctorIds() != null;
    }

    @Transactional(readOnly=false)
    public void deleteWorkRoleInfoSubmit(Long id, Long loginStaffId, Long cid) {
        WorkRoleInfo wForm = new WorkRoleInfo();
        wForm.setId(id);
        wForm.setIsValid(Global.FALSE);
        this.update(wForm, loginStaffId);
        this.sysCoreWorkModuleCorrelationService.soureBusinessDelete(id, loginStaffId);
    }

    public List<WorkRoleInfo> getWorkRoleInfosByCid(Long cid) {
        Example example = new Example(WorkRoleInfo.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true);
        return this.getListByExample(example);
    }

    public List<WorkRoleInfo> getWorkRoleOrgNameByCid(Long cid) {
        if (cid == null) {
            return Collections.emptyList();
        }
        return ((WorkRoleInfoMapper)this.dao).getWorkRoleOrgNameByCid(cid);
    }

    public WorkRoleInfo getWorkRoleInfoByName(String workName, Long cid) {
        Example example = new Example(WorkRoleInfo.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true).andEqualTo("workName", (Object)workName);
        List list = this.getListByExample(example);
        WorkRoleInfo work = null;
        if (list != null && list.size() > 0) {
            work = (WorkRoleInfo)list.get(0);
        }
        return work;
    }

    public void deleteWorkRoleByCid(Long cid, Long staffid) {
        WorkRoleInfo work = new WorkRoleInfo();
        work.setIsValid(Boolean.valueOf(false));
        super.setUpdateInfo(work, staffid);
        Example example = new Example(CompanyArea.class);
        example.createCriteria().andEqualTo("cid", (Object)cid);
        ((WorkRoleInfoMapper)this.dao).updateByExampleSelective(work, example);
    }

    public List<WorkRoleInfo> getWorkRoleInfosByCidAndSearch(Long cid, String searchKey, Long reWork) {
        List<WorkRoleInfo> list = this.workRoleInfoMapper.getWorkRoleInfosByCidAndSearch(cid, searchKey, reWork);
        return list;
    }

    public List<WorkRoleInfo> getWorkRoleOrganByCidAndSearch(Long cid, String searchKey) {
        List<WorkRoleInfo> list = this.workRoleInfoMapper.getWorkRoleOrganByCidAndSearch(cid, searchKey);
        return list;
    }

    @Override
    public WorkRoleInfo getById(Long id) {
        WorkRoleInfo work = this.workRoleInfoMapper.getWorkRoleInfoById(id, new Date().getTime());
        if (work != null) {
            work.setOrgName("");
            if (work.getOrgId() != null) {
                work.setOrgName(this.companyOrganizationService.getOrgNameById(work.getOrgId()));
            }
        }
        return work;
    }

    @Transactional(readOnly=false)
    public WorkRoleInfo getWorkRoleInfoByNameAndOrgName(String workName, String orgName, Long cid) {
        return this.workRoleInfoMapper.getWorkRoleInfoByWorkNameAndOrgName(cid, workName, orgName);
    }

    @Transactional(readOnly=false)
    public WorkRoleInfo getWorkRoleInfoByNameAndOrgName2(String workName, String orgName, Long cid) {
        return this.workRoleInfoMapper.getWorkRoleInfoByWorkNameAndOrgName2(cid, workName, orgName);
    }

    public Integer getWorkInfoCountByCid(Long cid) {
        if (cid == null) {
            return 0;
        }
        return this.getWorkRoleInfosByCid(cid).size();
    }

    public Integer getWorkInfoCountByWorkNameAndOrgId(String workName, Long orgId, Long cid) {
        Example example = new Example(WorkRoleInfo.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("workName", (Object)workName).andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)"1").andEqualTo("orgId", (Object)orgId);
        return this.getCountByExample(example);
    }

    public List<WorkRoleInfo> getWorkInfoListWorkNameAndOrgId(String workName, Long orgId, Long cid) {
        Example example = new Example(WorkRoleInfo.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("workName", (Object)workName).andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)"1").andEqualTo("orgId", (Object)orgId);
        return this.workRoleInfoMapper.selectByExample(example);
    }

    public String getWorkNameIncludeOrgName(Long workId) {
        WorkRoleInfo w = this.getById(workId);
        if (w != null) {
            Object workName = "";
            workName = (String)workName + w.getWorkName() + "/";
            if (StringUtils.isNotEmpty((String)w.getOrgName())) {
                workName = (String)workName + w.getOrgName();
            }
            if (!w.getIsValid().booleanValue()) {
                return "(\u5df2\u5220\u9664)" + (String)workName;
            }
            return workName;
        }
        return "";
    }

    public String getHistoryWorkNameIncludeOrgNameByWorkIdAndYear(Long workId, Date year) {
        if (workId == null || year == null) {
            return "";
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WorkInfoImportVo> getWorkInfoFromExcel(String ossfile, Long loginStaffId, Long cid) {
        HSSFWorkbook wb = null;
        List<WorkInfoImportVo> list = new ArrayList<WorkInfoImportVo>();
        try {
            wb = new HSSFWorkbook(ExcelUtil.getInstance().getOssInputStream(ossfile));
        }
        catch (Exception sheet) {
        }
        finally {
            if (wb != null) {
                try {
                    HSSFSheet sheet = wb.getSheetAt(0);
                    list = this.parseWorkInfofromExcel(sheet, loginStaffId, cid);
                    wb.close();
                }
                catch (IOException sheet) {}
            }
        }
        return list;
    }

    @Transactional(readOnly=false)
    public int importWorkInfo(List<WorkInfoImportVo> list, Long cid, Long loginStaffId) throws Exception {
        int addNum = 0;
        HashMap<String, Long> deptMap = new HashMap<String, Long>();
        for (WorkInfoImportVo vo : list) {
            WorkRoleInfo info = this.getWorkRoleInfoByNameAndOrgName(vo.getWorkName(), vo.getDeptName(), cid);
            if (info == null || info.getId() == null) {
                ++addNum;
                WorkRoleInfo work = new WorkRoleInfo();
                work.setWorkName(vo.getWorkName());
                if (vo.getDeptId() == null) {
                    Long deptId = (Long)deptMap.get(vo.getDeptName());
                    if (deptId != null) {
                        work.setOrgId(deptId);
                    } else {
                        CompanyOrganization org = new CompanyOrganization();
                        org.setCid(cid);
                        org.setOrganizationName(vo.getDeptName());
                        org = this.companyOrganizationService.addCompanyOrganization(org);
                        work.setOrgId(org.getId());
                        deptMap.put(vo.getDeptName(), org.getId());
                    }
                } else {
                    work.setOrgId(vo.getDeptId());
                }
                if (vo.getHarms() != null) {
                    work.setHarmFanctorIds(vo.getHarms());
                }
                if (vo.getProtectIds() != null) {
                    work.setProtectIds(vo.getProtectIds());
                }
                this.add(work, loginStaffId, cid);
                if (work.getHarmFanctorIds() == null) continue;
                this.sysCoreWorkModuleCorrelationService.postHarmFactorChange(work.getId(), loginStaffId, cid);
                continue;
            }
            WorkRoleInfo oldWork = info;
            if (vo.getHarms() != null) {
                info.setHarmFanctorIds(vo.getHarms());
            }
            if (this.isChangeHarmFactor(oldWork, info).booleanValue()) {
                this.sysCoreWorkModuleCorrelationService.postHarmFactorChange(info.getId(), loginStaffId, cid);
            }
            this.update(info, loginStaffId);
        }
        return addNum;
    }

    private List<WorkInfoImportVo> parseWorkInfofromExcel(HSSFSheet sheet, Long loginStaffId, Long cid) {
        ArrayList<WorkInfoImportVo> list = new ArrayList<WorkInfoImportVo>();
        int rowIndex = 0;
        int cellIndex = 3;
        Map harmMap = this.harmFactorService.getAllNameAndIdMap();
        Map protectMap = this.protectListService.getAllNameAndIdMap();
        Iterator iter = sheet.rowIterator();
        while (iter.hasNext()) {
            Row row = (Row)iter.next();
            if (++rowIndex < 3) continue;
            WorkInfoImportVo vo = new WorkInfoImportVo();
            vo.setCid(cid);
            vo.setLoginStaffId(loginStaffId);
            vo.setErrorReason("");
            block7: for (int i = 0; i <= cellIndex; ++i) {
                Cell cell = row.getCell(i);
                if (cell != null) {
                    cell.setCellType(CellType.STRING);
                }
                switch (i) {
                    case 0: {
                        if (cell != null && StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                            vo.setWorkName(cell.getStringCellValue().trim());
                            if (vo.getDataState() != null && vo.getDataState().byteValue() != StaffInfoImportStateEnum.normal.getValue()) continue block7;
                            vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                            continue block7;
                        }
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u5c97\u4f4d\u5de5\u79cd\u540d\u79f0\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;");
                        continue block7;
                    }
                    case 1: {
                        if (cell != null && StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                            vo.setDeptName(cell.getStringCellValue().trim());
                            List orgs = this.companyOrganizationService.getListByName(cell.getStringCellValue().trim(), cid);
                            if (orgs != null && orgs.size() > 0) {
                                vo.setDeptId(((CompanyOrganization)orgs.get(0)).getId());
                            } else {
                                vo.setNeedAddDept("\u7b2c" + rowIndex + "\u884c\u7684" + cell.getStringCellValue().trim() + "\u90e8\u95e8\u672a\u5b58\u5728\u7cfb\u7edf\u4e2d");
                            }
                            if (vo.getDataState() != null && vo.getDataState().byteValue() != StaffInfoImportStateEnum.normal.getValue()) continue block7;
                            vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                            continue block7;
                        }
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u6240\u5c5e\u90e8\u95e8\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;");
                        continue block7;
                    }
                    case 2: {
                        int k;
                        if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) continue block7;
                        StringBuffer sb = new StringBuffer();
                        String harmNames = cell.getStringCellValue().trim();
                        String[] split = harmNames.split("\uff1b");
                        for (k = 0; k < split.length; ++k) {
                            if (!harmMap.containsKey(split[k])) {
                                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + "," + split[k] + "\u5371\u5bb3\u56e0\u7d20\u4e0d\u5b58\u5728");
                                continue;
                            }
                            sb.append((String)harmMap.get(split[k]) + ",");
                        }
                        vo.setHarms(sb.toString());
                        if (vo.getDataState() != null && vo.getDataState().byteValue() != StaffInfoImportStateEnum.normal.getValue()) continue block7;
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                        continue block7;
                    }
                    case 3: {
                        int k;
                        if (cell == null || !StringUtils.isNotEmpty((String)cell.getStringCellValue())) continue block7;
                        StringBuffer sb = new StringBuffer();
                        String protects = cell.getStringCellValue().trim();
                        String[] split = protects.split("\uff1b");
                        for (k = 0; k < split.length; ++k) {
                            if (!protectMap.containsKey(split[k])) {
                                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + "," + split[k] + "\u5371\u5bb3\u56e0\u7d20\u4e0d\u5b58\u5728");
                                continue;
                            }
                            sb.append((String)protectMap.get(split[k]) + ",");
                        }
                        vo.setProtectIds(sb.toString());
                        if (vo.getDataState() != null && vo.getDataState().byteValue() != StaffInfoImportStateEnum.normal.getValue()) continue block7;
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                }
            }
            list.add(vo);
        }
        return list;
    }

    private String getExcelColName(int index) {
        if (index <= 26) {
            return String.valueOf((char)(65 + index - 1));
        }
        int a = index / 26;
        int b = index % 26;
        return String.valueOf((char)(65 + a - 1)) + String.valueOf((char)(65 + b - 1));
    }

    public List<Long> getHisDataWorkAreaId(Long cid, Date date, Long workId) {
        return ((WorkRoleInfoMapper)this.dao).getHisDataWorkAreaId(cid, date, workId);
    }

    public List<WorkRoleInfo> getCurrentAndPluralityWorkRoleInfosByCid(Long staffId) {
        return ((WorkRoleInfoMapper)this.dao).getCurrentAndPluralityWorkRoleInfosByCid(staffId);
    }

    public String getHarmNameByWorkRoleInfo(Long cid) {
        Example example = new Example(WorkRoleInfo.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true);
        List<WorkRoleInfo> workRoleInfoList = this.getListByExample(example);
        if (CollectionUtils.isNotEmpty(workRoleInfoList)) {
            List harmFactorList;
            HashSet harmIdList = new HashSet();
            workRoleInfoList.forEach(wri -> {
                String harmFanctorIds = wri.getHarmFanctorIds();
                List longs = StringUtils.parseToLongList((String)harmFanctorIds);
                harmIdList.addAll(longs);
            });
            if (CollectionUtils.isNotEmpty(harmIdList) && CollectionUtils.isNotEmpty((Collection)(harmFactorList = this.harmFactorService.getHarmByIds(StringUtils.join(harmIdList, (String)","))))) {
                Set collect = harmFactorList.stream().map(h -> h.getNameCh()).collect(Collectors.toSet());
                return StringUtils.join(collect, (String)",");
            }
        }
        return "";
    }

    public List<HarmFactor> getHarmfactorListByWork(Long workId, Long cid) {
        WorkRoleInfo info;
        if (cid != null && workId != null && (info = this.getById(workId)) != null && info.getHarmFanctorIds() != null) {
            List list = this.harmFactorService.getHarmByIds(info.getHarmFanctorIds());
            return list;
        }
        return null;
    }

    public Integer getContactHazardsStaffNumByCid(Long cid) {
        return ((WorkRoleInfoMapper)this.dao).getContactHazardsStaffNumByCid(cid);
    }

    public List<CompanyHarmNumVo> getContactHazardsStaffNumByCid2(Long cid) {
        return ((WorkRoleInfoMapper)this.dao).getContactHazardsStaffNumByCid2(cid);
    }

    @Transactional(readOnly=false)
    public void addWorkAndDeptFormExposeData(Long cid, Long staffId) {
        Map map;
        if (cid == null) {
            return;
        }
        int orgNum = this.companyOrganizationService.getCountByCid(cid);
        int workNum = this.getWorkInfoCountByCid(cid);
        if ((orgNum == 0 || workNum == 0) && (map = this.riskExposeEvaluateService.getComConcatWorkAndDept(cid)) != null) {
            ArrayList list = new ArrayList(map.values());
            if (orgNum == 0) {
                HashMap<String, CompanyOrganization> orgMap = new HashMap<String, CompanyOrganization>();
                ArrayList<WorkRoleInfo> workList = new ArrayList<WorkRoleInfo>();
                if (workNum == 0) {
                    for (RiskExposeEvaluateData risk : list) {
                        CompanyOrganization org = (CompanyOrganization)orgMap.get(risk.getWorkshop());
                        if (org == null) {
                            org = new CompanyOrganization();
                            this.setOrgInfo(org, risk.getWorkshop(), cid);
                            orgMap.put(risk.getWorkshop(), org);
                        }
                        WorkRoleInfo work = new WorkRoleInfo();
                        work.setCid(cid);
                        work.setWorkName(risk.getWorkName());
                        work.setId(Long.valueOf(this.idworker.nextId()));
                        work.setOrgId(org.getId());
                        work.setCreateBy(staffId);
                        work.setUpdateBy(staffId);
                        work.setUpdateDate(new Date());
                        work.setUpdateDate(new Date());
                        work.setHarmFanctorIds(risk.getFactorId());
                        workList.add(work);
                    }
                    this.addWorkRoleList(workList);
                    this.companyOrganizationService.addOrgList(new ArrayList(orgMap.values()));
                } else {
                    for (RiskExposeEvaluateData risk : list) {
                        CompanyOrganization org = (CompanyOrganization)orgMap.get(risk.getWorkshop());
                        if (org != null) continue;
                        org = new CompanyOrganization();
                        this.setOrgInfo(org, risk.getWorkshop(), cid);
                        orgMap.put(risk.getWorkshop(), org);
                    }
                    this.companyOrganizationService.addOrgList(new ArrayList(orgMap.values()));
                }
            } else {
                HashMap<String, WorkRoleInfo> workMap = new HashMap<String, WorkRoleInfo>();
                for (RiskExposeEvaluateData risk : list) {
                    WorkRoleInfo work = (WorkRoleInfo)workMap.get(risk.getWorkName());
                    if (work != null) continue;
                    work = new WorkRoleInfo();
                    work.setCid(cid);
                    work.setWorkName(risk.getWorkName());
                    work.setId(Long.valueOf(this.idworker.nextId()));
                    work.setCreateBy(staffId);
                    work.setUpdateBy(staffId);
                    work.setUpdateDate(new Date());
                    work.setUpdateDate(new Date());
                    work.setHarmFanctorIds(risk.getFactorId());
                    workMap.put(risk.getWorkName(), work);
                }
                this.addWorkRoleList(new ArrayList<WorkRoleInfo>(workMap.values()));
            }
        }
    }

    public List<WorkRoleInfo> getWorkRoleInfosByCidAndOrgAndSearchExcludeChoose(Long cid, Long orgId, String searchKey, Long reWork) {
        return ((WorkRoleInfoMapper)this.dao).getWorkRoleInfosByCidAndOrgAndSearchExcludeChoose(cid, orgId, searchKey, reWork);
    }

    private void setOrgInfo(CompanyOrganization org, String orgName, Long cid) {
        org.setCid(cid);
        org.setOrganizationName(orgName);
        org.setId(Long.valueOf(this.idworker.nextId()));
        org.setUpdateDate(new Date());
        org.setUpdateDate(new Date());
        org.setLevel(Byte.valueOf((byte)1));
    }

    public Map<String, WorkRoleInfo> getAllWorkRoleInfoByCids(Set<Long> cidSet) {
        HashMap<String, WorkRoleInfo> workRoleInfoMap = new HashMap<String, WorkRoleInfo>();
        Example example = new Example(WorkRoleInfo.class);
        Example.Criteria criteria = example.createCriteria();
        if (CollectionUtils.isNotEmpty(cidSet)) {
            criteria.andIn("cid", cidSet);
        }
        criteria.andEqualTo("isValid", (Object)true);
        List workRoleInfoList = this.getListByExample(example);
        if (CollectionUtils.isEmpty(workRoleInfoList)) {
            return workRoleInfoMap;
        }
        for (WorkRoleInfo workRoleInfo : workRoleInfoList) {
            String workRoleInfoKey = workRoleInfo.getCid() + "-" + workRoleInfo.getOrgId() + "-" + workRoleInfo.getWorkName();
            workRoleInfo.setNewAdd(Boolean.valueOf(false));
            workRoleInfoMap.put(workRoleInfoKey, workRoleInfo);
        }
        return workRoleInfoMap;
    }
}

