/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.wmbase;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.framework.service.datascope.DataScopeHelper;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.dao.base.wmbase.WmMaintenanceDetailMapper;
import cn.smarthse.modules.health.entity.base.wmbase.WmMaintenanceDetail;
import cn.smarthse.modules.health.entity.base.wmbase.WmMaintenanceDetailArea;
import cn.smarthse.modules.health.entity.base.wmbase.WmMaintenanceDetailWorkItemVo;
import cn.smarthse.modules.health.entity.datascope.DataScope;
import cn.smarthse.modules.health.entity.sys.SysCoreWorkModuleCorrelation;
import cn.smarthse.modules.health.enums.sys.coreWork.CoreWorkEnum;
import cn.smarthse.modules.health.service.base.company.ICompanyAreaService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.base.wmbase.IWmMaintenanceDetailAreaService;
import cn.smarthse.modules.health.service.base.wmbase.IWmMaintenanceDetailService;
import cn.smarthse.modules.health.service.sys.ISysCoreWorkModuleCorrelationService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class WmMaintenanceDetailServiceImpl
extends BaseServiceImpl<WmMaintenanceDetailMapper, WmMaintenanceDetail>
implements IWmMaintenanceDetailService {
    @Autowired
    WmMaintenanceDetailMapper wmMaintenanceDetailMapper;
    @Autowired
    ISysCoreWorkModuleCorrelationService sysCoreWorkModuleCorrelationService;
    @Autowired
    IWmMaintenanceDetailAreaService wmMaintenanceDetailAreaService;
    @Autowired
    ICompanyAreaService companyAreaService;
    @Autowired
    private IStaffInfoService stafInfoService;

    public PageInfo<WmMaintenanceDetail> getListItemList(JqGridParam param, Boolean saveState) {
        if (param == null) {
            return new PageInfo();
        }
        if (param.getCid() == null || param.getCid() == 0L) {
            return new PageInfo();
        }
        WmMaintenanceDetail detail = new WmMaintenanceDetail();
        detail.setCid(param.getCid());
        detail.setSaveState(saveState);
        if (StringUtils.isNotEmpty((String)param.getSidx())) {
            detail.setOrder(param.getSidx() + " " + param.getSord());
        } else {
            detail.setOrder("update_date desc");
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        DataScopeHelper.startDataScope("warnmarkWmBase", "wm_maintenance_detail");
        List<WmMaintenanceDetail> list = this.wmMaintenanceDetailMapper.selectListByState(detail);
        for (WmMaintenanceDetail details : list) {
            details.setContactName(this.stafInfoService.getStaffNameIncludeDelStatusByStaffId(details.getContactId()));
            List areas = this.wmMaintenanceDetailAreaService.getListByMainId(details.getId());
            if (areas.size() <= 0) continue;
            Object areaNames = null;
            for (WmMaintenanceDetailArea area : areas) {
                if (areaNames == null) {
                    areaNames = area.getAreaName();
                    continue;
                }
                areaNames = (String)areaNames + " ;" + area.getAreaName();
            }
            details.setConcatArea(areaNames);
        }
        return new PageInfo(list);
    }

    public List<WmMaintenanceDetail> getList(Long cid, Boolean saveState) {
        WmMaintenanceDetail detail = new WmMaintenanceDetail();
        detail.setCid(cid);
        detail.setSaveState(saveState);
        detail.setOrder("update_date desc");
        DataScopeHelper.startDataScope("warnmarkWmBase", "wm_maintenance_detail");
        List<WmMaintenanceDetail> list = this.wmMaintenanceDetailMapper.selectListByState(detail);
        int serialNum = 1;
        for (WmMaintenanceDetail details : list) {
            details.setSerialNum(Integer.valueOf(serialNum));
            details.setContactName(this.stafInfoService.getStaffNameIncludeDelStatusByStaffId(details.getContactId()));
            ++serialNum;
            List areas = this.wmMaintenanceDetailAreaService.getListByMainId(details.getId());
            if (areas.size() <= 0) continue;
            Object areaNames = null;
            for (WmMaintenanceDetailArea area : areas) {
                if (areaNames == null) {
                    areaNames = area.getAreaName();
                    continue;
                }
                areaNames = (String)areaNames + " ;" + area.getAreaName();
            }
            details.setConcatArea(areaNames);
        }
        return list;
    }

    private Integer getYearNum(Long cid) {
        Date time = ((WmMaintenanceDetailMapper)this.dao).selectMaxMainteTimeByCid(cid);
        Date distanceDate = DateUtils.getDistanceDate((Date)time, (int)1, (int)1);
        Date tipDate = DateUtils.getDistanceDate((Date)distanceDate, (int)5, (int)-1);
        if (tipDate != null && tipDate.getTime() <= new Date().getTime()) {
            return 1;
        }
        return 0;
    }

    private Integer getProceNum(Long cid) {
        Example example = new Example(WmMaintenanceDetail.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true).andEqualTo("saveState", (Object)Global.FALSE);
        return ((WmMaintenanceDetailMapper)this.dao).selectCountByExample(example);
    }

    private Integer getCompleteNum(Long cid) {
        Example example = new Example(WmMaintenanceDetail.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true).andEqualTo("saveState", (Object)Global.TRUE);
        return ((WmMaintenanceDetailMapper)this.dao).selectCountByExample(example);
    }

    @Transactional
    public WmMaintenanceDetailWorkItemVo getWorkItemVo(Long cid) {
        WmMaintenanceDetailWorkItemVo item = new WmMaintenanceDetailWorkItemVo();
        DataScopeHelper.startDataScope("warnmarkWmBase", "wm_maintenance_detail");
        DataScope dataScope = DataScopeHelper.getDataScope();
        Integer yearNum = this.getYearNum(cid);
        item.setYearNum(yearNum);
        DataScopeHelper.setDataScope(dataScope);
        Integer proceNum = this.getProceNum(cid);
        item.setProceNum(proceNum);
        DataScopeHelper.setDataScope(dataScope);
        Integer completeNum = this.getCompleteNum(cid);
        item.setCompleteNum(completeNum);
        List threeSimultaneityList = this.sysCoreWorkModuleCorrelationService.getListToRemind(CoreWorkEnum.threeSimultaneityManagement, CoreWorkEnum.WarningSigns, cid);
        Integer sizes = threeSimultaneityList.size();
        List harmfactorManageAreaList = this.sysCoreWorkModuleCorrelationService.getListToRemind(CoreWorkEnum.harmfactorManageArea, CoreWorkEnum.WarningSigns, cid);
        for (SysCoreWorkModuleCorrelation harmfactorManageArea : harmfactorManageAreaList) {
            String areaName = this.companyAreaService.getTreePathNameByAreaId(harmfactorManageArea.getSurceBusinessId()) + harmfactorManageArea.getBusinessName();
            harmfactorManageArea.setBusinessName(areaName);
        }
        sizes = sizes + harmfactorManageAreaList.size();
        item.setHarmfactorManageAreaList(harmfactorManageAreaList);
        item.setThreeSimultaneityList(threeSimultaneityList);
        item.setSizes(sizes);
        return item;
    }
}

