/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.wmbase;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.dao.base.wmbase.WmMaintenanceDetailAreaMapper;
import cn.smarthse.modules.health.entity.base.wmbase.WmMaintenanceDetailArea;
import cn.smarthse.modules.health.service.base.company.ICompanyAreaService;
import cn.smarthse.modules.health.service.base.wmbase.IWmMaintenanceDetailAreaService;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class WmMaintenanceDetailAreaServiceImpl
extends BaseServiceImpl<WmMaintenanceDetailAreaMapper, WmMaintenanceDetailArea>
implements IWmMaintenanceDetailAreaService {
    @Autowired
    WmMaintenanceDetailAreaMapper wmMaintenanceDetailAreaMapper;
    @Autowired
    private ICompanyAreaService companyAreaService;

    @Transactional(readOnly=false)
    public void adds(List<WmMaintenanceDetailArea> areaList, Long id, Long staffId, Long cid) {
        WmMaintenanceDetailArea entity = new WmMaintenanceDetailArea();
        entity.setMaintenanceDetailId(id);
        this.delete(entity);
        if (areaList != null && areaList.size() > 0) {
            for (WmMaintenanceDetailArea area : areaList) {
                if (area.getAreaId() == null) continue;
                area.setMaintenanceDetailId(id);
                this.add(area, staffId, cid);
            }
        }
    }

    public List<WmMaintenanceDetailArea> getListByMainId(Long detailId) {
        if (detailId == null) {
            return null;
        }
        List<WmMaintenanceDetailArea> list = this.wmMaintenanceDetailAreaMapper.selectListByMainId(detailId);
        for (WmMaintenanceDetailArea area : list) {
            String areaName = this.companyAreaService.getTreePathNameByAreaId(area.getAreaId());
            area.setAreaName(areaName + area.getAreaName());
        }
        return list;
    }
}

