/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.wmbase;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.jqgrid.ParamSeachFieldVO;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.dao.base.wmbase.WmBaseListViewMapper;
import cn.smarthse.modules.health.entity.base.wmbase.WmBase;
import cn.smarthse.modules.health.entity.base.wmbase.WmBaseListView;
import cn.smarthse.modules.health.service.base.company.ICompanyAreaService;
import cn.smarthse.modules.health.service.base.occriskfactor.IOccupationalRiskFactorsService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.base.wmbase.IWmBaseListViewService;
import cn.smarthse.modules.health.service.base.wmbase.IWmBaseService;
import cn.smarthse.modules.health.service.base.wmbase.IWmContentTypeService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class WmBaseListViewServiceImpl
extends BaseServiceImpl<WmBaseListViewMapper, WmBaseListView>
implements IWmBaseListViewService {
    @Autowired
    WmBaseListViewMapper wmBaseListViewMapper;
    @Autowired
    private ICompanyAreaService companyAreaService;
    @Autowired
    private IStaffInfoService staffInfoService;
    @Autowired
    private IWmBaseService wmBaseService;
    @Autowired
    IOccupationalRiskFactorsService occupationalRiskFactorsService;
    @Autowired
    IWmContentTypeService wmContentTypeServiceImpl;

    public PageInfo<WmBaseListView> getWmBaseListItemList(JqGridParam param, Long areaId, Long signType, List<Long> areaIds) {
        if (param == null) {
            return new PageInfo();
        }
        if (param.getCid() == null || param.getCid() == 0L) {
            return new PageInfo();
        }
        WmBaseListView wmbase = new WmBaseListView();
        wmbase.setCid(param.getCid());
        if (areaId != null) {
            wmbase.setAreaId(areaId);
        }
        if (signType != null) {
            wmbase.setSignType(signType);
        }
        if (param.getPostDatas() != null) {
            for (ParamSeachFieldVO sField : param.getPostDatas()) {
                if ("keyword".equals(sField.getSearchField())) {
                    if ("".equals(sField.getSearchValue())) continue;
                    wmbase.setKeyword(sField.getSearchValue());
                    continue;
                }
                if ("signType".equals(sField.getSearchField())) {
                    if ("".equals(sField.getSearchValue())) continue;
                    wmbase.setSignType(Long.valueOf(sField.getSearchValue()));
                    continue;
                }
                if ("areaId".equals(sField.getSearchField())) {
                    if ("".equals(sField.getSearchValue())) continue;
                    wmbase.setAreaId(Long.valueOf(sField.getSearchValue()));
                    continue;
                }
                if (!"managerId".equals(sField.getSearchField()) || "".equals(sField.getSearchValue())) continue;
                wmbase.setManagerId(Long.valueOf(sField.getSearchValue()));
            }
        }
        if (StringUtils.isNotEmpty((String)param.getSidx())) {
            wmbase.setOrder(param.getSidx() + " " + param.getSord());
        } else {
            wmbase.setOrder("create_date desc");
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<WmBaseListView> list = null;
        if (areaIds == null) {
            list = this.wmBaseListViewMapper.selectList(wmbase);
        } else if (areaIds.isEmpty()) {
            list = new ArrayList<WmBaseListView>();
        } else {
            wmbase.setAreaIds(areaIds);
            wmbase.setAreaId(null);
            list = this.wmBaseListViewMapper.selectListByAreaIds(wmbase);
        }
        return new PageInfo(list);
    }

    public List<WmBaseListView> getWmbaseListByCid(Long cid) {
        WmBaseListView wmbase = new WmBaseListView();
        wmbase.setCid(cid);
        wmbase.setOrder("update_date desc");
        List<WmBaseListView> list = this.wmBaseListViewMapper.selectList(wmbase);
        for (WmBaseListView view : list) {
            WmBase wm = (WmBase)this.wmBaseService.getById(view.getId());
            if (wm.getAreaName() != null) {
                view.setAreaName(wm.getAreaName());
                continue;
            }
            String areaName = this.companyAreaService.getTreePathNameByAreaId(view.getAreaId());
            view.setAreaName(areaName + view.getAreaName());
        }
        return list;
    }

    public List<WmBaseListView> getWmbaseListByCidAndYear(Long cid, Integer year) {
        ArrayList<WmBaseListView> viewList = new ArrayList<WmBaseListView>();
        return viewList;
    }
}

