/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.wmbase;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IHarmFactorService;
import cn.smarthse.modules.health.compliance.enums.ComplianceCodeEnum;
import cn.smarthse.modules.health.compliance.service.IBusinessDataUpdateRefreshService;
import cn.smarthse.modules.health.dao.base.wmbase.WarnSignManageDetailMapper;
import cn.smarthse.modules.health.dao.base.wmbase.WarnSignManageMapper;
import cn.smarthse.modules.health.entity.base.wmbase.WarnSignManage;
import cn.smarthse.modules.health.entity.base.wmbase.WarnSignManageDetail;
import cn.smarthse.modules.health.enums.certificate.ApprovalStatusEnum;
import cn.smarthse.modules.health.enums.reform.ReformGenerationSourceEnum;
import cn.smarthse.modules.health.service.base.wmbase.IWarnSignManageDetailService;
import cn.smarthse.modules.health.service.base.wmbase.IWarnSignManageService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.supervise.entity.keyFactory.KeyFactory;
import cn.smarthse.modules.health.supervise.entity.keyFactory.KeyFactoryApprovalHistory;
import cn.smarthse.modules.health.supervise.enums.keyFactory.HistoryStatusEnum;
import cn.smarthse.modules.health.supervise.enums.keyFactory.KeyFactoryStatusEnum;
import cn.smarthse.modules.health.supervise.enums.keyFactory.KeyFactoryTypeEnum;
import cn.smarthse.modules.health.supervise.service.keyFactory.IKeyFactoryApprovalHistoryService;
import cn.smarthse.modules.health.supervise.service.keyFactory.IKeyFactoryService;
import cn.smarthse.services.hfi.api.entity.riskev.RiskExposeEvaluate;
import cn.smarthse.services.hfi.api.entity.riskev.RiskExposeEvaluateData;
import cn.smarthse.services.hfi.api.model.riskev.EvQueryParam;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import cn.smarthse.services.hfi.api.service.ICheckResultService;
import cn.smarthse.services.hfi.api.service.riskev.IRiskExposeEvaluateDataService;
import cn.smarthse.services.hfi.api.service.riskev.IRiskExposeEvaluateService;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.smarthse.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class WarnSignManageServiceImpl
extends BaseServiceImpl<WarnSignManageMapper, WarnSignManage>
implements IWarnSignManageService {
    @DubboReference(version="1.0.0")
    ICompanyProvideByHSEService companyProvideByHSEService;
    @Autowired
    IWarnSignManageDetailService signManageDetailService;
    @DubboReference
    ICheckPlanService checkPlanService;
    @DubboReference
    ICheckResultService checkResultService;
    @DubboReference
    IRiskExposeEvaluateService exposeEvaluateService;
    @DubboReference
    IRiskExposeEvaluateDataService exposeEvaluateDataService;
    @DubboReference(version="1.0.0")
    IHarmFactorService harmFactorService;
    @DubboReference
    IKeyFactoryService keyFactoryService;
    @DubboReference
    IKeyFactoryApprovalHistoryService historyService;
    @Autowired
    private RedisClient redisClient;
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    private IReformItemBasicService reformItemBasicService;
    @DubboReference
    private IBusinessDataUpdateRefreshService refreshService;

    public List<WarnSignManage> getListSignManageBySearchModel(WarnSignManage searchModel) {
        List<WarnSignManage> list = ((WarnSignManageMapper)this.dao).getListSignManageBySearchMode(searchModel);
        return list;
    }

    public PageInfo<WarnSignManage> getPagesSignManageBySearchModel(JqGridParam jqGridParam, WarnSignManage searchModel) {
        PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows());
        List<WarnSignManage> list = this.getListSignManageBySearchModel(searchModel);
        return new PageInfo(list);
    }

    @Transactional(readOnly=false)
    public Integer deleteByIds(List<Long> ids, Long loginStaffId) {
        if (CollectionUtils.isEmpty(ids)) {
            return 0;
        }
        ArrayList<WarnSignManage> list = new ArrayList<WarnSignManage>();
        for (Long id : ids) {
            WarnSignManage record = new WarnSignManage();
            record.setId(id);
            record.setUpdateDate(new Date());
            record.setUpdateBy(loginStaffId);
            record.setIsValid(Boolean.valueOf(false));
            list.add(record);
        }
        int i = this.batchUpdateOrInsert(list, WarnSignManageMapper.class, (item, mapper) -> mapper.updateByPrimaryKeySelective(item), 1000);
        this.signManageDetailService.deleteBySignManageIds(ids, loginStaffId);
        return i;
    }

    @Transactional(readOnly=false)
    public Integer deleteByIds(List<Long> ids) {
        int i = ((WarnSignManageMapper)this.dao).deleteByIds(ids.toString());
        this.signManageDetailService.deleteBySignManageIds(ids);
        return i;
    }

    @Transactional(readOnly=false)
    public WarnSignManage cloneSignManage(Long id, Long loginStaffId) {
        WarnSignManage oldSignManage = (WarnSignManage)this.getById(id);
        if (oldSignManage == null) {
            throw new RuntimeException("\u672a\u627e\u5230\u8be5\u9884\u8b66\u6807\u8bc6\u7ba1\u7406\u4fe1\u606f");
        }
        Example e = new Example(WarnSignManageDetail.class);
        e.createCriteria().andEqualTo("signManageId", (Object)oldSignManage.getId()).andEqualTo("isValid", (Object)true);
        List signManageDetail = this.signManageDetailService.getListByExample(e);
        oldSignManage.setId(null);
        oldSignManage.setReportState(Integer.valueOf(1));
        oldSignManage.setChangeTime(null);
        if (StringUtils.isNotBlank((CharSequence)oldSignManage.getFactorNames())) {
            oldSignManage.setFactorNames(oldSignManage.getFactorNames().replaceAll("[\t\n\r]", ""));
        }
        WarnSignManage signManageNew = this.add(oldSignManage, loginStaffId, null);
        if (CollectionUtils.isNotEmpty((Collection)signManageDetail)) {
            for (WarnSignManageDetail o : signManageDetail) {
                if (StringUtils.isNotBlank((CharSequence)o.getFactorNames())) {
                    o.setFactorNames(o.getFactorNames().replaceAll("[\t\n\r]", ""));
                }
                o.setId(Long.valueOf(this.idworker.nextId()));
                o.setIsCheckGenerate(Boolean.valueOf(false));
                o.setCheckId(null);
                o.setCredentialFileId(null);
                o.setSignManageId(signManageNew.getId());
                o.setUpdateBy(loginStaffId);
                o.setUpdateDate(new Date());
            }
            this.signManageDetailService.batchUpdateOrInsert(signManageDetail, WarnSignManageDetailMapper.class, (item, mapper) -> mapper.insert(item), 1000);
            signManageNew.setRecordDetailList(signManageDetail);
        }
        if (signManageNew == null) {
            throw new ServiceException("\u514b\u9686\u6570\u636e\u4e3a\u7a7a");
        }
        return signManageNew;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Transactional(readOnly=false)
    public WarnSignManage saveOrSubmitSignManage(WarnSignManage needUpdateData, Integer changeState) {
        List recordDetailListByRecordId;
        WarnSignManage temp;
        Long updateBy = needUpdateData.getUpdateBy();
        WarnSignManage old = (WarnSignManage)this.getById(needUpdateData.getId());
        if (old == null) {
            throw new ServiceException("\u672a\u627e\u5230\u8be5\u9884\u8b66\u6807\u8bc6\u7ba1\u7406\u4fe1\u606f");
        }
        if (changeState == 2 && changeState.equals(old.getReportState())) {
            throw new ServiceException("\u91cd\u590d\u63d0\u4ea4");
        }
        if (old.getReportType() == 1 && (temp = this.getRecordFactorIds(old.getId())) != null) {
            needUpdateData.setFactorIds(temp.getFactorIds());
            if (StringUtils.isNotBlank((CharSequence)temp.getFactorNames())) {
                needUpdateData.setFactorNames(temp.getFactorNames());
            }
        }
        if (changeState == 2 && CollectionUtils.isEmpty((Collection)(recordDetailListByRecordId = this.signManageDetailService.getRecordDetailListByRecordId(needUpdateData.getId())))) {
            throw new ServiceException("\u8be6\u60c5\u4e3a\u7a7a\u65f6\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4");
        }
        needUpdateData.setReportState(changeState);
        RLock lock = this.redissonClient.getLock("keyFactor:WarnSignManage:" + needUpdateData.getId() + ":hot");
        if (lock.tryLock()) {
            try {
                if (changeState == 2) {
                    Long keyFactoryId = this.submit(old, needUpdateData, updateBy);
                    needUpdateData.setKeyFactoryId(keyFactoryId);
                    int i = ((WarnSignManageMapper)this.dao).updateByPrimaryKeySelective(needUpdateData);
                    this.reformItemBasicService.changeStatusByCidAndGenerationSource(old.getCid(), ReformGenerationSourceEnum.WARNING_SIGNS.getValue(), null, updateBy, null);
                }
                if (changeState != 1) return needUpdateData;
                int keyFactoryId = ((WarnSignManageMapper)this.dao).updateByPrimaryKeySelective(needUpdateData);
                return needUpdateData;
            }
            catch (Exception e) {
                throw new ServiceException(e.getMessage());
            }
            finally {
                lock.unlock();
            }
        } else {
            this.logger.error("\u672a\u83b7\u5f97\u9501\u8d44\u6e90keyFactor:WarnSignManage id:{}", (Object)needUpdateData.getId());
            return null;
        }
    }

    public Long submit(WarnSignManage old, WarnSignManage needUpdateData, Long updateBy) {
        Long keyFactoryId;
        KeyFactoryApprovalHistory history = new KeyFactoryApprovalHistory();
        history.setCid(old.getCid());
        history.setOperatorCompanyName(needUpdateData.getCompanyName());
        history.setOperator(needUpdateData.getUpdateByStr());
        history.setBusinessId(old.getId());
        history.setUpdateBy(updateBy);
        history.setCreateBy(updateBy);
        history.setType(KeyFactoryTypeEnum.WARNING_SIGNS.getCode());
        history.setStatus(HistoryStatusEnum.SUBMIT.getCode());
        this.historyService.addRecord(Collections.singletonList(history));
        CompanyBaseInfoModel companyBaseInfoModel = this.companyProvideByHSEService.getCompanyById(old.getCid());
        Company company = new Company();
        BeanUtils.copyProperties((Object)companyBaseInfoModel, (Object)company);
        company.setId(companyBaseInfoModel.getCid());
        if (old.getReportType() == 1) {
            keyFactoryId = this.keyFactoryService.submitNotNeedAudit(company, updateBy, old.getId(), KeyFactoryTypeEnum.WARNING_SIGNS);
            needUpdateData.setReportState(Integer.valueOf(5));
            history.setStatus(HistoryStatusEnum.PASS.getCode());
            this.historyService.addRecord(Collections.singletonList(history));
        } else {
            keyFactoryId = this.keyFactoryService.submitKeyFactory(company, updateBy, old.getId(), KeyFactoryTypeEnum.WARNING_SIGNS);
        }
        return keyFactoryId;
    }

    public WarnSignManage getRecordFactorIds(Long id) {
        if (id == null) {
            return null;
        }
        WarnSignManage record = new WarnSignManage();
        List recordDetailList = this.signManageDetailService.getRecordDetailListByRecordId(id);
        if (CollectionUtils.isNotEmpty((Collection)recordDetailList)) {
            Map harmIdAndName = this.harmFactorService.getAllIdAndNameMapIncludeInValid();
            StringBuilder factorStrIds = new StringBuilder();
            for (WarnSignManageDetail detail : recordDetailList) {
                if (detail == null || !StringUtils.isNotBlank((CharSequence)detail.getFactorIds())) continue;
                if (StringUtils.isNotBlank((CharSequence)factorStrIds.toString())) {
                    factorStrIds.append(",").append(detail.getFactorIds());
                    continue;
                }
                factorStrIds.append(detail.getFactorIds());
            }
            if (StringUtils.isNotBlank((CharSequence)factorStrIds.toString())) {
                List factorIds = Arrays.stream(factorStrIds.toString().split(",")).distinct().collect(Collectors.toList());
                record.setFactorIds(String.join((CharSequence)",", factorIds));
                boolean refresh = true;
                StringBuilder factorStrNames = new StringBuilder();
                for (String item : factorIds) {
                    String s = (String)harmIdAndName.get(item);
                    if (StringUtils.isBlank((CharSequence)s) && refresh) {
                        this.redisClient.delPrefix("HarmFactorServiceImpl");
                        harmIdAndName = this.harmFactorService.getAllIdAndNameMapIncludeInValid();
                        s = (String)harmIdAndName.get(item);
                        refresh = false;
                    }
                    if (!StringUtils.isNotBlank((CharSequence)s)) continue;
                    if (StringUtils.isNotBlank((CharSequence)factorStrNames.toString())) {
                        factorStrNames.append(",").append(s.replaceAll("[\t\n\r]", ""));
                        continue;
                    }
                    factorStrNames.append(s.replaceAll("[\t\n\r]", ""));
                }
                record.setFactorNames(factorStrNames.toString());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)record.getFactorIds())) {
            return record;
        }
        return null;
    }

    @Transactional(readOnly=false)
    public Integer changeRecordReportType(Long id, Integer reportType, Long loginStaffId) {
        WarnSignManage signManage = (WarnSignManage)this.getById(id);
        if (signManage == null || reportType == null) {
            throw new ServiceException("\u53c2\u6570\u9519\u8bef");
        }
        if (signManage.getReportType().equals(reportType)) {
            throw new ServiceException("\u91cd\u590d\u64cd\u4f5c");
        }
        WarnSignManage signManageNew = new WarnSignManage();
        signManageNew.setId(signManage.getId());
        signManageNew.setCid(signManage.getCid());
        signManageNew.setReportType(reportType);
        signManageNew.setReportState(Integer.valueOf(1));
        signManageNew.setUpdateBy(loginStaffId);
        signManageNew.setUpdateDate(new Date());
        int i = ((WarnSignManageMapper)this.dao).updateByPrimaryKeySelective(signManageNew);
        return i;
    }

    public List<Integer> getAllRecordYearBySearch(Long cid) {
        return ((WarnSignManageMapper)this.dao).getAllRecordYearBySearch(cid);
    }

    @Transactional
    public WarnSignManage addRecordByCheck(WarnSignManage param) {
        if (param == null || param.getCid() == null) {
            throw new ServiceException("\u53c2\u6570\u5f02\u5e38");
        }
        WarnSignManage signManage = this.add(param);
        return this.generateSignManageDetailByCheck(signManage);
    }

    public WarnSignManage generateSignManageDetailByCheck(WarnSignManage signManage) {
        List dataList;
        List lastEv = this.exposeEvaluateService.getLastEv(new EvQueryParam().setCid(signManage.getCid()));
        if (CollectionUtils.isNotEmpty((Collection)lastEv) && ((RiskExposeEvaluate)lastEv.get(0)).getId() != null && CollectionUtils.isNotEmpty((Collection)(dataList = this.exposeEvaluateDataService.getRiskDataByShopAndPointGroup(((RiskExposeEvaluate)lastEv.get(0)).getId())))) {
            RiskExposeEvaluateData data;
            ArrayList<WarnSignManageDetail> signManageDetailList = new ArrayList<WarnSignManageDetail>();
            StringBuilder factorStrIds = new StringBuilder();
            Iterator iterator = dataList.iterator();
            while (iterator.hasNext() && (data = (RiskExposeEvaluateData)iterator.next()) != null) {
                WarnSignManageDetail signManageDetail = new WarnSignManageDetail();
                signManageDetail.setSignManageId(signManage.getId());
                if (StringUtils.isNotBlank((CharSequence)data.getWorkshop())) {
                    signManageDetail.setWorkshop(data.getWorkshop().trim().replaceAll(" ", "-").replaceAll("[\t\n\r]", ""));
                }
                if (StringUtils.isNotBlank((CharSequence)data.getCheckPoint())) {
                    signManageDetail.setCheckPoint(data.getCheckPoint().trim().replaceAll(" ", "-").replaceAll("[\t\n\r]", ""));
                }
                signManageDetail.setFactorIds(data.getFactorId());
                signManageDetail.setFactorNames(data.getFactorName());
                if (StringUtils.isNotBlank((CharSequence)data.getFactorName())) {
                    signManageDetail.setFactorNames(data.getFactorName().replaceAll("[\t\n\r]", ""));
                }
                signManageDetail.setIsCheckGenerate(Boolean.valueOf(true));
                signManageDetail.setCheckId(((RiskExposeEvaluate)lastEv.get(0)).getId());
                signManageDetail.setCreateBy(signManage.getCreateBy());
                signManageDetail.setUpdateBy(signManage.getCreateBy());
                signManageDetail.setUpdateDate(new Date());
                signManageDetail.setCreateDate(new Date());
                signManageDetail.setIsValid(Boolean.valueOf(true));
                signManageDetailList.add(signManageDetail);
                if (!StringUtils.isNotBlank((CharSequence)data.getFactorId())) continue;
                if (StringUtils.isNotBlank((CharSequence)factorStrIds.toString())) {
                    factorStrIds.append(",").append(data.getFactorId());
                    continue;
                }
                factorStrIds.append(data.getFactorId());
            }
            this.signManageDetailService.batchUpdateOrInsert(signManageDetailList, WarnSignManageDetailMapper.class, (item, mapper) -> mapper.insert(item), 1000);
            WarnSignManage temp = new WarnSignManage();
            temp.setId(signManage.getId());
            List collect = Arrays.stream(factorStrIds.toString().split(",")).distinct().collect(Collectors.toList());
            temp.setFactorIds(String.join((CharSequence)",", collect));
            Map harmIdAndName = this.harmFactorService.getAllIdAndNameMapIncludeInValid();
            boolean refresh = true;
            StringBuilder factorStrNames = new StringBuilder();
            for (String item2 : collect) {
                String s = (String)harmIdAndName.get(item2);
                if (StringUtils.isBlank((CharSequence)s) && refresh) {
                    this.redisClient.delPrefix("HarmFactorServiceImpl");
                    harmIdAndName = this.harmFactorService.getAllIdAndNameMapIncludeInValid();
                    s = (String)harmIdAndName.get(item2);
                    refresh = false;
                }
                if (!StringUtils.isNotBlank((CharSequence)s)) continue;
                if (StringUtils.isNotBlank((CharSequence)factorStrNames.toString())) {
                    factorStrNames.append(",").append(s.replaceAll("[\t\n\r]", ""));
                    continue;
                }
                factorStrNames.append(s.replaceAll("[\t\n\r]", ""));
            }
            temp.setFactorNames(factorStrNames.toString());
            ((WarnSignManageMapper)this.dao).updateByPrimaryKeySelective(temp);
            signManage.setFactorIds(String.join((CharSequence)",", collect));
        }
        return signManage;
    }

    @Transactional(rollbackFor={Exception.class})
    public int approval(KeyFactory keyFactory, Byte status) {
        status = Objects.equals(status, ApprovalStatusEnum.PASSED.getValue()) ? Byte.valueOf((byte)4) : Byte.valueOf((byte)3);
        if (keyFactory != null && keyFactory.getBusinessId() != null && KeyFactoryTypeEnum.WARNING_SIGNS.getCode().equals(keyFactory.getType())) {
            WarnSignManage signManage = new WarnSignManage();
            signManage.setReportState(Integer.valueOf(status.byteValue()));
            signManage.setUpdateBy(keyFactory.getUpdateBy());
            signManage.setUpdateDate(new Date());
            Example example = new Example(WarnSignManage.class);
            example.createCriteria().andEqualTo("id", (Object)keyFactory.getBusinessId()).andNotEqualTo("reportState", (Object)status);
            int i = ((WarnSignManageMapper)this.dao).updateByExampleSelective(signManage, example);
            if (status.equals((byte)4)) {
                this.refreshService.addBusinessDataUpdateMsg(keyFactory.getCid(), null, new ComplianceCodeEnum[]{ComplianceCodeEnum.CODE11});
            }
            this.reformItemBasicService.changeStatusByCidAndGenerationSource(keyFactory.getCid(), ReformGenerationSourceEnum.WARNING_SIGNS.getValue(), null, keyFactory.getUpdateBy(), keyFactory.getBusinessId());
            return i;
        }
        return 0;
    }

    public List<WarnSignManage> getFullSignManage(WarnSignManage searchModel) {
        return ((WarnSignManageMapper)this.dao).getFullSignManage(searchModel);
    }

    public Integer getLastTwoYearsCompletedNum(Long cid) {
        if (cid == null) {
            return null;
        }
        return ((WarnSignManageMapper)this.dao).getLastTwoYearsCompletedNum(cid);
    }

    public String verifyData(WarnSignManage searchModel) {
        boolean b;
        if (searchModel == null) {
            return "\u6ca1\u6709\u53c2\u6570\u6570\u636e";
        }
        List detailList = this.signManageDetailService.getRecordDetailListByRecordId(searchModel.getId());
        if (CollectionUtils.isNotEmpty((Collection)detailList) && (b = detailList.parallelStream().anyMatch(item -> StringUtils.isBlank((CharSequence)item.getCredentialFileId())))) {
            return "\u4f50\u8bc1\u6750\u6599\u4e3a\u5fc5\u586b\u9879\u672a\u4e0a\u4f20";
        }
        return "\u6210\u529f";
    }

    @Transactional
    public Long setTermination(WarnSignManage signManage, Long loginStaffId, Company currentCompany) {
        if (signManage == null || signManage.getId() == null) {
            throw new ServiceException("\u53c2\u6570\u9519\u8bef");
        }
        WarnSignManage record = (WarnSignManage)this.getById(signManage.getId());
        if (record == null) {
            throw new ServiceException("\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        if (!record.getReportState().equals(3)) {
            throw new ServiceException("\u53ea\u6709\u9000\u56de\u7684\u6570\u636e\u624d\u80fd\u7ec8\u6b62");
        }
        record.setReportState(Integer.valueOf(6));
        this.updateByPrimaryKey(record, loginStaffId);
        KeyFactory keyFactory = this.keyFactoryService.getByBusinessId(record.getId());
        keyFactory.setStatus(KeyFactoryStatusEnum.CLOSED.getCode());
        this.keyFactoryService.updateByPrimaryKey((Object)keyFactory, loginStaffId);
        KeyFactoryApprovalHistory history = new KeyFactoryApprovalHistory();
        history.setCid(record.getCid());
        history.setOperatorCompanyName(currentCompany.getName());
        history.setOperator(currentCompany.getName());
        history.setBusinessId(record.getId());
        history.setUpdateBy(loginStaffId);
        history.setCreateBy(loginStaffId);
        history.setType(KeyFactoryTypeEnum.WARNING_SIGNS.getCode());
        history.setStatus(HistoryStatusEnum.CLOSED.getCode());
        this.historyService.addRecord(Collections.singletonList(history));
        return keyFactory.getId();
    }

    public List<WarnSignManage> selectLatestData(List<Long> cids) {
        if (CollectionUtils.isEmpty(cids)) {
            return Collections.emptyList();
        }
        return ((WarnSignManageMapper)this.dao).selectLatestData(cids);
    }
}

