/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.wmbase;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.datacentre.provider.apps.wm.IWmRecommendpicService;
import cn.smarthse.modules.health.dao.base.wmbase.WarnSignManageDetailMapper;
import cn.smarthse.modules.health.entity.base.wmbase.WarnSignManageDetail;
import cn.smarthse.modules.health.service.base.wmbase.IWarnSignManageDetailService;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class WarnSignManageDetailServiceImpl
extends BaseServiceImpl<WarnSignManageDetailMapper, WarnSignManageDetail>
implements IWarnSignManageDetailService {
    @DubboReference(version="1.0.0")
    IWmRecommendpicService wmRecommendpicService;
    @Autowired
    private RedisClient redisClient;

    @Transactional(readOnly=false)
    public WarnSignManageDetail addOrUpdate(WarnSignManageDetail signManageDetail, Long loginStaffId) {
        WarnSignManageDetail detail;
        if (signManageDetail.getId() == null) {
            signManageDetail.setIsCheckGenerate(Boolean.valueOf(false));
            signManageDetail.setCheckId(null);
            if (StringUtils.isNotBlank((CharSequence)signManageDetail.getWorkshop())) {
                signManageDetail.setWorkshop(signManageDetail.getWorkshop().trim().replaceAll(" ", "_").replaceAll("[\t\n\r]", ""));
            }
            if (StringUtils.isNotBlank((CharSequence)signManageDetail.getCheckPoint())) {
                signManageDetail.setCheckPoint(signManageDetail.getCheckPoint().trim().replaceAll(" ", "_").replaceAll("[\t\n\r]", ""));
            }
            detail = this.add(signManageDetail, loginStaffId, null);
        } else {
            signManageDetail.setUpdateDate(new Date());
            signManageDetail.setUpdateBy(loginStaffId);
            if (StringUtils.isNotBlank((CharSequence)signManageDetail.getWorkshop())) {
                signManageDetail.setWorkshop(signManageDetail.getWorkshop().trim().replaceAll(" ", "_").replaceAll("[\t\n\r]", ""));
            }
            if (StringUtils.isNotBlank((CharSequence)signManageDetail.getCheckPoint())) {
                signManageDetail.setCheckPoint(signManageDetail.getCheckPoint().trim().replaceAll(" ", "_").replaceAll("[\t\n\r]", ""));
            }
            ((WarnSignManageDetailMapper)this.dao).updateByPrimaryKeySelective(signManageDetail);
            detail = signManageDetail;
        }
        return detail;
    }

    public List<WarnSignManageDetail> getRecordDetailListByRecordId(Long id) {
        Example example = new Example(WarnSignManageDetail.class);
        example.createCriteria().andEqualTo("signManageId", (Object)id).andEqualTo("isValid", (Object)Global.TRUE);
        return this.getListByExample(example);
    }

    public List<WarnSignManageDetail> getSignManageDetailListBySearchModel(WarnSignManageDetail searchModel) {
        List<WarnSignManageDetail> list = ((WarnSignManageDetailMapper)this.dao).getSignManageDetailListBySearchModel(searchModel);
        for (WarnSignManageDetail detail : list) {
            String[] split;
            if (StringUtils.isNotBlank((CharSequence)detail.getCheckPoint())) {
                detail.setCheckPoint(detail.getCheckPoint().trim().replaceAll(" ", "_").replaceAll("[\t\n\r]", ""));
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getWorkshop())) {
                detail.setWorkshop(detail.getWorkshop().trim().replaceAll(" ", "_").replaceAll("[\t\n\r]", ""));
            }
            if (!StringUtils.isNotBlank((CharSequence)detail.getSignTypeNames())) continue;
            HashMap<String, String> nameAndPathMap = new HashMap<String, String>();
            for (String s : split = detail.getSignTypeNames().split(",")) {
                String path = this.wmRecommendpicService.getImgPathByNameFromCache(s);
                if (!StringUtils.isNotBlank((CharSequence)path)) continue;
                nameAndPathMap.put(s, path);
            }
            detail.setNameAndPathMap(nameAndPathMap);
        }
        return list;
    }

    public PageInfo<WarnSignManageDetail> getPageSignManageDetailListBySearchModel(JqGridParam jqGridParam, WarnSignManageDetail searchModel) {
        PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows());
        List<WarnSignManageDetail> list = this.getSignManageDetailListBySearchModel(searchModel);
        return new PageInfo(list);
    }

    @Transactional(readOnly=false)
    public Integer deleteBySignManageIds(List<Long> signManageIds, Long loginStaffId) {
        WarnSignManageDetail record = new WarnSignManageDetail();
        record.setUpdateDate(new Date());
        record.setUpdateBy(loginStaffId);
        record.setIsValid(Boolean.valueOf(false));
        Example e = new Example(WarnSignManageDetail.class);
        e.createCriteria().andIn("signManageId", signManageIds);
        int i = ((WarnSignManageDetailMapper)this.dao).updateByExampleSelective(record, e);
        return i;
    }

    @Transactional(readOnly=false)
    public Integer deleteBySignManageIds(List<Long> equipIssueRecordIds) {
        Example e = new Example(WarnSignManageDetail.class);
        e.createCriteria().andIn("signManageId", equipIssueRecordIds);
        return ((WarnSignManageDetailMapper)this.dao).deleteByExample(e);
    }
}

