/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.staff;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.dao.base.staff.WorkNatureInfoMapper;
import cn.smarthse.modules.health.entity.base.staff.WorkNatureInfo;
import cn.smarthse.modules.health.enums.staff.WorkNatureEnum;
import cn.smarthse.modules.health.service.base.staff.IWorkNatureInfoService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class WorkNatureInfoServiceImpl
extends BaseServiceImpl<WorkNatureInfoMapper, WorkNatureInfo>
implements IWorkNatureInfoService {
    @Autowired
    private WorkNatureInfoMapper WorkNatureInfoMapper;

    @Transactional(readOnly=false)
    public void addDefaultInfoByStaffId(Long staffId, Long cid) {
        for (WorkNatureEnum nature : WorkNatureEnum.values()) {
            WorkNatureInfo info = new WorkNatureInfo();
            info.setCid(cid);
            info.setStaffId(staffId);
            info.setIsDefault(Boolean.valueOf(true));
            info.setNature(Byte.valueOf(nature.getValue()));
            info.setNatureName(nature.getName());
            this.add(info);
        }
    }

    public PageInfo<WorkNatureInfo> getWorkNatureInfoByStaffId(JqGridParam param, Long staffId) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        Example example = new Example(WorkNatureInfo.class);
        example.createCriteria().andEqualTo("staffId", (Object)staffId).andEqualTo("isValid", (Object)true);
        List list = this.WorkNatureInfoMapper.selectByExample(example);
        return new PageInfo(list);
    }

    @Transactional(readOnly=false)
    public Boolean haveWorkNatureDataByStaffId(Long staffId, Long cid) {
        Example example = new Example(WorkNatureInfo.class);
        example.createCriteria().andEqualTo("staffId", (Object)staffId).andEqualTo("isValid", (Object)true);
        List list = this.WorkNatureInfoMapper.selectByExample(example);
        if (list != null && list.size() > 0) {
            return true;
        }
        this.addDefaultInfoByStaffId(staffId, cid);
        return false;
    }

    public List<WorkNatureInfo> getWorkInfoListByCid(Long cid, Byte type) {
        if (cid == null) {
            return null;
        }
        List<WorkNatureInfo> list = this.WorkNatureInfoMapper.selectByCidAndType(cid, type);
        return list;
    }
}

