/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.staff;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IHarmFactorService;
import cn.smarthse.modules.health.dao.base.staff.SuperviseStaffHarmsMapper;
import cn.smarthse.modules.health.dao.base.staff.SuperviseStaffListMapper;
import cn.smarthse.modules.health.entity.base.staff.SuperviseStaffHarms;
import cn.smarthse.modules.health.entity.base.staff.SuperviseStaffList;
import cn.smarthse.modules.health.enums.check.ExamResultEnum;
import cn.smarthse.modules.health.enums.staff.StaffGenderEnum;
import cn.smarthse.modules.health.service.base.staff.ISuperviseStaffListSerivce;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import tk.mybatis.mapper.entity.Example;

@DubboService
public class SuperviseStaffListServiceImpl
extends BaseServiceImpl<SuperviseStaffListMapper, SuperviseStaffList>
implements ISuperviseStaffListSerivce {
    @Autowired
    SuperviseStaffHarmsMapper superviseStaffHarmsMapper;
    @Autowired
    private DataSourceTransactionManager txManager;
    @DubboReference(version="1.0.0")
    IHarmFactorService harmFactorService;
    private int total = 0;

    private void clearAll() {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.txManager.getTransaction((TransactionDefinition)def);
        try {
            this.clearList();
            this.clearHarms();
            this.txManager.commit(status);
        }
        catch (Exception e) {
            this.txManager.rollback(status);
            e.printStackTrace();
            this.logger.error("\u3010\u76d1\u7ba1\u4eba\u5458\u5217\u8868\u6e05\u9664\u65e7\u6570\u636e\u51fa\u9519\u3011", (Throwable)e);
        }
        this.logger.info("\u3010\u76d1\u7ba1\u4eba\u5458\u5217\u8868---\u6e05\u9664\u65e7\u6570\u636e\u5b8c\u6210\u3011");
    }

    private void clearList() {
        Example example = new Example(SuperviseStaffList.class);
        ((SuperviseStaffListMapper)this.dao).deleteByExample(example);
    }

    private void clearHarms() {
        Example example = new Example(SuperviseStaffHarms.class);
        this.superviseStaffHarmsMapper.deleteByExample(example);
    }

    @Transactional
    public void refreshSuperviseStaffs() {
        this.logger.info("\u3010\u76d1\u7ba1\u4eba\u5458\u5217\u8868---\u5f00\u59cb\u3011");
        this.total = 0;
        this.clearAll();
        this.logger.info("\u3010\u76d1\u7ba1\u4eba\u5458\u5217\u8868---\u6e05\u9664\u65e7\u6570\u636e\u5b8c\u6210\u3011");
        Integer count = ((SuperviseStaffListMapper)this.dao).countSuperviseStaff();
        this.logger.info("\u3010\u76d1\u7ba1\u4eba\u5458\u5217\u8868---\u83b7\u53d6\u6570\u636e\u4e2d\u5fc3\u4f01\u4e1a\u5b8c\u6210\u3011");
        if (count == null || count == 0) {
            return;
        }
        int pages = (int)Math.ceil((double)count.intValue() / 1000.0);
        this.logger.info("\u3010\u76d1\u7ba1\u4eba\u5458\u5217\u8868-\u83b7\u53d6\u4f01\u4e1a\u7edf\u8ba1\u4fe1\u606f\u5b8c\u6210\u3011");
        this.logger.info("\u3010\u76d1\u7ba1\u4eba\u5458\u5217\u8868---\u5f00\u59cb" + count + "\u6761\u3011");
        for (int i = 1; i <= pages; ++i) {
            this.commitOneBatch(i, 1000);
        }
        this.logger.info("\u3010\u76d1\u7ba1\u4eba\u5458\u5217\u8868---\u5b8c\u6210\u3011\u5408\u8ba1\u5bfc\u5165:" + this.total);
    }

    private void commitOneBatch(int page, int pageSize) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.txManager.getTransaction((TransactionDefinition)def);
        try {
            Date now = new Date();
            int pageStart = (page - 1) * pageSize;
            List<SuperviseStaffList> staffs = ((SuperviseStaffListMapper)this.dao).listSuperviseStaff(pageStart, pageSize);
            ArrayList<SuperviseStaffHarms> harms = new ArrayList<SuperviseStaffHarms>();
            for (SuperviseStaffList c : staffs) {
                c.setStaffName(SpringEncryptUtils.decrypt((String)c.getStaffName()));
                c.setIdCard(SpringEncryptUtils.decrypt((String)c.getIdCard()));
                c.setCreateDate(now);
                c.setGenderName(StaffGenderEnum.getName((Integer)c.getGender()));
                c.setLastExamResultName(ExamResultEnum.getName((String)c.getLastExamResult()));
                if (c.getDiseaserId() != null) {
                    c.setIsDiseasesPatient(Boolean.valueOf(true));
                } else {
                    c.setIsDiseasesPatient(Boolean.valueOf(false));
                }
                if (StringUtils.isNotEmpty((String)c.getHarmIds())) {
                    c.setHarmNames(this.harmFactorService.getHarmNames(c.getHarmIds()));
                }
                List<SuperviseStaffHarms> staffHarms = this.getHarms(c);
                harms.addAll(staffHarms);
            }
            ((SuperviseStaffListMapper)this.dao).insertBatch(staffs);
            this.total += staffs.size();
            if (!harms.isEmpty()) {
                this.superviseStaffHarmsMapper.insertBatch(harms);
            }
            this.txManager.commit(status);
        }
        catch (Exception e) {
            this.txManager.rollback(status);
            e.printStackTrace();
            this.logger.error("\u3010\u76d1\u7ba1\u4eba\u5458\u5217\u8868\u7edf\u8ba1\u51fa\u9519\u7b2c" + page + "\u9875\u3011", (Throwable)e);
        }
    }

    private List<SuperviseStaffHarms> getHarms(SuperviseStaffList c) {
        ArrayList<SuperviseStaffHarms> harms = new ArrayList<SuperviseStaffHarms>();
        List harmIds = StringUtils.parseToLongList((String)c.getHarmIds());
        if (harmIds == null || harmIds.isEmpty()) {
            return harms;
        }
        for (Long harmId : harmIds) {
            SuperviseStaffHarms harm = new SuperviseStaffHarms();
            harm.setHarmId(harmId);
            harm.setStaffId(c.getStaffId());
            harms.add(harm);
        }
        return harms;
    }
}

