/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.staff;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IHarmFactorService;
import cn.smarthse.modules.health.dao.base.staff.StaffWorkRoleMapper;
import cn.smarthse.modules.health.entity.base.company.CompanyOrganization;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicWork;
import cn.smarthse.modules.health.entity.base.staff.StaffFieldChangeLog;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffWorkRole;
import cn.smarthse.modules.health.entity.base.staff.importstaff.BatchStafffWorkVo;
import cn.smarthse.modules.health.entity.base.staff.vo.ImproveStaffModel;
import cn.smarthse.modules.health.entity.base.workinfo.WorkRoleInfo;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheckDataResult;
import cn.smarthse.modules.health.enums.staff.StaffFieldChangeEnum;
import cn.smarthse.modules.health.enums.staff.StaffWorkChangeStatusRecordEnum;
import cn.smarthse.modules.health.enums.staff.StaffWorkPropertyEnum;
import cn.smarthse.modules.health.enums.staff.StaffWorkStatusEnum;
import cn.smarthse.modules.health.service.base.staff.IStaffBasicInfoService;
import cn.smarthse.modules.health.service.base.staff.IStaffBasicWorkService;
import cn.smarthse.modules.health.service.base.staff.IStaffFieldChangeLogService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.base.staff.IStaffWorkRoleService;
import cn.smarthse.modules.health.service.base.workinfo.IWorkRoleInfoService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckDataResultService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class StaffWorkRoleServiceImpl
extends BaseServiceImpl<StaffWorkRoleMapper, StaffWorkRole>
implements IStaffWorkRoleService {
    @Autowired
    StaffWorkRoleMapper staffWorkRoleMapper;
    @Autowired
    IWorkRoleInfoService workRoleInfoService;
    @Autowired
    IStaffInfoService staffInfoService;
    @Autowired
    IStaffBasicWorkService staffBasicWorkService;
    @Autowired
    private IStaffBasicInfoService staffBasicInfoService;
    @DubboReference(version="1.0.0")
    private IHarmFactorService harmFactorService;
    @Autowired
    IPhcPhysicalCheckDataResultService phcPhysicalCheckDataResultService;
    @Autowired
    private IStaffFieldChangeLogService staffFieldChangeLogService;

    public StaffWorkRole getCurrentStaffWorkRoleByStaffId(Long staffId) {
        Example e = new Example(StaffWorkRole.class);
        Example.Criteria c = e.createCriteria();
        c.andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("staffId", (Object)staffId).andEqualTo("isHistory", (Object)Global.FALSE).andEqualTo("isThirdParty", (Object)Global.FALSE).andEqualTo("workProperty", (Object)StaffWorkPropertyEnum.MAJOR.getValue());
        List list = this.staffWorkRoleMapper.selectByExample(e);
        StaffWorkRole s = null;
        if (list != null && list.size() > 0) {
            s = (StaffWorkRole)list.get(0);
        }
        return s;
    }

    public List<StaffWorkRole> getLocalStaffWorkRolesByStaffId(Long staffId) {
        Example e = new Example(StaffWorkRole.class);
        Example.Criteria c = e.createCriteria();
        c.andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("staffId", (Object)staffId).andEqualTo("isThirdParty", (Object)Global.FALSE).andNotEqualTo("workProperty", (Object)StaffWorkPropertyEnum.PLURALITY.getValue()).andEqualTo("isHistory", (Object)Global.TRUE);
        e.orderBy("workProperty");
        List list = this.staffWorkRoleMapper.selectByExample(e);
        if (list != null) {
            for (StaffWorkRole s : list) {
                if (s.getWorkRoleId() == null) continue;
                WorkRoleInfo wri = (WorkRoleInfo)this.workRoleInfoService.getById(s.getWorkRoleId());
                if (wri != null) {
                    wri.setWorkName(wri.getWorkName() + "/" + wri.getOrgName());
                    if (!wri.getIsValid().booleanValue()) {
                        wri.setWorkName("(\u5df2\u5220\u9664)" + wri.getWorkName());
                    }
                }
                s.setWorkRoleInfo(wri);
            }
        }
        return list;
    }

    public List<StaffWorkRole> getLocalStaffWorkRolesByStaffIdOrderByBeginTime(Long staffId) {
        Example e = new Example(StaffWorkRole.class);
        Example.Criteria c = e.createCriteria();
        c.andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("staffId", (Object)staffId).andEqualTo("isThirdParty", (Object)Global.FALSE).andNotEqualTo("workProperty", (Object)StaffWorkPropertyEnum.PLURALITY.getValue());
        Boolean isHave = this.isHaveCurrentRoleInHistory(staffId);
        if (isHave.booleanValue()) {
            c.andEqualTo("isHistory", (Object)Global.TRUE);
        }
        e.orderBy("beginTime").asc();
        List list = this.staffWorkRoleMapper.selectByExample(e);
        if (list != null) {
            for (StaffWorkRole s : list) {
                if (s.getWorkRoleId() == null) continue;
                WorkRoleInfo wri = (WorkRoleInfo)this.workRoleInfoService.getById(s.getWorkRoleId());
                if (wri != null) {
                    wri.setWorkName(wri.getWorkName() + "/" + wri.getOrgName());
                    if (!wri.getIsValid().booleanValue()) {
                        wri.setWorkName("(\u5df2\u5220\u9664)" + wri.getWorkName());
                    }
                }
                s.setWorkRoleInfo(wri);
            }
        }
        return list;
    }

    public List<StaffWorkRole> getOutsideStaffWorkRolesByStaffId(Long staffId) {
        Example e = new Example(StaffWorkRole.class);
        Example.Criteria c = e.createCriteria();
        c.andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("staffId", (Object)staffId).andEqualTo("isThirdParty", (Object)Global.TRUE);
        List list = this.staffWorkRoleMapper.selectByExample(e);
        return list;
    }

    public StaffWorkRole getStaffWorkRoleById(Long staffWorkRoleId) {
        StaffWorkRole staffWorkRole = (StaffWorkRole)this.getById(staffWorkRoleId);
        if (staffWorkRole != null && staffWorkRole.getWorkRoleId() != null) {
            staffWorkRole.setWorkRoleInfo((WorkRoleInfo)this.workRoleInfoService.getById(staffWorkRole.getWorkRoleId()));
        }
        return staffWorkRole;
    }

    public List<StaffWorkRole> getPluralityStaffWorkRolesByStaffId(Long staffId) {
        Example e = new Example(StaffWorkRole.class);
        Example.Criteria c = e.createCriteria();
        c.andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("staffId", (Object)staffId).andEqualTo("isHistory", (Object)Global.FALSE).andEqualTo("isThirdParty", (Object)Global.FALSE).andEqualTo("workProperty", (Object)StaffWorkPropertyEnum.PLURALITY.getValue());
        List list = this.staffWorkRoleMapper.selectByExample(e);
        return list;
    }

    public List<StaffWorkRole> getAllPluralityStaffWorkRolesByStaffId(Long staffId) {
        Example e = new Example(StaffWorkRole.class);
        Example.Criteria c = e.createCriteria();
        c.andEqualTo("staffId", (Object)staffId).andEqualTo("isHistory", (Object)Global.FALSE).andEqualTo("isThirdParty", (Object)Global.FALSE).andEqualTo("workProperty", (Object)StaffWorkPropertyEnum.PLURALITY.getValue());
        List list = this.staffWorkRoleMapper.selectByExample(e);
        return list;
    }

    public PageInfo<StaffWorkRole> getLocalStaffWorkRolesDataByStaffId(JqGridParam jparam, Long staffInfoId) {
        Example e = new Example(StaffWorkRole.class);
        Example.Criteria c = e.createCriteria();
        c.andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("staffId", (Object)staffInfoId).andEqualTo("isThirdParty", (Object)Global.FALSE).andNotEqualTo("workProperty", (Object)StaffWorkPropertyEnum.PLURALITY.getValue()).andEqualTo("isHistory", (Object)Global.TRUE);
        e.orderBy("beginTime").desc();
        PageHelper.startPage((int)jparam.getPage(), (int)jparam.getRows());
        List list = this.staffWorkRoleMapper.selectByExample(e);
        if (list != null) {
            for (StaffWorkRole s : list) {
                if (s.getWorkRoleId() == null) continue;
                WorkRoleInfo wri = (WorkRoleInfo)this.workRoleInfoService.getById(s.getWorkRoleId());
                if (wri != null) {
                    wri.setWorkName(wri.getWorkName() + "/" + wri.getOrgName());
                    if (!wri.getIsValid().booleanValue()) {
                        wri.setWorkName("(\u5df2\u5220\u9664)" + wri.getWorkName());
                    }
                }
                s.setWorkRoleInfo(wri);
            }
        }
        return new PageInfo(list);
    }

    public List<StaffWorkRole> getLocalStaffWorkRolesDataByStaffId(Long staffInfoId) {
        Example e = new Example(StaffWorkRole.class);
        Example.Criteria c = e.createCriteria();
        c.andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("staffId", (Object)staffInfoId).andEqualTo("isThirdParty", (Object)Global.FALSE).andNotEqualTo("workProperty", (Object)StaffWorkPropertyEnum.PLURALITY.getValue()).andEqualTo("isHistory", (Object)Global.TRUE);
        e.orderBy("workProperty");
        List list = this.staffWorkRoleMapper.selectByExample(e);
        return list;
    }

    public PageInfo<StaffWorkRole> getOutsideStaffWorkRolesDataByStaffId(JqGridParam jparam, Long staffInfoId) {
        Example e = new Example(StaffWorkRole.class);
        Example.Criteria c = e.createCriteria();
        c.andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("staffId", (Object)staffInfoId).andEqualTo("isThirdParty", (Object)Global.TRUE);
        PageHelper.startPage((int)jparam.getPage(), (int)jparam.getRows());
        List list = this.staffWorkRoleMapper.selectByExample(e);
        return new PageInfo(list);
    }

    public List<StaffWorkRole> getStaffWorkRoleByCidAndWorkIdAndNoHistory(Long workId, Long cid) {
        Example e = new Example(StaffWorkRole.class);
        Example.Criteria c = e.createCriteria();
        c.andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("isHistory", (Object)Global.FALSE).andEqualTo("isThirdParty", (Object)Global.FALSE).andEqualTo("workRoleId", (Object)workId).andEqualTo("cid", (Object)cid).andNotEqualTo("workProperty", (Object)StaffWorkPropertyEnum.WORKED.getValue());
        return this.staffWorkRoleMapper.selectByExample(e);
    }

    public Boolean getIsFirstEditWorkBy(Long staffInfoId, Long loginStaffId, Long cid) {
        if (staffInfoId == null) {
            return true;
        }
        Example e = new Example(StaffWorkRole.class);
        Example.Criteria c = e.createCriteria();
        c.andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("staffId", (Object)staffInfoId).andEqualTo("isThirdParty", (Object)Global.FALSE).andNotEqualTo("workProperty", (Object)StaffWorkPropertyEnum.PLURALITY.getValue());
        List list = this.staffWorkRoleMapper.selectByExample(e);
        if (list.size() > 0 && list.size() == 1 && ((StaffWorkRole)list.get(0)).getWorkRoleId() == null) {
            return true;
        }
        return false;
    }

    public List<StaffWorkRole> getStaffWorkRoleByStaffIdsAndStartDateAndEndDateAndCid(String staffIds, Date beginWorkTime, Date endWorkTime, Long cid) {
        List<StaffWorkRole> roles = this.staffWorkRoleMapper.getStaffWorkRoleByStaffIdsAndStartDateAndEndDateAndCidHis(staffIds, beginWorkTime, endWorkTime, cid);
        return roles;
    }

    @Transactional(readOnly=false)
    public StaffWorkRole addStaffWorkRoleSubmit(StaffWorkRole staffWorkRole, Long loginStaffId, Long cid) {
        StaffWorkRole addData = this.add(staffWorkRole, loginStaffId, cid);
        return addData;
    }

    @Transactional(readOnly=false)
    public void editStaffWorkRoleSubmit(StaffWorkRole staffWorkRole, Long loginStaffId, Long cid) {
        this.updateByPrimaryKey(staffWorkRole, loginStaffId);
    }

    public StaffWorkRole getCurrentStaffWorkRoleIncludeNoIsValidByStaffId(Long staffId) {
        Example e = new Example(StaffWorkRole.class);
        Example.Criteria c = e.createCriteria();
        c.andEqualTo("staffId", (Object)staffId).andEqualTo("isHistory", (Object)Global.FALSE).andEqualTo("isThirdParty", (Object)Global.FALSE).andEqualTo("workProperty", (Object)StaffWorkPropertyEnum.MAJOR.getValue());
        List list = this.staffWorkRoleMapper.selectByExample(e);
        StaffWorkRole s = null;
        if (list != null && list.size() > 0 && (s = (StaffWorkRole)list.get(0)).getWorkRoleId() != null) {
            s.setWorkRoleInfo((WorkRoleInfo)this.workRoleInfoService.getById(s.getWorkRoleId()));
        }
        return s;
    }

    public Integer getCurrentOnWorkStaffCountByWordIds(List<Long> workIds, Long cid) {
        return this.staffWorkRoleMapper.getCurrentOnWorkStaffCountByWordIds(workIds, cid);
    }

    @Transactional(readOnly=false)
    public void deleteStaffWorkRoleByStaffWorkRoleId(Long staffWorkRoleId, Long loginStaffId, Long cid) {
        StaffWorkRole staffWorkRole = new StaffWorkRole();
        staffWorkRole.setId(staffWorkRoleId);
        staffWorkRole.setIsValid(Global.FALSE);
        this.update(staffWorkRole, loginStaffId);
    }

    public List<StaffWorkRole> geCurrenttStaffWorkRoleByCidAndWorkIdAndNoHistory(Long workId, Long cid) {
        Example e = new Example(StaffWorkRole.class);
        Example.Criteria c = e.createCriteria();
        c.andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("isHistory", (Object)Global.FALSE).andEqualTo("isThirdParty", (Object)Global.FALSE).andEqualTo("workRoleId", (Object)workId).andEqualTo("cid", (Object)cid).andEqualTo("workProperty", (Object)StaffWorkPropertyEnum.MAJOR.getValue());
        return this.staffWorkRoleMapper.selectByExample(e);
    }

    public StaffWorkRole getCurrentStaffWorkRoleHistoryCompanyIncludeNoIsValidByStaffId(Long staffId) {
        Example e = new Example(StaffWorkRole.class);
        Example.Criteria c = e.createCriteria();
        c.andEqualTo("staffId", (Object)staffId).andEqualTo("isHistory", (Object)Global.FALSE).andEqualTo("isThirdParty", (Object)Global.FALSE).andEqualTo("workProperty", (Object)StaffWorkPropertyEnum.MAJOR.getValue());
        List list = this.staffWorkRoleMapper.selectByExample(e);
        StaffWorkRole s = null;
        if (list != null && list.size() > 0 && (s = (StaffWorkRole)list.get(0)).getWorkRoleId() != null) {
            s.setWorkRoleInfo((WorkRoleInfo)this.workRoleInfoService.getById(s.getWorkRoleId()));
            if (s.getStatus() != null && s.getStatus() == 2) {
                s.setLeaveTime(this.staffWorkRoleMapper.getMaxHistoryLeaveTimeByWorkIdAndStaffId(s.getStaffId(), s.getWorkRoleId()));
            }
        }
        return s;
    }

    public StaffWorkRole getCurrentStaffWorkRoleHistory(Long staffId, Long workRoleId) {
        Example e = new Example(StaffWorkRole.class);
        Example.Criteria c = e.createCriteria();
        c.andEqualTo("staffId", (Object)staffId).andEqualTo("isHistory", (Object)Global.TRUE).andEqualTo("workRoleId", (Object)workRoleId);
        List list = this.staffWorkRoleMapper.selectByExample(e);
        StaffWorkRole s = null;
        if (list != null && list.size() > 0) {
            s = (StaffWorkRole)list.get(0);
        }
        return s;
    }

    public List<Long> getWorkIdsByStaffIds(List<Long> staffIds) {
        if (staffIds == null || staffIds.size() == 0) {
            return new ArrayList<Long>();
        }
        return ((StaffWorkRoleMapper)this.dao).getWorkIdsByStaffIds(staffIds);
    }

    @Transactional(readOnly=false)
    public void batchStaffWorkSubmit(Integer type, BatchStafffWorkVo vo, String isSharingSystem) {
        block15: {
            block16: {
                block14: {
                    if (vo == null || vo.getStaffIds() == null || vo.getStaffIds().length == 0 || type == 1 && vo.getWorkId() == null) {
                        return;
                    }
                    if (type != 1) break block14;
                    WorkRoleInfo workRoleInfo = (WorkRoleInfo)this.workRoleInfoService.getById(vo.getWorkId());
                    for (String staffId : vo.getStaffIds()) {
                        StaffWorkChangeStatusRecordEnum record;
                        List<StaffWorkRole> localList = this.getLocalStaffWorkRolesDataByStaffId(Long.valueOf(staffId));
                        StaffWorkRole oldCurrentStaffWorkRole = this.getCurrentStaffWorkRoleByStaffId(Long.valueOf(staffId));
                        for (StaffWorkRole swr : localList) {
                            if (swr == null || swr.getWorkRoleId() == null || !swr.getWorkRoleId().equals(oldCurrentStaffWorkRole.getWorkRoleId()) || swr.getBeginTime() == null || !swr.getBeginTime().equals(oldCurrentStaffWorkRole.getBeginTime())) continue;
                            this.delete(swr);
                        }
                        StaffWorkRole newStaffWorkRole = new StaffWorkRole();
                        newStaffWorkRole.setBeginTime(vo.getTranferTime());
                        newStaffWorkRole.setFirstBeginTime(oldCurrentStaffWorkRole.getFirstBeginTime());
                        newStaffWorkRole.setCid(vo.getCid());
                        newStaffWorkRole.setStaffId(Long.valueOf(staffId));
                        newStaffWorkRole.setIsThirdParty(Global.FALSE);
                        newStaffWorkRole.setWorkRoleId(vo.getWorkId());
                        newStaffWorkRole.setWorkProperty(StaffWorkPropertyEnum.MAJOR.getValue());
                        newStaffWorkRole.setIsHistory(Global.FALSE);
                        newStaffWorkRole.setStatus(StaffWorkStatusEnum.ONWORKING.getValue());
                        newStaffWorkRole.setCreateBy(vo.getLoginBy());
                        this.add(newStaffWorkRole, vo.getLoginBy(), vo.getCid());
                        StaffWorkRole curHistoryStaffWorkRole = new StaffWorkRole();
                        curHistoryStaffWorkRole.setCid(vo.getCid());
                        curHistoryStaffWorkRole.setBeginTime(newStaffWorkRole.getBeginTime());
                        newStaffWorkRole.setFirstBeginTime(oldCurrentStaffWorkRole.getFirstBeginTime());
                        curHistoryStaffWorkRole.setIsHistory(Boolean.valueOf(true));
                        curHistoryStaffWorkRole.setIsThirdParty(newStaffWorkRole.getIsThirdParty());
                        curHistoryStaffWorkRole.setLeaveTime(newStaffWorkRole.getLeaveTime());
                        curHistoryStaffWorkRole.setStaffId(newStaffWorkRole.getStaffId());
                        curHistoryStaffWorkRole.setStatus(newStaffWorkRole.getStatus());
                        curHistoryStaffWorkRole.setWorkProperty(StaffWorkPropertyEnum.WORKED.getValue());
                        curHistoryStaffWorkRole.setWorkRoleId(newStaffWorkRole.getWorkRoleId());
                        this.add(curHistoryStaffWorkRole, vo.getLoginBy(), vo.getCid());
                        oldCurrentStaffWorkRole.setWorkProperty(StaffWorkPropertyEnum.WORKED.getValue());
                        oldCurrentStaffWorkRole.setIsHistory(Global.TRUE);
                        if (!StaffWorkStatusEnum.ONWORKING.getValue().equals(oldCurrentStaffWorkRole.getStatus()) && (record = StaffWorkChangeStatusRecordEnum.getThisEnumByFlag((String)("" + oldCurrentStaffWorkRole.getStatus() + StaffWorkStatusEnum.ONWORKING.getValue()))) != null) {
                            StaffInfo newStaff = new StaffInfo();
                            newStaff.setId(Long.valueOf(staffId));
                            newStaff.setWorkChangeStatusRecord(record.getValue());
                            this.staffInfoService.update((Object)newStaff, vo.getLoginBy());
                        }
                        oldCurrentStaffWorkRole.setStatus(StaffWorkStatusEnum.TRANSFER.getValue());
                        oldCurrentStaffWorkRole.setLeaveTime(newStaffWorkRole.getBeginTime());
                        this.update(oldCurrentStaffWorkRole, vo.getLoginBy());
                        if (!"true".equalsIgnoreCase(isSharingSystem)) continue;
                        StaffBasicWork staffBasicWork = new StaffBasicWork();
                        staffBasicWork.setOrgId(workRoleInfo.getOrgId());
                        StaffBasicWork dbBasicWork = this.staffBasicWorkService.getStaffBasicWorkByStaffId(Long.valueOf(staffId));
                        if (dbBasicWork != null) {
                            staffBasicWork.setId(dbBasicWork.getId());
                            this.staffBasicWorkService.update((Object)staffBasicWork);
                        }
                        StaffInfo staffInfo = new StaffInfo();
                        staffInfo.setOrgId(workRoleInfo.getOrgId());
                        staffInfo.setId(Long.valueOf(staffId));
                        this.staffInfoService.update((Object)staffInfo);
                    }
                    break block15;
                }
                if (type != 2) break block16;
                for (String staffId : vo.getStaffIds()) {
                    StaffWorkChangeStatusRecordEnum record;
                    StaffWorkRole oldCurrentStaffWorkRole = this.getCurrentStaffWorkRoleByStaffId(Long.valueOf(staffId));
                    if (!StaffWorkStatusEnum.NOWORKED.getValue().equals(oldCurrentStaffWorkRole.getStatus()) && (record = StaffWorkChangeStatusRecordEnum.getThisEnumByFlag((String)("" + oldCurrentStaffWorkRole.getStatus() + StaffWorkStatusEnum.NOWORKED.getValue()))) != null) {
                        StaffInfo newStaff = new StaffInfo();
                        newStaff.setId(Long.valueOf(staffId));
                        newStaff.setWorkChangeStatusRecord(record.getValue());
                        this.staffInfoService.update((Object)newStaff, vo.getLoginBy());
                    }
                    this.addWorkStatusLog(oldCurrentStaffWorkRole.getStaffId(), vo.getCid(), oldCurrentStaffWorkRole.getStatus(), StaffWorkStatusEnum.NOWORKED.getValue(), vo.getLoginBy());
                    List<StaffWorkRole> localList = this.getLocalStaffWorkRolesDataByStaffId(Long.valueOf(staffId));
                    for (StaffWorkRole swr : localList) {
                        if (swr.getStatus() == null || swr.getStatus() != oldCurrentStaffWorkRole.getStatus()) continue;
                        swr.setLeaveTime(vo.getLeaveTime());
                        swr.setStatus(StaffWorkStatusEnum.NOWORKED.getValue());
                        this.update(swr);
                    }
                    if (oldCurrentStaffWorkRole.getBeginTime() == null) {
                        throw new RuntimeException("\u672c\u5c97\u4f4d\u4e0a\u5c97\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                    }
                    if (oldCurrentStaffWorkRole.getBeginTime().getTime() >= vo.getLeaveTime().getTime()) {
                        throw new RuntimeException("\u79bb\u804c\u65f6\u95f4\u9700\u665a\u4e8e\u672c\u5c97\u4f4d\u4e0a\u5c97\u65f6\u95f4\u3002");
                    }
                    oldCurrentStaffWorkRole.setLeaveTime(vo.getLeaveTime());
                    oldCurrentStaffWorkRole.setStatus(StaffWorkStatusEnum.NOWORKED.getValue());
                    this.update(oldCurrentStaffWorkRole, vo.getLoginBy());
                }
                break block15;
            }
            if (type != 3) break block15;
            for (String staffId : vo.getStaffIds()) {
                StaffWorkRole CurrentStaffWorkRole;
                WorkRoleInfo info;
                List works;
                StaffBasicWork staffBasicWork = new StaffBasicWork();
                staffBasicWork.setOrgId(vo.getOrgId());
                StaffBasicWork dbBasicWork = this.staffBasicWorkService.getStaffBasicWorkByStaffId(Long.valueOf(staffId));
                if (dbBasicWork != null) {
                    staffBasicWork.setId(dbBasicWork.getId());
                    this.staffBasicWorkService.update((Object)staffBasicWork);
                }
                if ((works = this.workRoleInfoService.getWorkInfoListWorkNameAndOrgId((info = (WorkRoleInfo)this.workRoleInfoService.getById((CurrentStaffWorkRole = this.getCurrentStaffWorkRoleByStaffId(Long.valueOf(staffId))).getWorkRoleId())).getWorkName(), vo.getOrgId(), info.getCid())) != null && works.size() > 0) {
                    CurrentStaffWorkRole.setWorkRoleId(((WorkRoleInfo)works.get(0)).getId());
                } else {
                    WorkRoleInfo newWork = new WorkRoleInfo();
                    newWork.setOrgId(vo.getOrgId());
                    newWork.setWorkName(info.getWorkName());
                    newWork = (WorkRoleInfo)this.workRoleInfoService.add((Object)newWork, Long.valueOf(staffId), info.getCid());
                    CurrentStaffWorkRole.setWorkRoleId(newWork.getId());
                }
                this.update(CurrentStaffWorkRole);
                StaffInfo staffInfo = new StaffInfo();
                staffInfo.setOrgId(vo.getOrgId());
                staffInfo.setId(Long.valueOf(staffId));
                this.staffInfoService.update((Object)staffInfo);
            }
        }
    }

    private void addWorkStatusLog(Long staffId, Long cid, Byte oldWorkStatus, Byte newWorkStatus, Long userId) {
        if (oldWorkStatus != null && newWorkStatus != null && !oldWorkStatus.equals(newWorkStatus)) {
            StaffFieldChangeLog log = new StaffFieldChangeLog();
            log.setStaffId(staffId);
            log.setCid(cid);
            log.setBeforeInfo(StaffWorkStatusEnum.getWorkStatusStr((Byte)oldWorkStatus));
            log.setAfterInfo(StaffWorkStatusEnum.getWorkStatusStr((Byte)newWorkStatus));
            log.setField(StaffFieldChangeEnum.WORK_ROLE_STATUS.getCode());
            this.staffFieldChangeLogService.addChangeLogList(Collections.singletonList(log), userId);
        }
    }

    public StaffWorkRole getStaffWorkRoleHistoryByStaffIdAndTime(Long staffId, Date beginTime, Date endTime) {
        List<StaffWorkRole> list = this.staffWorkRoleMapper.getStaffWorkRoleHistoryByStaffIdAndTime(staffId, beginTime, endTime);
        StaffWorkRole s = null;
        if (list != null && list.size() > 0 && (s = list.get(0)).getWorkRoleId() != null) {
            WorkRoleInfo wri = (WorkRoleInfo)this.workRoleInfoService.getById(s.getWorkRoleId());
            if (wri != null) {
                wri.setWorkName(wri.getWorkName() + "/" + wri.getOrgName());
                if (!wri.getIsValid().booleanValue()) {
                    wri.setWorkName("(\u5df2\u5220\u9664)" + wri.getWorkName());
                }
            }
            s.setWorkRoleInfo(wri);
        }
        return s;
    }

    public PageInfo<StaffWorkRole> getStaffWorkRolesDataByStaffId(JqGridParam jparam, Long staffId) {
        List<Object> list = new ArrayList();
        list = this.staffWorkRoleMapper.selectByStaffIdWithOutCurrent(staffId, jparam.getCid());
        StaffInfo staffInfo = (StaffInfo)this.staffInfoService.getById(staffId);
        StaffBasicInfo basic = (StaffBasicInfo)this.staffBasicInfoService.getById(staffInfo.getStaffBasicId());
        StaffBasicWork work = this.staffBasicWorkService.getStaffBasicWorkByStaffId(staffId);
        if (list != null) {
            for (StaffWorkRole staffWorkRole : list) {
                if (basic != null) {
                    staffWorkRole.setStaffName(basic.getRealName());
                }
                if (work != null) {
                    staffWorkRole.setWorkNo(work.getWorkNo());
                }
                if (staffWorkRole.getWorkRoleId() == null) continue;
                WorkRoleInfo wri = (WorkRoleInfo)this.workRoleInfoService.getById(staffWorkRole.getWorkRoleId());
                if (wri != null) {
                    PhcPhysicalCheckDataResult result = this.phcPhysicalCheckDataResultService.getDataResultByStaffId(staffId, wri.getWorkName());
                    if (result != null && result.getHarmFactor() != null) {
                        String harmNames = this.harmFactorService.getHarmNames(result.getHarmFactor());
                        staffWorkRole.setContactHarm(harmNames);
                    }
                    wri.setWorkName(wri.getWorkName() + "/" + wri.getOrgName());
                    if (!wri.getIsValid().booleanValue()) {
                        wri.setWorkName("(\u5df2\u5220\u9664)" + wri.getWorkName());
                    }
                }
                staffWorkRole.setWorkRoleInfo(wri);
            }
        }
        return new PageInfo(list);
    }

    public Boolean isHaveCurrentRoleInHistory(Long staffId) {
        Example e = new Example(StaffWorkRole.class);
        Example.Criteria c = e.createCriteria();
        c.andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("staffId", (Object)staffId).andEqualTo("isHistory", (Object)Global.FALSE).andEqualTo("workProperty", (Object)StaffWorkPropertyEnum.MAJOR.getValue());
        List list = this.staffWorkRoleMapper.selectByExample(e);
        if (list != null && list.size() > 0) {
            Example e1 = new Example(StaffWorkRole.class);
            Example.Criteria c1 = e1.createCriteria();
            c1.andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("staffId", (Object)staffId).andEqualTo("isHistory", (Object)Global.TRUE).andEqualTo("workRoleId", (Object)((StaffWorkRole)list.get(0)).getWorkRoleId());
            List listHis = this.staffWorkRoleMapper.selectByExample(e1);
            if (listHis != null && listHis.size() > 0) {
                return true;
            }
        }
        return false;
    }

    public Integer getWorkerNumByWorkId(Long workId, Long cid) {
        List<StaffWorkRole> list = this.staffWorkRoleMapper.selectByWorkId(workId, cid);
        if (list != null) {
            return list.size();
        }
        return 0;
    }

    public List<StaffWorkRole> getChooseStaff(Long orgId, Long cid, Long trainId, String staffName, Byte sortBy) {
        List<StaffWorkRole> staffList = ((StaffWorkRoleMapper)this.dao).getChooseStaff(orgId, cid, trainId, SpringEncryptUtils.encrypt((String)staffName), sortBy);
        staffList.forEach(s -> s.setStaffName(SpringEncryptUtils.decrypt((String)s.getStaffName())));
        staffList.forEach(s -> s.setCurrentJobBeginTime(StrUtil.isBlank((CharSequence)s.getCurrentJobBeginTime()) ? "-" : s.getCurrentJobBeginTime()));
        return staffList;
    }

    public Integer getFemaleWorkerNumByWorkId(Long workId, Long cid) {
        List<StaffWorkRole> list = this.staffWorkRoleMapper.getFemaleWorkerNumByWorkId(workId, cid);
        if (list != null) {
            return list.size();
        }
        return 0;
    }

    public Integer getSelfComOrThirdWorkerNumByWorkId(Long workId, Long cid, Boolean isThird) {
        List<StaffWorkRole> list = this.staffWorkRoleMapper.getSelfComOrThirdWorkerNumByWorkId(workId, cid, isThird);
        if (list != null) {
            for (int i = list.size() - 1; i >= 0; --i) {
                StaffWorkRole currentStaffWorkRole;
                StaffWorkRole staffWorkRole = list.get(i);
                if (staffWorkRole.getWorkProperty() != 2 || (currentStaffWorkRole = this.getCurrentStaffWorkRoleByStaffId(staffWorkRole.getStaffId())).getStatus() == null || currentStaffWorkRole.getStatus() != 2) continue;
                list.remove(i);
            }
            return list.size();
        }
        return 0;
    }

    public List<CompanyOrganization> getStaffOrgByStaffId(Long staffId) {
        List<CompanyOrganization> list = this.staffWorkRoleMapper.selectStaffOrgByStaffId(staffId);
        return list;
    }

    public List<Long> getOutWorkStaffIdList(Long cid) {
        List<Long> list = this.staffWorkRoleMapper.getOutWorkStaffIdList(cid);
        return list;
    }

    @Transactional(readOnly=false)
    public void updateCurrentStaffWorkRoleNotWorkedByStaffId(Long staffId) {
        if (staffId == null) {
            return;
        }
        Example e = new Example(StaffWorkRole.class);
        Example.Criteria c = e.createCriteria();
        c.andEqualTo("staffId", (Object)staffId).andEqualTo("isHistory", (Object)Global.FALSE).andEqualTo("isThirdParty", (Object)Global.FALSE).andEqualTo("workProperty", (Object)StaffWorkPropertyEnum.MAJOR.getValue());
        StaffWorkRole workRole = new StaffWorkRole();
        workRole.setStatus(StaffWorkStatusEnum.NOWORKED.getValue());
        workRole.setLeaveTime(new Date());
        ((StaffWorkRoleMapper)this.dao).updateByExampleSelective(workRole, e);
    }

    public List<Long> getNeedSetStatusCids() {
        Example e = new Example(StaffWorkRole.class);
        e.createCriteria().andEqualTo("dataSource", (Object)1).andIsNull("status").andEqualTo("isValid", (Object)true).andIsNotNull("cid").andEqualTo("workProperty", (Object)1).andEqualTo("isThirdParty", (Object)0);
        e.selectProperties(new String[]{"cid"}).setDistinct(true);
        List listByExample = this.getListByExample(e);
        return listByExample.stream().map(StaffWorkRole::getCid).collect(Collectors.toList());
    }

    public int updateBatchWorkStatus(List<StaffWorkRole> updateList) {
        return this.batchUpdateOrInsert(updateList, StaffWorkRoleMapper.class, (item, mapper) -> mapper.updateWorkStatus((StaffWorkRole)item));
    }

    @Transactional
    public int updateBatchWorkTime(List<ImproveStaffModel> updateList) {
        return this.batchUpdateOrInsert(updateList, StaffWorkRoleMapper.class, (item, mapper) -> mapper.updateWorkTime((ImproveStaffModel)item));
    }

    public List<StaffWorkRole> getStaffWorkRoleListBatch(List<Long> staffIdList) {
        if (CollUtil.isEmpty(staffIdList)) {
            return Collections.emptyList();
        }
        return ((StaffWorkRoleMapper)this.dao).selectStaffWorkRoleList(staffIdList);
    }

    @Transactional
    public void setFirstBeginTime() {
        List<Long> allCidList = ((StaffWorkRoleMapper)this.dao).getAllCidList();
        if (CollectionUtils.isNotEmpty(allCidList)) {
            List cidList = ListUtil.split(allCidList, (int)3000);
            for (List cids : cidList) {
                List<StaffWorkRole> staffWorkRoleList = ((StaffWorkRoleMapper)this.dao).getStaffFirstBeginTime(cids);
                if (!CollectionUtils.isNotEmpty(staffWorkRoleList)) continue;
                List list = ListUtil.split(staffWorkRoleList, (int)1000);
                for (List workRoleList : list) {
                    ((StaffWorkRoleMapper)this.dao).setFirstBeginTime(workRoleList);
                }
            }
        }
    }

    public Byte getWorkStatus(Long cid, String idCard) {
        return ((StaffWorkRoleMapper)this.dao).getWorkStatus(cid, SpringEncryptUtils.encrypt((String)idCard));
    }

    public Integer updateStaffWorkRoleStatus(List<StaffWorkRole> staffWorkRoleList) {
        return this.batchUpdateOrInsert(staffWorkRoleList, StaffWorkRoleMapper.class, (item, mapper) -> mapper.updateStaffWorkRoleStatus((StaffWorkRole)item));
    }
}

