/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.staff;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.framework.service.datascope.DataScopeHelper;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.IDCardUtil;
import cn.smarthse.common.util.StringMixedUtil;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.common.util.excel.ExcelUtil;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.modules.datacentre.enums.SysParamGroupEnum;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.model.system.SysParamModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.datacentre.provider.system.ISysParamProvideService;
import cn.smarthse.modules.health.bx.service.IBxZybService;
import cn.smarthse.modules.health.compliance.service.IComplianceCompanyInfoService;
import cn.smarthse.modules.health.compliance.service.IComplianceScoreRefreshService;
import cn.smarthse.modules.health.compliance.vo.ComplianceStaffInfoVo;
import cn.smarthse.modules.health.compliance.vo.ComplianceWorkerTrainRecordsVo;
import cn.smarthse.modules.health.dao.base.staff.StaffBasicInfoMapper;
import cn.smarthse.modules.health.dao.base.staff.StaffBasicWorkMapper;
import cn.smarthse.modules.health.dao.base.staff.StaffHeaderSetMapper;
import cn.smarthse.modules.health.dao.base.staff.StaffInfoMapper;
import cn.smarthse.modules.health.dao.base.staff.StaffWorkRoleMapper;
import cn.smarthse.modules.health.dosemonitor.model.DoseMonitorDataModel;
import cn.smarthse.modules.health.entity.base.company.CompanyOrganization;
import cn.smarthse.modules.health.entity.base.occriskfactor.OccupationalRiskFactors;
import cn.smarthse.modules.health.entity.base.staff.StaffAbnormalInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffAttachment;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicWork;
import cn.smarthse.modules.health.entity.base.staff.StaffDoseMonitorDataModel;
import cn.smarthse.modules.health.entity.base.staff.StaffExistChangeVo;
import cn.smarthse.modules.health.entity.base.staff.StaffFieldChangeLog;
import cn.smarthse.modules.health.entity.base.staff.StaffHeaderSet;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffInfoImportVo;
import cn.smarthse.modules.health.entity.base.staff.StaffInfoSearchParam;
import cn.smarthse.modules.health.entity.base.staff.StaffOccupationHealth;
import cn.smarthse.modules.health.entity.base.staff.StaffShowInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffWorkRole;
import cn.smarthse.modules.health.entity.base.staff.WorkNatureInfo;
import cn.smarthse.modules.health.entity.base.staff.importstaff.BatchStafffWorkVo;
import cn.smarthse.modules.health.entity.base.staff.importstaff.StaffInfoExcelImportVo;
import cn.smarthse.modules.health.entity.base.staff.importstaff.StaffInfoNeedImportVo;
import cn.smarthse.modules.health.entity.base.staff.vo.HarmWorkStaffInfoQuery;
import cn.smarthse.modules.health.entity.base.staff.vo.HarmWorkStaffInfoVo;
import cn.smarthse.modules.health.entity.base.staff.vo.HealthCheckStaffInfoQuery;
import cn.smarthse.modules.health.entity.base.staff.vo.HealthCheckStaffInfoVo;
import cn.smarthse.modules.health.entity.base.staff.vo.ImproveStaffModel;
import cn.smarthse.modules.health.entity.base.staff.vo.StaffBasicVo;
import cn.smarthse.modules.health.entity.base.staff.vo.StaffCurrentWorkVo;
import cn.smarthse.modules.health.entity.base.staff.vo.StaffDocInfoVo;
import cn.smarthse.modules.health.entity.base.staff.vo.StaffInfoArchiveVo;
import cn.smarthse.modules.health.entity.base.staff.vo.StaffOccupationAndHarmHistoryVo;
import cn.smarthse.modules.health.entity.base.staff.vo.StaffPhySicalCheckModel;
import cn.smarthse.modules.health.entity.base.staff.vo.StaffQuery;
import cn.smarthse.modules.health.entity.base.staff.vo.StaffhealthDocVo;
import cn.smarthse.modules.health.entity.base.workinfo.WorkRoleInfo;
import cn.smarthse.modules.health.entity.datascope.DataScope;
import cn.smarthse.modules.health.entity.work.check.PhcOccupationalDiseaser;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheckData;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheckDataResult;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalStaffCheckInfo;
import cn.smarthse.modules.health.entity.work.check.checkV3221.noEnvo.StaffPhySicalCheckNoEnModel;
import cn.smarthse.modules.health.entity.work.check.earliestCheckModel;
import cn.smarthse.modules.health.entity.work.check.vo.HudongSysStaffInfoVo;
import cn.smarthse.modules.health.entity.work.harmfactor.HarmfactorWork;
import cn.smarthse.modules.health.entity.work.harmfactor.HarmfactorWorkSource;
import cn.smarthse.modules.health.entity.work.informmanager.ContractInform;
import cn.smarthse.modules.health.entity.work.informmanager.NoInformStaff;
import cn.smarthse.modules.health.entity.work.shield.vo.ShieldWorkRelation;
import cn.smarthse.modules.health.enums.hccheckplan.ResultCollectTypeEnum;
import cn.smarthse.modules.health.enums.staff.ContractInformReasonEnum;
import cn.smarthse.modules.health.enums.staff.NoInformStaffChangeWorkStatusEnum;
import cn.smarthse.modules.health.enums.staff.StaffAddFromEnum;
import cn.smarthse.modules.health.enums.staff.StaffExcelSheetNameEnum;
import cn.smarthse.modules.health.enums.staff.StaffFieldChangeEnum;
import cn.smarthse.modules.health.enums.staff.StaffFurloughStatusEnum;
import cn.smarthse.modules.health.enums.staff.StaffGenderEnum;
import cn.smarthse.modules.health.enums.staff.StaffInfoImportStateEnum;
import cn.smarthse.modules.health.enums.staff.StaffListHeaderEnum;
import cn.smarthse.modules.health.enums.staff.StaffMaritalStatusEnum;
import cn.smarthse.modules.health.enums.staff.StaffRadiationEnum;
import cn.smarthse.modules.health.enums.staff.StaffWorkChangeStatusRecordEnum;
import cn.smarthse.modules.health.enums.staff.StaffWorkPropertyEnum;
import cn.smarthse.modules.health.enums.staff.StaffWorkStatusEnum;
import cn.smarthse.modules.health.enums.staff.WorkNatureEnum;
import cn.smarthse.modules.health.service.base.company.ICompanyOrganizationService;
import cn.smarthse.modules.health.service.base.occriskfactor.IOccupationalRiskFactorsService;
import cn.smarthse.modules.health.service.base.staff.IStaffAttachmentService;
import cn.smarthse.modules.health.service.base.staff.IStaffBasicInfoService;
import cn.smarthse.modules.health.service.base.staff.IStaffBasicWorkService;
import cn.smarthse.modules.health.service.base.staff.IStaffFieldChangeLogService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoExportService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.base.staff.IStaffOccupationHealthService;
import cn.smarthse.modules.health.service.base.staff.IStaffPhysiologicalFeatureService;
import cn.smarthse.modules.health.service.base.staff.IStaffWorkRoleService;
import cn.smarthse.modules.health.service.base.staff.IWorkNatureInfoService;
import cn.smarthse.modules.health.service.base.workinfo.IWorkRoleInfoService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveFilePersonalService;
import cn.smarthse.modules.health.service.sys.IParamService;
import cn.smarthse.modules.health.service.work.check.IPhcOccupationalDiseaserService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckCountService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckDataResultService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckDataService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckRecommendIgnoredService;
import cn.smarthse.modules.health.service.work.check.checkV3221.IPhcPhysicalStaffCheckInfoService;
import cn.smarthse.modules.health.service.work.harmfactor.IHarmfactorWorkService;
import cn.smarthse.modules.health.service.work.hccheckplan.IHcCheckResultCollectDataService;
import cn.smarthse.modules.health.service.work.informmanager.IContractInformService;
import cn.smarthse.modules.health.service.work.informmanager.INoInformStaffService;
import cn.smarthse.modules.health.service.work.shield.IShieldEquipRuleService;
import cn.smarthse.modules.health.vo.base.historyBasic.BasicEntityContentSearch;
import cn.smarthse.modules.platform.model.UserModel;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import cn.smarthse.services.wanda.api.entity.WandaHealthCard;
import cn.smarthse.services.wanda.api.enums.WandaTJTypeEnum;
import cn.smarthse.services.wanda.api.service.IWandaHealthCardService;
import cn.smarthse.util.common.ListUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import jakarta.annotation.Resource;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.CollectionUtils;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class StaffInfoServiceImpl
extends BaseServiceImpl<StaffInfoMapper, StaffInfo>
implements IStaffInfoService {
    @Autowired
    private IContractInformService contractInformService;
    @Autowired
    private StaffHeaderSetMapper staffHeaderSetMapper;
    @Autowired
    private IPhcPhysicalCheckCountService phcPhysicalCheckCountService;
    @Autowired
    private IOccupationalRiskFactorsService occupationalRiskFactorsService;
    @Autowired
    private IHcCheckResultCollectDataService hcCheckResultCollectDataService;
    @Autowired
    private IHarmfactorWorkService harmfactorWorkService;
    @Autowired
    private IShieldEquipRuleService shieldEquipRuleService;
    @Autowired
    private IStaffAttachmentService staffAttachmentService;
    @Autowired
    private IStaffOccupationHealthService staffOccupationHealthService;
    @Autowired
    private IStaffBasicInfoService staffBasicInfoService;
    @Autowired
    private IStaffPhysiologicalFeatureService staffPhysiologicalFeatureService;
    @Autowired
    private IStaffWorkRoleService staffWorkRoleService;
    @Autowired
    private IStaffBasicWorkService staffBasicWorkService;
    @Autowired
    private ICompanyOrganizationService companyOrganizationService;
    @Autowired
    private IWorkRoleInfoService workRoleInfoService;
    @Autowired
    private StaffInfoMapper staffInfoMapper;
    @Autowired
    private StaffBasicInfoMapper staffBasicInfoMapper;
    @DubboReference(version="1.0.0")
    private ISysParamProvideService sysParamProvideService;
    @Autowired
    private INoInformStaffService noInformStaffService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaService;
    @Autowired
    private IStaffInfoExportService staffInfoExportService;
    @Autowired
    private IPhcPhysicalCheckRecommendIgnoredService phcPhysicalCheckRecommendIgnoredService;
    @Autowired
    private IWorkNatureInfoService workNatureInfoService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideByHSEService companyProvideByHSEService;
    @DubboReference
    ICheckPlanService checkPlanService;
    @Autowired
    IParamService paramService;
    @Autowired
    IPhcPhysicalCheckDataResultService phcPhysicalCheckDataResultService;
    @DubboReference(version="1.0.0")
    ICompanyProvideService companyProvideService;
    @DubboReference
    IWandaHealthCardService wandaHealthCardService;
    @DubboReference
    IComplianceScoreRefreshService scoreRefreshService;
    @DubboReference
    private IBxZybService bxZybService;
    @Autowired
    private IStaffFieldChangeLogService staffFieldChangeLogService;
    @Autowired
    private StaffBasicWorkMapper staffBasicWorkMapper;
    @Autowired
    @Lazy
    private ILiteArchiveFilePersonalService liteArchiveFilePersonalService;
    @DubboReference
    @Lazy
    private IComplianceCompanyInfoService complianceCompanyInfoService;
    @Value(value="${isActualize}")
    private String isActualize;
    @Autowired
    private DataSourceTransactionManager txManager;
    @Autowired
    StaffWorkRoleMapper staffWorkRoleMapper;
    @Resource
    IPhcPhysicalCheckDataService phcPhysicalCheckDataService;
    @Resource
    IPhcOccupationalDiseaserService phcOccupationalDiseaserService;
    private static Date DATE_2023_01_01 = DateUtil.getDate((String)"2023-01-01", (String)"yyyy-MM-dd");
    private static Date DATE_2023_03_01 = DateUtil.getDate((String)"2023-03-01", (String)"yyyy-MM-dd");
    private static Date DATE_2022_12_31 = DateUtil.getDate((String)"2022-12-31", (String)"yyyy-MM-dd");
    private static final List<String> beforeWorkStatus = Collections.singletonList("1");
    private static final List<String> onWorkStatus = Arrays.asList("2", "5");
    private static final List<String> leaveWorkStatus = Arrays.asList("3", "4");
    @Autowired
    private IPhcPhysicalStaffCheckInfoService phcPhysicalStaffCheckInfoService;

    private Boolean getIsHuadong(Long cid) {
        String value = this.paramService.getByKey("company_code", cid);
        if (value != null && value.equals("hdyy")) {
            return true;
        }
        return false;
    }

    public PageInfo<StaffShowInfo> getStaffInfoListBySearchParam(StaffInfoSearchParam param) {
        if (param.getUpdateDateEnd() != null) {
            String end = DateUtils.format((Date)param.getUpdateDateEnd(), (String)"yyyy-MM-dd") + " 23:59:59";
            param.setUpdateDateEnd(DateUtils.parseDate((Object)end));
        }
        PageHelper.startPage((int)param.getJqGridParam().getPage(), (int)param.getJqGridParam().getRows(), (boolean)false);
        DataScopeHelper.startDataScope("staffInfo", "staff_info");
        DataScope dataScope = DataScopeHelper.getDataScope();
        dataScope.setCreateBy("id");
        DataScopeHelper.setDataScope(dataScope);
        String yearStatusPhy = param.getYearStatusPhy();
        if (CharSequenceUtil.isNotBlank((CharSequence)yearStatusPhy)) {
            List yearStatusPhyList = CharSequenceUtil.split((CharSequence)yearStatusPhy, (char)',');
            param.setYearStatusPhyList(yearStatusPhyList);
        }
        param.setSearchKeyEncrypt(param.getSearchKey());
        param.setStaffNameEncrypt(param.getStaffName());
        List<StaffShowInfo> comStaffList = this.staffInfoMapper.getStaffInfoListBySearchParam(param);
        if (!CollectionUtils.isEmpty(comStaffList)) {
            List idcardList = comStaffList.stream().map(StaffShowInfo::getIdCardNo).filter(s -> StringUtils.isNotEmpty((String)s)).distinct().peek(String::toLowerCase).collect(Collectors.toList());
            List earliestPhcDate = this.phcPhysicalStaffCheckInfoService.getEarliestPhcDate(Collections.singletonList(param.getCid()), idcardList);
            if (CollectionUtil.isNotEmpty((Collection)earliestPhcDate)) {
                Map<String, List<earliestCheckModel>> earliestPhcMap = earliestPhcDate.stream().peek(s -> s.setIdCard(s.getIdCard().toUpperCase())).collect(Collectors.groupingBy(earliestCheckModel::getIdCard));
                for (StaffShowInfo staffShowInfo : comStaffList) {
                    List<earliestCheckModel> earliestCheckModels;
                    if (!StringUtils.isNotEmpty((String)staffShowInfo.getIdCardNo()) || !CollectionUtil.isNotEmpty(earliestCheckModels = earliestPhcMap.get(staffShowInfo.getIdCardNo().toUpperCase()))) continue;
                    staffShowInfo.setEarliestCheckTime(earliestCheckModels.get(0).getCheckTime());
                }
            }
        }
        if (CollectionUtils.isEmpty(comStaffList)) {
            return new PageInfo();
        }
        PageInfo list = new PageInfo(comStaffList);
        List idCards = comStaffList.stream().map(StaffShowInfo::getIdCardNo).collect(Collectors.toList());
        ArrayList<String> idCardEncs = new ArrayList<String>();
        if (CollectionUtil.isNotEmpty(idCards)) {
            for (String idCard : idCards) {
                String encs = SpringEncryptUtils.encrypt((String)idCard);
                idCardEncs.add(encs);
            }
        }
        List<StaffPhySicalCheckModel> checkModelList = ((StaffInfoMapper)this.dao).getCheckListByIdCards(param.getCid(), idCardEncs);
        checkModelList.removeAll(Collections.singleton(null));
        Map<String, List<StaffPhySicalCheckModel>> map = null;
        if (CollectionUtil.isNotEmpty(checkModelList)) {
            map = checkModelList.stream().peek(s -> s.setIdcardCode(StringUtils.isNotEmpty((String)s.getIdcardCode()) ? s.getIdcardCode().toUpperCase() : s.getIdcardCode())).collect(Collectors.groupingBy(StaffPhySicalCheckModel::getIdcardCode));
        }
        List<Long> staffIdList = comStaffList.stream().map(StaffShowInfo::getId).collect(Collectors.toList());
        List<ComplianceWorkerTrainRecordsVo> trainList = ((StaffInfoMapper)this.dao).getTrainListByStaffIdList(staffIdList);
        Map<Long, List<ComplianceWorkerTrainRecordsVo>> trainMap = null;
        if (CollectionUtil.isNotEmpty(trainList)) {
            trainMap = trainList.stream().collect(Collectors.groupingBy(ComplianceWorkerTrainRecordsVo::getStaffId));
        }
        for (StaffShowInfo s2 : list.getList()) {
            List<ComplianceWorkerTrainRecordsVo> gzTrain;
            Date date23;
            StaffWorkRole currentStaffWorkRole;
            Boolean falg;
            s2.setIsUnEmployee(Boolean.valueOf(false));
            if (StringUtils.isNotEmpty((String)s2.getIdCardNo()) && (falg = ((StaffInfoMapper)this.dao).getStaffIsUnEmployee(param.getCid(), SpringEncryptUtils.encrypt((String)s2.getIdCardNo()))).booleanValue() && ObjectUtil.isNotNull((Object)s2.getWorkStatus()) && s2.getWorkStatus() != 10) {
                s2.setIsUnEmployee(Boolean.valueOf(true));
            }
            if (s2.getOrgId() != null) {
                CompanyOrganization org = (CompanyOrganization)this.companyOrganizationService.getById(s2.getOrgId());
                s2.setOrgName(org == null ? null : org.getOrganizationName());
            }
            if (s2.getWorkProperty() == 2 && (currentStaffWorkRole = this.staffWorkRoleService.getCurrentStaffWorkRoleByStaffId(s2.getId())) != null) {
                s2.setWorkStatus(currentStaffWorkRole.getStatus());
            }
            if (param.getStaffInfoIdList() != null && param.getStaffInfoIdList().size() > 0 && param.getStaffInfoIdList().contains(s2.getId())) {
                s2.setArchivesFinished("\u5df2\u5b8c\u5584");
            } else {
                s2.setArchivesFinished("\u672a\u5b8c\u5584");
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            try {
                date23 = dateFormat.parse("2023-01-01");
            }
            catch (ParseException e2) {
                throw new RuntimeException(e2);
            }
            List<StaffPhySicalCheckModel> checkList = null;
            if (map != null && (checkList = map.get(StringUtils.isNotEmpty((String)s2.getIdCardNo()) ? s2.getIdCardNo().toUpperCase() : s2.getIdCardNo())) != null && checkList.size() > 0) {
                List<StaffPhySicalCheckModel> lgCheck;
                List<StaffPhySicalCheckModel> gzCheck;
                checkList.stream().max(Comparator.comparing(StaffPhySicalCheckModel::getCheckTime)).ifPresent(e -> s2.setLatestCheckDate(e.getCheckTime()));
                String gzCheckType = WandaTJTypeEnum.ZG_TJ.getType() + "," + WandaTJTypeEnum.YJ_TJ.getType();
                String lgCheckType = WandaTJTypeEnum.LG_TJ.getType() + "," + WandaTJTypeEnum.LG_AFTER_TJ.getType();
                List<StaffPhySicalCheckModel> gqCheck = checkList.stream().filter(e -> e.getCheckTime().getTime() >= date23.getTime() && Objects.equals(WandaTJTypeEnum.SG_BEFORE_TJ.getType(), e.getBodyCheckType())).collect(Collectors.toList());
                if (gqCheck.size() > 0) {
                    Map<Integer, String> gqCheckMap = this.getCheckMap(dateFormat, gqCheck);
                    s2.setGqCheckTimeInThisYear(gqCheckMap.get(1));
                    s2.setGqCheckTimeInPastOneYear(gqCheckMap.get(2));
                    s2.setGqCheckTimeInPastTwoYear(gqCheckMap.get(3));
                }
                if ((gzCheck = checkList.stream().filter(e -> e.getCheckTime().getTime() >= date23.getTime() && gzCheckType.contains(e.getBodyCheckType())).collect(Collectors.toList())).size() > 0) {
                    Map<Integer, String> gzCheckMap = this.getCheckMap(dateFormat, gzCheck);
                    s2.setZgCheckTimeInThisYear(gzCheckMap.get(1));
                    s2.setZgCheckTimeInPastOneYear(gzCheckMap.get(2));
                    s2.setZgCheckTimeInPastTwoYear(gzCheckMap.get(3));
                }
                if ((lgCheck = checkList.stream().filter(e -> e.getCheckTime().getTime() >= date23.getTime() && lgCheckType.contains(e.getBodyCheckType())).collect(Collectors.toList())).size() > 0) {
                    Map<Integer, String> lgCheckMap = this.getCheckMap(dateFormat, lgCheck);
                    s2.setLgCheckTimeInThisYear(lgCheckMap.get(1));
                    s2.setLgCheckTimeInPastOneYear(lgCheckMap.get(2));
                    s2.setLgCheckTimeInPastTwoYear(lgCheckMap.get(3));
                }
            }
            List<ComplianceWorkerTrainRecordsVo> trainRecordsVoList = null;
            if (trainMap == null || (trainRecordsVoList = trainMap.get(s2.getId())) == null || trainRecordsVoList.size() <= 0) continue;
            List<ComplianceWorkerTrainRecordsVo> gqTrain = trainRecordsVoList.stream().filter(e -> e.getTrainBeginTime().getTime() >= date23.getTime() && e.getType() == 1).collect(Collectors.toList());
            if (gqTrain.size() > 0) {
                Map<Integer, String> gqTrainMap = this.getTrainMap(dateFormat, gqTrain);
                s2.setGqStaffTrainThisYear(gqTrainMap.get(1));
                s2.setGqStaffTrainPastOneYear(gqTrainMap.get(2));
                s2.setGqStaffTrainPastTwoYear(gqTrainMap.get(3));
            }
            if ((gzTrain = trainRecordsVoList.stream().filter(e -> e.getTrainBeginTime().getTime() >= date23.getTime() && e.getType() == 2).collect(Collectors.toList())).size() <= 0) continue;
            Map<Integer, String> gzTrainMap = this.getTrainMap(dateFormat, gzTrain);
            s2.setGzStaffTrainThisYear(gzTrainMap.get(1));
            s2.setGzStaffTrainPastOneYear(gzTrainMap.get(2));
            s2.setGzStaffTrainPastTwoYear(gzTrainMap.get(3));
        }
        return list;
    }

    private Map<Integer, String> getCheckMap(SimpleDateFormat dateFormat, List<StaffPhySicalCheckModel> checkList) {
        Date date = new Date();
        int nowYear = date.getYear();
        checkList = checkList.stream().sorted(Comparator.comparing(StaffPhySicalCheckModel::getCheckTime).reversed()).collect(Collectors.toList());
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        HashSet<String> thisYearCheck = new HashSet<String>();
        HashSet<String> pastOneYearCheck = new HashSet<String>();
        HashSet<String> pastTwoYearCheck = new HashSet<String>();
        for (StaffPhySicalCheckModel staffPhySicalCheckModel : checkList) {
            if (staffPhySicalCheckModel.getCheckTime().getYear() == nowYear) {
                thisYearCheck.add(dateFormat.format(staffPhySicalCheckModel.getCheckTime()));
            }
            if (staffPhySicalCheckModel.getCheckTime().getYear() == nowYear - 1) {
                pastOneYearCheck.add(dateFormat.format(staffPhySicalCheckModel.getCheckTime()));
            }
            if (staffPhySicalCheckModel.getCheckTime().getYear() != nowYear - 2) continue;
            pastTwoYearCheck.add(dateFormat.format(staffPhySicalCheckModel.getCheckTime()));
        }
        map.put(1, thisYearCheck.stream().collect(Collectors.joining(",")));
        map.put(2, pastOneYearCheck.stream().collect(Collectors.joining(",")));
        map.put(3, pastTwoYearCheck.stream().collect(Collectors.joining(",")));
        return map;
    }

    private Map<Integer, String> getTrainMap(SimpleDateFormat dateFormat, List<ComplianceWorkerTrainRecordsVo> trainList) {
        Date date = new Date();
        int nowYear = date.getYear();
        trainList = trainList.stream().sorted(Comparator.comparing(ComplianceWorkerTrainRecordsVo::getTrainBeginTime).reversed()).collect(Collectors.toList());
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        HashSet<String> thisYearTrain = new HashSet<String>();
        HashSet<String> pastOneYearTrain = new HashSet<String>();
        HashSet<String> pastTwoYearTrain = new HashSet<String>();
        for (ComplianceWorkerTrainRecordsVo complianceWorkerTrainRecordsVo : trainList) {
            if (complianceWorkerTrainRecordsVo.getTrainBeginTime().getYear() == nowYear) {
                thisYearTrain.add(dateFormat.format(complianceWorkerTrainRecordsVo.getTrainBeginTime()));
            }
            if (complianceWorkerTrainRecordsVo.getTrainBeginTime().getYear() == nowYear - 1) {
                pastOneYearTrain.add(dateFormat.format(complianceWorkerTrainRecordsVo.getTrainBeginTime()));
            }
            if (complianceWorkerTrainRecordsVo.getTrainBeginTime().getYear() != nowYear - 2) continue;
            pastTwoYearTrain.add(dateFormat.format(complianceWorkerTrainRecordsVo.getTrainBeginTime()));
        }
        map.put(1, thisYearTrain.stream().collect(Collectors.joining(",")));
        map.put(2, pastOneYearTrain.stream().collect(Collectors.joining(",")));
        map.put(3, pastTwoYearTrain.stream().collect(Collectors.joining(",")));
        return map;
    }

    public Integer getStaffCount(StaffInfoSearchParam param) {
        String yearStatusPhy = param.getYearStatusPhy();
        if (CharSequenceUtil.isNotBlank((CharSequence)yearStatusPhy)) {
            List yearStatusPhyList = CharSequenceUtil.split((CharSequence)yearStatusPhy, (char)',');
            param.setYearStatusPhyList(yearStatusPhyList);
        }
        if (param.getUpdateDateEnd() != null) {
            String end = DateUtils.format((Date)param.getUpdateDateEnd(), (String)"yyyy-MM-dd") + " 23:59:59";
            param.setUpdateDateEnd(DateUtils.parseDate((Object)end));
        }
        param.setSearchKeyEncrypt(param.getSearchKey());
        param.setStaffNameEncrypt(param.getStaffName());
        return ((StaffInfoMapper)this.dao).getStaffCount(param);
    }

    public List<StaffShowInfo> getStaffInfoListByParam(StaffInfoSearchParam param) {
        param.setSearchKeyEncrypt(param.getSearchKey());
        param.setStaffNameEncrypt(param.getStaffName());
        return this.staffInfoMapper.getStaffInfoListBySearchParam(param);
    }

    public List<StaffShowInfo> getLaborDispatchStaffInfoListBySearchParam(StaffInfoSearchParam param) {
        param.setSearchKeyEncrypt(param.getSearchKey());
        param.setStaffNameEncrypt(param.getStaffName());
        return this.staffInfoMapper.getLaborDispatchStaffInfoListBySearchParam(param);
    }

    @Transactional(readOnly=false)
    public StaffInfo addStaffInfoSubmit(StaffInfo staffInfo) {
        if (staffInfo.getStaffBasicInfo() != null) {
            this.staffBasicInfoService.add((Object)staffInfo.getStaffBasicInfo(), staffInfo.getCreateBy(), staffInfo.getCid());
            staffInfo.setStaffBasicId(staffInfo.getStaffBasicInfo().getId());
        }
        this.add(staffInfo, staffInfo.getCreateBy(), staffInfo.getCid());
        if (staffInfo.getStaffPhysiologicalFeature() != null) {
            staffInfo.getStaffPhysiologicalFeature().setStaffId(staffInfo.getId());
            this.staffPhysiologicalFeatureService.add((Object)staffInfo.getStaffPhysiologicalFeature(), staffInfo.getCreateBy(), staffInfo.getCid());
        }
        StaffBasicWork staffBasicWork = new StaffBasicWork();
        staffBasicWork.setStaffId(staffInfo.getId());
        staffBasicWork.setCid(staffInfo.getCid());
        staffBasicWork.setCreateBy(staffInfo.getCreateBy());
        staffBasicWork.setIsRadiation(Global.FALSE);
        this.staffBasicWorkService.add((Object)staffBasicWork, staffInfo.getCreateBy(), staffInfo.getCid());
        StaffWorkRole staffWorkRole = new StaffWorkRole();
        staffWorkRole.setCid(staffInfo.getCid());
        staffWorkRole.setStaffId(staffInfo.getId());
        staffWorkRole.setWorkProperty(StaffWorkPropertyEnum.MAJOR.getValue());
        staffWorkRole.setStatus(StaffWorkStatusEnum.ONWORKING.getValue());
        staffWorkRole.setIsThirdParty(Global.FALSE);
        staffWorkRole.setIsHistory(Global.FALSE);
        staffWorkRole.setCreateBy(staffInfo.getId());
        this.staffWorkRoleService.add((Object)staffWorkRole, staffInfo.getCreateBy(), staffInfo.getCid());
        return staffInfo;
    }

    public StaffInfo getStaffInfoDetailById(Long staffId) {
        StaffInfo staffInfo = (StaffInfo)this.getById(staffId);
        if (staffInfo != null) {
            if (staffInfo.getStaffBasicId() != null) {
                staffInfo.setStaffBasicInfo((StaffBasicInfo)this.staffBasicInfoService.getById(staffInfo.getStaffBasicId()));
            }
            staffInfo.setStaffPhysiologicalFeature(this.staffPhysiologicalFeatureService.getStaffStaffPhysiologicalFeatureByStaffId(staffId));
            staffInfo.setStaffBasicWork(this.staffBasicWorkService.getStaffBasicWorkByStaffId(staffId));
            staffInfo.setStaffWorkRole(this.staffWorkRoleService.getCurrentStaffWorkRoleByStaffId(staffId));
            staffInfo.setLocalStaffWorkRoles(this.staffWorkRoleService.getLocalStaffWorkRolesByStaffId(staffId));
            staffInfo.setOutsideStaffWorkRoles(this.staffWorkRoleService.getOutsideStaffWorkRolesByStaffId(staffId));
            staffInfo.setStaffAttachments(this.staffAttachmentService.getStaffAttachmentsByStaffId(staffId));
        }
        return staffInfo;
    }

    public StaffInfo getStaffInfoWorkAndDeptById(Long staffId) {
        StaffInfo staffInfo = (StaffInfo)this.getById(staffId);
        if (staffInfo != null) {
            if (staffInfo.getStaffBasicId() != null) {
                staffInfo.setStaffBasicInfo((StaffBasicInfo)this.staffBasicInfoService.getById(staffInfo.getStaffBasicId()));
            }
            staffInfo.setStaffBasicWork(this.staffBasicWorkService.getStaffBasicWorkByStaffId(staffId));
            staffInfo.setStaffWorkRole(this.staffWorkRoleService.getCurrentStaffWorkRoleByStaffId(staffId));
        }
        return staffInfo;
    }

    public List<StaffInfo> getStaffInfoDetailByOrgId(Long cid, Long orgId, String searchKey, Long workRoleInfoId) {
        if (cid == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Long> orgIds = new ArrayList<Long>();
        if (orgId != null) {
            orgIds.add(orgId);
        } else {
            orgIds = null;
        }
        if (orgId != null && orgId != -1L) {
            List orgList = this.companyOrganizationService.getAllChildrenCompanyOrganizationsByPid(orgId, cid);
            for (CompanyOrganization co : orgList) {
                orgIds.add(co.getId());
            }
        }
        return this.staffBasicWorkService.getStaffInfosByOrgIdAndSearch(cid, searchKey, workRoleInfoId, orgIds);
    }

    public StaffInfo getStaffInfoWithStaffBasicWorkById(Long staffId) {
        StaffWorkRole staffWorkRole;
        StaffBasicWork staffWork;
        if (staffId == null) {
            return null;
        }
        StaffInfo staffInfo = (StaffInfo)this.getById(staffId);
        if (staffInfo == null) {
            return null;
        }
        if (staffInfo.getStaffBasicId() != null) {
            staffInfo.setStaffBasicInfo((StaffBasicInfo)this.staffBasicInfoService.getById(staffInfo.getStaffBasicId()));
        }
        if ((staffWork = this.staffBasicWorkService.getStaffBasicWorkByStaffId(staffId)) != null) {
            staffInfo.setStaffBasicWork(staffWork);
        }
        if ((staffWorkRole = this.staffWorkRoleService.getCurrentStaffWorkRoleByStaffId(staffId)) != null) {
            staffInfo.setStaffWorkRole(staffWorkRole);
        }
        return staffInfo;
    }

    @Transactional(readOnly=false)
    public void editStaffInfoSubmit(StaffInfo staffInfo, Long loginStaffId) {
        this.update(staffInfo, loginStaffId);
        if (staffInfo.getStaffBasicInfo() != null) {
            this.staffBasicInfoService.update((Object)staffInfo.getStaffBasicInfo(), loginStaffId);
        }
    }

    @Transactional(readOnly=false)
    public void deleteStaffInfoById(Long staffInfoId, Long loginStaffId, String deleteReason) {
        StaffInfo staffInfo = (StaffInfo)this.getById(staffInfoId);
        if (staffInfo.getAddFrom() != null && staffInfo.getAddFrom() != 2) {
            List staffAttachments;
            staffInfo.setDeleteReason(deleteReason);
            this.delete(staffInfo, loginStaffId);
            if (staffInfo != null && staffInfo.getStaffBasicId() != null) {
                StaffBasicInfo staffBasicInfo = new StaffBasicInfo();
                staffBasicInfo.setId(staffInfo.getStaffBasicId());
                this.staffBasicInfoService.delete((Object)staffBasicInfo, loginStaffId);
            }
            StaffBasicWork staffBasicWork = this.staffBasicWorkService.getStaffBasicWorkByStaffId(staffInfoId);
            this.staffBasicWorkService.delete((Object)staffBasicWork, loginStaffId);
            StaffOccupationHealth staffOccupationHealth = this.staffOccupationHealthService.getStaffOccupationHealthByStaffId(staffInfoId);
            if (staffOccupationHealth != null) {
                this.staffOccupationHealthService.delete((Object)staffOccupationHealth, loginStaffId);
            }
            StaffWorkRole staffWorkRole = this.staffWorkRoleService.getCurrentStaffWorkRoleByStaffId(staffInfoId);
            if (staffOccupationHealth != null) {
                this.staffWorkRoleService.delete((Object)staffWorkRole, loginStaffId);
            }
            if ((staffAttachments = this.staffAttachmentService.getStaffAttachmentsByStaffId(staffInfoId)).size() > 0) {
                this.staffAttachmentService.delete((Object)((StaffAttachment)staffAttachments.get(0)), loginStaffId);
            }
        }
    }

    public ResponseData<StaffInfoImportVo> getBatchStaffInfoFromExcelForSelf(String ossfile, Long cid) throws Exception {
        HSSFWorkbook wb = new HSSFWorkbook(ExcelUtil.getInstance().getOssInputStream(ossfile));
        HSSFSheet sheet = wb.getSheetAt(0);
        ResponseData<StaffInfoImportVo> data = this.parseStaffInfromExcelForSelf(sheet, cid);
        wb.close();
        return data;
    }

    private ResponseData<StaffInfoImportVo> parseStaffInfromExcelForSelf(HSSFSheet sheet, Long cid) {
        Long basicId = 1L;
        int rowIndex = 0;
        DecimalFormat df = new DecimalFormat("###########");
        ResponseData data = new ResponseData();
        StaffInfoImportVo staffInfoImportVo = new StaffInfoImportVo();
        Iterator iter = sheet.rowIterator();
        while (iter.hasNext()) {
            Row row = (Row)iter.next();
            if (++rowIndex == 1) continue;
            if (!(row.getCell(2) != null && row.getCell(2).getCellType() != CellType.BLANK || row.getCell(3) != null && row.getCell(3).getCellType() != CellType.BLANK || row.getCell(1) != null && row.getCell(1).getCellType() != CellType.BLANK || row.getCell(4) != null && row.getCell(4).getCellType() != CellType.BLANK || row.getCell(5) != null && row.getCell(5).getCellType() != CellType.BLANK || row.getCell(6) != null && row.getCell(6).getCellType() != CellType.BLANK || row.getCell(7) != null && row.getCell(7).getCellType() != CellType.BLANK)) {
                if (row.getCell(0) != null) {
                    row.getCell(0).setCellType(CellType.STRING);
                }
                if (!(row.getCell(0) != null && StringUtils.isNotEmpty((String)row.getCell(0).getStringCellValue()) || row.getCell(8) != null && StringUtils.isNotEmpty((String)row.getCell(8).getStringCellValue()) || row.getCell(10) != null && StringUtils.isNotEmpty((String)row.getCell(10).getStringCellValue()) || row.getCell(9) != null && StringUtils.isNotEmpty((String)row.getCell(9).getStringCellValue()) || row.getCell(13) != null && StringUtils.isNotEmpty((String)row.getCell(13).getStringCellValue()) || row.getCell(14) != null && StringUtils.isNotEmpty((String)row.getCell(14).getStringCellValue()) || row.getCell(15) != null && StringUtils.isNotEmpty((String)row.getCell(15).getStringCellValue()) || row.getCell(16) != null && StringUtils.isNotEmpty((String)row.getCell(16).getStringCellValue()) || row.getCell(17) != null && StringUtils.isNotEmpty((String)row.getCell(17).getStringCellValue()) || row.getCell(18) != null && StringUtils.isNotEmpty((String)row.getCell(18).getStringCellValue()) || row.getCell(20) != null && StringUtils.isNotEmpty((String)row.getCell(20).getStringCellValue()) || row.getCell(19) != null && StringUtils.isNotEmpty((String)row.getCell(19).getStringCellValue())) && (row.getCell(12) == null || !StringUtils.isNotEmpty((String)row.getCell(12).getStringCellValue()))) continue;
                data.setState(ResponseStateEnum.warning);
                data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(1) + ", \u59d3\u540d\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a");
                return data;
            }
            StaffBasicInfo staffBasicInfo = new StaffBasicInfo();
            Long l = basicId;
            basicId = basicId + 1L;
            staffBasicInfo.setId(l);
            StaffInfo staffInfo = new StaffInfo();
            staffInfo.setId(staffBasicInfo.getId());
            staffInfo.setStaffBasicId(staffBasicInfo.getId());
            staffInfo.setIsThirdParty(Global.FALSE);
            StaffBasicWork staffBasicWork = new StaffBasicWork();
            staffBasicWork.setId(staffBasicInfo.getId());
            staffBasicWork.setStaffId(staffInfo.getId());
            StaffWorkRole currentStaffWorkRole = new StaffWorkRole();
            currentStaffWorkRole.setId(staffBasicInfo.getId());
            currentStaffWorkRole.setStaffId(staffInfo.getId());
            currentStaffWorkRole.setIsHistory(Global.FALSE);
            currentStaffWorkRole.setWorkProperty(StaffWorkPropertyEnum.MAJOR.getValue());
            currentStaffWorkRole.setIsThirdParty(Global.FALSE);
            int cellCount = 21;
            int colIndex = 0;
            block64: for (int i = 0; i < cellCount; ++i) {
                Cell cell = row.getCell(i);
                ++colIndex;
                if (cell == null || cell.getCellType() == CellType.BLANK) {
                    if (i == 1) {
                        data.setState(ResponseStateEnum.warning);
                        data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u59d3\u540d\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a");
                        return data;
                    }
                    if (i == 2) {
                        data.setState(ResponseStateEnum.warning);
                        data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u90e8\u95e8/\u8f66\u95f4\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a");
                        return data;
                    }
                    if (i == 3) {
                        data.setState(ResponseStateEnum.warning);
                        data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u5c97\u4f4d/\u5de5\u79cd\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a");
                        return data;
                    }
                    if (i == 4) {
                        data.setState(ResponseStateEnum.warning);
                        data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u6027\u522b\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a");
                        return data;
                    }
                    if (i == 5) {
                        data.setState(ResponseStateEnum.warning);
                        data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u624b\u673a\u53f7\u7801\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a");
                        return data;
                    }
                    if (i == 6) {
                        data.setState(ResponseStateEnum.warning);
                        data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u8eab\u4efd\u8bc1\u53f7\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a");
                        return data;
                    }
                    if (i != 7) continue;
                    data.setState(ResponseStateEnum.warning);
                    data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u5c97\u4f4d\u72b6\u6001\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a");
                    return data;
                }
                switch (i) {
                    case 0: {
                        Object number;
                        try {
                            number = cell.getStringCellValue().trim();
                        }
                        catch (Exception e2) {
                            try {
                                number = df.format(cell.getNumericCellValue());
                            }
                            catch (Exception e) {
                                data.setState(ResponseStateEnum.warning);
                                data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u5de5\u53f7\u683c\u5f0f\u4e0d\u5bf9");
                                return data;
                            }
                        }
                        staffBasicWork.setWorkNo((String)number);
                        continue block64;
                    }
                    case 1: {
                        String realName;
                        try {
                            realName = cell.getStringCellValue().trim();
                        }
                        catch (Exception e) {
                            data.setState(ResponseStateEnum.warning);
                            data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u59d3\u540d\u683c\u5f0f\u4e0d\u5bf9");
                            return data;
                        }
                        staffBasicInfo.setRealName(realName);
                        continue block64;
                    }
                    case 2: {
                        String dept;
                        try {
                            dept = cell.getStringCellValue().trim();
                        }
                        catch (Exception e) {
                            data.setState(ResponseStateEnum.warning);
                            data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u90e8\u95e8/\u8f66\u95f4\u683c\u5f0f\u4e0d\u5bf9");
                            return data;
                        }
                        if (staffInfoImportVo.getDeptMap().get(dept) == null) {
                            staffInfoImportVo.getDeptMap().put(dept, dept);
                        }
                        staffBasicWork.setOrgName(dept);
                        continue block64;
                    }
                    case 3: {
                        String work;
                        try {
                            work = cell.getStringCellValue().trim();
                        }
                        catch (Exception e) {
                            data.setState(ResponseStateEnum.warning);
                            data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ",\u5c97\u4f4d/\u5de5\u79cd\u683c\u5f0f\u4e0d\u5bf9");
                            return data;
                        }
                        if (staffInfoImportVo.getWorkroleMap().get(work) == null) {
                            staffInfoImportVo.getWorkroleMap().put(work, work);
                        }
                        currentStaffWorkRole.setCurrentWorkName(work);
                        continue block64;
                    }
                    case 4: {
                        String gender;
                        try {
                            gender = cell.getStringCellValue().trim();
                        }
                        catch (Exception e) {
                            data.setState(ResponseStateEnum.warning);
                            data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u6027\u522b\u683c\u5f0f\u4e0d\u5bf9");
                            return data;
                        }
                        if (gender.equals("\u7537")) {
                            staffBasicInfo.setGender(Byte.valueOf(StaffGenderEnum.MALE.getValue().byteValue()));
                            continue block64;
                        }
                        if (gender.equals("\u5973")) {
                            staffBasicInfo.setGender(Byte.valueOf(StaffGenderEnum.FEMALE.getValue().byteValue()));
                            continue block64;
                        }
                        data.setState(ResponseStateEnum.warning);
                        data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u6027\u522b\u683c\u5f0f\u4e0d\u5bf9");
                        return data;
                    }
                    case 5: {
                        Object phone;
                        try {
                            phone = cell.getStringCellValue().trim();
                            staffBasicInfo.setMobile((String)phone);
                            continue block64;
                        }
                        catch (Exception e2) {
                            try {
                                phone = df.format(cell.getNumericCellValue());
                                staffBasicInfo.setMobile((String)phone);
                                continue block64;
                            }
                            catch (Exception e) {
                                data.setState(ResponseStateEnum.warning);
                                data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u624b\u673a\u53f7\u7801\u683c\u5f0f\u4e0d\u5bf9");
                                return data;
                            }
                        }
                    }
                    case 6: {
                        try {
                            String idcard = cell.getStringCellValue();
                            idcard = idcard.trim();
                            if (!IDCardUtil.isIDCard((String)idcard)) {
                                data.setState(ResponseStateEnum.warning);
                                data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u8eab\u4efd\u8bc1\u53f7\u683c\u5f0f\u4e0d\u5bf9");
                                return data;
                            }
                            staffBasicInfo.setIdCard(idcard);
                            Object birth = "19000101";
                            birth = idcard.length() == 15 ? "19" + idcard.substring(6, 12) : idcard.substring(6, 14);
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
                            Date birthday = null;
                            birthday = sdf.parse((String)birth);
                            staffBasicInfo.setBirthday(birthday);
                            String birthYear = ((String)birth).substring(0, 4);
                            SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy");
                            Date date = new Date();
                            String year = sdf1.format(date);
                            int age = Integer.parseInt(year) - Integer.parseInt(birthYear);
                            staffBasicInfo.setAge(Integer.valueOf(age));
                            continue block64;
                        }
                        catch (Exception e) {
                            data.setState(ResponseStateEnum.warning);
                            data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u8eab\u4efd\u8bc1\u53f7\u683c\u5f0f\u4e0d\u5bf9");
                            return data;
                        }
                    }
                    case 7: {
                        try {
                            String workStatus = cell.getStringCellValue().trim();
                            if (StaffWorkStatusEnum.ONWORKING.getName().equals(workStatus)) {
                                currentStaffWorkRole.setStatus(StaffWorkStatusEnum.ONWORKING.getValue());
                                continue block64;
                            }
                            if (StaffWorkStatusEnum.NOWORKED.getName().equals(workStatus)) {
                                currentStaffWorkRole.setStatus(StaffWorkStatusEnum.NOWORKED.getValue());
                                continue block64;
                            }
                            if (!StaffWorkStatusEnum.FURLOUGH.getName().equals(workStatus)) continue block64;
                            currentStaffWorkRole.setStatus(StaffWorkStatusEnum.FURLOUGH.getValue());
                            continue block64;
                        }
                        catch (Exception e) {
                            data.setState(ResponseStateEnum.warning);
                            data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u5c97\u4f4d\u72b6\u6001\u683c\u5f0f\u4e0d\u5bf9");
                            return data;
                        }
                    }
                    case 8: {
                        String job;
                        try {
                            job = cell.getStringCellValue().trim();
                        }
                        catch (Exception e) {
                            data.setState(ResponseStateEnum.warning);
                            data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u516c\u53f8\u804c\u52a1\u683c\u5f0f\u4e0d\u5bf9");
                            return data;
                        }
                        staffBasicWork.setJobTitle(job);
                        continue block64;
                    }
                    case 9: {
                        try {
                            staffBasicInfo.setNativePlace(cell.getStringCellValue().trim());
                            continue block64;
                        }
                        catch (Exception e) {
                            data.setState(ResponseStateEnum.warning);
                            data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u7c4d\u8d2f\u683c\u5f0f\u4e0d\u5bf9");
                            return data;
                        }
                    }
                    case 10: {
                        try {
                            staffBasicInfo.setNation(cell.getStringCellValue().trim());
                            continue block64;
                        }
                        catch (Exception e) {
                            data.setState(ResponseStateEnum.warning);
                            data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u6c11\u65cf\u683c\u5f0f\u4e0d\u5bf9");
                            return data;
                        }
                    }
                    case 11: {
                        String marriage;
                        try {
                            marriage = cell.getStringCellValue().trim();
                        }
                        catch (Exception e) {
                            data.setState(ResponseStateEnum.warning);
                            data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u5a5a\u59fb\u72b6\u51b5\u683c\u5f0f\u4e0d\u5bf9");
                            return data;
                        }
                        if (StaffMaritalStatusEnum.MARRIED.getName().equals(marriage)) {
                            staffBasicInfo.setMaritalStatus(StaffMaritalStatusEnum.MARRIED.getCode());
                            continue block64;
                        }
                        if (StaffMaritalStatusEnum.UNMARRIED.getName().equals(marriage)) {
                            staffBasicInfo.setMaritalStatus(StaffMaritalStatusEnum.UNMARRIED.getCode());
                            continue block64;
                        }
                        if (StaffMaritalStatusEnum.DISSOCIATON.getName().equals(marriage)) {
                            staffBasicInfo.setMaritalStatus(StaffMaritalStatusEnum.DISSOCIATON.getCode());
                            continue block64;
                        }
                        data.setState(ResponseStateEnum.warning);
                        data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u5a5a\u59fb\u72b6\u51b5\u683c\u5f0f\u4e0d\u5bf9");
                        return data;
                    }
                    case 12: {
                        try {
                            Object collage = cell.getCellType() == CellType.NUMERIC ? "" + cell.getNumericCellValue() : cell.getStringCellValue();
                            SysParamModel sysParam = this.sysParamProvideService.getSysParamByName((String)collage, cid, SysParamGroupEnum.educ_background);
                            if (sysParam == null) continue block64;
                            staffBasicInfo.setEducation(sysParam.getId());
                            continue block64;
                        }
                        catch (Exception e) {
                            data.setState(ResponseStateEnum.warning);
                            data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u5b66\u5386\u683c\u5f0f\u4e0d\u5bf9");
                            return data;
                        }
                    }
                    case 13: {
                        try {
                            Object major = cell.getCellType() == CellType.NUMERIC ? "" + cell.getNumericCellValue() : cell.getStringCellValue();
                            staffBasicInfo.setMajor((String)major);
                            continue block64;
                        }
                        catch (Exception e) {
                            data.setState(ResponseStateEnum.warning);
                            data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u4e13\u4e1a\u683c\u5f0f\u4e0d\u5bf9");
                            return data;
                        }
                    }
                    case 14: {
                        if (cell == null || cell.getCellType() == CellType.BLANK) continue block64;
                        StaffInfoServiceImpl.dateHandle(cell);
                        if (cell.getCellType() == CellType.BLANK) {
                            data.setState(ResponseStateEnum.warning);
                            data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u8fdb\u5382\u65f6\u95f4\u683c\u5f0f\u4e0d\u5bf9");
                            return data;
                        }
                        staffBasicWork.setJoinTime(cell.getDateCellValue());
                        continue block64;
                    }
                    case 15: {
                        if (cell == null || cell.getCellType() == CellType.BLANK) continue block64;
                        StaffInfoServiceImpl.dateHandle(cell);
                        if (cell.getCellType() == CellType.BLANK) {
                            data.setState(ResponseStateEnum.warning);
                            data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ",\u53c2\u52a0\u5de5\u4f5c\u65f6\u95f4\u683c\u5f0f\u4e0d\u5bf9");
                            return data;
                        }
                        staffBasicWork.setWorkTime(cell.getDateCellValue());
                        continue block64;
                    }
                    case 16: {
                        String isRadiation;
                        try {
                            isRadiation = cell.getStringCellValue().trim();
                        }
                        catch (Exception e) {
                            data.setState(ResponseStateEnum.warning);
                            data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u662f\u5426\u662f\u5426\u653e\u5c04\u4eba\u5458\u683c\u5f0f\u4e0d\u5bf9");
                            return data;
                        }
                        if (isRadiation.equals("\u662f")) {
                            staffBasicWork.setIsRadiation(Global.TRUE);
                            continue block64;
                        }
                        if (isRadiation.equals("\u5426")) {
                            staffBasicWork.setIsRadiation(Global.FALSE);
                            continue block64;
                        }
                        data.setState(ResponseStateEnum.warning);
                        data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u662f\u5426\u662f\u5426\u653e\u5c04\u4eba\u5458\u683c\u5f0f\u4e0d\u5bf9");
                        return data;
                    }
                    case 17: {
                        if (cell == null || cell.getCellType() == CellType.BLANK) continue block64;
                        StaffInfoServiceImpl.dateHandle(cell);
                        if (cell.getCellType() == CellType.BLANK) {
                            data.setState(ResponseStateEnum.warning);
                            data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ",  \u5916\u5c04\u5de5\u4f5c\u5f00\u59cb\u65f6\u95f4\u683c\u5f0f\u4e0d\u5bf9");
                            return data;
                        }
                        staffBasicWork.setRadiationYear(cell.getDateCellValue());
                        continue block64;
                    }
                    case 18: {
                        try {
                            String type2 = cell.getStringCellValue().trim();
                            SysParamModel sysParam = null;
                            if (StringUtils.isNotEmpty((String)type2)) {
                                String[] strs = type2.split(" ");
                                sysParam = this.sysParamProvideService.getSysParamByNameGroupCode(strs[1], cid, SysParamGroupEnum.occup_exposure_workingtype, strs[0]);
                            }
                            if (sysParam == null) continue block64;
                            staffBasicWork.setRadiationType(sysParam.getId());
                            continue block64;
                        }
                        catch (Exception e) {
                            data.setState(ResponseStateEnum.warning);
                            data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ",  \u804c\u4e1a\u7167\u5c04\u804c\u4e1a\u5206\u7c7b\u683c\u5f0f\u4e0d\u5bf9");
                            return data;
                        }
                    }
                    case 19: {
                        SysParamModel sysParam;
                        String type;
                        try {
                            type = cell.getStringCellValue().trim();
                            sysParam = this.sysParamProvideService.getSysParamByName(type, cid, SysParamGroupEnum.spec_operation_type);
                            if (sysParam == null) continue block64;
                            staffBasicWork.setSpecialOperations(sysParam.getId());
                            continue block64;
                        }
                        catch (Exception e) {
                            data.setState(ResponseStateEnum.warning);
                            data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ",  \u7279\u79cd\u4f5c\u4e1a\u7c7b\u578b\u683c\u5f0f\u4e0d\u5bf9");
                            return data;
                        }
                    }
                    case 20: {
                        SysParamModel sysParam;
                        String type;
                        try {
                            type = cell.getStringCellValue().trim();
                            sysParam = this.sysParamProvideService.getSysParamByName(type, cid, SysParamGroupEnum.spec_working_type);
                            if (sysParam == null) continue block64;
                            staffBasicWork.setSpecialWork(sysParam.getId());
                            continue block64;
                        }
                        catch (Exception e) {
                            data.setState(ResponseStateEnum.warning);
                            data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ",  \u7279\u79cd\u4f5c\u4e1a\u7c7b\u578b\u683c\u5f0f\u4e0d\u5bf9");
                            return data;
                        }
                    }
                }
            }
            staffInfoImportVo.getStaffInfoList().add(staffInfo);
            staffInfoImportVo.getStaffBasicInfoList().add(staffBasicInfo);
            staffInfoImportVo.getStaffBasicWorkList().add(staffBasicWork);
            staffInfoImportVo.getCurrentStaffWorkRoleList().add(currentStaffWorkRole);
        }
        data.setResult((Object)staffInfoImportVo);
        data.setState(ResponseStateEnum.success);
        data.setContent("\u5bfc\u5165\u6210\u529f");
        return data;
    }

    private ResponseData<StaffInfoImportVo> parseStaffInfromExcelForThird(HSSFSheet sheet, Long cid, StaffExcelSheetNameEnum outsource) {
        Long basicId = 1L;
        int rowIndex = 0;
        DecimalFormat df = new DecimalFormat("###########");
        ResponseData data = new ResponseData();
        StaffInfoImportVo staffInfoImportVo = new StaffInfoImportVo();
        Iterator iter = sheet.rowIterator();
        while (iter.hasNext()) {
            Row row = (Row)iter.next();
            if (++rowIndex == 1) continue;
            if (!(row.getCell(7) != null && row.getCell(7).getCellType() != CellType.BLANK || row.getCell(2) != null && row.getCell(2).getCellType() != CellType.BLANK || row.getCell(0) != null && row.getCell(0).getCellType() != CellType.BLANK || row.getCell(3) != null && row.getCell(3).getCellType() != CellType.BLANK || row.getCell(4) != null && row.getCell(4).getCellType() != CellType.BLANK || row.getCell(5) != null && row.getCell(5).getCellType() != CellType.BLANK || row.getCell(8) != null && row.getCell(8).getCellType() != CellType.BLANK || row.getCell(6) != null && row.getCell(6).getCellType() != CellType.BLANK)) {
                if (row.getCell(1) != null) {
                    row.getCell(1).setCellType(CellType.BLANK);
                }
                if (!(row.getCell(1) != null && StringUtils.isNotEmpty((String)row.getCell(1).getStringCellValue()) || row.getCell(9) != null && StringUtils.isNotEmpty((String)row.getCell(9).getStringCellValue()) || row.getCell(10) != null && StringUtils.isNotEmpty((String)row.getCell(10).getStringCellValue()) || row.getCell(11) != null && StringUtils.isNotEmpty((String)row.getCell(11).getStringCellValue()) || row.getCell(13) != null && StringUtils.isNotEmpty((String)row.getCell(13).getStringCellValue()) || row.getCell(14) != null && StringUtils.isNotEmpty((String)row.getCell(14).getStringCellValue()) || row.getCell(15) != null && StringUtils.isNotEmpty((String)row.getCell(15).getStringCellValue()) || row.getCell(16) != null && StringUtils.isNotEmpty((String)row.getCell(16).getStringCellValue()) || row.getCell(17) != null && StringUtils.isNotEmpty((String)row.getCell(17).getStringCellValue()) || row.getCell(18) != null && StringUtils.isNotEmpty((String)row.getCell(18).getStringCellValue()) || row.getCell(19) != null && StringUtils.isNotEmpty((String)row.getCell(19).getStringCellValue()) || row.getCell(21) != null && StringUtils.isNotEmpty((String)row.getCell(21).getStringCellValue())) && (row.getCell(20) == null || !StringUtils.isNotEmpty((String)row.getCell(20).getStringCellValue()))) continue;
                data.setState(ResponseStateEnum.warning);
                data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(1) + ", \u6d3e\u9063\u4f01\u4e1a\u540d\u79f0\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a");
                return data;
            }
            StaffBasicInfo staffBasicInfo = new StaffBasicInfo();
            Long l = basicId;
            basicId = basicId + 1L;
            staffBasicInfo.setId(l);
            StaffInfo staffInfo = new StaffInfo();
            staffInfo.setId(staffBasicInfo.getId());
            staffInfo.setOutsource(outsource.getVal());
            staffInfo.setStaffBasicId(staffBasicInfo.getId());
            staffInfo.setIsThirdParty(Global.TRUE);
            StaffBasicWork staffBasicWork = new StaffBasicWork();
            staffBasicWork.setId(staffBasicInfo.getId());
            staffBasicWork.setStaffId(staffInfo.getId());
            StaffWorkRole currentStaffWorkRole = new StaffWorkRole();
            currentStaffWorkRole.setId(staffBasicInfo.getId());
            currentStaffWorkRole.setStaffId(staffInfo.getId());
            currentStaffWorkRole.setIsHistory(Global.FALSE);
            currentStaffWorkRole.setWorkProperty(StaffWorkPropertyEnum.MAJOR.getValue());
            currentStaffWorkRole.setIsThirdParty(Global.FALSE);
            int cellCount = 22;
            int colIndex = 0;
            block67: for (int i = 0; i < cellCount; ++i) {
                Cell cell = row.getCell(i);
                ++colIndex;
                if (cell == null || cell.getCellType() == CellType.BLANK) {
                    if (i == 0) {
                        data.setState(ResponseStateEnum.warning);
                        data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u6d3e\u9063\u4f01\u4e1a\u540d\u79f0\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a");
                        return data;
                    }
                    if (i == 2) {
                        data.setState(ResponseStateEnum.warning);
                        data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u59d3\u540d\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a");
                        return data;
                    }
                    if (i == 3) {
                        data.setState(ResponseStateEnum.warning);
                        data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u90e8\u95e8/\u8f66\u95f4\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a");
                        return data;
                    }
                    if (i == 4) {
                        data.setState(ResponseStateEnum.warning);
                        data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u5c97\u4f4d/\u5de5\u79cd\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a");
                        return data;
                    }
                    if (i == 5) {
                        data.setState(ResponseStateEnum.warning);
                        data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u6027\u522b\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a");
                        return data;
                    }
                    if (i == 6) {
                        data.setState(ResponseStateEnum.warning);
                        data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u624b\u673a\u53f7\u7801\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a");
                        return data;
                    }
                    if (i == 7) {
                        data.setState(ResponseStateEnum.warning);
                        data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u8eab\u4efd\u8bc1\u53f7\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a");
                        return data;
                    }
                    if (i != 8) continue;
                    data.setState(ResponseStateEnum.warning);
                    data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u5c97\u4f4d\u72b6\u6001\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a");
                    return data;
                }
                switch (i) {
                    case 0: {
                        String company = null;
                        try {
                            company = cell.getStringCellValue().trim();
                        }
                        catch (Exception e) {
                            data.setState(ResponseStateEnum.warning);
                            data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u6d3e\u9063\u516c\u53f8\u683c\u5f0f\u4e0d\u5bf9");
                            return data;
                        }
                        staffInfo.setOtherCompany(company);
                        continue block67;
                    }
                    case 1: {
                        Object number;
                        try {
                            number = cell.getStringCellValue().trim();
                        }
                        catch (Exception e2) {
                            try {
                                number = df.format(cell.getNumericCellValue());
                            }
                            catch (Exception e) {
                                data.setState(ResponseStateEnum.warning);
                                data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u5de5\u53f7\u683c\u5f0f\u4e0d\u5bf9");
                                return data;
                            }
                        }
                        staffBasicWork.setWorkNo((String)number);
                        continue block67;
                    }
                    case 2: {
                        String realname;
                        try {
                            realname = cell.getStringCellValue().trim();
                        }
                        catch (Exception e) {
                            data.setState(ResponseStateEnum.warning);
                            data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u59d3\u540d\u683c\u5f0f\u4e0d\u5bf9");
                            return data;
                        }
                        staffBasicInfo.setRealName(realname);
                        continue block67;
                    }
                    case 3: {
                        String dept = null;
                        try {
                            dept = cell.getStringCellValue().trim();
                        }
                        catch (Exception e) {
                            data.setState(ResponseStateEnum.warning);
                            data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u90e8\u95e8/\u8f66\u95f4\u683c\u5f0f\u4e0d\u5bf9");
                            return data;
                        }
                        if (staffInfoImportVo.getDeptMap().get(dept) == null) {
                            staffInfoImportVo.getDeptMap().put(dept, dept);
                        }
                        staffBasicWork.setOrgName(dept);
                        continue block67;
                    }
                    case 4: {
                        String work;
                        try {
                            work = cell.getStringCellValue().trim();
                        }
                        catch (Exception e) {
                            data.setState(ResponseStateEnum.warning);
                            data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ",\u5c97\u4f4d/\u5de5\u79cd\u683c\u5f0f\u4e0d\u5bf9");
                            return data;
                        }
                        if (staffInfoImportVo.getWorkroleMap().get(work) == null) {
                            staffInfoImportVo.getWorkroleMap().put(work, work);
                        }
                        currentStaffWorkRole.setCurrentWorkName(work);
                        continue block67;
                    }
                    case 5: {
                        String gender;
                        try {
                            gender = cell.getStringCellValue().trim();
                        }
                        catch (Exception e) {
                            data.setState(ResponseStateEnum.warning);
                            data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u6027\u522b\u683c\u5f0f\u4e0d\u5bf9");
                            return data;
                        }
                        if (gender.equals("\u7537")) {
                            staffBasicInfo.setGender(Byte.valueOf(StaffGenderEnum.MALE.getValue().byteValue()));
                            continue block67;
                        }
                        if (gender.equals("\u5973")) {
                            staffBasicInfo.setGender(Byte.valueOf(StaffGenderEnum.FEMALE.getValue().byteValue()));
                            continue block67;
                        }
                        data.setState(ResponseStateEnum.warning);
                        data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u6027\u522b\u683c\u5f0f\u4e0d\u5bf9");
                        return data;
                    }
                    case 6: {
                        Object phone;
                        try {
                            phone = cell.getStringCellValue().trim();
                            staffBasicInfo.setMobile((String)phone);
                            continue block67;
                        }
                        catch (Exception e2) {
                            try {
                                phone = df.format(cell.getNumericCellValue());
                                staffBasicInfo.setMobile((String)phone);
                                continue block67;
                            }
                            catch (Exception e) {
                                data.setState(ResponseStateEnum.warning);
                                data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u624b\u673a\u53f7\u7801\u683c\u5f0f\u4e0d\u5bf9");
                                return data;
                            }
                        }
                    }
                    case 7: {
                        try {
                            String idcard = cell.getStringCellValue();
                            idcard = idcard.trim();
                            if (!IDCardUtil.isIDCard((String)idcard)) {
                                data.setState(ResponseStateEnum.warning);
                                data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u8eab\u4efd\u8bc1\u53f7\u683c\u5f0f\u4e0d\u5bf9");
                                return data;
                            }
                            staffBasicInfo.setIdCard(idcard);
                            Object birth = "19000101";
                            birth = idcard.length() == 15 ? "19" + idcard.substring(6, 12) : idcard.substring(6, 14);
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
                            Date birthday = null;
                            birthday = sdf.parse((String)birth);
                            staffBasicInfo.setBirthday(birthday);
                            String birthYear = ((String)birth).substring(0, 4);
                            SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy");
                            Date date = new Date();
                            String year = sdf1.format(date);
                            int age = Integer.parseInt(year) - Integer.parseInt(birthYear);
                            staffBasicInfo.setAge(Integer.valueOf(age));
                            continue block67;
                        }
                        catch (Exception e) {
                            data.setState(ResponseStateEnum.warning);
                            data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u8eab\u4efd\u8bc1\u53f7\u683c\u5f0f\u4e0d\u5bf9");
                            return data;
                        }
                    }
                    case 8: {
                        try {
                            String workStatus = cell.getStringCellValue().trim();
                            if (StaffWorkStatusEnum.ONWORKING.getName().equals(workStatus)) {
                                currentStaffWorkRole.setStatus(StaffWorkStatusEnum.ONWORKING.getValue());
                            } else if (StaffWorkStatusEnum.NOWORKED.getName().equals(workStatus)) {
                                currentStaffWorkRole.setStatus(StaffWorkStatusEnum.NOWORKED.getValue());
                            } else if (StaffWorkStatusEnum.FURLOUGH.getName().equals(workStatus)) {
                                currentStaffWorkRole.setStatus(StaffWorkStatusEnum.FURLOUGH.getValue());
                            }
                        }
                        catch (Exception e) {
                            data.setState(ResponseStateEnum.warning);
                            data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u5c97\u4f4d\u72b6\u6001\u683c\u5f0f\u4e0d\u5bf9");
                            return data;
                        }
                    }
                    case 9: {
                        String job;
                        try {
                            job = cell.getStringCellValue().trim();
                        }
                        catch (Exception e) {
                            data.setState(ResponseStateEnum.warning);
                            data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u516c\u53f8\u804c\u52a1\u683c\u5f0f\u4e0d\u5bf9");
                            return data;
                        }
                        staffBasicWork.setJobTitle(job);
                        continue block67;
                    }
                    case 10: {
                        try {
                            staffBasicInfo.setNativePlace(cell.getStringCellValue().trim());
                            continue block67;
                        }
                        catch (Exception e) {
                            data.setState(ResponseStateEnum.warning);
                            data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u7c4d\u8d2f\u683c\u5f0f\u4e0d\u5bf9");
                            return data;
                        }
                    }
                    case 11: {
                        try {
                            staffBasicInfo.setNation(cell.getStringCellValue().trim());
                            continue block67;
                        }
                        catch (Exception e) {
                            data.setState(ResponseStateEnum.warning);
                            data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u6c11\u65cf\u683c\u5f0f\u4e0d\u5bf9");
                            return data;
                        }
                    }
                    case 12: {
                        String marriage;
                        try {
                            marriage = cell.getStringCellValue().trim();
                        }
                        catch (Exception e) {
                            data.setState(ResponseStateEnum.warning);
                            data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u5a5a\u59fb\u72b6\u51b5\u683c\u5f0f\u4e0d\u5bf9");
                            return data;
                        }
                        if (StaffMaritalStatusEnum.MARRIED.getName().equals(marriage)) {
                            staffBasicInfo.setMaritalStatus(StaffMaritalStatusEnum.MARRIED.getCode());
                            continue block67;
                        }
                        if (StaffMaritalStatusEnum.UNMARRIED.getName().equals(marriage)) {
                            staffBasicInfo.setMaritalStatus(StaffMaritalStatusEnum.UNMARRIED.getCode());
                            continue block67;
                        }
                        if (StaffMaritalStatusEnum.DISSOCIATON.getName().equals(marriage)) {
                            staffBasicInfo.setMaritalStatus(StaffMaritalStatusEnum.DISSOCIATON.getCode());
                            continue block67;
                        }
                        data.setState(ResponseStateEnum.warning);
                        data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u5a5a\u59fb\u72b6\u51b5\u683c\u5f0f\u4e0d\u5bf9");
                        return data;
                    }
                    case 13: {
                        try {
                            Object collage = cell.getCellType() == CellType.NUMERIC ? "" + cell.getNumericCellValue() : cell.getStringCellValue();
                            SysParamModel sysParam = this.sysParamProvideService.getSysParamByName((String)collage, cid, SysParamGroupEnum.educ_background);
                            if (sysParam == null) continue block67;
                            staffBasicInfo.setEducation(sysParam.getId());
                            continue block67;
                        }
                        catch (Exception e) {
                            data.setState(ResponseStateEnum.warning);
                            data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u5b66\u5386\u683c\u5f0f\u4e0d\u5bf9");
                            return data;
                        }
                    }
                    case 14: {
                        try {
                            Object major = cell.getCellType() == CellType.NUMERIC ? "" + cell.getNumericCellValue() : cell.getStringCellValue();
                            staffBasicInfo.setMajor((String)major);
                            continue block67;
                        }
                        catch (Exception e) {
                            data.setState(ResponseStateEnum.warning);
                            data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u4e13\u4e1a\u683c\u5f0f\u4e0d\u5bf9");
                            return data;
                        }
                    }
                    case 15: {
                        if (cell == null || cell.getCellType() == CellType.BLANK) continue block67;
                        StaffInfoServiceImpl.dateHandle(cell);
                        if (cell.getCellType() == CellType.BLANK) {
                            data.setState(ResponseStateEnum.warning);
                            data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u8fdb\u5382\u65f6\u95f4\u683c\u5f0f\u4e0d\u5bf9");
                            return data;
                        }
                        staffBasicWork.setJoinTime(cell.getDateCellValue());
                        continue block67;
                    }
                    case 16: {
                        if (cell == null || cell.getCellType() == CellType.BLANK) continue block67;
                        StaffInfoServiceImpl.dateHandle(cell);
                        if (cell.getCellType() == CellType.BLANK) {
                            data.setState(ResponseStateEnum.warning);
                            data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ",\u53c2\u52a0\u5de5\u4f5c\u65f6\u95f4\u683c\u5f0f\u4e0d\u5bf9");
                            return data;
                        }
                        staffBasicWork.setWorkTime(cell.getDateCellValue());
                        continue block67;
                    }
                    case 17: {
                        String isRadiation;
                        try {
                            isRadiation = cell.getStringCellValue().trim();
                        }
                        catch (Exception e) {
                            data.setState(ResponseStateEnum.warning);
                            data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u662f\u5426\u662f\u5426\u653e\u5c04\u4eba\u5458\u683c\u5f0f\u4e0d\u5bf9");
                            return data;
                        }
                        if (isRadiation.equals("\u662f")) {
                            staffBasicWork.setIsRadiation(Global.TRUE);
                            continue block67;
                        }
                        if (isRadiation.equals("\u5426")) {
                            staffBasicWork.setIsRadiation(Global.FALSE);
                            continue block67;
                        }
                        data.setState(ResponseStateEnum.warning);
                        data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u662f\u5426\u662f\u5426\u653e\u5c04\u4eba\u5458\u683c\u5f0f\u4e0d\u5bf9");
                        return data;
                    }
                    case 18: {
                        if (cell == null || cell.getCellType() == CellType.BLANK) continue block67;
                        StaffInfoServiceImpl.dateHandle(cell);
                        if (cell.getCellType() == CellType.BLANK) {
                            data.setState(ResponseStateEnum.warning);
                            data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ",  \u5916\u5c04\u5de5\u4f5c\u5f00\u59cb\u65f6\u95f4\u683c\u5f0f\u4e0d\u5bf9");
                            return data;
                        }
                        staffBasicWork.setRadiationYear(cell.getDateCellValue());
                        continue block67;
                    }
                    case 19: {
                        try {
                            String type2 = cell.getStringCellValue().trim();
                            SysParamModel sysParam = null;
                            if (StringUtils.isNotEmpty((String)type2)) {
                                String[] strs = type2.split(" ");
                                sysParam = this.sysParamProvideService.getSysParamByNameGroupCode(strs[1], cid, SysParamGroupEnum.occup_exposure_workingtype, strs[0]);
                            }
                            if (sysParam == null) continue block67;
                            staffBasicWork.setRadiationType(sysParam.getId());
                            continue block67;
                        }
                        catch (Exception e) {
                            data.setState(ResponseStateEnum.warning);
                            data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ",  \u804c\u4e1a\u7167\u5c04\u804c\u4e1a\u5206\u7c7b\u683c\u5f0f\u4e0d\u5bf9");
                            return data;
                        }
                    }
                    case 20: {
                        try {
                            String type = cell.getStringCellValue().trim();
                            SysParamModel sysParam = this.sysParamProvideService.getSysParamByName(type, cid, SysParamGroupEnum.spec_operation_type);
                            if (sysParam == null) continue block67;
                            staffBasicWork.setSpecialOperations(sysParam.getId());
                            continue block67;
                        }
                        catch (Exception e) {
                            data.setState(ResponseStateEnum.warning);
                            data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ",  \u7279\u79cd\u4f5c\u4e1a\u7c7b\u578b\u683c\u5f0f\u4e0d\u5bf9");
                            return data;
                        }
                    }
                    case 21: {
                        try {
                            String type3 = cell.getStringCellValue().trim();
                            SysParamModel sysParam = this.sysParamProvideService.getSysParamByName(type3, cid, SysParamGroupEnum.spec_working_type);
                            if (sysParam == null) continue block67;
                            staffBasicWork.setSpecialWork(sysParam.getId());
                            continue block67;
                        }
                        catch (Exception e) {
                            data.setState(ResponseStateEnum.warning);
                            data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ",  \u7279\u79cd\u4f5c\u4e1a\u7c7b\u578b\u683c\u5f0f\u4e0d\u5bf9");
                            return data;
                        }
                    }
                }
            }
            staffInfoImportVo.getStaffInfoList().add(staffInfo);
            staffInfoImportVo.getStaffBasicInfoList().add(staffBasicInfo);
            staffInfoImportVo.getStaffBasicWorkList().add(staffBasicWork);
            staffInfoImportVo.getCurrentStaffWorkRoleList().add(currentStaffWorkRole);
        }
        data.setResult((Object)staffInfoImportVo);
        data.setState(ResponseStateEnum.success);
        data.setContent("\u5bfc\u5165\u6210\u529f");
        return data;
    }

    public ResponseData<StaffInfoImportVo> getStaffBatchInfoFromExcelForThird(String ossfile, Long cid) throws Exception {
        HSSFWorkbook wb = new HSSFWorkbook(ExcelUtil.getInstance().getOssInputStream(ossfile));
        HSSFSheet sheet = wb.getSheetAt(0);
        ResponseData<StaffInfoImportVo> data = this.parseStaffInfromExcelForThird(sheet, cid, StaffExcelSheetNameEnum.THIRDCOMPANY);
        wb.close();
        return data;
    }

    private String getExcelColName(int index) {
        if (index <= 26) {
            return String.valueOf((char)(65 + index - 1));
        }
        int a = index / 26;
        int b = index % 26;
        return String.valueOf((char)(65 + a - 1)) + String.valueOf((char)(65 + b - 1));
    }

    public List<StaffInfo> getStaffInfoListByCid(Long cid) {
        Example e = new Example(StaffInfo.class);
        e.createCriteria().andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("cid", (Object)cid).andNotEqualTo("addFrom", (Object)4);
        return this.staffInfoMapper.selectByExample(e);
    }

    public Integer getStaffInfoCountByCid(Long cid) {
        return this.staffInfoMapper.getStaffCountByCid(cid);
    }

    @Transactional(readOnly=false)
    public StaffInfo addStaffInfoByPlatform(Long cid, UserModel userinfo) {
        StaffInfo staffInfo = new StaffInfo();
        staffInfo.setCid(cid);
        staffInfo.setIsThirdParty(Global.FALSE);
        StaffBasicInfo staffBasicInfo = new StaffBasicInfo();
        staffBasicInfo.setRealName(userinfo.getFullname());
        staffBasicInfo.setCid(cid);
        staffBasicInfo.setIsValid(Global.TRUE);
        staffInfo.setStaffBasicInfo(staffBasicInfo);
        this.addStaffInfoSubmit(staffInfo);
        return staffInfo;
    }

    @Transactional(readOnly=false)
    public Map<String, Object> batchImportStaffInfoForThirdTime(StaffInfoImportVo vo, Long loginStaffId, Long cid) {
        Map deptMap = vo.getDeptMap();
        HashMap<String, CompanyOrganization> newOrgMap = new HashMap<String, CompanyOrganization>();
        for (String name : deptMap.keySet()) {
            List cos = this.companyOrganizationService.getListByName(name, cid);
            if (cos != null && cos.size() > 0) {
                newOrgMap.put(name, (CompanyOrganization)cos.get(0));
                continue;
            }
            CompanyOrganization co = new CompanyOrganization();
            co.setOrganizationName(name);
            this.companyOrganizationService.add((Object)co, loginStaffId, cid);
            newOrgMap.put(name, co);
        }
        Map workMap = vo.getWorkroleMap();
        HashMap<String, WorkRoleInfo> newWorkMap = new HashMap<String, WorkRoleInfo>();
        for (String work : workMap.keySet()) {
            WorkRoleInfo workRoleInfo = this.workRoleInfoService.getWorkRoleInfoByName(work, cid);
            if (workRoleInfo != null) {
                newWorkMap.put(work, workRoleInfo);
                continue;
            }
            workRoleInfo = new WorkRoleInfo();
            workRoleInfo.setWorkName(work);
            this.workRoleInfoService.add((Object)workRoleInfo, loginStaffId, cid);
            newWorkMap.put(work, workRoleInfo);
        }
        List staffInfoList = vo.getStaffInfoList();
        List staffBasicInfoList = vo.getStaffBasicInfoList();
        List staffBasicWorkList = vo.getStaffBasicWorkList();
        List currentStaffWorkRoleList = vo.getCurrentStaffWorkRoleList();
        HashMap<CallSite, StaffInfo> staffInfoMap = new HashMap<CallSite, StaffInfo>();
        HashMap<CallSite, StaffBasicInfo> staffBasicInfoMap = new HashMap<CallSite, StaffBasicInfo>();
        HashMap<CallSite, StaffBasicWork> staffBasicWorkMap = new HashMap<CallSite, StaffBasicWork>();
        HashMap<CallSite, StaffWorkRole> staffWorkRoleWorkMap = new HashMap<CallSite, StaffWorkRole>();
        for (StaffBasicInfo staffBasicInfo : staffBasicInfoList) {
            staffBasicInfoMap.put((CallSite)((Object)("" + staffBasicInfo.getId())), staffBasicInfo);
        }
        for (StaffInfo staffInfo : staffInfoList) {
            staffInfoMap.put((CallSite)((Object)("" + staffInfo.getId())), staffInfo);
        }
        for (StaffBasicWork staffBasicWork : staffBasicWorkList) {
            staffBasicWorkMap.put((CallSite)((Object)("" + staffBasicWork.getId())), staffBasicWork);
        }
        for (StaffWorkRole staffWorkRole : currentStaffWorkRoleList) {
            staffWorkRoleWorkMap.put((CallSite)((Object)("" + staffWorkRole.getId())), staffWorkRole);
        }
        ArrayList<StaffBasicInfo> noImportStaffBasicInfos = new ArrayList<StaffBasicInfo>();
        ArrayList staffBasicInfoIds = new ArrayList(staffBasicInfoMap.keySet());
        ArrayList<StaffInfo> noImportStaffInfos = new ArrayList<StaffInfo>();
        for (String id : staffBasicInfoIds) {
            StaffBasicInfo staffBasicInfo = (StaffBasicInfo)staffBasicInfoMap.get(id);
            StaffBasicInfo staffBasicInfoFromBase = this.staffBasicInfoService.getStaffBasicInfoByIdCard(staffBasicInfo.getIdCard(), null, cid);
            if (staffBasicInfoFromBase != null) {
                noImportStaffBasicInfos.add(staffBasicInfo);
                noImportStaffInfos.addAll(this.getStaffInfoListByStaffBasicInfoId(staffBasicInfo.getId()));
                staffBasicInfoMap.remove(id);
                staffInfoMap.remove(id);
                staffBasicWorkMap.remove(id);
                staffWorkRoleWorkMap.remove(id);
                continue;
            }
            staffBasicInfo.setId(null);
            this.staffBasicInfoService.add((Object)staffBasicInfo, loginStaffId, cid);
            ((StaffInfo)staffInfoMap.get(id)).setStaffBasicId(staffBasicInfo.getId());
        }
        for (String id : staffInfoMap.keySet()) {
            ((StaffInfo)staffInfoMap.get(id)).setId(null);
            this.add((StaffInfo)staffInfoMap.get(id), loginStaffId, cid);
            ((StaffBasicWork)staffBasicWorkMap.get(id)).setId(null);
            ((StaffBasicWork)staffBasicWorkMap.get(id)).setStaffId(((StaffInfo)staffInfoMap.get(id)).getId());
            ((StaffWorkRole)staffWorkRoleWorkMap.get(id)).setStaffId(((StaffInfo)staffInfoMap.get(id)).getId());
            CompanyOrganization co = (CompanyOrganization)newOrgMap.get(((StaffBasicWork)staffBasicWorkMap.get(id)).getOrgName());
            ((StaffBasicWork)staffBasicWorkMap.get(id)).setOrgId(co.getId());
            ((StaffBasicWork)staffBasicWorkMap.get(id)).setId(null);
            this.staffBasicWorkService.add((Object)((StaffBasicWork)staffBasicWorkMap.get(id)), loginStaffId, cid);
            WorkRoleInfo currentWork = (WorkRoleInfo)newWorkMap.get(((StaffWorkRole)staffWorkRoleWorkMap.get(id)).getCurrentWorkName());
            ((StaffWorkRole)staffWorkRoleWorkMap.get(id)).setWorkRoleId(currentWork.getId());
            ((StaffWorkRole)staffWorkRoleWorkMap.get(id)).setId(null);
            this.staffWorkRoleService.add((Object)((StaffWorkRole)staffWorkRoleWorkMap.get(id)), loginStaffId, cid);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("noImportStaffBasicInfos", noImportStaffBasicInfos);
        result.put("successStaffInfo", staffInfoMap.values());
        result.put("noImportStaffInfos", noImportStaffInfos);
        return result;
    }

    public Map<String, ResponseData<StaffInfoImportVo>> getStaffBatchInfoFromExcelForInit(String ossfile, Long cid) throws Exception {
        HSSFWorkbook wb = new HSSFWorkbook(ExcelUtil.getInstance().getOssInputStream(ossfile));
        HashMap<String, ResponseData<StaffInfoImportVo>> map = new HashMap<String, ResponseData<StaffInfoImportVo>>();
        for (int i = 0; i < wb.getNumberOfSheets(); ++i) {
            ResponseData<StaffInfoImportVo> data;
            if (StaffExcelSheetNameEnum.SELFCOMPANY.getName().equals(wb.getSheetAt(i).getSheetName())) {
                data = this.parseStaffInfromExcelForSelf(wb.getSheetAt(i), cid);
                map.put(StaffExcelSheetNameEnum.SELFCOMPANY.getName(), data);
            }
            if (!StaffExcelSheetNameEnum.THIRDCOMPANY.getName().equals(wb.getSheetAt(i).getSheetName())) continue;
            data = this.parseStaffInfromExcelForThird(wb.getSheetAt(i), cid, StaffExcelSheetNameEnum.THIRDCOMPANY);
            map.put(StaffExcelSheetNameEnum.THIRDCOMPANY.getName(), data);
        }
        wb.close();
        return map;
    }

    @Transactional(readOnly=false)
    public void deletestaffInfosNotSelfForInit(Long cid, Long loginStaffId) {
        Example e = new Example(StaffInfo.class);
        e.createCriteria().andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("cid", (Object)cid).andNotEqualTo("id", (Object)loginStaffId);
        List list = this.staffInfoMapper.selectByExample(e);
        for (StaffInfo s : list) {
            this.deleteStaffInfoById(s.getId(), loginStaffId, "\u91cd\u65b0\u5bfc\u5165\u4eba\u5458\u65f6\u5220\u9664");
        }
    }

    @Transactional(readOnly=false)
    public void staffCurrentWorkInfoChangeInform(Long staffInfoId, Long changedWorkId, Date currentWorkLeaveTime, Date nowWorkBeginTime, StaffWorkStatusEnum nowWorkStatus, Long loginStaffId, Long cid) {
        StaffWorkRole oldCurrentStaffWorkRole = this.staffWorkRoleService.getCurrentStaffWorkRoleByStaffId(staffInfoId);
        if (oldCurrentStaffWorkRole != null && !changedWorkId.equals(oldCurrentStaffWorkRole.getWorkRoleId()) && nowWorkStatus.getValue() == StaffWorkStatusEnum.TRANSFER.getValue()) {
            StaffWorkChangeStatusRecordEnum record;
            List localList = this.staffWorkRoleService.getLocalStaffWorkRolesDataByStaffId(staffInfoId);
            for (StaffWorkRole swr : localList) {
                if (swr.getWorkRoleId() != oldCurrentStaffWorkRole.getWorkRoleId() || swr.getBeginTime() != oldCurrentStaffWorkRole.getBeginTime() && (swr.getBeginTime() == null || !swr.getBeginTime().equals(oldCurrentStaffWorkRole.getBeginTime()))) continue;
                this.staffWorkRoleService.delete((Object)swr);
            }
            StaffWorkRole newStaffWorkRole = new StaffWorkRole();
            newStaffWorkRole.setBeginTime(nowWorkBeginTime);
            newStaffWorkRole.setCid(cid);
            newStaffWorkRole.setStaffId(staffInfoId);
            newStaffWorkRole.setIsThirdParty(Global.FALSE);
            newStaffWorkRole.setWorkRoleId(changedWorkId);
            newStaffWorkRole.setWorkProperty(StaffWorkPropertyEnum.MAJOR.getValue());
            newStaffWorkRole.setIsHistory(Global.FALSE);
            newStaffWorkRole.setStatus(StaffWorkStatusEnum.ONWORKING.getValue());
            newStaffWorkRole.setCreateBy(loginStaffId);
            this.staffWorkRoleService.add((Object)newStaffWorkRole, loginStaffId, cid);
            StaffWorkRole curHistoryStaffWorkRole = new StaffWorkRole();
            curHistoryStaffWorkRole.setCid(cid);
            curHistoryStaffWorkRole.setBeginTime(newStaffWorkRole.getBeginTime());
            curHistoryStaffWorkRole.setIsHistory(Boolean.valueOf(true));
            curHistoryStaffWorkRole.setIsThirdParty(newStaffWorkRole.getIsThirdParty());
            curHistoryStaffWorkRole.setLeaveTime(newStaffWorkRole.getLeaveTime());
            curHistoryStaffWorkRole.setStaffId(newStaffWorkRole.getStaffId());
            curHistoryStaffWorkRole.setStatus(newStaffWorkRole.getStatus());
            curHistoryStaffWorkRole.setWorkProperty(StaffWorkPropertyEnum.WORKED.getValue());
            curHistoryStaffWorkRole.setWorkRoleId(newStaffWorkRole.getWorkRoleId());
            this.staffWorkRoleService.add((Object)curHistoryStaffWorkRole, loginStaffId, cid);
            oldCurrentStaffWorkRole.setWorkProperty(StaffWorkPropertyEnum.WORKED.getValue());
            oldCurrentStaffWorkRole.setIsHistory(Global.TRUE);
            if (!"1".equals("" + oldCurrentStaffWorkRole.getStatus()) && (record = StaffWorkChangeStatusRecordEnum.getThisEnumByFlag((String)(oldCurrentStaffWorkRole.getStatus() + "1"))) != null) {
                StaffInfo staffInfo = new StaffInfo();
                staffInfo.setWorkChangeStatusRecord(record.getValue());
                staffInfo.setId(staffInfoId);
                this.update(staffInfo, loginStaffId);
            }
            oldCurrentStaffWorkRole.setStatus(StaffWorkStatusEnum.TRANSFER.getValue());
            oldCurrentStaffWorkRole.setLeaveTime(currentWorkLeaveTime);
            this.staffWorkRoleService.update((Object)oldCurrentStaffWorkRole, loginStaffId);
        }
        if (nowWorkStatus.getValue() == StaffWorkStatusEnum.NOWORKED.getValue()) {
            // empty if block
        }
    }

    public String getStaffNameByStaffId(Long staffId) {
        StaffBasicInfo bassicInfo;
        if (staffId == null) {
            return null;
        }
        StaffInfo staff = (StaffInfo)super.getById(staffId);
        if (staff != null && staff.getStaffBasicId() != null && (bassicInfo = (StaffBasicInfo)this.staffBasicInfoService.getById(staff.getStaffBasicId())) != null) {
            return bassicInfo.getRealName();
        }
        return null;
    }

    public StaffBasicVo getStaffBasicInfoById(Long staffId) {
        StaffWorkRole staffWorkRole;
        StaffBasicWork staffBasicWork;
        StaffBasicVo vo = new StaffBasicVo();
        vo.setStaffId(staffId);
        StaffInfo staffInfo = (StaffInfo)this.getById(staffId);
        if (staffInfo == null) {
            return vo;
        }
        vo.setCid(staffInfo.getCid());
        if (staffInfo.getStaffBasicId() == null) {
            return vo;
        }
        StaffBasicInfo staffBasicInfo = (StaffBasicInfo)this.staffBasicInfoService.getById(staffInfo.getStaffBasicId());
        if (staffBasicInfo != null) {
            vo.setStaffName(staffBasicInfo.getRealName());
            vo.setBirthday(staffBasicInfo.getBirthday());
            vo.setGender(staffBasicInfo.getGender());
            vo.setMobile(staffBasicInfo.getMobile());
            vo.setIdCard(staffBasicInfo.getIdCard());
        }
        if ((staffBasicWork = this.staffBasicWorkService.getStaffBasicWorkByStaffId(staffId)) != null) {
            vo.setDeptId(staffBasicWork.getOrgId());
            vo.setWorkNo(staffBasicWork.getWorkNo());
            vo.setJobTitle(staffBasicWork.getJobTitle());
            if (staffBasicWork.getCompanyOrganization() != null) {
                vo.setDeptName(staffBasicWork.getCompanyOrganization().getOrganizationName());
            }
        }
        if ((staffWorkRole = this.staffWorkRoleService.getCurrentStaffWorkRoleByStaffId(vo.getStaffId())) != null && staffWorkRole.getWorkRoleInfo() != null) {
            vo.setWorkId(staffWorkRole.getWorkRoleInfo().getId());
            vo.setWorkName(staffWorkRole.getWorkRoleInfo().getWorkName());
            vo.setWorkStatus(staffWorkRole.getStatus());
        }
        return vo;
    }

    public StaffBasicVo getStaffInfoByQuery(Long cid, String staffName, String idCard) {
        StaffBasicVo vo = null;
        StaffQuery query = new StaffQuery();
        if (cid == null || idCard == null) {
            return vo;
        }
        query.setCid(cid);
        query.setStaffName(staffName);
        query.setIdCard(idCard);
        List<StaffBasicVo> vos = ((StaffInfoMapper)this.dao).getStaffInfoByQuery(query);
        if (vos == null || vos.size() == 0) {
            return vo;
        }
        for (StaffBasicVo v : vos) {
            v.setStaffName(SpringEncryptUtils.decrypt((String)v.getStaffName()));
            v.setIdCard(SpringEncryptUtils.decrypt((String)v.getIdCard()));
            if (v.getIsValid() == null || !v.getIsValid().booleanValue()) continue;
            vo = v;
            break;
        }
        if (vo == null) {
            vo = vos.get(0);
            vo.setDeptId(null);
            vo.setDeptName("");
            vo.setWorkNo("");
        }
        if (vo.getStaffId() == null) {
            return null;
        }
        return vo;
    }

    public List<StaffBasicVo> getStaffInfoByIdCard(Long cid, String idCard) {
        if (cid == null || idCard == null) {
            return null;
        }
        StaffQuery query = new StaffQuery();
        query.setCid(cid);
        query.setIdCard(idCard);
        List<StaffBasicVo> vos = ((StaffInfoMapper)this.dao).getStaffInfoByQuery(query);
        if (CollectionUtil.isNotEmpty(vos)) {
            for (StaffBasicVo v : vos) {
                v.setStaffName(SpringEncryptUtils.decrypt((String)v.getStaffName()));
                v.setIdCard(SpringEncryptUtils.decrypt((String)v.getIdCard()));
            }
        }
        return vos;
    }

    @Transactional(readOnly=false)
    public StaffBasicVo getOrAddStaffInfoByQuery(Long cid, String staffName, String idCard, String workName, String harmIds, Byte dataSource) {
        StaffBasicVo vo = null;
        StaffQuery query = new StaffQuery();
        if (cid == null || idCard == null) {
            return vo;
        }
        query.setCid(cid);
        query.setStaffName(staffName);
        query.setIdCard(idCard);
        List<StaffBasicVo> vos = ((StaffInfoMapper)this.dao).getStaffInfoByQuery(query);
        if (vos == null || vos.size() == 0) {
            vo = this.addStaffInfos(null, cid, staffName, idCard, workName, harmIds, dataSource);
            return vo;
        }
        vo = vos.get(0);
        vo.setStaffName(SpringEncryptUtils.decrypt((String)vo.getStaffName()));
        vo.setIdCard(SpringEncryptUtils.decrypt((String)vo.getIdCard()));
        return vo;
    }

    private void updateWorkHarm(String harmIds, WorkRoleInfo work, Long staffId) {
        if (harmIds != null) {
            if (work.getHarmFanctorIds() == null) {
                work.setHarmFanctorIds(harmIds);
            } else {
                List harmIdList = StringUtils.parseToLongList((String)harmIds, (String)",");
                StringBuilder harms = new StringBuilder(work.getHarmFanctorIds());
                List hasHarms = StringUtils.parseToLongList((String)harms.toString(), (String)",");
                for (Long harmId : harmIdList) {
                    if (hasHarms.contains(harmId)) continue;
                    harms.append(",").append(harmId);
                }
                work.setHarmFanctorIds(harms.toString());
            }
            this.workRoleInfoService.update((Object)work, staffId);
        }
    }

    private StaffBasicVo addStaffInfos(Long staffId, Long cid, String staffName, String idCard, String workName, String harmIds, Byte dataSource) {
        StaffBasicInfo basicInfo = new StaffBasicInfo();
        basicInfo.setRealName(staffName);
        basicInfo.setIdCard(idCard);
        basicInfo.setCid(cid);
        basicInfo.setIsValid(Boolean.valueOf(true));
        basicInfo.setUpdateDate(new Date());
        basicInfo.setCreateDate(new Date());
        basicInfo.setDataSource(dataSource);
        if (IDCardUtil.isIDCard((String)idCard)) {
            basicInfo.setAge(Integer.valueOf(IDCardUtil.getAge((String)basicInfo.getIdCard())));
            basicInfo.setGender(IDCardUtil.getGender((String)idCard));
            basicInfo.setBirthday(IDCardUtil.getBirthday((String)idCard));
        }
        this.staffBasicInfoMapper.insertSelective(basicInfo);
        StaffInfo staffInfo = new StaffInfo();
        if (staffId != null) {
            staffInfo.setId(staffId);
        }
        staffInfo.setStaffBasicId(basicInfo.getId());
        staffInfo.setIsValid(Boolean.valueOf(true));
        staffInfo.setCid(cid);
        staffInfo.setIsThirdParty(Boolean.valueOf(false));
        staffInfo.setAddFrom(Integer.valueOf(StaffAddFromEnum.un_known.getValue().byteValue()));
        staffInfo.setUpdateDate(new Date());
        staffInfo.setCreateDate(new Date());
        ((StaffInfoMapper)this.dao).insertSelective(staffInfo);
        StaffBasicWork staffBasicWork = new StaffBasicWork();
        staffBasicWork.setStaffId(staffInfo.getId());
        staffBasicWork.setCid(staffInfo.getCid());
        staffBasicWork.setCreateBy(staffInfo.getCreateBy());
        staffBasicWork.setIsRadiation(Global.FALSE);
        this.staffBasicWorkService.add((Object)staffBasicWork, staffInfo.getCreateBy(), staffInfo.getCid());
        StaffWorkRole staffWorkRole = new StaffWorkRole();
        staffWorkRole.setCid(staffInfo.getCid());
        staffWorkRole.setStaffId(staffInfo.getId());
        staffWorkRole.setWorkProperty(StaffWorkPropertyEnum.MAJOR.getValue());
        staffWorkRole.setStatus(StaffWorkStatusEnum.ONWORKING.getValue());
        staffWorkRole.setIsThirdParty(Global.FALSE);
        staffWorkRole.setIsHistory(Global.FALSE);
        staffWorkRole.setCreateBy(staffInfo.getId());
        this.staffWorkRoleService.add((Object)staffWorkRole, staffInfo.getCreateBy(), staffInfo.getCid());
        StaffBasicVo vo = new StaffBasicVo();
        vo.setStaffId(staffInfo.getId());
        vo.setStaffName(staffName);
        vo.setNew(true);
        return vo;
    }

    public List<StaffhealthDocVo> getStaffhealthDocVoDatasByCid(Long cid) {
        List<StaffInfo> list = this.getStaffInfoListByCid(cid);
        ArrayList<StaffhealthDocVo> vos = new ArrayList<StaffhealthDocVo>();
        for (StaffInfo s : list) {
            StaffOccupationHealth health;
            StaffBasicWork work;
            StaffhealthDocVo vo = new StaffhealthDocVo();
            if (s.getStaffBasicId() != null) {
                StaffBasicInfo basicInfo;
                StaffWorkRole staffWorkRole = this.staffWorkRoleService.getCurrentStaffWorkRoleByStaffId(s.getId());
                if (staffWorkRole != null) {
                    List harmFactorList;
                    if (staffWorkRole.getWorkRoleId() == null || (harmFactorList = this.harmfactorWorkService.getHarmfactorListByWork(cid, staffWorkRole.getWorkRoleId())) == null || harmFactorList.size() == 0) continue;
                    vo.setLeaveTime(staffWorkRole.getLeaveTime());
                }
                if ((basicInfo = (StaffBasicInfo)this.staffBasicInfoService.getById(s.getStaffBasicId())) != null) {
                    vo.setRealName(basicInfo.getRealName());
                    Byte gender = basicInfo.getGender();
                    if (gender != null && StaffGenderEnum.MALE.getValue().byteValue() == basicInfo.getGender().byteValue()) {
                        vo.setGender(StaffGenderEnum.MALE.getName());
                    }
                    if (gender != null && StaffGenderEnum.FEMALE.getValue().byteValue() == basicInfo.getGender().byteValue()) {
                        vo.setGender(StaffGenderEnum.FEMALE.getName());
                    }
                }
            }
            if ((work = this.staffBasicWorkService.getStaffBasicWorkByStaffId(s.getId())) != null && work.getOrgId() != null) {
                vo.setOrgName(this.companyOrganizationService.getOrgNameById(work.getOrgId()));
            }
            if ((health = this.staffOccupationHealthService.getStaffOccupationHealthByStaffId(s.getId())) != null) {
                vo.setDocNo((String)(health.getFileNo() == null ? "ZW-GRJK-" + s.getId() : health.getFileNo()));
                vo.setCreateDocTime(health.getFilingTime() == null ? this.phcPhysicalCheckCountService.getStaffFirstCheckBeginTime(s.getId()) : health.getFilingTime());
            } else {
                vo.setDocNo("ZW-GRJK-" + s.getId());
                vo.setCreateDocTime(this.phcPhysicalCheckCountService.getStaffFirstCheckBeginTime(s.getId()));
            }
            vos.add(vo);
        }
        return vos;
    }

    private List<StaffInfo> getStaffInfoListByStaffBasicInfoId(Long basicId) {
        Example e = new Example(StaffInfo.class);
        e.createCriteria().andEqualTo("staffBasicId", (Object)basicId);
        return this.staffInfoMapper.selectByExample(e);
    }

    @Transactional(readOnly=false)
    public void currentWorkChangeInorm(Long staffInfoId, Long changedWorkId, Date currentWorkLeaveTime, Date nowWorkBeginTime, StaffWorkStatusEnum nowWorkStatus, Long loginStaffId, Long cid) {
        if (nowWorkStatus.getValue() == StaffWorkStatusEnum.ONWORKING.getValue() || nowWorkStatus.getValue() == StaffWorkStatusEnum.TRANSFER.getValue()) {
            NoInformStaff noInformStaff = new NoInformStaff();
            noInformStaff.setChangWorkStatus(nowWorkStatus.getValue());
            noInformStaff.setStaffId(staffInfoId);
            noInformStaff.setWorkInfoId(changedWorkId);
            this.noInformStaffService.add((Object)noInformStaff, loginStaffId, cid);
        }
    }

    public String getStaffNamesByStaffIds(String staffIdStr) {
        if (StringUtils.isEmpty((CharSequence)staffIdStr)) {
            return "";
        }
        String[] ids = staffIdStr.split(",");
        StringBuffer names = new StringBuffer("");
        for (String id : ids) {
            String name;
            if (!StringUtils.isNumber((String)id) || !StringUtils.isNotEmpty((String)(name = this.getStaffNameByStaffId(Long.valueOf(id))))) continue;
            names.append(name);
            names.append(",");
        }
        if (names.length() > 0) {
            names.deleteCharAt(names.lastIndexOf(","));
        }
        return names.toString();
    }

    public StaffDocInfoVo getStaffDocInfoVoByStaffId(Long staffId) {
        StaffBasicWork staffBasicWork;
        StaffDocInfoVo vo = new StaffDocInfoVo();
        StaffInfo staffInfo = (StaffInfo)this.getById(staffId);
        StaffBasicInfo staffBasicInfo = null;
        if (staffInfo != null && staffInfo.getStaffBasicId() != null) {
            staffBasicInfo = (StaffBasicInfo)this.staffBasicInfoService.getById(staffInfo.getStaffBasicId());
        }
        if (staffBasicInfo != null) {
            SysParamModel sysParam;
            if (staffBasicInfo.getEducation() != null && (sysParam = this.sysParamProvideService.getById(staffBasicInfo.getEducation())) != null) {
                vo.setEducationName(sysParam.getParamValue());
            }
            if (staffBasicInfo.getAge() != null) {
                vo.setAge(staffBasicInfo.getAge());
            }
            vo.setFaceId(staffBasicInfo.getFaceId());
            if (staffBasicInfo.getGender() != null) {
                if (staffBasicInfo.getGender().byteValue() == StaffGenderEnum.MALE.getValue().byteValue()) {
                    vo.setGenderName(StaffGenderEnum.MALE.getName());
                } else if (staffBasicInfo.getGender().byteValue() == StaffGenderEnum.FEMALE.getValue().byteValue()) {
                    vo.setGenderName(StaffGenderEnum.FEMALE.getName());
                }
            }
            vo.setHabitSmoke(staffBasicInfo.getHabitSmoke());
            vo.setIdCard(staffBasicInfo.getIdCard());
            if (staffBasicInfo.getMaritalStatus() != null) {
                if (staffBasicInfo.getMaritalStatus() == StaffMaritalStatusEnum.DISSOCIATON.getCode()) {
                    vo.setMarriedInfo(StaffMaritalStatusEnum.DISSOCIATON.getName());
                } else if (staffBasicInfo.getMaritalStatus() == StaffMaritalStatusEnum.MARRIED.getCode()) {
                    vo.setMarriedInfo(StaffMaritalStatusEnum.MARRIED.getName());
                } else if (staffBasicInfo.getMaritalStatus() == StaffMaritalStatusEnum.UNMARRIED.getCode()) {
                    vo.setMarriedInfo(StaffMaritalStatusEnum.UNMARRIED.getName());
                }
            }
            vo.setNativePlace(staffBasicInfo.getNativePlace());
            vo.setRealName(staffBasicInfo.getRealName());
        }
        if ((staffBasicWork = this.staffBasicWorkService.getStaffBasicWorkByStaffId(staffId)) != null) {
            vo.setWorkTime(staffBasicWork.getWorkTime());
            vo.setWorkNo(staffBasicWork.getWorkNo());
        }
        List localWorkHistories = this.staffWorkRoleService.getLocalStaffWorkRolesByStaffId(staffId);
        ArrayList<StaffOccupationAndHarmHistoryVo> list = new ArrayList<StaffOccupationAndHarmHistoryVo>();
        for (Object s : localWorkHistories) {
            StaffOccupationAndHarmHistoryVo v = new StaffOccupationAndHarmHistoryVo();
            v.setStaffWorkRole((StaffWorkRole)s);
            if (s.getWorkRoleId() != null) {
                List infos;
                Object protectiveArticles = "";
                Date leaveTime = s.getLeaveTime();
                if (leaveTime == null) {
                    leaveTime = new Date();
                }
                if ((infos = this.shieldEquipRuleService.getHistoryShieldInfosByWorkId(s.getWorkRoleId(), s.getCid(), leaveTime)) != null && !infos.isEmpty()) {
                    for (int i = 0; i < infos.size(); ++i) {
                        protectiveArticles = StringUtils.isNotEmpty((String)((ShieldWorkRelation)infos.get(i)).getShieldDesc()) ? (String)protectiveArticles + ((ShieldWorkRelation)infos.get(i)).getDetailName() + "-" + ((ShieldWorkRelation)infos.get(i)).getShieldDesc() : (String)protectiveArticles + ((ShieldWorkRelation)infos.get(i)).getDetailName();
                        if (i == infos.size() - 1) continue;
                        protectiveArticles = (String)protectiveArticles + "\uff1b";
                    }
                }
                v.setProtectiveArticles((String)protectiveArticles);
                if ("true".equals(this.isActualize)) {
                    List factorList = this.harmfactorWorkService.getArchiveHarmfactorByWork(s.getCid(), s.getWorkRoleId(), s.getLeaveTime());
                    if (factorList != null && factorList.size() > 0) {
                        HashMap<Long, Long> harmMap = new HashMap<Long, Long>();
                        for (HarmfactorWorkSource harm : factorList) {
                            harmMap.put(harm.getHarmId(), harm.getHarmId());
                        }
                        StringBuilder harmIdStr = null;
                        for (Long hid : harmMap.values()) {
                            if (harmIdStr == null) {
                                harmIdStr = new StringBuilder(hid.toString());
                                continue;
                            }
                            harmIdStr.append(",").append(hid.toString());
                        }
                        if (harmIdStr != null) {
                            v.setHarmNames(this.occupationalRiskFactorsService.getHarmNamesByIds(harmIdStr.toString().toString()));
                        }
                    }
                } else {
                    String factorStrs = "";
                    WorkRoleInfo work = (WorkRoleInfo)this.workRoleInfoService.getById(s.getWorkRoleId());
                    PhcPhysicalCheckDataResult result = this.phcPhysicalCheckDataResultService.getDataResultByStaffId(staffId, work.getWorkName());
                    if (result != null && result.getHarmFactor() != null) {
                        factorStrs = this.occupationalRiskFactorsService.getHarmNamesByIds(result.getHarmFactor());
                    }
                    v.setHarmNames(factorStrs);
                }
            }
            list.add(v);
        }
        List outSideWorkHistories = this.staffWorkRoleService.getOutsideStaffWorkRolesByStaffId(staffId);
        for (StaffWorkRole s : outSideWorkHistories) {
            StaffOccupationAndHarmHistoryVo v = new StaffOccupationAndHarmHistoryVo();
            v.setStaffWorkRole(s);
            list.add(v);
        }
        vo.setStaffOccupationAndHarmHistoryVo(list);
        StaffOccupationHealth staffOccupationHealth = this.staffOccupationHealthService.getStaffOccupationHealthByStaffId(staffId);
        if (staffOccupationHealth != null) {
            vo.setDocNumber(staffOccupationHealth.getFileNo());
            vo.setCreateDocTime(staffOccupationHealth.getFilingTime() == null ? this.phcPhysicalCheckCountService.getStaffFirstCheckBeginTime(staffId) : staffOccupationHealth.getFilingTime());
        } else {
            vo.setDocNumber("ZW-GRJK-" + staffId);
            vo.setCreateDocTime(this.phcPhysicalCheckCountService.getStaffFirstCheckBeginTime(staffId));
        }
        return vo;
    }

    public List<StaffCurrentWorkVo> getStaffCurrentWorkVoByStaffId(Long staffId) {
        ArrayList<StaffCurrentWorkVo> vos = new ArrayList<StaffCurrentWorkVo>();
        List localHistories = this.staffWorkRoleService.getLocalStaffWorkRolesByStaffIdOrderByBeginTime(staffId);
        for (StaffWorkRole role : localHistories) {
            List factorList;
            if (role.getWorkRoleId() == null) continue;
            StaffCurrentWorkVo vo = new StaffCurrentWorkVo();
            if (role.getWorkRoleInfo() != null) {
                vo.setWorkName(role.getWorkRoleInfo().getWorkName());
                Object protectiveArticles = "";
                List infos = this.shieldEquipRuleService.getHistoryShieldInfosByWorkId(role.getWorkRoleInfo().getId(), role.getCid(), role.getLeaveTime());
                if (infos != null && !infos.isEmpty()) {
                    for (int i = 0; i < infos.size(); ++i) {
                        protectiveArticles = (String)protectiveArticles + ((ShieldWorkRelation)infos.get(i)).getDetailName();
                        if (StringUtils.isNotEmpty((String)((ShieldWorkRelation)infos.get(i)).getShieldDesc())) {
                            protectiveArticles = (String)protectiveArticles + "\u2014" + ((ShieldWorkRelation)infos.get(i)).getShieldDesc();
                        }
                        if (i == infos.size() - 1) continue;
                        protectiveArticles = (String)protectiveArticles + ",";
                    }
                }
                vo.setProtectiveArticles((String)protectiveArticles);
            }
            if (role.getLeaveTime() == null) {
                role.setLeaveTime(new Date());
            }
            if ((factorList = this.harmfactorWorkService.getArchiveHarmfactorByWork(role.getCid(), role.getWorkRoleId(), role.getLeaveTime())) == null || factorList.size() <= 0) continue;
            HashMap hcMap = new HashMap();
            HashMap hcHarmSourcesMap = new HashMap();
            HashMap<Long, Long> harmMap = new HashMap<Long, Long>();
            for (HarmfactorWorkSource harm : factorList) {
                harmMap.put(harm.getHarmId(), harm.getHarmId());
                if (hcMap.get(harm.getCheckPlanId()) == null) {
                    hcMap.put(harm.getCheckPlanId(), new HashMap());
                    ArrayList collectTypes = new ArrayList();
                    ((HashMap)hcMap.get(harm.getCheckPlanId())).put("collectTypes", collectTypes);
                    ArrayList<Long> harmIds = new ArrayList<Long>();
                    harmIds.add(-999L);
                    ((HashMap)hcMap.get(harm.getCheckPlanId())).put("harmIds", harmIds);
                }
                if (hcHarmSourcesMap.get(harm.getCheckPlanId()) == null) {
                    ArrayList<String> hcHarmSources = new ArrayList<String>();
                    hcHarmSources.add("");
                    hcHarmSourcesMap.put(harm.getCheckPlanId(), hcHarmSources);
                }
                ((ArrayList)((HashMap)hcMap.get(harm.getCheckPlanId())).get("harmIds")).add(harm.getHarmId());
                ((ArrayList)hcHarmSourcesMap.get(harm.getCheckPlanId())).add(harm.getHazardSource());
                OccupationalRiskFactors orf = (OccupationalRiskFactors)this.occupationalRiskFactorsService.getById(harm.getHarmId());
                Integer collectType = null;
                if (orf == null || !StringUtils.isNotEmpty((String)orf.getParamcode())) continue;
                if (orf.getParamcode().contains(ResultCollectTypeEnum.CHEMICAL.getParamCode())) {
                    ((ArrayList)((HashMap)hcMap.get(harm.getCheckPlanId())).get("collectTypes")).add(ResultCollectTypeEnum.CHEMICAL.getCode().longValue());
                    continue;
                }
                if (orf.getParamcode().contains(ResultCollectTypeEnum.BIOLOGICAL.getParamCode())) {
                    ((ArrayList)((HashMap)hcMap.get(harm.getCheckPlanId())).get("collectTypes")).add(ResultCollectTypeEnum.BIOLOGICAL.getCode().longValue());
                    continue;
                }
                if (orf.getParamcode().contains(ResultCollectTypeEnum.DUST.getParamCode())) {
                    ((ArrayList)((HashMap)hcMap.get(harm.getCheckPlanId())).get("collectTypes")).add(ResultCollectTypeEnum.DUST.getCode().longValue());
                    continue;
                }
                collectType = ResultCollectTypeEnum.getCodeByParamCode((String)orf.getParamcode());
                if (collectType == null) continue;
                ((ArrayList)((HashMap)hcMap.get(harm.getCheckPlanId())).get("collectTypes")).add(collectType.longValue());
            }
            StringBuilder harmIdStr = null;
            for (Long v : harmMap.values()) {
                if (harmIdStr == null) {
                    harmIdStr = new StringBuilder(v.toString());
                    continue;
                }
                harmIdStr.append(",").append(v.toString());
            }
            if (harmIdStr != null) {
                vo.setHarmNames(this.occupationalRiskFactorsService.getHarmNamesByIds(harmIdStr.toString().toString()));
            }
            vo.setList(this.hcCheckResultCollectDataService.getStaffWorkHarmCheckResultVoByHcMap(hcMap, hcHarmSourcesMap, role.getCid()));
            vos.add(vo);
        }
        return vos;
    }

    public Integer getNoWorkCheckStaffIdsByCidAndStaffIds(Long cid, Long staffId) {
        StaffWorkRole role = this.staffWorkRoleService.getCurrentStaffWorkRoleByStaffId(staffId);
        if (role == null) {
            return 0;
        }
        if (role.getWorkRoleId() == null) {
            return 0;
        }
        Integer count = this.harmfactorWorkService.countHarmfactorByCidAndWork(cid, role.getWorkRoleId());
        if (count > 0) {
            return 1;
        }
        return 0;
    }

    public Integer getStaffCountByWork(Long workId, Long cid) {
        List list = this.staffWorkRoleService.getStaffWorkRoleByCidAndWorkIdAndNoHistory(workId, cid);
        ArrayList<CallSite> staffIds = new ArrayList<CallSite>();
        for (StaffWorkRole s : list) {
            StaffBasicInfo info;
            StaffInfo staffInfo;
            if (s.getStaffId() == null || s.getWorkProperty() != StaffWorkPropertyEnum.MAJOR.getValue() || s.getStatus() != StaffWorkStatusEnum.ONWORKING.getValue() || (staffInfo = (StaffInfo)this.getById(s.getStaffId())) == null || staffInfo.getStaffBasicId() == null || (info = (StaffBasicInfo)this.staffBasicInfoService.getById(staffInfo.getStaffBasicId())) == null || !info.getIsValid().booleanValue() || staffIds.contains("" + s.getStaffId())) continue;
            staffIds.add((CallSite)((Object)("" + s.getStaffId())));
        }
        return staffIds.size();
    }

    public Integer getStaffCountHarmsByWork(Long workId, Long cid) {
        List list = this.staffWorkRoleService.getStaffWorkRoleByCidAndWorkIdAndNoHistory(workId, cid);
        ArrayList<CallSite> staffIds = new ArrayList<CallSite>();
        for (StaffWorkRole s : list) {
            StaffBasicInfo info;
            StaffInfo staffInfo;
            if (s.getStaffId() == null || s.getWorkProperty() != StaffWorkPropertyEnum.MAJOR.getValue() || s.getStatus() != StaffWorkStatusEnum.ONWORKING.getValue() && s.getStatus() != StaffWorkStatusEnum.FURLOUGH.getValue() || (staffInfo = (StaffInfo)this.getById(s.getStaffId())) == null || staffInfo.getStaffBasicId() == null || (info = (StaffBasicInfo)this.staffBasicInfoService.getById(staffInfo.getStaffBasicId())) == null || !info.getIsValid().booleanValue() || staffIds.contains("" + s.getStaffId())) continue;
            staffIds.add((CallSite)((Object)("" + s.getStaffId())));
        }
        return staffIds.size();
    }

    public Integer getHistoryBasicStaffCountByWork(Long workId, Long cid, Date date) {
        ArrayList<BasicEntityContentSearch> search = new ArrayList<BasicEntityContentSearch>();
        BasicEntityContentSearch bs = new BasicEntityContentSearch();
        bs.setKey("workProperty");
        bs.setValue((Object)1);
        search.add(bs);
        bs = new BasicEntityContentSearch();
        bs.setKey("workRoleId");
        bs.setValue((Object)workId);
        search.add(bs);
        bs = new BasicEntityContentSearch();
        bs.setKey("cid");
        bs.setValue((Object)cid);
        search.add(bs);
        bs = new BasicEntityContentSearch();
        bs.setKey("status");
        bs.setValue((Object)1);
        search.add(bs);
        ArrayList staffIds = new ArrayList();
        return staffIds.size();
    }

    public Integer getHistoryBasicFemaleStaffCountByWork(Long workId, Long cid, Date date) {
        ArrayList<BasicEntityContentSearch> search = new ArrayList<BasicEntityContentSearch>();
        BasicEntityContentSearch bs = new BasicEntityContentSearch();
        bs.setKey("workProperty");
        bs.setValue((Object)1);
        search.add(bs);
        bs = new BasicEntityContentSearch();
        bs.setKey("workRoleId");
        bs.setValue((Object)workId);
        search.add(bs);
        bs = new BasicEntityContentSearch();
        bs.setKey("cid");
        bs.setValue((Object)cid);
        search.add(bs);
        bs = new BasicEntityContentSearch();
        bs.setKey("status");
        bs.setValue((Object)1);
        search.add(bs);
        ArrayList staffIds = new ArrayList();
        return staffIds.size();
    }

    public Integer getFemaleStaffCountByWork(Long workId, Long cid) {
        List list = this.staffWorkRoleService.getStaffWorkRoleByCidAndWorkIdAndNoHistory(workId, cid);
        ArrayList<CallSite> staffIds = new ArrayList<CallSite>();
        for (StaffWorkRole s : list) {
            StaffBasicInfo basicInfo;
            StaffInfo staffInfo;
            if (s.getStaffId() == null || (staffInfo = (StaffInfo)this.getById(s.getStaffId())) == null || staffInfo.getStaffBasicId() == null || !(basicInfo = (StaffBasicInfo)this.staffBasicInfoService.getById(staffInfo.getStaffBasicId())).getIsValid().booleanValue() || basicInfo == null || basicInfo.getGender() == null || StaffGenderEnum.FEMALE.getValue().byteValue() != basicInfo.getGender().byteValue()) continue;
            staffIds.add((CallSite)((Object)("" + s.getStaffId())));
        }
        return staffIds.size();
    }

    public Integer getStaffCountByCid(Long cid, Boolean isThirdParty) {
        StaffInfoSearchParam param = new StaffInfoSearchParam();
        param.setCid(cid);
        param.setIsThirdParty(isThirdParty);
        param.setIsSeniorSearch(Boolean.valueOf(false));
        param.setSearchKeyEncrypt(param.getSearchKey());
        param.setStaffNameEncrypt(param.getStaffName());
        List<StaffShowInfo> list = this.staffInfoMapper.getStaffInfoListBySearchParam(param);
        return list.size();
    }

    public StaffInfoNeedImportVo getStaffInfoFromExcel(HSSFSheet sheet, Long loginStaffId, Long cid, Boolean isThirdCompany, Byte outsource) {
        StaffInfoNeedImportVo info = new StaffInfoNeedImportVo();
        ArrayList<StaffInfoExcelImportVo> list = new ArrayList<StaffInfoExcelImportVo>();
        int rowIndex = 0;
        int cellIndex = 0;
        cellIndex = isThirdCompany != false ? 24 : 22;
        HashMap<String, CompanyOrganization> needAddOrg = new HashMap<String, CompanyOrganization>();
        HashMap<String, WorkRoleInfo> needAddworkList = new HashMap<String, WorkRoleInfo>();
        ArrayList<String> workAndDeptNames = new ArrayList<String>();
        Iterator iter = sheet.rowIterator();
        while (iter.hasNext()) {
            Row row = (Row)iter.next();
            if (++rowIndex == 1 || rowIndex == 2) continue;
            StaffInfoExcelImportVo vo = new StaffInfoExcelImportVo();
            vo.setLoginStaffId(loginStaffId);
            vo.setCid(cid);
            if (isThirdCompany.booleanValue()) {
                vo.setIsThirdCompany(Global.TRUE);
            } else {
                vo.setIsThirdCompany(Global.FALSE);
            }
            vo.setErrorReason("");
            for (int i = 0; i < cellIndex; ++i) {
                Cell cell = row.getCell(i);
                if (cell == null) {
                    cell = new HSSFWorkbook().createSheet().createRow(1).createCell(0);
                }
                if (isThirdCompany.booleanValue()) {
                    if (i != 16 && i != 20 && i != 17 && i != 9) {
                        cell.setCellType(CellType.STRING);
                    }
                    this.formatEveryExcelCellforThird(cell, i, rowIndex, vo, needAddOrg, needAddworkList, workAndDeptNames);
                    continue;
                }
                if (i != 14 && i != 18 && i != 15 && i != 7) {
                    cell.setCellType(CellType.STRING);
                }
                this.formatEveryExcelCellforSelf(cell, i, rowIndex, vo, needAddOrg, needAddworkList, workAndDeptNames);
            }
            Object allValues = "";
            for (String value : vo.getKeyValue().values()) {
                allValues = (String)allValues + value;
            }
            if (!StringUtils.isNotEmpty((String)allValues)) continue;
            list.add(vo);
        }
        info.setStaffList(list);
        List<CompanyOrganization> needAddOrgs = this.getOrgList(needAddOrg);
        List<WorkRoleInfo> needAddworks = this.getWorkList(needAddworkList);
        if (needAddOrgs != null && needAddOrgs.size() > 0) {
            info.setNeedAddOrgs(needAddOrgs);
        }
        if (needAddworks != null && needAddworks.size() > 0) {
            info.setNeedAddwork(needAddworks);
        }
        info.setWorkAndDeptNames(workAndDeptNames);
        return info;
    }

    private List<WorkRoleInfo> getWorkList(Map<String, WorkRoleInfo> needAddworkList) {
        ArrayList<WorkRoleInfo> workList = new ArrayList<WorkRoleInfo>();
        for (String key : needAddworkList.keySet()) {
            workList.add(needAddworkList.get(key));
        }
        return workList;
    }

    private List<CompanyOrganization> getOrgList(Map<String, CompanyOrganization> needAddOrg) {
        ArrayList<CompanyOrganization> orglist = new ArrayList<CompanyOrganization>();
        for (String key : needAddOrg.keySet()) {
            orglist.add(needAddOrg.get(key));
        }
        return orglist;
    }

    @Transactional(readOnly=false)
    public void formatEveryExcelCellforSelf(Cell cell, int cellIndex, int rowIndex, StaffInfoExcelImportVo vo, Map<String, CompanyOrganization> needAddOrg, Map<String, WorkRoleInfo> needAddworkList, List<String> workAndDeptNames) {
        switch (cellIndex) {
            case 0: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                vo.getStaffInfo().setIsThirdParty(Global.FALSE);
                vo.getCurrentStaffWorkRole().setIsHistory(Global.FALSE);
                vo.getCurrentStaffWorkRole().setWorkProperty(StaffWorkPropertyEnum.MAJOR.getValue());
                vo.getCurrentStaffWorkRole().setIsThirdParty(Global.FALSE);
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    vo.setWorkNo(cell.getStringCellValue().trim());
                    vo.getStaffBasicWork().setWorkNo(vo.getWorkNo());
                    break;
                }
                vo.getStaffBasicWork().setWorkNo(" ");
                break;
            }
            case 1: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    vo.setRealName(cell.getStringCellValue().trim());
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    vo.getStaffBasicInfo().setRealName(vo.getRealName());
                    break;
                }
                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u59d3\u540d\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                break;
            }
            case 2: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    String workName = cell.getStringCellValue();
                    if (this.getIsHuadong(vo.getCid()).booleanValue()) {
                        if (workName.contains("/")) {
                            String[] workAndDeptname = workName.split("/");
                            if (workAndDeptname.length == 2) {
                                String jobName = workAndDeptname[0];
                                String deptName = workAndDeptname[1];
                                vo.setDeptName(deptName);
                                vo.setWorkName(jobName);
                                List orgs = this.companyOrganizationService.getListByName(deptName, vo.getCid());
                                if (orgs != null && orgs.size() > 0) {
                                    for (CompanyOrganization org : orgs) {
                                        List works;
                                        if (org.getTreePath() == null || !org.getTreePath().contains("99043991307161895") || (works = this.workRoleInfoService.getWorkInfoListWorkNameAndOrgId(vo.getWorkName(), org.getId(), vo.getCid())) == null || works.size() <= 0) continue;
                                        WorkRoleInfo work = (WorkRoleInfo)works.get(0);
                                        vo.setWorkId(work.getId());
                                        vo.setDeptId(org.getId());
                                        break;
                                    }
                                    if (vo.getWorkId() != null) break;
                                    vo.setDeptId(((CompanyOrganization)orgs.get(0)).getId());
                                    workAndDeptNames.add("\u7b2c" + rowIndex + "\u884c\u7684\u5c97\u4f4d" + vo.getWorkName() + "/" + vo.getDeptName() + "\u672a\u5b58\u5728\u7cfb\u7edf\u4e2d");
                                    WorkRoleInfo workinfo = needAddworkList.get(vo.getWorkName() + "/" + vo.getDeptName());
                                    if (workinfo != null && workinfo.getId() != null) {
                                        vo.setWorkId(workinfo.getId());
                                        break;
                                    }
                                    workinfo = new WorkRoleInfo();
                                    workinfo.setCid(vo.getCid());
                                    workinfo.setOrgId(vo.getDeptId());
                                    workinfo.setWorkName(vo.getWorkName());
                                    workinfo.setOrgName(deptName);
                                    workinfo.setId(Long.valueOf(this.idworker.nextId()));
                                    needAddworkList.put(jobName + "/" + deptName, workinfo);
                                    vo.setWorkId(workinfo.getId());
                                    break;
                                }
                                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u90e8\u95e8\u4e0d\u5b58\u5728;<br/>");
                                break;
                            }
                            vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u5c97\u4f4d/\u90e8\u95e8\u683c\u5f0f\u586b\u5199\u9519\u8bef;<br/>");
                            break;
                        }
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u5c97\u4f4d/\u90e8\u95e8\u683c\u5f0f\u586b\u5199\u9519\u8bef;<br/>");
                        break;
                    }
                    WorkRoleInfo work = this.getWorkByNameAndCid(workName, vo.getCid());
                    if (work != null) {
                        if (work.getId() == null) {
                            workAndDeptNames.add("\u7b2c" + rowIndex + "\u884c\u7684" + workName + "\u672a\u5b58\u5728\u7cfb\u7edf\u4e2d");
                            vo.setIsHaveWork(Boolean.valueOf(false));
                            WorkRoleInfo workinfo = needAddworkList.get(work.getWorkName() + "/" + work.getOrgName());
                            if (workinfo == null || workinfo.getId() == null) {
                                workinfo = new WorkRoleInfo();
                                List orgs = this.companyOrganizationService.getListByName(work.getOrgName(), vo.getCid());
                                if (orgs != null && orgs.size() > 0) {
                                    workinfo.setCid(vo.getCid());
                                    workinfo.setOrgId(((CompanyOrganization)orgs.get(0)).getId());
                                    workinfo.setWorkName(work.getWorkName());
                                    workinfo.setCreateDate(new Date());
                                    workinfo.setOrgName(work.getOrgName());
                                    workinfo.setId(Long.valueOf(this.idworker.nextId()));
                                    needAddworkList.put(work.getWorkName() + "/" + work.getOrgName(), workinfo);
                                } else {
                                    CompanyOrganization org = needAddOrg.get(work.getOrgName());
                                    if (org == null || org.getId() == null) {
                                        org = new CompanyOrganization();
                                        org.setCid(vo.getCid());
                                        org.setId(Long.valueOf(this.idworker.nextId()));
                                        org.setLevel(Byte.valueOf((byte)1));
                                        org.setCreateDate(new Date());
                                        org.setOrganizationName(work.getOrgName());
                                        needAddOrg.put(work.getOrgName(), org);
                                    }
                                    workinfo.setCid(vo.getCid());
                                    workinfo.setOrgId(org.getId());
                                    workinfo.setWorkName(work.getWorkName());
                                    workinfo.setOrgName(work.getOrgName());
                                    workinfo.setId(Long.valueOf(this.idworker.nextId()));
                                    needAddworkList.put(work.getWorkName() + "/" + work.getOrgName(), workinfo);
                                }
                                work = workinfo;
                            }
                        }
                        vo.setWorkName(work.getWorkName());
                        vo.setWorkId(work.getId());
                        vo.setDeptId(work.getOrgId());
                        vo.setDeptName(work.getOrgName());
                        if (vo.getDataState() != null && vo.getDataState().byteValue() != StaffInfoImportStateEnum.normal.getValue()) break;
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                        break;
                    }
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                    vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u5c97\u4f4d/\u90e8\u95e8\u683c\u5f0f\u586b\u5199\u9519\u8bef;<br/>");
                    break;
                }
                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u5c97\u4f4d/\u90e8\u95e8\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                break;
            }
            case 3: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    vo.setSexName(cell.getStringCellValue().trim());
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    if (vo.getSexName().equals("\u7537")) {
                        vo.setGender(Byte.valueOf(StaffGenderEnum.MALE.getValue().byteValue()));
                    } else if (vo.getSexName().equals("\u5973")) {
                        vo.setGender(Byte.valueOf(StaffGenderEnum.FEMALE.getValue().byteValue()));
                    } else {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u6027\u522b\u683c\u5f0f\u4e0d\u5bf9;<br/>");
                    }
                    vo.getStaffBasicInfo().setGender(vo.getGender());
                    break;
                }
                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u6027\u522b\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                break;
            }
            case 4: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (!StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                vo.setMobile(cell.getStringCellValue().trim());
                if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                }
                vo.getStaffBasicInfo().setMobile(vo.getMobile());
                break;
            }
            case 5: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    vo.setCardNo(cell.getStringCellValue().trim());
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    if (vo.getCardNo().length() != 18 && vo.getCardNo().length() != 15) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u8eab\u4efd\u8bc1\u53f7\u683c\u5f0f\u4e0d\u5bf9;<br/>");
                    } else {
                        Object birth = "19000101";
                        birth = vo.getCardNo().length() == 15 ? "19" + vo.getCardNo().substring(6, 12) : vo.getCardNo().substring(6, 14);
                        try {
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
                            vo.setBirthDay(sdf.parse((String)birth));
                            sdf = new SimpleDateFormat("yyyy");
                            vo.setAge(Integer.valueOf(Integer.parseInt(sdf.format(new Date())) - Integer.parseInt(((String)birth).substring(0, 4))));
                            vo.setNativePlace(this.sysAreaService.getFullName(Long.valueOf(vo.getCardNo().substring(0, 6) + "000000"), ""));
                        }
                        catch (Exception e) {
                            vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u8eab\u4efd\u8bc1\u53f7\u89e3\u6790\u8be5\u4eba\u7684\u51fa\u751f\u65e5\u671f\u9519\u8bef;<br/>");
                        }
                    }
                    vo.getStaffBasicInfo().setIdCard(vo.getCardNo());
                    vo.getStaffBasicInfo().setAge(vo.getAge());
                    vo.getStaffBasicInfo().setBirthday(vo.getBirthDay());
                    vo.getStaffBasicInfo().setNativePlace(vo.getNativePlace());
                    break;
                }
                if (vo.getWorkNo() != null && !vo.getWorkNo().equals(" ")) break;
                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ",\u5de5\u53f7\u6216\u8eab\u4efd\u8bc1\u53f7\u8bf7\u81f3\u5c11\u586b\u5199\u4e00\u9879;<br/>");
                break;
            }
            case 6: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    vo.setWorkStateName(cell.getStringCellValue().trim());
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    if (StaffWorkStatusEnum.ONWORKING.getName().equals(vo.getWorkStateName())) {
                        vo.setWorkState(StaffWorkStatusEnum.ONWORKING.getValue());
                    } else if (StaffWorkStatusEnum.NOWORKED.getName().equals(vo.getWorkStateName())) {
                        vo.setWorkState(StaffWorkStatusEnum.NOWORKED.getValue());
                    } else if (StaffWorkStatusEnum.FURLOUGH.getName().equals(vo.getWorkStateName())) {
                        vo.setWorkState(StaffWorkStatusEnum.FURLOUGH.getValue());
                    }
                    vo.getCurrentStaffWorkRole().setStatus(vo.getWorkState());
                    break;
                }
                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u5c97\u4f4d\u72b6\u6001\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                break;
            }
            case 7: {
                if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                }
                if (cell == null || cell.getCellType() == CellType.BLANK) break;
                StaffInfoServiceImpl.dateHandle(cell);
                if (cell.getCellType() == CellType.BLANK) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                    vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u4e0a\u5c97\u65f6\u95f4\u89e3\u6790\u9519\u8bef;<br/>");
                    break;
                }
                vo.getCurrentStaffWorkRole().setBeginTime(cell.getDateCellValue());
                break;
            }
            case 8: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    vo.setCompanyJob(cell.getStringCellValue().trim());
                    vo.getStaffBasicWork().setJobTitle(vo.getCompanyJob());
                    break;
                }
                vo.getStaffBasicWork().setJobTitle(" ");
                break;
            }
            case 9: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    vo.setNativePlace(cell.getStringCellValue().trim());
                    vo.getStaffBasicInfo().setNativePlace(vo.getNativePlace());
                    break;
                }
                if (!StringUtils.isEmpty((CharSequence)vo.getStaffBasicInfo().getNativePlace())) break;
                vo.getStaffBasicInfo().setNativePlace(" ");
                break;
            }
            case 10: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    vo.setNation(cell.getStringCellValue().trim());
                    vo.getStaffBasicInfo().setNation(vo.getNation());
                    break;
                }
                vo.getStaffBasicInfo().setNation(" ");
                break;
            }
            case 11: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (!StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                }
                vo.setMarriageState(cell.getStringCellValue().trim());
                if (StaffMaritalStatusEnum.MARRIED.getName().equals(vo.getMarriageState())) {
                    vo.setMaritalStatus(StaffMaritalStatusEnum.MARRIED.getCode());
                } else if (StaffMaritalStatusEnum.UNMARRIED.getName().equals(vo.getMarriageState())) {
                    vo.setMaritalStatus(StaffMaritalStatusEnum.UNMARRIED.getCode());
                } else if (StaffMaritalStatusEnum.DISSOCIATON.getName().equals(vo.getMarriageState())) {
                    vo.setMaritalStatus(StaffMaritalStatusEnum.DISSOCIATON.getCode());
                } else {
                    vo.setMaritalStatus(Byte.valueOf((byte)-1));
                }
                vo.getStaffBasicInfo().setMaritalStatus(vo.getMaritalStatus());
                break;
            }
            case 12: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (!StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                vo.setEducation(cell.getStringCellValue().trim());
                SysParamModel sysParam = this.sysParamProvideService.getSysParamByName(vo.getEducation(), vo.getCid(), SysParamGroupEnum.educ_background);
                if (sysParam != null) {
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    vo.setEducationId(sysParam.getId());
                    vo.getStaffBasicInfo().setEducation(vo.getEducationId());
                    break;
                }
                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u5b66\u5386\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728;<br/>");
                break;
            }
            case 13: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    vo.setMajor(cell.getStringCellValue().trim());
                    vo.getStaffBasicInfo().setMajor(vo.getMajor());
                    break;
                }
                vo.getStaffBasicInfo().setMajor(" ");
                break;
            }
            case 14: {
                if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                }
                if (cell == null || cell.getCellType() == CellType.BLANK) break;
                StaffInfoServiceImpl.dateHandle(cell);
                if (cell.getCellType() == CellType.BLANK) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                    vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u8fdb\u5382\u65f6\u95f4\u89e3\u6790\u9519\u8bef;<br/>");
                    break;
                }
                vo.getStaffBasicWork().setJoinTime(cell.getDateCellValue());
                if (vo.getCurrentStaffWorkRole().getBeginTime() != null) break;
                vo.getCurrentStaffWorkRole().setBeginTime(cell.getDateCellValue());
                break;
            }
            case 15: {
                if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                }
                if (cell == null || cell.getCellType() == CellType.BLANK) break;
                StaffInfoServiceImpl.dateHandle(cell);
                if (cell.getCellType() == CellType.BLANK) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                    vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u53c2\u52a0\u5de5\u4f5c\u65f6\u95f4\u89e3\u6790\u9519\u8bef;<br/>");
                    break;
                }
                vo.getStaffBasicWork().setWorkTime(cell.getDateCellValue());
                break;
            }
            case 16: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    vo.setHobby(cell.getStringCellValue().trim());
                    vo.getStaffBasicInfo().setHabitSmoke(vo.getHobby());
                    break;
                }
                vo.getStaffBasicInfo().setHabitSmoke("");
                break;
            }
            case 17: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (!StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                }
                vo.setIsRadiationName(cell.getStringCellValue().trim());
                if (vo.getIsRadiationName().equals("\u662f")) {
                    vo.setIsRadiation(Global.TRUE);
                    break;
                }
                if (vo.getIsRadiationName().equals("\u5426")) {
                    vo.setIsRadiation(Global.FALSE);
                    break;
                }
                vo.setIsRadiation(Global.FALSE);
                break;
            }
            case 18: {
                if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                }
                if (cell == null || cell.getCellType() == CellType.BLANK) break;
                StaffInfoServiceImpl.dateHandle(cell);
                if (cell.getCellType() == CellType.BLANK) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                    vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u4ece\u4e8b\u653e\u5c04\u5de5\u4f5c\u8d77\u59cb\u65f6\u95f4\u89e3\u6790\u9519\u8bef;<br/>");
                    break;
                }
                vo.setRadiationYear(cell.getDateCellValue());
                break;
            }
            case 19: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (!StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                }
                vo.setRadiationTypeName(cell.getStringCellValue().trim());
                String[] strs = vo.getRadiationTypeName().split(" ");
                SysParamModel sysParam = this.sysParamProvideService.getSysParamByNameGroupCode(strs[1], vo.getCid(), SysParamGroupEnum.occup_exposure_workingtype, strs[0]);
                if (sysParam == null) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                    vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u804c\u4e1a\u7167\u5c04\u804c\u4e1a\u5206\u7c7b\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728;<br/>");
                    break;
                }
                vo.setRadiationType(sysParam.getId());
                break;
            }
            case 20: {
                SysParamModel sysParam;
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (!StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                vo.setSpecialOperationsName(cell.getStringCellValue().trim());
                if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                }
                if ((sysParam = this.sysParamProvideService.getSysParamByName(vo.getSpecialOperationsName(), vo.getCid(), SysParamGroupEnum.spec_operation_type)) == null) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                    vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u7279\u79cd\u4f5c\u4e1a\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728;<br/>");
                    break;
                }
                vo.setSpecialOperations(sysParam.getId());
                break;
            }
            case 21: {
                SysParamModel sysParam;
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (!StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                vo.setSpecialWorkName(cell.getStringCellValue().trim());
                if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                }
                if ((sysParam = this.sysParamProvideService.getSysParamByName(vo.getSpecialWorkName(), vo.getCid(), SysParamGroupEnum.spec_working_type)) == null) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                    vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u7279\u6b8a\u4f5c\u4e1a\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728;<br/>");
                    break;
                }
                vo.setSpecialWork(sysParam.getId());
            }
        }
    }

    private WorkRoleInfo getWorkByNameAndCid(String workName, Long cid) {
        String[] workAndDeptname;
        if (workName == null || cid == null) {
            return null;
        }
        if (workName.contains("/") && (workAndDeptname = workName.split("/")).length == 2) {
            String jobName = workAndDeptname[0];
            String deptName = workAndDeptname[1];
            WorkRoleInfo work = this.workRoleInfoService.getWorkRoleInfoByNameAndOrgName(jobName, deptName, cid);
            if (work != null && work.getId() != null) {
                return work;
            }
            work = new WorkRoleInfo();
            work.setWorkName(jobName);
            work.setOrgName(deptName);
            return work;
        }
        return null;
    }

    @Transactional(readOnly=false)
    void formatEveryExcelCellforThird(Cell cell, int cellIndex, int rowIndex, StaffInfoExcelImportVo vo, Map<String, CompanyOrganization> needAddOrg, Map<String, WorkRoleInfo> needAddworkList, List<String> workAndDeptNames) {
        switch (cellIndex) {
            case 0: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                vo.setErrorReason("");
                vo.getStaffInfo().setIsThirdParty(Global.TRUE);
                vo.getCurrentStaffWorkRole().setIsHistory(Global.FALSE);
                vo.getCurrentStaffWorkRole().setWorkProperty(StaffWorkPropertyEnum.MAJOR.getValue());
                vo.getCurrentStaffWorkRole().setIsThirdParty(Global.FALSE);
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    vo.setThirdCompanyName(cell.getStringCellValue().trim());
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    vo.getStaffInfo().setOtherCompany(vo.getThirdCompanyName());
                    break;
                }
                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u5916\u534f\u4f01\u4e1a\u540d\u79f0\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                break;
            }
            case 1: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (!StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                }
                Byte outsource = null;
                if ("\u52b3\u52a1\u6d3e\u9063".equals(cell.getStringCellValue().trim())) {
                    outsource = 1;
                } else if ("\u52b3\u52a1\u5916\u5305".equals(cell.getStringCellValue().trim())) {
                    outsource = 2;
                } else if ("\u5176\u4ed6".equals(cell.getStringCellValue().trim())) {
                    outsource = 3;
                }
                vo.setOutsource(outsource);
                vo.getStaffInfo().setOutsource(outsource);
                break;
            }
            case 2: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    vo.setWorkNo(cell.getStringCellValue().trim());
                    vo.getStaffBasicWork().setWorkNo(vo.getWorkNo());
                    break;
                }
                vo.getStaffBasicWork().setWorkNo(" ");
                vo.setWorkNo(" ");
                break;
            }
            case 3: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    vo.setRealName(cell.getStringCellValue().trim());
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    vo.getStaffBasicInfo().setRealName(vo.getRealName());
                    break;
                }
                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u59d3\u540d\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                break;
            }
            case 4: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    String workName = cell.getStringCellValue();
                    if (this.getIsHuadong(vo.getCid()).booleanValue()) {
                        if (workName.contains("/")) {
                            String[] workAndDeptname = workName.split("/");
                            if (workAndDeptname.length == 2) {
                                String jobName = workAndDeptname[0];
                                String deptName = workAndDeptname[1];
                                vo.setDeptName(deptName);
                                vo.setWorkName(jobName);
                                List orgs = this.companyOrganizationService.getListByName(deptName, vo.getCid());
                                if (orgs != null && orgs.size() > 0) {
                                    for (CompanyOrganization org : orgs) {
                                        List works;
                                        if (org.getTreePath() == null || !org.getTreePath().contains("99043991307161895") || (works = this.workRoleInfoService.getWorkInfoListWorkNameAndOrgId(vo.getWorkName(), org.getId(), vo.getCid())) == null || works.size() <= 0) continue;
                                        WorkRoleInfo work = (WorkRoleInfo)works.get(0);
                                        vo.setWorkId(work.getId());
                                        vo.setDeptId(org.getId());
                                        break;
                                    }
                                    if (vo.getWorkId() != null) break;
                                    vo.setDeptId(((CompanyOrganization)orgs.get(0)).getId());
                                    workAndDeptNames.add("\u7b2c" + rowIndex + "\u884c\u7684\u5c97\u4f4d" + vo.getWorkName() + "/" + vo.getDeptName() + "\u672a\u5b58\u5728\u7cfb\u7edf\u4e2d");
                                    WorkRoleInfo workinfo = needAddworkList.get(vo.getWorkName() + "/" + vo.getDeptName());
                                    if (workinfo != null && workinfo.getId() != null) {
                                        vo.setWorkId(workinfo.getId());
                                        break;
                                    }
                                    workinfo = new WorkRoleInfo();
                                    workinfo.setCid(vo.getCid());
                                    workinfo.setOrgId(vo.getDeptId());
                                    workinfo.setWorkName(vo.getWorkName());
                                    workinfo.setOrgName(deptName);
                                    workinfo.setId(Long.valueOf(this.idworker.nextId()));
                                    needAddworkList.put(jobName + "/" + deptName, workinfo);
                                    vo.setWorkId(workinfo.getId());
                                    break;
                                }
                                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u90e8\u95e8\u4e0d\u5b58\u5728;<br/>");
                                break;
                            }
                            vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u5c97\u4f4d/\u90e8\u95e8\u683c\u5f0f\u586b\u5199\u9519\u8bef;<br/>");
                            break;
                        }
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u5c97\u4f4d/\u90e8\u95e8\u683c\u5f0f\u586b\u5199\u9519\u8bef;<br/>");
                        break;
                    }
                    WorkRoleInfo work = this.getWorkByNameAndCid(workName, vo.getCid());
                    if (work != null) {
                        if (work.getId() == null) {
                            workAndDeptNames.add("\u7b2c" + rowIndex + "\u884c\u7684" + workName + "\u672a\u5b58\u5728\u7cfb\u7edf\u4e2d");
                            vo.setIsHaveWork(Boolean.valueOf(false));
                            WorkRoleInfo workinfo = needAddworkList.get(work.getWorkName() + "/" + work.getOrgName());
                            if (workinfo == null || workinfo.getId() == null) {
                                workinfo = new WorkRoleInfo();
                                List orgs = this.companyOrganizationService.getListByName(work.getOrgName(), vo.getCid());
                                if (orgs != null && orgs.size() > 0) {
                                    workinfo.setCid(vo.getCid());
                                    workinfo.setOrgId(((CompanyOrganization)orgs.get(0)).getId());
                                    workinfo.setWorkName(work.getWorkName());
                                    workinfo.setCreateDate(new Date());
                                    workinfo.setOrgName(work.getOrgName());
                                    workinfo.setId(Long.valueOf(this.idworker.nextId()));
                                    needAddworkList.put(work.getWorkName() + "/" + work.getOrgName(), workinfo);
                                } else {
                                    CompanyOrganization org = needAddOrg.get(work.getOrgName());
                                    if (org == null || org.getId() == null) {
                                        org = new CompanyOrganization();
                                        org.setCid(vo.getCid());
                                        org.setId(Long.valueOf(this.idworker.nextId()));
                                        org.setLevel(Byte.valueOf((byte)1));
                                        org.setCreateDate(new Date());
                                        org.setOrganizationName(work.getOrgName());
                                        needAddOrg.put(work.getOrgName(), org);
                                    }
                                    workinfo.setCid(vo.getCid());
                                    workinfo.setOrgId(org.getId());
                                    workinfo.setWorkName(work.getWorkName());
                                    workinfo.setOrgName(work.getOrgName());
                                    workinfo.setId(Long.valueOf(this.idworker.nextId()));
                                    needAddworkList.put(work.getWorkName() + "/" + work.getOrgName(), workinfo);
                                }
                                work = workinfo;
                            }
                        }
                        vo.setWorkName(work.getWorkName());
                        vo.setWorkId(work.getId());
                        vo.setDeptId(work.getOrgId());
                        vo.setDeptName(work.getOrgName());
                        if (vo.getDataState() != null && vo.getDataState().byteValue() != StaffInfoImportStateEnum.normal.getValue()) break;
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                        break;
                    }
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                    vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u5c97\u4f4d/\u90e8\u95e8\u683c\u5f0f\u586b\u5199\u9519\u8bef;<br/>");
                    break;
                }
                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u5c97\u4f4d/\u90e8\u95e8\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                break;
            }
            case 5: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    vo.setSexName(cell.getStringCellValue().trim());
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    if (vo.getSexName().equals("\u7537")) {
                        vo.setGender(Byte.valueOf(StaffGenderEnum.MALE.getValue().byteValue()));
                    } else if (vo.getSexName().equals("\u5973")) {
                        vo.setGender(Byte.valueOf(StaffGenderEnum.FEMALE.getValue().byteValue()));
                    } else {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u6027\u522b\u683c\u5f0f\u4e0d\u5bf9;<br/>");
                    }
                    vo.getStaffBasicInfo().setGender(vo.getGender());
                    break;
                }
                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u6027\u522b\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                break;
            }
            case 6: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (!StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                vo.setMobile(cell.getStringCellValue().trim());
                if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                }
                vo.getStaffBasicInfo().setMobile(vo.getMobile());
                break;
            }
            case 7: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    vo.setCardNo(cell.getStringCellValue().trim());
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    if (vo.getCardNo().length() != 18 && vo.getCardNo().length() != 15) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u8eab\u4efd\u8bc1\u53f7\u683c\u5f0f\u4e0d\u5bf9;<br/>");
                        break;
                    }
                    Object birth = "19000101";
                    birth = vo.getCardNo().length() == 15 ? "19" + vo.getCardNo().substring(6, 12) : vo.getCardNo().substring(6, 14);
                    try {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
                        vo.setBirthDay(sdf.parse((String)birth));
                        sdf = new SimpleDateFormat("yyyy");
                        vo.setAge(Integer.valueOf(Integer.parseInt(sdf.format(new Date())) - Integer.parseInt(((String)birth).substring(0, 4))));
                        vo.setNativePlace(this.sysAreaService.getFullName(Long.valueOf(vo.getCardNo().substring(0, 6) + "000000"), ""));
                    }
                    catch (Exception e) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u8eab\u4efd\u8bc1\u53f7\u89e3\u6790\u8be5\u4eba\u7684\u51fa\u751f\u65e5\u671f\u9519\u8bef;<br/>");
                    }
                    vo.getStaffBasicInfo().setIdCard(vo.getCardNo());
                    vo.getStaffBasicInfo().setAge(vo.getAge());
                    vo.getStaffBasicInfo().setBirthday(vo.getBirthDay());
                    vo.getStaffBasicInfo().setNativePlace(vo.getNativePlace());
                    break;
                }
                if (vo.getWorkNo() != null && !vo.getWorkNo().equals(" ")) break;
                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ",\u5de5\u53f7\u6216\u8eab\u4efd\u8bc1\u53f7\u8bf7\u81f3\u5c11\u586b\u5199\u4e00\u9879;<br/>");
                break;
            }
            case 8: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    vo.setWorkStateName(cell.getStringCellValue().trim());
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    if (StaffWorkStatusEnum.ONWORKING.getName().equals(vo.getWorkStateName())) {
                        vo.setWorkState(StaffWorkStatusEnum.ONWORKING.getValue());
                    } else if (StaffWorkStatusEnum.NOWORKED.getName().equals(vo.getWorkStateName())) {
                        vo.setWorkState(StaffWorkStatusEnum.NOWORKED.getValue());
                    } else if (StaffWorkStatusEnum.FURLOUGH.getName().equals(vo.getWorkStateName())) {
                        vo.setWorkState(StaffWorkStatusEnum.FURLOUGH.getValue());
                    }
                    vo.getCurrentStaffWorkRole().setStatus(vo.getWorkState());
                    break;
                }
                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u5c97\u4f4d\u72b6\u6001\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                break;
            }
            case 9: {
                if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                }
                if (cell == null || cell.getCellType() == CellType.BLANK) break;
                StaffInfoServiceImpl.dateHandle(cell);
                if (cell.getCellType() == CellType.BLANK) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                    vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u4e0a\u5c97\u65f6\u95f4\u89e3\u6790\u9519\u8bef;<br/>");
                    break;
                }
                vo.getCurrentStaffWorkRole().setBeginTime(cell.getDateCellValue());
                break;
            }
            case 10: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    vo.setCompanyJob(cell.getStringCellValue().trim());
                    vo.getStaffBasicWork().setJobTitle(vo.getCompanyJob());
                    break;
                }
                vo.getStaffBasicWork().setJobTitle(" ");
                break;
            }
            case 11: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    vo.setNativePlace(cell.getStringCellValue().trim());
                    vo.getStaffBasicInfo().setNativePlace(vo.getNativePlace());
                    break;
                }
                if (!StringUtils.isEmpty((CharSequence)vo.getStaffBasicInfo().getNativePlace())) break;
                vo.getStaffBasicInfo().setNativePlace(" ");
                break;
            }
            case 12: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    vo.setNation(cell.getStringCellValue().trim());
                    vo.getStaffBasicInfo().setNation(vo.getNation());
                    break;
                }
                vo.getStaffBasicInfo().setNation(" ");
                break;
            }
            case 13: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (!StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                }
                vo.setMarriageState(cell.getStringCellValue().trim());
                if (StaffMaritalStatusEnum.MARRIED.getName().equals(vo.getMarriageState())) {
                    vo.setMaritalStatus(StaffMaritalStatusEnum.MARRIED.getCode());
                } else if (StaffMaritalStatusEnum.UNMARRIED.getName().equals(vo.getMarriageState())) {
                    vo.setMaritalStatus(StaffMaritalStatusEnum.UNMARRIED.getCode());
                } else if (StaffMaritalStatusEnum.DISSOCIATON.getName().equals(vo.getMarriageState())) {
                    vo.setMaritalStatus(StaffMaritalStatusEnum.DISSOCIATON.getCode());
                } else {
                    vo.setMaritalStatus(Byte.valueOf((byte)-1));
                }
                vo.getStaffBasicInfo().setMaritalStatus(vo.getMaritalStatus());
                break;
            }
            case 14: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (!StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                vo.setEducation(cell.getStringCellValue().trim());
                SysParamModel sysParam = this.sysParamProvideService.getSysParamByName(vo.getEducation(), vo.getCid(), SysParamGroupEnum.educ_background);
                if (sysParam != null) {
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    vo.setEducationId(sysParam.getId());
                    vo.getStaffBasicInfo().setEducation(vo.getEducationId());
                    break;
                }
                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u5b66\u5386\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728;<br/>");
                break;
            }
            case 15: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    vo.setMajor(cell.getStringCellValue().trim());
                    vo.getStaffBasicInfo().setMajor(vo.getMajor());
                    break;
                }
                vo.getStaffBasicInfo().setMajor(" ");
                break;
            }
            case 16: {
                if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                }
                if (cell == null || cell.getCellType() == CellType.BLANK) break;
                StaffInfoServiceImpl.dateHandle(cell);
                if (cell.getCellType() == CellType.BLANK) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                    vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u8fdb\u5382\u65f6\u95f4\u89e3\u6790\u9519\u8bef;<br/>");
                    break;
                }
                vo.getCurrentStaffWorkRole().setBeginTime(cell.getDateCellValue());
                vo.getStaffBasicWork().setJoinTime(cell.getDateCellValue());
                if (vo.getCurrentStaffWorkRole().getBeginTime() != null) break;
                vo.getCurrentStaffWorkRole().setBeginTime(cell.getDateCellValue());
                break;
            }
            case 17: {
                if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                }
                if (cell == null || cell.getCellType() == CellType.BLANK) break;
                StaffInfoServiceImpl.dateHandle(cell);
                if (cell.getCellType() == CellType.BLANK) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                    vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u53c2\u52a0\u5de5\u4f5c\u65f6\u95f4\u89e3\u6790\u9519\u8bef;<br/>");
                    break;
                }
                vo.getStaffBasicWork().setWorkTime(cell.getDateCellValue());
                break;
            }
            case 18: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    vo.setHobby(cell.getStringCellValue().trim());
                    vo.getStaffBasicInfo().setHabitSmoke(vo.getHobby());
                    break;
                }
                vo.getStaffBasicInfo().setHabitSmoke("");
                break;
            }
            case 19: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (!StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                }
                vo.setIsRadiationName(cell.getStringCellValue().trim());
                if (vo.getIsRadiationName().equals("\u662f")) {
                    vo.setIsRadiation(Global.TRUE);
                    break;
                }
                if (vo.getIsRadiationName().equals("\u5426")) {
                    vo.setIsRadiation(Global.FALSE);
                    break;
                }
                vo.setIsRadiation(Global.FALSE);
                break;
            }
            case 20: {
                if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                }
                if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                }
                if (cell == null || cell.getCellType() == CellType.BLANK) break;
                StaffInfoServiceImpl.dateHandle(cell);
                if (cell.getCellType() == CellType.BLANK) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                    vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u4ece\u4e8b\u653e\u5c04\u5de5\u4f5c\u8d77\u59cb\u65f6\u95f4\u89e3\u6790\u9519\u8bef;<br/>");
                    break;
                }
                vo.setRadiationYear(cell.getDateCellValue());
                break;
            }
            case 21: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (!StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                }
                vo.setRadiationTypeName(cell.getStringCellValue().trim());
                String[] strs = vo.getRadiationTypeName().split(" ");
                SysParamModel sysParam = this.sysParamProvideService.getSysParamByNameGroupCode(strs[1], vo.getCid(), SysParamGroupEnum.occup_exposure_workingtype, strs[0]);
                if (sysParam == null) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                    vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u804c\u4e1a\u7167\u5c04\u804c\u4e1a\u5206\u7c7b\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728;<br/>");
                    break;
                }
                vo.setRadiationType(sysParam.getId());
                break;
            }
            case 22: {
                SysParamModel sysParam;
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (!StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                vo.setSpecialOperationsName(cell.getStringCellValue().trim());
                if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                }
                if ((sysParam = this.sysParamProvideService.getSysParamByName(vo.getSpecialOperationsName(), vo.getCid(), SysParamGroupEnum.spec_operation_type)) == null) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                    vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u7279\u79cd\u4f5c\u4e1a\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728;<br/>");
                    break;
                }
                vo.setSpecialOperations(sysParam.getId());
                break;
            }
            case 23: {
                SysParamModel sysParam;
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (!StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                vo.setSpecialWorkName(cell.getStringCellValue().trim());
                if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                }
                if ((sysParam = this.sysParamProvideService.getSysParamByName(vo.getSpecialWorkName(), vo.getCid(), SysParamGroupEnum.spec_working_type)) == null) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                    vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u7279\u6b8a\u4f5c\u4e1a\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728;<br/>");
                    break;
                }
                vo.setSpecialWork(sysParam.getId());
            }
        }
    }

    @Transactional(readOnly=false)
    public List<StaffInfoExcelImportVo> batchStaffDataStaffInfoExcel(List<StaffInfoExcelImportVo> datas, Long loginStaffId, Long cid) {
        ArrayList<StaffInfoExcelImportVo> existData = new ArrayList<StaffInfoExcelImportVo>();
        for (StaffInfoExcelImportVo vo : datas) {
            if (vo.getCid() != null) {
                cid = vo.getCid();
            }
            StaffInfo staffInfo = vo.getStaffInfo();
            StaffBasicInfo staffBasicInfo = vo.getStaffBasicInfo();
            StaffBasicWork staffBasicWork = vo.getStaffBasicWork();
            StaffWorkRole currentStaffWorkRole = vo.getCurrentStaffWorkRole();
            staffBasicWork.setWorkNo(vo.getWorkNo());
            staffBasicInfo.setHabitSmoke(vo.getHobby());
            staffBasicWork.setOrgId(vo.getDeptId());
            currentStaffWorkRole.setWorkRoleId(vo.getWorkId());
            staffBasicWork.setOrgId(vo.getDeptId());
            if (vo.getDataState() == null || vo.getDataState().byteValue() != StaffInfoImportStateEnum.normal.getValue()) continue;
            StaffBasicInfo staffBasicInfoFromBase = null;
            if (staffBasicInfo.getIdCard() != null) {
                staffBasicInfoFromBase = this.staffBasicInfoService.getStaffBasicInfoByIdCard(staffBasicInfo.getIdCard(), null, cid);
            }
            if (staffBasicInfoFromBase != null) {
                StaffWorkRole staffWorkRoleDB;
                StaffBasicWork staffBasicWorkDB;
                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.exist.getValue()));
                existData.add(vo);
                staffBasicInfo.setId(staffBasicInfoFromBase.getId());
                ArrayList<Long> staffBasicIds = new ArrayList<Long>();
                staffBasicIds.add(staffBasicInfoFromBase.getId());
                List<StaffInfo> staffInfos = this.getStaffInfosByStaffBasicIds(staffBasicIds, cid);
                if (staffInfos != null && staffInfos.size() > 0) {
                    staffInfo.setId(staffInfos.get(0).getId());
                }
                if ((staffBasicWorkDB = this.staffBasicWorkService.getStaffBasicWorkByStaffId(staffInfo.getId())) != null) {
                    staffBasicWork.setId(staffBasicWorkDB.getId());
                }
                if ((staffWorkRoleDB = this.staffWorkRoleService.getCurrentStaffWorkRoleByStaffId(staffInfo.getId())) == null) continue;
                currentStaffWorkRole.setId(staffWorkRoleDB.getId());
                continue;
            }
            StaffBasicWork bsWork = null;
            if (staffBasicWork.getWorkNo() != null) {
                bsWork = this.staffBasicWorkService.getStaffBasicWorkByWorkNo(staffBasicWork.getWorkNo(), cid);
            }
            if (bsWork != null) {
                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.exist.getValue()));
                existData.add(vo);
                staffInfo.setId(bsWork.getStaffId());
                StaffInfo staffinfoDB = (StaffInfo)this.getById(bsWork.getStaffId());
                if (staffinfoDB != null) {
                    staffBasicInfo.setId(staffinfoDB.getStaffBasicId());
                }
                staffBasicWork.setId(bsWork.getId());
                StaffWorkRole staffWorkRoleDB = this.staffWorkRoleService.getCurrentStaffWorkRoleByStaffId(staffInfo.getId());
                if (staffWorkRoleDB == null) continue;
                currentStaffWorkRole.setId(staffWorkRoleDB.getId());
                continue;
            }
            this.staffBasicInfoService.add((Object)staffBasicInfo, loginStaffId, cid);
            staffInfo.setStaffBasicId(staffBasicInfo.getId());
            this.add(staffInfo, loginStaffId, cid);
            staffBasicWork.setStaffId(staffInfo.getId());
            this.staffBasicWorkService.add((Object)staffBasicWork, loginStaffId, cid);
            if (staffInfo.getId() != null && staffBasicWork.getOrgId() != null) {
                StaffInfo nstaffInfo = new StaffInfo();
                nstaffInfo.setId(staffInfo.getId());
                nstaffInfo.setOrgId(staffBasicWork.getOrgId());
                this.update(nstaffInfo, loginStaffId);
            }
            WorkNatureInfo radiationWork = new WorkNatureInfo();
            radiationWork.setIsWork(vo.getIsRadiation());
            radiationWork.setIsDefault(Boolean.valueOf(true));
            if (vo.getRadiationYear() != null) {
                radiationWork.setWorkBeginTime(vo.getRadiationYear());
            }
            radiationWork.setWorkType(vo.getRadiationTypeName());
            radiationWork.setNature(Byte.valueOf(WorkNatureEnum.RadiationWork.getValue()));
            radiationWork.setNatureName(WorkNatureEnum.RadiationWork.getName());
            radiationWork.setStaffId(staffInfo.getId());
            radiationWork.setCid(cid);
            this.workNatureInfoService.add((Object)radiationWork, loginStaffId, cid);
            WorkNatureInfo particularWork = new WorkNatureInfo();
            if (vo.getSpecialOperationsName() != null) {
                particularWork.setIsWork(Boolean.valueOf(true));
                particularWork.setWorkType(vo.getSpecialOperationsName());
            }
            particularWork.setIsDefault(Boolean.valueOf(true));
            particularWork.setNature(Byte.valueOf(WorkNatureEnum.ParticularWork.getValue()));
            particularWork.setNatureName(WorkNatureEnum.ParticularWork.getName());
            particularWork.setStaffId(staffInfo.getId());
            particularWork.setCid(cid);
            this.workNatureInfoService.add((Object)particularWork, loginStaffId, cid);
            WorkNatureInfo specialWork = new WorkNatureInfo();
            if (vo.getSpecialWorkName() != null) {
                specialWork.setIsWork(Boolean.valueOf(true));
                specialWork.setWorkType(vo.getSpecialWorkName());
            }
            specialWork.setIsDefault(Boolean.valueOf(true));
            specialWork.setNature(Byte.valueOf(WorkNatureEnum.SpecialWork.getValue()));
            specialWork.setNatureName(WorkNatureEnum.SpecialWork.getName());
            specialWork.setStaffId(staffInfo.getId());
            specialWork.setCid(cid);
            this.workNatureInfoService.add((Object)specialWork, loginStaffId, cid);
            currentStaffWorkRole.setStaffId(staffInfo.getId());
            this.staffWorkRoleService.add((Object)currentStaffWorkRole, loginStaffId, cid);
            if (currentStaffWorkRole.getStatus() == StaffWorkStatusEnum.ONWORKING.getValue()) {
                this.createNoInformStaff(currentStaffWorkRole, NoInformStaffChangeWorkStatusEnum.ONWORKING, staffInfo.getCreateBy(), staffInfo.getCid());
            }
            StaffWorkRole curHistoryStaffWorkRole = new StaffWorkRole();
            curHistoryStaffWorkRole.setCid(cid);
            curHistoryStaffWorkRole.setBeginTime(currentStaffWorkRole.getBeginTime());
            curHistoryStaffWorkRole.setIsHistory(Boolean.valueOf(true));
            curHistoryStaffWorkRole.setIsThirdParty(currentStaffWorkRole.getIsThirdParty());
            curHistoryStaffWorkRole.setLeaveTime(currentStaffWorkRole.getLeaveTime());
            curHistoryStaffWorkRole.setStaffId(currentStaffWorkRole.getStaffId());
            curHistoryStaffWorkRole.setStatus(currentStaffWorkRole.getStatus());
            curHistoryStaffWorkRole.setWorkProperty(StaffWorkPropertyEnum.WORKED.getValue());
            curHistoryStaffWorkRole.setWorkRoleId(currentStaffWorkRole.getWorkRoleId());
            this.staffWorkRoleService.add((Object)curHistoryStaffWorkRole, loginStaffId, cid);
        }
        return existData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(readOnly=false)
    public StaffInfoNeedImportVo getBatchStaffInfoFromExcel(String ossfile, Long cid, Boolean isThirdCompany, Long loginStaffId, Byte outsource) {
        HSSFWorkbook wb = null;
        StaffInfoNeedImportVo data = new StaffInfoNeedImportVo();
        try {
            wb = new HSSFWorkbook(ExcelUtil.getInstance().getOssInputStream(ossfile));
        }
        catch (Exception sheet) {
        }
        finally {
            if (wb != null) {
                try {
                    HSSFSheet sheet = wb.getSheetAt(0);
                    data = this.getStaffInfoFromExcel(sheet, loginStaffId, cid, isThirdCompany, outsource);
                    wb.close();
                }
                catch (IOException sheet) {}
            }
        }
        return data;
    }

    public StaffInfo getStaffInfoIdByIdCardAndCid(String idCard, Long cid) {
        StaffBasicInfo sbi = this.staffBasicInfoService.getStaffBasicInfoByIdCard(idCard, null, cid);
        if (sbi != null) {
            Example e = new Example(StaffInfo.class);
            e.createCriteria().andEqualTo("staffBasicId", (Object)sbi.getId()).andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)Global.TRUE);
            List list = this.staffInfoMapper.selectByExample(e);
            if (list != null && list.size() > 0) {
                ((StaffInfo)list.get(0)).setStaffBasicInfo(sbi);
                return (StaffInfo)list.get(0);
            }
            return null;
        }
        return null;
    }

    public List<StaffInfo> getStaffInfosByStaffBasicIds(List<Long> staffBasicIds, Long cid) {
        Example e = new Example(StaffInfo.class);
        if (staffBasicIds == null || staffBasicIds.size() == 0) {
            staffBasicIds = new ArrayList<Long>();
            staffBasicIds.add(-9L);
        }
        e.createCriteria().andIn("staffBasicId", staffBasicIds).andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)Global.TRUE);
        return this.staffInfoMapper.selectByExample(e);
    }

    public List<StaffInfo> getStaffInfoByCardId(String idCard, Long cid) {
        if (StringUtils.isBlank((CharSequence)idCard)) {
            return null;
        }
        if (cid == null) {
            List<Object> list = new ArrayList<StaffInfo>();
            StaffBasicInfo sbi = this.staffBasicInfoService.getFirstStaffBasicInfoByIdCard(idCard);
            if (sbi != null) {
                Example e = new Example(StaffInfo.class);
                e.createCriteria().andEqualTo("staffBasicId", (Object)sbi.getId()).andEqualTo("isValid", (Object)Global.TRUE);
                list = this.staffInfoMapper.selectByExample(e);
                for (StaffInfo staffInfo : list) {
                    staffInfo.setStaffBasicInfo(sbi);
                }
            }
            return list;
        }
        List<Object> finalList = new ArrayList<StaffInfo>();
        if (0L == cid) {
            List sbis = this.staffBasicInfoService.getAllStaffBasicInfoByIdCard(idCard);
            for (StaffBasicInfo sbi : sbis) {
                Example example = new Example(StaffInfo.class);
                example.createCriteria().andEqualTo("staffBasicId", (Object)sbi.getId()).andEqualTo("isValid", (Object)Global.TRUE);
                List list = this.staffInfoMapper.selectByExample(example);
                for (StaffInfo s : list) {
                    s.setStaffBasicInfo(sbi);
                }
                if (list.size() <= 0) continue;
                finalList.addAll(list);
            }
            return finalList;
        }
        StaffBasicInfo sbi = this.staffBasicInfoService.getStaffBasicInfoByIdCard(idCard, null, cid);
        if (sbi != null) {
            Example e = new Example(StaffInfo.class);
            e.createCriteria().andEqualTo("staffBasicId", (Object)sbi.getId()).andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)Global.TRUE);
            finalList = this.staffInfoMapper.selectByExample(e);
            for (StaffInfo staffInfo : finalList) {
                staffInfo.setStaffBasicInfo(sbi);
            }
        }
        return finalList;
    }

    public List<StaffInfo> getStaffInfoByCardId(String idCard) {
        if (StringUtils.isEmpty((CharSequence)idCard)) {
            return null;
        }
        ArrayList<StaffInfo> finalList = new ArrayList<StaffInfo>();
        List sbis = this.staffBasicInfoService.getAllBasicInfoByIdCard(idCard);
        for (StaffBasicInfo sbi : sbis) {
            Example e = new Example(StaffInfo.class);
            e.createCriteria().andEqualTo("staffBasicId", (Object)sbi.getId()).andEqualTo("isValid", (Object)Global.TRUE);
            List list = this.staffInfoMapper.selectByExample(e);
            for (StaffInfo s : list) {
                s.setStaffBasicInfo(sbi);
            }
            if (list.size() <= 0) continue;
            finalList.addAll(list);
        }
        return finalList;
    }

    @Transactional(readOnly=false)
    public List<StaffHeaderSet> getStaffHeaderSetsByCid(Long cid, StaffListHeaderEnum[] defaultHeader, Boolean isThirdParty, Long loginStaffId) {
        Example e = new Example(StaffHeaderSet.class);
        e.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isThirdCompany", (Object)isThirdParty).andEqualTo("isValid", (Object)Global.TRUE);
        List listFromDB = this.staffHeaderSetMapper.selectByExample(e);
        if (listFromDB.size() <= 0) {
            StaffHeaderSet shs;
            for (StaffListHeaderEnum slhe : defaultHeader) {
                if (Global.TRUE.equals(slhe.getThirdParty())) continue;
                shs = new StaffHeaderSet();
                shs.setCid(cid);
                shs.setCreateBy(loginStaffId);
                shs.setUpdateBy(loginStaffId);
                shs.setCreateDate(new Date());
                shs.setUpdateDate(new Date());
                shs.setIsValid(Global.TRUE);
                shs.setIsThirdCompany(isThirdParty);
                shs.setHeaderName(slhe.getHeaderName());
                shs.setHeaderValue(Integer.valueOf(slhe.getValue().intValue()));
                shs.setIsSelect(slhe.getIsSelected());
                shs.setId(Long.valueOf(this.idworker.nextId()));
                this.staffHeaderSetMapper.insert(shs);
                listFromDB.add(shs);
            }
            for (StaffListHeaderEnum slhe : defaultHeader) {
                if (Global.FALSE.equals(slhe.getThirdParty())) continue;
                shs = new StaffHeaderSet();
                shs.setCid(cid);
                shs.setCreateBy(loginStaffId);
                shs.setUpdateBy(loginStaffId);
                shs.setCreateDate(new Date());
                shs.setUpdateDate(new Date());
                shs.setIsValid(Global.TRUE);
                shs.setIsThirdCompany(Boolean.valueOf(isThirdParty == false));
                shs.setHeaderName(slhe.getHeaderName());
                shs.setHeaderValue(Integer.valueOf(slhe.getValue().intValue()));
                shs.setIsSelect(slhe.getIsSelected());
                shs.setId(Long.valueOf(this.idworker.nextId()));
                this.staffHeaderSetMapper.insert(shs);
                listFromDB.add(shs);
            }
        }
        return listFromDB;
    }

    @Transactional(readOnly=false)
    public void submitStaffHeaderSets(Boolean isThirdParty, Long cid, String headerValues, Long loginStaffId) {
        StaffHeaderSet shs;
        String[] headerValuesArr = headerValues.split(",");
        Example ex = new Example(StaffHeaderSet.class);
        ex.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isSelect", (Object)true);
        StaffHeaderSet s = new StaffHeaderSet();
        s.setIsSelect(Global.FALSE);
        this.staffHeaderSetMapper.updateByExampleSelective(s, ex);
        for (String str : headerValuesArr) {
            shs = new StaffHeaderSet();
            shs.setCid(cid);
            shs.setCreateBy(loginStaffId);
            shs.setUpdateBy(loginStaffId);
            shs.setCreateDate(new Date());
            shs.setUpdateDate(new Date());
            shs.setIsThirdCompany(Boolean.valueOf(false));
            shs.setHeaderName(StaffListHeaderEnum.getHeaderName((Byte)Byte.valueOf(str)));
            shs.setIsSelect(Global.TRUE);
            ex = new Example(StaffHeaderSet.class);
            ex.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isThirdCompany", (Object)false).andEqualTo("headerValue", (Object)Integer.valueOf(str));
            this.staffHeaderSetMapper.updateByExampleSelective(shs, ex);
        }
        for (String str : headerValuesArr) {
            shs = new StaffHeaderSet();
            shs.setCid(cid);
            shs.setCreateBy(loginStaffId);
            shs.setUpdateBy(loginStaffId);
            shs.setCreateDate(new Date());
            shs.setUpdateDate(new Date());
            shs.setIsThirdCompany(Boolean.valueOf(true));
            shs.setHeaderName(StaffListHeaderEnum.getHeaderName((Byte)Byte.valueOf(str)));
            shs.setIsSelect(Global.TRUE);
            ex = new Example(StaffHeaderSet.class);
            ex.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isThirdCompany", (Object)true).andEqualTo("headerValue", (Object)Integer.valueOf(str));
            this.staffHeaderSetMapper.updateByExampleSelective(shs, ex);
        }
    }

    public List<HealthCheckStaffInfoVo> getRecommendHealthCheckStaffInfosBySearch(HealthCheckStaffInfoQuery query) {
        query.setSearchKeyEncrypt(query.getSearchKey());
        List<HealthCheckStaffInfoVo> list = this.staffInfoMapper.getRecommendHealthCheckStaffInfosBySearch(query);
        if (list != null && list.size() > 0) {
            for (HealthCheckStaffInfoVo vo : list) {
                WorkRoleInfo wrf;
                CompanyOrganization co;
                if (vo.getGender() != null) {
                    if (StaffGenderEnum.MALE.getValue().byteValue() == vo.getGender().byteValue()) {
                        vo.setGenderName(StaffGenderEnum.MALE.getName());
                    }
                    if (StaffGenderEnum.FEMALE.getValue().byteValue() == vo.getGender().byteValue()) {
                        vo.setGenderName(StaffGenderEnum.FEMALE.getName());
                    }
                }
                if (vo.getOrgId() != null && (co = (CompanyOrganization)this.companyOrganizationService.getById(vo.getOrgId())) != null) {
                    vo.setOrgName(co.getOrganizationName());
                }
                if (vo.getWorkId() != null && (wrf = (WorkRoleInfo)this.workRoleInfoService.getById(vo.getWorkId())) != null) {
                    vo.setWorkName(wrf.getWorkName() + "/" + wrf.getOrgName());
                }
                List ps = this.staffWorkRoleService.getPluralityStaffWorkRolesByStaffId(vo.getStaffId());
                ArrayList<Long> pluralityIds = new ArrayList<Long>();
                vo.setPluralityIds(pluralityIds);
                if (ps == null || ps.size() <= 0) continue;
                Object pluralityNames = "";
                for (StaffWorkRole s : ps) {
                    if (s.getWorkRoleId() == null) continue;
                    WorkRoleInfo wrf2 = (WorkRoleInfo)this.workRoleInfoService.getById(s.getWorkRoleId());
                    pluralityIds.add(s.getWorkRoleId());
                    if (wrf2 == null) continue;
                    pluralityNames = (String)pluralityNames + "," + wrf2.getWorkName() + "/" + wrf2.getOrgName();
                }
                if (!StringUtils.isNotEmpty((String)pluralityNames)) continue;
                vo.setPluralityNames(((String)pluralityNames).substring(1, ((String)pluralityNames).length()));
            }
        }
        return list;
    }

    public PageInfo<HealthCheckStaffInfoVo> getRecommendHealthCheckStaffInfosPageBySearch(JqGridParam param, HealthCheckStaffInfoQuery query) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<HealthCheckStaffInfoVo> list = this.getRecommendHealthCheckStaffInfosBySearch(query);
        return new PageInfo(list);
    }

    @Transactional(readOnly=false)
    public StaffInfo addNewStaffInfoSubmit(StaffInfo staffInfo) {
        if (staffInfo.getStaffBasicInfo() != null) {
            this.staffBasicInfoService.add((Object)staffInfo.getStaffBasicInfo(), staffInfo.getCreateBy(), staffInfo.getCid());
            staffInfo.setStaffBasicId(staffInfo.getStaffBasicInfo().getId());
        }
        this.add(staffInfo, staffInfo.getCreateBy(), staffInfo.getCid());
        StaffBasicWork staffBasicWork = staffInfo.getStaffBasicWork();
        if (staffBasicWork != null) {
            StaffInfo furloughStaffInfo;
            staffBasicWork.setStaffId(staffInfo.getId());
            staffBasicWork.setCid(staffInfo.getCid());
            staffBasicWork.setCreateBy(staffInfo.getCreateBy());
            staffBasicWork.setIsRadiation(Global.FALSE);
            this.staffBasicWorkService.add((Object)staffBasicWork, staffInfo.getCreateBy(), staffInfo.getCid());
            StaffWorkRole staffWorkRole = staffBasicWork.getCurrentStaffWorkRole();
            if (staffWorkRole != null) {
                staffWorkRole.setCid(staffInfo.getCid());
                staffWorkRole.setStaffId(staffInfo.getId());
                staffWorkRole.setIsThirdParty(Global.FALSE);
                staffWorkRole.setIsHistory(Global.FALSE);
                staffWorkRole.setCreateBy(staffInfo.getCreateBy());
                this.staffWorkRoleService.add((Object)staffWorkRole, staffInfo.getCreateBy(), staffInfo.getCid());
            }
            if (staffBasicWork.getCurrentStaffWorkRole().getStatus() == StaffWorkStatusEnum.ONWORKING.getValue() && staffBasicWork.getStaffInfo().getIsNewStaff() != null && staffBasicWork.getStaffInfo().getIsNewStaff().booleanValue()) {
                this.createNoInformStaff(staffBasicWork.getCurrentStaffWorkRole(), NoInformStaffChangeWorkStatusEnum.ONWORKING, staffInfo.getCreateBy(), staffInfo.getCid());
                this.goToContractInform(staffBasicWork.getCurrentStaffWorkRole(), ContractInformReasonEnum.GOTOWORK, staffInfo.getId(), staffInfo.getCreateBy(), staffInfo.getCid());
            }
            if ((furloughStaffInfo = staffBasicWork.getStaffInfo()) != null) {
                furloughStaffInfo.setId(staffInfo.getId());
                this.update(furloughStaffInfo);
            }
            List oldPluralityStaffWorkRoles = this.staffWorkRoleService.getAllPluralityStaffWorkRolesByStaffId(staffInfo.getId());
            HashMap<CallSite, StaffWorkRole> oldPluralityStaffWorkRolesMap = new HashMap<CallSite, StaffWorkRole>();
            for (StaffWorkRole s : oldPluralityStaffWorkRoles) {
                oldPluralityStaffWorkRolesMap.put((CallSite)((Object)("" + s.getWorkRoleId())), s);
                if (!Global.TRUE.equals(s.getIsValid())) continue;
                s.setIsValid(Global.FALSE);
                this.staffWorkRoleService.update((Object)s, staffInfo.getCreateBy());
            }
            HashMap<CallSite, StaffWorkRole> newPluralityStaffWorkRolesMap = new HashMap<CallSite, StaffWorkRole>();
            if (staffBasicWork.getPluralityStaffWorkRoles() != null) {
                for (StaffWorkRole s : staffBasicWork.getPluralityStaffWorkRoles()) {
                    s.setStaffId(staffInfo.getId());
                    newPluralityStaffWorkRolesMap.put((CallSite)((Object)("" + s.getWorkRoleId())), s);
                }
            }
            for (String key : newPluralityStaffWorkRolesMap.keySet()) {
                StaffWorkRole oldWork = (StaffWorkRole)oldPluralityStaffWorkRolesMap.get(key);
                if (oldWork == null) {
                    ((StaffWorkRole)newPluralityStaffWorkRolesMap.get(key)).setId(null);
                    this.staffWorkRoleService.add((Object)((StaffWorkRole)newPluralityStaffWorkRolesMap.get(key)), staffInfo.getCreateBy(), staffInfo.getCid());
                }
                if (oldWork == null || !Global.FALSE.equals(oldWork.getIsValid())) continue;
                oldWork.setIsValid(Global.TRUE);
                this.staffWorkRoleService.update((Object)oldWork, staffInfo.getCreateBy());
            }
        }
        return staffInfo;
    }

    @Transactional(readOnly=false)
    public void editNewStaffInfoSubmit(StaffInfo staffInfo, Long loginStaffId, Long cid) {
        StaffBasicWork staffBasicWork;
        this.update(staffInfo, loginStaffId);
        if (staffInfo.getStaffBasicInfo() != null) {
            this.staffBasicInfoService.update((Object)staffInfo.getStaffBasicInfo(), loginStaffId);
        }
        if ((staffBasicWork = staffInfo.getStaffBasicWork()) != null) {
            this.staffBasicWorkService.update((Object)staffBasicWork, loginStaffId);
            if (staffBasicWork.getStaffInfo() != null) {
                this.update(staffBasicWork.getStaffInfo(), loginStaffId);
                if (staffBasicWork.getStaffInfo().getFurloughStatus() != null && staffBasicWork.getStaffInfo().getFurloughStatus() == StaffFurloughStatusEnum.FURLOUGHEND.getCode() && staffBasicWork.getStaffInfo().getFurloughBeginTime() != null && staffBasicWork.getStaffInfo().getFurloughEndTime() != null && DateUtils.getDistanceOfTwoDate((Date)staffBasicWork.getStaffInfo().getFurloughBeginTime(), (Date)staffBasicWork.getStaffInfo().getFurloughEndTime()) >= 60.0) {
                    this.createNoInformStaff(staffBasicWork.getCurrentStaffWorkRole(), NoInformStaffChangeWorkStatusEnum.AGAINWORK, loginStaffId, cid);
                    ContractInform inform = this.goToContractInform(staffBasicWork.getCurrentStaffWorkRole(), ContractInformReasonEnum.AGAINWORK, staffBasicWork.getStaffInfo().getId(), loginStaffId, cid);
                    if (inform != null) {
                        staffBasicWork.getCurrentStaffWorkRole().setInformId(inform.getId());
                        this.staffWorkRoleService.update((Object)staffBasicWork.getCurrentStaffWorkRole(), loginStaffId);
                        if (staffBasicWork.getCurrentStaffWorkRole() != null) {
                            // empty if block
                        }
                    }
                }
            }
            if (staffBasicWork.getCurrentStaffWorkRole() != null) {
                if (staffBasicWork.getCurrentStaffWorkRole().getId() == null) {
                    this.staffWorkRoleService.add((Object)staffBasicWork.getCurrentStaffWorkRole(), loginStaffId, cid);
                } else if (staffBasicWork.getStaffInfo() != null && (staffBasicWork.getStaffInfo().getChangeWorkStatus() == NoInformStaffChangeWorkStatusEnum.TRANSFER.getValue() || staffBasicWork.getStaffInfo().getChangeWorkStatus() == NoInformStaffChangeWorkStatusEnum.AGAINWORK.getValue())) {
                    Long beforeCurrentStaffWorkRoleId = staffBasicWork.getCurrentStaffWorkRole().getId();
                    Date beforeCurrentLeaveTime = staffBasicWork.getCurrentStaffWorkRole().getLeaveTime();
                    staffBasicWork.getCurrentStaffWorkRole().setId(null);
                    staffBasicWork.getCurrentStaffWorkRole().setLeaveTime(null);
                    this.staffWorkRoleService.add((Object)staffBasicWork.getCurrentStaffWorkRole(), loginStaffId, cid);
                    if (staffBasicWork.getStaffInfo().getChangeWorkStatus() == NoInformStaffChangeWorkStatusEnum.TRANSFER.getValue()) {
                        this.createNoInformStaff(staffBasicWork.getCurrentStaffWorkRole(), NoInformStaffChangeWorkStatusEnum.TRANSFER, loginStaffId, cid);
                    }
                    if (staffBasicWork.getStaffInfo().getChangeWorkStatus() == NoInformStaffChangeWorkStatusEnum.AGAINWORK.getValue() && staffBasicWork.getStaffInfo().getIsNewStaff() != null && staffBasicWork.getStaffInfo().getIsNewStaff().booleanValue()) {
                        this.createNoInformStaff(staffBasicWork.getCurrentStaffWorkRole(), NoInformStaffChangeWorkStatusEnum.AGAINWORK, loginStaffId, cid);
                    }
                    this.noInformStaffService.updateBeforeNoInformStaffNoValidBybeforeCurrentStaffWorkRoleId(beforeCurrentStaffWorkRoleId, cid, loginStaffId);
                    this.goToContractInform(staffBasicWork.getCurrentStaffWorkRole(), ContractInformReasonEnum.TRANSFERWORK, staffBasicWork.getStaffInfo().getId(), loginStaffId, cid);
                    staffBasicWork.getCurrentStaffWorkRole().setId(beforeCurrentStaffWorkRoleId);
                    staffBasicWork.getCurrentStaffWorkRole().setWorkRoleId(null);
                    staffBasicWork.getCurrentStaffWorkRole().setBeginTime(null);
                    staffBasicWork.getCurrentStaffWorkRole().setLeaveTime(beforeCurrentLeaveTime);
                    if (staffBasicWork.getStaffInfo().getChangeWorkStatus() == NoInformStaffChangeWorkStatusEnum.TRANSFER.getValue()) {
                        staffBasicWork.getCurrentStaffWorkRole().setStatus(StaffWorkStatusEnum.TRANSFER.getValue());
                    }
                    if (staffBasicWork.getStaffInfo().getChangeWorkStatus() == NoInformStaffChangeWorkStatusEnum.AGAINWORK.getValue()) {
                        staffBasicWork.getCurrentStaffWorkRole().setStatus(StaffWorkStatusEnum.NOWORKED.getValue());
                    }
                    staffBasicWork.getCurrentStaffWorkRole().setWorkProperty(StaffWorkPropertyEnum.WORKED.getValue());
                    staffBasicWork.getCurrentStaffWorkRole().setIsHistory(Global.TRUE);
                    this.staffWorkRoleService.update((Object)staffBasicWork.getCurrentStaffWorkRole(), loginStaffId);
                } else {
                    this.staffWorkRoleService.update((Object)staffBasicWork.getCurrentStaffWorkRole(), loginStaffId);
                    if (staffBasicWork.getCurrentStaffWorkRole().getStatus() == StaffWorkStatusEnum.ONWORKING.getValue() && staffBasicWork.getStaffInfo().getIsNewStaff() != null && staffBasicWork.getStaffInfo().getIsNewStaff().booleanValue()) {
                        this.createNoInformStaff(staffBasicWork.getCurrentStaffWorkRole(), NoInformStaffChangeWorkStatusEnum.ONWORKING, loginStaffId, cid);
                        this.goToContractInform(staffBasicWork.getCurrentStaffWorkRole(), ContractInformReasonEnum.GOTOWORK, staffBasicWork.getStaffInfo().getId(), loginStaffId, cid);
                    }
                }
            }
            List oldPluralityStaffWorkRoles = this.staffWorkRoleService.getAllPluralityStaffWorkRolesByStaffId(staffBasicWork.getStaffInfo().getId());
            HashMap<CallSite, StaffWorkRole> oldPluralityStaffWorkRolesMap = new HashMap<CallSite, StaffWorkRole>();
            for (StaffWorkRole s : oldPluralityStaffWorkRoles) {
                oldPluralityStaffWorkRolesMap.put((CallSite)((Object)("" + s.getWorkRoleId())), s);
                if (!Global.TRUE.equals(s.getIsValid())) continue;
                s.setIsValid(Global.FALSE);
                this.staffWorkRoleService.update((Object)s, loginStaffId);
            }
            HashMap<CallSite, StaffWorkRole> newPluralityStaffWorkRolesMap = new HashMap<CallSite, StaffWorkRole>();
            if (staffBasicWork.getPluralityStaffWorkRoles() != null) {
                for (StaffWorkRole s : staffBasicWork.getPluralityStaffWorkRoles()) {
                    newPluralityStaffWorkRolesMap.put((CallSite)((Object)("" + s.getWorkRoleId())), s);
                }
            }
            for (String key : newPluralityStaffWorkRolesMap.keySet()) {
                StaffWorkRole oldWork = (StaffWorkRole)oldPluralityStaffWorkRolesMap.get(key);
                if (oldWork == null) {
                    ((StaffWorkRole)newPluralityStaffWorkRolesMap.get(key)).setId(null);
                    this.staffWorkRoleService.add((Object)((StaffWorkRole)newPluralityStaffWorkRolesMap.get(key)), loginStaffId, cid);
                }
                if (oldWork == null || !Global.FALSE.equals(oldWork.getIsValid())) continue;
                oldWork.setIsValid(Global.TRUE);
                this.staffWorkRoleService.update((Object)oldWork, loginStaffId);
            }
        }
    }

    private ContractInform goToContractInform(StaffWorkRole workRole, ContractInformReasonEnum reason, Long staffId, Long loginStaffId, Long cid) {
        ContractInform inform = new ContractInform();
        inform.setInformState(Long.valueOf(0L));
        inform.setInformWorkId(workRole.getWorkRoleId());
        inform.setStaffId(staffId);
        inform.setIsValid(Global.TRUE);
        inform.setInformReason("" + reason.getValue());
        inform.setStaffWorkRoleId(workRole.getId());
        inform = this.contractInformService.informContractInformFromWorkChange(inform, loginStaffId, cid);
        return inform;
    }

    private NoInformStaff createNoInformStaff(StaffWorkRole staffWorkRole, NoInformStaffChangeWorkStatusEnum status, Long loginStaffId, Long cid) {
        NoInformStaff noInformStaff = this.noInformStaffService.getNotInformStaffByStaffWorkRoleId(staffWorkRole.getId(), cid);
        if (noInformStaff != null) {
            noInformStaff.setChangWorkStatus(status.getValue());
            noInformStaff.setStaffId(staffWorkRole.getStaffId());
            noInformStaff.setWorkInfoId(staffWorkRole.getWorkRoleId());
            noInformStaff.setStaffWorkRoleId(staffWorkRole.getId());
            this.noInformStaffService.update((Object)noInformStaff, loginStaffId);
        } else {
            noInformStaff = new NoInformStaff();
            noInformStaff.setChangWorkStatus(status.getValue());
            noInformStaff.setStaffId(staffWorkRole.getStaffId());
            noInformStaff.setWorkInfoId(staffWorkRole.getWorkRoleId());
            noInformStaff.setStaffWorkRoleId(staffWorkRole.getId());
            this.noInformStaffService.add((Object)noInformStaff, loginStaffId, cid);
        }
        return noInformStaff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(readOnly=false)
    public List<StaffInfoExcelImportVo> getNewStaffBatchInfoFromExcelForInit(String ossfile, Long cid, Long loginStaffId) {
        HSSFWorkbook wb = null;
        ArrayList<StaffInfoExcelImportVo> list = new ArrayList<StaffInfoExcelImportVo>();
        try {
            wb = new HSSFWorkbook(ExcelUtil.getInstance().getOssInputStream(ossfile));
        }
        catch (Exception i) {
        }
        finally {
            if (wb != null) {
                try {
                    for (int i = 0; i < wb.getNumberOfSheets(); ++i) {
                        StaffInfoNeedImportVo data;
                        if (StaffExcelSheetNameEnum.SELFCOMPANY.getName().equals(wb.getSheetAt(i).getSheetName().trim())) {
                            data = this.getStaffInfoFromExcel(wb.getSheetAt(i), loginStaffId, cid, false, StaffExcelSheetNameEnum.SELFCOMPANY.getVal());
                            list.addAll(data.getStaffList());
                        }
                        if (!StaffExcelSheetNameEnum.THIRDCOMPANY.getName().equals(wb.getSheetAt(i).getSheetName().trim())) continue;
                        data = this.getStaffInfoFromExcel(wb.getSheetAt(i), loginStaffId, cid, true, StaffExcelSheetNameEnum.THIRDCOMPANY.getVal());
                        list.addAll(data.getStaffList());
                    }
                    wb.close();
                }
                catch (IOException i) {}
            }
        }
        return list;
    }

    @Transactional(readOnly=false)
    public List<StaffInfoExcelImportVo> coverUpdateStaffDataFromExcel(List<StaffInfoExcelImportVo> cacheObj, Long loginStaffId) {
        ArrayList<StaffInfoExcelImportVo> updatedSheetDatas = new ArrayList<StaffInfoExcelImportVo>();
        for (StaffInfoExcelImportVo v : cacheObj) {
            StaffBasicInfo staffBasicInfo;
            StaffBasicWork staffBasicWork = v.getStaffBasicWork();
            StaffBasicWork staffBasicWorkFromDB = (StaffBasicWork)this.staffBasicWorkService.getById(staffBasicWork.getId());
            StaffWorkRole currentStaffWorkRole = v.getCurrentStaffWorkRole();
            StaffWorkRole currentStaffWorkRoleDB = (StaffWorkRole)this.staffWorkRoleService.getById(currentStaffWorkRole.getId());
            StaffInfo staffInfo = v.getStaffInfo();
            if (staffInfo != null && staffInfo.getId() != null) {
                this.update(staffInfo, loginStaffId);
            }
            if ((staffBasicInfo = v.getStaffBasicInfo()) != null && staffBasicInfo.getId() != null) {
                this.staffBasicInfoService.update((Object)staffBasicInfo, loginStaffId);
            }
            if (staffBasicWork != null && staffBasicWork.getId() != null) {
                boolean hasData = true;
                this.staffBasicWorkService.update((Object)staffBasicWork, loginStaffId);
                if (staffBasicWork.getOrgId() != null && staffInfo != null && staffInfo.getId() != null) {
                    StaffInfo staffInfoOrg = new StaffInfo();
                    staffInfoOrg.setId(staffInfo.getId());
                    staffInfoOrg.setOrgId(staffBasicWork.getOrgId());
                    this.update(staffInfoOrg, loginStaffId);
                }
            }
            if (currentStaffWorkRole != null && currentStaffWorkRole.getId() != null) {
                this.staffWorkRoleService.update((Object)currentStaffWorkRole, loginStaffId);
                StaffWorkRole hisWork = this.staffWorkRoleService.getCurrentStaffWorkRoleHistory(staffInfo.getId(), currentStaffWorkRole.getWorkRoleId());
                if (hisWork != null) {
                    hisWork.setBeginTime(currentStaffWorkRole.getBeginTime());
                    this.staffWorkRoleService.update((Object)hisWork, loginStaffId);
                } else {
                    StaffWorkRole curHistoryStaffWorkRole = new StaffWorkRole();
                    curHistoryStaffWorkRole.setCid(staffInfo.getCid());
                    curHistoryStaffWorkRole.setBeginTime(currentStaffWorkRole.getBeginTime());
                    curHistoryStaffWorkRole.setIsHistory(Boolean.valueOf(true));
                    curHistoryStaffWorkRole.setIsThirdParty(currentStaffWorkRole.getIsThirdParty());
                    curHistoryStaffWorkRole.setLeaveTime(currentStaffWorkRole.getLeaveTime());
                    curHistoryStaffWorkRole.setStaffId(staffInfo.getId());
                    curHistoryStaffWorkRole.setStatus(currentStaffWorkRole.getStatus());
                    curHistoryStaffWorkRole.setWorkProperty(StaffWorkPropertyEnum.WORKED.getValue());
                    curHistoryStaffWorkRole.setWorkRoleId(currentStaffWorkRole.getWorkRoleId());
                    this.staffWorkRoleService.add((Object)curHistoryStaffWorkRole, loginStaffId, staffInfo.getCid());
                }
            }
            if (v.getIsRadiation() != null && v.getIsRadiation().booleanValue()) {
                WorkNatureInfo radiationWork = new WorkNatureInfo();
                radiationWork.setIsWork(v.getIsRadiation());
                radiationWork.setIsDefault(Boolean.valueOf(false));
                if (v.getRadiationYear() != null) {
                    radiationWork.setWorkBeginTime(v.getRadiationYear());
                }
                radiationWork.setWorkType(v.getRadiationTypeName());
                radiationWork.setNature(Byte.valueOf(WorkNatureEnum.RadiationWork.getValue()));
                radiationWork.setNatureName(WorkNatureEnum.RadiationWork.getName());
                radiationWork.setStaffId(staffInfo.getId());
                radiationWork.setCid(staffInfo.getCid());
                this.workNatureInfoService.add((Object)radiationWork, loginStaffId, staffInfo.getCid());
            }
            if (v.getSpecialOperationsName() == null) continue;
            WorkNatureInfo radiationWork = new WorkNatureInfo();
            radiationWork.setIsWork(Boolean.valueOf(true));
            radiationWork.setIsDefault(Boolean.valueOf(false));
            radiationWork.setWorkType(v.getSpecialOperationsName());
            radiationWork.setNature(Byte.valueOf(WorkNatureEnum.ParticularWork.getValue()));
            radiationWork.setNatureName(WorkNatureEnum.ParticularWork.getName());
            radiationWork.setStaffId(staffInfo.getId());
            radiationWork.setCid(staffInfo.getCid());
            this.workNatureInfoService.add((Object)radiationWork, loginStaffId, staffInfo.getCid());
        }
        return updatedSheetDatas;
    }

    public List<StaffInfo> getHarmStaffIdsByWork(Long workId, Long cid) {
        List list = this.staffWorkRoleService.getStaffWorkRoleByCidAndWorkIdAndNoHistory(workId, cid);
        ArrayList<CallSite> staffIds = new ArrayList<CallSite>();
        ArrayList<StaffInfo> finalList = new ArrayList<StaffInfo>();
        for (StaffWorkRole s : list) {
            StaffBasicInfo info;
            StaffInfo staffInfo;
            if (s.getStaffId() == null || (staffInfo = (StaffInfo)this.getById(s.getStaffId())) == null || staffInfo.getStaffBasicId() == null || (info = (StaffBasicInfo)this.staffBasicInfoService.getById(staffInfo.getStaffBasicId())) == null || !info.getIsValid().booleanValue() || staffIds.contains("" + s.getStaffId())) continue;
            staffIds.add((CallSite)((Object)("" + s.getStaffId())));
            staffInfo.setStaffBasicInfo(info);
            finalList.add(staffInfo);
        }
        return finalList;
    }

    public List<StaffInfo> getHarmStaffIdsByCid(Long cid) {
        List workList = this.harmfactorWorkService.getHarmfactorWorkListByCid(cid.longValue());
        ArrayList<CallSite> staffIds = new ArrayList<CallSite>();
        ArrayList<StaffInfo> finalList = new ArrayList<StaffInfo>();
        for (HarmfactorWork work : workList) {
            List list;
            if (work == null || work.getWorkId() == null || (list = this.staffWorkRoleService.getStaffWorkRoleByCidAndWorkIdAndNoHistory(work.getWorkId(), cid)) == null || list.size() <= 0) continue;
            for (StaffWorkRole s : list) {
                StaffBasicInfo info;
                StaffInfo staffInfo;
                if (s.getStaffId() == null || s.getStatus() == StaffWorkStatusEnum.NOWORKED.getValue() || (staffInfo = (StaffInfo)this.getById(s.getStaffId())) == null || staffInfo.getStaffBasicId() == null || (info = (StaffBasicInfo)this.staffBasicInfoService.getById(staffInfo.getStaffBasicId())) == null || !info.getIsValid().booleanValue() || staffIds.contains("" + s.getStaffId())) continue;
                staffIds.add((CallSite)((Object)("" + s.getStaffId())));
                staffInfo.setStaffBasicInfo(info);
                staffInfo.setStaffWorkRole(s);
                finalList.add(staffInfo);
            }
        }
        return finalList;
    }

    public List<StaffInfo> getHarmStaffIdsByCidAndStatus(Long cid, StaffWorkStatusEnum status) {
        List workList = this.harmfactorWorkService.getHarmfactorWorkListByCid(cid.longValue());
        ArrayList<CallSite> staffIds = new ArrayList<CallSite>();
        ArrayList<StaffInfo> finalList = new ArrayList<StaffInfo>();
        for (HarmfactorWork work : workList) {
            List list;
            if (work == null || work.getWorkId() == null || (list = this.staffWorkRoleService.geCurrenttStaffWorkRoleByCidAndWorkIdAndNoHistory(work.getWorkId(), cid)) == null || list.size() <= 0) continue;
            for (StaffWorkRole s : list) {
                StaffBasicInfo info;
                StaffInfo staffInfo;
                if (s.getStatus() == null) {
                    s.setStatus(StaffWorkStatusEnum.ONWORKING.getValue());
                }
                if (s.getStaffId() == null || s.getStatus() != status.getValue() || (staffInfo = (StaffInfo)this.getById(s.getStaffId())) == null || staffInfo.getStaffBasicId() == null || (info = (StaffBasicInfo)this.staffBasicInfoService.getById(staffInfo.getStaffBasicId())) == null || !info.getIsValid().booleanValue() || staffIds.contains("" + s.getStaffId())) continue;
                staffIds.add((CallSite)((Object)("" + s.getStaffId())));
                staffInfo.setStaffBasicInfo(info);
                staffInfo.setStaffWorkRole(s);
                finalList.add(staffInfo);
            }
        }
        return finalList;
    }

    @Transactional(readOnly=false)
    public StaffInfo addNewStaffInfoSubmitV24(StaffInfo staffInfo) {
        if (ObjectUtil.isNotNull((Object)staffInfo.getStaffBasicInfo()) && StringUtils.isNotEmpty((String)staffInfo.getStaffBasicInfo().getIdCard())) {
            String idCard = staffInfo.getStaffBasicInfo().getIdCard();
            staffInfo.getStaffBasicInfo().setIdCard(idCard.toUpperCase());
        }
        this.staffBasicInfoService.add((Object)staffInfo.getStaffBasicInfo(), staffInfo.getCreateBy(), staffInfo.getCid());
        staffInfo.setStaffBasicId(staffInfo.getStaffBasicInfo().getId());
        StaffWorkChangeStatusRecordEnum workChangeRecord = StaffWorkChangeStatusRecordEnum.getThisEnumByFlag((String)("0" + staffInfo.getStaffBasicWork().getCurrentStaffWorkRole().getStatus()));
        if (workChangeRecord != null) {
            staffInfo.setWorkChangeStatusRecord(workChangeRecord.getValue());
            if (staffInfo.getWorkChangeStatusRecord() == StaffWorkChangeStatusRecordEnum.NOSTATUS_TO_FURLOUGH.getValue()) {
                staffInfo.setFurloughStatus(StaffFurloughStatusEnum.FURLOUGHING.getCode());
            }
        }
        if (staffInfo.getFurloughStatus() == StaffFurloughStatusEnum.FURLOUGHING.getCode() && staffInfo.getFurloughBeginTime() == null) {
            staffInfo.setFurloughBeginTime(new Date());
        }
        this.add(staffInfo, staffInfo.getCreateBy(), staffInfo.getCid());
        StaffBasicWork staffBasicWork = staffInfo.getStaffBasicWork();
        staffBasicWork.setStaffId(staffInfo.getId());
        staffBasicWork.setCid(staffInfo.getCid());
        staffBasicWork.setCreateBy(staffInfo.getCreateBy());
        if (staffBasicWork.getIsRadiation() == null) {
            staffBasicWork.setIsRadiation(Global.FALSE);
        }
        staffInfo.setOrgId(staffBasicWork.getOrgId());
        this.staffBasicWorkService.add((Object)staffBasicWork, staffInfo.getCreateBy(), staffInfo.getCid());
        StaffWorkRole staffWorkRole = staffBasicWork.getCurrentStaffWorkRole();
        staffWorkRole.setCid(staffInfo.getCid());
        staffWorkRole.setStaffId(staffInfo.getId());
        staffWorkRole.setIsThirdParty(Global.FALSE);
        staffWorkRole.setIsHistory(Global.FALSE);
        staffWorkRole.setCreateBy(staffInfo.getCreateBy());
        StaffWorkRole curHistoryStaffWorkRole = new StaffWorkRole();
        curHistoryStaffWorkRole.setCid(staffInfo.getCid());
        curHistoryStaffWorkRole.setBeginTime(staffWorkRole.getBeginTime());
        curHistoryStaffWorkRole.setIsHistory(Global.TRUE);
        curHistoryStaffWorkRole.setIsThirdParty(staffWorkRole.getIsThirdParty());
        curHistoryStaffWorkRole.setLeaveTime(staffWorkRole.getLeaveTime());
        curHistoryStaffWorkRole.setFirstBeginTime(staffWorkRole.getFirstBeginTime());
        curHistoryStaffWorkRole.setStaffId(staffWorkRole.getStaffId());
        curHistoryStaffWorkRole.setStatus(staffWorkRole.getStatus());
        curHistoryStaffWorkRole.setWorkProperty(StaffWorkPropertyEnum.WORKED.getValue());
        this.staffWorkRoleService.add((Object)curHistoryStaffWorkRole, staffInfo.getCreateBy(), staffInfo.getCid());
        this.staffWorkRoleService.add((Object)staffWorkRole, staffInfo.getCreateBy(), staffInfo.getCid());
        if (staffWorkRole.getStatus() == StaffWorkStatusEnum.ONWORKING.getValue()) {
            this.createNoInformStaff(staffWorkRole, NoInformStaffChangeWorkStatusEnum.ONWORKING, staffInfo.getCreateBy(), staffInfo.getCid());
        }
        return staffInfo;
    }

    @Transactional(readOnly=false)
    public void editNewStaffInfoSubmitV24(StaffInfo staffInfo, Long loginStaffId, Long cid, String operationType, Integer operationSelect) {
        StaffWorkRole oldCurrentStaffWorkRoleForHealth;
        if (ObjectUtil.isNotNull((Object)staffInfo.getStaffBasicInfo()) && StringUtils.isNotEmpty((String)staffInfo.getStaffBasicInfo().getIdCard())) {
            String idCard = staffInfo.getStaffBasicInfo().getIdCard();
            staffInfo.getStaffBasicInfo().setIdCard(idCard.toUpperCase());
        }
        if ((oldCurrentStaffWorkRoleForHealth = this.staffWorkRoleService.getCurrentStaffWorkRoleByStaffId(staffInfo.getId())) != null && oldCurrentStaffWorkRoleForHealth.getWorkRoleId() != null && !oldCurrentStaffWorkRoleForHealth.getWorkRoleId().equals(staffInfo.getStaffBasicWork().getCurrentStaffWorkRole().getWorkRoleId())) {
            this.phcPhysicalCheckRecommendIgnoredService.removeIgnoredByStaffId(staffInfo.getId());
        }
        StaffWorkRole dbCurrentStaffWorkRole = this.staffWorkRoleService.getCurrentStaffWorkRoleByStaffId(staffInfo.getId());
        StaffBasicWork oldStaffBasicWork = (StaffBasicWork)this.staffBasicWorkService.getById(staffInfo.getStaffBasicWork().getId());
        StaffBasicInfo basicInfo = (StaffBasicInfo)this.staffBasicInfoService.getById(staffInfo.getStaffBasicInfo().getId());
        List<StaffFieldChangeLog> logList = this.addStaffChangeLogList(staffInfo.getId(), cid, dbCurrentStaffWorkRole, staffInfo.getStaffBasicWork().getCurrentStaffWorkRole(), oldStaffBasicWork, staffInfo.getStaffBasicWork(), basicInfo.getJobName(), staffInfo.getStaffBasicInfo().getJobName(), loginStaffId);
        this.staffFieldChangeLogService.addChangeLogList(logList, loginStaffId);
        if (staffInfo.getStaffBasicWork().getCurrentStaffWorkRole().getStatus() == StaffWorkStatusEnum.FURLOUGH.getValue()) {
            staffInfo.setFurloughStatus(StaffFurloughStatusEnum.FURLOUGHING.getCode());
            if (staffInfo.getFurloughBeginTime() == null) {
                staffInfo.setFurloughBeginTime(new Date());
            }
        } else if (staffInfo.getFurloughStatus() == StaffFurloughStatusEnum.FURLOUGHEND.getCode()) {
            staffInfo.setFurloughEndTime(new Date());
        } else {
            staffInfo.setFurloughStatus(StaffFurloughStatusEnum.NOTFURLOUGH.getCode());
        }
        if (staffInfo.getOutsource() == null) {
            staffInfo.setOutsource(Byte.valueOf((byte)0));
        }
        staffInfo.setOrgId(staffInfo.getStaffBasicWork().getOrgId());
        StaffWorkRole currentStaffWorkRole = staffInfo.getStaffBasicWork().getCurrentStaffWorkRole();
        this.staffWorkRoleService.update((Object)currentStaffWorkRole, loginStaffId);
        this.staffBasicInfoService.update((Object)staffInfo.getStaffBasicInfo(), loginStaffId);
        StaffBasicWork staffBasicWork = staffInfo.getStaffBasicWork();
        this.update(staffInfo, loginStaffId);
        this.staffBasicWorkService.update((Object)staffBasicWork, loginStaffId);
        if (staffInfo.getOrgId() == null) {
            ((StaffInfoMapper)this.dao).setStaffOrgId(staffInfo.getId());
            ((StaffInfoMapper)this.dao).setStaffWorkOrgId(staffBasicWork.getId());
        }
    }

    public Integer getStaffOnWorkCountByCid(Long cid) {
        StaffInfoSearchParam param = new StaffInfoSearchParam();
        param.setCid(cid);
        param.setIsThirdParty(null);
        param.setIsSeniorSearch(Boolean.valueOf(false));
        param.setWorkStatus(StaffWorkStatusEnum.ONWORKING.getValue());
        param.setSearchKeyEncrypt(param.getSearchKey());
        param.setStaffNameEncrypt(param.getStaffName());
        List<StaffShowInfo> list = this.staffInfoMapper.getStaffInfoListBySearchParam(param);
        return list.size();
    }

    public Integer getStaffCountByCidAndIsThirdPartyAndOutsource(Long cid, Boolean isThirdParty, Byte outsource) {
        StaffInfoSearchParam param = new StaffInfoSearchParam();
        param.setCid(cid);
        param.setIsThirdParty(isThirdParty);
        param.setIsSeniorSearch(Boolean.valueOf(false));
        param.setOutsource(outsource);
        param.setSearchKeyEncrypt(param.getSearchKey());
        param.setStaffNameEncrypt(param.getStaffName());
        List<StaffShowInfo> list = this.staffInfoMapper.getStaffInfoListBySearchParam(param);
        return list.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean importStaffExcelFormatIsRight(String ossfile, Boolean isThirdParty, Byte outsource) {
        HSSFWorkbook wb = null;
        Boolean isRight = false;
        try {
            wb = new HSSFWorkbook(ExcelUtil.getInstance().getOssInputStream(ossfile));
            isRight = StaffExcelSheetNameEnum.SELFCOMPANY.getName().equals(wb.getSheetAt(0).getSheetName().trim()) && !isThirdParty.booleanValue() && wb.getNumberOfSheets() == 2 ? Boolean.valueOf(true) : (StaffExcelSheetNameEnum.THIRDCOMPANY.getName().equals(wb.getSheetAt(0).getSheetName().trim()) && wb.getNumberOfSheets() == 2 ? Boolean.valueOf(true) : Boolean.valueOf(false));
        }
        catch (Exception e) {
            isRight = false;
        }
        finally {
            try {
                if (wb == null) {
                    isRight = false;
                } else {
                    wb.close();
                }
            }
            catch (IOException e) {
                isRight = false;
            }
        }
        return isRight;
    }

    public String getStaffNameIncludeDelStatusByStaffId(Long staffId) {
        StaffBasicInfo bassicInfo;
        if (staffId == null) {
            return "";
        }
        StaffInfo staff = (StaffInfo)super.getById(staffId);
        if (staff != null && staff.getStaffBasicId() != null && (bassicInfo = (StaffBasicInfo)this.staffBasicInfoService.getById(staff.getStaffBasicId())) != null && StringUtils.isNotEmpty((String)bassicInfo.getRealName())) {
            if (!staff.getIsValid().booleanValue()) {
                return "(\u5df2\u5220\u9664)" + bassicInfo.getRealName();
            }
            return bassicInfo.getRealName();
        }
        return "";
    }

    public String getStaffNameAndWorkNoAndIncludeDelStatusByStaffId(Long staffId) {
        if (staffId == null) {
            return "";
        }
        StaffInfo staff = (StaffInfo)super.getById(staffId);
        if (staff != null && staff.getStaffBasicId() != null) {
            StaffBasicInfo bassicInfo = (StaffBasicInfo)this.staffBasicInfoService.getById(staff.getStaffBasicId());
            StaffBasicWork staffBasicWorkByStaffId = this.staffBasicWorkService.getStaffBasicWorkIncludeDelStatusByStaffId(staff.getStaffBasicId());
            if (bassicInfo != null && StringUtils.isNotEmpty((String)bassicInfo.getRealName())) {
                if (staffBasicWorkByStaffId != null && StringUtils.isNotEmpty((String)staffBasicWorkByStaffId.getWorkNo())) {
                    if (!staff.getIsValid().booleanValue()) {
                        return "(\u5df2\u5220\u9664)" + bassicInfo.getRealName() + "/" + staffBasicWorkByStaffId.getWorkNo();
                    }
                    return bassicInfo.getRealName() + "/" + staffBasicWorkByStaffId.getWorkNo();
                }
                if (!staff.getIsValid().booleanValue()) {
                    return "(\u5df2\u5220\u9664)" + bassicInfo.getRealName();
                }
                return bassicInfo.getRealName();
            }
        }
        return "";
    }

    public String getStaffNameIncludeDelStatusAndDepByStaffId(Long staffId) {
        StaffBasicInfo bassicInfo;
        if (staffId == null) {
            return "";
        }
        StaffInfo staff = (StaffInfo)super.getById(staffId);
        if (staff != null && staff.getStaffBasicId() != null && (bassicInfo = (StaffBasicInfo)this.staffBasicInfoService.getById(staff.getStaffBasicId())) != null) {
            String name = bassicInfo.getRealName() + "/";
            StaffBasicWork work = this.staffBasicWorkService.getStaffBasicWorkIncludeDeleteByStaffId(staff.getId());
            if (work != null && work.getOrgId() != null) {
                name = name + this.companyOrganizationService.getOrgNameById(work.getOrgId());
            }
            if (!staff.getIsValid().booleanValue()) {
                return "(\u5df2\u5220\u9664)" + name;
            }
            return name;
        }
        return "";
    }

    public String getStaffCurrentWorkNameByStaffId(Long staffId) {
        StaffWorkRole swr = this.staffWorkRoleService.getCurrentStaffWorkRoleByStaffId(staffId);
        String name = "";
        if (swr != null && swr.getWorkRoleInfo() != null) {
            name = swr.getWorkRoleInfo().getWorkName();
        }
        return name;
    }

    public String getStaffOrgNameByStaffId(Long staffId) {
        if (staffId == null) {
            return "";
        }
        StaffInfo staff = (StaffInfo)super.getById(staffId);
        if (staff != null) {
            Object name = "";
            StaffBasicWork work = this.staffBasicWorkService.getStaffBasicWorkIncludeDeleteByStaffId(staff.getId());
            if (work != null && work.getOrgId() != null) {
                name = (String)name + this.companyOrganizationService.getOrgNameById(work.getOrgId());
            }
            return name;
        }
        return "";
    }

    public String getHistroyRealNameByIdAndYear(Long staffId, Date year) {
        if (staffId == null || year == null) {
            return "";
        }
        StaffInfo staffInfo = (StaffInfo)this.getById(staffId);
        String name = null;
        if (staffInfo == null || staffInfo.getStaffBasicId() != null) {
            // empty if block
        }
        return name;
    }

    public StaffBasicInfo getHistroyStaffBasicInfoByIdAndYear(Long staffId, Date year) {
        if (staffId == null || year == null) {
            return null;
        }
        StaffInfo staffInfo = (StaffInfo)this.getById(staffId);
        if (staffInfo == null || staffInfo.getStaffBasicId() != null) {
            // empty if block
        }
        return null;
    }

    public List<HealthCheckStaffInfoVo> getBeforeWorkRecommendHealthCheckStaffInfosBySearch(HealthCheckStaffInfoQuery query) {
        query.setSearchKeyEncrypt(query.getSearchKey());
        List<HealthCheckStaffInfoVo> list = this.staffInfoMapper.getBeforeWorkRecommendHealthCheckStaffInfosBySearch(query);
        if (list != null && list.size() > 0) {
            for (HealthCheckStaffInfoVo vo : list) {
                WorkRoleInfo wrf;
                CompanyOrganization co;
                if (vo.getGender() != null) {
                    if (StaffGenderEnum.MALE.getValue().byteValue() == vo.getGender().byteValue()) {
                        vo.setGenderName(StaffGenderEnum.MALE.getName());
                    }
                    if (StaffGenderEnum.FEMALE.getValue().byteValue() == vo.getGender().byteValue()) {
                        vo.setGenderName(StaffGenderEnum.FEMALE.getName());
                    }
                }
                if (vo.getOrgId() != null && (co = (CompanyOrganization)this.companyOrganizationService.getById(vo.getOrgId())) != null) {
                    vo.setOrgName(co.getOrganizationName());
                }
                if (vo.getWorkId() != null && (wrf = (WorkRoleInfo)this.workRoleInfoService.getById(vo.getWorkId())) != null) {
                    vo.setWorkName(wrf.getWorkName() + "/" + wrf.getOrgName());
                }
                List ps = this.staffWorkRoleService.getPluralityStaffWorkRolesByStaffId(vo.getStaffId());
                ArrayList<Long> pluralityIds = new ArrayList<Long>();
                vo.setPluralityIds(pluralityIds);
                if (ps == null || ps.size() <= 0) continue;
                Object pluralityNames = "";
                for (StaffWorkRole s : ps) {
                    if (s.getWorkRoleId() == null) continue;
                    WorkRoleInfo wrf2 = (WorkRoleInfo)this.workRoleInfoService.getById(s.getWorkRoleId());
                    pluralityIds.add(s.getWorkRoleId());
                    if (wrf2 == null) continue;
                    pluralityNames = (String)pluralityNames + "," + wrf2.getWorkName() + "/" + wrf2.getOrgName();
                }
                if (!StringUtils.isNotEmpty((String)pluralityNames)) continue;
                vo.setPluralityNames(((String)pluralityNames).substring(1, ((String)pluralityNames).length()));
            }
        }
        return list;
    }

    public PageInfo<HealthCheckStaffInfoVo> getBeforeWorkRecommendHealthCheckStaffInfosPageBySearch(JqGridParam param, HealthCheckStaffInfoQuery query) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<HealthCheckStaffInfoVo> list = this.getBeforeWorkRecommendHealthCheckStaffInfosBySearch(query);
        return new PageInfo(list);
    }

    public List<HealthCheckStaffInfoVo> getAfterWorkRecommendHealthCheckStaffInfosBySearch(HealthCheckStaffInfoQuery query) {
        query.setSearchKeyEncrypt(query.getSearchKey());
        List<HealthCheckStaffInfoVo> list = this.staffInfoMapper.getAfterWorkRecommendHealthCheckStaffInfosBySearch(query);
        if (list != null && list.size() > 0) {
            for (HealthCheckStaffInfoVo vo : list) {
                WorkRoleInfo wrf;
                CompanyOrganization co;
                if (vo.getGender() != null) {
                    if (StaffGenderEnum.MALE.getValue().byteValue() == vo.getGender().byteValue()) {
                        vo.setGenderName(StaffGenderEnum.MALE.getName());
                    }
                    if (StaffGenderEnum.FEMALE.getValue().byteValue() == vo.getGender().byteValue()) {
                        vo.setGenderName(StaffGenderEnum.FEMALE.getName());
                    }
                }
                if (vo.getOrgId() != null && (co = (CompanyOrganization)this.companyOrganizationService.getById(vo.getOrgId())) != null) {
                    vo.setOrgName(co.getOrganizationName());
                }
                if (vo.getWorkId() != null && (wrf = (WorkRoleInfo)this.workRoleInfoService.getById(vo.getWorkId())) != null) {
                    vo.setWorkName(wrf.getWorkName() + "/" + wrf.getOrgName());
                }
                List ps = this.staffWorkRoleService.getPluralityStaffWorkRolesByStaffId(vo.getStaffId());
                ArrayList<Long> pluralityIds = new ArrayList<Long>();
                vo.setPluralityIds(pluralityIds);
                if (ps == null || ps.size() <= 0) continue;
                Object pluralityNames = "";
                for (StaffWorkRole s : ps) {
                    if (s.getWorkRoleId() == null) continue;
                    WorkRoleInfo wrf2 = (WorkRoleInfo)this.workRoleInfoService.getById(s.getWorkRoleId());
                    pluralityIds.add(s.getWorkRoleId());
                    if (wrf2 == null) continue;
                    pluralityNames = (String)pluralityNames + "," + wrf2.getWorkName() + "/" + wrf2.getOrgName();
                }
                if (!StringUtils.isNotEmpty((String)pluralityNames)) continue;
                vo.setPluralityNames(((String)pluralityNames).substring(1, ((String)pluralityNames).length()));
            }
        }
        return list;
    }

    public List<HarmWorkStaffInfoVo> getRecommendTrainStaffInfosBySearch(HarmWorkStaffInfoQuery query) {
        List workList = this.harmfactorWorkService.getHarmfactorWorkListByCid(query.getCid().longValue());
        if (workList != null) {
            ArrayList<Long> workIds = new ArrayList<Long>();
            for (HarmfactorWork work : workList) {
                workIds.add(work.getWorkId());
            }
            query.setWorkIds(workIds);
        }
        query.setSearchKeyEncrypt(query.getSearchKey());
        List<HarmWorkStaffInfoVo> list = this.staffInfoMapper.getHarmWorkStaffInfosBySearch(query);
        if (list != null && list.size() > 0) {
            for (HarmWorkStaffInfoVo vo : list) {
                WorkRoleInfo wrf;
                CompanyOrganization co;
                vo.setId(vo.getStaffId());
                if (vo.getGender() != null) {
                    if (StaffGenderEnum.MALE.getValue().byteValue() == vo.getGender().byteValue()) {
                        vo.setGenderName(StaffGenderEnum.MALE.getName());
                    }
                    if (StaffGenderEnum.FEMALE.getValue().byteValue() == vo.getGender().byteValue()) {
                        vo.setGenderName(StaffGenderEnum.FEMALE.getName());
                    }
                }
                if (vo.getOrgId() != null && (co = (CompanyOrganization)this.companyOrganizationService.getById(vo.getOrgId())) != null) {
                    vo.setOrgName(co.getOrganizationName());
                }
                if (vo.getWorkId() == null || (wrf = (WorkRoleInfo)this.workRoleInfoService.getById(vo.getWorkId())) == null) continue;
                vo.setWorkName(wrf.getWorkName() + "/" + wrf.getOrgName());
            }
        }
        return list;
    }

    public PageInfo<HarmWorkStaffInfoVo> getRecommendTrainStaffInfoPageBySearch(JqGridParam param, HarmWorkStaffInfoQuery query) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<HarmWorkStaffInfoVo> list = this.getRecommendTrainStaffInfosBySearch(query);
        return new PageInfo(list);
    }

    public List<HarmWorkStaffInfoVo> getHarmWorkStaffInfosNotInArchive(Long cid) {
        List<HarmWorkStaffInfoVo> list = this.staffInfoMapper.getHarmWorkStaffInfosNotInArchive(cid);
        return list;
    }

    public PageInfo<HealthCheckStaffInfoVo> getAfterWorkWorkRecommendHealthCheckStaffInfosPageBySearch(JqGridParam param, HealthCheckStaffInfoQuery query) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<HealthCheckStaffInfoVo> list = this.getAfterWorkRecommendHealthCheckStaffInfosBySearch(query);
        return new PageInfo(list);
    }

    public List<HarmWorkStaffInfoVo> getHarmWorkStaffInfosBySearch(HarmWorkStaffInfoQuery query) {
        query.setSearchKeyEncrypt(query.getSearchKey());
        List<HarmWorkStaffInfoVo> list = this.staffInfoMapper.getHarmWorkStaffInfosBySearch(query);
        if (list != null && list.size() > 0) {
            for (HarmWorkStaffInfoVo vo : list) {
                WorkRoleInfo wrf;
                CompanyOrganization co;
                if (vo.getGender() != null) {
                    if (StaffGenderEnum.MALE.getValue().byteValue() == vo.getGender().byteValue()) {
                        vo.setGenderName(StaffGenderEnum.MALE.getName());
                    }
                    if (StaffGenderEnum.FEMALE.getValue().byteValue() == vo.getGender().byteValue()) {
                        vo.setGenderName(StaffGenderEnum.FEMALE.getName());
                    }
                }
                if (vo.getOrgId() != null && (co = (CompanyOrganization)this.companyOrganizationService.getById(vo.getOrgId())) != null) {
                    vo.setOrgName(co.getOrganizationName());
                }
                if (vo.getWorkId() != null && (wrf = (WorkRoleInfo)this.workRoleInfoService.getById(vo.getWorkId())) != null) {
                    vo.setWorkName(wrf.getWorkName() + "/" + wrf.getOrgName());
                }
                List ps = this.staffWorkRoleService.getPluralityStaffWorkRolesByStaffId(vo.getStaffId());
                ArrayList<Long> pluralityIds = new ArrayList<Long>();
                vo.setPluralityIds(pluralityIds);
                if (ps == null || ps.size() <= 0) continue;
                Object pluralityNames = "";
                for (StaffWorkRole s : ps) {
                    if (s.getWorkRoleId() == null) continue;
                    WorkRoleInfo wrf2 = (WorkRoleInfo)this.workRoleInfoService.getById(s.getWorkRoleId());
                    pluralityIds.add(s.getWorkRoleId());
                    if (wrf2 == null) continue;
                    pluralityNames = (String)pluralityNames + "," + wrf2.getWorkName() + "/" + wrf2.getOrgName();
                }
                if (!StringUtils.isNotEmpty((String)pluralityNames)) continue;
                vo.setPluralityNames(((String)pluralityNames).substring(1, ((String)pluralityNames).length()));
            }
        }
        return list;
    }

    public Byte getOrgStatusByStaffId(Long staffId) {
        if (staffId == null) {
            return null;
        }
        StaffInfo staff = (StaffInfo)super.getById(staffId);
        String orgName = this.companyProvideByHSEService.getCompanyNameById(staff.getOrgId());
        if (staff != null && staff.getStaffBasicId() != null) {
            WorkRoleInfo role;
            StaffBasicWork work = this.staffBasicWorkService.getStaffBasicWorkIncludeDeleteByStaffId(staff.getId());
            if (work != null && work.getOrgId() != null) {
                CompanyOrganization co = (CompanyOrganization)this.companyOrganizationService.getById(work.getOrgId());
                if (co != null) {
                    if (co.getIsValid() != null && co.getIsValid().booleanValue()) {
                        return (byte)2;
                    }
                    return (byte)1;
                }
                if (orgName != null && !"".equals(orgName)) {
                    return (byte)2;
                }
                return (byte)0;
            }
            StaffWorkRole workrole = this.staffWorkRoleService.getCurrentStaffWorkRoleByStaffId(staff.getId());
            if (workrole != null && (role = (WorkRoleInfo)this.workRoleInfoService.getById(workrole.getWorkRoleId())) != null && role.getOrgId() != null) {
                CompanyOrganization co = (CompanyOrganization)this.companyOrganizationService.getById(role.getOrgId());
                if (co != null) {
                    if (co.getIsValid() != null && co.getIsValid().booleanValue()) {
                        return (byte)2;
                    }
                    return (byte)1;
                }
                if (orgName != null && !"".equals(orgName)) {
                    return (byte)2;
                }
                return (byte)0;
            }
            return (byte)0;
        }
        return null;
    }

    public StaffInfo getStaffInfoByWorkNo(String workNo, Long cid) {
        StaffBasicWork work = this.staffBasicWorkService.getStaffBasicWorkByWorkNo(workNo, cid);
        if (work != null && work.getStaffId() != null) {
            return (StaffInfo)this.getById(work.getStaffId());
        }
        return null;
    }

    private List<CompanyOrganization> getNeedSaveOrg(StaffInfoExcelImportVo vo) {
        String[] depNames = vo.getDeptName().split("-");
        ArrayList<CompanyOrganization> needSaveDeps = new ArrayList<CompanyOrganization>();
        for (int a = 0; a < depNames.length; ++a) {
            CompanyOrganization nCor;
            CompanyOrganization cor;
            String dep = depNames[a];
            Byte level = (byte)(a + 1);
            if (needSaveDeps.size() > 0) {
                if (((CompanyOrganization)needSaveDeps.get(a - 1)).getId() != null) {
                    cor = this.companyOrganizationService.getCompanyOrganizationByNameAndLevel(dep, level, vo.getCid());
                    if (cor != null) {
                        needSaveDeps.add(cor);
                        continue;
                    }
                    nCor = new CompanyOrganization();
                    nCor.setLevel(level);
                    nCor.setOrganizationName(dep);
                    nCor.setCid(vo.getCid());
                    needSaveDeps.add(nCor);
                    continue;
                }
                CompanyOrganization nCor2 = new CompanyOrganization();
                nCor2.setLevel(level);
                nCor2.setOrganizationName(dep);
                nCor2.setCid(vo.getCid());
                needSaveDeps.add(nCor2);
                continue;
            }
            cor = this.companyOrganizationService.getCompanyOrganizationByNameAndLevel(dep, level, vo.getCid());
            if (cor != null) {
                needSaveDeps.add(cor);
                continue;
            }
            nCor = new CompanyOrganization();
            nCor.setLevel(level);
            nCor.setOrganizationName(dep);
            nCor.setCid(vo.getCid());
            needSaveDeps.add(nCor);
        }
        return needSaveDeps;
    }

    @Transactional(readOnly=false)
    void saveOrgsBylevles(List<CompanyOrganization> needSaveCom, Long loginStaffId, Long cid) {
        for (int i = 0; i < needSaveCom.size(); ++i) {
            if (i == 0) {
                if (needSaveCom.get(0).getId() != null) continue;
                this.companyOrganizationService.add((Object)needSaveCom.get(0), loginStaffId, cid);
                continue;
            }
            if (needSaveCom.get(i).getId() != null) continue;
            needSaveCom.get(i).setPid(needSaveCom.get(i - 1).getId());
            String treePath = StringUtils.isEmpty((CharSequence)needSaveCom.get(i - 1).getTreePath()) ? "" + needSaveCom.get(i - 1).getId() : needSaveCom.get(i - 1).getTreePath() + "," + needSaveCom.get(i - 1).getId();
            needSaveCom.get(i).setTreePath(treePath);
            this.companyOrganizationService.add((Object)needSaveCom.get(i), loginStaffId, cid);
        }
    }

    private static void dateHandle(Cell cell) {
        String dateStr;
        if (cell.getCellType() == CellType.STRING && StringUtils.isNotEmpty((String)(dateStr = cell.getStringCellValue()))) {
            Date date = DateUtils.parseDate((Object)dateStr.trim());
            if (date == null) {
                cell.setCellType(CellType.BLANK);
            } else {
                Integer year = date.getYear();
                if (year > 9999) {
                    cell.setCellType(CellType.BLANK);
                } else {
                    cell.setCellValue(date);
                }
            }
        }
    }

    @Transactional(readOnly=false)
    public List<StaffInfoExcelImportVo> coverUpdateStaffDataFromExcelV210(List<StaffInfoExcelImportVo> cacheObj, Long loginStaffId) {
        ArrayList<StaffInfoExcelImportVo> updatedSheetDatas = new ArrayList<StaffInfoExcelImportVo>();
        for (StaffInfoExcelImportVo v : cacheObj) {
            WorkNatureInfo radiationWork;
            boolean updateFlag = false;
            StaffBasicWork staffBasicWork = v.getStaffBasicWork();
            StaffBasicWork staffBasicWorkFromDB = (StaffBasicWork)this.staffBasicWorkService.getById(staffBasicWork.getId());
            StaffWorkRole currentStaffWorkRole = v.getCurrentStaffWorkRole();
            StaffWorkRole currentStaffWorkRoleDB = (StaffWorkRole)this.staffWorkRoleService.getById(currentStaffWorkRole.getId());
            StaffInfo staffInfo = v.getStaffInfo();
            StaffInfo staffInfoFromDB = (StaffInfo)this.getById(staffInfo.getId());
            StaffInfo staffInfoNew = new StaffInfo();
            staffInfoNew.setId(staffInfo.getId());
            if (!staffInfo.getOtherCompany().equals(staffInfoFromDB.getOtherCompany())) {
                staffInfoNew.setOtherCompany(staffInfo.getOtherCompany());
            }
            if (!("" + staffInfoFromDB.getOutsource()).equals("" + staffInfo.getOutsource())) {
                if (staffInfo.getOutsource() == null) {
                    staffInfoNew.setOutsource(Byte.valueOf((byte)0));
                } else {
                    staffInfoNew.setOutsource(staffInfo.getOutsource());
                }
            }
            StaffBasicWork staffBasicWorkNew = new StaffBasicWork();
            staffBasicWorkNew.setId(staffBasicWork.getId());
            if (!staffBasicWorkFromDB.getWorkNo().equals(staffBasicWork.getWorkNo())) {
                if (staffBasicWork.getWorkNo() == null) {
                    staffBasicWorkNew.setWorkNo("");
                } else {
                    staffBasicWorkNew.setWorkNo(staffBasicWork.getWorkNo());
                }
            }
            StaffBasicInfo staffBasicInfo = v.getStaffBasicInfo();
            StaffBasicInfo staffBasicInfoFromDB = (StaffBasicInfo)this.staffBasicInfoService.getById(staffBasicInfo.getId());
            StaffBasicInfo staffBasicInfoNew = new StaffBasicInfo();
            staffBasicInfoNew.setId(staffBasicInfo.getId());
            if (!staffBasicInfo.getRealName().equals(staffBasicInfoFromDB.getRealName())) {
                staffBasicInfoNew.setRealName(staffBasicInfo.getRealName());
            }
            if (!("" + staffBasicWorkFromDB.getOrgId()).equals("" + staffBasicWork.getOrgId())) {
                staffBasicWorkNew.setOrgId(staffBasicWork.getOrgId());
                staffInfoNew.setOrgId(staffBasicWork.getOrgId());
            }
            StaffWorkRole staffWorkRoleNew = new StaffWorkRole();
            staffWorkRoleNew.setId(currentStaffWorkRole.getId());
            if (!("" + currentStaffWorkRoleDB.getWorkRoleId()).equals("" + currentStaffWorkRole.getWorkRoleId())) {
                staffWorkRoleNew.setWorkRoleId(currentStaffWorkRole.getWorkRoleId());
            }
            if (staffBasicInfo.getGender() != null) {
                staffBasicInfoNew.setGender(staffBasicInfo.getGender());
            }
            if (!staffBasicInfo.getMobile().equals(staffBasicInfoFromDB.getMobile())) {
                staffBasicInfoNew.setMobile(staffBasicInfo.getMobile());
            }
            if (!("" + currentStaffWorkRoleDB.getStatus()).equals("" + currentStaffWorkRole.getStatus())) {
                staffWorkRoleNew.setStatus(currentStaffWorkRole.getStatus());
            }
            if (currentStaffWorkRole.getBeginTime() != null) {
                staffWorkRoleNew.setBeginTime(currentStaffWorkRole.getBeginTime());
            }
            if (staffBasicWork.getJobTitle() != null) {
                staffBasicWorkNew.setJobTitle(staffBasicWork.getJobTitle());
            }
            if (staffBasicInfo.getNativePlace() != null) {
                staffBasicInfoNew.setNativePlace(staffBasicInfo.getNativePlace());
            }
            if (staffBasicInfo.getNation() != null) {
                staffBasicInfoNew.setNation(staffBasicInfo.getNation());
            }
            if (v.getMaritalStatus() != null) {
                staffBasicInfoNew.setMaritalStatus(v.getMaritalStatus());
            }
            if (staffBasicInfo.getEducation() != null) {
                staffBasicInfoNew.setEducation(staffBasicInfo.getEducation());
            }
            if (v.getMajor() != null) {
                staffBasicInfoNew.setMajor(v.getMajor());
            }
            if (staffBasicWork.getJoinTime() != null) {
                staffBasicWorkNew.setJoinTime(staffBasicWork.getJoinTime());
            }
            if (staffBasicWork.getWorkTime() != null) {
                staffBasicWorkNew.setWorkTime(staffBasicWork.getWorkTime());
            }
            if (staffInfoNew.getId() != null) {
                this.update(staffInfoNew, loginStaffId);
            }
            if (staffBasicInfoNew.getId() != null) {
                this.staffBasicInfoService.update((Object)staffBasicInfoNew, loginStaffId);
            }
            if (staffBasicWorkNew.getId() != null) {
                this.staffBasicWorkService.update((Object)staffBasicWorkNew, loginStaffId);
            }
            Long cid = currentStaffWorkRoleDB.getCid();
            if (v.getIsRadiation() != null && v.getIsRadiation().booleanValue()) {
                radiationWork = new WorkNatureInfo();
                radiationWork.setIsWork(v.getIsRadiation());
                radiationWork.setIsDefault(Boolean.valueOf(false));
                if (v.getRadiationYear() != null) {
                    radiationWork.setWorkBeginTime(v.getRadiationYear());
                }
                radiationWork.setWorkType(v.getRadiationTypeName());
                radiationWork.setNature(Byte.valueOf(WorkNatureEnum.RadiationWork.getValue()));
                radiationWork.setNatureName(WorkNatureEnum.RadiationWork.getName());
                radiationWork.setStaffId(staffInfo.getId());
                radiationWork.setCid(staffInfoNew.getCid());
                this.workNatureInfoService.add((Object)radiationWork, loginStaffId, cid);
            }
            if (v.getSpecialOperationsName() != null) {
                radiationWork = new WorkNatureInfo();
                radiationWork.setIsWork(Boolean.valueOf(true));
                radiationWork.setIsDefault(Boolean.valueOf(false));
                radiationWork.setWorkType(v.getSpecialOperationsName());
                radiationWork.setNature(Byte.valueOf(WorkNatureEnum.ParticularWork.getValue()));
                radiationWork.setNatureName(WorkNatureEnum.ParticularWork.getName());
                radiationWork.setStaffId(staffInfo.getId());
                radiationWork.setCid(cid);
                this.workNatureInfoService.add((Object)radiationWork, loginStaffId, cid);
            }
            if (v.getSpecialWorkName() != null) {
                radiationWork = new WorkNatureInfo();
                radiationWork.setIsWork(Boolean.valueOf(true));
                radiationWork.setIsDefault(Boolean.valueOf(false));
                radiationWork.setWorkType(v.getSpecialWorkName());
                radiationWork.setNature(Byte.valueOf(WorkNatureEnum.SpecialWork.getValue()));
                radiationWork.setNatureName(WorkNatureEnum.SpecialWork.getName());
                radiationWork.setStaffId(staffInfo.getId());
                radiationWork.setCid(cid);
                this.workNatureInfoService.add((Object)radiationWork, loginStaffId, cid);
            }
            if (staffWorkRoleNew.getId() != null) {
                this.staffWorkRoleService.update((Object)staffWorkRoleNew, loginStaffId);
                StaffWorkRole hisWork = this.staffWorkRoleService.getCurrentStaffWorkRoleHistory(staffInfo.getId(), currentStaffWorkRole.getWorkRoleId());
                if (hisWork != null) {
                    hisWork.setBeginTime(staffWorkRoleNew.getBeginTime());
                    this.staffWorkRoleService.update((Object)hisWork, loginStaffId);
                } else {
                    StaffWorkRole curHistoryStaffWorkRole = new StaffWorkRole();
                    curHistoryStaffWorkRole.setCid(cid);
                    curHistoryStaffWorkRole.setBeginTime(staffWorkRoleNew.getBeginTime());
                    curHistoryStaffWorkRole.setIsHistory(Boolean.valueOf(true));
                    curHistoryStaffWorkRole.setIsThirdParty(currentStaffWorkRole.getIsThirdParty());
                    curHistoryStaffWorkRole.setLeaveTime(currentStaffWorkRole.getLeaveTime());
                    curHistoryStaffWorkRole.setStaffId(staffInfo.getId());
                    curHistoryStaffWorkRole.setStatus(currentStaffWorkRole.getStatus());
                    curHistoryStaffWorkRole.setWorkProperty(StaffWorkPropertyEnum.WORKED.getValue());
                    curHistoryStaffWorkRole.setWorkRoleId(currentStaffWorkRole.getWorkRoleId());
                    this.staffWorkRoleService.add((Object)curHistoryStaffWorkRole, loginStaffId, cid);
                }
            }
            updatedSheetDatas.add(v);
        }
        return updatedSheetDatas;
    }

    @Transactional(readOnly=false)
    public void addNotExistStaffs(List<StaffBasicVo> notExistStaffList) {
        if (notExistStaffList == null || notExistStaffList.isEmpty()) {
            return;
        }
        for (StaffBasicVo staff : notExistStaffList) {
            String harmIds = null;
            this.addStaffInfoByQuery(staff, harmIds);
        }
    }

    private StaffBasicVo addStaffInfoByQuery(StaffBasicVo staff, String harmIds) {
        StaffBasicVo vo = null;
        StaffQuery query = new StaffQuery();
        Long cid = staff.getCid();
        if (cid == null || staff.getIdCard() == null) {
            return vo;
        }
        query.setCid(staff.getCid());
        query.setStaffName(staff.getStaffName());
        query.setIdCard(staff.getIdCard());
        List<StaffBasicVo> vos = ((StaffInfoMapper)this.dao).getStaffInfoByQuery(query);
        if (vos == null || vos.size() == 0) {
            vo = this.addStaffInfosFromCheck(staff, harmIds);
            return vo;
        }
        vo = vos.get(0);
        vo.setStaffName(SpringEncryptUtils.decrypt((String)vo.getStaffName()));
        vo.setIdCard(SpringEncryptUtils.decrypt((String)vo.getIdCard()));
        return vo;
    }

    private StaffBasicVo addStaffInfosFromCheck(StaffBasicVo staff, String harmIds) {
        staff = this.addStaffInfos(staff.getStaffId(), staff.getCid(), staff.getStaffName(), staff.getIdCard(), staff.getWorkName(), harmIds, null);
        return staff;
    }

    @Transactional(readOnly=false)
    public void updateStaffNameByIdCardAndCid(Long cid, String idCard, String staffName) {
        this.staffBasicInfoService.updateStaffNameByIdCardAndCid(cid, idCard, staffName);
    }

    public List<StaffInfo> getStaffInfosByOrgId(Long cid, Long orgId, String searchKey) {
        if (cid == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Long> orgIds = new ArrayList<Long>();
        if (orgId != null) {
            orgIds.add(orgId);
        } else {
            orgIds = null;
        }
        if (orgId != null && orgId != -1L) {
            List orgList = this.companyOrganizationService.getAllChildrenCompanyOrganizationsByPid(orgId, cid);
            for (CompanyOrganization co : orgList) {
                orgIds.add(co.getId());
            }
        }
        return this.staffBasicWorkService.getStaffInfosByOrgIdAndSearch2(cid, searchKey, null, orgIds);
    }

    public String getFullStaffRealNameAndOrgName(Long staffId) {
        if (staffId == null) {
            return "";
        }
        Object realName = ((StaffInfoMapper)this.dao).getFullStaffRealNameAndOrgName(staffId);
        StaffBasicInfo staffBasicInfo = ((StaffInfoMapper)this.dao).getFullStaffRealName(staffId);
        if (ObjectUtil.isNotNull((Object)staffBasicInfo)) {
            realName = staffBasicInfo.getRealName() + (String)realName;
            if (!staffBasicInfo.getIsValid().booleanValue()) {
                realName = "(\u5df2\u5220\u9664)" + (String)realName;
            }
        }
        if (StringUtils.isNotEmpty((String)realName)) {
            return realName;
        }
        return "";
    }

    public List<StaffInfo> getAllByCid(Long cid) {
        Example e = new Example(StaffInfo.class);
        Example.Criteria c = e.createCriteria();
        c.andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("cid", (Object)cid);
        return this.getListByExample(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(readOnly=false)
    public List<StaffInfoExcelImportVo> getStaffBatchInfoFromExcelWithMoreCom(String ossfile) {
        HSSFWorkbook wb = null;
        ArrayList<StaffInfoExcelImportVo> list = new ArrayList<StaffInfoExcelImportVo>();
        try {
            wb = new HSSFWorkbook(ExcelUtil.getInstance().getOssInputStream(ossfile));
        }
        catch (Exception i) {
        }
        finally {
            if (wb != null) {
                try {
                    for (int i = 0; i < wb.getNumberOfSheets(); ++i) {
                        String comName = wb.getSheetAt(i).getSheetName().trim();
                        CompanyBaseInfoModel com = this.companyProvideByHSEService.getByName(comName);
                        List<StaffInfoExcelImportVo> data = this.getStaffInfoFromExcelMoreSheet(wb.getSheetAt(i), com.getId(), comName);
                        list.addAll(data);
                    }
                    wb.close();
                }
                catch (IOException i) {}
            }
        }
        return list;
    }

    private List<StaffInfoExcelImportVo> getStaffInfoFromExcelMoreSheet(HSSFSheet sheet, Long cid, String comName) {
        ArrayList<StaffInfoExcelImportVo> list = new ArrayList<StaffInfoExcelImportVo>();
        int rowIndex = 0;
        int cellIndex = 22;
        HashMap<String, CompanyOrganization> needAddOrg = new HashMap<String, CompanyOrganization>();
        HashMap<String, WorkRoleInfo> needAddworkList = new HashMap<String, WorkRoleInfo>();
        ArrayList<String> workAndDeptNames = new ArrayList<String>();
        Iterator iter = sheet.rowIterator();
        while (iter.hasNext()) {
            Row row = (Row)iter.next();
            if (++rowIndex == 1 || rowIndex == 2) continue;
            StaffInfoExcelImportVo vo = new StaffInfoExcelImportVo();
            vo.setLoginStaffId(cid);
            vo.setCid(cid);
            vo.setErrorReason("\u4f01\u4e1a" + comName + ":");
            for (int i = 0; i < cellIndex; ++i) {
                Cell cell = row.getCell(i);
                if (cell == null) {
                    cell = new HSSFWorkbook().createSheet().createRow(1).createCell(0);
                }
                if (i != 15 && i != 18 && i != 16 && i != 8) {
                    cell.setCellType(CellType.STRING);
                }
                this.formatEveryExcelCellforSelf(cell, i, rowIndex, vo, needAddOrg, needAddworkList, workAndDeptNames);
            }
            Object allValues = "";
            for (String value : vo.getKeyValue().values()) {
                allValues = (String)allValues + value;
            }
            if (!StringUtils.isNotEmpty((String)allValues)) continue;
            list.add(vo);
        }
        List<CompanyOrganization> needAddOrgs = this.getOrgList(needAddOrg);
        List<WorkRoleInfo> needAddworks = this.getWorkList(needAddworkList);
        if (needAddOrgs != null && needAddOrgs.size() > 0) {
            this.companyOrganizationService.addOrgList(needAddOrgs);
        }
        if (needAddworks != null && needAddworks.size() > 0) {
            this.workRoleInfoService.addWorkRoleList(needAddworks);
        }
        return list;
    }

    public StaffBasicVo getStaffBasicVoByIdCardNotSelfId(String idCard, Long id, Long cid) {
        List<StaffBasicVo> list = ((StaffInfoMapper)this.dao).getStaffBasicVoByIdCardNotSelfId(SpringEncryptUtils.encrypt((String)idCard), id, cid);
        if (list != null && list.size() > 0) {
            StaffBasicVo staffBasicVo = list.get(0);
            staffBasicVo.setStaffName(SpringEncryptUtils.decrypt((String)staffBasicVo.getStaffName()));
            staffBasicVo.setIdCard(SpringEncryptUtils.decrypt((String)staffBasicVo.getIdCard()));
            staffBasicVo.setMobile(SpringEncryptUtils.decrypt((String)staffBasicVo.getMobile()));
            return staffBasicVo;
        }
        return null;
    }

    @Transactional(readOnly=false)
    public StaffBasicVo addStaffInfoFromOrg(StaffInfo staffInfo) {
        StaffBasicInfo basicInfo = staffInfo.getStaffBasicInfo();
        if (basicInfo == null) {
            return null;
        }
        basicInfo.setIsValid(Boolean.valueOf(true));
        if (IDCardUtil.isIDCard((String)basicInfo.getIdCard())) {
            basicInfo.setAge(Integer.valueOf(IDCardUtil.getAge((String)basicInfo.getIdCard())));
            basicInfo.setGender(IDCardUtil.getGender((String)basicInfo.getIdCard()));
            basicInfo.setBirthday(IDCardUtil.getBirthday((String)basicInfo.getIdCard()));
        }
        this.staffBasicInfoMapper.insertSelective(basicInfo);
        staffInfo.setStaffBasicId(basicInfo.getId());
        staffInfo.setIsValid(Boolean.valueOf(true));
        staffInfo.setIsThirdParty(Boolean.valueOf(false));
        staffInfo.setAddFrom(Integer.valueOf(StaffAddFromEnum.third_org_check_add.getValue().intValue()));
        ((StaffInfoMapper)this.dao).insertSelective(staffInfo);
        StaffBasicWork staffBasicWork = new StaffBasicWork();
        staffBasicWork.setStaffId(staffInfo.getId());
        staffBasicWork.setCid(staffInfo.getCid());
        staffBasicWork.setCreateBy(staffInfo.getCreateBy());
        staffBasicWork.setIsRadiation(Global.FALSE);
        this.staffBasicWorkService.add((Object)staffBasicWork, staffInfo.getCreateBy(), staffInfo.getCid());
        StaffWorkRole staffWorkRole = new StaffWorkRole();
        staffWorkRole.setCid(staffInfo.getCid());
        staffWorkRole.setStaffId(staffInfo.getId());
        staffWorkRole.setWorkProperty(StaffWorkPropertyEnum.MAJOR.getValue());
        staffWorkRole.setStatus(StaffWorkStatusEnum.ONWORKING.getValue());
        staffWorkRole.setIsThirdParty(Global.FALSE);
        staffWorkRole.setIsHistory(Global.FALSE);
        staffWorkRole.setCreateBy(staffInfo.getId());
        this.staffWorkRoleService.add((Object)staffWorkRole, staffInfo.getCreateBy(), staffInfo.getCid());
        StaffBasicVo vo = new StaffBasicVo();
        vo.setStaffId(staffInfo.getId());
        vo.setStaffName(basicInfo.getRealName());
        vo.setNew(true);
        vo.setMobile(basicInfo.getMobile());
        return vo;
    }

    public StaffBasicVo getStaffBasicVoFromOrgById(Long id) {
        List<StaffBasicVo> list = ((StaffInfoMapper)this.dao).getStaffBasicVoFromOrgById(id);
        if (list != null && list.size() > 0) {
            StaffBasicVo staffBasicVo = list.get(0);
            staffBasicVo.setStaffName(SpringEncryptUtils.decrypt((String)staffBasicVo.getStaffName()));
            staffBasicVo.setIdCard(SpringEncryptUtils.decrypt((String)staffBasicVo.getIdCard()));
            staffBasicVo.setMobile(SpringEncryptUtils.decrypt((String)staffBasicVo.getMobile()));
            return staffBasicVo;
        }
        return null;
    }

    @Transactional(readOnly=false)
    public void updateRealNameByStaffId(String realName, Long staffId) {
        StaffInfo info = (StaffInfo)this.getById(staffId);
        if (info != null && info.getStaffBasicId() != null) {
            StaffBasicInfo cinfo = new StaffBasicInfo();
            cinfo.setRealName(realName);
            cinfo.setId(info.getStaffBasicId());
            this.staffBasicInfoService.update((Object)cinfo);
        }
    }

    @Transactional
    public void updateMobileByStaffId(String mobile, Long staffId) {
        StaffInfo info = (StaffInfo)this.getById(staffId);
        if (info != null && info.getStaffBasicId() != null) {
            StaffBasicInfo basicInfo = new StaffBasicInfo();
            basicInfo.setMobile(mobile);
            basicInfo.setId(info.getStaffBasicId());
            this.staffBasicInfoService.update((Object)basicInfo);
        }
    }

    public List<Long> getQuitStaffIdsByCid(Long cid) {
        List<Long> staffIds = ((StaffInfoMapper)this.dao).getQuitStaffIdsByCid(cid);
        return staffIds;
    }

    public StaffBasicVo getStaffBasicInfoByNameAndIdcard(String name, String idCard, Long cid) {
        List<StaffBasicVo> list = ((StaffInfoMapper)this.dao).getStaffBasicInfoByNameAndIdcard(SpringEncryptUtils.encrypt((String)name), SpringEncryptUtils.encrypt((String)idCard), cid);
        if (list != null && list.size() > 0) {
            StaffBasicVo staffBasicVo = list.get(0);
            staffBasicVo.setStaffName(SpringEncryptUtils.decrypt((String)staffBasicVo.getStaffName()));
            staffBasicVo.setIdCard(SpringEncryptUtils.decrypt((String)staffBasicVo.getIdCard()));
            staffBasicVo.setMobile(SpringEncryptUtils.decrypt((String)staffBasicVo.getMobile()));
            return staffBasicVo;
        }
        return null;
    }

    public StaffBasicVo addStaffInfoFromTrainPro(String name, String idCard, Long cid, String mobile) {
        StaffInfo info = new StaffInfo();
        StaffBasicInfo basicInfo = new StaffBasicInfo();
        basicInfo.setRealName(name);
        basicInfo.setIdCard(idCard);
        basicInfo.setMobile(mobile);
        info.setStaffBasicInfo(basicInfo);
        return this.addStaffInfoFromOrg(info);
    }

    public List<Long> getStaffIdLeaveAndNoCheck(Long cid, int days) {
        return ((StaffInfoMapper)this.dao).getStaffIdLeaveAndNoCheck(cid, days);
    }

    @Transactional(readOnly=false)
    public HudongSysStaffInfoVo addHuadongStaffInfo(String realName, String workNo, String idCard, Long loginStaffId, Long cid) {
        HudongSysStaffInfoVo vo = new HudongSysStaffInfoVo();
        vo.setRealName(realName);
        vo.setWorkNo(StringUtils.isNotEmpty((String)workNo) ? workNo.trim() : "");
        vo.setIdCard(StringUtils.isNotEmpty((String)idCard) ? idCard.trim() : "");
        StaffBasicInfo basicInfo = new StaffBasicInfo();
        basicInfo.setRealName(vo.getRealName());
        basicInfo.setIsValid(Boolean.valueOf(true));
        basicInfo.setIdCard(vo.getIdCard());
        if (IDCardUtil.isIDCard((String)basicInfo.getIdCard())) {
            basicInfo.setAge(Integer.valueOf(IDCardUtil.getAge((String)basicInfo.getIdCard())));
            basicInfo.setGender(IDCardUtil.getGender((String)basicInfo.getIdCard()));
            basicInfo.setBirthday(IDCardUtil.getBirthday((String)basicInfo.getIdCard()));
        }
        basicInfo = (StaffBasicInfo)this.staffBasicInfoService.add((Object)basicInfo, loginStaffId, cid);
        StaffInfo staffInfo = new StaffInfo();
        staffInfo.setStaffBasicId(basicInfo.getId());
        staffInfo.setIsValid(Boolean.valueOf(true));
        staffInfo.setIsThirdParty(Boolean.valueOf(false));
        staffInfo = this.add(staffInfo, loginStaffId, cid);
        StaffBasicWork staffBasicWork = new StaffBasicWork();
        staffBasicWork.setStaffId(staffInfo.getId());
        staffBasicWork.setWorkNo(vo.getWorkNo());
        this.staffBasicWorkService.add((Object)staffBasicWork, loginStaffId, cid);
        StaffWorkRole staffWorkRole = new StaffWorkRole();
        staffWorkRole.setCid(staffInfo.getCid());
        staffWorkRole.setStaffId(staffInfo.getId());
        staffWorkRole.setWorkProperty(StaffWorkPropertyEnum.MAJOR.getValue());
        staffWorkRole.setStatus(StaffWorkStatusEnum.ONWORKING.getValue());
        staffWorkRole.setIsThirdParty(Global.FALSE);
        staffWorkRole.setIsHistory(Global.FALSE);
        this.staffWorkRoleService.add((Object)staffWorkRole, loginStaffId, cid);
        vo.setStaffId(staffInfo.getId());
        return vo;
    }

    @Transactional(readOnly=false)
    public void updateHuadongStaffInfo(Long staffId, String workNo, String idCard, Long loginStaffId, Long cid) {
        if (staffId == null) {
            return;
        }
        if (StringUtils.isNotEmpty((String)idCard)) {
            StaffInfo staffInfo = (StaffInfo)this.getById(staffId);
            StaffBasicInfo basicInfo = new StaffBasicInfo();
            basicInfo.setIdCard(idCard.trim());
            basicInfo.setId(staffInfo.getStaffBasicId());
            this.staffBasicInfoService.update((Object)basicInfo, loginStaffId);
        }
        if (StringUtils.isNotEmpty((String)workNo)) {
            StaffBasicWork work = new StaffBasicWork();
            work.setWorkNo(workNo.trim());
            this.staffBasicWorkService.updateByStaffId(work, staffId, loginStaffId, cid);
        }
    }

    public List<StaffInfoArchiveVo> getStaffInfoArchiveVoByStaffIds(Integer year, Long cid) {
        return ((StaffInfoMapper)this.dao).getStaffInfoArchiveVoByStaffIds(year, cid);
    }

    @Transactional(readOnly=false)
    public void updataStaffAddFromByCheckId(Long checkId) {
        if (checkId != null) {
            ((StaffInfoMapper)this.dao).updataStaffAddFromByCheckId(checkId);
        }
    }

    @Transactional(readOnly=false)
    public StaffInfo getStaffInfoByIdCardOrTrainUserId(Long cid, String staffName, String idCard, Long trainUserId) {
        StaffInfo staff;
        if (cid == null || trainUserId == null) {
            return null;
        }
        Example e = new Example(StaffInfo.class);
        Example.Criteria c = e.createCriteria();
        c.andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("trainUserId", (Object)trainUserId).andEqualTo("cid", (Object)cid);
        List list = this.getListByExample(e);
        if (list != null && list.size() > 0) {
            StaffInfo staff2 = null;
            for (StaffInfo staffInfo : list) {
                StaffBasicInfo basic = (StaffBasicInfo)this.staffBasicInfoService.getById(staffInfo.getStaffBasicId());
                if (!staffName.equals(basic.getRealName())) continue;
                staff2 = staffInfo;
                break;
            }
            if (staff2 == null) {
                return this.setStaffInfoAndReturn(cid, staffName, idCard, trainUserId);
            }
            if (idCard != null && IDCardUtil.isIDCard((String)idCard)) {
                StaffBasicInfo basicInfo = (StaffBasicInfo)this.staffBasicInfoService.getById(staff2.getStaffBasicId());
                basicInfo.setRealName(staffName);
                basicInfo.setIdCard(idCard);
                basicInfo.setAge(Integer.valueOf(IDCardUtil.getAge((String)idCard)));
                basicInfo.setGender(IDCardUtil.getGender((String)idCard));
                basicInfo.setBirthday(IDCardUtil.getBirthday((String)idCard));
                this.staffBasicInfoService.update((Object)basicInfo);
                staff2.setStaffBasicInfo(basicInfo);
            }
            return staff2;
        }
        if (idCard != null && (staff = this.getStaffInfoIdByIdCardAndCid(idCard, cid)) != null) {
            staff.setTrainUserId(trainUserId);
            this.update(staff);
            return staff;
        }
        return this.setStaffInfoAndReturn(cid, staffName, idCard, trainUserId);
    }

    private StaffInfo setStaffInfoAndReturn(Long cid, String staffName, String idCard, Long trainUserId) {
        StaffInfo staff = new StaffInfo();
        staff.setCid(cid);
        StaffBasicInfo basicInfo = new StaffBasicInfo();
        basicInfo.setIsValid(Boolean.valueOf(true));
        basicInfo.setRealName(staffName);
        basicInfo.setCid(cid);
        if (idCard != null) {
            basicInfo.setIdCard(idCard);
            basicInfo.setRealName(staffName);
            if (IDCardUtil.isIDCard((String)basicInfo.getIdCard())) {
                basicInfo.setAge(Integer.valueOf(IDCardUtil.getAge((String)idCard)));
                basicInfo.setGender(IDCardUtil.getGender((String)idCard));
                basicInfo.setBirthday(IDCardUtil.getBirthday((String)idCard));
            }
        }
        this.staffBasicInfoMapper.insertSelective(basicInfo);
        staff.setStaffBasicId(basicInfo.getId());
        staff.setIsValid(Boolean.valueOf(true));
        staff.setIsThirdParty(Boolean.valueOf(false));
        staff.setAddFrom(Integer.valueOf(StaffAddFromEnum.online_train_add.getValue().intValue()));
        staff.setTrainUserId(trainUserId);
        ((StaffInfoMapper)this.dao).insertSelective(staff);
        StaffBasicWork staffBasicWork = new StaffBasicWork();
        staffBasicWork.setStaffId(staff.getId());
        staffBasicWork.setCid(staff.getCid());
        staffBasicWork.setCreateBy(staff.getCreateBy());
        staffBasicWork.setIsRadiation(Global.FALSE);
        this.staffBasicWorkService.add((Object)staffBasicWork, staff.getId(), staff.getCid());
        StaffWorkRole staffWorkRole = new StaffWorkRole();
        staffWorkRole.setCid(staff.getCid());
        staffWorkRole.setStaffId(staff.getId());
        staffWorkRole.setWorkProperty(StaffWorkPropertyEnum.MAJOR.getValue());
        staffWorkRole.setStatus(StaffWorkStatusEnum.ONWORKING.getValue());
        staffWorkRole.setIsThirdParty(Global.FALSE);
        staffWorkRole.setIsHistory(Global.FALSE);
        staffWorkRole.setCreateBy(staff.getId());
        this.staffWorkRoleService.add((Object)staffWorkRole, staff.getId(), staff.getCid());
        staff.setStaffBasicInfo(basicInfo);
        return staff;
    }

    public StaffInfo getStaffInfoByCidAndTrainUserId(Long cid, Long trainUserId) {
        Example e = new Example(StaffInfo.class);
        Example.Criteria c = e.createCriteria();
        c.andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("trainUserId", (Object)trainUserId).andEqualTo("cid", (Object)cid);
        List list = this.getListByExample(e);
        if (list != null && list.size() > 0) {
            StaffInfo staffInfo = (StaffInfo)list.get(0);
            StaffBasicInfo staffBasicInfo = (StaffBasicInfo)this.staffBasicInfoService.getById(staffInfo.getStaffBasicId());
            staffInfo.setStaffBasicInfo(staffBasicInfo);
            return staffInfo;
        }
        return null;
    }

    @Transactional(readOnly=false)
    public List<StaffInfo> updateStaffNameAndIdCardByTrainUserId(Long trainUserId, String idCard, String staffName) {
        Example e = new Example(StaffInfo.class);
        Example.Criteria c = e.createCriteria();
        c.andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("trainUserId", (Object)trainUserId);
        List<StaffInfo> list = this.getListByExample(e);
        for (StaffInfo info : list) {
            StaffBasicInfo basicInfo = new StaffBasicInfo();
            if (StringUtils.isNotEmpty((String)idCard)) {
                basicInfo.setIdCard(idCard);
                basicInfo.setAge(Integer.valueOf(IDCardUtil.getAge((String)idCard)));
                basicInfo.setGender(IDCardUtil.getGender((String)idCard));
                basicInfo.setBirthday(IDCardUtil.getBirthday((String)idCard));
            }
            basicInfo.setRealName(staffName);
            basicInfo.setId(info.getStaffBasicId());
            basicInfo.setUpdateBy(trainUserId);
            basicInfo.setUpdateDate(new Date());
            this.staffBasicInfoService.update((Object)basicInfo);
        }
        return list;
    }

    public List<StaffInfo> getListByTrainUserId(Long trainUserId) {
        if (trainUserId == null) {
            return null;
        }
        Example e = new Example(StaffInfo.class);
        Example.Criteria c = e.createCriteria();
        c.andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("trainUserId", (Object)trainUserId);
        List<StaffInfo> list = this.getListByExample(e);
        if (list != null && list.size() > 0) {
            StaffInfo staffInfo = (StaffInfo)list.get(0);
            StaffBasicInfo staffBasicInfo = (StaffBasicInfo)this.staffBasicInfoService.getById(staffInfo.getStaffBasicId());
            staffInfo.setStaffBasicInfo(staffBasicInfo);
            return list;
        }
        return null;
    }

    @Transactional(readOnly=false)
    public void updateStaffNameAndIdCard(StaffInfo staffInfo) {
        if (staffInfo == null) {
            return;
        }
        StaffBasicInfo staffBasicInfo = staffInfo.getStaffBasicInfo();
        if (staffBasicInfo != null) {
            staffBasicInfo.setUpdateDate(new Date());
            staffBasicInfo.setUpdateBy(staffInfo.getUpdateBy());
            this.staffBasicInfoService.update((Object)staffBasicInfo);
        }
        this.update(staffInfo);
    }

    public StaffInfo getStaffInfoByStaffBasicId(Long staffBasicId, Long cid) {
        List list;
        Example example = new Example(StaffInfo.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("staffBasicId", (Object)staffBasicId).andEqualTo("isValid", (Object)true);
        if (cid != null) {
            criteria.andEqualTo("cid", (Object)cid);
        }
        if (CollectionUtils.isEmpty((Collection)(list = ((StaffInfoMapper)this.dao).selectByExample(example)))) {
            return null;
        }
        return (StaffInfo)list.get(0);
    }

    public StaffDocInfoVo getStaffDocInfoVoByStaffIdNew(Long staffId, Long cid) {
        if (staffId == null || cid == null) {
            return null;
        }
        return ((StaffInfoMapper)this.dao).getStaffDocInfoVoByStaffIdNew(staffId, cid);
    }

    public List<StaffDocInfoVo> getStaffDocInfoVoByStaffIdNewList(List<Long> staffIdList, Long cid) {
        if (CollectionUtils.isEmpty(staffIdList) || cid == null) {
            return Collections.emptyList();
        }
        return ((StaffInfoMapper)this.dao).getStaffDocInfoVoByStaffIdNewList(staffIdList, cid);
    }

    public Map<Long, Map<Long, StaffDocInfoVo>> getStaffDocInfoVoMap(Map<Long, List<Long>> cidAndStaffIdListMap) {
        if (CollectionUtils.isEmpty(cidAndStaffIdListMap)) {
            return Collections.emptyMap();
        }
        Set<Long> cidList = cidAndStaffIdListMap.keySet();
        List<Long> staffIdAllList = cidAndStaffIdListMap.values().stream().filter(value -> !CollectionUtils.isEmpty((Collection)value)).flatMap(Collection::stream).collect(Collectors.toList());
        List<StaffDocInfoVo> staffDocInfoVoList = ((StaffInfoMapper)this.dao).getStaffDocInfoVoByCid(cidList, staffIdAllList);
        Map<Long, Map<Long, StaffDocInfoVo>> map = staffDocInfoVoList.stream().filter(staffDocInfoVo -> staffDocInfoVo != null && staffDocInfoVo.getStaffInfoId() != null && staffDocInfoVo.getStaffBasicInfoId() != null).collect(Collectors.groupingBy(StaffDocInfoVo::getCid, Collectors.toMap(StaffDocInfoVo::getStaffInfoId, Function.identity(), (v1, v2) -> v1)));
        return map;
    }

    public PageInfo<StaffInfo> getOperateRecords(Long cid, JqGridParam page) {
        PageHelper.startPage((int)page.getPage(), (int)page.getRows());
        PageHelper.orderBy((String)"i.update_date desc");
        List<StaffInfo> operateRecords = ((StaffInfoMapper)this.dao).getOperateRecords(cid);
        operateRecords.forEach(o -> {
            o.setStaffName(SpringEncryptUtils.decrypt((String)o.getStaffName()));
            o.setOperateUser(SpringEncryptUtils.decrypt((String)o.getOperateUser()));
            if (Objects.equals(0L, o.getOperateId())) {
                o.setOperateUser("\u7cfb\u7edf");
            }
        });
        return new PageInfo(operateRecords);
    }

    @Transactional(readOnly=false)
    public void setPhcPhysicalCheckStaffWorkStatus(List<Long> cids) {
        if (CollectionUtils.isEmpty(cids)) {
            cids = ((StaffInfoMapper)this.dao).getNeedSetWorkStatusCheckStaffCid();
        }
        int pageSize = 100;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        List split = ListUtils.split(cids, (int)pageSize);
        this.logger.info("\u9700\u540c\u6b65\u4f01\u4e1a\u6570\uff1a{},\u5206{}\u9875", (Object)cids.size(), (Object)split.size());
        for (int i = 0; i < split.size(); ++i) {
            this.logger.info("\u5f00\u59cb\u7b2c{}\u9875\u6570\u636e", (Object)i);
            List cidList = (List)split.get(i);
            List<StaffInfo> needSetStaffList = ((StaffInfoMapper)this.dao).getNeedSetWorkStatusCheckStaffList(cidList);
            if (CollectionUtil.isNotEmpty(needSetStaffList)) {
                for (StaffInfo staffInfo : needSetStaffList) {
                    staffInfo.setIdCard(SpringEncryptUtils.decrypt((String)staffInfo.getIdCard()));
                }
            }
            Map<String, Map<Long, List<StaffInfo>>> idCardCidMap = needSetStaffList.stream().peek(s -> s.setIdCard(s.getIdCard().toUpperCase())).collect(Collectors.groupingBy(StaffInfo::getIdCard, Collectors.groupingBy(StaffInfo::getCid)));
            Map<String, Long> creditCidMap = needSetStaffList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<StaffInfo>(Comparator.comparing(StaffInfo::getCid))), ArrayList::new)).stream().peek(s -> s.setCreditCode(s.getCreditCode().toLowerCase())).distinct().collect(Collectors.toMap(StaffInfo::getCreditCode, StaffInfo::getCid));
            Set IdCardSet = needSetStaffList.stream().map(m -> SpringEncryptUtils.decrypt((String)m.getIdCard())).collect(Collectors.toSet());
            Set creditCodeSet = needSetStaffList.stream().map(StaffInfo::getCreditCode).collect(Collectors.toSet());
            List wandaHealthCardList = this.wandaHealthCardService.getByCreditCodeIdCard(creditCodeSet, IdCardSet);
            Map<String, Map<String, List<WandaHealthCard>>> creditCodeMap = wandaHealthCardList.stream().peek(w -> w.setIdcardCode(w.getIdcardCode())).collect(Collectors.groupingBy(WandaHealthCard::getCreditCode, Collectors.groupingBy(WandaHealthCard::getIdcardCode)));
            ArrayList<StaffWorkRole> updateList = new ArrayList<StaffWorkRole>();
            for (String creditCode : creditCodeMap.keySet()) {
                Map<String, List<WandaHealthCard>> idCardMap = creditCodeMap.get(creditCode);
                Long cid = creditCidMap.get(creditCode.toLowerCase());
                for (String idCard : idCardMap.keySet()) {
                    List<StaffInfo> staffInfos;
                    StaffWorkRole staffWorkRole = new StaffWorkRole();
                    staffWorkRole.setCid(cid);
                    staffWorkRole.setIdCard(idCard);
                    Map<Long, List<StaffInfo>> cidMap = idCardCidMap.get(idCard);
                    if (MapUtils.isEmpty(cidMap) || CollectionUtil.isEmpty(staffInfos = cidMap.get(cid))) continue;
                    staffWorkRole.setId(staffInfos.get(0).getId());
                    List<WandaHealthCard> wandaHealthCards = idCardMap.get(idCard);
                    Optional<WandaHealthCard> maxOptional = wandaHealthCards.stream().max(Comparator.comparing(WandaHealthCard::getCheckTime));
                    if (!maxOptional.isPresent()) continue;
                    WandaHealthCard latestData = wandaHealthCards.stream().max(Comparator.comparing(WandaHealthCard::getCheckTime)).get();
                    Byte workStatus = this.convertWorkStatus(latestData.getBodyCheckType());
                    if (StaffWorkStatusEnum.NOWORKED.getValue().equals(workStatus)) {
                        String checkTime = latestData.getCheckTime();
                        try {
                            Date leaveTime = sdf.parse(checkTime);
                            staffWorkRole.setLeaveTime(leaveTime);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    staffWorkRole.setStatus(workStatus);
                    this.addWorkStatusLog(staffInfos.get(0).getOperateId(), cid, staffInfos.get(0).getCheckStatus(), workStatus);
                    WandaHealthCard latestBeforeDate = wandaHealthCards.stream().filter(h -> h.getBodyCheckType().equalsIgnoreCase("1")).max(Comparator.comparing(WandaHealthCard::getCheckTime)).orElse(null);
                    if (Objects.nonNull(latestBeforeDate)) {
                        String beginTimeStr = latestBeforeDate.getCheckTime();
                        Date beginTime = null;
                        try {
                            beginTime = sdf.parse(beginTimeStr);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        staffWorkRole.setBeginTime(beginTime);
                    }
                    updateList.add(staffWorkRole);
                }
            }
            DefaultTransactionDefinition def = new DefaultTransactionDefinition();
            def.setPropagationBehavior(3);
            TransactionStatus status = this.txManager.getTransaction((TransactionDefinition)def);
            try {
                this.submitBatchUpdateWorkStatus(updateList);
                this.txManager.commit(status);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.txManager.rollback(status);
            }
        }
    }

    private void addWorkStatusLog(Long staffId, Long cid, Byte oldWorkStatus, Byte newWorkStatus) {
        StaffFieldChangeLog log = new StaffFieldChangeLog();
        log.setStaffId(staffId);
        log.setCid(cid);
        log.setBeforeInfo(ObjectUtil.isNull((Object)oldWorkStatus) ? "-" : StaffWorkStatusEnum.getWorkStatusStr((Byte)oldWorkStatus));
        log.setAfterInfo(ObjectUtil.isNull((Object)newWorkStatus) ? "-" : StaffWorkStatusEnum.getWorkStatusStr((Byte)newWorkStatus));
        log.setField(StaffFieldChangeEnum.WORK_ROLE_STATUS.getCode());
        log.setChangeReason("\u4e07\u8fbe\u4ed3\u4f53\u68c0\u6570\u636e\u53d8\u66f4");
        this.staffFieldChangeLogService.addChangeLogList(Collections.singletonList(log), null);
    }

    private void addWorkStatusLog(Long staffId, Long cid, Byte oldWorkStatus, Byte newWorkStatus, Long userId) {
        if (oldWorkStatus != null && newWorkStatus != null && !oldWorkStatus.equals(newWorkStatus)) {
            StaffFieldChangeLog log = new StaffFieldChangeLog();
            log.setStaffId(staffId);
            log.setCid(cid);
            log.setBeforeInfo(StaffWorkStatusEnum.getWorkStatusStr((Byte)oldWorkStatus));
            log.setAfterInfo(StaffWorkStatusEnum.getWorkStatusStr((Byte)newWorkStatus));
            log.setField(StaffFieldChangeEnum.WORK_ROLE_STATUS.getCode());
            this.staffFieldChangeLogService.addChangeLogList(Collections.singletonList(log), userId);
        }
    }

    private void submitBatchUpdateWorkStatus(List<StaffWorkRole> updateList) {
        int i = this.staffWorkRoleService.updateBatchWorkStatus(updateList);
        this.logger.info("\u63d0\u4ea4\u4e86{}\u6761\u6570\u636e", (Object)i);
    }

    private Byte convertWorkStatus(String bodyCheckType) {
        Byte status = null;
        switch (bodyCheckType) {
            case "1": 
            case "2": 
            case "5": {
                status = StaffWorkStatusEnum.ONWORKING.getValue();
                break;
            }
            case "3": 
            case "4": {
                status = StaffWorkStatusEnum.NOWORKED.getValue();
            }
        }
        return status;
    }

    public List<StaffInfo> collectStaffInfoWorkNum(List<Long> cidList, Boolean isThirdParty, Integer workStatus) {
        if (CollectionUtils.isEmpty(cidList)) {
            return new ArrayList<StaffInfo>();
        }
        return ((StaffInfoMapper)this.dao).getStaffInfoWorkNum(cidList, isThirdParty, workStatus);
    }

    public List<StaffInfo> getStaffInfoWorkNum(List<Long> cidList, Map<String, Object> param) {
        List<StaffInfo> staffInfoWorkNum;
        Boolean isThirdParty = null;
        Integer workStatus = null;
        if (param != null && param.get("isThirdParty") != null) {
            isThirdParty = (Boolean)param.get("isThirdParty");
            workStatus = (Integer)param.get("workStatus");
        }
        if (CollectionUtils.isEmpty(staffInfoWorkNum = ((StaffInfoMapper)this.dao).getStaffInfoWorkNum(cidList, isThirdParty, workStatus))) {
            return staffInfoWorkNum;
        }
        Map<Long, List<StaffInfo>> collect = ((StaffInfoMapper)this.dao).getStaffInfoIdList(cidList, isThirdParty, workStatus).stream().filter(Objects::nonNull).collect(Collectors.groupingBy(StaffInfo::getCid));
        for (StaffInfo staffInfo : staffInfoWorkNum) {
            if (staffInfo == null || staffInfo.getCid() == null || CollectionUtils.isEmpty((Collection)collect.get(staffInfo.getCid()))) continue;
            Long cid = staffInfo.getCid();
            List collect1 = collect.get(cid).stream().filter(item -> item != null && item.getId() != null).map(StaffInfo::getId).collect(Collectors.toList());
            staffInfo.setLocalOutWorkStaffIds(StringUtils.join(collect1, (String)","));
        }
        return staffInfoWorkNum;
    }

    public List<StaffInfo> getStaffInfoIdList(List<Long> cidList, Map<String, Object> param) {
        if (CollUtil.isEmpty(cidList)) {
            return Collections.emptyList();
        }
        return ((StaffInfoMapper)this.dao).getStaffInfoListByCompliance(cidList);
    }

    public List<StaffPhySicalCheckModel> queryPhysicalStaffList(List<Long> cids) {
        if (CollectionUtils.isEmpty(cids)) {
            return Collections.emptyList();
        }
        List<StaffPhySicalCheckModel> staffPhySicalCheckModels = ((StaffInfoMapper)this.dao).queryPhysicalStaffList(cids);
        if (CollectionUtil.isNotEmpty(staffPhySicalCheckModels)) {
            for (StaffPhySicalCheckModel staffPhySicalCheckModel : staffPhySicalCheckModels) {
                staffPhySicalCheckModel.setName(SpringEncryptUtils.decrypt((String)staffPhySicalCheckModel.getName()));
                staffPhySicalCheckModel.setCardId(SpringEncryptUtils.decrypt((String)staffPhySicalCheckModel.getCardId()));
            }
        }
        return staffPhySicalCheckModels;
    }

    public Map<Long, Integer> countNoWorkStatusNum(List<Long> cids) {
        HashMap<Long, Integer> resultMap = new HashMap<Long, Integer>();
        List<StaffPhySicalCheckModel> list = ((StaffInfoMapper)this.dao).countNoWorkStatusNum(cids);
        Map<Long, Integer> map = list.stream().collect(Collectors.toMap(StaffPhySicalCheckModel::getCid, StaffPhySicalCheckModel::getNoWorkStatusNum));
        Iterator<Long> iterator = cids.iterator();
        while (iterator.hasNext()) {
            Long cid;
            Integer integer = map.get(cid = iterator.next());
            resultMap.put(cid, Objects.nonNull(integer) ? integer : 0);
        }
        return resultMap;
    }

    @Transactional
    public void mergeStaffInfo(Long cid) {
        List<StaffDocInfoVo> repeatStaffList = ((StaffInfoMapper)this.dao).queryRepeatStaff(cid);
        if (CollectionUtils.isEmpty(repeatStaffList)) {
            return;
        }
        ArrayList<PhcPhysicalCheckData> phcPhysicalCheckDataList = new ArrayList<PhcPhysicalCheckData>();
        ArrayList<PhcOccupationalDiseaser> phcOccupationalDiseaserList = new ArrayList<PhcOccupationalDiseaser>();
        List idCardList = repeatStaffList.stream().map(StaffDocInfoVo::getIdCard).distinct().collect(Collectors.toList());
        List<Long> cidList = repeatStaffList.stream().map(StaffDocInfoVo::getCid).distinct().collect(Collectors.toList());
        ArrayList<String> idCardListEncrypt = new ArrayList<String>();
        for (String s : idCardList) {
            idCardListEncrypt.add(SpringEncryptUtils.encrypt((String)s));
        }
        List<StaffDocInfoVo> dbStaffInfoList = ((StaffInfoMapper)this.dao).queryRepeatStaffInfoList(idCardListEncrypt, cidList);
        Map<Long, List<StaffDocInfoVo>> map = dbStaffInfoList.stream().collect(Collectors.groupingBy(StaffDocInfoVo::getCid));
        ArrayList updateList = new ArrayList();
        for (Long key : map.keySet()) {
            List<StaffDocInfoVo> staffBasicInfos = map.get(key);
            Map<String, List<StaffDocInfoVo>> nameMap = staffBasicInfos.stream().collect(Collectors.groupingBy(StaffDocInfoVo::getRealName));
            for (String name : nameMap.keySet()) {
                List<StaffDocInfoVo> personalList = nameMap.get(name);
                if (personalList.size() < 2) continue;
                StaffDocInfoVo upperCaseX = personalList.stream().filter(p -> p.getIdCard().contains("x")).findFirst().orElse(null);
                if (upperCaseX == null) {
                    upperCaseX = personalList.get(0);
                }
                Long staffBasicInfoId = upperCaseX.getStaffBasicInfoId();
                Long staffInfoId = upperCaseX.getStaffInfoId();
                List needDelList = personalList.stream().filter(p -> !p.getStaffBasicInfoId().equals(staffBasicInfoId)).collect(Collectors.toList());
                for (StaffDocInfoVo staffDocInfoVo : needDelList) {
                    PhcPhysicalCheckData phcPhysicalCheckData = new PhcPhysicalCheckData();
                    phcPhysicalCheckData.setId(staffDocInfoVo.getStaffInfoId());
                    phcPhysicalCheckData.setStaffId(staffInfoId);
                    phcPhysicalCheckData.setCid(key);
                    phcPhysicalCheckDataList.add(phcPhysicalCheckData);
                    PhcOccupationalDiseaser phcOccupationalDiseaser = new PhcOccupationalDiseaser();
                    phcOccupationalDiseaser.setId(staffDocInfoVo.getStaffInfoId());
                    phcOccupationalDiseaser.setStaffId(staffInfoId);
                    phcOccupationalDiseaser.setCid(key);
                    phcOccupationalDiseaserList.add(phcOccupationalDiseaser);
                }
                if (!CollectionUtil.isNotEmpty(needDelList)) continue;
                updateList.addAll(needDelList);
            }
        }
        if (CollectionUtil.isNotEmpty(updateList)) {
            this.batchUpdateOrInsert(updateList, StaffInfoMapper.class, (item, mapper) -> mapper.delMerge((StaffDocInfoVo)item));
            this.batchUpdateOrInsert(updateList, StaffBasicInfoMapper.class, (item, mapper) -> mapper.delMerge((StaffDocInfoVo)item));
        }
    }

    @Transactional
    public void changeToThirdCompanyPerson(BatchStafffWorkVo vo) {
        if (StringUtils.isNotEmpty((String)vo.getStaffInfoIds())) {
            List list = Arrays.stream(vo.getStaffInfoIds().split(",")).map(Long::valueOf).collect(Collectors.toList());
            vo.setStaffInfoIdList(list);
        }
        vo.setUpdateDate(new Date());
        ((StaffInfoMapper)this.dao).changeToThirdCompanyPerson(vo);
        Long cid = vo.getCid();
        List staffInfoIdList = vo.getStaffInfoIdList();
        ArrayList<StaffFieldChangeLog> staffFieldChangeLogList = new ArrayList<StaffFieldChangeLog>();
        if (CollectionUtil.isNotEmpty((Collection)staffInfoIdList)) {
            for (Long aLong : staffInfoIdList) {
                StaffFieldChangeLog log = new StaffFieldChangeLog();
                log.setStaffId(aLong);
                log.setCid(cid);
                log.setField(StaffFieldChangeEnum.STAFF_OUTSOURCE.getCode());
                log.setBeforeInfo("\u672c\u4f01\u4e1a\u4eba\u5458");
                log.setAfterInfo("\u5916\u6765\u4eba\u5458");
                log.setChangeReason("\u4f01\u4e1a\u624b\u52a8\u53d8\u66f4");
                staffFieldChangeLogList.add(log);
            }
            this.staffFieldChangeLogService.addChangeLogList(staffFieldChangeLogList, vo.getLoginBy());
        }
    }

    public List<Long> getStaffIdWithArchive(Long cid, List<Long> staffIds) {
        Boolean isComplianceItem = this.complianceCompanyInfoService.getCompanyIsComplianceItem(cid);
        return this.liteArchiveFilePersonalService.getCompletedPersonalByCid(isComplianceItem, cid, staffIds);
    }

    public ComplianceStaffInfoVo getStaffTrainByStaffId(Long staffId) {
        return ((StaffInfoMapper)this.dao).getStaffTrainByStaffId(staffId);
    }

    public List<StaffFieldChangeLog> addStaffChangeLogList(Long staffId, Long cid, StaffWorkRole oldCurrentStaffWorkRole, StaffWorkRole currentStaffWorkRole, StaffBasicWork oldStaffBasicWork, StaffBasicWork staffBasicWork, String oldJobName, String newJobName, Long loginStaffId) {
        StaffFieldChangeLog log;
        ArrayList<StaffFieldChangeLog> logList = new ArrayList<StaffFieldChangeLog>();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (oldCurrentStaffWorkRole.getBeginTime() != null && currentStaffWorkRole.getBeginTime() != null && !oldCurrentStaffWorkRole.getBeginTime().equals(currentStaffWorkRole.getBeginTime())) {
            log = new StaffFieldChangeLog();
            log.setStaffId(staffId);
            log.setCid(cid);
            log.setBeforeInfo(dateFormat.format(oldCurrentStaffWorkRole.getBeginTime()));
            log.setAfterInfo(dateFormat.format(currentStaffWorkRole.getBeginTime()));
            log.setField(StaffFieldChangeEnum.WORK_BEGIN_TIME.getCode());
            logList.add(log);
        }
        if (oldCurrentStaffWorkRole.getFirstBeginTime() != null && currentStaffWorkRole.getFirstBeginTime() != null && !oldCurrentStaffWorkRole.getFirstBeginTime().equals(currentStaffWorkRole.getFirstBeginTime())) {
            log = new StaffFieldChangeLog();
            log.setStaffId(staffId);
            log.setCid(cid);
            log.setBeforeInfo(dateFormat.format(oldCurrentStaffWorkRole.getFirstBeginTime()));
            log.setAfterInfo(dateFormat.format(currentStaffWorkRole.getFirstBeginTime()));
            log.setField(StaffFieldChangeEnum.FIRST_WORK_BEGIN_TIME.getCode());
            logList.add(log);
        }
        if (oldCurrentStaffWorkRole.getStatus() != null && currentStaffWorkRole.getStatus() != null && !oldCurrentStaffWorkRole.getStatus().equals(currentStaffWorkRole.getStatus())) {
            log = new StaffFieldChangeLog();
            log.setStaffId(staffId);
            log.setCid(cid);
            log.setBeforeInfo(StaffWorkStatusEnum.getWorkStatusStr((Byte)oldCurrentStaffWorkRole.getStatus()));
            log.setAfterInfo(StaffWorkStatusEnum.getWorkStatusStr((Byte)currentStaffWorkRole.getStatus()));
            log.setField(StaffFieldChangeEnum.WORK_ROLE_STATUS.getCode());
            logList.add(log);
        }
        if (oldStaffBasicWork.getIsRadiation() != null && staffBasicWork.getIsRadiation() != null && !oldStaffBasicWork.getIsRadiation().equals(staffBasicWork.getIsRadiation())) {
            log = new StaffFieldChangeLog();
            log.setStaffId(staffId);
            log.setCid(cid);
            log.setBeforeInfo(StaffRadiationEnum.getRadiationStr((Boolean)oldStaffBasicWork.getIsRadiation()));
            log.setAfterInfo(StaffRadiationEnum.getRadiationStr((Boolean)staffBasicWork.getIsRadiation()));
            log.setField(StaffFieldChangeEnum.RADIATION_STAFF.getCode());
            logList.add(log);
        }
        if (StringUtils.isNotEmpty((String)oldJobName) && StringUtils.isNotEmpty((String)newJobName) && !oldJobName.equals(newJobName)) {
            log = new StaffFieldChangeLog();
            log.setStaffId(staffId);
            log.setCid(cid);
            log.setBeforeInfo(oldJobName);
            log.setAfterInfo(newJobName);
            log.setField(StaffFieldChangeEnum.JOB_NAME.getCode());
            logList.add(log);
        }
        return logList;
    }

    @Transactional
    public void setWorkStatus(Long id, Long staffId, Long cid, Byte oldWorkStatus, Long userId) {
        this.staffWorkRoleMapper.setWorkStatus(id, userId, new Date());
        this.addWorkStatusLog(staffId, cid, oldWorkStatus, StaffWorkStatusEnum.UNEMPLOYED.getValue(), userId);
    }

    @Transactional
    public void reloadCheckData(List<StaffPhySicalCheckModel> allList) {
        if (CollectionUtils.isEmpty(allList)) {
            return;
        }
        List<Long> cidList = allList.stream().map(StaffPhySicalCheckModel::getCid).distinct().collect(Collectors.toList());
        ((StaffInfoMapper)this.dao).cleanTable(cidList);
        ((StaffInfoMapper)this.dao).insertComplianceCheckData(allList);
    }

    @Transactional
    public void cleanTable(List<Long> cidList) {
        if (CollectionUtils.isEmpty(cidList)) {
            return;
        }
        ((StaffInfoMapper)this.dao).cleanTable(cidList);
    }

    @Transactional
    public void reloadNewCheckData(List<StaffPhySicalCheckNoEnModel> allList) {
        if (CollectionUtils.isEmpty(allList)) {
            return;
        }
        List<Long> cidList = allList.stream().map(StaffPhySicalCheckNoEnModel::getCid).distinct().collect(Collectors.toList());
        ((StaffInfoMapper)this.dao).cleanNewTable(cidList);
        int batchSize = 5000;
        for (int i = 0; i < allList.size(); i += batchSize) {
            int end = Math.min(i + batchSize, allList.size());
            List<StaffPhySicalCheckNoEnModel> batchList = allList.subList(i, end);
            ((StaffInfoMapper)this.dao).insertNewComplianceCheckData(batchList);
        }
    }

    @Transactional
    public void cleanNewTable(List<Long> cidList) {
        if (CollectionUtils.isEmpty(cidList)) {
            return;
        }
        ((StaffInfoMapper)this.dao).cleanNewTable(cidList);
    }

    @Transactional
    public void improveStaffInfo(Long cid) {
        List<Long> cidList = ((StaffInfoMapper)this.dao).getNeedImproveCidList(cid);
        if (CollectionUtils.isEmpty(cidList)) {
            return;
        }
        int pageSize = 100;
        List split = ListUtils.split(cidList, (int)pageSize);
        int i = 1;
        this.logger.info("\u603b\u5171{}\u9875", (Object)split.size());
        for (List cids : split) {
            this.logger.info("\u5f00\u59cb\u7b2c{}\u6279\u6570\u636e", (Object)i);
            List<ImproveStaffModel> needImproveList = ((StaffInfoMapper)this.dao).getNeedImproveList(cids);
            List<Long> notSbwList = needImproveList.stream().filter(ImproveStaffModel::getSbw).map(ImproveStaffModel::getStaffId).collect(Collectors.toList());
            List notWrList = needImproveList.stream().filter(ImproveStaffModel::getWr).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(notWrList)) {
                List notWrCidList = notWrList.stream().map(ImproveStaffModel::getCid).collect(Collectors.toList());
                List companyBaseInfoList = this.companyProvideService.getCompanyBaseInfoList(notWrCidList, null);
                List creditCodeList = companyBaseInfoList.stream().map(CompanyBaseInfoModel::getUnifiedSocialCc).distinct().collect(Collectors.toList());
                Map<String, List<CompanyBaseInfoModel>> cidMap = companyBaseInfoList.stream().collect(Collectors.groupingBy(CompanyBaseInfoModel::getUnifiedSocialCc));
                List idcards = notWrList.stream().map(ImproveStaffModel::getIdCard).distinct().collect(Collectors.toList());
                List wandaHealthCardList = this.wandaHealthCardService.getWorkName(creditCodeList, idcards);
                Map<String, List<WandaHealthCard>> companyMap = wandaHealthCardList.stream().collect(Collectors.groupingBy(WandaHealthCard::getCreditCode));
                for (String creditCode : companyMap.keySet()) {
                    List<WandaHealthCard> wandaHealthCards = companyMap.get(creditCode);
                    Map<String, List<WandaHealthCard>> map = wandaHealthCards.stream().filter(s -> StringUtils.isNotEmpty((String)s.getOtherJobName())).collect(Collectors.groupingBy(WandaHealthCard::getIdcardCode));
                    List<String> workNames = wandaHealthCards.stream().map(WandaHealthCard::getOtherJobName).distinct().collect(Collectors.toList());
                    List<CompanyBaseInfoModel> companyBaseInfoModels = cidMap.get(creditCode);
                    if (CollectionUtils.isEmpty(companyBaseInfoModels) || CollectionUtils.isEmpty(workNames)) continue;
                    List<WorkRoleInfo> workRoleInfoList = ((StaffInfoMapper)this.dao).getWorkRoleIds(companyBaseInfoModels.get(0).getId(), workNames);
                    Map<String, Long> workNameIdMap = workRoleInfoList.stream().collect(Collectors.toMap(WorkRoleInfo::getWorkName, WorkRoleInfo::getId, (o1, o2) -> o1));
                    for (ImproveStaffModel model : notWrList) {
                        Long workRoleId;
                        List<WandaHealthCard> workNamesList = map.get(model.getIdCard());
                        if (CollectionUtils.isEmpty(workNamesList) || (workRoleId = (Long)workNamesList.stream().filter(f -> workNameIdMap.get(f.getOtherJobName()) != null).map(s -> (Long)workNameIdMap.get(s.getOtherJobName())).findFirst().orElse(null)) == null) continue;
                        model.setWorkRoleId(workRoleId);
                    }
                }
            }
            DefaultTransactionDefinition def = new DefaultTransactionDefinition();
            def.setPropagationBehavior(3);
            TransactionStatus status = this.txManager.getTransaction((TransactionDefinition)def);
            try {
                if (CollectionUtil.isNotEmpty(notSbwList)) {
                    ((StaffInfoMapper)this.dao).insertSbw(notSbwList);
                }
                if (CollectionUtil.isNotEmpty(notWrList = notWrList.stream().filter(s -> s.getWorkRoleId() != null).collect(Collectors.toList()))) {
                    this.workRoleInfoService.batchUpdateOrInsert(notWrList, StaffWorkRoleMapper.class, (item, mapper) -> {
                        StaffWorkRole info = new StaffWorkRole();
                        info.setId(item.getStaffWorkRoleId());
                        info.setWorkRoleId(item.getWorkRoleId());
                        return mapper.updateByPrimaryKeySelective(info);
                    });
                }
                this.txManager.commit(status);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.txManager.rollback(status);
            }
        }
    }

    public List<StaffInfoExcelImportVo> getStaffInfoByIdList(List<Long> staffInfoIdList) {
        if (CollectionUtils.isEmpty(staffInfoIdList)) {
            return Collections.emptyList();
        }
        return ((StaffInfoMapper)this.dao).getStaffInfoByIdList(staffInfoIdList);
    }

    @Transactional
    public List<StaffAbnormalInfo> complianceStaffAbnormalList(Long cid, String keyword) {
        List<StaffAbnormalInfo> staffShowInfoList = ((StaffInfoMapper)this.dao).complianceStaffAbnormalList(cid, SpringEncryptUtils.encrypt((String)keyword));
        for (StaffAbnormalInfo staffShowInfo : staffShowInfoList) {
            String mixIdCard = StringMixedUtil.mixedIDCard((String)staffShowInfo.getIdCard());
            staffShowInfo.setIdCard(mixIdCard);
            staffShowInfo.setReason(this.getReason(staffShowInfo));
        }
        return staffShowInfoList;
    }

    @Transactional
    public PageInfo<StaffAbnormalInfo> complianceStaffAbnormalListPage(JqGridParam page, Long cid, String keyword) {
        this.staticsStaffLatelyCheckTime(cid);
        PageHelper.startPage((int)page.getPage(), (int)page.getRows());
        return new PageInfo(this.complianceStaffAbnormalList(cid, keyword));
    }

    @Transactional
    public void improveWorkTime(List<Long> cidList) {
        List<Long> needImproveCidList = ((StaffInfoMapper)this.dao).getNeedImproveWorkTimeCidList(cidList);
        if (CollectionUtils.isEmpty(needImproveCidList)) {
            this.logger.error("\u6ca1\u6709\u9700\u8981\u5b8c\u5584\u5c97\u4f4d\u65f6\u95f4\u7684\u4f01\u4e1a");
            return;
        }
        Date updateDate = new Date();
        int pageSize = 100;
        List split = ListUtils.split(needImproveCidList, (int)pageSize);
        for (List cids : split) {
            DefaultTransactionDefinition def = new DefaultTransactionDefinition();
            def.setPropagationBehavior(3);
            TransactionStatus status = this.txManager.getTransaction((TransactionDefinition)def);
            try {
                List<ImproveStaffModel> improveStaffModelList = ((StaffInfoMapper)this.dao).getNeedImproveWorkTimeList(cids);
                if (CollectionUtils.isEmpty(improveStaffModelList)) {
                    this.logger.error("\u672c\u9875\u6ca1\u6709\u9700\u8981\u8bbe\u7f6e\u5c97\u4f4d\u65f6\u95f4\u7684\u63a5\u5bb3\u4eba\u5458");
                    continue;
                }
                List<ImproveStaffModel> updateList = new ArrayList<ImproveStaffModel>();
                Set IdCardSet = improveStaffModelList.stream().map(model -> SpringEncryptUtils.encrypt((String)model.getIdCard())).collect(Collectors.toSet());
                List wandaHealthCardList = this.phcPhysicalStaffCheckInfoService.getByCidIdCard(cids, IdCardSet);
                Map<Long, Map<String, List<PhcPhysicalStaffCheckInfo>>> creditCodeIdCardMap = wandaHealthCardList.stream().collect(Collectors.groupingBy(PhcPhysicalStaffCheckInfo::getCid, Collectors.groupingBy(PhcPhysicalStaffCheckInfo::getIdcardCode)));
                List<ImproveStaffModel> needImproveFirstBeinTimeList = improveStaffModelList.stream().filter(ImproveStaffModel::getNeedImproveFirstBeginTime).collect(Collectors.toList());
                List<ImproveStaffModel> needImproveBeinTimeList = improveStaffModelList.stream().filter(ImproveStaffModel::getNeedImproveBeginTime).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(needImproveFirstBeinTimeList)) {
                    this.improveFirstBeinTime(updateList, creditCodeIdCardMap, needImproveFirstBeinTimeList);
                }
                if (!CollectionUtils.isEmpty(needImproveBeinTimeList)) {
                    this.improveBeinTime(updateList, creditCodeIdCardMap, needImproveBeinTimeList);
                }
                if (CollectionUtils.isEmpty(updateList)) continue;
                updateList = this.mergeList(updateList);
                updateList.forEach(s -> s.setUpdateDate(updateDate));
                int updateSize = this.staffWorkRoleService.updateBatchWorkTime(updateList);
                this.logger.info("\u8865\u5168\u5c97\u4f4d\u65f6\u95f4\u4fe1\u606f \u66f4\u65b0\u4e86{}\u6761\u6570\u636e", (Object)updateSize);
                this.txManager.commit(status);
            }
            catch (Exception e) {
                this.txManager.rollback(status);
                e.printStackTrace();
                this.logger.error("\u8865\u5168\u5c97\u4f4d\u65f6\u95f4\u4fe1\u606f \u66f4\u65b0\u5931\u8d25", (Throwable)e);
            }
        }
    }

    @Transactional
    public void improveWorkTimeByCompliance(List<Long> cidList) {
        List<Long> needImproveCidList = ((StaffInfoMapper)this.dao).getNeedImproveWorkTimeCidListByCompliance(cidList);
        if (CollectionUtils.isEmpty(needImproveCidList)) {
            this.logger.error("\u6ca1\u6709\u9700\u8981\u5b8c\u5584\u5c97\u4f4d\u65f6\u95f4\u7684\u4f01\u4e1a");
            return;
        }
        Date updateDate = new Date();
        int pageSize = 100;
        List split = ListUtils.split(needImproveCidList, (int)pageSize);
        for (List cids : split) {
            DefaultTransactionDefinition def = new DefaultTransactionDefinition();
            def.setPropagationBehavior(3);
            TransactionStatus status = this.txManager.getTransaction((TransactionDefinition)def);
            try {
                List<ImproveStaffModel> improveStaffModelList = ((StaffInfoMapper)this.dao).getNeedImproveWorkTimeListByCompliance(cids);
                if (CollectionUtils.isEmpty(improveStaffModelList)) {
                    this.logger.error("\u672c\u9875\u6ca1\u6709\u9700\u8981\u8bbe\u7f6e\u5c97\u4f4d\u65f6\u95f4\u7684\u63a5\u5bb3\u4eba\u5458");
                    continue;
                }
                List<ImproveStaffModel> updateList = new ArrayList<ImproveStaffModel>();
                Set IdCardSet = improveStaffModelList.stream().map(m -> SpringEncryptUtils.encrypt((String)m.getIdCard())).collect(Collectors.toSet());
                List wandaHealthCardList = this.phcPhysicalStaffCheckInfoService.getByCidIdCard(cids, IdCardSet);
                Map<Long, Map<String, List<PhcPhysicalStaffCheckInfo>>> creditCodeIdCardMap = wandaHealthCardList.stream().collect(Collectors.groupingBy(PhcPhysicalStaffCheckInfo::getCid, Collectors.groupingBy(PhcPhysicalStaffCheckInfo::getIdcardCode)));
                List<ImproveStaffModel> needImproveFirstBeinTimeList = improveStaffModelList.stream().filter(ImproveStaffModel::getNeedImproveFirstBeginTime).collect(Collectors.toList());
                List<ImproveStaffModel> needImproveBeinTimeList = improveStaffModelList.stream().filter(ImproveStaffModel::getNeedImproveBeginTime).collect(Collectors.toList());
                List<ImproveStaffModel> needImproveLeaveTimeList = improveStaffModelList.stream().filter(ImproveStaffModel::getNeedImproveLeaveTime).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(needImproveFirstBeinTimeList)) {
                    this.improveFirstBeinTimeByCompliance(updateList, creditCodeIdCardMap, needImproveFirstBeinTimeList);
                }
                if (!CollectionUtils.isEmpty(needImproveBeinTimeList)) {
                    this.improveBeinTimeByCompliance(updateList, creditCodeIdCardMap, needImproveBeinTimeList);
                }
                if (!CollectionUtils.isEmpty(needImproveLeaveTimeList)) {
                    this.improveLeaveTimeByCompliance(updateList, creditCodeIdCardMap, needImproveLeaveTimeList);
                }
                if (CollectionUtils.isEmpty(updateList)) continue;
                updateList = this.mergeList(updateList);
                updateList.forEach(s -> s.setUpdateDate(updateDate));
                int updateSize = this.staffWorkRoleService.updateBatchWorkTime(updateList);
                this.logger.info("\u8865\u5168\u5c97\u4f4d\u65f6\u95f4\u4fe1\u606f \u66f4\u65b0\u4e86{}\u6761\u6570\u636e", (Object)updateSize);
                this.txManager.commit(status);
            }
            catch (Exception e) {
                this.txManager.rollback(status);
                e.printStackTrace();
                this.logger.error("\u8865\u5168\u5c97\u4f4d\u65f6\u95f4\u4fe1\u606f \u66f4\u65b0\u5931\u8d25", (Throwable)e);
            }
        }
    }

    private void improveBeinTimeByCompliance(List<ImproveStaffModel> updateList, Map<Long, Map<String, List<PhcPhysicalStaffCheckInfo>>> cidIdCardMap, List<ImproveStaffModel> needImproveBeinTimeList) {
        Map<Long, List<ImproveStaffModel>> companyMap = needImproveBeinTimeList.stream().collect(Collectors.groupingBy(ImproveStaffModel::getCid));
        for (Long cid : companyMap.keySet()) {
            Map<String, List<PhcPhysicalStaffCheckInfo>> idCardMap = cidIdCardMap.get(cid);
            List<ImproveStaffModel> improveStaffModels = companyMap.get(cid);
            if (MapUtils.isEmpty(idCardMap)) {
                improveStaffModels.forEach(s -> s.setBeginTime(DATE_2022_12_31));
            } else {
                for (ImproveStaffModel improveStaffModel : improveStaffModels) {
                    List<PhcPhysicalStaffCheckInfo> wandaHealthCards = idCardMap.get(improveStaffModel.getIdCard());
                    if (CollectionUtils.isEmpty(wandaHealthCards)) {
                        improveStaffModel.setBeginTime(DATE_2022_12_31);
                        continue;
                    }
                    PhcPhysicalStaffCheckInfo earliestBeforCheck = wandaHealthCards.stream().filter(h -> beforeWorkStatus.contains(h.getBodyCheckType())).max(Comparator.comparing(PhcPhysicalStaffCheckInfo::getCheckTime)).orElse(null);
                    PhcPhysicalStaffCheckInfo earliestOnCheck = wandaHealthCards.stream().filter(h -> onWorkStatus.contains(h.getBodyCheckType())).min(Comparator.comparing(PhcPhysicalStaffCheckInfo::getCheckTime)).orElse(null);
                    if (earliestBeforCheck != null) {
                        improveStaffModel.setBeginTime(earliestBeforCheck.getCheckTime());
                        continue;
                    }
                    if (earliestOnCheck != null) {
                        improveStaffModel.setBeginTime(earliestOnCheck.getCheckTime());
                        continue;
                    }
                    improveStaffModel.setBeginTime(DATE_2022_12_31);
                }
            }
            updateList.addAll(improveStaffModels);
        }
    }

    private void improveFirstBeinTimeByCompliance(List<ImproveStaffModel> updateList, Map<Long, Map<String, List<PhcPhysicalStaffCheckInfo>>> cidIdCardMap, List<ImproveStaffModel> needImproveFirstBeinTimeList) {
        Map<Long, List<ImproveStaffModel>> companyMap = needImproveFirstBeinTimeList.stream().collect(Collectors.groupingBy(ImproveStaffModel::getCid));
        for (Long cid : companyMap.keySet()) {
            Map<String, List<PhcPhysicalStaffCheckInfo>> idCardMap = cidIdCardMap.get(cid);
            List<ImproveStaffModel> improveStaffModels = companyMap.get(cid);
            if (MapUtils.isEmpty(idCardMap)) {
                improveStaffModels.forEach(s -> s.setFirstBeginTime(DATE_2022_12_31));
            } else {
                for (ImproveStaffModel improveStaffModel : improveStaffModels) {
                    List<PhcPhysicalStaffCheckInfo> wandaHealthCards = idCardMap.get(improveStaffModel.getIdCard());
                    if (CollectionUtils.isEmpty(wandaHealthCards)) {
                        improveStaffModel.setFirstBeginTime(DATE_2022_12_31);
                        continue;
                    }
                    PhcPhysicalStaffCheckInfo earliest = wandaHealthCards.stream().min(Comparator.comparing(PhcPhysicalStaffCheckInfo::getCheckTime)).orElseThrow(() -> new IllegalStateException("\u4f53\u68c0\u6570\u636e\u4e3a\u7a7a"));
                    improveStaffModel.setFirstBeginTime(earliest.getCheckTime());
                }
            }
            updateList.addAll(improveStaffModels);
        }
    }

    private void improveLeaveTimeByCompliance(List<ImproveStaffModel> updateList, Map<Long, Map<String, List<PhcPhysicalStaffCheckInfo>>> cidIdCardMap, List<ImproveStaffModel> needImproveLeaveTimeList) {
        Map<Long, List<ImproveStaffModel>> companyMap = needImproveLeaveTimeList.stream().collect(Collectors.groupingBy(ImproveStaffModel::getCid));
        for (Long cid : companyMap.keySet()) {
            Map<String, List<PhcPhysicalStaffCheckInfo>> idCardMap = cidIdCardMap.get(cid);
            List<ImproveStaffModel> improveStaffModels = companyMap.get(cid);
            if (MapUtils.isEmpty(idCardMap)) continue;
            for (ImproveStaffModel improveStaffModel : improveStaffModels) {
                PhcPhysicalStaffCheckInfo earliestLeaveCheck;
                List<PhcPhysicalStaffCheckInfo> wandaHealthCards = idCardMap.get(improveStaffModel.getIdCard());
                if (CollectionUtils.isEmpty(wandaHealthCards) || (earliestLeaveCheck = (PhcPhysicalStaffCheckInfo)wandaHealthCards.stream().filter(h -> leaveWorkStatus.contains(h.getBodyCheckType())).max(Comparator.comparing(PhcPhysicalStaffCheckInfo::getCheckTime)).orElse(null)) == null) continue;
                improveStaffModel.setLeaveTime(earliestLeaveCheck.getCheckTime());
                updateList.add(improveStaffModel);
            }
        }
    }

    @Transactional
    public void staticsStaffLatelyCheckTime(Long cid) {
        Date latelyCheckTimeTableUpdateDate = ((StaffInfoMapper)this.dao).getLatelyCheckTimeTableUpdateDate(cid);
        if (latelyCheckTimeTableUpdateDate == null || !DateUtils.isSameDay((Date)latelyCheckTimeTableUpdateDate, (Date)new Date())) {
            ((StaffInfoMapper)this.dao).cleanLatelyCheckTime(Collections.singletonList(cid));
            ((StaffInfoMapper)this.dao).staticsStaffLatelyCheckTime(Collections.singletonList(cid));
        }
    }

    @Transactional
    public void staticsStaffLatelyCheckTimeBatch(List<Long> cidList) {
        ((StaffInfoMapper)this.dao).cleanLatelyCheckTime(cidList);
        ((StaffInfoMapper)this.dao).staticsStaffLatelyCheckTime(cidList);
    }

    public List<StaffInfo> getByIdcardList(Long cid, List<String> idcardList) {
        if (cid == null || CollectionUtils.isEmpty(idcardList)) {
            return Collections.emptyList();
        }
        ArrayList<String> idcardListEncrypt = new ArrayList<String>();
        for (String s : idcardList) {
            idcardListEncrypt.add(SpringEncryptUtils.encrypt((String)s));
        }
        List<StaffInfo> staffInfos = ((StaffInfoMapper)this.dao).queryByIdCardList(cid, idcardListEncrypt);
        if (CollectionUtil.isNotEmpty(staffInfos)) {
            for (StaffInfo staffInfo : staffInfos) {
                staffInfo.setIdCard(SpringEncryptUtils.decrypt((String)staffInfo.getIdCard()));
            }
        }
        return staffInfos;
    }

    public StaffBasicVo getBasicInfo(Long staffId) {
        StaffBasicVo staffBasicInfo = ((StaffInfoMapper)this.dao).getStaffBasicInfo(staffId);
        if (ObjectUtil.isNotNull((Object)staffBasicInfo)) {
            staffBasicInfo.setStaffName(SpringEncryptUtils.decrypt((String)staffBasicInfo.getStaffName()));
            staffBasicInfo.setIdCard(SpringEncryptUtils.decrypt((String)staffBasicInfo.getIdCard()));
            staffBasicInfo.setMobile(SpringEncryptUtils.decrypt((String)staffBasicInfo.getMobile()));
        }
        return staffBasicInfo;
    }

    public Boolean decideIsAbnormalRadiation(Long cid) {
        if (ObjectUtil.isNull((Object)cid)) {
            return null;
        }
        List<Long> staffInfoIdList = ((StaffInfoMapper)this.dao).selectRadiationMismatchIdByCid(cid);
        Integer existRadioactivity = ((StaffInfoMapper)this.dao).getCompanyIsExistRadioactivity(cid);
        if (ObjectUtil.isNull((Object)existRadioactivity) || existRadioactivity == 0) {
            return staffInfoIdList.size() > 0;
        }
        return staffInfoIdList.size() <= 0;
    }

    public PageInfo<StaffExistChangeVo> getListDataExistChange(StaffInfoSearchParam param) {
        PageHelper.startPage((int)param.getJqGridParam().getPage(), (int)param.getJqGridParam().getRows(), (boolean)true);
        DataScopeHelper.startDataScope("staffInfo", "staff_info");
        DataScope dataScope = DataScopeHelper.getDataScope();
        dataScope.setCreateBy("id");
        DataScopeHelper.setDataScope(dataScope);
        param.setStaffName(SpringEncryptUtils.encrypt((String)param.getStaffName()));
        List<StaffExistChangeVo> comStaffList = this.staffInfoMapper.getListDataExistChange(param);
        for (StaffExistChangeVo s : comStaffList) {
            if (s.getOrgId() != null) {
                CompanyOrganization org = (CompanyOrganization)this.companyOrganizationService.getById(s.getOrgId());
                s.setOrgName(org == null ? null : org.getOrganizationName());
            }
            s.setIdCardDesensitization(s.getIdCard());
            s.setIdCard(null);
        }
        return new PageInfo(comStaffList);
    }

    public List<String> getlistDataStaffWorkName(StaffInfoSearchParam param) {
        DataScopeHelper.startDataScope("staffInfo", "staff_info");
        DataScope dataScope = DataScopeHelper.getDataScope();
        dataScope.setCreateBy("id");
        DataScopeHelper.setDataScope(dataScope);
        List<String> workNameList = this.staffInfoMapper.getlistDataStaffWorkName(param);
        return workNameList;
    }

    public List<StaffPhySicalCheckNoEnModel> queryNewPhysicalStaffList(List<Long> cids) {
        if (CollectionUtils.isEmpty(cids)) {
            return Collections.emptyList();
        }
        return ((StaffInfoMapper)this.dao).queryNewPhysicalStaffList(cids);
    }

    public List<StaffShowInfo> getStaffInfoByCardIdList(Long cid, List<String> idcardList, Long sourceId) {
        if (cid == null || CollectionUtils.isEmpty(idcardList)) {
            return Collections.emptyList();
        }
        ArrayList<String> idcardListEncrypt = new ArrayList<String>();
        for (String s : idcardList) {
            idcardListEncrypt.add(SpringEncryptUtils.encrypt((String)s));
        }
        List<StaffShowInfo> staffShowInfos = ((StaffInfoMapper)this.dao).selectStaffInfoByCardIdList(cid, idcardListEncrypt, sourceId);
        return staffShowInfos;
    }

    public List<StaffDoseMonitorDataModel> getDoseMonitorData(String realName, String idCard, Long cid) {
        if (ObjectUtil.isNull((Object)cid) || StringUtils.isEmpty((CharSequence)idCard) || StringUtils.isEmpty((CharSequence)realName)) {
            return Collections.emptyList();
        }
        idCard = idCard.toUpperCase();
        Map<String, List<DoseMonitorDataModel>> doseMonitorDataMap = null;
        List<DoseMonitorDataModel> doseMonitorDataModels = ((StaffInfoMapper)this.dao).getDoseMonitorDataList(Arrays.asList(SpringEncryptUtils.encrypt((String)idCard)), cid);
        if (CollectionUtil.isNotEmpty(doseMonitorDataModels)) {
            doseMonitorDataMap = doseMonitorDataModels.stream().peek(d -> d.setIdCard(d.getIdCard().toUpperCase())).collect(Collectors.groupingBy(d -> d.getIdCard() + d.getName()));
        }
        List<DoseMonitorDataModel> doseMonitorDataModelList = null;
        if (MapUtils.isNotEmpty(doseMonitorDataMap) && (doseMonitorDataModelList = doseMonitorDataMap.get(idCard + realName)) != null && doseMonitorDataModelList.size() > 0) {
            List sortedList = doseMonitorDataModelList.stream().sorted(Comparator.comparing(DoseMonitorDataModel::getBeginDate, Comparator.nullsLast(Comparator.reverseOrder()))).limit(6L).collect(Collectors.toList());
            ArrayList<StaffDoseMonitorDataModel> staffDoseMonitorDataModels = new ArrayList<StaffDoseMonitorDataModel>();
            if (sortedList.size() == 1) {
                StaffDoseMonitorDataModel staffDoseMonitorDataModel = new StaffDoseMonitorDataModel();
                DoseMonitorDataModel current = (DoseMonitorDataModel)sortedList.get(0);
                staffDoseMonitorDataModel.setEndDate(current.getEndDate());
                staffDoseMonitorDataModel.setBeginDate(current.getBeginDate());
                staffDoseMonitorDataModel.setIsBigDose(current.getIsBigDose());
                staffDoseMonitorDataModels.add(staffDoseMonitorDataModel);
            }
            for (int i = 0; i < sortedList.size() - 1; ++i) {
                Long diffInMillis;
                StaffDoseMonitorDataModel staffDoseMonitorDataModel = new StaffDoseMonitorDataModel();
                DoseMonitorDataModel current = (DoseMonitorDataModel)sortedList.get(i);
                DoseMonitorDataModel next = (DoseMonitorDataModel)sortedList.get(i + 1);
                staffDoseMonitorDataModel.setExceedingDay(Boolean.valueOf(false));
                staffDoseMonitorDataModel.setEndDate(current.getEndDate());
                staffDoseMonitorDataModel.setBeginDate(current.getBeginDate());
                staffDoseMonitorDataModel.setIsBigDose(current.getIsBigDose());
                if (current.getBeginDate() != null && next.getEndDate() != null && (diffInMillis = Long.valueOf(next.getEndDate().getTime() - current.getBeginDate().getTime())) > 0L) {
                    staffDoseMonitorDataModel.setExceedingDay(Boolean.valueOf(TimeUnit.DAYS.convert(diffInMillis, TimeUnit.MILLISECONDS) > 90L));
                }
                staffDoseMonitorDataModels.add(staffDoseMonitorDataModel);
            }
            return staffDoseMonitorDataModels;
        }
        return Collections.emptyList();
    }

    public String getStaffBasicInfoRealNameByStaffId(Long staffId) {
        if (staffId == null) {
            return null;
        }
        String realName = ((StaffInfoMapper)this.dao).getStaffBasicInfoRealNameByStaffId(staffId);
        if (StrUtil.isBlank((CharSequence)realName)) {
            return null;
        }
        return SpringEncryptUtils.decrypt((String)realName);
    }

    @Transactional
    public void addOrgCheckStaffInfo(List<StaffInfo> insertList, Long operatorId) {
        if (CollectionUtils.isEmpty(insertList)) {
            return;
        }
        List staffBasicInfoList = insertList.stream().map(StaffInfo::getStaffBasicInfo).collect(Collectors.toList());
        List staffBasicWorkList = insertList.stream().map(StaffInfo::getStaffBasicWork).collect(Collectors.toList());
        List staffWorkRoleList = staffBasicWorkList.stream().map(StaffBasicWork::getCurrentStaffWorkRole).collect(Collectors.toList());
        insertList.forEach(item -> {
            item.setCreateDate(new Date());
            item.setUpdateDate(new Date());
            item.setCreateBy(operatorId);
            item.setUpdateBy(operatorId);
            item.setIsValid(Boolean.valueOf(true));
        });
        ((StaffInfoMapper)this.dao).insertList2(insertList);
        this.staffBasicInfoService.batchUpdateOrInsert(staffBasicInfoList, StaffBasicInfoMapper.class, (item, mapper) -> {
            item.setCreateDate(new Date());
            item.setUpdateDate(new Date());
            item.setCreateBy(operatorId);
            item.setUpdateBy(operatorId);
            item.setIsValid(Boolean.valueOf(true));
            return mapper.insert(item);
        });
        this.staffBasicWorkService.batchUpdateOrInsert(staffBasicWorkList, StaffBasicWorkMapper.class, (item, mapper) -> {
            item.setCreateDate(new Date());
            item.setUpdateDate(new Date());
            item.setCreateBy(operatorId);
            item.setUpdateBy(operatorId);
            item.setIsValid(Boolean.valueOf(true));
            return mapper.insert(item);
        });
        this.staffWorkRoleService.batchUpdateOrInsert(staffWorkRoleList, StaffWorkRoleMapper.class, (item, mapper) -> {
            item.setCreateDate(new Date());
            item.setUpdateDate(new Date());
            item.setCreateBy(operatorId);
            item.setUpdateBy(operatorId);
            item.setIsValid(Boolean.valueOf(true));
            return mapper.insert(item);
        });
    }

    public List<Long> getStaffIdByStaffQuery(StaffQuery staffQuery) {
        if (StrUtil.isBlank((CharSequence)staffQuery.getStaffName()) || staffQuery.getCid() == null) {
            return Collections.emptyList();
        }
        return ((StaffInfoMapper)this.dao).getStaffIdByStaffQuery(staffQuery);
    }

    public List<String> getOtherCompany(Long cid) {
        ArrayList<String> otherCompanyList = new ArrayList<String>();
        otherCompanyList.add("\u5168\u90e8");
        otherCompanyList.add("\u672a\u660e\u786e\u5916\u5305\u4f01\u4e1a\u540d\u79f0");
        if (ObjectUtil.isNull((Object)cid)) {
            return otherCompanyList;
        }
        List<String> list = ((StaffInfoMapper)this.dao).selectOtherCompany(cid);
        if (CollectionUtil.isNotEmpty(list)) {
            otherCompanyList.addAll(list);
        }
        return otherCompanyList;
    }

    @Transactional
    public void changeThird2SelfPerson(BatchStafffWorkVo vo) {
        if (StringUtils.isNotEmpty((String)vo.getStaffInfoIds())) {
            List list = Arrays.stream(vo.getStaffInfoIds().split(",")).map(Long::valueOf).collect(Collectors.toList());
            vo.setStaffInfoIdList(list);
        }
        vo.setUpdateDate(new Date());
        ((StaffInfoMapper)this.dao).changeThird2SelfPerson(vo);
        Long cid = vo.getCid();
        List staffInfoIdList = vo.getStaffInfoIdList();
        ArrayList<StaffFieldChangeLog> staffFieldChangeLogList = new ArrayList<StaffFieldChangeLog>();
        if (CollectionUtil.isNotEmpty((Collection)staffInfoIdList)) {
            for (Long aLong : staffInfoIdList) {
                StaffFieldChangeLog log = new StaffFieldChangeLog();
                log.setStaffId(aLong);
                log.setCid(cid);
                log.setField(StaffFieldChangeEnum.STAFF_OUTSOURCE.getCode());
                log.setBeforeInfo("\u5916\u6765\u4eba\u5458");
                log.setAfterInfo("\u672c\u4f01\u4e1a\u4eba\u5458");
                log.setChangeReason("\u4f01\u4e1a\u624b\u52a8\u53d8\u66f4");
                staffFieldChangeLogList.add(log);
            }
            this.staffFieldChangeLogService.addChangeLogList(staffFieldChangeLogList, vo.getLoginBy());
        }
    }

    private List<ImproveStaffModel> mergeList(List<ImproveStaffModel> updateList) {
        HashSet<ImproveStaffModel> set = new HashSet<ImproveStaffModel>(updateList);
        return new ArrayList<ImproveStaffModel>(set);
    }

    private void improveFirstBeinTime(List<ImproveStaffModel> updateList, Map<Long, Map<String, List<PhcPhysicalStaffCheckInfo>>> cidIdCardMap, List<ImproveStaffModel> needImproveFirstBeinTimeList) {
        Map<Long, List<ImproveStaffModel>> companyMap = needImproveFirstBeinTimeList.stream().collect(Collectors.groupingBy(ImproveStaffModel::getCid));
        for (Long cid : companyMap.keySet()) {
            Map<String, List<PhcPhysicalStaffCheckInfo>> idCardMap = cidIdCardMap.get(cid);
            List<ImproveStaffModel> improveStaffModels = companyMap.get(cid);
            if (MapUtils.isEmpty(idCardMap)) {
                improveStaffModels.forEach(s -> s.setFirstBeginTime(DATE_2022_12_31));
                updateList.addAll(improveStaffModels);
                continue;
            }
            for (ImproveStaffModel improveStaffModel : improveStaffModels) {
                List<PhcPhysicalStaffCheckInfo> wandaHealthCards = idCardMap.get(improveStaffModel.getIdCard());
                if (CollectionUtils.isEmpty(wandaHealthCards)) {
                    improveStaffModel.setFirstBeginTime(DATE_2022_12_31);
                } else {
                    PhcPhysicalStaffCheckInfo earliest = wandaHealthCards.stream().min(Comparator.comparing(PhcPhysicalStaffCheckInfo::getCheckTime)).get();
                    Date checkTime = earliest.getCheckTime();
                    if (beforeWorkStatus.contains(earliest.getBodyCheckType()) || onWorkStatus.contains(earliest.getBodyCheckType())) {
                        improveStaffModel.setFirstBeginTime(checkTime);
                    } else if (checkTime.getTime() < DATE_2023_01_01.getTime()) {
                        improveStaffModel.setFirstBeginTime(checkTime);
                    } else {
                        improveStaffModel.setFirstBeginTime(DATE_2022_12_31);
                    }
                }
                updateList.add(improveStaffModel);
            }
        }
    }

    private void improveBeinTime(List<ImproveStaffModel> updateList, Map<Long, Map<String, List<PhcPhysicalStaffCheckInfo>>> cidIdCardMap, List<ImproveStaffModel> needImproveBeinTimeList) {
        Map<Long, List<ImproveStaffModel>> companyMap = needImproveBeinTimeList.stream().collect(Collectors.groupingBy(ImproveStaffModel::getCid));
        for (Long cid : companyMap.keySet()) {
            Map<String, List<PhcPhysicalStaffCheckInfo>> idCardMap = cidIdCardMap.get(cid);
            List<ImproveStaffModel> improveStaffModels = companyMap.get(cid);
            if (MapUtils.isEmpty(idCardMap)) {
                improveStaffModels.forEach(s -> s.setBeginTime(DATE_2022_12_31));
                updateList.addAll(improveStaffModels);
                continue;
            }
            for (ImproveStaffModel improveStaffModel : improveStaffModels) {
                List<PhcPhysicalStaffCheckInfo> wandaHealthCards = idCardMap.get(improveStaffModel.getIdCard());
                if (CollectionUtils.isEmpty(wandaHealthCards)) {
                    improveStaffModel.setBeginTime(DATE_2022_12_31);
                } else {
                    PhcPhysicalStaffCheckInfo earliestBeforCheck = wandaHealthCards.stream().filter(h -> beforeWorkStatus.contains(h.getBodyCheckType())).max(Comparator.comparing(PhcPhysicalStaffCheckInfo::getCheckTime)).orElse(null);
                    PhcPhysicalStaffCheckInfo earliestOnCheck = wandaHealthCards.stream().filter(h -> onWorkStatus.contains(h.getBodyCheckType())).min(Comparator.comparing(PhcPhysicalStaffCheckInfo::getCheckTime)).orElse(null);
                    PhcPhysicalStaffCheckInfo earliestLeaveCheck = wandaHealthCards.stream().filter(h -> leaveWorkStatus.contains(h.getBodyCheckType())).min(Comparator.comparing(PhcPhysicalStaffCheckInfo::getCheckTime)).orElse(null);
                    if (Objects.nonNull(earliestBeforCheck)) {
                        improveStaffModel.setBeginTime(earliestBeforCheck.getCheckTime());
                    } else if (Objects.nonNull(earliestOnCheck)) {
                        improveStaffModel.setBeginTime(earliestOnCheck.getCheckTime());
                    } else if (Objects.nonNull(earliestLeaveCheck)) {
                        if (earliestLeaveCheck.getCheckTime().getTime() < DATE_2023_01_01.getTime()) {
                            improveStaffModel.setBeginTime(earliestLeaveCheck.getCheckTime());
                        } else {
                            improveStaffModel.setBeginTime(DATE_2022_12_31);
                        }
                    }
                }
                updateList.add(improveStaffModel);
            }
        }
    }

    private String getReason(StaffAbnormalInfo staffShowInfo) {
        if (staffShowInfo.getLeaveTime() == null) {
            return "\u79bb\u804c\u65f6\u95f4\u4e0d\u5f97\u4e3a\u7a7a";
        }
        return "\u3010\u79bb\u804c\u6216\u8f6c\u5165\u65e0\u5371\u5bb3\u5c97\u4f4d\u65f6\u95f4\u3011\u4e0d\u5f97\u65e9\u4e8e\u6700\u8fd1\u4e00\u6b21\u7684\u4f53\u68c0\u65f6\u95f4";
    }
}

