/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.staff;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.util.CommonUtil;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.excel.ExcelUtil;
import cn.smarthse.modules.datacentre.enums.SysParamGroupEnum;
import cn.smarthse.modules.datacentre.model.system.SysParamModel;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.datacentre.provider.system.ISysParamProvideService;
import cn.smarthse.modules.health.dao.base.staff.StaffBasicInfoMapper;
import cn.smarthse.modules.health.dao.base.staff.StaffBasicWorkMapper;
import cn.smarthse.modules.health.dao.base.staff.StaffInfoMapper;
import cn.smarthse.modules.health.dao.base.staff.StaffWorkRoleMapper;
import cn.smarthse.modules.health.dao.base.staff.WorkNatureInfoMapper;
import cn.smarthse.modules.health.entity.base.company.CompanyOrganization;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicWork;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffWorkRole;
import cn.smarthse.modules.health.entity.base.staff.WorkNatureInfo;
import cn.smarthse.modules.health.entity.base.staff.importstaff.StaffInfoExcelImportVo;
import cn.smarthse.modules.health.entity.base.staff.importstaff.StaffInfoNeedImportVo;
import cn.smarthse.modules.health.entity.base.workinfo.WorkRoleInfo;
import cn.smarthse.modules.health.entity.work.informmanager.NoInformStaff;
import cn.smarthse.modules.health.enums.staff.NoInformStaffChangeWorkStatusEnum;
import cn.smarthse.modules.health.enums.staff.StaffGenderEnum;
import cn.smarthse.modules.health.enums.staff.StaffInfoImportStateEnum;
import cn.smarthse.modules.health.enums.staff.StaffMaritalStatusEnum;
import cn.smarthse.modules.health.enums.staff.StaffWorkPropertyEnum;
import cn.smarthse.modules.health.enums.staff.StaffWorkStatusEnum;
import cn.smarthse.modules.health.enums.staff.WorkNatureEnum;
import cn.smarthse.modules.health.service.base.company.ICompanyOrganizationService;
import cn.smarthse.modules.health.service.base.staff.IStaffBasicInfoService;
import cn.smarthse.modules.health.service.base.staff.IStaffBasicWorkService;
import cn.smarthse.modules.health.service.base.staff.IStaffFieldChangeLogService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoImportService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.base.staff.IStaffOccupationHealthService;
import cn.smarthse.modules.health.service.base.staff.IStaffWorkRoleService;
import cn.smarthse.modules.health.service.base.staff.IWorkNatureInfoService;
import cn.smarthse.modules.health.service.base.workinfo.IWorkRoleInfoService;
import cn.smarthse.modules.health.service.work.informmanager.INoInformStaffService;
import cn.smarthse.snowflake.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class StaffInfoImportServiceImpl
implements IStaffInfoImportService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StaffInfoImportServiceImpl.class);
    @Autowired
    private ICompanyOrganizationService companyOrganizationService;
    @Autowired
    private IWorkRoleInfoService workRoleInfoService;
    @DubboReference(version="1.0.0")
    private ISysParamProvideService sysParamProvideService;
    @Autowired
    private IStaffBasicInfoService staffBasicInfoService;
    @Autowired
    private IStaffWorkRoleService staffWorkRoleService;
    @Autowired
    private IStaffBasicWorkService staffBasicWorkService;
    @Autowired
    private IStaffInfoService staffInfoService;
    @Autowired
    private IStaffFieldChangeLogService staffFieldChangeLogService;
    @Autowired
    private IWorkNatureInfoService workNatureInfoService;
    @Autowired
    private IStaffOccupationHealthService staffOccupationHealthService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaService;
    @Autowired
    protected IdWorker idworker;
    @Autowired
    private INoInformStaffService noInformStaffService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StaffInfoNeedImportVo getStaffInfoFromExcel(String ossfile, Long cid, Boolean isThirdParty, Long loginStaffId) {
        HSSFWorkbook wb = null;
        StaffInfoNeedImportVo data = new StaffInfoNeedImportVo();
        try {
            wb = new HSSFWorkbook(ExcelUtil.getInstance().getOssInputStream(ossfile));
        }
        catch (Exception sheet) {
        }
        finally {
            if (wb != null) {
                try {
                    HSSFSheet sheet = wb.getSheetAt(0);
                    data = this.getStaffInfoFromExcelSheet(sheet, loginStaffId, cid, isThirdParty);
                    wb.close();
                }
                catch (IOException sheet) {}
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StaffInfoNeedImportVo getStaffInfoZJFromExcel(String ossfile, Long cid, Boolean isThirdParty, Long loginStaffId) {
        HSSFWorkbook wb = null;
        StaffInfoNeedImportVo data = new StaffInfoNeedImportVo();
        try {
            wb = new HSSFWorkbook(ExcelUtil.getInstance().getOssInputStream(ossfile));
        }
        catch (Exception sheet) {
        }
        finally {
            if (wb != null) {
                try {
                    HSSFSheet sheet = wb.getSheetAt(0);
                    data = this.getStaffInfoZJFromExcelSheet(sheet, loginStaffId, cid, isThirdParty);
                    wb.close();
                }
                catch (IOException sheet) {}
            }
        }
        return data;
    }

    private StaffInfoNeedImportVo getStaffInfoFromExcelSheet(HSSFSheet sheet, Long loginStaffId, Long cid, Boolean isThirdCompany) {
        StaffInfoNeedImportVo info = new StaffInfoNeedImportVo();
        ArrayList<StaffInfoExcelImportVo> list = new ArrayList<StaffInfoExcelImportVo>();
        int rowIndex = 0;
        int cellIndex = 0;
        cellIndex = isThirdCompany != false ? 23 : 21;
        HashMap<String, CompanyOrganization> needAddOrg = new HashMap<String, CompanyOrganization>();
        HashMap<String, WorkRoleInfo> needAddworkList = new HashMap<String, WorkRoleInfo>();
        ArrayList<String> workAndDeptNames = new ArrayList<String>();
        Iterator iter = sheet.rowIterator();
        while (iter.hasNext()) {
            Row row = (Row)iter.next();
            if (++rowIndex == 1 || rowIndex == 2) continue;
            StaffInfoExcelImportVo vo = new StaffInfoExcelImportVo();
            vo.setLoginStaffId(loginStaffId);
            vo.setCid(cid);
            if (isThirdCompany.booleanValue()) {
                vo.setIsThirdCompany(Global.TRUE);
            } else {
                vo.setIsThirdCompany(Global.FALSE);
            }
            vo.setErrorReason("");
            for (int i = 0; i < cellIndex; ++i) {
                Cell cell = row.getCell(i);
                if (cell == null) {
                    cell = new HSSFWorkbook().createSheet().createRow(1).createCell(0);
                }
                if (isThirdCompany.booleanValue()) {
                    if (i != 17 && i != 19 && i != 16 && i != 9) {
                        cell.setCellType(CellType.STRING);
                    }
                    this.formatEveryExcelCellforThird(cell, i, rowIndex, vo, needAddOrg, needAddworkList, workAndDeptNames);
                    continue;
                }
                if (i != 17 && i != 15 && i != 9 && i != 6) {
                    cell.setCellType(CellType.STRING);
                }
                this.formatEveryExcelCellforSelf(cell, i, rowIndex, vo, needAddOrg, needAddworkList, workAndDeptNames);
            }
            Object allValues = "";
            for (String value : vo.getKeyValue().values()) {
                allValues = (String)allValues + value;
            }
            if (!StringUtils.isNotEmpty((String)allValues)) continue;
            list.add(vo);
        }
        info.setStaffList(list);
        List<CompanyOrganization> needAddOrgs = this.getOrgList(needAddOrg);
        List<WorkRoleInfo> needAddworks = this.getWorkList(needAddworkList);
        if (needAddOrgs != null && needAddOrgs.size() > 0) {
            info.setNeedAddOrgs(needAddOrgs);
        }
        if (needAddworks != null && needAddworks.size() > 0) {
            info.setNeedAddwork(needAddworks);
        }
        info.setWorkAndDeptNames(workAndDeptNames);
        return info;
    }

    private StaffInfoNeedImportVo getStaffInfoZJFromExcelSheet(HSSFSheet sheet, Long loginStaffId, Long cid, Boolean isThirdCompany) {
        StaffInfoNeedImportVo info = new StaffInfoNeedImportVo();
        ArrayList<StaffInfoExcelImportVo> list = new ArrayList<StaffInfoExcelImportVo>();
        int rowIndex = 0;
        int cellIndex = 0;
        cellIndex = isThirdCompany != false ? 16 : 14;
        HashMap<String, CompanyOrganization> needAddOrg = new HashMap<String, CompanyOrganization>();
        HashMap<String, WorkRoleInfo> needAddworkList = new HashMap<String, WorkRoleInfo>();
        ArrayList<String> workAndDeptNames = new ArrayList<String>();
        ArrayList<Object> rowList = new ArrayList<Object>();
        for (int i = 0; i < sheet.getPhysicalNumberOfRows(); ++i) {
            HSSFRow sheetRow = sheet.getRow(i);
            if (sheetRow == null) continue;
            boolean bl = false;
            for (int j = 0; j < sheetRow.getPhysicalNumberOfCells(); ++j) {
                HSSFCell cell = sheetRow.getCell(j);
                if (cell == null || CellType.BLANK == cell.getCellType()) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            rowList.add(sheetRow);
        }
        if (CollectionUtils.isEmpty(rowList)) {
            throw new RuntimeException("\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        List organizationList = this.companyOrganizationService.getAllCompanyOrganizations(cid);
        for (HSSFRow hSSFRow : rowList) {
            if (++rowIndex == 1 || rowIndex == 2) continue;
            StaffInfoExcelImportVo vo = new StaffInfoExcelImportVo();
            vo.setLoginStaffId(loginStaffId);
            vo.setCid(cid);
            if (isThirdCompany.booleanValue()) {
                vo.setIsThirdCompany(Global.TRUE);
            } else {
                vo.setIsThirdCompany(Global.FALSE);
            }
            vo.setErrorReason("");
            for (int i = 0; i < cellIndex; ++i) {
                HSSFCell cell = hSSFRow.getCell(i);
                if (cell == null) {
                    cell = new HSSFWorkbook().createSheet().createRow(1).createCell(0);
                }
                if (isThirdCompany.booleanValue()) {
                    if (i != 4 && i != 5 && i != 9) {
                        cell.setCellType(CellType.STRING);
                    }
                    this.formatEveryExcelCellforThirdZJ((Row)hSSFRow, (Cell)cell, i, rowIndex, vo, needAddOrg, needAddworkList, workAndDeptNames, organizationList);
                    continue;
                }
                if (i != 2 && i != 3 && i != 7) {
                    cell.setCellType(CellType.STRING);
                }
                this.formatEveryExcelCellforSelfZJ((Row)hSSFRow, (Cell)cell, i, rowIndex, vo, needAddOrg, needAddworkList, workAndDeptNames, organizationList);
            }
            list.add(vo);
        }
        info.setStaffList(list);
        List<CompanyOrganization> needAddOrgs = this.getOrgList(needAddOrg);
        List<WorkRoleInfo> list2 = this.getWorkList(needAddworkList);
        if (needAddOrgs != null && needAddOrgs.size() > 0) {
            info.setNeedAddOrgs(needAddOrgs);
        }
        if (list2 != null && list2.size() > 0) {
            info.setNeedAddwork(list2);
        }
        info.setWorkAndDeptNames(workAndDeptNames);
        return info;
    }

    @Transactional(readOnly=false)
    public void formatEveryExcelCellforSelf(Cell cell, int cellIndex, int rowIndex, StaffInfoExcelImportVo vo, Map<String, CompanyOrganization> needAddOrg, Map<String, WorkRoleInfo> needAddworkList, List<String> workAndDeptNames) {
        switch (cellIndex) {
            case 0: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                vo.getStaffInfo().setIsThirdParty(Global.FALSE);
                vo.getCurrentStaffWorkRole().setIsHistory(Global.FALSE);
                vo.getCurrentStaffWorkRole().setWorkProperty(StaffWorkPropertyEnum.MAJOR.getValue());
                vo.getCurrentStaffWorkRole().setIsThirdParty(Global.FALSE);
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    vo.setRealName(cell.getStringCellValue().trim());
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    vo.getStaffBasicInfo().setRealName(vo.getRealName());
                    break;
                }
                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u59d3\u540d\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                break;
            }
            case 1: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    String workName = cell.getStringCellValue();
                    WorkRoleInfo work = this.getWorkByNameAndCid(workName, vo.getCid());
                    if (work != null) {
                        if (work.getId() == null) {
                            workAndDeptNames.add("\u7b2c" + rowIndex + "\u884c\u7684" + workName + "\u672a\u5b58\u5728\u7cfb\u7edf\u4e2d");
                            vo.setIsHaveWork(Boolean.valueOf(false));
                            WorkRoleInfo workinfo = needAddworkList.get(work.getWorkName() + "/" + work.getOrgName());
                            if (workinfo == null || workinfo.getId() == null) {
                                workinfo = new WorkRoleInfo();
                                List orgs = this.companyOrganizationService.getListByName(work.getOrgName(), vo.getCid());
                                if (orgs != null && orgs.size() > 0) {
                                    workinfo.setCid(vo.getCid());
                                    workinfo.setOrgId(((CompanyOrganization)orgs.get(0)).getId());
                                    workinfo.setWorkName(work.getWorkName());
                                    workinfo.setOrgName(work.getOrgName());
                                    workinfo.setId(Long.valueOf(this.idworker.nextId()));
                                    needAddworkList.put(work.getWorkName() + "/" + work.getOrgName(), workinfo);
                                } else {
                                    CompanyOrganization org = needAddOrg.get(work.getOrgName());
                                    if (org == null || org.getId() == null) {
                                        org = new CompanyOrganization();
                                        org.setCid(vo.getCid());
                                        org.setLevel(Byte.valueOf((byte)1));
                                        org.setId(Long.valueOf(this.idworker.nextId()));
                                        org.setOrganizationName(work.getOrgName());
                                        needAddOrg.put(work.getOrgName(), org);
                                    }
                                    workinfo.setCid(vo.getCid());
                                    workinfo.setOrgId(org.getId());
                                    workinfo.setOrgName(work.getOrgName());
                                    workinfo.setWorkName(work.getWorkName());
                                    workinfo.setId(Long.valueOf(this.idworker.nextId()));
                                    needAddworkList.put(work.getWorkName() + "/" + work.getOrgName(), workinfo);
                                }
                            }
                            work = workinfo;
                        }
                        vo.setWorkName(work.getWorkName());
                        vo.setWorkId(work.getId());
                        vo.setDeptId(work.getOrgId());
                        vo.setDeptName(work.getOrgName());
                        if (vo.getDataState() != null && vo.getDataState().byteValue() != StaffInfoImportStateEnum.normal.getValue()) break;
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                        break;
                    }
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                    vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u5c97\u4f4d/\u90e8\u95e8\u683c\u5f0f\u8f93\u5165\u9519\u8bef;<br/>");
                    break;
                }
                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u5c97\u4f4d/\u90e8\u95e8\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                break;
            }
            case 2: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    vo.setSexName(cell.getStringCellValue().trim());
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    if (vo.getSexName().equals("\u7537")) {
                        vo.setGender(Byte.valueOf(StaffGenderEnum.MALE.getValue().byteValue()));
                    } else if (vo.getSexName().equals("\u5973")) {
                        vo.setGender(Byte.valueOf(StaffGenderEnum.FEMALE.getValue().byteValue()));
                    } else {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u6027\u522b\u683c\u5f0f\u4e0d\u5bf9;<br/>");
                    }
                    vo.getStaffBasicInfo().setGender(vo.getGender());
                    break;
                }
                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u6027\u522b\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                break;
            }
            case 3: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    vo.setMobile(cell.getStringCellValue().trim());
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    vo.getStaffBasicInfo().setMobile(vo.getMobile());
                    break;
                }
                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u624b\u673a\u53f7\u7801\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                break;
            }
            case 4: {
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    vo.setCardNo(cell.getStringCellValue().trim());
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    if (vo.getCardNo().length() != 18 && vo.getCardNo().length() != 15) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u8eab\u4efd\u8bc1\u53f7\u683c\u5f0f\u4e0d\u5bf9;<br/>");
                    } else {
                        Object birth = "19000101";
                        birth = vo.getCardNo().length() == 15 ? "19" + vo.getCardNo().substring(6, 12) : vo.getCardNo().substring(6, 14);
                        try {
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
                            vo.setBirthDay(sdf.parse((String)birth));
                            sdf = new SimpleDateFormat("yyyy");
                            vo.setAge(Integer.valueOf(Integer.parseInt(sdf.format(new Date())) - Integer.parseInt(((String)birth).substring(0, 4))));
                            vo.setNativePlace(this.sysAreaService.getFullName(Long.valueOf(vo.getCardNo().substring(0, 6) + "000000"), ""));
                        }
                        catch (Exception e) {
                            vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u8eab\u4efd\u8bc1\u53f7\u89e3\u6790\u8be5\u4eba\u7684\u51fa\u751f\u65e5\u671f\u9519\u8bef;<br/>");
                        }
                    }
                    vo.getStaffBasicInfo().setIdCard(vo.getCardNo());
                    vo.getStaffBasicInfo().setAge(vo.getAge());
                    vo.getStaffBasicInfo().setBirthday(vo.getBirthDay());
                    vo.getStaffBasicInfo().setNativePlace(vo.getNativePlace());
                    break;
                }
                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ",\u8eab\u4efd\u8bc1\u53f7\u4e3a\u5fc5\u586b\u9879\u4e0d\u53ef\u4e3a\u7a7a;<br/>");
                break;
            }
            case 5: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    vo.setWorkStateName(cell.getStringCellValue().trim());
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    if (StaffWorkStatusEnum.ONWORKING.getName().equals(vo.getWorkStateName())) {
                        vo.setWorkState(StaffWorkStatusEnum.ONWORKING.getValue());
                    } else if (StaffWorkStatusEnum.NOWORKED.getName().equals(vo.getWorkStateName())) {
                        vo.setWorkState(StaffWorkStatusEnum.NOWORKED.getValue());
                    } else if (StaffWorkStatusEnum.FURLOUGH.getName().equals(vo.getWorkStateName())) {
                        vo.setWorkState(StaffWorkStatusEnum.FURLOUGH.getValue());
                    }
                    vo.getCurrentStaffWorkRole().setStatus(vo.getWorkState());
                    break;
                }
                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u5c97\u4f4d\u72b6\u6001\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                break;
            }
            case 6: {
                if (cell != null && cell.getCellType() != CellType.BLANK) {
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    StaffInfoImportServiceImpl.dateHandle(cell);
                    if (cell.getCellType() == CellType.BLANK) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u8fdb\u5382\u65f6\u95f4\u89e3\u6790\u9519\u8bef;<br/>");
                        break;
                    }
                    vo.getStaffBasicWork().setJoinTime(cell.getDateCellValue());
                    if (vo.getCurrentStaffWorkRole().getBeginTime() != null) break;
                    vo.getCurrentStaffWorkRole().setBeginTime(cell.getDateCellValue());
                    break;
                }
                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u8fdb\u5382\u65f6\u95f4\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                break;
            }
            case 7: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    vo.setNativePlace(cell.getStringCellValue().trim());
                    vo.getStaffBasicInfo().setNativePlace(vo.getNativePlace());
                    break;
                }
                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u7c4d\u8d2f\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                break;
            }
            case 8: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    vo.setEducation(cell.getStringCellValue().trim());
                    SysParamModel sysParam = this.sysParamProvideService.getSysParamByName(vo.getEducation(), vo.getCid(), SysParamGroupEnum.educ_background);
                    if (sysParam != null) {
                        if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                            vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                        }
                        vo.setEducationId(sysParam.getId());
                        vo.getStaffBasicInfo().setEducation(vo.getEducationId());
                        break;
                    }
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                    vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u5b66\u5386\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728;<br/>");
                    break;
                }
                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u5b66\u5386\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                break;
            }
            case 9: {
                if (cell != null && cell.getCellType() != CellType.BLANK) {
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    StaffInfoImportServiceImpl.dateHandle(cell);
                    if (cell.getCellType() == CellType.BLANK) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u4e0a\u5c97\u65f6\u95f4\u89e3\u6790\u9519\u8bef;<br/>");
                        break;
                    }
                    vo.getCurrentStaffWorkRole().setBeginTime(cell.getDateCellValue());
                    break;
                }
                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u4e0a\u5c97\u65f6\u95f4\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                break;
            }
            case 10: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    vo.setWorkNo(cell.getStringCellValue().trim());
                    vo.getStaffBasicWork().setWorkNo(vo.getWorkNo());
                    break;
                }
                vo.getStaffBasicWork().setWorkNo(" ");
                break;
            }
            case 11: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    vo.setCompanyJob(cell.getStringCellValue().trim());
                    vo.getStaffBasicWork().setJobTitle(vo.getCompanyJob());
                    break;
                }
                vo.getStaffBasicWork().setJobTitle(" ");
                break;
            }
            case 12: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    vo.setNation(cell.getStringCellValue().trim());
                    vo.getStaffBasicInfo().setNation(vo.getNation());
                    break;
                }
                vo.getStaffBasicInfo().setNation(" ");
                break;
            }
            case 13: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (!StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                }
                vo.setMarriageState(cell.getStringCellValue().trim());
                if (StaffMaritalStatusEnum.MARRIED.getName().equals(vo.getMarriageState())) {
                    vo.setMaritalStatus(StaffMaritalStatusEnum.MARRIED.getCode());
                } else if (StaffMaritalStatusEnum.UNMARRIED.getName().equals(vo.getMarriageState())) {
                    vo.setMaritalStatus(StaffMaritalStatusEnum.UNMARRIED.getCode());
                } else if (StaffMaritalStatusEnum.DISSOCIATON.getName().equals(vo.getMarriageState())) {
                    vo.setMaritalStatus(StaffMaritalStatusEnum.DISSOCIATON.getCode());
                } else {
                    vo.setMaritalStatus(Byte.valueOf((byte)-1));
                }
                vo.getStaffBasicInfo().setMaritalStatus(vo.getMaritalStatus());
                break;
            }
            case 14: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    vo.setMajor(cell.getStringCellValue().trim());
                    vo.getStaffBasicInfo().setMajor(vo.getMajor());
                    break;
                }
                vo.getStaffBasicInfo().setMajor(" ");
                break;
            }
            case 15: {
                if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                }
                if (cell == null || cell.getCellType() == CellType.BLANK) break;
                StaffInfoImportServiceImpl.dateHandle(cell);
                if (cell.getCellType() == CellType.BLANK) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                    vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u53c2\u52a0\u5de5\u4f5c\u65f6\u95f4\u89e3\u6790\u9519\u8bef;<br/>");
                    break;
                }
                vo.getStaffBasicWork().setWorkTime(cell.getDateCellValue());
                break;
            }
            case 16: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (!StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                }
                vo.setIsRadiationName(cell.getStringCellValue().trim());
                if (vo.getIsRadiationName().equals("\u662f")) {
                    vo.setIsRadiation(Global.TRUE);
                    break;
                }
                if (vo.getIsRadiationName().equals("\u5426")) {
                    vo.setIsRadiation(Global.FALSE);
                    break;
                }
                vo.setIsRadiation(Global.FALSE);
                break;
            }
            case 17: {
                if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                }
                if (cell == null || cell.getCellType() == CellType.BLANK) break;
                StaffInfoImportServiceImpl.dateHandle(cell);
                if (cell.getCellType() == CellType.BLANK) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                    vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u4ece\u4e8b\u653e\u5c04\u5de5\u4f5c\u8d77\u59cb\u65f6\u95f4\u89e3\u6790\u9519\u8bef;<br/>");
                    break;
                }
                vo.setRadiationYear(cell.getDateCellValue());
                break;
            }
            case 18: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (!StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                }
                vo.setRadiationTypeName(cell.getStringCellValue().trim());
                String[] strs = vo.getRadiationTypeName().split(" ");
                SysParamModel sysParam = this.sysParamProvideService.getSysParamByNameGroupCode(strs[1], vo.getCid(), SysParamGroupEnum.occup_exposure_workingtype, strs[0]);
                if (sysParam == null) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                    vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u804c\u4e1a\u7167\u5c04\u804c\u4e1a\u5206\u7c7b\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728;<br/>");
                    break;
                }
                vo.setRadiationType(sysParam.getId());
                break;
            }
            case 19: {
                SysParamModel sysParam;
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (!StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                vo.setSpecialOperationsName(cell.getStringCellValue().trim());
                if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                }
                if ((sysParam = this.sysParamProvideService.getSysParamByName(vo.getSpecialOperationsName(), vo.getCid(), SysParamGroupEnum.spec_operation_type)) == null) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                    vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u7279\u79cd\u4f5c\u4e1a\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728;<br/>");
                    break;
                }
                vo.setSpecialOperations(sysParam.getId());
                break;
            }
            case 20: {
                SysParamModel sysParam;
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (!StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                vo.setSpecialWorkName(cell.getStringCellValue().trim());
                if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                }
                if ((sysParam = this.sysParamProvideService.getSysParamByName(vo.getSpecialWorkName(), vo.getCid(), SysParamGroupEnum.spec_working_type)) == null) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                    vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u7279\u6b8a\u4f5c\u4e1a\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728;<br/>");
                    break;
                }
                vo.setSpecialWork(sysParam.getId());
            }
        }
    }

    @Transactional(readOnly=false)
    public void formatEveryExcelCellforThird(Cell cell, int cellIndex, int rowIndex, StaffInfoExcelImportVo vo, Map<String, CompanyOrganization> needAddOrg, Map<String, WorkRoleInfo> needAddworkList, List<String> workAndDeptNames) {
        switch (cellIndex) {
            case 0: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                vo.setErrorReason("");
                vo.getStaffInfo().setIsThirdParty(Global.TRUE);
                vo.getCurrentStaffWorkRole().setIsHistory(Global.FALSE);
                vo.getCurrentStaffWorkRole().setWorkProperty(StaffWorkPropertyEnum.MAJOR.getValue());
                vo.getCurrentStaffWorkRole().setIsThirdParty(Global.FALSE);
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    vo.setThirdCompanyName(cell.getStringCellValue().trim());
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    vo.getStaffInfo().setOtherCompany(vo.getThirdCompanyName());
                    break;
                }
                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u5916\u534f\u4f01\u4e1a\u540d\u79f0\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                break;
            }
            case 1: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (!StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                }
                Byte outsource = null;
                if ("\u52b3\u52a1\u6d3e\u9063".equals(cell.getStringCellValue().trim())) {
                    outsource = 1;
                } else if ("\u52b3\u52a1\u5916\u5305".equals(cell.getStringCellValue().trim())) {
                    outsource = 2;
                } else if ("\u5176\u4ed6".equals(cell.getStringCellValue().trim())) {
                    outsource = 3;
                }
                vo.setOutsource(outsource);
                vo.getStaffInfo().setOutsource(outsource);
                break;
            }
            case 2: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    vo.setWorkNo(cell.getStringCellValue().trim());
                    vo.getStaffBasicWork().setWorkNo(vo.getWorkNo());
                    break;
                }
                vo.getStaffBasicWork().setWorkNo(" ");
                vo.setWorkNo(" ");
                break;
            }
            case 3: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    vo.setRealName(cell.getStringCellValue().trim());
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    vo.getStaffBasicInfo().setRealName(vo.getRealName());
                    break;
                }
                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u59d3\u540d\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                break;
            }
            case 4: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    String workName = cell.getStringCellValue();
                    WorkRoleInfo work = this.getWorkByNameAndCid(workName, vo.getCid());
                    if (work != null) {
                        if (work.getId() == null) {
                            workAndDeptNames.add("\u7b2c" + rowIndex + "\u884c\u7684" + workName + "\u672a\u5b58\u5728\u7cfb\u7edf\u4e2d");
                            vo.setIsHaveWork(Boolean.valueOf(false));
                            WorkRoleInfo workinfo = needAddworkList.get(work.getWorkName() + "/" + work.getOrgName());
                            if (workinfo == null || workinfo.getId() == null) {
                                workinfo = new WorkRoleInfo();
                                List orgs = this.companyOrganizationService.getListByName(work.getOrgName(), vo.getCid());
                                if (orgs != null && orgs.size() > 0) {
                                    workinfo.setCid(vo.getCid());
                                    workinfo.setOrgId(((CompanyOrganization)orgs.get(0)).getId());
                                    workinfo.setWorkName(work.getWorkName());
                                    workinfo.setOrgName(work.getOrgName());
                                    workinfo.setId(Long.valueOf(this.idworker.nextId()));
                                    needAddworkList.put(work.getWorkName() + "/" + work.getOrgName(), workinfo);
                                } else {
                                    CompanyOrganization org = needAddOrg.get(work.getOrgName());
                                    if (org == null || org.getId() == null) {
                                        org = new CompanyOrganization();
                                        org.setCid(vo.getCid());
                                        org.setLevel(Byte.valueOf((byte)1));
                                        org.setId(Long.valueOf(this.idworker.nextId()));
                                        org.setOrganizationName(work.getOrgName());
                                        needAddOrg.put(work.getOrgName(), org);
                                    }
                                    workinfo.setCid(vo.getCid());
                                    workinfo.setOrgId(org.getId());
                                    workinfo.setOrgName(work.getOrgName());
                                    workinfo.setWorkName(work.getWorkName());
                                    workinfo.setId(Long.valueOf(this.idworker.nextId()));
                                    needAddworkList.put(work.getWorkName() + "/" + work.getOrgName(), workinfo);
                                }
                            }
                            work = workinfo;
                        }
                        vo.setWorkName(work.getWorkName());
                        vo.setWorkId(work.getId());
                        vo.setDeptId(work.getOrgId());
                        vo.setDeptName(work.getOrgName());
                        if (vo.getDataState() != null && vo.getDataState().byteValue() != StaffInfoImportStateEnum.normal.getValue()) break;
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                        break;
                    }
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                    vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u5c97\u4f4d/\u90e8\u95e8\u683c\u5f0f\u586b\u5199\u9519\u8bef;<br/>");
                    break;
                }
                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u5c97\u4f4d/\u90e8\u95e8\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                break;
            }
            case 5: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    vo.setSexName(cell.getStringCellValue().trim());
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    if (vo.getSexName().equals("\u7537")) {
                        vo.setGender(Byte.valueOf(StaffGenderEnum.MALE.getValue().byteValue()));
                    } else if (vo.getSexName().equals("\u5973")) {
                        vo.setGender(Byte.valueOf(StaffGenderEnum.FEMALE.getValue().byteValue()));
                    } else {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u6027\u522b\u683c\u5f0f\u4e0d\u5bf9;<br/>");
                    }
                    vo.getStaffBasicInfo().setGender(vo.getGender());
                    break;
                }
                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u6027\u522b\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                break;
            }
            case 6: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    vo.setMobile(cell.getStringCellValue().trim());
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    vo.getStaffBasicInfo().setMobile(vo.getMobile());
                    break;
                }
                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u624b\u673a\u53f7\u7801\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                break;
            }
            case 7: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    vo.setCardNo(cell.getStringCellValue().trim());
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    if (vo.getCardNo().length() != 18 && vo.getCardNo().length() != 15) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u8eab\u4efd\u8bc1\u53f7\u683c\u5f0f\u4e0d\u5bf9;<br/>");
                        break;
                    }
                    Object birth = "19000101";
                    birth = vo.getCardNo().length() == 15 ? "19" + vo.getCardNo().substring(6, 12) : vo.getCardNo().substring(6, 14);
                    try {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
                        vo.setBirthDay(sdf.parse((String)birth));
                        sdf = new SimpleDateFormat("yyyy");
                        vo.setAge(Integer.valueOf(Integer.parseInt(sdf.format(new Date())) - Integer.parseInt(((String)birth).substring(0, 4))));
                        vo.setNativePlace(this.sysAreaService.getFullName(Long.valueOf(vo.getCardNo().substring(0, 6) + "000000"), ""));
                    }
                    catch (Exception e) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u8eab\u4efd\u8bc1\u53f7\u89e3\u6790\u8be5\u4eba\u7684\u51fa\u751f\u65e5\u671f\u9519\u8bef;<br/>");
                    }
                    vo.getStaffBasicInfo().setIdCard(vo.getCardNo());
                    vo.getStaffBasicInfo().setAge(vo.getAge());
                    vo.getStaffBasicInfo().setBirthday(vo.getBirthDay());
                    vo.getStaffBasicInfo().setNativePlace(vo.getNativePlace());
                    break;
                }
                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ",\u8eab\u4efd\u8bc1\u53f7\u8bf7\u4e3a\u5fc5\u586b\u9879\u4e0d\u53ef\u4e3a\u7a7a;<br/>");
                break;
            }
            case 8: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    vo.setWorkStateName(cell.getStringCellValue().trim());
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    if (StaffWorkStatusEnum.ONWORKING.getName().equals(vo.getWorkStateName())) {
                        vo.setWorkState(StaffWorkStatusEnum.ONWORKING.getValue());
                    } else if (StaffWorkStatusEnum.NOWORKED.getName().equals(vo.getWorkStateName())) {
                        vo.setWorkState(StaffWorkStatusEnum.NOWORKED.getValue());
                    } else if (StaffWorkStatusEnum.FURLOUGH.getName().equals(vo.getWorkStateName())) {
                        vo.setWorkState(StaffWorkStatusEnum.FURLOUGH.getValue());
                    }
                    vo.getCurrentStaffWorkRole().setStatus(vo.getWorkState());
                    break;
                }
                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u5c97\u4f4d\u72b6\u6001\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                break;
            }
            case 9: {
                if (cell != null && cell.getCellType() != CellType.BLANK) {
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    StaffInfoImportServiceImpl.dateHandle(cell);
                    if (cell.getCellType() == CellType.BLANK) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u4e0a\u5c97\u65f6\u95f4\u89e3\u6790\u9519\u8bef;<br/>");
                        break;
                    }
                    vo.getCurrentStaffWorkRole().setBeginTime(cell.getDateCellValue());
                    break;
                }
                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u4e0a\u5c97\u65f6\u95f4\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                break;
            }
            case 10: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    vo.setCompanyJob(cell.getStringCellValue().trim());
                    vo.getStaffBasicWork().setJobTitle(vo.getCompanyJob());
                    break;
                }
                vo.getStaffBasicWork().setJobTitle(" ");
                break;
            }
            case 11: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    vo.setNativePlace(cell.getStringCellValue().trim());
                    vo.getStaffBasicInfo().setNativePlace(vo.getNativePlace());
                    break;
                }
                if (!StringUtils.isEmpty((CharSequence)vo.getStaffBasicInfo().getNativePlace())) break;
                vo.getStaffBasicInfo().setNativePlace(" ");
                break;
            }
            case 12: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    vo.setNation(cell.getStringCellValue().trim());
                    vo.getStaffBasicInfo().setNation(vo.getNation());
                    break;
                }
                vo.getStaffBasicInfo().setNation(" ");
                break;
            }
            case 13: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (!StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                }
                vo.setMarriageState(cell.getStringCellValue().trim());
                if (StaffMaritalStatusEnum.MARRIED.getName().equals(vo.getMarriageState())) {
                    vo.setMaritalStatus(StaffMaritalStatusEnum.MARRIED.getCode());
                } else if (StaffMaritalStatusEnum.UNMARRIED.getName().equals(vo.getMarriageState())) {
                    vo.setMaritalStatus(StaffMaritalStatusEnum.UNMARRIED.getCode());
                } else if (StaffMaritalStatusEnum.DISSOCIATON.getName().equals(vo.getMarriageState())) {
                    vo.setMaritalStatus(StaffMaritalStatusEnum.DISSOCIATON.getCode());
                } else {
                    vo.setMaritalStatus(Byte.valueOf((byte)-1));
                }
                vo.getStaffBasicInfo().setMaritalStatus(vo.getMaritalStatus());
                break;
            }
            case 14: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (!StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                vo.setEducation(cell.getStringCellValue().trim());
                SysParamModel sysParam = this.sysParamProvideService.getSysParamByName(vo.getEducation(), vo.getCid(), SysParamGroupEnum.educ_background);
                if (sysParam != null) {
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    vo.setEducationId(sysParam.getId());
                    vo.getStaffBasicInfo().setEducation(vo.getEducationId());
                    break;
                }
                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u5b66\u5386\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728;<br/>");
                break;
            }
            case 15: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    vo.setMajor(cell.getStringCellValue().trim());
                    vo.getStaffBasicInfo().setMajor(vo.getMajor());
                    break;
                }
                vo.getStaffBasicInfo().setMajor(" ");
                break;
            }
            case 16: {
                if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                }
                if (cell == null || cell.getCellType() == CellType.BLANK) break;
                StaffInfoImportServiceImpl.dateHandle(cell);
                if (cell.getCellType() == CellType.BLANK) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                    vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u8fdb\u5382\u65f6\u95f4\u89e3\u6790\u9519\u8bef;<br/>");
                    break;
                }
                vo.getStaffBasicWork().setJoinTime(cell.getDateCellValue());
                if (vo.getCurrentStaffWorkRole().getBeginTime() != null) break;
                vo.getCurrentStaffWorkRole().setBeginTime(cell.getDateCellValue());
                break;
            }
            case 17: {
                if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                }
                if (cell == null || cell.getCellType() == CellType.BLANK) break;
                StaffInfoImportServiceImpl.dateHandle(cell);
                if (cell.getCellType() == CellType.BLANK) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                    vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u53c2\u52a0\u5de5\u4f5c\u65f6\u95f4\u89e3\u6790\u9519\u8bef;<br/>");
                    break;
                }
                vo.getStaffBasicWork().setWorkTime(cell.getDateCellValue());
                break;
            }
            case 18: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (!StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                }
                vo.setIsRadiationName(cell.getStringCellValue().trim());
                if (vo.getIsRadiationName().equals("\u662f")) {
                    vo.setIsRadiation(Global.TRUE);
                    break;
                }
                if (vo.getIsRadiationName().equals("\u5426")) {
                    vo.setIsRadiation(Global.FALSE);
                    break;
                }
                vo.setIsRadiation(Global.FALSE);
                break;
            }
            case 19: {
                if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                }
                if (cell == null || cell.getCellType() == CellType.BLANK) break;
                StaffInfoImportServiceImpl.dateHandle(cell);
                if (cell.getCellType() == CellType.BLANK) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                    vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u4ece\u4e8b\u653e\u5c04\u5de5\u4f5c\u8d77\u59cb\u65f6\u95f4\u89e3\u6790\u9519\u8bef;<br/>");
                    break;
                }
                vo.setRadiationYear(cell.getDateCellValue());
                break;
            }
            case 20: {
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (!StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                }
                vo.setRadiationTypeName(cell.getStringCellValue().trim());
                String[] strs = vo.getRadiationTypeName().split(" ");
                SysParamModel sysParam = this.sysParamProvideService.getSysParamByNameGroupCode(strs[1], vo.getCid(), SysParamGroupEnum.occup_exposure_workingtype, strs[0]);
                if (sysParam == null) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                    vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u804c\u4e1a\u7167\u5c04\u804c\u4e1a\u5206\u7c7b\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728;<br/>");
                    break;
                }
                vo.setRadiationType(sysParam.getId());
                break;
            }
            case 21: {
                SysParamModel sysParam;
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (!StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                vo.setSpecialOperationsName(cell.getStringCellValue().trim());
                if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                }
                if ((sysParam = this.sysParamProvideService.getSysParamByName(vo.getSpecialOperationsName(), vo.getCid(), SysParamGroupEnum.spec_operation_type)) == null) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                    vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u7279\u79cd\u4f5c\u4e1a\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728;<br/>");
                    break;
                }
                vo.setSpecialOperations(sysParam.getId());
                break;
            }
            case 22: {
                SysParamModel sysParam;
                vo.getKeyValue().put("" + cellIndex, cell.getStringCellValue());
                if (!StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                vo.setSpecialWorkName(cell.getStringCellValue().trim());
                if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                }
                if ((sysParam = this.sysParamProvideService.getSysParamByName(vo.getSpecialWorkName(), vo.getCid(), SysParamGroupEnum.spec_working_type)) == null) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                    vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u7279\u6b8a\u4f5c\u4e1a\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728;<br/>");
                    break;
                }
                vo.setSpecialWork(sysParam.getId());
            }
        }
    }

    private int getDeptCount(CompanyOrganization organization, Map<Long, CompanyOrganization> map, List<String> orgNameList) {
        CompanyOrganization parent = null;
        if (organization.getPid() == null) {
            if (orgNameList.contains(organization.getOrganizationName())) {
                return 1;
            }
        } else {
            parent = map.get(organization.getPid());
            if (parent != null && orgNameList.contains(parent.getOrganizationName())) {
                return 1 + this.getDeptCount(parent, map, orgNameList);
            }
        }
        return 0;
    }

    @Transactional(readOnly=false)
    public void formatEveryExcelCellforSelfZJ(Row row, Cell cell, int cellIndex, int rowIndex, StaffInfoExcelImportVo vo, Map<String, CompanyOrganization> needAddOrg, Map<String, WorkRoleInfo> needAddworkList, List<String> workAndDeptNames, List<CompanyOrganization> organizationList) {
        switch (cellIndex) {
            case 0: {
                vo.getStaffInfo().setIsThirdParty(Global.FALSE);
                vo.getCurrentStaffWorkRole().setIsHistory(Global.FALSE);
                vo.getCurrentStaffWorkRole().setWorkProperty(StaffWorkPropertyEnum.MAJOR.getValue());
                vo.getCurrentStaffWorkRole().setIsThirdParty(Global.FALSE);
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    vo.setRealName(cell.getStringCellValue().trim());
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    vo.getStaffBasicInfo().setRealName(vo.getRealName());
                    break;
                }
                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u59d3\u540d\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                break;
            }
            case 1: {
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    vo.setCardNo(cell.getStringCellValue().trim());
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    if (vo.getCardNo().length() != 18 && vo.getCardNo().length() != 15) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u8eab\u4efd\u8bc1\u53f7\u683c\u5f0f\u4e0d\u5bf9;<br/>");
                    } else {
                        Object birth = "19000101";
                        if (vo.getCardNo().length() == 15) {
                            birth = "19" + vo.getCardNo().substring(6, 12);
                            if (Integer.parseInt(vo.getCardNo().substring(14, 15)) % 2 == 0) {
                                vo.setGender(Byte.valueOf(StaffGenderEnum.FEMALE.getValue().byteValue()));
                            } else {
                                vo.setGender(Byte.valueOf(StaffGenderEnum.MALE.getValue().byteValue()));
                            }
                        } else {
                            birth = vo.getCardNo().substring(6, 14);
                            if (Integer.parseInt(vo.getCardNo().substring(16).substring(0, 1)) % 2 == 0) {
                                vo.setGender(Byte.valueOf(StaffGenderEnum.FEMALE.getValue().byteValue()));
                            } else {
                                vo.setGender(Byte.valueOf(StaffGenderEnum.MALE.getValue().byteValue()));
                            }
                        }
                        try {
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
                            vo.setBirthDay(sdf.parse((String)birth));
                            sdf = new SimpleDateFormat("yyyy");
                            vo.setAge(Integer.valueOf(Integer.parseInt(sdf.format(new Date())) - Integer.parseInt(((String)birth).substring(0, 4))));
                        }
                        catch (Exception e3) {
                            vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u8eab\u4efd\u8bc1\u53f7\u89e3\u6790\u8be5\u4eba\u7684\u51fa\u751f\u65e5\u671f\u9519\u8bef;<br/>");
                        }
                    }
                    vo.getStaffBasicInfo().setIdCard(vo.getCardNo());
                    vo.getStaffBasicInfo().setAge(vo.getAge());
                    vo.getStaffBasicInfo().setBirthday(vo.getBirthDay());
                    vo.getStaffBasicInfo().setGender(vo.getGender());
                    break;
                }
                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ",\u8eab\u4efd\u8bc1\u53f7\u4e3a\u5fc5\u586b\u9879\u4e0d\u53ef\u4e3a\u7a7a;<br/>");
                break;
            }
            case 2: {
                if (cell != null && cell.getCellType() != CellType.BLANK) {
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    StaffInfoImportServiceImpl.dateHandle(cell);
                    if (cell.getCellType() == CellType.BLANK) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u9996\u6b21\u4e0a\u5c97\u65f6\u95f4\u89e3\u6790\u9519\u8bef;<br/>");
                        break;
                    }
                    vo.getCurrentStaffWorkRole().setFirstBeginTime(cell.getDateCellValue());
                    break;
                }
                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u9996\u6b21\u4e0a\u5c97\u65f6\u95f4\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                break;
            }
            case 3: {
                if (cell != null && cell.getCellType() != CellType.BLANK) {
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    StaffInfoImportServiceImpl.dateHandle(cell);
                    if (cell.getCellType() == CellType.BLANK) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u4e0a\u5c97\u65f6\u95f4\u89e3\u6790\u9519\u8bef;<br/>");
                        break;
                    }
                    Cell lastCell = null;
                    lastCell = row.getCell(cellIndex - 1);
                    if (lastCell == null || lastCell.getCellType() == CellType.BLANK) break;
                    StaffInfoImportServiceImpl.dateHandle(lastCell);
                    if (lastCell.getCellType() == CellType.BLANK) break;
                    if (cell.getDateCellValue().before(lastCell.getDateCellValue())) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u672c\u5c97\u4f4d\u4e0a\u5c97\u65f6\u95f4\u4e0d\u5f97\u65e9\u4e8e\u9996\u6b21\u4e0a\u5c97\u65f6\u95f4;<br/>");
                        break;
                    }
                    vo.getCurrentStaffWorkRole().setBeginTime(cell.getDateCellValue());
                    break;
                }
                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u4e0a\u5c97\u65f6\u95f4\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                break;
            }
            case 4: {
                if (!StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                }
                String workName = cell.getStringCellValue();
                List<String> orgNameList = Arrays.stream(workName.split(">")).collect(Collectors.toList());
                ArrayList<CompanyOrganization> nameList = new ArrayList<CompanyOrganization>();
                organizationList.removeAll(Collections.singleton(null));
                Map<Long, CompanyOrganization> organizationMap = null;
                if (CollectionUtils.isNotEmpty(organizationList)) {
                    organizationMap = organizationList.stream().collect(Collectors.toMap(CompanyOrganization::getId, Function.identity(), (e1, e2) -> e2));
                    for (CompanyOrganization organization : organizationList) {
                        if (!orgNameList.contains(organization.getOrganizationName())) continue;
                        nameList.add(organization);
                    }
                }
                CompanyOrganization dept = null;
                if (CollectionUtils.isNotEmpty(nameList) && nameList.size() >= orgNameList.size()) {
                    List parentList = nameList.stream().filter(e -> e.getPid() == null).collect(Collectors.toList());
                    if (nameList.size() == 1 || nameList.size() == parentList.size()) {
                        dept = (CompanyOrganization)nameList.get(0);
                    } else if (orgNameList.size() == 1) {
                        dept = (CompanyOrganization)parentList.get(0);
                    } else {
                        for (CompanyOrganization organization : organizationList) {
                            int deptCount = this.getDeptCount(organization, organizationMap, orgNameList);
                            if (deptCount != orgNameList.size()) continue;
                            dept = organization;
                            break;
                        }
                    }
                    if (dept != null) {
                        vo.setDeptId(dept.getId());
                        vo.setDeptName(dept.getOrganizationName());
                        break;
                    }
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                    vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u90e8\u95e8/\u8f66\u95f4\u4e0d\u5b58\u5728;<br/>");
                    break;
                }
                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u90e8\u95e8/\u8f66\u95f4\u4e0d\u5b58\u5728;<br/>");
                break;
            }
            case 5: {
                if (!StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                String workName = cell.getStringCellValue();
                if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                }
                vo.getStaffBasicInfo().setJobName(workName);
                break;
            }
            case 6: {
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    vo.setWorkStateName(cell.getStringCellValue().trim());
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    if (StaffWorkStatusEnum.ONWORKING.getName().equals(vo.getWorkStateName())) {
                        vo.setWorkState(StaffWorkStatusEnum.ONWORKING.getValue());
                    } else if (StaffWorkStatusEnum.NOWORKED.getName().equals(vo.getWorkStateName())) {
                        vo.setWorkState(StaffWorkStatusEnum.NOWORKED.getValue());
                    } else if (StaffWorkStatusEnum.FURLOUGH.getName().equals(vo.getWorkStateName())) {
                        vo.setWorkState(StaffWorkStatusEnum.FURLOUGH.getValue());
                    }
                    vo.getCurrentStaffWorkRole().setStatus(vo.getWorkState());
                    break;
                }
                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u5c97\u4f4d\u72b6\u6001\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                break;
            }
            case 7: {
                if (row.getCell(cellIndex - 1) == null || row.getCell(cellIndex - 1).getCellType() == CellType.BLANK) break;
                String workState = row.getCell(cellIndex - 1).getStringCellValue();
                if (cell != null && cell.getCellType() != CellType.BLANK) {
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    StaffInfoImportServiceImpl.dateHandle(cell);
                    if (cell.getCellType() == CellType.BLANK) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u79bb\u804c\u65f6\u95f4\u89e3\u6790\u9519\u8bef;<br/>");
                        break;
                    }
                    vo.getCurrentStaffWorkRole().setLeaveTime(cell.getDateCellValue());
                    break;
                }
                if (!StringUtils.isNotBlank((CharSequence)workState) || !StaffWorkStatusEnum.NOWORKED.getName().equals(workState)) break;
                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u5f53\u5c97\u4f4d\u72b6\u6001\u4e3a\u79bb\u5c97\u65f6\uff0c\u79bb\u804c\u65f6\u95f4\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                break;
            }
            case 8: {
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    vo.setIsRadiationName(cell.getStringCellValue().trim());
                    if (vo.getIsRadiationName().equals("\u662f")) {
                        vo.getStaffBasicWork().setIsRadiation(Boolean.valueOf(true));
                        break;
                    }
                    if (vo.getIsRadiationName().equals("\u5426")) {
                        vo.getStaffBasicWork().setIsRadiation(Boolean.valueOf(false));
                        break;
                    }
                    vo.getStaffBasicWork().setIsRadiation(Boolean.valueOf(false));
                    break;
                }
                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u662f\u5426\u653e\u5c04\u5de5\u4f5c\u4eba\u5458\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                break;
            }
            case 9: {
                String mobile;
                if (!StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                }
                if (CommonUtil.checkMobile((String)(mobile = cell.getStringCellValue().trim()))) {
                    vo.setMobile(mobile);
                    vo.getStaffBasicInfo().setMobile(mobile);
                    break;
                }
                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u624b\u673a\u53f7\u683c\u5f0f\u9519\u8bef;<br/>");
                break;
            }
            case 10: {
                if (!StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                }
                vo.setNativePlace(cell.getStringCellValue().trim());
                vo.getStaffBasicInfo().setNativePlace(vo.getNativePlace());
                break;
            }
            case 11: {
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    vo.setHobby(cell.getStringCellValue().trim());
                    vo.getStaffBasicInfo().setHabitSmoke(vo.getHobby());
                    break;
                }
                vo.getStaffBasicInfo().setHabitSmoke("");
                break;
            }
            case 12: {
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    vo.setWorkNo(cell.getStringCellValue().trim());
                    vo.getStaffBasicWork().setWorkNo(vo.getWorkNo());
                    break;
                }
                vo.getStaffBasicWork().setWorkNo(" ");
                break;
            }
            case 13: {
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    vo.setNation(cell.getStringCellValue().trim());
                    vo.getStaffBasicInfo().setNation(vo.getNation());
                    break;
                }
                vo.getStaffBasicInfo().setNation(" ");
                break;
            }
        }
    }

    private Date getDateFromCell(Cell cell) {
        if (cell != null) {
            if (Objects.equals(cell.getCellType(), CellType.NUMERIC)) {
                return cell.getDateCellValue();
            }
            String stringCellValue = cell.getStringCellValue();
            return DateUtils.parseDate((Object)stringCellValue);
        }
        return null;
    }

    @Transactional(readOnly=false)
    public void formatEveryExcelCellforThirdZJ(Row row, Cell cell, int cellIndex, int rowIndex, StaffInfoExcelImportVo vo, Map<String, CompanyOrganization> needAddOrg, Map<String, WorkRoleInfo> needAddworkList, List<String> workAndDeptNames, List<CompanyOrganization> organizationList) {
        switch (cellIndex) {
            case 0: {
                vo.setErrorReason("");
                vo.getStaffInfo().setIsThirdParty(Global.TRUE);
                vo.getCurrentStaffWorkRole().setIsHistory(Global.FALSE);
                vo.getCurrentStaffWorkRole().setWorkProperty(StaffWorkPropertyEnum.MAJOR.getValue());
                vo.getCurrentStaffWorkRole().setIsThirdParty(Global.FALSE);
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    vo.setThirdCompanyName(cell.getStringCellValue().trim());
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    vo.getStaffInfo().setOtherCompany(vo.getThirdCompanyName());
                    break;
                }
                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u5916\u534f\u4f01\u4e1a\u540d\u79f0\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                break;
            }
            case 1: {
                if (!StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                }
                Byte outsource = null;
                if ("\u52b3\u52a1\u6d3e\u9063".equals(cell.getStringCellValue().trim())) {
                    outsource = 1;
                } else if ("\u52b3\u52a1\u5916\u5305".equals(cell.getStringCellValue().trim())) {
                    outsource = 2;
                } else if ("\u5176\u4ed6".equals(cell.getStringCellValue().trim())) {
                    outsource = 3;
                }
                vo.setOutsource(outsource);
                vo.getStaffInfo().setOutsource(outsource);
                break;
            }
            case 2: {
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    vo.setRealName(cell.getStringCellValue().trim());
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    vo.getStaffBasicInfo().setRealName(vo.getRealName());
                    break;
                }
                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u59d3\u540d\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                break;
            }
            case 3: {
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    vo.setCardNo(cell.getStringCellValue().trim());
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    if (vo.getCardNo().length() != 18 && vo.getCardNo().length() != 15) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u8eab\u4efd\u8bc1\u53f7\u683c\u5f0f\u4e0d\u5bf9;<br/>");
                        break;
                    }
                    Object birth = "19000101";
                    if (vo.getCardNo().length() == 15) {
                        birth = "19" + vo.getCardNo().substring(6, 12);
                        if (Integer.parseInt(vo.getCardNo().substring(14, 15)) % 2 == 0) {
                            vo.setGender(Byte.valueOf(StaffGenderEnum.FEMALE.getValue().byteValue()));
                        } else {
                            vo.setGender(Byte.valueOf(StaffGenderEnum.MALE.getValue().byteValue()));
                        }
                    } else {
                        birth = vo.getCardNo().substring(6, 14);
                        if (Integer.parseInt(vo.getCardNo().substring(16).substring(0, 1)) % 2 == 0) {
                            vo.setGender(Byte.valueOf(StaffGenderEnum.FEMALE.getValue().byteValue()));
                        } else {
                            vo.setGender(Byte.valueOf(StaffGenderEnum.MALE.getValue().byteValue()));
                        }
                    }
                    try {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
                        vo.setBirthDay(sdf.parse((String)birth));
                        sdf = new SimpleDateFormat("yyyy");
                        vo.setAge(Integer.valueOf(Integer.parseInt(sdf.format(new Date())) - Integer.parseInt(((String)birth).substring(0, 4))));
                    }
                    catch (Exception e3) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u8eab\u4efd\u8bc1\u53f7\u89e3\u6790\u8be5\u4eba\u7684\u51fa\u751f\u65e5\u671f\u9519\u8bef;<br/>");
                    }
                    vo.getStaffBasicInfo().setIdCard(vo.getCardNo());
                    vo.getStaffBasicInfo().setAge(vo.getAge());
                    vo.getStaffBasicInfo().setBirthday(vo.getBirthDay());
                    vo.getStaffBasicInfo().setGender(vo.getGender());
                    break;
                }
                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ",\u8eab\u4efd\u8bc1\u53f7\u8bf7\u4e3a\u5fc5\u586b\u9879\u4e0d\u53ef\u4e3a\u7a7a;<br/>");
                break;
            }
            case 4: {
                if (cell != null && cell.getCellType() != CellType.BLANK) {
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    StaffInfoImportServiceImpl.dateHandle(cell);
                    if (cell.getCellType() == CellType.BLANK) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u9996\u6b21\u4e0a\u5c97\u65f6\u95f4\u89e3\u6790\u9519\u8bef;<br/>");
                        break;
                    }
                    vo.getCurrentStaffWorkRole().setFirstBeginTime(cell.getDateCellValue());
                    break;
                }
                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u9996\u6b21\u4e0a\u5c97\u65f6\u95f4\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                break;
            }
            case 5: {
                if (cell != null && cell.getCellType() != CellType.BLANK) {
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    StaffInfoImportServiceImpl.dateHandle(cell);
                    if (cell.getCellType() == CellType.BLANK) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u4e0a\u5c97\u65f6\u95f4\u89e3\u6790\u9519\u8bef;<br/>");
                        break;
                    }
                    Cell lastCell = null;
                    lastCell = row.getCell(cellIndex - 1);
                    if (lastCell == null || lastCell.getCellType() == CellType.BLANK) break;
                    StaffInfoImportServiceImpl.dateHandle(lastCell);
                    if (lastCell.getCellType() == CellType.BLANK) break;
                    if (cell.getDateCellValue().before(lastCell.getDateCellValue())) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u672c\u5c97\u4f4d\u4e0a\u5c97\u65f6\u95f4\u4e0d\u5f97\u65e9\u4e8e\u9996\u6b21\u4e0a\u5c97\u65f6\u95f4;<br/>");
                        break;
                    }
                    vo.getCurrentStaffWorkRole().setBeginTime(cell.getDateCellValue());
                    break;
                }
                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u4e0a\u5c97\u65f6\u95f4\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                break;
            }
            case 6: {
                if (!StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                }
                String workName = cell.getStringCellValue();
                List<String> orgNameList = Arrays.stream(workName.split(">")).collect(Collectors.toList());
                ArrayList<CompanyOrganization> nameList = new ArrayList<CompanyOrganization>();
                organizationList.removeAll(Collections.singleton(null));
                Map<Long, CompanyOrganization> organizationMap = null;
                if (CollectionUtils.isNotEmpty(organizationList)) {
                    organizationMap = organizationList.stream().collect(Collectors.toMap(CompanyOrganization::getId, Function.identity(), (e1, e2) -> e2));
                    for (CompanyOrganization organization : organizationList) {
                        if (!orgNameList.contains(organization.getOrganizationName())) continue;
                        nameList.add(organization);
                    }
                }
                CompanyOrganization dept = null;
                if (CollectionUtils.isNotEmpty(nameList) && nameList.size() >= orgNameList.size()) {
                    List parentList = nameList.stream().filter(e -> e.getPid() == null).collect(Collectors.toList());
                    if (nameList.size() == 1 || nameList.size() == parentList.size()) {
                        dept = (CompanyOrganization)nameList.get(0);
                    } else if (orgNameList.size() == 1) {
                        dept = (CompanyOrganization)parentList.get(0);
                    } else {
                        for (CompanyOrganization organization : organizationList) {
                            int deptCount = this.getDeptCount(organization, organizationMap, orgNameList);
                            if (deptCount != orgNameList.size()) continue;
                            dept = organization;
                            break;
                        }
                    }
                    if (dept != null) {
                        vo.setDeptId(dept.getId());
                        vo.setDeptName(dept.getOrganizationName());
                        break;
                    }
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                    vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u90e8\u95e8/\u8f66\u95f4\u4e0d\u5b58\u5728;<br/>");
                    break;
                }
                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u90e8\u95e8/\u8f66\u95f4\u4e0d\u5b58\u5728;<br/>");
                break;
            }
            case 7: {
                if (!StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                String workName = cell.getStringCellValue();
                if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                }
                vo.getStaffBasicInfo().setJobName(workName);
                break;
            }
            case 8: {
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    vo.setWorkStateName(cell.getStringCellValue().trim());
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    if (StaffWorkStatusEnum.ONWORKING.getName().equals(vo.getWorkStateName())) {
                        vo.setWorkState(StaffWorkStatusEnum.ONWORKING.getValue());
                    } else if (StaffWorkStatusEnum.NOWORKED.getName().equals(vo.getWorkStateName())) {
                        vo.setWorkState(StaffWorkStatusEnum.NOWORKED.getValue());
                    } else if (StaffWorkStatusEnum.FURLOUGH.getName().equals(vo.getWorkStateName())) {
                        vo.setWorkState(StaffWorkStatusEnum.FURLOUGH.getValue());
                    }
                    vo.getCurrentStaffWorkRole().setStatus(vo.getWorkState());
                    break;
                }
                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u5c97\u4f4d\u72b6\u6001\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                break;
            }
            case 9: {
                if (row.getCell(cellIndex - 1) == null || row.getCell(cellIndex - 1).getCellType() == CellType.BLANK) break;
                String workState = row.getCell(cellIndex - 1).getStringCellValue();
                if (cell != null && cell.getCellType() != CellType.BLANK) {
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    StaffInfoImportServiceImpl.dateHandle(cell);
                    if (cell.getCellType() == CellType.BLANK) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u79bb\u804c\u65f6\u95f4\u89e3\u6790\u9519\u8bef;<br/>");
                        break;
                    }
                    vo.getCurrentStaffWorkRole().setLeaveTime(cell.getDateCellValue());
                    break;
                }
                if (!StringUtils.isNotBlank((CharSequence)workState) || !StaffWorkStatusEnum.NOWORKED.getName().equals(workState)) break;
                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u5f53\u5c97\u4f4d\u72b6\u6001\u4e3a\u79bb\u5c97\u65f6\uff0c\u79bb\u804c\u65f6\u95f4\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                break;
            }
            case 10: {
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    vo.setIsRadiationName(cell.getStringCellValue().trim());
                    if (vo.getIsRadiationName().equals("\u662f")) {
                        vo.getStaffBasicWork().setIsRadiation(Boolean.valueOf(true));
                        break;
                    }
                    if (vo.getIsRadiationName().equals("\u5426")) {
                        vo.getStaffBasicWork().setIsRadiation(Boolean.valueOf(false));
                        break;
                    }
                    vo.getStaffBasicWork().setIsRadiation(Boolean.valueOf(false));
                    break;
                }
                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u662f\u5426\u653e\u5c04\u5de5\u4f5c\u4eba\u5458\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                break;
            }
            case 11: {
                String mobile;
                if (!StringUtils.isNotEmpty((String)cell.getStringCellValue())) break;
                if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                    vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                }
                if (CommonUtil.checkMobile((String)(mobile = cell.getStringCellValue().trim()))) {
                    vo.setMobile(mobile);
                    vo.getStaffBasicInfo().setMobile(mobile);
                    break;
                }
                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.error.getValue()));
                vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(cellIndex + 1) + ", \u624b\u673a\u53f7\u683c\u5f0f\u9519\u8bef;<br/>");
                break;
            }
            case 12: {
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    vo.setNativePlace(cell.getStringCellValue().trim());
                    vo.getStaffBasicInfo().setNativePlace(vo.getNativePlace());
                    break;
                }
                if (!StringUtils.isEmpty((CharSequence)vo.getStaffBasicInfo().getNativePlace())) break;
                vo.getStaffBasicInfo().setNativePlace(" ");
                break;
            }
            case 13: {
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    vo.setHobby(cell.getStringCellValue().trim());
                    vo.getStaffBasicInfo().setHabitSmoke(vo.getHobby());
                    break;
                }
                vo.getStaffBasicInfo().setHabitSmoke("");
                break;
            }
            case 14: {
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    vo.setWorkNo(cell.getStringCellValue().trim());
                    vo.getStaffBasicWork().setWorkNo(vo.getWorkNo());
                    break;
                }
                vo.getStaffBasicWork().setWorkNo(" ");
                vo.setWorkNo(" ");
                break;
            }
            case 15: {
                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                    if (vo.getDataState() == null || vo.getDataState().byteValue() == StaffInfoImportStateEnum.normal.getValue()) {
                        vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.normal.getValue()));
                    }
                    vo.setNation(cell.getStringCellValue().trim());
                    vo.getStaffBasicInfo().setNation(vo.getNation());
                    break;
                }
                vo.getStaffBasicInfo().setNation(" ");
            }
        }
    }

    private List<WorkRoleInfo> getWorkList(Map<String, WorkRoleInfo> needAddworkList) {
        ArrayList<WorkRoleInfo> workList = new ArrayList<WorkRoleInfo>();
        for (String key : needAddworkList.keySet()) {
            workList.add(needAddworkList.get(key));
        }
        return workList;
    }

    private List<CompanyOrganization> getOrgList(Map<String, CompanyOrganization> needAddOrg) {
        ArrayList<CompanyOrganization> orglist = new ArrayList<CompanyOrganization>();
        for (String key : needAddOrg.keySet()) {
            orglist.add(needAddOrg.get(key));
        }
        return orglist;
    }

    @Transactional(readOnly=false)
    public List<StaffInfoExcelImportVo> importStaffDataFromExcel(List<StaffInfoExcelImportVo> list, Long loginStaffId, Long cid) {
        ArrayList<StaffInfoExcelImportVo> existData = new ArrayList<StaffInfoExcelImportVo>();
        if (CollectionUtils.isEmpty(list)) {
            return existData;
        }
        List idCardList = list.stream().map(e -> e.getStaffBasicInfo().getIdCard()).filter(Objects::nonNull).collect(Collectors.toList());
        List importVoList = this.staffBasicInfoService.getByCidAndIdCard(cid, idCardList);
        Map importVoMap = null;
        if (CollectionUtils.isNotEmpty((Collection)importVoList)) {
            importVoMap = importVoList.stream().collect(Collectors.toMap(StaffInfoExcelImportVo::getCardNo, Function.identity()));
        }
        ArrayList<StaffInfo> addStaffInfoList = new ArrayList<StaffInfo>();
        ArrayList<StaffBasicInfo> addStaffBasicInfoList = new ArrayList<StaffBasicInfo>();
        ArrayList<StaffBasicWork> addStaffBasicWorkList = new ArrayList<StaffBasicWork>();
        ArrayList<StaffWorkRole> addStaffWorkRoleList = new ArrayList<StaffWorkRole>();
        Date date = new Date();
        for (StaffInfoExcelImportVo vo : list) {
            if (vo.getCid() != null) {
                cid = vo.getCid();
            }
            StaffInfo staffInfo = vo.getStaffInfo();
            StaffBasicInfo staffBasicInfo = vo.getStaffBasicInfo();
            StaffBasicWork staffBasicWork = vo.getStaffBasicWork();
            StaffWorkRole currentStaffWorkRole = vo.getCurrentStaffWorkRole();
            staffBasicWork.setWorkNo(vo.getWorkNo());
            staffBasicWork.setOrgId(vo.getDeptId());
            if (vo.getDataState() == null || vo.getDataState().byteValue() != StaffInfoImportStateEnum.normal.getValue()) continue;
            StaffInfoExcelImportVo importVo = null;
            if (importVoMap != null && (importVo = (StaffInfoExcelImportVo)importVoMap.get(staffBasicInfo.getIdCard())) != null) {
                vo.setDataState(Byte.valueOf(StaffInfoImportStateEnum.exist.getValue()));
                staffBasicInfo.setId(importVo.getStaffBasicId());
                staffInfo.setId(importVo.getStaffInfoId());
                staffBasicWork.setId(importVo.getStaffBasicWorkId());
                currentStaffWorkRole.setId(importVo.getStaffWorkRoleId());
                existData.add(vo);
                continue;
            }
            staffBasicInfo.setId(Long.valueOf(this.idworker.nextId()));
            staffBasicInfo.setCid(cid);
            staffBasicInfo.setCreateBy(loginStaffId);
            staffBasicInfo.setCreateDate(date);
            staffBasicInfo.setIsValid(Boolean.valueOf(true));
            addStaffBasicInfoList.add(staffBasicInfo);
            if (staffBasicWork.getOrgId() != null) {
                staffInfo.setOrgId(staffBasicWork.getOrgId());
            }
            staffInfo.setStaffBasicId(staffBasicInfo.getId());
            staffInfo.setId(Long.valueOf(this.idworker.nextId()));
            staffInfo.setCid(cid);
            staffInfo.setCreateBy(loginStaffId);
            staffInfo.setCreateDate(date);
            staffInfo.setIsValid(Boolean.valueOf(true));
            addStaffInfoList.add(staffInfo);
            staffBasicWork.setStaffId(staffInfo.getId());
            staffBasicWork.setId(Long.valueOf(this.idworker.nextId()));
            staffBasicWork.setCid(cid);
            staffBasicWork.setCreateBy(loginStaffId);
            staffBasicWork.setCreateDate(date);
            staffBasicWork.setIsValid(Boolean.valueOf(true));
            addStaffBasicWorkList.add(staffBasicWork);
            currentStaffWorkRole.setStaffId(staffInfo.getId());
            currentStaffWorkRole.setIsHistory(Boolean.valueOf(false));
            currentStaffWorkRole.setIsThirdParty(Boolean.valueOf(false));
            currentStaffWorkRole.setWorkProperty(StaffWorkPropertyEnum.MAJOR.getValue());
            currentStaffWorkRole.setId(Long.valueOf(this.idworker.nextId()));
            currentStaffWorkRole.setCid(cid);
            currentStaffWorkRole.setCreateBy(loginStaffId);
            currentStaffWorkRole.setCreateDate(date);
            currentStaffWorkRole.setIsValid(Boolean.valueOf(true));
            addStaffWorkRoleList.add(currentStaffWorkRole);
            if (currentStaffWorkRole.getStatus() == StaffWorkStatusEnum.ONWORKING.getValue()) {
                this.createNoInformStaff(currentStaffWorkRole, NoInformStaffChangeWorkStatusEnum.ONWORKING, staffInfo.getCreateBy(), staffInfo.getCid());
            }
            StaffWorkRole curHistoryStaffWorkRole = new StaffWorkRole();
            curHistoryStaffWorkRole.setCid(cid);
            curHistoryStaffWorkRole.setBeginTime(currentStaffWorkRole.getBeginTime());
            curHistoryStaffWorkRole.setIsHistory(Boolean.valueOf(true));
            curHistoryStaffWorkRole.setIsThirdParty(currentStaffWorkRole.getIsThirdParty());
            curHistoryStaffWorkRole.setLeaveTime(currentStaffWorkRole.getLeaveTime());
            curHistoryStaffWorkRole.setStaffId(currentStaffWorkRole.getStaffId());
            curHistoryStaffWorkRole.setStatus(currentStaffWorkRole.getStatus());
            curHistoryStaffWorkRole.setWorkProperty(StaffWorkPropertyEnum.WORKED.getValue());
            curHistoryStaffWorkRole.setId(Long.valueOf(this.idworker.nextId()));
            curHistoryStaffWorkRole.setCreateBy(loginStaffId);
            curHistoryStaffWorkRole.setCreateDate(date);
            curHistoryStaffWorkRole.setIsValid(Boolean.valueOf(true));
            addStaffWorkRoleList.add(curHistoryStaffWorkRole);
        }
        if (addStaffInfoList.size() > 0) {
            this.staffInfoService.batchUpdateOrInsert(addStaffInfoList, StaffInfoMapper.class, (e, mapper) -> mapper.insertSelective(e));
        }
        if (addStaffBasicInfoList.size() > 0) {
            this.staffBasicInfoService.batchUpdateOrInsert(addStaffBasicInfoList, StaffBasicInfoMapper.class, (e, mapper) -> mapper.insertSelective(e));
        }
        if (addStaffBasicWorkList.size() > 0) {
            this.staffBasicWorkService.batchUpdateOrInsert(addStaffBasicWorkList, StaffBasicWorkMapper.class, (e, mapper) -> mapper.insertSelective(e));
        }
        if (addStaffWorkRoleList.size() > 0) {
            this.staffWorkRoleService.batchUpdateOrInsert(addStaffWorkRoleList, StaffWorkRoleMapper.class, (e, mapper) -> mapper.insertSelective(e));
        }
        return existData;
    }

    @Transactional(readOnly=false)
    public List<StaffInfoExcelImportVo> coverUpdateStaffDataFromExcel(List<StaffInfoExcelImportVo> existData, Long loginStaffId) {
        ArrayList<StaffInfoExcelImportVo> updatedSheetDatas = new ArrayList<StaffInfoExcelImportVo>();
        List dbStaffInfoList = this.staffInfoService.getStaffInfoByIdList(existData.stream().map(e -> e.getStaffInfo().getId()).collect(Collectors.toList()));
        Map map = dbStaffInfoList.stream().collect(Collectors.toMap(StaffInfoExcelImportVo::getStaffInfoId, Function.identity(), (e1, e2) -> e2));
        ArrayList<StaffInfo> updateStaffInfoList = new ArrayList<StaffInfo>();
        ArrayList<StaffBasicInfo> updateStaffBasicInfoList = new ArrayList<StaffBasicInfo>();
        ArrayList<StaffBasicWork> updateStaffBasicWorkList = new ArrayList<StaffBasicWork>();
        ArrayList<StaffWorkRole> updateStaffWorkRoleList = new ArrayList<StaffWorkRole>();
        ArrayList<WorkNatureInfo> addWorkNatureInfoList = new ArrayList<WorkNatureInfo>();
        Date date = new Date();
        ArrayList logList = new ArrayList();
        for (StaffInfoExcelImportVo v : existData) {
            WorkNatureInfo radiationWork;
            Long staffInfoId = v.getStaffInfo().getId();
            boolean updateFlag = false;
            StaffBasicWork staffBasicWork = v.getStaffBasicWork();
            StaffBasicWork staffBasicWorkFromDB = ((StaffInfoExcelImportVo)map.get(staffInfoId)).getStaffBasicWork();
            StaffWorkRole currentStaffWorkRole = v.getCurrentStaffWorkRole();
            StaffWorkRole currentStaffWorkRoleDB = ((StaffInfoExcelImportVo)map.get(staffInfoId)).getCurrentStaffWorkRole();
            StaffInfo staffInfo = v.getStaffInfo();
            StaffInfo staffInfoFromDB = ((StaffInfoExcelImportVo)map.get(staffInfoId)).getStaffInfo();
            StaffBasicInfo staffBasicInfo = v.getStaffBasicInfo();
            StaffBasicInfo staffBasicInfoFromDB = ((StaffInfoExcelImportVo)map.get(staffInfoId)).getStaffBasicInfo();
            Long cid = ((StaffInfoExcelImportVo)dbStaffInfoList.get(0)).getCid();
            List staffFieldChangeLogList = this.staffInfoService.addStaffChangeLogList(staffInfo.getId(), cid, currentStaffWorkRoleDB, currentStaffWorkRole, staffBasicWorkFromDB, staffBasicWork, staffBasicInfoFromDB.getJobName(), v.getStaffBasicInfo().getJobName(), loginStaffId);
            logList.addAll(staffFieldChangeLogList);
            StaffInfo staffInfoNew = new StaffInfo();
            staffInfoNew.setId(staffInfo.getId());
            if (staffInfo.getOtherCompany() != null && !staffInfo.getOtherCompany().equals(staffInfoFromDB.getOtherCompany())) {
                staffInfoNew.setOtherCompany(staffInfo.getOtherCompany());
            }
            if (staffInfo.getOutsource() == null) {
                staffInfoNew.setOutsource(Byte.valueOf((byte)0));
            } else if (!staffInfo.getOutsource().equals(staffInfoFromDB.getOutsource())) {
                staffInfoNew.setOutsource(staffInfo.getOutsource());
            }
            StaffBasicWork staffBasicWorkNew = new StaffBasicWork();
            staffBasicWorkNew.setId(staffBasicWork.getId());
            if (staffBasicWork.getWorkNo() != null && !staffBasicWork.getWorkNo().equals(staffBasicWorkFromDB.getWorkNo())) {
                staffBasicWorkNew.setWorkNo(staffBasicWork.getWorkNo());
            }
            StaffBasicInfo staffBasicInfoNew = new StaffBasicInfo();
            staffBasicInfoNew.setId(staffBasicInfo.getId());
            if (staffBasicInfo.getRealName() != null && !staffBasicInfo.getRealName().equals(staffBasicInfoFromDB.getRealName())) {
                staffBasicInfoNew.setRealName(staffBasicInfo.getRealName());
            }
            if (staffBasicWork.getOrgId() != null && !staffBasicWork.getOrgId().equals(staffBasicWorkFromDB.getOrgId())) {
                staffBasicWorkNew.setOrgId(staffBasicWork.getOrgId());
                staffInfoNew.setOrgId(staffBasicWork.getOrgId());
            }
            staffInfoNew.setIsThirdParty(v.getIsThirdCompany());
            StaffWorkRole staffWorkRoleNew = new StaffWorkRole();
            staffWorkRoleNew.setId(currentStaffWorkRole.getId());
            if (staffBasicInfo.getGender() != null) {
                staffBasicInfoNew.setGender(staffBasicInfo.getGender());
            }
            if (staffBasicInfo.getMobile() != null && !staffBasicInfo.getMobile().equals(staffBasicInfoFromDB.getMobile())) {
                staffBasicInfoNew.setMobile(staffBasicInfo.getMobile());
            }
            if (currentStaffWorkRole.getStatus() != null && !currentStaffWorkRole.getStatus().equals(currentStaffWorkRoleDB.getStatus())) {
                staffWorkRoleNew.setStatus(currentStaffWorkRole.getStatus());
            }
            if (currentStaffWorkRole.getBeginTime() != null) {
                staffWorkRoleNew.setBeginTime(currentStaffWorkRole.getBeginTime());
            }
            if (currentStaffWorkRole.getLeaveTime() != null) {
                staffWorkRoleNew.setLeaveTime(currentStaffWorkRole.getLeaveTime());
            }
            if (currentStaffWorkRole.getBeginTime() != null) {
                staffWorkRoleNew.setFirstBeginTime(currentStaffWorkRole.getFirstBeginTime());
            }
            if (staffBasicWork.getIsRadiation() != null) {
                staffBasicWorkNew.setIsRadiation(staffBasicWork.getIsRadiation());
            } else {
                staffBasicWorkNew.setIsRadiation(Global.FALSE);
            }
            if (staffBasicWork.getJobTitle() != null) {
                staffBasicWorkNew.setJobTitle(staffBasicWork.getJobTitle());
            }
            if (staffBasicInfo.getNativePlace() != null) {
                staffBasicInfoNew.setNativePlace(staffBasicInfo.getNativePlace());
            }
            if (staffBasicInfo.getNation() != null) {
                staffBasicInfoNew.setNation(staffBasicInfo.getNation());
            }
            if (v.getMaritalStatus() != null) {
                staffBasicInfoNew.setMaritalStatus(v.getMaritalStatus());
            }
            if (staffBasicInfo.getEducation() != null) {
                staffBasicInfoNew.setEducation(staffBasicInfo.getEducation());
            }
            if (v.getMajor() != null) {
                staffBasicInfoNew.setMajor(v.getMajor());
            }
            if (staffBasicWork.getJoinTime() != null) {
                staffBasicWorkNew.setJoinTime(staffBasicWork.getJoinTime());
            }
            if (staffBasicWork.getWorkTime() != null) {
                staffBasicWorkNew.setWorkTime(staffBasicWork.getWorkTime());
            }
            if (staffBasicInfo.getHabitSmoke() != null) {
                staffBasicInfoNew.setHabitSmoke(staffBasicInfo.getHabitSmoke());
            }
            if (StringUtils.isNotEmpty((String)staffBasicInfo.getJobName()) && !staffBasicInfo.getJobName().equals(staffBasicInfoFromDB.getJobName())) {
                staffBasicInfoNew.setJobName(staffBasicInfo.getJobName());
            }
            if (staffInfoNew.getId() != null) {
                staffInfoNew.setUpdateBy(loginStaffId);
                staffInfoNew.setUpdateDate(date);
                updateStaffInfoList.add(staffInfoNew);
            }
            if (staffBasicInfoNew.getId() != null) {
                staffBasicInfoNew.setUpdateBy(loginStaffId);
                staffBasicInfoNew.setUpdateDate(date);
                updateStaffBasicInfoList.add(staffBasicInfoNew);
            }
            if (staffBasicWorkNew.getId() != null) {
                staffBasicWorkNew.setUpdateBy(loginStaffId);
                staffBasicWorkNew.setUpdateDate(date);
                updateStaffBasicWorkList.add(staffBasicWorkNew);
            }
            if (v.getIsRadiation() != null && v.getIsRadiation().booleanValue()) {
                radiationWork = new WorkNatureInfo();
                radiationWork.setIsWork(Boolean.valueOf(true));
                radiationWork.setIsDefault(Boolean.valueOf(false));
                if (v.getRadiationYear() != null) {
                    radiationWork.setWorkBeginTime(v.getRadiationYear());
                }
                radiationWork.setWorkType(v.getRadiationTypeName());
                radiationWork.setNature(Byte.valueOf(WorkNatureEnum.RadiationWork.getValue()));
                radiationWork.setNatureName(WorkNatureEnum.RadiationWork.getName());
                radiationWork.setStaffId(staffInfo.getId());
                radiationWork.setCid(staffInfoNew.getCid());
                radiationWork.setId(Long.valueOf(this.idworker.nextId()));
                radiationWork.setCreateBy(loginStaffId);
                radiationWork.setCreateDate(date);
                radiationWork.setIsValid(Boolean.valueOf(true));
                addWorkNatureInfoList.add(radiationWork);
            }
            if (v.getSpecialOperationsName() != null) {
                radiationWork = new WorkNatureInfo();
                radiationWork.setIsWork(Boolean.valueOf(true));
                radiationWork.setIsDefault(Boolean.valueOf(false));
                radiationWork.setWorkType(v.getSpecialOperationsName());
                radiationWork.setNature(Byte.valueOf(WorkNatureEnum.ParticularWork.getValue()));
                radiationWork.setNatureName(WorkNatureEnum.ParticularWork.getName());
                radiationWork.setStaffId(staffInfo.getId());
                radiationWork.setCid(cid);
                radiationWork.setId(Long.valueOf(this.idworker.nextId()));
                radiationWork.setCreateBy(loginStaffId);
                radiationWork.setCreateDate(date);
                radiationWork.setIsValid(Boolean.valueOf(true));
                addWorkNatureInfoList.add(radiationWork);
            }
            if (v.getSpecialWorkName() != null) {
                radiationWork = new WorkNatureInfo();
                radiationWork.setIsWork(Boolean.valueOf(true));
                radiationWork.setIsDefault(Boolean.valueOf(false));
                radiationWork.setWorkType(v.getSpecialWorkName());
                radiationWork.setNature(Byte.valueOf(WorkNatureEnum.SpecialWork.getValue()));
                radiationWork.setNatureName(WorkNatureEnum.SpecialWork.getName());
                radiationWork.setStaffId(staffInfo.getId());
                radiationWork.setCid(cid);
                radiationWork.setId(Long.valueOf(this.idworker.nextId()));
                radiationWork.setCreateBy(loginStaffId);
                radiationWork.setCreateDate(date);
                radiationWork.setIsValid(Boolean.valueOf(true));
                addWorkNatureInfoList.add(radiationWork);
            }
            if (staffWorkRoleNew.getId() != null) {
                staffWorkRoleNew.setUpdateBy(loginStaffId);
                staffWorkRoleNew.setUpdateDate(date);
                updateStaffWorkRoleList.add(staffWorkRoleNew);
            }
            updatedSheetDatas.add(v);
        }
        if (updateStaffInfoList.size() > 0) {
            this.staffInfoService.batchUpdateOrInsert(updateStaffInfoList, StaffInfoMapper.class, (e, mapper) -> mapper.updateByPrimaryKeySelective(e));
        }
        if (updateStaffBasicInfoList.size() > 0) {
            this.staffBasicInfoService.batchUpdateOrInsert(updateStaffBasicInfoList, StaffBasicInfoMapper.class, (e, mapper) -> mapper.updateByPrimaryKeySelective(e));
        }
        if (updateStaffBasicWorkList.size() > 0) {
            this.staffBasicWorkService.batchUpdateOrInsert(updateStaffBasicWorkList, StaffBasicWorkMapper.class, (e, mapper) -> mapper.updateByPrimaryKeySelective(e));
        }
        if (updateStaffWorkRoleList.size() > 0) {
            this.staffWorkRoleService.batchUpdateOrInsert(updateStaffWorkRoleList, StaffWorkRoleMapper.class, (e, mapper) -> mapper.updateByPrimaryKeySelective(e));
        }
        if (addWorkNatureInfoList.size() > 0) {
            this.workNatureInfoService.batchUpdateOrInsert(addWorkNatureInfoList, WorkNatureInfoMapper.class, (e, mapper) -> mapper.insertSelective(e));
        }
        this.staffFieldChangeLogService.addChangeLogList(logList, loginStaffId);
        return updatedSheetDatas;
    }

    private String getExcelColName(int index) {
        if (index <= 26) {
            return String.valueOf((char)(65 + index - 1));
        }
        int a = index / 26;
        int b = index % 26;
        return String.valueOf((char)(65 + a - 1)) + String.valueOf((char)(65 + b - 1));
    }

    private WorkRoleInfo getWorkByNameAndCid(String workName, Long cid) {
        String[] workAndDeptname;
        if (workName == null || cid == null) {
            return null;
        }
        if (workName.contains("/") && (workAndDeptname = workName.split("/")).length == 2) {
            String jobName = workAndDeptname[0];
            String deptName = workAndDeptname[1];
            WorkRoleInfo work = this.workRoleInfoService.getWorkRoleInfoByNameAndOrgName(jobName, deptName, cid);
            if (work != null && work.getId() != null) {
                return work;
            }
            work = new WorkRoleInfo();
            work.setWorkName(jobName);
            work.setOrgName(deptName);
            return work;
        }
        return null;
    }

    private static void dateHandle(Cell cell) {
        String dateStr;
        if ((cell.getCellType() == CellType.STRING || cell.getCellType() == CellType.FORMULA) && StringUtils.isNotEmpty((String)(dateStr = cell.getStringCellValue()))) {
            Date date = DateUtils.parseDate((Object)dateStr.trim());
            if (date == null) {
                cell.setCellType(CellType.BLANK);
            } else {
                Integer year = date.getYear();
                if (year > 9999) {
                    cell.setCellType(CellType.BLANK);
                } else {
                    cell.setCellValue(date);
                }
            }
        }
    }

    private NoInformStaff createNoInformStaff(StaffWorkRole staffWorkRole, NoInformStaffChangeWorkStatusEnum status, Long loginStaffId, Long cid) {
        NoInformStaff noInformStaff = this.noInformStaffService.getNotInformStaffByStaffWorkRoleId(staffWorkRole.getId(), cid);
        if (noInformStaff != null) {
            noInformStaff.setChangWorkStatus(status.getValue());
            noInformStaff.setStaffId(staffWorkRole.getStaffId());
            noInformStaff.setWorkInfoId(staffWorkRole.getWorkRoleId());
            noInformStaff.setStaffWorkRoleId(staffWorkRole.getId());
            this.noInformStaffService.update((Object)noInformStaff, loginStaffId);
        } else {
            noInformStaff = new NoInformStaff();
            noInformStaff.setChangWorkStatus(status.getValue());
            noInformStaff.setStaffId(staffWorkRole.getStaffId());
            noInformStaff.setWorkInfoId(staffWorkRole.getWorkRoleId());
            noInformStaff.setStaffWorkRoleId(staffWorkRole.getId());
            this.noInformStaffService.add((Object)noInformStaff, loginStaffId, cid);
        }
        return noInformStaff;
    }
}

