/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.staff;

import cn.smarthse.common.framework.service.datascope.DataScopeHelper;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.enums.SysParamGroupEnum;
import cn.smarthse.modules.datacentre.model.system.SysParamModel;
import cn.smarthse.modules.datacentre.provider.system.ISysParamProvideService;
import cn.smarthse.modules.health.dao.base.staff.StaffInfoMapper;
import cn.smarthse.modules.health.entity.base.company.CompanyOrganization;
import cn.smarthse.modules.health.entity.base.staff.StaffInfoSearchParam;
import cn.smarthse.modules.health.entity.base.staff.StaffOccupationHealth;
import cn.smarthse.modules.health.entity.base.staff.StaffShowInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffShowInfoExportVo;
import cn.smarthse.modules.health.entity.base.staff.WorkNatureInfo;
import cn.smarthse.modules.health.entity.base.workinfo.WorkRoleInfo;
import cn.smarthse.modules.health.entity.datascope.DataScope;
import cn.smarthse.modules.health.enums.staff.WorkNatureEnum;
import cn.smarthse.modules.health.service.base.company.ICompanyOrganizationService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoExportService;
import cn.smarthse.modules.health.service.base.staff.IStaffOccupationHealthService;
import cn.smarthse.modules.health.service.base.staff.IWorkNatureInfoService;
import cn.smarthse.modules.health.service.base.workinfo.IWorkRoleInfoService;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class StaffInfoExportServiceImpl
implements IStaffInfoExportService {
    @Autowired
    private ICompanyOrganizationService companyOrganizationService;
    @Autowired
    private IWorkRoleInfoService workRoleInfoService;
    @DubboReference(version="1.0.0")
    private ISysParamProvideService sysParamProvideService;
    @Autowired
    private StaffInfoMapper staffInfoMapper;
    @Autowired
    private IWorkNatureInfoService workNatureInfoService;
    @Autowired
    private IStaffOccupationHealthService staffOccupationHealthService;

    private String getOutSource(Byte state) {
        if (state == null) {
            return "";
        }
        String result = "";
        switch (state) {
            case 1: {
                result = "\u52b3\u52a8\u6d3e\u9063";
                break;
            }
            case 2: {
                result = "\u52b3\u52a8\u5916\u5305";
                break;
            }
            case 3: {
                result = "\u5176\u4ed6";
                break;
            }
        }
        return result;
    }

    private Map<Long, CompanyOrganization> getOrgMap(Long cid) {
        HashMap<Long, CompanyOrganization> map = new HashMap<Long, CompanyOrganization>();
        List orgs = this.companyOrganizationService.getListByCid(cid);
        if (orgs == null || orgs.isEmpty()) {
            return map;
        }
        for (CompanyOrganization org : orgs) {
            map.put(org.getId(), org);
        }
        return map;
    }

    private String getFullOrgName(Long orgId, Map<Long, CompanyOrganization> orgMap) {
        Object fullOrgName = "";
        if (orgId == null || orgMap.isEmpty()) {
            return fullOrgName;
        }
        CompanyOrganization comor = orgMap.get(orgId);
        if (comor != null) {
            if (StringUtils.isNotEmpty((String)comor.getTreePath())) {
                String[] paths;
                for (String ss : paths = comor.getTreePath().split(",")) {
                    CompanyOrganization comor1;
                    if (StringUtils.isEmpty((CharSequence)ss) || (comor1 = orgMap.get(Long.valueOf(ss))) == null) continue;
                    fullOrgName = (String)fullOrgName + comor1.getOrganizationName() + "-";
                }
                fullOrgName = (String)fullOrgName + comor.getOrganizationName();
            } else {
                fullOrgName = comor.getOrganizationName();
            }
        }
        return fullOrgName;
    }

    private String getAllPathOrgName(Long orgId, Map<Long, CompanyOrganization> orgMap) {
        Object workName = "";
        if (orgId == null || orgMap.isEmpty()) {
            return workName;
        }
        CompanyOrganization org = orgMap.get(orgId);
        if (org != null) {
            if (StringUtils.isNotEmpty((String)org.getOrganizationName())) {
                workName = org.getOrganizationName();
            }
            if (org.getTreePath() != null && org.getTreePath().length() > 0) {
                List list = Arrays.stream(org.getTreePath().split(",")).map(Long::valueOf).collect(Collectors.toList());
                ArrayList<CompanyOrganization> parent = new ArrayList<CompanyOrganization>();
                for (Long id : list) {
                    if (orgMap.get(id) == null) continue;
                    parent.add(orgMap.get(id));
                }
                List<Object> nameList = new ArrayList();
                if (parent.size() > 0) {
                    nameList = parent.stream().filter(e -> e.getLevel() != null).sorted(Comparator.comparing(CompanyOrganization::getLevel)).map(CompanyOrganization::getOrganizationName).collect(Collectors.toList());
                }
                if (nameList.size() > 0) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (String name : nameList) {
                        stringBuilder.append(name).append(">");
                    }
                    workName = !"".equals(workName) ? String.valueOf(stringBuilder) + (String)workName : stringBuilder.substring(0, stringBuilder.length() - 1);
                }
            }
        }
        return workName;
    }

    private String getOrgName(Long orgId, Map<Long, CompanyOrganization> orgMap) {
        String workName = "";
        if (orgId == null || orgMap.isEmpty()) {
            return workName;
        }
        CompanyOrganization org = orgMap.get(orgId);
        workName = org == null ? "" : org.getOrganizationName();
        return workName;
    }

    private Map<Long, WorkRoleInfo> getWorkMap(Long cid) {
        HashMap<Long, WorkRoleInfo> map = new HashMap<Long, WorkRoleInfo>();
        List works = this.workRoleInfoService.getWorkRoleInfosByCid(cid);
        if (works == null || works.isEmpty()) {
            return map;
        }
        for (WorkRoleInfo work : works) {
            map.put(work.getId(), work);
        }
        return map;
    }

    private Map<Long, String> getEduMap() {
        HashMap<Long, String> result = new HashMap<Long, String>();
        List educTypeParam = this.sysParamProvideService.getSysParamList(SysParamGroupEnum.educ_background.getValue());
        if (educTypeParam == null || educTypeParam.isEmpty()) {
            return result;
        }
        for (SysParamModel l : educTypeParam) {
            result.put(l.getId(), l.getParamValue());
        }
        return result;
    }

    private String getWorkOrgName(Long workId, Map<Long, WorkRoleInfo> workMap) {
        String workName = "";
        if (workId == null || workMap.isEmpty()) {
            return workName;
        }
        WorkRoleInfo work = workMap.get(workId);
        workName = work == null ? "" : work.getWorkName();
        return workName;
    }

    private String getParamValue(Long id, Map<Long, SysParamModel> sysParamMap) {
        if (id == null || sysParamMap.isEmpty()) {
            return "";
        }
        SysParamModel sp = sysParamMap.get(id);
        return sp == null ? "" : sp.getParamValue();
    }

    private Map<Long, WorkNatureInfo> getRadiationWorkMap(Long cid, Byte Type2) {
        HashMap<Long, WorkNatureInfo> map = new HashMap<Long, WorkNatureInfo>();
        List works = this.workNatureInfoService.getWorkInfoListByCid(cid, Type2);
        if (works == null || works.isEmpty()) {
            return map;
        }
        for (WorkNatureInfo work : works) {
            map.put(work.getStaffId(), work);
        }
        return map;
    }

    private String getSpecialWorkName(Long StaffId, Map<Long, WorkNatureInfo> workMap) {
        String workName = "";
        if (StaffId == null || workMap.isEmpty()) {
            return workName;
        }
        WorkNatureInfo work = workMap.get(StaffId);
        workName = work == null ? "" : work.getWorkType();
        return workName;
    }

    private Map<Long, StaffOccupationHealth> getStaffOccupationHealthByCid(Long cid) {
        HashMap<Long, StaffOccupationHealth> map = new HashMap<Long, StaffOccupationHealth>();
        List list = this.staffOccupationHealthService.getStaffOccupationHealthByStaffIdByCid(cid);
        if (list == null || list.isEmpty()) {
            return map;
        }
        for (StaffOccupationHealth info : list) {
            map.put(info.getStaffId(), info);
        }
        return map;
    }

    public List<StaffShowInfo> exportStaffInfoListBySearchParam(StaffInfoSearchParam param) {
        if (param.getOrgId() != null) {
            List orgList = this.companyOrganizationService.getAllChildrenCompanyOrganizationsByPid(param.getOrgId(), param.getCid());
            param.getOrgIds().add(param.getOrgId());
            for (CompanyOrganization co : orgList) {
                param.getOrgIds().add(co.getId());
            }
        }
        Long cid = param.getCid();
        DataScopeHelper.startDataScope("staffInfo", "staff_info");
        DataScope dataScope = DataScopeHelper.getDataScope();
        dataScope.setCreateBy("id");
        DataScopeHelper.setDataScope(dataScope);
        param.setSearchKeyEncrypt(param.getSearchKey());
        param.setStaffNameEncrypt(param.getStaffName());
        List<StaffShowInfo> list = this.staffInfoMapper.getStaffInfoListBySearchParam(param);
        Map<Long, CompanyOrganization> orgMap = this.getOrgMap(cid);
        Map<Long, String> eduMap = this.getEduMap();
        Map<Long, WorkRoleInfo> workMap = this.getWorkMap(cid);
        Map<Long, WorkNatureInfo> radiationWorkMap = this.getRadiationWorkMap(cid, WorkNatureEnum.RadiationWork.getValue());
        Map<Long, WorkNatureInfo> ParticularWorkMap = this.getRadiationWorkMap(cid, WorkNatureEnum.ParticularWork.getValue());
        Map<Long, WorkNatureInfo> SpecialWorkMap = this.getRadiationWorkMap(cid, WorkNatureEnum.SpecialWork.getValue());
        Map<Long, StaffOccupationHealth> fileMap = this.getStaffOccupationHealthByCid(cid);
        for (StaffShowInfo s : list) {
            s.setOutsourceName(this.getOutSource(s.getOutsource()));
            s.setOrgName(this.getFullOrgName(s.getOrgId(), orgMap));
            s.setWorkName(this.getWorkOrgName(s.getWorkRoleId(), workMap) + "/" + this.getOrgName(s.getOrgId(), orgMap));
            s.setEducationName(eduMap.get(s.getEducation()));
            WorkNatureInfo radiationInfo = radiationWorkMap.get(s.getId());
            if (radiationInfo != null) {
                s.setIsRadiation(radiationInfo.getIsWork());
                s.setRadiationYear(radiationInfo.getWorkBeginTime());
                s.setRadiationTypeName(radiationInfo.getWorkType());
            }
            s.setSpecialoperationsName(this.getSpecialWorkName(s.getId(), ParticularWorkMap));
            s.setSpecialWorkName(this.getSpecialWorkName(s.getId(), SpecialWorkMap));
            StaffOccupationHealth health = fileMap.get(s.getId());
            if (health == null) continue;
            s.setFileNo(health.getFileNo());
            s.setFilingTime(health.getFilingTime());
            s.setFilesStorageLocation(health.getFilesStorageLocation());
        }
        return list;
    }

    public List<StaffShowInfoExportVo> exportStaffInfosBySearchParam(StaffInfoSearchParam param) {
        Long cid = param.getCid();
        DataScopeHelper.startDataScope("staffInfo", "staff_info");
        DataScope dataScope = DataScopeHelper.getDataScope();
        dataScope.setCreateBy("id");
        DataScopeHelper.setDataScope(dataScope);
        param.setSearchKeyEncrypt(param.getSearchKey());
        param.setStaffNameEncrypt(param.getStaffName());
        List<StaffShowInfo> list = this.staffInfoMapper.getStaffInfoListBySearchParam(param);
        ArrayList<StaffShowInfoExportVo> finalList = new ArrayList<StaffShowInfoExportVo>();
        if (CollectionUtils.isNotEmpty(list)) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            Map<Long, CompanyOrganization> orgMap = this.getOrgMap(cid);
            Map<Long, String> eduMap = this.getEduMap();
            Map<Long, WorkRoleInfo> workMap = this.getWorkMap(cid);
            Map<Long, WorkNatureInfo> radiationWorkMap = this.getRadiationWorkMap(cid, WorkNatureEnum.RadiationWork.getValue());
            Map<Long, WorkNatureInfo> ParticularWorkMap = this.getRadiationWorkMap(cid, WorkNatureEnum.ParticularWork.getValue());
            Map<Long, WorkNatureInfo> SpecialWorkMap = this.getRadiationWorkMap(cid, WorkNatureEnum.SpecialWork.getValue());
            for (StaffShowInfo s : list) {
                WorkNatureInfo radiationInfo;
                if (s == null) continue;
                StaffShowInfoExportVo vo = new StaffShowInfoExportVo();
                vo.setOtherCompany(s.getOtherCompany());
                vo.setOutsourceName(this.getOutSource(s.getOutsource()));
                vo.setWorkNo(s.getWorkNo());
                vo.setRealName(s.getRealName());
                vo.setOrgName(this.getAllPathOrgName(s.getOrgId(), orgMap));
                vo.setWorkName(s.getJobName());
                vo.setDeptId(s.getOrgId());
                vo.setEducationName(eduMap.get(s.getEducation()));
                vo.setGender(s.getGender());
                vo.setMobile(s.getPhoneNo());
                vo.setIdCardNo(s.getIdCardNo());
                vo.setWorkStatus(s.getWorkStatus());
                if (s.getWorkStatus() != null && s.getWorkStatus() == 2 && s.getCurrentWorkLeaveTime() != null) {
                    vo.setCurrentWorkLeaveTimeStr(dateFormat.format(s.getCurrentWorkLeaveTime()));
                }
                vo.setHobby(s.getHabitSmoke());
                if (s.getCurrentWorkBeginTime() != null) {
                    vo.setCurrentWorkBeginTimeStr(dateFormat.format(s.getCurrentWorkBeginTime()));
                }
                if (s.getFirstBeginTime() != null) {
                    vo.setFirstBeginTimeStr(dateFormat.format(s.getFirstBeginTime()));
                }
                vo.setJobTitle(s.getJobTitle());
                vo.setNativePlace(s.getNativePlace());
                vo.setNation(s.getNation());
                vo.setMarriage(s.getMarriage());
                vo.setMajor(s.getMajor());
                if (s.getWorkTime() != null) {
                    vo.setWorkTimeStr(dateFormat.format(s.getWorkTime()));
                }
                if (s.getJoinTime() != null) {
                    vo.setJoinTimeStr(dateFormat.format(s.getJoinTime()));
                }
                if ((radiationInfo = radiationWorkMap.get(s.getId())) != null) {
                    vo.setIsRadiation(radiationInfo.getIsWork());
                    if (radiationInfo.getWorkBeginTime() != null) {
                        vo.setRadiationYearStr(dateFormat.format(radiationInfo.getWorkBeginTime()));
                    }
                    vo.setRadiationTypeName(radiationInfo.getWorkType());
                }
                vo.setIsRadiation(s.getIsRadiation());
                vo.setSpecialoperationsName(this.getSpecialWorkName(s.getId(), ParticularWorkMap));
                vo.setSpecialWorkName(this.getSpecialWorkName(s.getId(), SpecialWorkMap));
                finalList.add(vo);
            }
        }
        return finalList;
    }
}

