/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.staff;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.modules.health.dao.base.staff.StaffFieldChangeLogMapper;
import cn.smarthse.modules.health.entity.base.staff.StaffFieldChangeLog;
import cn.smarthse.modules.health.service.base.staff.IStaffFieldChangeLogService;
import cn.smarthse.snowflake.IdWorker;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
public class StaffFieldChangeLogServiceImpl
extends BaseServiceImpl<StaffFieldChangeLogMapper, StaffFieldChangeLog>
implements IStaffFieldChangeLogService {
    @Autowired
    protected IdWorker idworker;

    @Transactional
    public void addChangeLogList(List<StaffFieldChangeLog> logList, Long userId) {
        if (CollectionUtils.isNotEmpty(logList)) {
            Date date = new Date();
            this.batchUpdateOrInsert(logList, StaffFieldChangeLogMapper.class, (e, mapper) -> {
                e.setId(Long.valueOf(this.idworker.nextId()));
                e.setCreateBy(userId);
                e.setCreateDate(date);
                return mapper.insertSelective(e);
            }, 1000);
        }
    }

    public PageInfo<StaffFieldChangeLog> getChangePage(Long cid, Long staffId, String field, JqGridParam page) {
        List<Integer> list = Arrays.stream(field.split(",")).map(Integer::valueOf).collect(Collectors.toList());
        PageHelper.startPage((int)page.getPage(), (int)page.getRows());
        List<StaffFieldChangeLog> logList = ((StaffFieldChangeLogMapper)this.dao).getChangeList(list, staffId, cid);
        if (CollectionUtils.isNotEmpty(logList)) {
            for (StaffFieldChangeLog staffFieldChangeLog : logList) {
                staffFieldChangeLog.setOperator(SpringEncryptUtils.decrypt((String)staffFieldChangeLog.getOperator()));
            }
            return new PageInfo(logList);
        }
        return new PageInfo();
    }
}

