/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.staff;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.modules.health.dao.base.staff.StaffBasicWorkMapper;
import cn.smarthse.modules.health.entity.base.company.CompanyOrganization;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicWork;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffWorkRole;
import cn.smarthse.modules.health.entity.base.staff.vo.StaffBasicVo;
import cn.smarthse.modules.health.entity.base.workinfo.WorkRoleInfo;
import cn.smarthse.modules.health.entity.work.informmanager.ContractInform;
import cn.smarthse.modules.health.entity.work.informmanager.NoInformStaff;
import cn.smarthse.modules.health.enums.staff.ContractInformReasonEnum;
import cn.smarthse.modules.health.enums.staff.NoInformStaffChangeWorkStatusEnum;
import cn.smarthse.modules.health.enums.staff.StaffFurloughStatusEnum;
import cn.smarthse.modules.health.enums.staff.StaffWorkPropertyEnum;
import cn.smarthse.modules.health.enums.staff.StaffWorkStatusEnum;
import cn.smarthse.modules.health.service.base.company.ICompanyOrganizationService;
import cn.smarthse.modules.health.service.base.staff.IStaffBasicInfoService;
import cn.smarthse.modules.health.service.base.staff.IStaffBasicWorkService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.base.staff.IStaffWorkRoleService;
import cn.smarthse.modules.health.service.base.workinfo.IWorkRoleInfoService;
import cn.smarthse.modules.health.service.work.informmanager.IContractInformService;
import cn.smarthse.modules.health.service.work.informmanager.INoInformStaffService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.lang.invoke.CallSite;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class StaffBasicWorkServiceImpl
extends BaseServiceImpl<StaffBasicWorkMapper, StaffBasicWork>
implements IStaffBasicWorkService {
    @Autowired
    IContractInformService contractInformService;
    @Autowired
    ICompanyOrganizationService companyOrganizationService;
    @Autowired
    IStaffWorkRoleService staffWorkRoleService;
    @Autowired
    IStaffBasicInfoService staffBasicInfoService;
    @Autowired
    IWorkRoleInfoService workRoleInfoService;
    @Autowired
    INoInformStaffService noInformStaffService;
    @Autowired
    IStaffInfoService staffInfoService;
    @Autowired
    StaffBasicWorkMapper staffBasicWorkMapper;

    public StaffBasicWork getStaffBasicWorkByStaffId(Long staffId) {
        Example e = new Example(StaffBasicWork.class);
        Example.Criteria c = e.createCriteria();
        c.andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("staffId", (Object)staffId);
        List list = this.staffBasicWorkMapper.selectByExample(e);
        StaffBasicWork s = null;
        if (list != null && list.size() > 0 && (s = (StaffBasicWork)list.get(0)).getOrgId() != null) {
            s.setCompanyOrganization((CompanyOrganization)this.companyOrganizationService.getById(s.getOrgId()));
        }
        return s;
    }

    public StaffBasicWork getStaffBasicWorkIncludeDelStatusByStaffId(Long staffId) {
        Example e = new Example(StaffBasicWork.class);
        Example.Criteria c = e.createCriteria();
        c.andEqualTo("staffId", (Object)staffId);
        List list = this.staffBasicWorkMapper.selectByExample(e);
        StaffBasicWork s = null;
        if (list != null && list.size() > 0 && (s = (StaffBasicWork)list.get(0)).getOrgId() != null) {
            s.setCompanyOrganization((CompanyOrganization)this.companyOrganizationService.getById(s.getOrgId()));
        }
        return s;
    }

    public List<StaffBasicWork> getStaffBasicWorksByOrgId(Long orgId) {
        Example e = new Example(StaffBasicWork.class);
        Example.Criteria c = e.createCriteria();
        c.andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("orgId", (Object)orgId);
        List list = this.staffBasicWorkMapper.selectByExample(e);
        return list;
    }

    public List<StaffBasicWork> getStaffBasicWorkDetailByOrgId(Long orgId) {
        List<StaffBasicWork> staffBasicWorks = this.getStaffBasicWorksByOrgId(orgId);
        for (StaffBasicWork basicWork : staffBasicWorks) {
            if (basicWork.getStaffId() == null) continue;
            StaffWorkRole currentStaffWorkRole = this.staffWorkRoleService.getCurrentStaffWorkRoleByStaffId(basicWork.getStaffId());
            if (currentStaffWorkRole != null && currentStaffWorkRole.getWorkRoleId() != null) {
                currentStaffWorkRole.setWorkRoleInfo((WorkRoleInfo)this.workRoleInfoService.getById(currentStaffWorkRole.getWorkRoleId()));
            }
            basicWork.setCurrentStaffWorkRole(currentStaffWorkRole);
            StaffInfo staffInfo = (StaffInfo)this.staffInfoService.getById(basicWork.getStaffId());
            if (staffInfo == null || staffInfo.getStaffBasicId() == null) continue;
            basicWork.setStaffBasicInfo((StaffBasicInfo)this.staffBasicInfoService.getById(staffInfo.getStaffBasicId()));
        }
        return staffBasicWorks;
    }

    public PageInfo<StaffBasicWork> getStaffBasicWorkDetailByOrgId(Long orgId, Integer pageNum, Integer pageSize) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        return new PageInfo(this.getStaffBasicWorkDetailByOrgId(orgId));
    }

    @Transactional(readOnly=false)
    public void editStaffBasicWorkSubmit(StaffBasicWork staffBasicWork, Long loginStaffId, Long cid) {
        this.update(staffBasicWork, loginStaffId);
        if (staffBasicWork.getStaffInfo() != null) {
            this.staffInfoService.update((Object)staffBasicWork.getStaffInfo(), loginStaffId);
            if (staffBasicWork.getStaffInfo().getFurloughStatus() != null && staffBasicWork.getStaffInfo().getFurloughStatus() == StaffFurloughStatusEnum.FURLOUGHEND.getCode() && staffBasicWork.getStaffInfo().getFurloughBeginTime() != null && staffBasicWork.getStaffInfo().getFurloughEndTime() != null && DateUtils.getDistanceOfTwoDate((Date)staffBasicWork.getStaffInfo().getFurloughBeginTime(), (Date)staffBasicWork.getStaffInfo().getFurloughEndTime()) >= 60.0) {
                this.createNoInformStaff(staffBasicWork.getCurrentStaffWorkRole(), NoInformStaffChangeWorkStatusEnum.WORKCHANGED, loginStaffId, cid);
                ContractInform inform = this.goToContractInform(staffBasicWork.getCurrentStaffWorkRole(), ContractInformReasonEnum.AGAINWORK, staffBasicWork.getStaffInfo().getId(), loginStaffId, cid);
                if (inform != null) {
                    staffBasicWork.getCurrentStaffWorkRole().setInformId(inform.getId());
                    this.staffWorkRoleService.update((Object)staffBasicWork.getCurrentStaffWorkRole(), loginStaffId);
                    if (staffBasicWork.getCurrentStaffWorkRole() != null) {
                        // empty if block
                    }
                }
            }
        }
        if (staffBasicWork.getCurrentStaffWorkRole() != null) {
            if (staffBasicWork.getCurrentStaffWorkRole().getId() == null) {
                this.staffWorkRoleService.add((Object)staffBasicWork.getCurrentStaffWorkRole(), loginStaffId, cid);
            } else if (staffBasicWork.getStaffInfo() != null && (staffBasicWork.getStaffInfo().getChangeWorkStatus() == NoInformStaffChangeWorkStatusEnum.TRANSFER.getValue() || staffBasicWork.getStaffInfo().getChangeWorkStatus() == NoInformStaffChangeWorkStatusEnum.AGAINWORK.getValue())) {
                Long beforeCurrentStaffWorkRoleId = staffBasicWork.getCurrentStaffWorkRole().getId();
                Date beforeCurrentLeaveTime = staffBasicWork.getCurrentStaffWorkRole().getLeaveTime();
                staffBasicWork.getCurrentStaffWorkRole().setId(null);
                staffBasicWork.getCurrentStaffWorkRole().setLeaveTime(null);
                this.staffWorkRoleService.add((Object)staffBasicWork.getCurrentStaffWorkRole(), loginStaffId, cid);
                if (staffBasicWork.getStaffInfo().getChangeWorkStatus() == NoInformStaffChangeWorkStatusEnum.TRANSFER.getValue()) {
                    this.createNoInformStaff(staffBasicWork.getCurrentStaffWorkRole(), NoInformStaffChangeWorkStatusEnum.WORKCHANGED, loginStaffId, cid);
                }
                if (staffBasicWork.getStaffInfo().getChangeWorkStatus() == NoInformStaffChangeWorkStatusEnum.AGAINWORK.getValue() && staffBasicWork.getStaffInfo().getIsNewStaff() != null && staffBasicWork.getStaffInfo().getIsNewStaff().booleanValue()) {
                    this.createNoInformStaff(staffBasicWork.getCurrentStaffWorkRole(), NoInformStaffChangeWorkStatusEnum.ONWORKING, loginStaffId, cid);
                }
                this.noInformStaffService.updateBeforeNoInformStaffNoValidBybeforeCurrentStaffWorkRoleId(beforeCurrentStaffWorkRoleId, cid, loginStaffId);
                this.goToContractInform(staffBasicWork.getCurrentStaffWorkRole(), ContractInformReasonEnum.TRANSFERWORK, staffBasicWork.getStaffInfo().getId(), loginStaffId, cid);
                staffBasicWork.getCurrentStaffWorkRole().setId(beforeCurrentStaffWorkRoleId);
                staffBasicWork.getCurrentStaffWorkRole().setWorkRoleId(null);
                staffBasicWork.getCurrentStaffWorkRole().setBeginTime(null);
                staffBasicWork.getCurrentStaffWorkRole().setLeaveTime(beforeCurrentLeaveTime);
                if (staffBasicWork.getStaffInfo().getChangeWorkStatus() == NoInformStaffChangeWorkStatusEnum.TRANSFER.getValue()) {
                    staffBasicWork.getCurrentStaffWorkRole().setStatus(StaffWorkStatusEnum.TRANSFER.getValue());
                }
                if (staffBasicWork.getStaffInfo().getChangeWorkStatus() == NoInformStaffChangeWorkStatusEnum.AGAINWORK.getValue()) {
                    staffBasicWork.getCurrentStaffWorkRole().setStatus(StaffWorkStatusEnum.NOWORKED.getValue());
                }
                staffBasicWork.getCurrentStaffWorkRole().setWorkProperty(StaffWorkPropertyEnum.WORKED.getValue());
                staffBasicWork.getCurrentStaffWorkRole().setIsHistory(Global.TRUE);
                this.staffWorkRoleService.update((Object)staffBasicWork.getCurrentStaffWorkRole(), loginStaffId);
            } else {
                this.staffWorkRoleService.update((Object)staffBasicWork.getCurrentStaffWorkRole(), loginStaffId);
                if (staffBasicWork.getCurrentStaffWorkRole().getStatus() == StaffWorkStatusEnum.ONWORKING.getValue() && staffBasicWork.getStaffInfo().getIsNewStaff() != null && staffBasicWork.getStaffInfo().getIsNewStaff().booleanValue()) {
                    this.createNoInformStaff(staffBasicWork.getCurrentStaffWorkRole(), NoInformStaffChangeWorkStatusEnum.ONWORKING, loginStaffId, cid);
                }
            }
        }
        List oldPluralityStaffWorkRoles = this.staffWorkRoleService.getAllPluralityStaffWorkRolesByStaffId(staffBasicWork.getStaffInfo().getId());
        HashMap<CallSite, StaffWorkRole> oldPluralityStaffWorkRolesMap = new HashMap<CallSite, StaffWorkRole>();
        for (StaffWorkRole s : oldPluralityStaffWorkRoles) {
            oldPluralityStaffWorkRolesMap.put((CallSite)((Object)("" + s.getWorkRoleId())), s);
            if (!Global.TRUE.equals(s.getIsValid())) continue;
            s.setIsValid(Global.FALSE);
            this.staffWorkRoleService.update((Object)s, loginStaffId);
        }
        HashMap<CallSite, StaffWorkRole> newPluralityStaffWorkRolesMap = new HashMap<CallSite, StaffWorkRole>();
        if (staffBasicWork.getPluralityStaffWorkRoles() != null) {
            for (StaffWorkRole s : staffBasicWork.getPluralityStaffWorkRoles()) {
                newPluralityStaffWorkRolesMap.put((CallSite)((Object)("" + s.getWorkRoleId())), s);
            }
        }
        for (String key : newPluralityStaffWorkRolesMap.keySet()) {
            StaffWorkRole oldWork = (StaffWorkRole)oldPluralityStaffWorkRolesMap.get(key);
            if (oldWork == null) {
                ((StaffWorkRole)newPluralityStaffWorkRolesMap.get(key)).setId(null);
                this.staffWorkRoleService.add((Object)((StaffWorkRole)newPluralityStaffWorkRolesMap.get(key)), loginStaffId, cid);
            }
            if (oldWork == null || !Global.FALSE.equals(oldWork.getIsValid())) continue;
            oldWork.setIsValid(Global.TRUE);
            this.staffWorkRoleService.update((Object)oldWork, loginStaffId);
        }
    }

    private ContractInform goToContractInform(StaffWorkRole workRole, ContractInformReasonEnum reason, Long staffId, Long loginStaffId, Long cid) {
        ContractInform inform = new ContractInform();
        inform.setInformState(Long.valueOf(0L));
        inform.setInformWorkId(workRole.getWorkRoleId());
        inform.setStaffId(staffId);
        inform.setIsValid(Global.TRUE);
        inform.setInformReason("" + reason.getValue());
        inform.setStaffWorkRoleId(workRole.getId());
        inform = this.contractInformService.informContractInformFromWorkChange(inform, loginStaffId, cid);
        return inform;
    }

    private NoInformStaff createNoInformStaff(StaffWorkRole staffWorkRole, NoInformStaffChangeWorkStatusEnum status, Long loginStaffId, Long cid) {
        NoInformStaff noInformStaff = this.noInformStaffService.getNotInformStaffByStaffWorkRoleId(staffWorkRole.getId(), cid);
        if (noInformStaff != null) {
            noInformStaff.setChangWorkStatus(status.getValue());
            noInformStaff.setStaffId(staffWorkRole.getStaffId());
            noInformStaff.setWorkInfoId(staffWorkRole.getWorkRoleId());
            noInformStaff.setStaffWorkRoleId(staffWorkRole.getId());
            this.noInformStaffService.update((Object)noInformStaff, loginStaffId);
        } else {
            noInformStaff = new NoInformStaff();
            noInformStaff.setChangWorkStatus(status.getValue());
            noInformStaff.setStaffId(staffWorkRole.getStaffId());
            noInformStaff.setWorkInfoId(staffWorkRole.getWorkRoleId());
            noInformStaff.setStaffWorkRoleId(staffWorkRole.getId());
            this.noInformStaffService.add((Object)noInformStaff, loginStaffId, cid);
        }
        return noInformStaff;
    }

    public List<StaffBasicWork> getStaffBasicWorksByRealName(Long cid, String searchKey) {
        return this.staffBasicWorkMapper.getStaffBasicWorksByRealName(cid, SpringEncryptUtils.encrypt((String)searchKey));
    }

    public List<StaffBasicWork> getStaffBasicWorksByOrgIdAndSearchKey(Long cid, Long orgId, String searchKey) {
        return this.staffBasicWorkMapper.getStaffBasicWorksByOrgIdAndSearchKey(cid, orgId, SpringEncryptUtils.encrypt((String)searchKey));
    }

    public List<StaffInfo> getStaffInfosByOrgIdAndSearch(Long cid, String searchKey, Long workId, List<Long> orgIds) {
        return this.staffBasicWorkMapper.getStaffInfoByOrgIdAndSearchKey(cid, SpringEncryptUtils.encrypt((String)searchKey), workId, orgIds);
    }

    public List<StaffInfo> getStaffInfosByOrgIdAndSearch2(Long cid, String searchKey, Long workId, List<Long> orgIds) {
        return this.staffBasicWorkMapper.getStaffInfoByOrgIdAndSearchKey2(cid, SpringEncryptUtils.encrypt((String)searchKey), workId, orgIds);
    }

    public List<StaffBasicWork> getAllByCid(Long cid) {
        Example e = new Example(StaffBasicWork.class);
        Example.Criteria c = e.createCriteria();
        c.andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("cid", (Object)cid);
        return this.getListByExample(e);
    }

    @Transactional(readOnly=false)
    public void updateByStaffId(StaffBasicWork work, Long staffId, Long loginStaffId, Long cid) {
        Example e = new Example(StaffBasicWork.class);
        Example.Criteria c = e.createCriteria();
        c.andEqualTo("staffId", (Object)staffId).andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("cid", (Object)cid);
        work.setUpdateBy(loginStaffId);
        work.setUpdateDate(new Date());
        ((StaffBasicWorkMapper)this.dao).updateByExampleSelective(work, e);
    }

    public StaffBasicWork getStaffBasicWorkIncludeNoIsValidByStaffId(Long staffId) {
        Example e = new Example(StaffBasicWork.class);
        Example.Criteria c = e.createCriteria();
        c.andEqualTo("staffId", (Object)staffId);
        List list = this.staffBasicWorkMapper.selectByExample(e);
        StaffBasicWork s = null;
        if (list != null && list.size() > 0 && (s = (StaffBasicWork)list.get(0)).getOrgId() != null) {
            s.setCompanyOrganization((CompanyOrganization)this.companyOrganizationService.getById(s.getOrgId()));
        }
        return s;
    }

    @Transactional(readOnly=false)
    public void editNewStaffBasicWorkSubmit(StaffBasicWork staffBasicWork, Long loginStaffId, Long cid) {
        this.update(staffBasicWork, loginStaffId);
        if (staffBasicWork.getStaffInfo() != null || staffBasicWork.getPluralityStaffWorkRoles() != null) {
            List oldPluralityStaffWorkRoles = this.staffWorkRoleService.getAllPluralityStaffWorkRolesByStaffId(staffBasicWork.getStaffInfo().getId());
            HashMap<CallSite, StaffWorkRole> oldPluralityStaffWorkRolesMap = new HashMap<CallSite, StaffWorkRole>();
            for (StaffWorkRole s : oldPluralityStaffWorkRoles) {
                oldPluralityStaffWorkRolesMap.put((CallSite)((Object)("" + s.getWorkRoleId())), s);
                if (!Global.TRUE.equals(s.getIsValid())) continue;
                s.setIsValid(Global.FALSE);
                this.staffWorkRoleService.update((Object)s, loginStaffId);
            }
            HashMap<CallSite, StaffWorkRole> newPluralityStaffWorkRolesMap = new HashMap<CallSite, StaffWorkRole>();
            if (staffBasicWork.getPluralityStaffWorkRoles() != null) {
                for (StaffWorkRole s : staffBasicWork.getPluralityStaffWorkRoles()) {
                    newPluralityStaffWorkRolesMap.put((CallSite)((Object)("" + s.getWorkRoleId())), s);
                }
            }
            for (String key : newPluralityStaffWorkRolesMap.keySet()) {
                StaffWorkRole oldWork = (StaffWorkRole)oldPluralityStaffWorkRolesMap.get(key);
                if (oldWork == null) {
                    ((StaffWorkRole)newPluralityStaffWorkRolesMap.get(key)).setId(null);
                    this.staffWorkRoleService.add((Object)((StaffWorkRole)newPluralityStaffWorkRolesMap.get(key)), loginStaffId, cid);
                }
                if (oldWork == null || !Global.FALSE.equals(oldWork.getIsValid())) continue;
                oldWork.setIsValid(Global.TRUE);
                this.staffWorkRoleService.update((Object)oldWork, loginStaffId);
            }
        }
    }

    @Transactional(readOnly=false)
    public void upDateStaffBasicWorkByIdForOverUpdate(StaffBasicWork staffBasicWork, Long loginStaffId) {
        if (staffBasicWork != null && staffBasicWork.getId() != null) {
            staffBasicWork.setUpdateBy(loginStaffId);
            staffBasicWork.setUpdateDate(new Date());
            this.staffBasicWorkMapper.upDateStaffBasicWorkByIdForOverUpdate(staffBasicWork);
        }
    }

    public StaffBasicWork getStaffBasicWorkIncludeDeleteByStaffId(Long staffId) {
        Example e = new Example(StaffBasicWork.class);
        Example.Criteria c = e.createCriteria();
        c.andEqualTo("staffId", (Object)staffId);
        List list = this.staffBasicWorkMapper.selectByExample(e);
        StaffBasicWork s = null;
        if (list != null && list.size() > 0) {
            s = (StaffBasicWork)list.get(0);
        }
        return s;
    }

    public StaffBasicVo getByWorkNo(String workNo, Long cid) {
        List<StaffBasicVo> staffBasicWorks = ((StaffBasicWorkMapper)this.dao).getByWorkNo(workNo, cid);
        if (CollectionUtils.isNotEmpty(staffBasicWorks)) {
            for (StaffBasicVo staffBasicWork : staffBasicWorks) {
                staffBasicWork.setStaffName(SpringEncryptUtils.decrypt((String)staffBasicWork.getStaffName()));
            }
        }
        return staffBasicWorks == null || staffBasicWorks.isEmpty() ? null : staffBasicWorks.get(0);
    }

    public StaffBasicWork getStaffBasicWorkByWorkNo(String workNo, Long cid) {
        if (workNo == null || workNo.equals("") || cid == null) {
            return null;
        }
        Example example = new Example(StaffBasicWork.class);
        example.createCriteria().andEqualTo("workNo", (Object)workNo).andEqualTo("isValid", (Object)true).andEqualTo("cid", (Object)cid);
        example.orderBy("createDate").desc();
        List list = this.getListByExample(example);
        if (list != null && list.size() > 0) {
            return (StaffBasicWork)list.get(0);
        }
        return null;
    }

    public Integer getSaffCountByOrgId(Long orgId) {
        Example e = new Example(StaffBasicWork.class);
        Example.Criteria c = e.createCriteria();
        c.andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("orgId", (Object)orgId);
        return this.staffBasicWorkMapper.selectCountByExample(e);
    }
}

