/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.staff;

import cn.hutool.core.collection.ListUtil;
import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.modules.health.dao.base.staff.StaffBasicInfoMapper;
import cn.smarthse.modules.health.dao.base.staff.StaffWorkRoleMapper;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicInfo;
import cn.smarthse.modules.health.entity.base.staff.importstaff.StaffInfoExcelImportVo;
import cn.smarthse.modules.health.service.base.staff.IStaffBasicInfoService;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class StaffBasicInfoServiceImpl
extends BaseServiceImpl<StaffBasicInfoMapper, StaffBasicInfo>
implements IStaffBasicInfoService {
    @Autowired
    StaffBasicInfoMapper staffBasicInfoMapper;
    @Autowired
    StaffWorkRoleMapper staffWorkRoleMapper;

    public StaffBasicInfo getStaffBasicInfoByIdCard(String idCard, Long basicId, Long cid) {
        Example e = new Example(StaffBasicInfo.class);
        Example.Criteria c = e.createCriteria();
        c.andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("idCard", (Object)SpringEncryptUtils.encrypt((String)idCard)).andEqualTo("cid", (Object)cid);
        if (basicId != null) {
            c.andNotEqualTo("id", (Object)basicId);
        }
        StaffBasicInfo staffBasicInfo = null;
        List list = this.getListByExample(e);
        if (list != null && list.size() > 0) {
            staffBasicInfo = (StaffBasicInfo)list.get(0);
        }
        return staffBasicInfo;
    }

    public String getUserName(String ids) {
        List list = this.getListByIds(ids);
        Object name = "";
        for (StaffBasicInfo info : list) {
            if ("".equals(name)) {
                name = info.getRealName();
                continue;
            }
            name = (String)name + "/" + info.getRealName();
        }
        return name;
    }

    public List<StaffBasicInfo> getStaffBasicInfosByCardId(String cardId) {
        Example e = new Example(StaffBasicInfo.class);
        Example.Criteria c = e.createCriteria();
        c.andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("idCard", (Object)SpringEncryptUtils.encrypt((String)cardId));
        List<StaffBasicInfo> list = this.getListByExample(e);
        return list;
    }

    public List<StaffBasicInfo> getStaffBasicInfosByCardIds(List<String> cardIds) {
        if (cardIds == null || cardIds.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList cardIdsEncrypt = new ArrayList();
        cardIds.forEach(c -> cardIdsEncrypt.add(SpringEncryptUtils.encrypt((String)c)));
        Example e = new Example(StaffBasicInfo.class);
        Example.Criteria c2 = e.createCriteria();
        c2.andIn("idCard", cardIdsEncrypt);
        return this.getListByExample(e);
    }

    public List<StaffBasicInfo> getStaffBasicInfosByCardIdAndCid(String cardId, Long cid) {
        Example e = new Example(StaffBasicInfo.class);
        Example.Criteria c = e.createCriteria();
        c.andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("idCard", (Object)SpringEncryptUtils.encrypt((String)cardId)).andEqualTo("cid", (Object)cid);
        List<StaffBasicInfo> list = this.getListByExample(e);
        return list;
    }

    public StaffBasicInfo getFirstStaffBasicInfoByIdCard(String idCard) {
        Example e = new Example(StaffBasicInfo.class);
        Example.Criteria c = e.createCriteria();
        c.andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("idCard", (Object)SpringEncryptUtils.encrypt((String)idCard));
        e.orderBy("createDate").desc();
        List list = this.getListByExample(e);
        if (list != null && list.size() > 0) {
            return (StaffBasicInfo)list.get(0);
        }
        return null;
    }

    public List<StaffBasicInfo> getAllStaffBasicInfoByIdCard(String idCard) {
        Example e = new Example(StaffBasicInfo.class);
        Example.Criteria c = e.createCriteria();
        c.andEqualTo("idCard", (Object)SpringEncryptUtils.encrypt((String)idCard));
        List<StaffBasicInfo> list = this.getListByExample(e);
        if (list != null && list.size() > 0) {
            return list;
        }
        return new ArrayList<StaffBasicInfo>();
    }

    @Transactional(readOnly=false)
    public void upDateStaffBasicInfoByIdForOverUpdate(StaffBasicInfo staffBasicInfo, Long loginStaffId) {
        if (staffBasicInfo != null && staffBasicInfo.getId() != null) {
            staffBasicInfo.setUpdateBy(loginStaffId);
            staffBasicInfo.setUpdateDate(new Date());
            this.staffBasicInfoMapper.upDateStaffBasicInfoByIdForOverUpdate(staffBasicInfo);
        }
    }

    @Transactional(readOnly=false)
    public void updateStaffNameByIdCardAndCid(Long cid, String idCard, String staffName) {
        StaffBasicInfo info = new StaffBasicInfo();
        info.setRealName(staffName);
        info.setUpdateDate(new Date());
        Example example = new Example(StaffBasicInfo.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("idCard", (Object)SpringEncryptUtils.encrypt((String)idCard));
        ((StaffBasicInfoMapper)this.dao).updateByExampleSelective(info, example);
    }

    public List<StaffBasicInfo> getAllByCid(Long cid) {
        Example e = new Example(StaffBasicInfo.class);
        Example.Criteria c = e.createCriteria();
        c.andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("cid", (Object)cid);
        return this.getListByExample(e);
    }

    public List<StaffBasicInfo> getAllBasicInfoByIdCard(String idCard) {
        Example e = new Example(StaffBasicInfo.class);
        Example.Criteria c = e.createCriteria();
        c.andEqualTo("idCard", (Object)SpringEncryptUtils.encrypt((String)idCard)).andEqualTo("isValid", (Object)Global.TRUE);
        e.orderBy("realName").desc();
        List<StaffBasicInfo> list = this.getListByExample(e);
        if (list != null && list.size() > 0) {
            return list;
        }
        return new ArrayList<StaffBasicInfo>();
    }

    @Transactional
    public void setStaffJobName() {
        List<Long> allCidList = this.staffWorkRoleMapper.getAllCidList();
        if (CollectionUtils.isNotEmpty(allCidList)) {
            List cidList = ListUtil.split(allCidList, (int)3000);
            for (List cids : cidList) {
                List<StaffBasicInfo> staffWorkRoleList = ((StaffBasicInfoMapper)this.dao).getStaffWorkName(cids);
                if (!CollectionUtils.isNotEmpty(staffWorkRoleList)) continue;
                List workNameList = ListUtil.split(staffWorkRoleList, (int)1000);
                for (List list : workNameList) {
                    ((StaffBasicInfoMapper)this.dao).setStaffJobName(list);
                }
            }
        }
    }

    public List<StaffInfoExcelImportVo> getByCidAndIdCard(Long cid, List<String> idCardList) {
        if (CollectionUtils.isEmpty(idCardList)) {
            return Collections.emptyList();
        }
        ArrayList<String> idCardListEsc = new ArrayList<String>();
        idCardList.forEach(i -> idCardListEsc.add(SpringEncryptUtils.encrypt((String)i)));
        return ((StaffBasicInfoMapper)this.dao).getByCidAndIdCard(cid, idCardListEsc);
    }
}

