/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.staff;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.dao.base.staff.StaffAttachmentMapper;
import cn.smarthse.modules.health.entity.base.staff.StaffAttachment;
import cn.smarthse.modules.health.service.base.staff.IStaffAttachmentService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class StaffAttachmentServiceImpl
extends BaseServiceImpl<StaffAttachmentMapper, StaffAttachment>
implements IStaffAttachmentService {
    @Autowired
    StaffAttachmentMapper staffAttachmentMapper;

    public List<StaffAttachment> getStaffAttachmentsByStaffId(Long staffId) {
        Example e = new Example(StaffAttachment.class);
        Example.Criteria c = e.createCriteria();
        c.andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("staffId", (Object)staffId);
        List list = this.staffAttachmentMapper.selectByExample(e);
        return list;
    }

    public StaffAttachment getStaffAttachmentById(Long id) {
        StaffAttachment s = (StaffAttachment)this.getById(id);
        return s;
    }

    public PageInfo<StaffAttachment> getStaffAttachmentsDataByStaffId(JqGridParam jparam, Long staffInfoId) {
        Example e = new Example(StaffAttachment.class);
        Example.Criteria c = e.createCriteria();
        c.andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("staffId", (Object)staffInfoId);
        PageHelper.startPage((int)jparam.getPage(), (int)jparam.getRows());
        List list = this.staffAttachmentMapper.selectByExample(e);
        return new PageInfo(list);
    }

    @Transactional(readOnly=false)
    public StaffAttachment addStaffAttachmentSubmit(StaffAttachment staffAttachment, Long loginStaffId, Long cid) {
        staffAttachment = this.add(staffAttachment, loginStaffId, cid);
        return staffAttachment;
    }

    @Transactional(readOnly=false)
    public void editStaffAttachmentSubmit(StaffAttachment staffAttachment, Long loginStaffId, Long cid) {
        this.update(staffAttachment, loginStaffId);
    }

    @Transactional(readOnly=false)
    public void deleteStaffAttachmentById(Long id, Long loginStaffId, Long cid) {
        StaffAttachment staffAttachment = new StaffAttachment();
        staffAttachment.setId(id);
        staffAttachment.setIsValid(Global.FALSE);
        this.update(staffAttachment, loginStaffId);
    }
}

