/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.staff;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.entity.base.company.CompanyOrganization;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicWork;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffInfoSearchParam;
import cn.smarthse.modules.health.entity.base.staff.StaffOccupationHealth;
import cn.smarthse.modules.health.entity.base.staff.StaffShowInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffWorkRole;
import cn.smarthse.modules.health.entity.base.workinfo.WorkRoleInfo;
import cn.smarthse.modules.health.enums.staff.StaffFurloughStatusEnum;
import cn.smarthse.modules.health.enums.staff.StaffWorkChangeStatusRecordEnum;
import cn.smarthse.modules.health.enums.staff.StaffWorkPropertyEnum;
import cn.smarthse.modules.health.service.base.company.ICompanyOrganizationService;
import cn.smarthse.modules.health.service.base.staff.IHuaDongStaffImportService;
import cn.smarthse.modules.health.service.base.staff.IStaffBasicInfoService;
import cn.smarthse.modules.health.service.base.staff.IStaffBasicWorkService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.base.staff.IStaffOccupationHealthService;
import cn.smarthse.modules.health.service.base.staff.IStaffWorkRoleService;
import cn.smarthse.modules.health.service.base.workinfo.IWorkRoleInfoService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckCountService;
import cn.smarthse.modules.health.service.work.informmanager.INoInformStaffService;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=false)
public class HuaDongStaffImportServiceImpl
implements IHuaDongStaffImportService {
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    @Autowired
    IStaffInfoService staffInfoService;
    @Autowired
    IStaffBasicInfoService staffBasicInfoService;
    @Autowired
    IStaffBasicWorkService staffBasicWorkService;
    @Autowired
    ICompanyOrganizationService companyOrganizationService;
    @Autowired
    IWorkRoleInfoService workRoleInfoService;
    @Autowired
    IStaffWorkRoleService staffWorkRoleService;
    @Autowired
    private IPhcPhysicalCheckCountService phcPhysicalCheckCountService;
    @Autowired
    private IStaffOccupationHealthService staffOccupationHealthService;
    @Autowired
    private INoInformStaffService noInformStaffService;

    public StaffInfo addHuaDongStaff(StaffInfo staffInfo) {
        staffInfo.setOrgId(staffInfo.getStaffBasicWork().getCompanyOrganization().getId());
        if (StringUtils.isNotEmpty((String)staffInfo.getStaffBasicWork().getCurrentStaffWorkRole().getWorkRoleInfo().getWorkName())) {
            List works = this.workRoleInfoService.getWorkInfoListWorkNameAndOrgId(staffInfo.getStaffBasicWork().getCurrentStaffWorkRole().getWorkRoleInfo().getWorkName(), staffInfo.getStaffBasicWork().getCompanyOrganization().getId(), staffInfo.getCid());
            if (works != null && works.size() > 0) {
                staffInfo.getStaffBasicWork().getCurrentStaffWorkRole().setWorkRoleId(((WorkRoleInfo)works.get(0)).getId());
                staffInfo.getStaffBasicWork().getCurrentStaffWorkRole().setWorkRoleInfo((WorkRoleInfo)works.get(0));
            } else {
                staffInfo.getStaffBasicWork().getCurrentStaffWorkRole().getWorkRoleInfo().setOrgId(staffInfo.getStaffBasicWork().getCompanyOrganization().getId());
                this.workRoleInfoService.add((Object)staffInfo.getStaffBasicWork().getCurrentStaffWorkRole().getWorkRoleInfo());
                staffInfo.getStaffBasicWork().getCurrentStaffWorkRole().setWorkRoleId(staffInfo.getStaffBasicWork().getCurrentStaffWorkRole().getWorkRoleInfo().getId());
            }
        }
        this.staffBasicInfoService.add((Object)staffInfo.getStaffBasicInfo());
        staffInfo.setStaffBasicId(staffInfo.getStaffBasicInfo().getId());
        staffInfo.setIsThirdParty(Global.FALSE);
        StaffWorkChangeStatusRecordEnum workChangeRecord = StaffWorkChangeStatusRecordEnum.getThisEnumByFlag((String)("0" + staffInfo.getStaffBasicWork().getCurrentStaffWorkRole().getStatus()));
        if (workChangeRecord != null) {
            staffInfo.setWorkChangeStatusRecord(workChangeRecord.getValue());
            if (staffInfo.getWorkChangeStatusRecord() == StaffWorkChangeStatusRecordEnum.NOSTATUS_TO_FURLOUGH.getValue()) {
                staffInfo.setFurloughStatus(StaffFurloughStatusEnum.FURLOUGHING.getCode());
            }
        }
        this.staffInfoService.add((Object)staffInfo);
        staffInfo.getStaffBasicWork().setStaffId(staffInfo.getId());
        this.staffBasicWorkService.add((Object)staffInfo.getStaffBasicWork());
        staffInfo.getStaffBasicWork().getCurrentStaffWorkRole().setStaffId(staffInfo.getId());
        staffInfo.getStaffBasicWork().getCurrentStaffWorkRole().setIsHistory(Global.FALSE);
        staffInfo.getStaffBasicWork().getCurrentStaffWorkRole().setWorkProperty(StaffWorkPropertyEnum.MAJOR.getValue());
        staffInfo.getStaffBasicWork().getCurrentStaffWorkRole().setIsThirdParty(Global.FALSE);
        this.staffWorkRoleService.add((Object)staffInfo.getStaffBasicWork().getCurrentStaffWorkRole());
        StaffWorkRole curHistoryStaffWorkRole = new StaffWorkRole();
        curHistoryStaffWorkRole.setCid(staffInfo.getCid());
        curHistoryStaffWorkRole.setBeginTime(staffInfo.getStaffBasicWork().getCurrentStaffWorkRole().getBeginTime());
        curHistoryStaffWorkRole.setIsHistory(Boolean.valueOf(true));
        curHistoryStaffWorkRole.setIsThirdParty(staffInfo.getStaffBasicWork().getCurrentStaffWorkRole().getIsThirdParty());
        curHistoryStaffWorkRole.setLeaveTime(staffInfo.getStaffBasicWork().getCurrentStaffWorkRole().getLeaveTime());
        curHistoryStaffWorkRole.setStaffId(staffInfo.getStaffBasicWork().getCurrentStaffWorkRole().getStaffId());
        curHistoryStaffWorkRole.setStatus(staffInfo.getStaffBasicWork().getCurrentStaffWorkRole().getStatus());
        curHistoryStaffWorkRole.setWorkProperty(StaffWorkPropertyEnum.WORKED.getValue());
        curHistoryStaffWorkRole.setWorkRoleId(staffInfo.getStaffBasicWork().getCurrentStaffWorkRole().getWorkRoleId());
        this.staffWorkRoleService.add((Object)curHistoryStaffWorkRole);
        StaffOccupationHealth health = new StaffOccupationHealth();
        health.setFileNo("ZW-GRJK-" + staffInfo.getId());
        health.setStaffId(staffInfo.getId());
        health.setFilingTime(this.phcPhysicalCheckCountService.getStaffFirstCheckBeginTime(staffInfo.getId()));
        this.staffOccupationHealthService.add((Object)health);
        return staffInfo;
    }

    public StaffInfo getHuaDongStaffById(Long id) {
        return null;
    }

    public StaffInfo updateHuaDongStaff(StaffInfo staffInfo) {
        StaffBasicWork dbWork;
        StaffBasicInfo dbStaffBasicInfo;
        staffInfo.setOrgId(staffInfo.getStaffBasicWork().getCompanyOrganization().getId());
        StaffInfo dbStaffInfo = (StaffInfo)this.staffInfoService.getById(staffInfo.getId());
        if (!(dbStaffInfo == null || dbStaffInfo.getStaffBasicId() == null || (dbStaffBasicInfo = (StaffBasicInfo)this.staffBasicInfoService.getById(dbStaffInfo.getStaffBasicId())) == null || dbStaffBasicInfo.getRealName().equals(staffInfo.getStaffBasicInfo().getRealName()) && ("" + dbStaffBasicInfo.getGender()).equals("" + staffInfo.getStaffBasicInfo().getGender()))) {
            staffInfo.getStaffBasicInfo().setId(dbStaffBasicInfo.getId());
            this.staffBasicInfoService.update((Object)staffInfo.getStaffBasicInfo());
        }
        if (!("" + dbStaffInfo.getOrgId()).equals("" + staffInfo.getOrgId())) {
            this.staffInfoService.update((Object)staffInfo);
        }
        if ((dbWork = this.staffBasicWorkService.getStaffBasicWorkByStaffId(staffInfo.getId())) != null && staffInfo.getStaffBasicWork().getOrgId() != null && !staffInfo.getStaffBasicWork().getOrgId().equals(dbWork.getOrgId())) {
            staffInfo.getStaffBasicWork().setId(dbWork.getId());
            this.staffBasicWorkService.update((Object)staffInfo.getStaffBasicWork());
        }
        return dbStaffInfo;
    }

    @Transactional(readOnly=true)
    public StaffInfo getStaffInfoByWorkNo(String workNo, Long cid) {
        if (StringUtils.isEmpty((CharSequence)workNo)) {
            this.logger.info("\u5de5\u53f7\u4e3a\u7a7a\uff01");
            return null;
        }
        StaffInfo staffInfo = this.staffInfoService.getStaffInfoByWorkNo(workNo.trim(), cid);
        if (staffInfo == null) {
            this.logger.info("\u67e5\u65e0\u6b64\u4eba");
            return new StaffInfo();
        }
        return staffInfo;
    }

    public CompanyOrganization getCompanyOrganizationByCode(Long cid, String code) {
        return this.companyOrganizationService.companyOrganizationService(cid, code);
    }

    public CompanyOrganization addCompanyOrganizationByCode(CompanyOrganization org) {
        return this.companyOrganizationService.addCompanyOrganization(org);
    }

    public void upateCompanyOrganization(CompanyOrganization comOrg) {
        this.companyOrganizationService.update((Object)comOrg);
    }

    @Transactional(readOnly=true)
    public List<CompanyOrganization> getAllCompanyOrganizations(Long cid) {
        return this.companyOrganizationService.getAllCompanyOrganizations(cid);
    }

    public List<CompanyOrganization> getAllCompanyOrganizationsHasCode(Long cid) {
        return this.companyOrganizationService.getAllCompanyOrganizationsHasCode(cid);
    }

    @Transactional(readOnly=false)
    public void upateCompanyOrganizationIncludeNull(CompanyOrganization co) {
        this.companyOrganizationService.upateCompanyOrganizationIncludeNull(co);
    }

    public List<StaffShowInfo> getAllStaffInfoNotIncludeNullWorkNo(Long cid) {
        StaffInfoSearchParam param = new StaffInfoSearchParam();
        param.setCid(cid);
        List list = this.staffInfoService.getStaffInfoListByParam(param);
        return list.stream().filter(s -> StringUtils.isNotEmpty((String)s.getWorkNo()) && !s.getWorkNo().equals("A2")).collect(Collectors.toList());
    }

    @Transactional(readOnly=false)
    public void updateCurrentStaffWorkRoleNotWorkedByStaffId(Long staffId) {
        this.staffWorkRoleService.updateCurrentStaffWorkRoleNotWorkedByStaffId(staffId);
    }
}

