/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.staff;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.dao.base.staff.ExistChangeReviewMapper;
import cn.smarthse.modules.health.dao.base.staff.ExistChangeReviewRecordMapper;
import cn.smarthse.modules.health.entity.base.company.CompanyOrganization;
import cn.smarthse.modules.health.entity.base.staff.ExistChangeReview;
import cn.smarthse.modules.health.entity.base.staff.ExistChangeReviewRecord;
import cn.smarthse.modules.health.entity.base.staff.ExistChangeReviewSearchParam;
import cn.smarthse.modules.health.entity.base.staff.StaffExistChangeParam;
import cn.smarthse.modules.health.entity.base.staff.StaffExistChangeVo;
import cn.smarthse.modules.health.entity.base.staff.StaffFieldChangeLog;
import cn.smarthse.modules.health.entity.base.staff.vo.ExistChangeReviewVo;
import cn.smarthse.modules.health.entity.sys.SysUser;
import cn.smarthse.modules.health.enums.staff.StaffFieldChangeEnum;
import cn.smarthse.modules.health.enums.staff.StaffRadiationEnum;
import cn.smarthse.modules.health.service.base.company.ICompanyOrganizationService;
import cn.smarthse.modules.health.service.base.staff.IExistChangeReviewService;
import cn.smarthse.modules.health.service.base.staff.IStaffFieldChangeLogService;
import cn.smarthse.modules.health.service.sys.ISysUserService;
import cn.smarthse.snowflake.IdWorker;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.apache.curator.shaded.com.google.common.collect.Lists;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class ExistChangeReviewServiceImpl
extends BaseServiceImpl<ExistChangeReviewMapper, ExistChangeReview>
implements IExistChangeReviewService {
    @Autowired
    protected IdWorker idworker;
    @Autowired
    private ExistChangeReviewRecordMapper existChangeReviewRecordMapper;
    @Autowired
    private IStaffFieldChangeLogService staffFieldChangeLogService;
    @DubboReference
    private ISysFileProvideService sysFileService;
    @Autowired
    private ISysUserService sysUserService;
    @Autowired
    private ICompanyOrganizationService companyOrganizationService;

    @Transactional
    public List<ExistChangeReview> draughtsStaffInfoExistChange(StaffExistChangeParam param) {
        Set<Long> idList;
        List existChangeReviews = param.getExistChangeReviews();
        if (CollectionUtil.isEmpty((Collection)existChangeReviews)) {
            return null;
        }
        Set<Long> staffInfoIdSet = existChangeReviews.stream().filter(e -> ObjectUtil.isNotNull((Object)e.getStaffInfoId())).map(ExistChangeReview::getStaffInfoId).collect(Collectors.toSet());
        if (CollectionUtil.isEmpty(staffInfoIdSet)) {
            return null;
        }
        Integer changeType = param.getChangeType();
        if (ObjectUtil.isNull((Object)changeType)) {
            throw new HealthException("\u672a\u6307\u5b9a\u53d8\u66f4\u7c7b\u578b\uff01");
        }
        Example example = new Example(ExistChangeReview.class);
        example.selectProperties(new String[]{"id"});
        example.createCriteria().andEqualTo("cid", (Object)param.getCid()).andEqualTo("state", (Object)0).andEqualTo("isValid", (Object)true).andNotIn("staffInfoId", staffInfoIdSet);
        List listByExample = this.getListByExample(example);
        if (CollectionUtil.isNotEmpty(listByExample) && CollectionUtil.isNotEmpty(idList = listByExample.stream().filter(e -> ObjectUtil.isNotNull((Object)e.getId())).map(ExistChangeReview::getId).collect(Collectors.toSet()))) {
            ((ExistChangeReviewMapper)this.dao).removeStaffInfoExistChange(idList);
            ((ExistChangeReviewMapper)this.dao).removeStaffInfoExistChangeRecord(idList, param.getUserId());
        }
        List<Long> staffIds = ((ExistChangeReviewMapper)this.dao).selectNoDraughtsStaffInfoId(staffInfoIdSet, changeType);
        Map changeTimeMap = existChangeReviews.stream().filter(e -> ObjectUtil.isNotNull((Object)e.getStaffInfoId())).collect(HashMap::new, (map, review) -> map.put(review.getStaffInfoId(), review.getChangeTime()), HashMap::putAll);
        if (CollectionUtil.isNotEmpty(staffIds)) {
            Long cid = param.getCid();
            Long userId = param.getUserId();
            Date date = new Date();
            ArrayList<ExistChangeReview> addExistChangeReviewList = new ArrayList<ExistChangeReview>();
            for (Long staffId : staffIds) {
                ExistChangeReview existChangeReview = new ExistChangeReview();
                existChangeReview.setId(Long.valueOf(this.idworker.nextId()));
                existChangeReview.setCid(cid);
                existChangeReview.setStaffInfoId(staffId);
                existChangeReview.setOperator(userId);
                existChangeReview.setOperateTime(date);
                existChangeReview.setState(Integer.valueOf(0));
                existChangeReview.setChangeType(changeType);
                existChangeReview.setCreateDate(date);
                existChangeReview.setUpdateDate(date);
                existChangeReview.setCreateBy(userId);
                existChangeReview.setUpdateBy(userId);
                existChangeReview.setIsValid(Boolean.TRUE);
                addExistChangeReviewList.add(existChangeReview);
            }
            if (CollectionUtil.isNotEmpty(addExistChangeReviewList)) {
                ((ExistChangeReviewMapper)this.dao).insertList2(addExistChangeReviewList);
                this.syncExistChangeReviewRecord(addExistChangeReviewList);
            }
            if (MapUtil.isNotEmpty((Map)changeTimeMap)) {
                for (ExistChangeReview existChangeReview : addExistChangeReviewList) {
                    existChangeReview.setChangeTime((Date)changeTimeMap.get(existChangeReview.getStaffInfoId()));
                }
            }
            return addExistChangeReviewList;
        }
        return null;
    }

    @Transactional
    public void syncExistChangeReviewRecord(List<ExistChangeReview> existChangeReviewList) {
        if (CollectionUtil.isEmpty(existChangeReviewList)) {
            return;
        }
        ArrayList<ExistChangeReviewRecord> addExistChangeReviewRecordList = new ArrayList<ExistChangeReviewRecord>();
        for (ExistChangeReview existChangeReview : existChangeReviewList) {
            ExistChangeReviewRecord existChangeReviewRecord = new ExistChangeReviewRecord();
            BeanUtil.copyProperties((Object)existChangeReview, (Object)existChangeReviewRecord, (String[])new String[0]);
            existChangeReviewRecord.setReviewId(existChangeReview.getId());
            existChangeReviewRecord.setId(Long.valueOf(this.idworker.nextId()));
            existChangeReviewRecord.setCreateBy(existChangeReview.getUpdateBy());
            existChangeReviewRecord.setCreateDate(existChangeReview.getUpdateDate());
            addExistChangeReviewRecordList.add(existChangeReviewRecord);
        }
        if (CollectionUtil.isNotEmpty(addExistChangeReviewRecordList)) {
            this.existChangeReviewRecordMapper.insertList2(addExistChangeReviewRecordList);
        }
    }

    @Transactional
    public void changeStatusStaffInfoExistChange(StaffExistChangeParam param) {
        List existChangeReviews = param.getExistChangeReviews();
        if (CollectionUtil.isEmpty((Collection)existChangeReviews)) {
            return;
        }
        Integer state = param.getState();
        Integer changeType = param.getChangeType();
        Long reviewMaterials = param.getReviewMaterials();
        Long userId = param.getUserId();
        String reason = param.getReason();
        if (ObjectUtil.isNull((Object)state)) {
            throw new HealthException("\u53d8\u66f4\u72b6\u6001\u672a\u786e\u5b9a\uff01");
        }
        if (ObjectUtil.isNull((Object)changeType)) {
            throw new HealthException("\u53d8\u66f4\u7c7b\u578b\u672a\u786e\u5b9a\uff01");
        }
        if (changeType == 1 && ObjectUtil.isNull((Object)reviewMaterials) && state == 1) {
            throw new HealthException("\u53d8\u66f4\u4e3a\u975e\u653e\u5c04\u5de5\u4f5c\u4eba\u5458\u9700\u8981\u4f50\u8bc1\u6750\u6599\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)reason) && state == 2) {
            throw new HealthException("\u9000\u56de\u65f6\u539f\u56e0\u5fc5\u586b\uff01");
        }
        Map changeTimeMap = existChangeReviews.stream().filter(e -> ObjectUtil.isNotNull((Object)e.getId())).collect(HashMap::new, (map, review) -> map.put(review.getId(), review.getChangeTime()), HashMap::putAll);
        if (MapUtil.isNotEmpty((Map)changeTimeMap)) {
            Boolean hasNullValue;
            if (state == 1 && (hasNullValue = Boolean.valueOf(changeTimeMap.values().stream().anyMatch(Objects::isNull))).booleanValue()) {
                throw new HealthException("\u5b58\u5728\u53d8\u66f4\u65f6\u95f4\u672a\u786e\u5b9a\uff01");
            }
            Set<Long> idList = changeTimeMap.keySet();
            Date date = new Date();
            if (CollectionUtil.isNotEmpty(idList)) {
                ArrayList<Long> staffIdList = new ArrayList<Long>();
                List<ExistChangeReview> existChangeReviewsList = ((ExistChangeReviewMapper)this.dao).selectByIdList(idList, changeType);
                ArrayList<StaffFieldChangeLog> logList = new ArrayList<StaffFieldChangeLog>();
                for (ExistChangeReview existChangeReview : existChangeReviewsList) {
                    StaffFieldChangeLog log;
                    existChangeReview.setOperator(userId);
                    if (state == 1) {
                        existChangeReview.setChangeTime((Date)changeTimeMap.get(existChangeReview.getId()));
                        existChangeReview.setReviewMaterials(reviewMaterials);
                    } else if (state == 2 || state == 3) {
                        existChangeReview.setReason(reason);
                    }
                    if (ObjectUtil.isNull((Object)existChangeReview.getChangeTime())) {
                        existChangeReview.setChangeTime((Date)changeTimeMap.get(existChangeReview.getId()));
                    }
                    existChangeReview.setOperateTime(date);
                    existChangeReview.setState(state);
                    existChangeReview.setUpdateBy(userId);
                    existChangeReview.setUpdateDate(date);
                    if (changeType == 1 && state == 3) {
                        staffIdList.add(existChangeReview.getStaffInfoId());
                        log = new StaffFieldChangeLog();
                        log.setStaffId(existChangeReview.getStaffInfoId());
                        log.setCid(existChangeReview.getCid());
                        log.setBeforeInfo(StaffRadiationEnum.getRadiationStr((Boolean)Boolean.FALSE));
                        log.setAfterInfo(StaffRadiationEnum.getRadiationStr((Boolean)Boolean.TRUE));
                        log.setField(StaffFieldChangeEnum.RADIATION_STAFF.getCode());
                        logList.add(log);
                        continue;
                    }
                    if (changeType != 0 || state != 3) continue;
                    staffIdList.add(existChangeReview.getStaffInfoId());
                    log = new StaffFieldChangeLog();
                    log.setStaffId(existChangeReview.getStaffInfoId());
                    log.setCid(existChangeReview.getCid());
                    log.setBeforeInfo(StaffRadiationEnum.getRadiationStr((Boolean)Boolean.TRUE));
                    log.setAfterInfo(StaffRadiationEnum.getRadiationStr((Boolean)Boolean.FALSE));
                    log.setField(StaffFieldChangeEnum.RADIATION_STAFF.getCode());
                    logList.add(log);
                }
                if (CollectionUtil.isNotEmpty(existChangeReviewsList)) {
                    Integer count = this.batchUpdateOrInsert(existChangeReviewsList, ExistChangeReviewMapper.class, (item, mapper) -> mapper.updateByPrimaryKeySelective(item), 1000);
                    if (count.intValue() != existChangeReviewsList.size()) {
                        throw new HealthException("\u5ba1\u6838\u4fee\u6539\u51fa\u9519");
                    }
                    this.syncExistChangeReviewRecord(existChangeReviewsList);
                }
                if (CollectionUtil.isNotEmpty(staffIdList) && state == 3 && (changeType == 1 || changeType == 0)) {
                    List partition = Lists.partition(staffIdList, (int)500);
                    for (List longs : partition) {
                        ((ExistChangeReviewMapper)this.dao).updateRadiationByEcrIds(longs, 1 - changeType, userId);
                    }
                }
                if (CollectionUtil.isNotEmpty(logList)) {
                    this.staffFieldChangeLogService.addChangeLogList(logList, userId);
                }
            }
        } else {
            throw new HealthException("\u9009\u4e2d\u7684\u53d8\u66f4\u5ba1\u6838\u65e0\u6548\uff01");
        }
    }

    public PageInfo<StaffExistChangeVo> listData(JqGridParam jParam, StaffExistChangeParam param) {
        PageHelper.startPage((int)jParam.getPage(), (int)jParam.getRows());
        List<StaffExistChangeVo> list = ((ExistChangeReviewMapper)this.dao).selectExistChangeReviewInfo(param);
        for (StaffExistChangeVo s : list) {
            if (s.getOrgId() == null) continue;
            CompanyOrganization org = (CompanyOrganization)this.companyOrganizationService.getById(s.getOrgId());
            s.setOrgName(org == null ? null : org.getOrganizationName());
        }
        return new PageInfo(list);
    }

    public List<StaffExistChangeVo> getStaffInfoExistChangeRecord(Long staffId) {
        if (ObjectUtil.isNull((Object)staffId)) {
            return new ArrayList<StaffExistChangeVo>();
        }
        List<StaffExistChangeVo> staffExistChangeVos = ((ExistChangeReviewMapper)this.dao).selectStaffInfoExistChangeRecord(staffId);
        for (StaffExistChangeVo staffExistChangeVo : staffExistChangeVos) {
            SysUser sysUser;
            Long reviewMaterials = staffExistChangeVo.getReviewMaterials();
            if (ObjectUtil.isNotNull((Object)reviewMaterials)) {
                SysFileModel file = this.sysFileService.getFileById(reviewMaterials);
                staffExistChangeVo.setFileModel(file);
            }
            String operatorName = staffExistChangeVo.getOperatorName();
            Long operator = staffExistChangeVo.getOperator();
            if (!StringUtils.isEmpty((CharSequence)operatorName) || !ObjectUtil.isNotNull((Object)operator) || !ObjectUtil.isNotNull((Object)(sysUser = (SysUser)this.sysUserService.getById(operator)))) continue;
            staffExistChangeVo.setOperatorName(sysUser.getUsername());
        }
        return staffExistChangeVos;
    }

    @Transactional
    public void removeStaffInfoExistChange(StaffExistChangeParam param) {
        Long userId = param.getUserId();
        List existChangeReviews = param.getExistChangeReviews();
        if (CollectionUtil.isEmpty((Collection)existChangeReviews)) {
            return;
        }
        Set<Long> idList = existChangeReviews.stream().filter(e -> ObjectUtil.isNotNull((Object)e.getId())).map(ExistChangeReview::getId).collect(Collectors.toSet());
        if (CollectionUtil.isNotEmpty(idList)) {
            ((ExistChangeReviewMapper)this.dao).removeStaffInfoExistChange(idList);
            ((ExistChangeReviewMapper)this.dao).removeStaffInfoExistChangeRecord(idList, userId);
        }
    }

    public ResponseData<ExistChangeReviewVo> existChange(Long id) {
        ExistChangeReviewVo existChangeReview = ((ExistChangeReviewMapper)this.dao).existChangeReview(id);
        return ResponseData.success((Object)existChangeReview);
    }

    @Transactional
    public ResponseData fishExistChangeReview(ExistChangeReview param) {
        int change = ((ExistChangeReviewMapper)this.dao).fishExistChangeReview(param);
        this.logger.info("\u5b8c\u6210\u5ba1\u6838\uff0c\u66f4\u65b0\u6570\uff1a{}", (Object)change);
        return ResponseData.success();
    }

    public PageInfo<ExistChangeReviewVo> existChangeReviewRecord(JqGridParam pageParam, ExistChangeReviewSearchParam param) {
        PageHelper.startPage((int)pageParam.getPage(), (int)pageParam.getRows());
        List<ExistChangeReviewVo> existChangeReviewRecords = this.existChangeReviewRecordMapper.selectExistChangeReviewRecord(param);
        return new PageInfo(existChangeReviewRecords);
    }
}

