/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.staff;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.model.supervise.CompanyVictimsInfo;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByVictimsInfoService;
import cn.smarthse.modules.health.dao.base.staff.CompanyRadiationAbnormalReportMapper;
import cn.smarthse.modules.health.entity.base.staff.CompanyRadiationAbnormalReport;
import cn.smarthse.modules.health.service.base.staff.ICompanyRadiationAbnormalReportService;
import cn.smarthse.modules.health.supervise.service.staff.ISuperviseStaffInfoService;
import cn.smarthse.services.hfi.api.entity.riskev.RiskExposeEvaluate;
import cn.smarthse.services.hfi.api.service.riskev.IRiskExposeEvaluateService;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.apache.dubbo.rpc.RpcContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@DubboService
@Transactional(readOnly=true)
public class CompanyRadiationAbnormalReportServiceImpl
extends BaseServiceImpl<CompanyRadiationAbnormalReportMapper, CompanyRadiationAbnormalReport>
implements ICompanyRadiationAbnormalReportService {
    @DubboReference
    private ISuperviseStaffInfoService superviseStaffInfoService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideByVictimsInfoService victimsInfoService;
    @DubboReference
    private IRiskExposeEvaluateService riskExposeEvaluateService;
    @Autowired(required=false)
    DataSourceTransactionManager transactionManager;

    public void updateCompanyRadiationAbnormalReport(List<Long> cids) {
        block6: {
            List<Long> cidList = ((CompanyRadiationAbnormalReportMapper)this.dao).selectAllCidList(cids);
            if (CollectionUtil.isEmpty(cidList)) {
                return;
            }
            List cidsList = ListUtil.partition(cidList, (int)2000);
            this.updateBatch(cidsList);
            if (CollectionUtil.isNotEmpty(cidList) && CollectionUtil.isEmpty(cids)) {
                TransactionStatus status = null;
                try {
                    if (this.transactionManager != null) {
                        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
                        def.setPropagationBehavior(3);
                        status = this.transactionManager.getTransaction((TransactionDefinition)def);
                        this.logger.info("\u4e8b\u52a1\u72b6\u6001\uff1a{}", (Object)status.toString());
                    }
                    RpcContext.getContext().setAttachment("skip_sensitive_log", "true");
                    ((CompanyRadiationAbnormalReportMapper)this.dao).delNotUpdateList(cidList);
                    if (status != null) {
                        this.transactionManager.commit(status);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (status == null) break block6;
                    this.transactionManager.rollback(status);
                    this.logger.error("\u5f02\u5e38\u62a5\u8868\u4e8b\u52a1\u56de\u6eda");
                }
            }
        }
    }

    private void updateBatch(List<List<Long>> cidsList) {
        if (CollectionUtil.isEmpty(cidsList)) {
            return;
        }
        for (List<Long> cids : cidsList) {
            List<Company> companies = ((CompanyRadiationAbnormalReportMapper)this.dao).selectCompanyInfoByCidList(cids);
            Map<Long, Company> companyMap = companies.stream().collect(Collectors.toMap(Company::getId, company -> company, (c1, c2) -> c1));
            if (MapUtil.isEmpty(companyMap)) continue;
            Date date = new Date();
            Map staffRadiationMap = this.superviseStaffInfoService.getStaffInfoRadiationCountByCids(cids);
            ArrayList<CompanyRadiationAbnormalReport> companyRadiationAbnormalReportList = new ArrayList<CompanyRadiationAbnormalReport>();
            List identifyRealNumListByCids = this.victimsInfoService.getIdentifyRealNumListByCids(cids);
            HashMap<Long, CompanyVictimsInfo> companyVictimsInfoMap = new HashMap<Long, CompanyVictimsInfo>();
            if (CollectionUtil.isNotEmpty((Collection)identifyRealNumListByCids)) {
                companyVictimsInfoMap.putAll(identifyRealNumListByCids.stream().filter(c -> ObjectUtil.isNotNull((Object)c.getCid())).collect(Collectors.toMap(CompanyVictimsInfo::getCid, CompanyVictimsInfo2 -> CompanyVictimsInfo2, (c1, c2) -> c1)));
            }
            HashMap<Long, RiskExposeEvaluate> exposeEvaluateMap = new HashMap<Long, RiskExposeEvaluate>();
            List riskExposeEvaluates = this.riskExposeEvaluateService.getTouchHarmPeopleNumber(cids);
            if (CollectionUtil.isNotEmpty((Collection)riskExposeEvaluates)) {
                exposeEvaluateMap.putAll(riskExposeEvaluates.stream().filter(r -> ObjectUtil.isNotNull((Object)r.getCid())).collect(Collectors.toMap(RiskExposeEvaluate::getCid, r -> r, (first, second) -> first)));
            }
            for (Long cid : cids) {
                Company company2;
                CompanyRadiationAbnormalReport companyRadiationAbnormalReport = new CompanyRadiationAbnormalReport();
                companyRadiationAbnormalReport.setId(cid);
                companyRadiationAbnormalReport.setIsValid(Boolean.TRUE);
                companyRadiationAbnormalReport.setIsAbnormalRadiation(Integer.valueOf(0));
                companyRadiationAbnormalReport.setIsAbnormalStaffCountLess(Integer.valueOf(0));
                companyRadiationAbnormalReport.setIsAbnormalDetectionRecognition(Integer.valueOf(0));
                Long staffCount = null;
                if (MapUtil.isNotEmpty((Map)staffRadiationMap)) {
                    staffCount = (Long)staffRadiationMap.get(cid);
                }
                if (ObjectUtil.isNotNull((Object)(company2 = companyMap.get(cid)))) {
                    if (ObjectUtil.isNotNull((Object)company2.getIsExistRadioactivity()) && company2.getIsExistRadioactivity().booleanValue()) {
                        if (ObjectUtil.isNull((Object)staffCount) || staffCount == 0L) {
                            companyRadiationAbnormalReport.setIsAbnormalRadiation(Integer.valueOf(1));
                        }
                    } else if (ObjectUtil.isNotNull((Object)staffCount) && staffCount > 0L) {
                        companyRadiationAbnormalReport.setIsAbnormalRadiation(Integer.valueOf(1));
                    }
                    Integer contactNum = null;
                    Integer staffCountType = null;
                    Integer jgNum = null;
                    Date jgUpdateDate = null;
                    Integer victimsIdentify = company2.getVictimsIdentify();
                    CompanyVictimsInfo companyVictimsInfo = (CompanyVictimsInfo)companyVictimsInfoMap.get(cid);
                    if (ObjectUtil.isNotNull((Object)companyVictimsInfo) && ObjectUtil.isNotNull((Object)victimsIdentify) && (victimsIdentify == 1 || victimsIdentify == 2)) {
                        jgNum = companyVictimsInfo.getIdentifyRealNum();
                        jgUpdateDate = companyVictimsInfo.getIdentifyRealTime();
                    }
                    LocalDateTime checkDateEnd = null;
                    Integer workNum = null;
                    RiskExposeEvaluate riskExposeEvaluate = (RiskExposeEvaluate)exposeEvaluateMap.get(cid);
                    if (ObjectUtil.isNotNull((Object)riskExposeEvaluate)) {
                        checkDateEnd = riskExposeEvaluate.getCheckDateEnd();
                        workNum = riskExposeEvaluate.getWorkNum();
                    }
                    if (ObjectUtil.isNotNull((Object)jgUpdateDate) && ObjectUtil.isNotNull((Object)checkDateEnd)) {
                        long localDateTimeMillis;
                        long dateMillis = jgUpdateDate.getTime();
                        if (dateMillis < (localDateTimeMillis = checkDateEnd.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli())) {
                            staffCountType = 2;
                            contactNum = workNum;
                        } else {
                            staffCountType = 1;
                            contactNum = jgNum;
                        }
                    } else if (ObjectUtil.isNotNull((Object)jgUpdateDate)) {
                        staffCountType = 1;
                        contactNum = jgNum;
                    } else if (ObjectUtil.isNotNull((Object)checkDateEnd)) {
                        staffCountType = 2;
                        contactNum = workNum;
                    }
                    if (ObjectUtil.isNotNull((Object)contactNum) && ObjectUtil.isNotNull((Object)company2.getStaffCount()) && ObjectUtil.isNotNull((Object)staffCountType) && company2.getStaffCount() < contactNum) {
                        companyRadiationAbnormalReport.setIsAbnormalStaffCountLess(staffCountType);
                    }
                    if ((ObjectUtil.isNull((Object)victimsIdentify) || victimsIdentify == 0) && (ObjectUtil.isNull((Object)workNum) || workNum == 0)) {
                        companyRadiationAbnormalReport.setIsAbnormalDetectionRecognition(Integer.valueOf(1));
                    }
                }
                companyRadiationAbnormalReport.setUpdateDate(date);
                companyRadiationAbnormalReport.setCreateDate(date);
                companyRadiationAbnormalReportList.add(companyRadiationAbnormalReport);
            }
            if (!CollectionUtil.isNotEmpty(companyRadiationAbnormalReportList)) continue;
            TransactionStatus status = null;
            try {
                if (this.transactionManager != null) {
                    DefaultTransactionDefinition def = new DefaultTransactionDefinition();
                    def.setPropagationBehavior(3);
                    status = this.transactionManager.getTransaction((TransactionDefinition)def);
                    this.logger.info("\u4e8b\u52a1\u72b6\u6001\uff1a{}", (Object)status.toString());
                }
                RpcContext.getContext().setAttachment("skip_sensitive_log", "true");
                ((CompanyRadiationAbnormalReportMapper)this.dao).updateBatch(companyRadiationAbnormalReportList);
                if (status == null) continue;
                this.transactionManager.commit(status);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (status == null) continue;
                this.transactionManager.rollback(status);
                this.logger.error("\u5f02\u5e38\u62a5\u8868\u4e8b\u52a1\u56de\u6eda");
            }
        }
    }

    public List<CompanyRadiationAbnormalReport> selectAbnormalReportByCidList(List<Long> cids) {
        if (CollectionUtil.isEmpty(cids)) {
            return new ArrayList<CompanyRadiationAbnormalReport>();
        }
        return ((CompanyRadiationAbnormalReportMapper)this.dao).selectAbnormalReportByCidList(cids);
    }

    @Transactional
    public void updateCompanyRadioByStaff(List<Long> cids) {
        ((CompanyRadiationAbnormalReportMapper)this.dao).updateCompanyRadioByStaff(cids);
    }
}

