/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.staff;

import cn.smarthse.common.util.IDCardUtil;
import cn.smarthse.common.util.passwordLog.StringUtils;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.dao.base.company.CompanyOrganizationMapper;
import cn.smarthse.modules.health.dao.base.staff.BatchAddStaffInfoMapper;
import cn.smarthse.modules.health.dao.base.staff.StaffBasicInfoMapper;
import cn.smarthse.modules.health.dao.base.staff.StaffBasicWorkMapper;
import cn.smarthse.modules.health.dao.base.staff.StaffInfoMapper;
import cn.smarthse.modules.health.dao.base.staff.StaffWorkRoleMapper;
import cn.smarthse.modules.health.dao.base.workinfo.WorkRoleInfoMapper;
import cn.smarthse.modules.health.entity.base.company.CompanyOrganization;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffFieldChangeLog;
import cn.smarthse.modules.health.entity.base.workinfo.WorkRoleInfo;
import cn.smarthse.modules.health.enums.staff.StaffFieldChangeEnum;
import cn.smarthse.modules.health.model.staff.BatchAddStaffModel;
import cn.smarthse.modules.health.model.staff.StaffBasicQueryModel;
import cn.smarthse.modules.health.service.base.company.ICompanyOrganizationService;
import cn.smarthse.modules.health.service.base.staff.IBatchAddStaffService;
import cn.smarthse.modules.health.service.base.staff.IStaffBasicInfoService;
import cn.smarthse.modules.health.service.base.staff.IStaffBasicWorkService;
import cn.smarthse.modules.health.service.base.staff.IStaffFieldChangeLogService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.base.staff.IStaffWorkRoleService;
import cn.smarthse.modules.health.service.base.workinfo.IWorkRoleInfoService;
import cn.smarthse.snowflake.IdWorker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
public class BatchAddStaffServiceImpl
implements IBatchAddStaffService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BatchAddStaffServiceImpl.class);
    @Autowired
    private BatchAddStaffInfoMapper batchAddStaffInfoMapper;
    @Autowired
    private IStaffInfoService staffInfoService;
    @Autowired
    private IStaffBasicInfoService staffBasicInfoService;
    @Autowired
    private ICompanyOrganizationService organizationService;
    @Autowired
    private IStaffWorkRoleService staffWorkRoleService;
    @Autowired
    private IStaffBasicWorkService staffBasicWorkService;
    @Autowired
    private IWorkRoleInfoService workRoleInfoService;
    @Autowired
    private IdWorker idworker;
    @Autowired
    private BatchAddStaffServiceImpl self;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaService;
    @Autowired
    private IStaffFieldChangeLogService staffFieldChangeLogService;

    public List<StaffBasicQueryModel> checkStaffModel(List<StaffBasicQueryModel> addStaffModelList) {
        return this.batchAddStaffInfoMapper.listStaffBasic(addStaffModelList);
    }

    private void checkOranization(List<BatchAddStaffModel> addStaffModelList) {
        List validList = addStaffModelList.stream().filter(model -> model.getOrganization() != null && StringUtils.isNotBlank((CharSequence)model.getOrganization().getOrganizationName())).collect(Collectors.toList());
        Set cidSet = validList.stream().map(BatchAddStaffModel::getCid).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(cidSet)) {
            return;
        }
        Map companyOrganizationMap = this.organizationService.getAllCompanyOrganizationByCids(cidSet);
        for (BatchAddStaffModel batchAddStaffModel : validList) {
            Long cid = batchAddStaffModel.getCid();
            String key = cid + "-" + batchAddStaffModel.getOrganization().getOrganizationName();
            CompanyOrganization companyOrganization = (CompanyOrganization)companyOrganizationMap.get(key);
            if (companyOrganization == null) {
                batchAddStaffModel.getOrganization().setNewAdd(Boolean.valueOf(true));
                continue;
            }
            batchAddStaffModel.setOrgId(companyOrganization.getId());
            batchAddStaffModel.getOrganization().setNewAdd(Boolean.valueOf(false));
        }
    }

    private void checkStaffIdBasicInfoId(List<BatchAddStaffModel> validAddStaffModelList, Map<String, StaffBasicQueryModel> cidIdcardMap) {
        Set idCardSet = validAddStaffModelList.stream().map(BatchAddStaffModel::getStaffBasicInfo).map(StaffBasicInfo::getIdCard).collect(Collectors.toSet());
        Map idCardMap = this.sysAreaService.getNativePlaceByIdCards(idCardSet);
        for (BatchAddStaffModel batchAddStaffModel : validAddStaffModelList) {
            StaffBasicInfo staffBasicInfo;
            String idCard;
            Long cid = batchAddStaffModel.getCid();
            StaffBasicQueryModel dbStaffInfo = cidIdcardMap.get(cid + "-" + (idCard = batchAddStaffModel.getStaffBasicInfo().getIdCard()));
            if (dbStaffInfo != null) {
                String jobName;
                StaffFieldChangeLog staffFieldChangeLog;
                if (dbStaffInfo.getStaffId() != null) {
                    batchAddStaffModel.setStaffId(dbStaffInfo.getStaffId());
                    batchAddStaffModel.setOldSourceId(dbStaffInfo.getSourceId());
                    batchAddStaffModel.getStaffInfo().setNewAdd(Boolean.valueOf(false));
                }
                if (dbStaffInfo.getStaffBasicId() != null) {
                    batchAddStaffModel.setStaffBasicId(dbStaffInfo.getStaffBasicId());
                    batchAddStaffModel.getStaffBasicInfo().setNewAdd(Boolean.valueOf(false));
                }
                if (dbStaffInfo.getStaffWorkRoleId() != null) {
                    batchAddStaffModel.setStaffWorkRoleId(dbStaffInfo.getStaffWorkRoleId());
                    if (batchAddStaffModel.getStaffWorkRole() != null) {
                        batchAddStaffModel.getStaffWorkRole().setNewAdd(Boolean.valueOf(false));
                        Byte workRoleStatus = dbStaffInfo.getStaffWorkRoleStatus();
                        if (!Objects.equals(workRoleStatus, batchAddStaffModel.getStaffWorkRole().getStatus())) {
                            staffFieldChangeLog = new StaffFieldChangeLog();
                            staffFieldChangeLog.setStaffId(dbStaffInfo.getStaffId());
                            staffFieldChangeLog.setCid(dbStaffInfo.getCid());
                            staffFieldChangeLog.setBeforeInfo(workRoleStatus == null ? "" : String.valueOf(workRoleStatus));
                            staffFieldChangeLog.setAfterInfo(batchAddStaffModel.getStaffWorkRole().getStatus() == null ? "" : String.valueOf(batchAddStaffModel.getStaffWorkRole().getStatus()));
                            staffFieldChangeLog.setField(StaffFieldChangeEnum.WORK_ROLE_STATUS.getCode());
                            staffFieldChangeLog.setChangeReason("\u4e2a\u4eba\u5242\u91cf\u6570\u636e\u53d8\u66f4");
                            batchAddStaffModel.getStaffFieldChangeLogList().add(staffFieldChangeLog);
                        }
                    }
                }
                if (dbStaffInfo.getWorkRoleInfoId() != null) {
                    batchAddStaffModel.setWorkRoleInfoId(dbStaffInfo.getWorkRoleInfoId());
                    if (batchAddStaffModel.getWorkRoleInfo() != null) {
                        batchAddStaffModel.getWorkRoleInfo().setNewAdd(Boolean.valueOf(false));
                    }
                }
                if (dbStaffInfo.getStaffBasicWorkId() != null) {
                    batchAddStaffModel.setStaffBasicWorkId(dbStaffInfo.getStaffBasicWorkId());
                    if (batchAddStaffModel.getStaffBasicWork() != null) {
                        batchAddStaffModel.getStaffBasicWork().setNewAdd(Boolean.valueOf(false));
                    }
                }
                if (!Objects.equals(jobName = dbStaffInfo.getJobName(), batchAddStaffModel.getStaffBasicInfo().getJobName())) {
                    staffFieldChangeLog = new StaffFieldChangeLog();
                    staffFieldChangeLog.setStaffId(dbStaffInfo.getStaffId());
                    staffFieldChangeLog.setCid(dbStaffInfo.getCid());
                    staffFieldChangeLog.setBeforeInfo(jobName);
                    staffFieldChangeLog.setAfterInfo(batchAddStaffModel.getStaffBasicInfo().getJobName());
                    staffFieldChangeLog.setField(StaffFieldChangeEnum.JOB_NAME.getCode());
                    staffFieldChangeLog.setChangeReason("\u4e2a\u4eba\u5242\u91cf\u6570\u636e\u53d8\u66f4");
                    batchAddStaffModel.getStaffFieldChangeLogList().add(staffFieldChangeLog);
                }
            }
            if (!StringUtils.isBlank((CharSequence)(staffBasicInfo = batchAddStaffModel.getStaffBasicInfo()).getNativePlace())) continue;
            if (StringUtils.isNotEmpty((String)staffBasicInfo.getIdCard()) && IDCardUtil.isIDCard((String)staffBasicInfo.getIdCard())) {
                String nativePlace = (String)idCardMap.get(staffBasicInfo.getIdCard().substring(0, 6) + "000000");
                staffBasicInfo.setNativePlace(nativePlace);
                continue;
            }
            log.info("\u8eab\u4efd\u8bc1\u683c\u5f0f\u6709\u8bef\uff1a{},id:{}", (Object)staffBasicInfo.getIdCard(), (Object)staffBasicInfo.getId());
        }
    }

    private void checkWorkRoleInfo(List<BatchAddStaffModel> validAddStaffModelList) {
        Stream<BatchAddStaffModel> batchAddStaffModelStream = validAddStaffModelList.stream().filter(batchAddStaffModel -> batchAddStaffModel.getWorkRoleInfo() != null);
        Set cidSet = batchAddStaffModelStream.map(BatchAddStaffModel::getCid).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(cidSet)) {
            return;
        }
        Map workRoleInfoMap = this.workRoleInfoService.getAllWorkRoleInfoByCids(cidSet);
        for (BatchAddStaffModel batchAddStaffModel2 : validAddStaffModelList) {
            String workName;
            String orgId;
            Long cid = batchAddStaffModel2.getCid();
            String key = cid + "-" + (orgId = batchAddStaffModel2.getOrganization() != null ? batchAddStaffModel2.getOrganization().getId().toString() : "") + "-" + (workName = batchAddStaffModel2.getWorkRoleInfo().getWorkName());
            WorkRoleInfo workRoleInfo = (WorkRoleInfo)workRoleInfoMap.get(key);
            if (workRoleInfo == null) continue;
            batchAddStaffModel2.setWorkRoleInfoId(workRoleInfo.getId());
            batchAddStaffModel2.getWorkRoleInfo().setNewAdd(Boolean.valueOf(false));
        }
    }

    private void checkStaffBasicWork(List<BatchAddStaffModel> validAddStaffModelList) {
        Stream<BatchAddStaffModel> batchAddStaffModelStream = validAddStaffModelList.stream().filter(batchAddStaffModel -> batchAddStaffModel.getStaffBasicWork() != null);
        Map<Long, Long> staffIdBasicWorkIdMap = batchAddStaffModelStream.collect(Collectors.toMap(k -> k.getStaffBasicWork().getStaffId(), v -> v.getStaffBasicWork().getId()));
        if (MapUtils.isEmpty(staffIdBasicWorkIdMap)) {
            return;
        }
        validAddStaffModelList.stream().filter(batchAddStaffModel -> batchAddStaffModel.getStaffBasicWork() != null).peek(p -> {
            if (staffIdBasicWorkIdMap.containsKey(p.getStaffBasicWork().getStaffId())) {
                p.getStaffBasicWork().setNewAdd(Boolean.valueOf(false));
            }
        });
    }

    private List<BatchAddStaffModel> docheckBatchSave(List<BatchAddStaffModel> addStaffModelList) {
        List<BatchAddStaffModel> validAddStaffModelList = addStaffModelList.stream().filter(f -> f != null && f.getStaffInfo() != null && f.getStaffBasicInfo() != null && StringUtils.isNotBlank((CharSequence)f.getStaffBasicInfo().getIdCard()) && StringUtils.isNotBlank((CharSequence)f.getStaffBasicInfo().getRealName()) && f.getCid() != null && f.getAddFrom() != null && f.getDataSource() != null).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(validAddStaffModelList)) {
            log.error("\u6279\u91cf\u6dfb\u52a0\u5458\u5de5\u4fe1\u606f\uff0c\u6709\u6548\u6570\u636e\u4e3a\u7a7a");
            return null;
        }
        Set<StaffBasicQueryModel> mapperQueryList = validAddStaffModelList.stream().map(m -> {
            StaffBasicQueryModel param = new StaffBasicQueryModel();
            param.setCid(m.getCid());
            param.setStaffIdCard(SpringEncryptUtils.encrypt((String)m.getStaffBasicInfo().getIdCard()));
            return param;
        }).collect(Collectors.toSet());
        List<StaffBasicQueryModel> staffBasicQueryModels = this.batchAddStaffInfoMapper.listStaffBasic(mapperQueryList);
        HashMap<String, StaffBasicQueryModel> cidIdcardMap = new HashMap();
        if (CollectionUtils.isNotEmpty(staffBasicQueryModels)) {
            cidIdcardMap = staffBasicQueryModels.stream().collect(Collectors.toMap(k -> k.getCid() + "-" + k.getStaffIdCard(), v -> v, (v1, v2) -> v1));
        }
        Iterator iterator = validAddStaffModelList.iterator();
        while (iterator.hasNext()) {
            BatchAddStaffModel f2 = (BatchAddStaffModel)iterator.next();
            String cidIdcard = f2.getCid() + "-" + f2.getStaffBasicInfo().getIdCard();
            if (!Objects.equals(f2.getStaffInfo().getIsValid(), false)) continue;
            Long staffSourceId = f2.getStaffInfo().getSourceId();
            if (!cidIdcardMap.containsKey(cidIdcard)) {
                iterator.remove();
            } else {
                StaffBasicQueryModel staffBasicQueryModel = (StaffBasicQueryModel)cidIdcardMap.get(cidIdcard);
                String dbStaffSourceId = staffBasicQueryModel.getSourceId();
                if (!Objects.equals(String.valueOf(staffSourceId), dbStaffSourceId)) {
                    iterator.remove();
                }
            }
            if (f2.getStaffWorkRole() != null) {
                f2.getStaffWorkRole().setIsValid(Boolean.valueOf(false));
            }
            if (f2.getStaffBasicWork() == null) continue;
            f2.getStaffBasicWork().setIsValid(Boolean.valueOf(false));
        }
        if (CollectionUtils.isEmpty(validAddStaffModelList)) {
            log.error("\u53bb\u6389\u65e0\u6548\u7684\u6570\u636e\u540e\uff0c\u6709\u6548\u6570\u636e\u4e3a\u7a7a");
            return null;
        }
        for (BatchAddStaffModel batchAddStaffModel : validAddStaffModelList) {
            batchAddStaffModel.setStaffId(Long.valueOf(this.idworker.nextId()));
            batchAddStaffModel.setStaffBasicId(Long.valueOf(this.idworker.nextId()));
            batchAddStaffModel.setOrgId(Long.valueOf(this.idworker.nextId()));
            batchAddStaffModel.setWorkRoleInfoId(Long.valueOf(this.idworker.nextId()));
            batchAddStaffModel.setStaffBasicWorkId(Long.valueOf(this.idworker.nextId()));
            batchAddStaffModel.setStaffWorkRoleId(Long.valueOf(this.idworker.nextId()));
        }
        this.checkOranization(validAddStaffModelList);
        this.checkStaffIdBasicInfoId(validAddStaffModelList, cidIdcardMap);
        this.checkWorkRoleInfo(validAddStaffModelList);
        this.checkStaffBasicWork(validAddStaffModelList);
        return validAddStaffModelList;
    }

    public List<BatchAddStaffModel> batchSave(List<BatchAddStaffModel> addStaffModelList) {
        if (CollectionUtils.isEmpty(addStaffModelList)) {
            return null;
        }
        List<BatchAddStaffModel> checkedBatchAddStaffModels = this.docheckBatchSave(addStaffModelList);
        if (CollectionUtils.isEmpty(checkedBatchAddStaffModels)) {
            return null;
        }
        List<BatchAddStaffModel> batchAddStaffModels = this.self.doBatchSave(checkedBatchAddStaffModels);
        return batchAddStaffModels;
    }

    @Transactional(readOnly=false)
    public List<BatchAddStaffModel> doBatchSave(List<BatchAddStaffModel> addStaffModelList) {
        if (CollectionUtils.isEmpty(addStaffModelList)) {
            return addStaffModelList;
        }
        List staffInfoList = addStaffModelList.stream().map(BatchAddStaffModel::getStaffInfo).filter(f -> f != null).collect(Collectors.toList());
        List staffBasicInfoList = addStaffModelList.stream().map(BatchAddStaffModel::getStaffBasicInfo).filter(f -> f != null).collect(Collectors.toList());
        List organizationList = addStaffModelList.stream().map(BatchAddStaffModel::getOrganization).filter(f -> f != null && f.getNewAdd() == true).collect(Collectors.toList());
        List staffBasicWorks = addStaffModelList.stream().map(BatchAddStaffModel::getStaffBasicWork).filter(f -> f != null).collect(Collectors.toList());
        List workRoleInfos = addStaffModelList.stream().map(BatchAddStaffModel::getWorkRoleInfo).filter(f -> f != null).collect(Collectors.toList());
        List staffWorkRoles = addStaffModelList.stream().map(BatchAddStaffModel::getStaffWorkRole).filter(f -> f != null).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(staffInfoList)) {
            this.staffInfoService.batchUpdateOrInsert(staffInfoList, StaffInfoMapper.class, (item, mapper) -> {
                if (Objects.equals(item.getNewAdd(), true)) {
                    item.setCreateDate(new Date());
                    item.setIsValid(Boolean.valueOf(true));
                    item.setCreateBy(Long.valueOf(7760L));
                    return mapper.insert(item);
                }
                if (item.getId() != null) {
                    item.setUpdateDate(new Date());
                    item.setAddFrom(null);
                    item.setDataSource(null);
                    item.setSourceId(null);
                    return mapper.updateByPrimaryKeySelective(item);
                }
                return 0;
            });
        }
        if (CollectionUtils.isNotEmpty(staffBasicInfoList)) {
            this.staffBasicInfoService.batchUpdateOrInsert(staffBasicInfoList, StaffBasicInfoMapper.class, (item, mapper) -> {
                if (Objects.equals(item.getNewAdd(), true)) {
                    item.setCreateDate(new Date());
                    item.setIsValid(Boolean.valueOf(true));
                    return mapper.insertSelective(item);
                }
                if (item.getId() != null) {
                    item.setUpdateDate(new Date());
                    item.setDataSource(null);
                    return mapper.updateByPrimaryKeySelective(item);
                }
                return 0;
            });
        }
        if (CollectionUtils.isNotEmpty(staffBasicWorks)) {
            this.staffBasicWorkService.batchUpdateOrInsert(staffBasicWorks, StaffBasicWorkMapper.class, (item, mapper) -> {
                if (Objects.equals(item.getNewAdd(), true)) {
                    item.setCreateDate(new Date());
                    item.setIsValid(Boolean.valueOf(true));
                    return mapper.insertSelective(item);
                }
                if (item.getId() != null) {
                    item.setUpdateDate(new Date());
                    item.setDataSource(null);
                    return mapper.updateByPrimaryKeySelective(item);
                }
                return 0;
            });
        }
        if (CollectionUtils.isNotEmpty(staffWorkRoles)) {
            this.staffWorkRoleService.batchUpdateOrInsert(staffWorkRoles, StaffWorkRoleMapper.class, (item, mapper) -> {
                if (Objects.equals(item.getNewAdd(), true)) {
                    item.setCreateDate(new Date());
                    item.setIsValid(Boolean.valueOf(true));
                    return mapper.insertSelective(item);
                }
                if (item.getId() != null) {
                    item.setUpdateDate(new Date());
                    item.setDataSource(null);
                    return mapper.updateByPrimaryKeySelective(item);
                }
                return 0;
            });
        }
        if (CollectionUtils.isNotEmpty(workRoleInfos)) {
            this.workRoleInfoService.batchUpdateOrInsert(workRoleInfos, WorkRoleInfoMapper.class, (item, mapper) -> {
                if (Objects.equals(item.getNewAdd(), true)) {
                    item.setCreateDate(new Date());
                    item.setIsValid(Boolean.valueOf(true));
                    return mapper.insertSelective(item);
                }
                if (item.getId() != null) {
                    item.setUpdateDate(new Date());
                    item.setDataSource(null);
                    return mapper.updateByPrimaryKeySelective(item);
                }
                return 0;
            });
        }
        if (CollectionUtils.isNotEmpty(organizationList)) {
            this.organizationService.batchUpdateOrInsert(organizationList, CompanyOrganizationMapper.class, (item, mapper) -> {
                if (Objects.equals(item.getNewAdd(), true)) {
                    item.setCreateDate(new Date());
                    item.setIsValid(Boolean.valueOf(true));
                    return mapper.insertSelective(item);
                }
                if (item.getId() != null) {
                    item.setUpdateDate(new Date());
                    item.setDataSource(null);
                    return mapper.updateByPrimaryKeySelective(item);
                }
                return 0;
            });
        }
        ArrayList staffFieldChangeLogList = new ArrayList();
        for (BatchAddStaffModel batchAddStaffModel : addStaffModelList) {
            if (!CollectionUtils.isNotEmpty((Collection)batchAddStaffModel.getStaffFieldChangeLogList())) continue;
            staffFieldChangeLogList.addAll(batchAddStaffModel.getStaffFieldChangeLogList());
        }
        if (CollectionUtils.isNotEmpty(staffFieldChangeLogList)) {
            this.staffFieldChangeLogService.addChangeLogList(staffFieldChangeLogList, null);
        }
        return addStaffModelList;
    }
}

