/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.selfjudge;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.PageUtil;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.db.common.entity.BaseEntity;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.model.system.IndustryModel;
import cn.smarthse.modules.datacentre.model.system.SysParamModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.datacentre.provider.system.ISysParamProvideService;
import cn.smarthse.modules.datacentre.provider.system.IndustryProvideService;
import cn.smarthse.modules.health.dao.base.selfjudge.SelfInspectionRiskAssessmentReportInfoMapper;
import cn.smarthse.modules.health.entity.base.company.CompanyReportInfo;
import cn.smarthse.modules.health.entity.base.company.grade.CompanyGradeV3;
import cn.smarthse.modules.health.entity.base.selfjudge.CompanyHsePreventionControlSelfJudge;
import cn.smarthse.modules.health.entity.base.selfjudge.OccupationalSelfJudgeV308;
import cn.smarthse.modules.health.entity.base.selfjudge.SelfInspectionRiskAssessmentReportHarm;
import cn.smarthse.modules.health.entity.base.selfjudge.SelfInspectionRiskAssessmentReportHarmJudgeInfo;
import cn.smarthse.modules.health.entity.base.selfjudge.SelfInspectionRiskAssessmentReportInfo;
import cn.smarthse.modules.health.entity.base.selfjudge.SelfInspectionTerm;
import cn.smarthse.modules.health.entity.base.selfjudge.vo.SelfInspectionRiskAssessmentReportForm;
import cn.smarthse.modules.health.entity.base.selfjudge.vo.SelfInspectionRiskAssessmentReportV314Vo;
import cn.smarthse.modules.health.entity.base.selfjudge.vo.SelfInspectionRiskAssessmentReportVo;
import cn.smarthse.modules.health.entity.base.selfjudge.vo.SelfjudgeReportSearchVo;
import cn.smarthse.modules.health.enums.company.CompanySizeEnum;
import cn.smarthse.modules.health.enums.selfjudge.HazardsExposureRiskLevelEnum;
import cn.smarthse.modules.health.enums.selfjudge.HazardsRiskClassifyEnum;
import cn.smarthse.modules.health.enums.selfjudge.JudgeResultLevelEnum;
import cn.smarthse.modules.health.service.base.company.CompanyReportInfoService;
import cn.smarthse.modules.health.service.base.selfjudge.ICompanyHsePreventionControlSelfJudgeService;
import cn.smarthse.modules.health.service.base.selfjudge.IOccupationalSelfJudgeTermV308Service;
import cn.smarthse.modules.health.service.base.selfjudge.IOccupationalSelfJudgeV308Service;
import cn.smarthse.modules.health.service.base.selfjudge.ISelfInspectionRiskAssessmentReportHarmJudgeInfoService;
import cn.smarthse.modules.health.service.base.selfjudge.ISelfInspectionRiskAssessmentReportHarmLevelService;
import cn.smarthse.modules.health.service.base.selfjudge.ISelfInspectionRiskAssessmentReportHarmService;
import cn.smarthse.modules.health.service.base.selfjudge.ISelfInspectionRiskAssessmentReportInfoService;
import cn.smarthse.modules.health.service.base.selfjudge.ISelfInspectionTermService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.supervise.entity.declare.CompanyDeclareInfo;
import cn.smarthse.modules.health.supervise.enums.WorkOperateLogEnum;
import cn.smarthse.modules.health.supervise.service.declare.IDeclareBaseService;
import cn.smarthse.modules.health.supervise.service.operate.IWorkOperateLogService;
import cn.smarthse.modules.health.thirdOrganization.entity.org.ThirdOrganization;
import cn.smarthse.modules.health.thirdOrganization.service.org.IThirdOrganizationService;
import cn.smarthse.modules.health.vo.base.company.gradev3.SelfReportCollectVo;
import cn.smarthse.services.hfi.api.entity.riskev.RiskExposeEvaluate;
import cn.smarthse.services.hfi.api.model.riskev.EvQueryParam;
import cn.smarthse.services.hfi.api.pojo.vo.riskev.RiskDecisionVo;
import cn.smarthse.services.hfi.api.pojo.vo.riskev.RiskExposeEvaluateVo;
import cn.smarthse.services.hfi.api.service.riskev.IRiskExposeEvaluateDataService;
import cn.smarthse.services.hfi.api.service.riskev.IRiskExposeEvaluateService;
import cn.smarthse.util.common.StringUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class SelfInspectionRiskAssessmentReportInfoServiceImpl
extends BaseServiceImpl<SelfInspectionRiskAssessmentReportInfoMapper, SelfInspectionRiskAssessmentReportInfo>
implements ISelfInspectionRiskAssessmentReportInfoService {
    @Autowired(required=false)
    private ISelfInspectionRiskAssessmentReportHarmJudgeInfoService selfInspectionRiskAssessmentReportHarmJudgeInfoService;
    @Autowired(required=false)
    private ISelfInspectionRiskAssessmentReportHarmLevelService selfInspectionRiskAssessmentReportHarmLevelService;
    @Autowired(required=false)
    private ISelfInspectionRiskAssessmentReportHarmService selfInspectionRiskAssessmentReportHarmService;
    @Autowired(required=false)
    private IStaffInfoService staffInfoService;
    @Autowired(required=false)
    private IOccupationalSelfJudgeV308Service occupationalSelfJudgeV308Service;
    @DubboReference(version="1.0.0")
    private ICompanyProvideByHSEService companyProvideByHSEService;
    @DubboReference(version="1.0.0", check=false)
    private ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    @DubboReference(version="1.0.0")
    private ISysParamProvideService sysParamProvideService;
    @DubboReference
    private IWorkOperateLogService workOperateLogService;
    @DubboReference
    private IRiskExposeEvaluateService riskExposeEvaluateService;
    @DubboReference
    private IRiskExposeEvaluateDataService riskExposeEvaluateDataService;
    @Autowired
    private ICompanyHsePreventionControlSelfJudgeService companyHsePreventionControlSelfJudgeService;
    @Autowired(required=false)
    private IOccupationalSelfJudgeTermV308Service occupationalSelfJudgeTermV308Service;
    @Autowired
    private ISelfInspectionTermService selfInspectionTermService;
    @Autowired
    private CompanyReportInfoService companyReportInfoService;
    @Autowired
    private IThirdOrganizationService thirdOrganizationService;
    @DubboReference
    private IDeclareBaseService declareBaseService;
    @DubboReference(version="1.0.0")
    private IndustryProvideService industryProvideService;

    public PageInfo<SelfInspectionRiskAssessmentReportVo> listPageData(JqGridParam jqGridParam) {
        PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows());
        List<SelfInspectionRiskAssessmentReportVo> list = ((SelfInspectionRiskAssessmentReportInfoMapper)this.dao).listData(jqGridParam.getCid());
        list.forEach(s -> {
            if (s.getDataSource() != null && s.getDataSource() == 1 && s.getOperatorStaffId() != null) {
                s.setOperatorStaffName(this.staffInfoService.getStaffNameByStaffId(s.getOperatorStaffId()));
            }
            if (s.getJudgeLevel() != null) {
                s.setJudgeLevelName(JudgeResultLevelEnum.getThisEnumByCode((Integer)s.getJudgeLevel()).getName());
            }
            if (s.getRiskLevel() != null) {
                HazardsExposureRiskLevelEnum riskLevelEnum = HazardsExposureRiskLevelEnum.getThisEnumByCode((Integer)s.getRiskLevel());
                s.setRiskLevelName(riskLevelEnum == null ? null : riskLevelEnum.getName());
            }
            if (s.getRiskClassify() != null) {
                HazardsRiskClassifyEnum riskClassifyEnum = HazardsRiskClassifyEnum.getThisEnumByCode((Integer)s.getRiskClassify());
                s.setRiskClassifyName(riskClassifyEnum == null ? null : riskClassifyEnum.getName());
            }
        });
        return new PageInfo(list);
    }

    public PageInfo<SelfInspectionRiskAssessmentReportVo> listPageDataBySearch(JqGridParam jqGridParam, SelfjudgeReportSearchVo vo) {
        PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows());
        List<SelfInspectionRiskAssessmentReportVo> list = ((SelfInspectionRiskAssessmentReportInfoMapper)this.dao).listDataBySearch(vo);
        list.forEach(s -> {
            if (s.getDataSource() != null && s.getDataSource() == 1 && s.getOperatorStaffId() != null) {
                s.setOperatorStaffName(this.staffInfoService.getStaffNameByStaffId(s.getOperatorStaffId()));
            }
            if (s.getJudgeLevel() != null) {
                s.setJudgeLevelName(JudgeResultLevelEnum.getThisEnumByCode((Integer)s.getJudgeLevel()).getName());
            }
            if (s.getRiskLevel() != null) {
                HazardsExposureRiskLevelEnum riskLevelEnum = HazardsExposureRiskLevelEnum.getThisEnumByCode((Integer)s.getRiskLevel());
                s.setRiskLevelName(riskLevelEnum == null ? null : riskLevelEnum.getName());
            }
            if (s.getRiskClassify() != null) {
                HazardsRiskClassifyEnum riskClassifyEnum = HazardsRiskClassifyEnum.getThisEnumByCode((Integer)s.getRiskClassify());
                s.setRiskClassifyName(riskClassifyEnum == null ? null : riskClassifyEnum.getName());
            }
        });
        return new PageInfo(list);
    }

    public SelfInspectionRiskAssessmentReportVo getVoById(Long id) {
        SelfInspectionRiskAssessmentReportVo vo = new SelfInspectionRiskAssessmentReportVo();
        vo.setReportInfo((SelfInspectionRiskAssessmentReportInfo)this.getById(id));
        if (vo.getReportInfo() != null) {
            SysParamModel economicType;
            IndustryModel industryClassification;
            if (vo.getReportInfo().getIndustryClassification() != null && (industryClassification = this.industryProvideService.getIndustryById(vo.getReportInfo().getIndustryClassification())) != null) {
                vo.setIndustryClassificationName(industryClassification.getCode() + "-" + industryClassification.getName());
            }
            if (vo.getReportInfo().getEconomicType() != null && (economicType = this.sysParamProvideService.getById(vo.getReportInfo().getEconomicType())) != null) {
                vo.setEconomicTypeName(economicType.getParamCode() + "-" + economicType.getParamValue());
            }
        }
        List harms = this.selfInspectionRiskAssessmentReportHarmService.getListByInfoId(id);
        vo.setBiologyHarms(harms.stream().filter(s -> "\u751f\u7269\u56e0\u7d20".equals(s.getHarmType())).collect(Collectors.toList()));
        vo.setBiologyHarmsList(ListUtils.partition((List)vo.getBiologyHarms(), (int)3));
        vo.setBiologyHarmsStaffCount(Long.valueOf(vo.getBiologyHarms().stream().filter(s -> s.getStaffCount() != null).mapToLong(SelfInspectionRiskAssessmentReportHarm::getStaffCount).sum()));
        vo.setDustHarms(harms.stream().filter(s -> "\u7c89\u5c18".equals(s.getHarmType())).collect(Collectors.toList()));
        vo.setDustHarmsList(ListUtils.partition((List)vo.getDustHarms(), (int)3));
        vo.setDustHarmsStaffCount(Long.valueOf(vo.getDustHarms().stream().filter(s -> s.getStaffCount() != null).mapToLong(SelfInspectionRiskAssessmentReportHarm::getStaffCount).sum()));
        vo.setChemicalHarms(harms.stream().filter(s -> "\u5316\u5b66\u56e0\u7d20".equals(s.getHarmType())).collect(Collectors.toList()));
        vo.setChemicalHarmsList(ListUtils.partition((List)vo.getChemicalHarms(), (int)3));
        vo.setChemicalHarmsStaffCount(Long.valueOf(vo.getChemicalHarms().stream().filter(s -> s.getStaffCount() != null).mapToLong(SelfInspectionRiskAssessmentReportHarm::getStaffCount).sum()));
        vo.setRadiationHarms(harms.stream().filter(s -> "\u653e\u5c04\u56e0\u7d20".equals(s.getHarmType())).collect(Collectors.toList()));
        vo.setRadiationHarmsList(ListUtils.partition((List)vo.getRadiationHarms(), (int)3));
        vo.setRadiationHarmsStaffCount(Long.valueOf(vo.getRadiationHarms().stream().filter(s -> s.getStaffCount() != null).mapToLong(SelfInspectionRiskAssessmentReportHarm::getStaffCount).sum()));
        vo.setPhysicsHarms(harms.stream().filter(s -> "\u7269\u7406\u56e0\u7d20".equals(s.getHarmType())).collect(Collectors.toList()));
        vo.setPhysicsHarmsList(ListUtils.partition((List)vo.getPhysicsHarms(), (int)3));
        vo.setPhysicsHarmsStaffCount(Long.valueOf(vo.getPhysicsHarms().stream().filter(s -> s.getStaffCount() != null).mapToLong(SelfInspectionRiskAssessmentReportHarm::getStaffCount).sum()));
        vo.setHarmLevel(this.selfInspectionRiskAssessmentReportHarmLevelService.getEntityByInfoId(id));
        vo.setHarmJudgeInfo(this.selfInspectionRiskAssessmentReportHarmJudgeInfoService.getEntityByInfoId(id));
        if (vo.getHarmJudgeInfo() != null) {
            HazardsExposureRiskLevelEnum riskLevelEnum;
            HazardsRiskClassifyEnum classifyEnum;
            OccupationalSelfJudgeV308 judgeV308;
            if (vo.getHarmJudgeInfo().getJudgeId() != null && (judgeV308 = (OccupationalSelfJudgeV308)this.occupationalSelfJudgeV308Service.getById(vo.getHarmJudgeInfo().getJudgeId())) != null && judgeV308.getJudgeStatus() != null && judgeV308.getJudgeStatus() == 2 && judgeV308.getResultLevel() != null) {
                vo.setJudgeLevel(Integer.valueOf(judgeV308.getResultLevel().intValue()));
                vo.setJudgeLevelName(JudgeResultLevelEnum.getThisEnumByCode((Integer)judgeV308.getResultLevel().intValue()).getName());
            }
            if (vo.getHarmJudgeInfo().getRiskClassify() != null && (classifyEnum = HazardsRiskClassifyEnum.getThisEnumByCode((Integer)vo.getHarmJudgeInfo().getRiskClassify().intValue())) != null) {
                vo.setRiskClassify(Integer.valueOf(vo.getHarmJudgeInfo().getRiskClassify().intValue()));
                vo.setRiskClassifyName(classifyEnum.getName());
            }
            if (vo.getHarmJudgeInfo().getRiskLevel() != null && (riskLevelEnum = HazardsExposureRiskLevelEnum.getThisEnumByCode((Integer)vo.getHarmJudgeInfo().getRiskLevel().intValue())) != null) {
                vo.setRiskLevel(Integer.valueOf(vo.getHarmJudgeInfo().getRiskLevel().intValue()));
                vo.setRiskLevelName(riskLevelEnum.getName());
            }
        }
        return vo;
    }

    @Transactional(readOnly=false)
    public void saveReportSubmit(SelfInspectionRiskAssessmentReportForm form, Long loginStaffId, Long cid) {
        form.getInfo().setIsValid(Boolean.valueOf(true));
        if (form.getInfo().getStatus() != null && form.getInfo().getStatus() == 2) {
            this.workOperateLogService.report(form.getInfo().getId(), WorkOperateLogEnum.selfJudge.getTypeVal(), loginStaffId, form.getOperaterName(), form.getCompanyName());
        }
        this.update(form.getInfo(), loginStaffId);
        ArrayList harms = new ArrayList();
        if (form.getBiologyHarms() != null) {
            harms.addAll(form.getBiologyHarms());
        }
        if (form.getChemicalHarms() != null) {
            harms.addAll(form.getChemicalHarms());
        }
        if (form.getDustHarms() != null) {
            harms.addAll(form.getDustHarms());
        }
        if (form.getPhysicsHarms() != null) {
            harms.addAll(form.getPhysicsHarms());
        }
        if (form.getRadiationHarms() != null) {
            harms.addAll(form.getRadiationHarms());
        }
        harms.forEach(s -> s.setInfoId(form.getInfo().getId()));
        form.getHarmLevel().setInfoId(form.getInfo().getId());
        form.getJudgeInfo().setInfoId(form.getInfo().getId());
        this.selfInspectionRiskAssessmentReportHarmService.addList(harms, loginStaffId, cid);
        this.selfInspectionRiskAssessmentReportHarmLevelService.addEntity(form.getHarmLevel(), loginStaffId, cid);
        this.selfInspectionRiskAssessmentReportHarmJudgeInfoService.addEntity(form.getJudgeInfo(), loginStaffId, cid);
    }

    @Transactional(readOnly=false)
    public void saveSelfReportSubmit(SelfInspectionRiskAssessmentReportForm form, Long loginStaffId, Long cid) {
        SelfInspectionRiskAssessmentReportInfo info;
        SelfInspectionRiskAssessmentReportInfo history;
        form.getInfo().setIsValid(Boolean.valueOf(true));
        if (form.getInfo().getStatus() != null && form.getInfo().getStatus() == 2) {
            this.workOperateLogService.report(form.getInfo().getId(), WorkOperateLogEnum.selfJudge.getTypeVal(), loginStaffId, form.getOperaterName(), form.getCompanyName());
        }
        this.logger.warn("\u6267\u884c\u8bc4\u4f30\u62a5\u544a\u4fdd\u5b58\u64cd\u4f5c\uff0c cid:{}", (Object)cid);
        this.update(form.getInfo(), loginStaffId);
        if (form.getInfo().getStatus() != null && form.getInfo().getStatus() == 2 && (history = (SelfInspectionRiskAssessmentReportInfo)this.getById((info = (SelfInspectionRiskAssessmentReportInfo)this.getById(form.getInfo().getId())).getSourceId())) != null) {
            Long id = history.getId();
            history.setId(info.getId());
            history.setSourceId(id);
            history.setTableFlag(Byte.valueOf((byte)2));
            history.setIsValid(Boolean.valueOf(false));
            info.setId(id);
            info.setSourceId(null);
            info.setTableFlag(null);
            info.setCidYear(history.getCidYear());
            history.setCidYear(null);
            this.updateByPrimaryKey(history, loginStaffId);
            this.updateByPrimaryKey(info, loginStaffId);
            this.workOperateLogService.report(info.getId(), WorkOperateLogEnum.selfJudge.getTypeVal(), loginStaffId, form.getOperaterName(), form.getCompanyName());
        }
        this.companyProvideBySuperviseService.updateAreaIdBycid(cid, form.getInfo().getLocationAddAreaId(), loginStaffId);
        if (cid != null && form.getInfo().getStatus() != null && form.getInfo().getStatus() == 2) {
            CompanyBaseInfoModel baseInfoModel = new CompanyBaseInfoModel();
            baseInfoModel.setId(cid);
            baseInfoModel.setName(form.getInfo().getCompanyName());
            baseInfoModel.setRegisterAddress(form.getInfo().getRegisterAddDetail());
            baseInfoModel.setWorkAddress(form.getInfo().getLocationAddDetail());
            if (form.getInfo().getCompanyScale() != null) {
                baseInfoModel.setScale("" + form.getInfo().getCompanyScale());
            }
            baseInfoModel.setIndustryCategory(form.getInfo().getIndustryClassification());
            baseInfoModel.setRegisterType(form.getInfo().getEconomicType());
            baseInfoModel.setLegalTel(form.getInfo().getContactNumber());
            baseInfoModel.setAreaId(form.getInfo().getLocationAddAreaId());
            if (form.getInfo() != null && form.getInfo().getStaffCount() != null) {
                baseInfoModel.setStaffCount(Integer.valueOf(Math.toIntExact(form.getInfo().getStaffCount())));
            }
            this.companyProvideByHSEService.updateCompanyBaseInfoModel(baseInfoModel, loginStaffId);
            CompanyReportInfo reportInfo = new CompanyReportInfo();
            BeanUtils.copyProperties((Object)form.getInfo(), (Object)reportInfo);
            List fileList = form.getSetUpFileList();
            if (CollectionUtils.isNotEmpty((Collection)fileList)) {
                reportInfo.setManageOrgFiles(StringUtils.join((Iterable)fileList, (String)","));
            }
            reportInfo.setId(null);
            this.companyReportInfoService.addCompanyReportInfo(reportInfo, loginStaffId, cid, null);
        }
    }

    @Transactional(readOnly=false)
    public void deleteReport(Long id, Long loginStaffId) {
        if (id != null) {
            SelfInspectionRiskAssessmentReportInfo info = new SelfInspectionRiskAssessmentReportInfo();
            info.setId(id);
            this.delete(info, loginStaffId);
            SelfInspectionRiskAssessmentReportInfo info1 = (SelfInspectionRiskAssessmentReportInfo)this.getById(id);
            if (info1.getSelfReportId() != null && Byte.valueOf("2").equals(info1.getReportFromYear()) && StringUtils.isNotEmpty((String)info1.getChangeReason()) && info1.getChangeReason().contains("2")) {
                CompanyHsePreventionControlSelfJudge selfJudge = (CompanyHsePreventionControlSelfJudge)this.companyHsePreventionControlSelfJudgeService.getById(info1.getSelfReportId());
                if (Byte.valueOf("1").equals(selfJudge.getStatus()) || Byte.valueOf("2").equals(selfJudge.getStatus())) {
                    this.companyHsePreventionControlSelfJudgeService.deleteSelfJudge(info1.getSelfReportId(), loginStaffId);
                }
            }
        }
    }

    @Transactional(readOnly=false)
    public void deleteSelfReport(Long id, Long loginStaffId) {
        if (id != null) {
            SelfInspectionRiskAssessmentReportInfo info = new SelfInspectionRiskAssessmentReportInfo();
            info.setId(id);
            this.delete(info, loginStaffId);
        }
    }

    @Transactional(readOnly=false)
    public SelfInspectionRiskAssessmentReportInfo addNotIsValid(Long cid, Long loginStaffId) {
        SelfInspectionRiskAssessmentReportInfo reportInfo = new SelfInspectionRiskAssessmentReportInfo();
        reportInfo.setCid(cid);
        reportInfo.setDataSource(Byte.valueOf((byte)1));
        reportInfo.setStatus(Byte.valueOf((byte)1));
        reportInfo.setIsValid(Boolean.valueOf(false));
        reportInfo.setCreateBy(loginStaffId);
        reportInfo.setUpdateBy(loginStaffId);
        reportInfo.setUpdateDate(new Date());
        reportInfo.setCreateDate(new Date());
        reportInfo.setIsValid(Boolean.valueOf(false));
        ((SelfInspectionRiskAssessmentReportInfoMapper)this.dao).insertSelective(reportInfo);
        return reportInfo;
    }

    @Transactional(readOnly=false)
    public void giveUpJudge(Long reportInfoId, Long loginStaffId) {
        SelfInspectionRiskAssessmentReportHarmJudgeInfo judgeInfo = this.selfInspectionRiskAssessmentReportHarmJudgeInfoService.getEntityByInfoId(reportInfoId);
        if (judgeInfo != null && judgeInfo.getJudgeId() != null) {
            judgeInfo.setJudgeId(null);
            this.selfInspectionRiskAssessmentReportHarmJudgeInfoService.updateByPrimaryKey((Object)judgeInfo, loginStaffId);
        }
    }

    public List<SelfInspectionRiskAssessmentReportVo> listDataEveryCidLatestByDateRange(Date beginDate, Date endDate) {
        List<SelfInspectionRiskAssessmentReportVo> list = ((SelfInspectionRiskAssessmentReportInfoMapper)this.dao).listDataEveryCidLatestByDateRange(beginDate, endDate, ((SelfInspectionRiskAssessmentReportInfoMapper)this.dao).selectCount(new SelfInspectionRiskAssessmentReportInfo()));
        list.forEach(s -> {
            if (s.getDataSource() != null && s.getDataSource() == 1 && s.getOperatorStaffId() != null) {
                s.setOperatorStaffName(this.staffInfoService.getStaffNameByStaffId(s.getOperatorStaffId()));
            }
            if (s.getJudgeLevel() != null) {
                s.setJudgeLevelName(JudgeResultLevelEnum.getThisEnumByCode((Integer)s.getJudgeLevel()).getName());
            }
            if (s.getRiskLevel() != null) {
                HazardsExposureRiskLevelEnum riskLevelEnum = HazardsExposureRiskLevelEnum.getThisEnumByCode((Integer)s.getRiskLevel());
                s.setRiskLevelName(riskLevelEnum == null ? null : riskLevelEnum.getName());
            }
            if (s.getRiskClassify() != null) {
                HazardsRiskClassifyEnum riskClassifyEnum = HazardsRiskClassifyEnum.getThisEnumByCode((Integer)s.getRiskClassify());
                s.setRiskClassifyName(riskClassifyEnum == null ? null : riskClassifyEnum.getName());
            }
        });
        return list;
    }

    public List<SelfInspectionRiskAssessmentReportInfo> listDataV314EveryCidLatestForSuperviseByDateRange(Date beginDate, Date endDate, List<Long> cids) {
        List<SelfInspectionRiskAssessmentReportInfo> reportInfoList = null;
        reportInfoList = CollectionUtils.isNotEmpty(cids) ? ((SelfInspectionRiskAssessmentReportInfoMapper)this.dao).listDataV314EveryCidLatestForSuperviseByDateRange(beginDate, endDate, cids, 100000) : ((SelfInspectionRiskAssessmentReportInfoMapper)this.dao).listDataV314EveryCidLatestForSuperviseByDateRange(beginDate, endDate, cids, ((SelfInspectionRiskAssessmentReportInfoMapper)this.dao).selectCount(new SelfInspectionRiskAssessmentReportInfo()));
        return reportInfoList;
    }

    public List<SelfInspectionRiskAssessmentReportVo> listAllData() {
        List<SelfInspectionRiskAssessmentReportVo> list = ((SelfInspectionRiskAssessmentReportInfoMapper)this.dao).listDataEveryCidLatestByDateRange(null, null, ((SelfInspectionRiskAssessmentReportInfoMapper)this.dao).selectCount(new SelfInspectionRiskAssessmentReportInfo()));
        return list;
    }

    public PageInfo<SelfInspectionRiskAssessmentReportV314Vo> listPageDataV314(JqGridParam jqGridParam) {
        PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows());
        List<SelfInspectionRiskAssessmentReportV314Vo> list = ((SelfInspectionRiskAssessmentReportInfoMapper)this.dao).listDataV314(jqGridParam.getCid());
        list.forEach(s -> {
            CompanyHsePreventionControlSelfJudge selfJudge;
            RiskExposeEvaluate riskExposeEvaluate;
            if (s.getDataSource() != null && s.getDataSource() == 1 && s.getOperatorStaffId() != null) {
                s.setOperatorStaffName(this.staffInfoService.getStaffNameByStaffId(s.getOperatorStaffId()));
            }
            if (s.getExposureReportId() != null && (riskExposeEvaluate = (RiskExposeEvaluate)this.riskExposeEvaluateService.getById((Serializable)s.getExposureReportId())) != null && riskExposeEvaluate.getRiskLevel() != null) {
                s.setRiskLevel(riskExposeEvaluate.getRiskLevel());
            }
            if (s.getSelfReportId() != null && (selfJudge = (CompanyHsePreventionControlSelfJudge)this.companyHsePreventionControlSelfJudgeService.getById(s.getSelfReportId())) != null && selfJudge.getJudgeLevel() != null) {
                s.setJudgeLevel(Integer.valueOf(selfJudge.getJudgeLevel().intValue()));
            }
            if (s.getJudgeLevel() != null) {
                s.setJudgeLevelName(JudgeResultLevelEnum.getThisEnumByCode((Integer)s.getJudgeLevel()).getName());
            }
            if (s.getRiskLevel() != null) {
                HazardsExposureRiskLevelEnum riskLevelEnum = HazardsExposureRiskLevelEnum.getThisEnumByCode((Integer)s.getRiskLevel());
                s.setRiskLevelName(riskLevelEnum == null ? null : riskLevelEnum.getName());
            }
            if (s.getJudgeLevel() != null && s.getRiskLevel() != null) {
                HazardsRiskClassifyEnum riskClassifyEnum = HazardsRiskClassifyEnum.getThisEnumByJudgeLevelAndRiskLevel((JudgeResultLevelEnum)JudgeResultLevelEnum.getThisEnumByCode((Integer)s.getJudgeLevel()), (HazardsExposureRiskLevelEnum)HazardsExposureRiskLevelEnum.getThisEnumByCode((Integer)s.getRiskLevel()));
                s.setRiskClassify(riskClassifyEnum == null ? null : riskClassifyEnum.getCode());
                s.setRiskClassifyName(riskClassifyEnum == null ? null : riskClassifyEnum.getName());
            }
        });
        return new PageInfo(list);
    }

    @Transactional(readOnly=false)
    public synchronized SelfInspectionRiskAssessmentReportInfo addThisYearSelfInspectionRiskAssessmentReport(Long loginStaffCompanyId, Long loginStaffId) {
        int year = DateUtils.getThisYear();
        SelfInspectionRiskAssessmentReportInfo reportInfo = this.getThisYearSelfInspectionRiskAssessmentReportByCid(year, loginStaffCompanyId);
        try {
            if (reportInfo == null) {
                CompanyHsePreventionControlSelfJudge selfJudge;
                RiskExposeEvaluate riskExposeEvaluate;
                reportInfo = new SelfInspectionRiskAssessmentReportInfo();
                reportInfo.setCidYear("" + loginStaffCompanyId + year);
                reportInfo.setCid(loginStaffCompanyId);
                reportInfo.setYear(Long.valueOf(year));
                reportInfo.setReportFromYear(Byte.valueOf((byte)1));
                reportInfo.setSelfTime(new Date());
                reportInfo.setStatus(Byte.valueOf((byte)1));
                reportInfo.setDataSource(Byte.valueOf((byte)1));
                reportInfo.setIsValid(Boolean.valueOf(true));
                reportInfo.setSelfTime(new Date());
                CompanyBaseInfoModel cim = this.companyProvideByHSEService.getCompanyById(loginStaffCompanyId);
                reportInfo.setCompanyName(cim.getName());
                reportInfo.setRegisterAddDetail(cim.getRegisterAddress());
                reportInfo.setLocationAddDetail(cim.getWorkAddress());
                reportInfo.setCompanyScale(StringUtils.isNumber((String)cim.getScale()) ? Long.valueOf(cim.getScale()) : null);
                reportInfo.setIndustryClassification(cim.getIndustryCategory());
                reportInfo.setEconomicType(cim.getRegisterType());
                reportInfo.setContactNumber(cim.getLegalTel());
                reportInfo.setUniformSocialCreditCode(cim.getUnifiedSocialCc());
                reportInfo.setSuperiorUnit(cim.getFatherDept());
                reportInfo.setLocationAddAreaId(cim.getAreaDetailId());
                CompanyReportInfo companyReportInfo = this.companyReportInfoService.getCompanyReportInfoByCid(loginStaffCompanyId);
                if (companyReportInfo != null) {
                    reportInfo.setManageOrg(companyReportInfo.getManageOrg());
                    reportInfo.setManageMajorStaffCount(companyReportInfo.getManageMajorStaffCount());
                    reportInfo.setManagePluralityStaffCount(companyReportInfo.getManagePluralityStaffCount());
                    reportInfo.setStaffCount(companyReportInfo.getStaffCount());
                    reportInfo.setHarmStaffCount(companyReportInfo.getHarmStaffCount());
                    reportInfo.setDiseaseOnWorkStaffCount(companyReportInfo.getDiseaseOnWorkStaffCount());
                    CompanyDeclareInfo companyDeclareInfo = this.declareBaseService.getCompanyDeclareInfo(loginStaffCompanyId);
                    reportInfo.setDiseaseStaffCount(Long.valueOf(companyDeclareInfo != null && companyDeclareInfo.getOccupationalDiseasesNum() != null ? companyDeclareInfo.getOccupationalDiseasesNum().longValue() : 0L));
                    reportInfo.setCheckGoWorkStaffCount(companyReportInfo.getCheckGoWorkStaffCount());
                    reportInfo.setCheckGoWorkStaffRealCount(companyReportInfo.getCheckGoWorkStaffRealCount());
                    reportInfo.setCheckOnWorkStaffCount(companyReportInfo.getCheckOnWorkStaffCount());
                    reportInfo.setCheckOnWorkStaffRealCount(companyReportInfo.getCheckOnWorkStaffRealCount());
                    reportInfo.setCheckLeaveWorkStaffCount(companyReportInfo.getCheckLeaveWorkStaffCount());
                    reportInfo.setCheckLeaveWorkStaffRealCount(companyReportInfo.getCheckLeaveWorkStaffRealCount());
                }
                if ((riskExposeEvaluate = this.riskExposeEvaluateService.getLatestNeedReportEv(loginStaffCompanyId)) != null) {
                    reportInfo.setExposureReportId(riskExposeEvaluate.getId());
                }
                if ((selfJudge = this.companyHsePreventionControlSelfJudgeService.getLatestEntityNoStatusByCid(loginStaffCompanyId)) != null) {
                    reportInfo.setSelfReportId(selfJudge.getId());
                }
                reportInfo = this.add(reportInfo, loginStaffId, loginStaffCompanyId);
            }
        }
        catch (Exception e) {
            this.logger.info("\u521b\u5efa\u62a5\u544a\u5931\u8d25!" + e.getMessage());
        }
        return reportInfo;
    }

    public PageInfo<RiskExposeEvaluateVo> pageRiskExposeEvaluateVo(EvQueryParam param) {
        Long cid = param.getCid();
        RiskExposeEvaluate riskExposeEvaluate = null;
        List<SelfInspectionRiskAssessmentReportInfo> lastNewReportList = this.listDataV314EveryCidLatestForSuperviseByDateRange(null, null, Arrays.asList(cid));
        if (CollectionUtils.isNotEmpty(lastNewReportList)) {
            SelfInspectionRiskAssessmentReportInfo reportInfo = lastNewReportList.get(0);
            if (Objects.equals(reportInfo.getStatus(), (byte)1)) {
                if (Byte.valueOf("2").equals(reportInfo.getReportFromYear()) && StringUtils.isNotEmpty((String)reportInfo.getChangeReason()) && reportInfo.getChangeReason().contains("1") || Byte.valueOf("1").equals(reportInfo.getReportFromYear())) {
                    riskExposeEvaluate = this.riskExposeEvaluateService.getLatestNeedReportEv(reportInfo.getCid());
                } else if (Byte.valueOf("2").equals(reportInfo.getReportFromYear())) {
                    if (reportInfo.getExposureReportId() == null && reportInfo.getChangeFromId() != null && (beforeReport = (SelfInspectionRiskAssessmentReportInfo)this.getById(reportInfo.getChangeFromId())) != null) {
                        reportInfo.setExposureReportId(beforeReport.getExposureReportId());
                        reportInfo.setExposureReportOldId(beforeReport.getExposureReportId());
                    }
                    if (reportInfo.getExposureReportId() != null) {
                        riskExposeEvaluate = (RiskExposeEvaluate)this.riskExposeEvaluateService.getById((Serializable)reportInfo.getExposureReportId());
                    }
                }
            } else if (Objects.equals(reportInfo.getStatus(), (byte)2) || Objects.equals(reportInfo.getStatus(), (byte)3)) {
                if (reportInfo.getExposureReportId() == null && reportInfo.getChangeFromId() != null && (beforeReport = (SelfInspectionRiskAssessmentReportInfo)this.getById(reportInfo.getChangeFromId())) != null) {
                    reportInfo.setExposureReportId(beforeReport.getExposureReportId());
                    reportInfo.setExposureReportOldId(beforeReport.getExposureReportId());
                }
                if (reportInfo.getExposureReportId() != null) {
                    riskExposeEvaluate = (RiskExposeEvaluate)this.riskExposeEvaluateService.getById((Serializable)reportInfo.getExposureReportId());
                }
            } else {
                riskExposeEvaluate = this.riskExposeEvaluateService.getLatestEv(cid, null, Integer.valueOf(2));
            }
        } else {
            riskExposeEvaluate = this.riskExposeEvaluateService.getLatestEv(cid, null, Integer.valueOf(2));
        }
        EvQueryParam evQueryParam = new EvQueryParam();
        evQueryParam.setCid(cid);
        evQueryParam.setReportStatusList(Arrays.asList(3, 4));
        evQueryParam.setPage(Integer.valueOf(1));
        evQueryParam.setRows(Integer.valueOf(100));
        List mergerRiskTableIdList = this.riskExposeEvaluateService.getRedundantSourceTablesIdsIsNotNullByCid(cid);
        if (CollectionUtils.isNotEmpty((Collection)mergerRiskTableIdList)) {
            evQueryParam.setSourceIdList(mergerRiskTableIdList);
        }
        PageInfo riskExposeEvaluateVoPageInfo = this.riskExposeEvaluateService.queryPage(evQueryParam);
        if (riskExposeEvaluate != null && !Objects.equals(riskExposeEvaluate.getReportStatus(), 3) && !Objects.equals(riskExposeEvaluate.getReportStatus(), 4)) {
            RiskExposeEvaluateVo vo = new RiskExposeEvaluateVo();
            BeanUtils.copyProperties((Object)riskExposeEvaluate, (Object)vo);
            Example example = new Example(SelfInspectionRiskAssessmentReportInfo.class);
            example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true).andIn("status", Arrays.asList(1, 2, 3, 4));
            example.setOrderByClause("update_date desc LIMIT 1");
            SelfInspectionRiskAssessmentReportInfo reportInfo = (SelfInspectionRiskAssessmentReportInfo)((SelfInspectionRiskAssessmentReportInfoMapper)this.dao).selectOneByExample(example);
            if (reportInfo != null && Objects.equals(reportInfo.getStatus(), (byte)4)) {
                vo.setIsIgnore(Boolean.valueOf(true));
            }
            List list = riskExposeEvaluateVoPageInfo.getList();
            list.add(0, vo);
            return PageUtil.getPageInfo((List)list, (int)param.getPage(), (int)param.getRows());
        }
        return PageUtil.getPageInfo((List)riskExposeEvaluateVoPageInfo.getList(), (int)param.getPage(), (int)param.getRows());
    }

    public SelfInspectionRiskAssessmentReportV314Vo getV314VoById(Long id) {
        SelfInspectionRiskAssessmentReportV314Vo v314Vo = new SelfInspectionRiskAssessmentReportV314Vo();
        SelfInspectionRiskAssessmentReportInfo reportInfo = (SelfInspectionRiskAssessmentReportInfo)this.getById(id);
        v314Vo.setReportInfo(reportInfo);
        if (v314Vo.getReportInfo() != null) {
            SysParamModel economicType;
            IndustryModel industryClassification;
            if (v314Vo.getReportInfo().getIndustryClassification() != null && (industryClassification = this.industryProvideService.getIndustryById(v314Vo.getReportInfo().getIndustryClassification())) != null) {
                v314Vo.setIndustryClassificationName(industryClassification.getCode() + "-" + industryClassification.getName());
            }
            if (v314Vo.getReportInfo().getEconomicType() != null && (economicType = this.sysParamProvideService.getById(v314Vo.getReportInfo().getEconomicType())) != null) {
                v314Vo.setEconomicTypeName(economicType.getParamCode() + "-" + economicType.getParamValue());
            }
            if (v314Vo.getReportInfo().getCompanyScale() != null) {
                v314Vo.setScaleName(CompanySizeEnum.getName((Byte)Byte.valueOf("" + v314Vo.getReportInfo().getCompanyScale())));
            }
        }
        if (v314Vo.getReportInfo() != null && v314Vo.getReportInfo().getStatus() != null && v314Vo.getReportInfo().getStatus() == 1) {
            CompanyHsePreventionControlSelfJudge selfJudge;
            if (!Byte.valueOf("2").equals(v314Vo.getReportInfo().getReportFromYear()) && (StringUtils.isEmpty((CharSequence)v314Vo.getReportInfo().getChangeReason()) || !v314Vo.getReportInfo().getChangeReason().contains("2")) || !Byte.valueOf("2").equals(v314Vo.getReportInfo().getReportFromYear()) && v314Vo.getReportInfo().getSelfReportId() == null) {
                selfJudge = this.companyHsePreventionControlSelfJudgeService.getLatestEntityNoStatusByCid(v314Vo.getReportInfo().getCid());
                v314Vo.setSelfJudge(selfJudge);
                if (v314Vo.getSelfJudge() != null) {
                    v314Vo.getReportInfo().setSelfReportId(v314Vo.getSelfJudge().getId());
                    if (v314Vo.getReportInfo().getSelfReportOldId() == null) {
                        v314Vo.getReportInfo().setSelfReportOldId(v314Vo.getSelfJudge().getId());
                    }
                }
            } else if (v314Vo.getReportInfo().getSelfReportId() != null && (selfJudge = (CompanyHsePreventionControlSelfJudge)this.companyHsePreventionControlSelfJudgeService.getById(v314Vo.getReportInfo().getSelfReportId())) != null && selfJudge.getIsValid().booleanValue()) {
                v314Vo.setSelfJudge(selfJudge);
            }
            if (Byte.valueOf("2").equals(v314Vo.getReportInfo().getReportFromYear()) && StringUtils.isNotEmpty((String)v314Vo.getReportInfo().getChangeReason()) && v314Vo.getReportInfo().getChangeReason().contains("1") || Byte.valueOf("1").equals(v314Vo.getReportInfo().getReportFromYear())) {
                RiskExposeEvaluate riskExposeEvaluate = this.riskExposeEvaluateService.getLatestNeedReportEv(v314Vo.getReportInfo().getCid());
                v314Vo.setRiskExposeEvaluate(riskExposeEvaluate);
                if (v314Vo.getRiskExposeEvaluate() != null) {
                    v314Vo.getReportInfo().setExposureReportId(v314Vo.getRiskExposeEvaluate().getId());
                    if (v314Vo.getReportInfo().getExposureReportOldId() == null) {
                        v314Vo.getReportInfo().setExposureReportOldId(v314Vo.getRiskExposeEvaluate().getId());
                    }
                }
            } else if (Byte.valueOf("2").equals(v314Vo.getReportInfo().getReportFromYear())) {
                SelfInspectionRiskAssessmentReportInfo beforeReport;
                if (v314Vo.getReportInfo().getExposureReportId() == null && v314Vo.getReportInfo().getChangeFromId() != null && (beforeReport = (SelfInspectionRiskAssessmentReportInfo)this.getById(v314Vo.getReportInfo().getChangeFromId())) != null) {
                    v314Vo.getReportInfo().setExposureReportId(beforeReport.getExposureReportId());
                    v314Vo.getReportInfo().setExposureReportOldId(beforeReport.getExposureReportId());
                }
                if (v314Vo.getReportInfo().getExposureReportId() != null) {
                    RiskExposeEvaluate beforeChange = (RiskExposeEvaluate)this.riskExposeEvaluateService.getById((Serializable)v314Vo.getReportInfo().getExposureReportId());
                    v314Vo.setRiskExposeEvaluate(beforeChange);
                }
            }
        }
        if (v314Vo.getReportInfo() != null && v314Vo.getReportInfo().getStatus() != null && v314Vo.getReportInfo().getStatus() != 1) {
            if (v314Vo.getReportInfo().getSelfReportId() != null) {
                v314Vo.setSelfJudge((CompanyHsePreventionControlSelfJudge)this.companyHsePreventionControlSelfJudgeService.getById(v314Vo.getReportInfo().getSelfReportId()));
            }
            if (v314Vo.getReportInfo().getExposureReportId() != null) {
                v314Vo.setRiskExposeEvaluate((RiskExposeEvaluate)this.riskExposeEvaluateService.getById((Serializable)v314Vo.getReportInfo().getExposureReportId()));
            }
        }
        if (v314Vo.getSelfJudge() != null) {
            v314Vo.getSelfJudge().setTerms(this.occupationalSelfJudgeTermV308Service.getListBySelfId(v314Vo.getSelfJudge().getId()));
            if (v314Vo.getSelfJudge().getTerms() != null) {
                List terms = this.selfInspectionTermService.getListByFlag(Integer.valueOf(1));
                v314Vo.getSelfJudge().getTerms().stream().forEach(s -> {
                    SelfInspectionTerm t = terms.stream().filter(s1 -> Long.valueOf(s1.getTermNo().intValue()).equals(s.getTermNo())).findFirst().orElse(null);
                    if (t != null) {
                        s.setTermName(t.getTermName());
                    }
                });
                v314Vo.setRectifyTerms(v314Vo.getSelfJudge().getTerms().stream().filter(s -> s.getCheckResult() != null && (s.getCheckResult() == 2 || s.getCheckResult() == 3)).collect(Collectors.toList()));
                v314Vo.setAbleMissingTerms(v314Vo.getSelfJudge().getTerms().stream().filter(s -> s.getCheckResult() != null && s.getCheckResult() == 4).collect(Collectors.toList()));
            }
            if (v314Vo.getSelfJudge().getJudgeLevel() != null) {
                v314Vo.setJudgeLevel(Integer.valueOf(v314Vo.getSelfJudge().getJudgeLevel().intValue()));
                v314Vo.setJudgeLevelName(JudgeResultLevelEnum.getThisEnumByCode((Integer)v314Vo.getSelfJudge().getJudgeLevel().intValue()).getName());
            }
        }
        if (v314Vo.getRiskExposeEvaluate() != null) {
            ThirdOrganization thirdOrganization;
            RiskDecisionVo riskDecisionVo = this.riskExposeEvaluateService.queryTouchNumAndLevel(v314Vo.getRiskExposeEvaluate().getId());
            v314Vo.setRiskDecisionVo(riskDecisionVo);
            v314Vo.setEvDataStatModels(this.riskExposeEvaluateDataService.queryEvDataStat(v314Vo.getRiskExposeEvaluate().getId()));
            if (riskDecisionVo != null && riskDecisionVo.getRiskLevel() != null) {
                Integer level = 1;
                String riskLevel = riskDecisionVo.getRiskLevel();
                if ("\u2160\u7ea7".equals(riskLevel)) {
                    level = 1;
                } else if ("\u2161\u7ea7".equals(riskLevel)) {
                    level = 2;
                } else if ("\u2162\u7ea7".equals(riskLevel)) {
                    level = 3;
                }
                v314Vo.setRiskLevel(level);
                v314Vo.setRiskLevelName(riskDecisionVo.getRiskLevel());
            }
            if (v314Vo.getRiskExposeEvaluate().getOrgId() != null && (thirdOrganization = (ThirdOrganization)this.thirdOrganizationService.getById(v314Vo.getRiskExposeEvaluate().getOrgId())) != null) {
                v314Vo.setThirdOrgName(thirdOrganization.getName());
                v314Vo.setThirdOrgId(thirdOrganization.getId());
            }
        }
        if (v314Vo.getJudgeLevel() != null && v314Vo.getRiskLevel() != null) {
            HazardsRiskClassifyEnum riskClassifyEnum = HazardsRiskClassifyEnum.getThisEnumByJudgeLevelAndRiskLevel((JudgeResultLevelEnum)JudgeResultLevelEnum.getThisEnumByCode((Integer)v314Vo.getJudgeLevel()), (HazardsExposureRiskLevelEnum)HazardsExposureRiskLevelEnum.getThisEnumByCode((Integer)v314Vo.getRiskLevel()));
            v314Vo.setRiskClassify(riskClassifyEnum == null ? null : riskClassifyEnum.getCode());
            v314Vo.setRiskClassifyName(riskClassifyEnum == null ? null : riskClassifyEnum.getName());
        }
        return v314Vo;
    }

    private SelfInspectionRiskAssessmentReportInfo getThisYearSelfInspectionRiskAssessmentReportByCid(int year, Long cid) {
        Example example = new Example(SelfInspectionRiskAssessmentReportInfo.class);
        example.createCriteria().andBetween("year", (Object)(year - 4), (Object)year).andEqualTo("cid", (Object)cid).andEqualTo("reportFromYear", (Object)1).andEqualTo("isValid", (Object)true);
        List list = ((SelfInspectionRiskAssessmentReportInfoMapper)this.dao).selectByExample(example);
        if (list != null && !list.isEmpty()) {
            return (SelfInspectionRiskAssessmentReportInfo)list.get(0);
        }
        return null;
    }

    public SelfInspectionRiskAssessmentReportV314Vo getLatestV314VoByCid(Long cid) {
        SelfInspectionRiskAssessmentReportV314Vo vo = new SelfInspectionRiskAssessmentReportV314Vo();
        Example example = new Example(SelfInspectionRiskAssessmentReportInfo.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true).andEqualTo("status", (Object)4);
        example.setOrderByClause("update_date desc");
        List list = ((SelfInspectionRiskAssessmentReportInfoMapper)this.dao).selectByExample(example);
        if (list != null && list.size() > 0) {
            vo.setReportInfo((SelfInspectionRiskAssessmentReportInfo)list.get(0));
        }
        if (vo != null && vo.getReportInfo() != null && vo.getReportInfo().getExposureReportId() != null) {
            RiskDecisionVo riskDecisionVo = this.riskExposeEvaluateService.queryTouchNumAndLevel(vo.getReportInfo().getExposureReportId());
            vo.setRiskDecisionVo(riskDecisionVo);
        }
        return vo;
    }

    public List<SelfReportCollectVo> getSelfReportInfoCollectVosByRangTime(Date beginDate, Date endDate) {
        List<SelfInspectionRiskAssessmentReportInfo> listAll = this.getAllDataByRangeTime(beginDate, endDate, null);
        Map map = listAll.stream().collect(Collectors.groupingBy(s -> s.getCid(), Collectors.toList()));
        ArrayList<SelfReportCollectVo> results = new ArrayList<SelfReportCollectVo>();
        for (Long cid : map.keySet()) {
            SelfReportCollectVo vo = new SelfReportCollectVo();
            vo.setCid(cid);
            List everylist = map.get(cid).stream().sorted(Comparator.comparing(SelfInspectionRiskAssessmentReportInfo::getUpdateDate).reversed()).collect(Collectors.toList());
            SelfInspectionRiskAssessmentReportInfo firstReportInfo = (SelfInspectionRiskAssessmentReportInfo)everylist.get(0);
            if (firstReportInfo.getSelfReportId() != null && !firstReportInfo.getSelfReportId().equals(firstReportInfo.getSelfReportOldId())) {
                vo.setJudgeHasUpdate(Boolean.valueOf(true));
            }
            if (firstReportInfo.getExposureReportId() != null && !firstReportInfo.getExposureReportId().equals(firstReportInfo.getExposureReportOldId())) {
                vo.setRiskHasUpdate(Boolean.valueOf(true));
            }
            ArrayList statusList = new ArrayList();
            SelfInspectionRiskAssessmentReportInfo reportInfo = everylist.stream().filter(s -> {
                statusList.add(s.getStatus());
                return Long.valueOf(4L).equals(s.getStatus());
            }).findFirst().orElse(null);
            if (reportInfo != null) {
                vo.setEvaluateId(reportInfo.getId());
                if (reportInfo.getRiskClassify() != null) {
                    vo.setGradeLevel(Integer.valueOf(reportInfo.getRiskClassify().intValue()));
                }
                vo.setEvaluateUpdateDate(reportInfo.getUpdateDate());
            }
            if (statusList.contains(Byte.valueOf("2"))) {
                vo.setEvaluateCheckState(Integer.valueOf(0));
                continue;
            }
            if (statusList.contains(Byte.valueOf("3"))) {
                vo.setEvaluateCheckState(Integer.valueOf(-1));
                continue;
            }
            if (!statusList.contains(Byte.valueOf("4"))) continue;
            vo.setEvaluateCheckState(Integer.valueOf(1));
        }
        return results;
    }

    public SelfReportCollectVo getSelfReportInfoCollectVosByRangTimeAndCid(Date beginDate, Date endDate, Long cid) {
        List<SelfInspectionRiskAssessmentReportInfo> listAll = this.getAllDataByRangeTime(beginDate, endDate, cid);
        SelfReportCollectVo vo = new SelfReportCollectVo();
        vo.setCid(cid);
        if (cid == null || listAll == null || listAll.size() == 0) {
            return vo;
        }
        List everylist = listAll.stream().sorted(Comparator.comparing(SelfInspectionRiskAssessmentReportInfo::getUpdateDate).reversed()).collect(Collectors.toList());
        SelfInspectionRiskAssessmentReportInfo firstReportInfo = (SelfInspectionRiskAssessmentReportInfo)everylist.get(0);
        if (firstReportInfo.getSelfReportId() != null && !firstReportInfo.getSelfReportId().equals(firstReportInfo.getSelfReportOldId())) {
            vo.setJudgeHasUpdate(Boolean.valueOf(true));
        }
        if (firstReportInfo.getExposureReportId() != null && !firstReportInfo.getExposureReportId().equals(firstReportInfo.getExposureReportOldId())) {
            vo.setRiskHasUpdate(Boolean.valueOf(true));
        }
        ArrayList statusList = new ArrayList();
        SelfInspectionRiskAssessmentReportInfo reportInfo = everylist.stream().filter(s -> {
            statusList.add(s.getStatus());
            return Long.valueOf(4L).equals(s.getStatus());
        }).findFirst().orElse(null);
        if (reportInfo != null) {
            vo.setEvaluateId(reportInfo.getId());
            if (reportInfo.getRiskClassify() != null) {
                vo.setGradeLevel(Integer.valueOf(reportInfo.getRiskClassify().intValue()));
            }
            vo.setEvaluateUpdateDate(reportInfo.getUpdateDate());
        }
        if (statusList.contains(Byte.valueOf("2"))) {
            vo.setEvaluateCheckState(Integer.valueOf(0));
        } else if (statusList.contains(Byte.valueOf("3"))) {
            vo.setEvaluateCheckState(Integer.valueOf(-1));
        } else if (statusList.contains(Byte.valueOf("4"))) {
            vo.setEvaluateCheckState(Integer.valueOf(1));
        }
        return vo;
    }

    public List<SelfReportCollectVo> getSelfReportInfoCollectVoListByRangTimeAndCid(Date beginDate, Date endDate, Long cid) {
        List<SelfInspectionRiskAssessmentReportInfo> reportInfos = this.listDataV314EveryCidLatestForSuperviseByDateRange(beginDate, endDate, Arrays.asList(cid));
        if (reportInfos != null && reportInfos.size() > 0) {
            ArrayList riskIds = new ArrayList();
            ArrayList selfIds = new ArrayList();
            List reportCollectVos = reportInfos.stream().map(s -> {
                SelfReportCollectVo vo = new SelfReportCollectVo();
                vo.setCid(s.getCid());
                vo.setEvaluateId(s.getId());
                vo.setEvaluateCheckState(this.getClassifySuperviseStatus(s.getStatus()));
                vo.setEvaluateUpdateDate(s.getUpdateDate());
                vo.setSelfId(s.getSelfReportId());
                if (vo.getSelfId() != null) {
                    selfIds.add(vo.getSelfId());
                }
                vo.setRiskId(s.getExposureReportId());
                if (vo.getRiskId() != null) {
                    riskIds.add(vo.getRiskId());
                }
                if (s.getExposureReportId() != null && s.getExposureReportOldId() != null && !s.getExposureReportId().equals(s.getExposureReportOldId())) {
                    vo.setRiskHasUpdate(Boolean.valueOf(true));
                }
                return vo;
            }).collect(Collectors.toList());
            Map riskExposeEvaluateMap = this.riskExposeEvaluateService.queryByIds(riskIds);
            Map selfJudgeMap = this.companyHsePreventionControlSelfJudgeService.queryByIds(selfIds);
            ArrayList<SelfReportCollectVo> finalSelfReportCollectVo = new ArrayList<SelfReportCollectVo>();
            for (SelfReportCollectVo s2 : reportCollectVos) {
                CompanyHsePreventionControlSelfJudge selfJudge = (CompanyHsePreventionControlSelfJudge)selfJudgeMap.get(s2.getSelfId());
                if (selfJudge != null) {
                    if (selfJudge.getJudgeLevel() != null) {
                        s2.setJudgeLevel(Integer.valueOf(selfJudge.getJudgeLevel().intValue()));
                    }
                    s2.setJudgeUpdateDate(selfJudge.getUpdateDate());
                    s2.setJudgeCheckState(this.getClassifySuperviseStatus(selfJudge.getStatus()));
                }
                if (selfJudge == null || selfJudge.getStatus() == null || selfJudge.getStatus() == 1) continue;
                RiskExposeEvaluate riskExposeEvaluate = (RiskExposeEvaluate)riskExposeEvaluateMap.get(s2.getRiskId());
                if (riskExposeEvaluate != null) {
                    if (riskExposeEvaluate.getDataUpdateDate() != null) {
                        s2.setRiskUpdateDate(Date.from(riskExposeEvaluate.getDataUpdateDate().atZone(ZoneId.systemDefault()).toInstant()));
                    }
                    s2.setRiskLevel(riskExposeEvaluate.getRiskLevel());
                    if (riskExposeEvaluate.getReportStatus() != null) {
                        s2.setRiskCheckState(this.getClassifySuperviseStatus(riskExposeEvaluate.getReportStatus().byteValue()));
                    }
                }
                if (riskExposeEvaluate == null || riskExposeEvaluate.getReportStatus() == null || riskExposeEvaluate.getReportStatus() == 1) continue;
                if (s2.getJudgeLevel() != null && s2.getRiskLevel() != null) {
                    HazardsRiskClassifyEnum riskClassifyEnum = HazardsRiskClassifyEnum.getThisEnumByJudgeLevelAndRiskLevel((JudgeResultLevelEnum)JudgeResultLevelEnum.getThisEnumByCode((Integer)s2.getJudgeLevel()), (HazardsExposureRiskLevelEnum)HazardsExposureRiskLevelEnum.getThisEnumByCode((Integer)s2.getRiskLevel()));
                    s2.setGradeLevel(riskClassifyEnum == null ? null : riskClassifyEnum.getCode());
                }
                finalSelfReportCollectVo.add(s2);
            }
            return finalSelfReportCollectVo;
        }
        return null;
    }

    public List<SelfReportCollectVo> getSelfReportInfoCollectVoListHasJudgeByRangTimeAndCid(Date beginDate, Date endDate, List<Long> cids) {
        List selfJudges = this.companyHsePreventionControlSelfJudgeService.listDataV314EveryCidLatestForSuperviseByDateRange(null, null, cids);
        int year = DateUtils.getThisYear() - 3;
        LocalDate of = LocalDate.of(year, 1, 1);
        Date end = DateUtils.addDay((Date)new Date(), (int)1);
        List riskExposeEvaluateList = this.riskExposeEvaluateService.listRiskEvaluateLasted(DateUtil.getDate((LocalDateTime)of.atStartOfDay()), end, cids);
        List<SelfInspectionRiskAssessmentReportInfo> reportInfos = this.listDataV314EveryCidLatestForSuperviseByDateRange(null, null, cids);
        List<CompanyGradeV3> lastCheckedReportGradeLevelList = ((SelfInspectionRiskAssessmentReportInfoMapper)this.dao).listLastCheckedReportGradeLevelInfo(cids);
        Map<Object, Object> selfJudgeMapTemp = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)selfJudges)) {
            selfJudgeMapTemp = selfJudges.stream().collect(Collectors.toMap(CompanyHsePreventionControlSelfJudge::getId, s -> s));
        }
        Map<Object, Object> riskInfoMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)riskExposeEvaluateList)) {
            riskInfoMap = riskExposeEvaluateList.stream().collect(Collectors.toMap(BaseEntity::getId, s -> s));
        }
        Map<Object, Object> lastCheckedReportGradeLevelMap = new HashMap();
        if (CollectionUtils.isNotEmpty(lastCheckedReportGradeLevelList)) {
            lastCheckedReportGradeLevelMap = lastCheckedReportGradeLevelList.stream().collect(Collectors.toMap(CompanyGradeV3::getCid, s -> s));
        }
        HashMap<Long, SelfReportCollectVo> reportCollectVoMap = new HashMap<Long, SelfReportCollectVo>();
        if (CollectionUtils.isNotEmpty((Collection)selfJudges)) {
            selfJudges.forEach(s -> {
                SelfReportCollectVo vo = reportCollectVoMap.computeIfAbsent(s.getCid(), v -> new SelfReportCollectVo(s.getCid()));
                vo.setSelfId(s.getId());
                if (s.getJudgeLevel() != null) {
                    vo.setJudgeLevel(Integer.valueOf(s.getJudgeLevel().intValue()));
                }
                if (s.getUpdateDate() != null) {
                    vo.setJudgeUpdateDate(s.getUpdateDate());
                }
                if (s.getStatus() != null) {
                    vo.setJudgeCheckState(this.getClassifySuperviseStatus(s.getStatus()));
                }
                if (s.getRealLevel() != null) {
                    vo.setRealJudgelevel(Integer.valueOf(s.getRealLevel().intValue()));
                }
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)riskExposeEvaluateList)) {
            riskExposeEvaluateList.forEach(s -> {
                SelfReportCollectVo vo = reportCollectVoMap.computeIfAbsent(s.getCid(), v -> new SelfReportCollectVo(s.getCid()));
                vo.setRiskId(s.getId());
                if (s.getRiskLevel() != null) {
                    vo.setRiskLevel(s.getRiskLevel());
                }
                if (s.getDataUpdateDate() != null) {
                    vo.setRiskUpdateDate(Date.from(s.getUpdateDate().atZone(ZoneId.systemDefault()).toInstant()));
                }
                if (s.getReportStatus() != null) {
                    vo.setRiskCheckState(this.getClassifySuperviseStatus(s.getReportStatus().byteValue()));
                }
            });
        }
        if (CollectionUtils.isNotEmpty(reportInfos)) {
            ArrayList<Long> riskIdSet = new ArrayList<Long>();
            ArrayList<Object> selfIdSet = new ArrayList<Object>();
            for (SelfInspectionRiskAssessmentReportInfo reportInfo : reportInfos) {
                Long selfReportId = reportInfo.getSelfReportId();
                Long riskId = reportInfo.getExposureReportId();
                if (!selfJudgeMapTemp.containsKey(selfReportId)) {
                    selfIdSet.add(selfReportId);
                }
                if (!riskInfoMap.containsKey(riskId)) {
                    riskIdSet.add(riskId);
                }
                SelfReportCollectVo vo = reportCollectVoMap.computeIfAbsent(reportInfo.getCid(), v -> new SelfReportCollectVo(reportInfo.getCid()));
                vo.setEvaluateId(reportInfo.getId());
                vo.setEvaluateCheckState(this.getClassifySuperviseStatus(reportInfo.getStatus()));
                vo.setEvaluateUpdateDate(reportInfo.getUpdateDate());
                if (reportInfo.getExposureReportId() != null && reportInfo.getExposureReportOldId() != null && !reportInfo.getExposureReportId().equals(reportInfo.getExposureReportOldId())) {
                    vo.setRiskHasUpdate(Boolean.valueOf(true));
                }
                if (reportInfo.getReportFromYear() != null) {
                    vo.setEvaluateType(Integer.valueOf(reportInfo.getReportFromYear().intValue()));
                }
                vo.setEvaluateChangeReason(reportInfo.getChangeReason());
            }
            Map riskExposeEvaluateMap = this.riskExposeEvaluateService.queryByIds(riskIdSet);
            Map selfJudgeMap = this.companyHsePreventionControlSelfJudgeService.queryByIds(selfIdSet);
            for (SelfInspectionRiskAssessmentReportInfo reportInfo : reportInfos) {
                Long selfReportId = reportInfo.getSelfReportId();
                Long riskId = reportInfo.getExposureReportId();
                SelfReportCollectVo vo = reportCollectVoMap.computeIfAbsent(reportInfo.getCid(), v -> new SelfReportCollectVo(reportInfo.getCid()));
                if (riskExposeEvaluateMap.containsKey(riskId)) {
                    RiskExposeEvaluate newRisk = (RiskExposeEvaluate)riskExposeEvaluateMap.get(riskId);
                    vo.setRiskId(newRisk.getId());
                    if (newRisk.getRiskLevel() != null) {
                        vo.setRiskLevel(newRisk.getRiskLevel());
                    }
                    if (newRisk.getDataUpdateDate() != null) {
                        vo.setRiskUpdateDate(Date.from(newRisk.getDataUpdateDate().atZone(ZoneId.systemDefault()).toInstant()));
                    }
                    if (newRisk.getReportStatus() != null) {
                        vo.setRiskCheckState(this.getClassifySuperviseStatus(newRisk.getReportStatus().byteValue()));
                    }
                }
                if (!selfJudgeMap.containsKey(selfReportId)) continue;
                CompanyHsePreventionControlSelfJudge newJudge = (CompanyHsePreventionControlSelfJudge)selfJudgeMap.get(selfReportId);
                vo.setSelfId(newJudge.getId());
                if (newJudge.getJudgeLevel() != null) {
                    vo.setJudgeLevel(Integer.valueOf(newJudge.getJudgeLevel().intValue()));
                }
                if (newJudge.getUpdateDate() != null) {
                    vo.setJudgeUpdateDate(newJudge.getUpdateDate());
                }
                if (newJudge.getStatus() != null) {
                    vo.setJudgeCheckState(this.getClassifySuperviseStatus(newJudge.getStatus()));
                }
                if (newJudge.getRealLevel() == null) continue;
                vo.setRealJudgelevel(Integer.valueOf(newJudge.getRealLevel().intValue()));
            }
        }
        ArrayList selfReportCollectVos = new ArrayList(reportCollectVoMap.values());
        for (SelfReportCollectVo vo : selfReportCollectVos) {
            CompanyGradeV3 lastCheckedLevelInfo;
            if (vo.getJudgeLevel() != null && vo.getRiskLevel() != null) {
                HazardsRiskClassifyEnum riskClassifyEnum = HazardsRiskClassifyEnum.getThisEnumByJudgeLevelAndRiskLevel((JudgeResultLevelEnum)JudgeResultLevelEnum.getThisEnumByCode((Integer)vo.getJudgeLevel()), (HazardsExposureRiskLevelEnum)HazardsExposureRiskLevelEnum.getThisEnumByCode((Integer)vo.getRiskLevel()));
                vo.setGradeLevel(riskClassifyEnum == null ? null : riskClassifyEnum.getCode());
            }
            if ((lastCheckedLevelInfo = (CompanyGradeV3)lastCheckedReportGradeLevelMap.get(vo.getCid())) == null) continue;
            HazardsRiskClassifyEnum riskClassifyEnum = HazardsRiskClassifyEnum.getThisEnumByJudgeLevelAndRiskLevel((JudgeResultLevelEnum)JudgeResultLevelEnum.getThisEnumByCode((Integer)lastCheckedLevelInfo.getJudgeLevel()), (HazardsExposureRiskLevelEnum)HazardsExposureRiskLevelEnum.getThisEnumByCode((Integer)lastCheckedLevelInfo.getRiskLevel()));
            vo.setLastCheckedGradeLevel(riskClassifyEnum == null ? null : riskClassifyEnum.getCode());
        }
        return new ArrayList<SelfReportCollectVo>(reportCollectVoMap.values());
    }

    private Integer getClassifySuperviseStatus(Byte status) {
        if (Byte.valueOf("2").equals(status)) {
            return 0;
        }
        if (Byte.valueOf("3").equals(status) || Byte.valueOf("10").equals(status)) {
            return -1;
        }
        if (Byte.valueOf("4").equals(status)) {
            return 1;
        }
        return null;
    }

    @Transactional(readOnly=false)
    public void synCompanyReportInfo(SelfInspectionRiskAssessmentReportInfo info) {
        if (info != null && info.getCid() != null) {
            Example example = new Example(SelfInspectionRiskAssessmentReportInfo.class);
            example.createCriteria().andEqualTo("cid", (Object)info.getCid()).andEqualTo("isValid", (Object)true).andEqualTo("status", (Object)1);
            ((SelfInspectionRiskAssessmentReportInfoMapper)this.dao).updateByExampleSelective(info, example);
        }
    }

    @Transactional(readOnly=false)
    public SelfInspectionRiskAssessmentReportInfo saveSelfReportChangeReason(SelfInspectionRiskAssessmentReportInfo reportInfo, Long cid, Long loginStaffId) {
        SelfInspectionRiskAssessmentReportInfo changeReportInfo = new SelfInspectionRiskAssessmentReportInfo();
        changeReportInfo.setChangeReason(reportInfo.getChangeReason());
        changeReportInfo.setReasonDetail(reportInfo.getReasonDetail());
        changeReportInfo.setPhoneNumber(reportInfo.getPhoneNumber());
        changeReportInfo.setSelfStaffName(reportInfo.getSelfStaffName());
        reportInfo = (SelfInspectionRiskAssessmentReportInfo)this.getById(reportInfo.getId());
        changeReportInfo.setCid(cid);
        changeReportInfo.setYear(Long.valueOf(LocalDate.now().getYear()));
        changeReportInfo.setReportFromYear(Byte.valueOf((byte)2));
        changeReportInfo.setStatus(Byte.valueOf((byte)1));
        changeReportInfo.setDataSource(Byte.valueOf((byte)1));
        changeReportInfo.setSelfTime(new Date());
        changeReportInfo.setIsValid(Boolean.valueOf(true));
        changeReportInfo.setChangeFromId(reportInfo.getId());
        CompanyBaseInfoModel cim = this.companyProvideByHSEService.getCompanyById(cid);
        changeReportInfo.setCompanyName(cim.getName());
        changeReportInfo.setRegisterAddDetail(cim.getRegisterAddress());
        changeReportInfo.setLocationAddDetail(cim.getWorkAddress());
        changeReportInfo.setCompanyScale(StringUtils.isNumber((String)cim.getScale()) ? Long.valueOf(cim.getScale()) : null);
        changeReportInfo.setIndustryClassification(cim.getIndustryCategory());
        changeReportInfo.setEconomicType(cim.getRegisterType());
        changeReportInfo.setContactNumber(cim.getLegalTel());
        changeReportInfo.setLocationAddAreaId(cim.getAreaDetailId());
        CompanyReportInfo companyReportInfo = this.companyReportInfoService.getCompanyReportInfoByCid(cid);
        if (companyReportInfo != null) {
            changeReportInfo.setManageOrg(companyReportInfo.getManageOrg());
            changeReportInfo.setManageMajorStaffCount(companyReportInfo.getManageMajorStaffCount());
            changeReportInfo.setManagePluralityStaffCount(companyReportInfo.getManagePluralityStaffCount());
            changeReportInfo.setStaffCount(companyReportInfo.getStaffCount());
            changeReportInfo.setHarmStaffCount(companyReportInfo.getHarmStaffCount());
            changeReportInfo.setDiseaseOnWorkStaffCount(companyReportInfo.getDiseaseOnWorkStaffCount());
            CompanyDeclareInfo companyDeclareInfo = this.declareBaseService.getCompanyDeclareInfo(cid);
            changeReportInfo.setDiseaseStaffCount(Long.valueOf(companyDeclareInfo != null && companyDeclareInfo.getOccupationalDiseasesNum() != null ? companyDeclareInfo.getOccupationalDiseasesNum().longValue() : 0L));
            changeReportInfo.setCheckGoWorkStaffCount(companyReportInfo.getCheckGoWorkStaffCount());
            changeReportInfo.setCheckGoWorkStaffRealCount(companyReportInfo.getCheckGoWorkStaffRealCount());
            changeReportInfo.setCheckOnWorkStaffCount(companyReportInfo.getCheckOnWorkStaffCount());
            changeReportInfo.setCheckOnWorkStaffRealCount(companyReportInfo.getCheckOnWorkStaffRealCount());
            changeReportInfo.setCheckLeaveWorkStaffCount(companyReportInfo.getCheckLeaveWorkStaffCount());
            changeReportInfo.setCheckLeaveWorkStaffRealCount(companyReportInfo.getCheckLeaveWorkStaffRealCount());
        }
        if (StringUtils.isNotEmpty((String)changeReportInfo.getChangeReason()) && changeReportInfo.getChangeReason().contains("1")) {
            changeReportInfo.setExposureReportOldId(reportInfo.getExposureReportId());
            RiskExposeEvaluate riskExposeEvaluate = this.riskExposeEvaluateService.getLatestNeedReportEv(cid);
            if (riskExposeEvaluate != null) {
                changeReportInfo.setExposureReportId(riskExposeEvaluate.getId());
            }
        } else {
            changeReportInfo.setExposureReportId(reportInfo.getExposureReportId());
            changeReportInfo.setExposureReportOldId(reportInfo.getExposureReportId());
        }
        if (StringUtils.isNotEmpty((String)changeReportInfo.getChangeReason()) && changeReportInfo.getChangeReason().contains("2")) {
            changeReportInfo.setSelfReportOldId(reportInfo.getSelfReportId());
        } else {
            changeReportInfo.setSelfReportId(reportInfo.getSelfReportId());
            changeReportInfo.setSelfReportOldId(reportInfo.getSelfReportId());
        }
        this.add(changeReportInfo, loginStaffId, cid);
        return changeReportInfo;
    }

    @Transactional(readOnly=false)
    public int examineAndVerifySelfReportById(SelfInspectionRiskAssessmentReportInfo reportInfo, Long loginUserId) {
        if (reportInfo == null && reportInfo.getId() == null || reportInfo.getStatus() == null || reportInfo.getStatus() == 1 || reportInfo.getStatus() == 2) {
            return 0;
        }
        SelfInspectionRiskAssessmentReportInfo updateReportInfo = new SelfInspectionRiskAssessmentReportInfo();
        updateReportInfo.setId(reportInfo.getId());
        updateReportInfo.setStatus(reportInfo.getStatus());
        updateReportInfo.setBackReason(reportInfo.getBackReason());
        updateReportInfo.setBackReasonDetail(reportInfo.getBackReasonDetail());
        this.update(updateReportInfo, loginUserId);
        if (reportInfo.getStatus() != null && reportInfo.getStatus().intValue() == 3) {
            SelfInspectionRiskAssessmentReportInfo info = (SelfInspectionRiskAssessmentReportInfo)this.getById(reportInfo.getId());
            SelfInspectionRiskAssessmentReportInfo copy = new SelfInspectionRiskAssessmentReportInfo();
            BeanUtils.copyProperties((Object)info, (Object)copy, (String[])new String[]{"id"});
            copy.setId(Long.valueOf(this.idworker.nextId()));
            copy.setSourceId(info.getId());
            copy.setTableFlag(Byte.valueOf((byte)1));
            copy.setChangeFromId(info.getChangeFromId());
            copy.setCidYear(null);
            copy.setCreateBy(loginUserId);
            copy.setCreateDate(new Date());
            copy.setUpdateBy(loginUserId);
            copy.setUpdateDate(new Date());
            info.setSourceId(copy.getId());
            info.setTableFlag(Byte.valueOf((byte)0));
            info.setChangeFromId(null);
            this.updateByPrimaryKey(info, loginUserId);
            this.add(copy);
        }
        return 1;
    }

    public List<SelfInspectionRiskAssessmentReportInfo> getAllHasExposeIdAndSelfIdByCid(Long loginStaffCompanyId) {
        Example example = new Example(SelfInspectionRiskAssessmentReportInfo.class);
        example.createCriteria().andIsNotNull("exposureReportId").andIsNotNull("selfReportId").andEqualTo("cid", (Object)loginStaffCompanyId).andEqualTo("isValid", (Object)true);
        List list = ((SelfInspectionRiskAssessmentReportInfoMapper)this.dao).selectByExample(example);
        return list;
    }

    public List<SelfInspectionRiskAssessmentReportInfo> getAllHasExposeIdAndChangeTypeByCidAndSelfId(Long cid, Long selfId) {
        if (selfId != null) {
            Example example = new Example(SelfInspectionRiskAssessmentReportInfo.class);
            example.createCriteria().andEqualTo("selfReportId", (Object)selfId).andEqualTo("cid", (Object)cid).andEqualTo("reportFromYear", (Object)2).andCondition("locate('2',change_reason)>0").andEqualTo("isValid", (Object)true);
            example.orderBy("createDate").desc();
            List list = ((SelfInspectionRiskAssessmentReportInfoMapper)this.dao).selectByExample(example);
            return list;
        }
        return null;
    }

    public List<SelfInspectionRiskAssessmentReportInfo> getAllHasExposeIdByCidAndSelfId(Long cid, Long selfId) {
        if (selfId != null) {
            Example example = new Example(SelfInspectionRiskAssessmentReportInfo.class);
            example.createCriteria().andEqualTo("selfReportId", (Object)selfId).andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true);
            example.orderBy("createDate").desc();
            List list = ((SelfInspectionRiskAssessmentReportInfoMapper)this.dao).selectByExample(example);
            return list;
        }
        return null;
    }

    private List<SelfInspectionRiskAssessmentReportInfo> getAllDataByRangeTime(Date beginDate, Date endDate, Long cid) {
        Example example = new Example(SelfInspectionRiskAssessmentReportInfo.class);
        example.createCriteria().andBetween("updateDate", (Object)beginDate, (Object)endDate).andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true);
        List list = ((SelfInspectionRiskAssessmentReportInfoMapper)this.dao).selectByExample(example);
        return list;
    }

    public List<SelfInspectionRiskAssessmentReportV314Vo> getAllHistoryReportInfo() {
        List<SelfInspectionRiskAssessmentReportV314Vo> temp = ((SelfInspectionRiskAssessmentReportInfoMapper)this.dao).getAllHistoryReportInfo();
        temp.forEach(item -> {
            if (item.getJudgeLevel() != null && item.getRiskLevel() != null) {
                HazardsRiskClassifyEnum riskClassifyEnum = HazardsRiskClassifyEnum.getThisEnumByJudgeLevelAndRiskLevel((JudgeResultLevelEnum)JudgeResultLevelEnum.getThisEnumByCode((Integer)item.getJudgeLevel()), (HazardsExposureRiskLevelEnum)HazardsExposureRiskLevelEnum.getThisEnumByCode((Integer)item.getRiskLevel()));
                item.setRiskClassify(riskClassifyEnum == null ? null : riskClassifyEnum.getCode());
                item.setRiskClassifyName(riskClassifyEnum == null ? null : riskClassifyEnum.getName());
            }
        });
        return temp;
    }

    public RiskExposeEvaluate mergerAdiationAndWandaRisk(Long searchCid) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        String startTime = dateFormat.format(new Date());
        this.logger.info("\u5408\u5e76\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\u65f6\u95f4 \uff1a " + startTime);
        RiskExposeEvaluate riskExposeEvaluate = null;
        List<Long> cidList = ((SelfInspectionRiskAssessmentReportInfoMapper)this.dao).getFangSheCompany(searchCid);
        for (Long cid : cidList) {
            if (cid == null) continue;
            List<SelfInspectionRiskAssessmentReportInfo> lastNewReportList = this.listDataV314EveryCidLatestForSuperviseByDateRange(null, null, Arrays.asList(cid));
            if (CollectionUtils.isNotEmpty(lastNewReportList)) {
                SelfInspectionRiskAssessmentReportInfo reportInfo = lastNewReportList.get(0);
                if (Objects.equals(reportInfo.getStatus(), (byte)1)) {
                    if ((!Byte.valueOf("2").equals(reportInfo.getReportFromYear()) || !StringUtils.isNotEmpty((String)reportInfo.getChangeReason()) || !reportInfo.getChangeReason().contains("1")) && !Byte.valueOf("1").equals(reportInfo.getReportFromYear())) continue;
                    riskExposeEvaluate = this.riskExposeEvaluateService.getLatestNeedReportEv(reportInfo.getCid());
                    continue;
                }
                if (Objects.equals(reportInfo.getStatus(), (byte)2) || Objects.equals(reportInfo.getStatus(), (byte)3)) {
                    boolean bl = false;
                    continue;
                }
                riskExposeEvaluate = this.riskExposeEvaluateService.getLatestEv(cid, null, Integer.valueOf(2));
                continue;
            }
            riskExposeEvaluate = this.riskExposeEvaluateService.getLatestEv(cid, null, Integer.valueOf(2));
        }
        String endTime = dateFormat.format(new Date());
        this.logger.info("\u5408\u5e76\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f\u65f6\u95f4 \uff1a " + endTime);
        return riskExposeEvaluate;
    }

    public List<RiskExposeEvaluate> listLastRiskExposeEvaluate(List<Long> cids) {
        if (CollectionUtils.isEmpty(cids)) {
            return null;
        }
        return ((SelfInspectionRiskAssessmentReportInfoMapper)this.dao).listLastRiskExposeEvaluate(cids);
    }
}

