/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.selfjudge;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.health.dao.base.selfjudge.OccupationalSelfJudgeV308Mapper;
import cn.smarthse.modules.health.entity.base.selfjudge.OccupationalSelfJudgeTermV308;
import cn.smarthse.modules.health.entity.base.selfjudge.OccupationalSelfJudgeV308;
import cn.smarthse.modules.health.entity.base.selfjudge.SelfInspectionRiskAssessmentReportHarmJudgeInfo;
import cn.smarthse.modules.health.entity.base.selfjudge.vo.SelfjudgeSearchVo;
import cn.smarthse.modules.health.enums.selfjudge.JudgeResultLevelEnum;
import cn.smarthse.modules.health.service.base.selfjudge.IOccupationalSelfJudgeTermV308Service;
import cn.smarthse.modules.health.service.base.selfjudge.IOccupationalSelfJudgeV308Service;
import cn.smarthse.modules.health.service.base.selfjudge.ISelfInspectionRiskAssessmentReportHarmJudgeInfoService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckTipService;
import cn.smarthse.modules.health.service.work.harmfactor.IHarmfactorWorkService;
import cn.smarthse.modules.health.service.work.judge.IJudgeEhsClassificationService;
import cn.smarthse.modules.health.vo.work.judge.ContractInformInfo;
import cn.smarthse.modules.health.vo.work.judge.FunOrganManagerInfo;
import cn.smarthse.modules.health.vo.work.judge.LastHarmFactorTestInfo;
import cn.smarthse.modules.health.vo.work.judge.PhcCheckInfo;
import cn.smarthse.modules.health.vo.work.judge.ShieldSendInfo;
import cn.smarthse.modules.health.vo.work.judge.TrainCertificateInfo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class OccupationalSelfJudgeV308ServiceImpl
extends BaseServiceImpl<OccupationalSelfJudgeV308Mapper, OccupationalSelfJudgeV308>
implements IOccupationalSelfJudgeV308Service {
    @Autowired(required=false)
    private IJudgeEhsClassificationService judgeEhsService;
    @Autowired
    private IStaffInfoService staffInfoServcie;
    @Autowired
    private IOccupationalSelfJudgeTermV308Service occupationalSelfJudgeTermV308Service;
    @Autowired(required=false)
    private ILiteArchiveService liteArchiveService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideByHSEService companyProvideByHSEService;
    @Autowired(required=false)
    private IHarmfactorWorkService harmfactorWorkService;
    @Autowired
    private IPhcPhysicalCheckTipService phcPhysicalCheckTipService;
    @Autowired
    private ISelfInspectionRiskAssessmentReportHarmJudgeInfoService selfInspectionRiskAssessmentReportHarmJudgeInfoService;

    public OccupationalSelfJudgeV308 getLastJudge(Long loginStaffId, Long loginStaffCompanyId) {
        Example example = new Example(OccupationalSelfJudgeV308.class);
        example.createCriteria().andEqualTo("cid", (Object)loginStaffCompanyId).andEqualTo("isValid", (Object)true);
        example.setOrderByClause("create_date desc");
        List list = ((OccupationalSelfJudgeV308Mapper)this.dao).selectByExample(example);
        if (list == null || list.isEmpty()) {
            return null;
        }
        ((OccupationalSelfJudgeV308)list.get(0)).setResultLevelName(JudgeResultLevelEnum.getThisEnumByCode((Integer)((OccupationalSelfJudgeV308)list.get(0)).getResultLevel().intValue()).getName());
        return (OccupationalSelfJudgeV308)list.get(0);
    }

    public OccupationalSelfJudgeV308 getThirdOrgLastJudge(Long loginStaffCompanyId) {
        Example example = new Example(OccupationalSelfJudgeV308.class);
        example.createCriteria().andEqualTo("cid", (Object)loginStaffCompanyId).andEqualTo("isValid", (Object)true).andEqualTo("judgeStatus", (Object)2).andEqualTo("dataSource", (Object)2);
        example.setOrderByClause("report_date desc");
        List list = ((OccupationalSelfJudgeV308Mapper)this.dao).selectByExample(example);
        if (list == null || list.isEmpty()) {
            return null;
        }
        ((OccupationalSelfJudgeV308)list.get(0)).setResultLevelName(JudgeResultLevelEnum.getThisEnumByCode((Integer)((OccupationalSelfJudgeV308)list.get(0)).getResultLevel().intValue()).getName());
        return (OccupationalSelfJudgeV308)list.get(0);
    }

    @Transactional(readOnly=false)
    public OccupationalSelfJudgeV308 create(Long loginStaffId, Long loginStaffCompanyId) {
        OccupationalSelfJudgeV308 lastJudge = this.getLastJudge(loginStaffId, loginStaffCompanyId);
        if (lastJudge != null && lastJudge.getJudgeStatus().equals((byte)1)) {
            return lastJudge;
        }
        OccupationalSelfJudgeV308 record = new OccupationalSelfJudgeV308();
        record.setJudgeStaffOrgId(loginStaffId);
        record.setJudgeStaffOrgName(this.staffInfoServcie.getStaffNameByStaffId(loginStaffId));
        return this.add(record, loginStaffId, loginStaffCompanyId);
    }

    @Transactional(readOnly=false)
    public OccupationalSelfJudgeV308 createReportSelfJudge(Long loginStaffId, Long loginStaffCompanyId, Long judgeInfoId) {
        SelfInspectionRiskAssessmentReportHarmJudgeInfo judgeInfo = (SelfInspectionRiskAssessmentReportHarmJudgeInfo)this.selfInspectionRiskAssessmentReportHarmJudgeInfoService.getById(judgeInfoId);
        OccupationalSelfJudgeV308 record = new OccupationalSelfJudgeV308();
        record.setJudgeStaffOrgId(loginStaffId);
        record.setSelfRiskReportInfoId(judgeInfo.getInfoId());
        record.setJudgeStaffOrgName(this.staffInfoServcie.getStaffNameByStaffId(loginStaffId));
        record = this.add(record, loginStaffId, loginStaffCompanyId);
        judgeInfo.setJudgeId(record.getId());
        this.selfInspectionRiskAssessmentReportHarmJudgeInfoService.update((Object)judgeInfo);
        return record;
    }

    @Transactional(readOnly=false)
    public OccupationalSelfJudgeV308 completeSubmit(OccupationalSelfJudgeV308 record, Long loginStaffId, Long loginStaffCompanyId) {
        if (record != null && record.getId() != null) {
            if (record.getTerms() != null && record.getTerms().size() > 0) {
                this.occupationalSelfJudgeTermV308Service.deleteBySelfId(record.getId(), loginStaffId);
                AtomicReference<Boolean> hasKeyTermNoGood = new AtomicReference<Boolean>(false);
                AtomicReference<Double> totalScore = new AtomicReference<Double>(0.0);
                AtomicReference<Double> termObtainScore = new AtomicReference<Double>(0.0);
                this.occupationalSelfJudgeTermV308Service.addBatch(record.getTerms().stream().map(s -> {
                    s.setCreateBy(loginStaffId);
                    s.setCreateDate(new Date());
                    s.setUpdateBy(loginStaffId);
                    s.setUpdateDate(new Date());
                    s.setIsValid(Boolean.valueOf(true));
                    if (s.getTermScore() == null && Byte.valueOf((byte)3).equals(s.getCheckResult())) {
                        hasKeyTermNoGood.set(true);
                    }
                    if (s.getTermScore() != null && s.getTermObtainScore() != null && s.getTermObtainScore() != -1.0) {
                        totalScore.updateAndGet(v -> v + s.getTermScore());
                        termObtainScore.updateAndGet(v -> v + s.getTermObtainScore());
                    } else {
                        s.setTermObtainScore(Double.valueOf(0.0));
                    }
                    return s;
                }).collect(Collectors.toList()));
                if (totalScore.get() == 0.0 || termObtainScore.get() == 0.0) {
                    record.setTotalScore(Long.valueOf(0L));
                } else {
                    record.setTotalScore(Long.valueOf(new BigDecimal(termObtainScore.get() * 100.0 / totalScore.get()).setScale(0, 4).longValue()));
                }
                if (hasKeyTermNoGood.get().booleanValue()) {
                    record.setResultLevel(Byte.valueOf((byte)3));
                } else {
                    record.setResultLevel(Byte.valueOf(JudgeResultLevelEnum.getThisEnumByScore((Double)((Object)record.getTotalScore())).getCode().byteValue()));
                }
            }
            this.update(record, loginStaffId);
            return record;
        }
        return null;
    }

    public int getHistoryCount(Long loginStaffId, Long loginStaffCompanyId) {
        Example example = new Example(OccupationalSelfJudgeV308.class);
        example.createCriteria().andEqualTo("cid", (Object)loginStaffCompanyId).andEqualTo("isValid", (Object)true).andEqualTo("judgeStatus", (Object)2);
        example.setOrderByClause("create_date desc");
        return ((OccupationalSelfJudgeV308Mapper)this.dao).selectCountByExample(example);
    }

    @Transactional(readOnly=false)
    public void giveUp(Long loginStaffId, Long loginStaffCompanyId) {
        OccupationalSelfJudgeV308 lastJudge = this.getLastJudge(loginStaffId, loginStaffCompanyId);
        if (lastJudge != null && lastJudge.getJudgeStatus().equals((byte)1)) {
            this.delete(lastJudge, loginStaffId);
        }
    }

    public PageInfo<OccupationalSelfJudgeV308> getHistoryList(int page, int rows, Long loginStaffId, Long loginStaffCompanyId) {
        Example example = new Example(OccupationalSelfJudgeV308.class);
        example.createCriteria().andEqualTo("cid", (Object)loginStaffCompanyId).andEqualTo("isValid", (Object)true).andEqualTo("judgeStatus", (Object)2);
        example.setOrderByClause("create_date desc");
        PageHelper.startPage((int)page, (int)rows);
        List list = ((OccupationalSelfJudgeV308Mapper)this.dao).selectByExample(example);
        list.forEach(s -> {
            if (s.getResultLevel() != null) {
                s.setResultLevelName(JudgeResultLevelEnum.getThisEnumByCode((Integer)s.getResultLevel().intValue()).getName());
            }
        });
        return new PageInfo(list);
    }

    public PageInfo<OccupationalSelfJudgeV308> getSelfjudgeList(JqGridParam jqGridParam, SelfjudgeSearchVo vo) {
        PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows());
        if (StringUtils.isEmpty((CharSequence)vo.getCompanyName())) {
            vo.setCompanyName(null);
        }
        List<OccupationalSelfJudgeV308> list = ((OccupationalSelfJudgeV308Mapper)this.dao).selectBySelfjudgeSearchVo(vo);
        return new PageInfo(list);
    }

    public OccupationalSelfJudgeV308 getOccupationalSelfJudgeV308ById(Long recordId) {
        OccupationalSelfJudgeV308 occupationalSelfJudgeV308 = (OccupationalSelfJudgeV308)this.getById(recordId);
        if (occupationalSelfJudgeV308 != null && occupationalSelfJudgeV308.getResultLevel() != null) {
            occupationalSelfJudgeV308.setResultLevelName(JudgeResultLevelEnum.getThisEnumByCode((Integer)occupationalSelfJudgeV308.getResultLevel().intValue()).getName());
        }
        return occupationalSelfJudgeV308;
    }

    @Transactional(readOnly=false)
    public void saveOrgSelfJudge(OccupationalSelfJudgeV308 selfJudgeV308) {
        List terms = selfJudgeV308.getTerms().stream().map(s -> {
            s.setCreateDate(new Date());
            s.setUpdateDate(new Date());
            s.setCreateBy(selfJudgeV308.getCreateBy());
            s.setUpdateBy(selfJudgeV308.getCreateBy());
            s.setIsValid(Boolean.valueOf(true));
            s.setSelfId(selfJudgeV308.getId());
            return s;
        }).collect(Collectors.toList());
        this.update(selfJudgeV308);
        OccupationalSelfJudgeV308 dbData = (OccupationalSelfJudgeV308)this.getById(selfJudgeV308.getId());
        HashMap mapMap = new HashMap();
        mapMap.put(dbData.getCid(), new HashMap());
        Long i = 1L;
        while (i <= 20L) {
            ((Map)mapMap.get(dbData.getCid())).put(i, true);
            Long l = i;
            i = i + 1L;
        }
        new Thread(() -> {
            this.termUniformityHandle(mapMap);
            terms.forEach(termV308 -> {
                termV308.setTermUniformity(Byte.valueOf((byte)1));
                boolean isRight = (Boolean)((Map)mapMap.get(dbData.getCid())).get(termV308.getTermNo());
                if (termV308.getTermNo() != 4L && termV308.getTermNo() != 7L && termV308.getTermNo() != 10L && termV308.getTermNo() != 14L && termV308.getTermNo() != 19L && (!isRight && termV308.getCheckResult() == 1 || isRight && termV308.getCheckResult() == 3)) {
                    termV308.setTermUniformity(Byte.valueOf((byte)2));
                }
            });
            this.occupationalSelfJudgeTermV308Service.deleteBySelfId(selfJudgeV308.getId(), selfJudgeV308.getCreateBy());
            this.occupationalSelfJudgeTermV308Service.addBatch(terms);
        }).start();
    }

    @Transactional(readOnly=false)
    public List<OccupationalSelfJudgeV308> importOccupationalSelfJudgeV308Datas(List<OccupationalSelfJudgeV308> records) {
        HashMap mapMap = new HashMap();
        for (OccupationalSelfJudgeV308 occupationalSelfJudge : records) {
            this.add(occupationalSelfJudge, occupationalSelfJudge.getCreateBy(), occupationalSelfJudge.getCid());
            if (mapMap.get(occupationalSelfJudge.getCid()) == null) {
                mapMap.put(occupationalSelfJudge.getCid(), new HashMap());
                Long i = 1L;
                while (i <= 20L) {
                    ((Map)mapMap.get(occupationalSelfJudge.getCid())).put(i, true);
                    Long l = i;
                    i = i + 1L;
                }
            }
            for (OccupationalSelfJudgeTermV308 s : occupationalSelfJudge.getTerms()) {
                if (s.getCheckResult() == null) {
                    s.setCheckResult(Byte.valueOf((byte)1));
                }
                s.setCreateBy(occupationalSelfJudge.getCreateBy());
                s.setCreateDate(new Date());
                s.setUpdateBy(occupationalSelfJudge.getCreateBy());
                s.setUpdateDate(new Date());
                s.setIsValid(Boolean.valueOf(true));
                s.setSelfId(occupationalSelfJudge.getId());
            }
        }
        new Thread(() -> {
            this.termUniformityHandle(mapMap);
            for (OccupationalSelfJudgeV308 judgeV308 : records) {
                for (OccupationalSelfJudgeTermV308 termV308 : judgeV308.getTerms()) {
                    termV308.setTermUniformity(Byte.valueOf((byte)1));
                    boolean isRight = (Boolean)((Map)mapMap.get(judgeV308.getCid())).get(termV308.getTermNo());
                    if (termV308.getTermNo() == 4L || termV308.getTermNo() == 7L || termV308.getTermNo() == 10L || termV308.getTermNo() == 14L || termV308.getTermNo() == 19L || (isRight || termV308.getCheckResult() != 1) && (!isRight || termV308.getCheckResult() != 3)) continue;
                    termV308.setTermUniformity(Byte.valueOf((byte)2));
                }
                this.occupationalSelfJudgeTermV308Service.addBatch(judgeV308.getTerms());
            }
        }).start();
        return records;
    }

    public OccupationalSelfJudgeV308 getCompleteLastJudge(Long loginStaffCompanyId) {
        Example example = new Example(OccupationalSelfJudgeV308.class);
        example.createCriteria().andEqualTo("cid", (Object)loginStaffCompanyId).andEqualTo("isValid", (Object)true).andEqualTo("judgeStatus", (Object)2);
        example.setOrderByClause("update_date desc");
        List list = ((OccupationalSelfJudgeV308Mapper)this.dao).selectByExample(example);
        if (list == null || list.isEmpty()) {
            return null;
        }
        ((OccupationalSelfJudgeV308)list.get(0)).setResultLevelName(JudgeResultLevelEnum.getThisEnumByCode((Integer)((OccupationalSelfJudgeV308)list.get(0)).getResultLevel().intValue()).getName());
        return (OccupationalSelfJudgeV308)list.get(0);
    }

    private void termUniformityHandle(Map<Long, Map<Long, Boolean>> cidMap) {
        for (Long cid : cidMap.keySet()) {
            Map<Long, Boolean> termsMap = cidMap.get(cid);
            int msInfoCountHasFile = this.judgeEhsService.getMsInfoCountHasFile(cid);
            int msPohopCount = this.judgeEhsService.getMsPohopCount(cid);
            termsMap.put(1L, msInfoCountHasFile > 0 && msPohopCount > 0);
            SysFileModel establishFile = this.judgeEhsService.getEstablishFile(cid);
            if (establishFile == null) {
                establishFile = new SysFileModel();
            }
            FunOrganManagerInfo funOrganMangerInfo = this.judgeEhsService.getFunOrganMangerInfo(cid);
            termsMap.put(2L, establishFile.getId() != null && funOrganMangerInfo.isHasEmployFile());
            Map archiveStatusMap = this.liteArchiveService.getArchiveStatus(cid, "" + Calendar.getInstance().get(1));
            termsMap.put(3L, archiveStatusMap.values().stream().filter(s -> s == 3).collect(Collectors.toList()).size() == 6);
            List thirdTimeInfo = this.judgeEhsService.getThirdTimeInfo(cid);
            termsMap.put(5L, thirdTimeInfo != null && thirdTimeInfo.size() > 0);
            LastHarmFactorTestInfo lastHarmFactorInfo = this.judgeEhsService.getLastHarmFactorInfo(cid);
            termsMap.put(6L, lastHarmFactorInfo == null || lastHarmFactorInfo.getInconformityNum() == 0);
            boolean isFinishedHarmFactorRegularCheck = this.judgeEhsService.isFinishedHarmFactorRegularCheck(cid, Calendar.getInstance().get(1));
            termsMap.put(8L, isFinishedHarmFactorRegularCheck);
            CompanyBaseInfoModel company = this.companyProvideByHSEService.getCompanyById(cid);
            int deviceOccupationalDiseaseNum = this.judgeEhsService.getDeviceOccupationalDiseaseNum(cid);
            termsMap.put(11L, deviceOccupationalDiseaseNum > 0);
            ShieldSendInfo shieldSendInfo = this.judgeEhsService.getShieldSendInfo(cid);
            List shieldPurchaseList = this.judgeEhsService.getShieldPurchaseList(cid);
            termsMap.put(12L, shieldSendInfo.getSendNum() > 0 || shieldPurchaseList != null && shieldPurchaseList.size() > 0);
            ContractInformInfo contractInformInfo = this.judgeEhsService.getContractInformInfo(cid);
            termsMap.put(13L, contractInformInfo != null && contractInformInfo.getInformNum() > 0);
            TrainCertificateInfo trainCertificateInfo = this.judgeEhsService.getTrainCertificateInfo(cid);
            termsMap.put(15L, trainCertificateInfo != null && trainCertificateInfo.getEhsTrainCertificateNum() > 0);
            PhcCheckInfo phcCheckInfo = this.judgeEhsService.getPhcCheckInfo(cid);
            int phcCheckNumJobing = this.judgeEhsService.getPhcCheckNumJobing(cid);
            termsMap.put(17L, phcCheckInfo.getPhcCheckNumPreJob() > 0 || phcCheckInfo.getPhcCheckNumLeftJob() > 0 || phcCheckNumJobing > 0);
            int undealAbnormalCount = this.phcPhysicalCheckTipService.undealAbnormalCount(cid);
            termsMap.put(18L, undealAbnormalCount == 0);
            int occupationalDiseasesNum = this.judgeEhsService.getOccupationalDiseasesNum(cid);
            termsMap.put(20L, occupationalDiseasesNum == 0);
        }
    }
}

