/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.selfjudge;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.dao.base.selfjudge.OccupationalSelfJudgeRecordMapper;
import cn.smarthse.modules.health.entity.base.selfjudge.OccupationalSelfJudgeRecord;
import cn.smarthse.modules.health.entity.base.selfjudge.OccupationalSelfJudgeV308;
import cn.smarthse.modules.health.service.base.selfjudge.IOccupationalSelfJudgeRecordService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.beans.PropertyDescriptor;
import java.util.Date;
import java.util.List;
import javax.cn.smarthse.modules.health.exception.BusinessException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Service(value="occupationalSelfJudgeRecordServiceImpl")
public class OccupationalSelfJudgeRecordServiceImpl
extends BaseServiceImpl<OccupationalSelfJudgeRecordMapper, OccupationalSelfJudgeRecord>
implements IOccupationalSelfJudgeRecordService {
    @Autowired
    private IStaffInfoService staffInfoServcie;
    @Autowired(required=false)
    private OccupationalSelfJudgeRecordMapper judgeRecordMapper;

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public synchronized OccupationalSelfJudgeRecord create(Long loginStaffId, Long cid) {
        OccupationalSelfJudgeRecord lastJudge = this.getLastJudge(loginStaffId, cid);
        if (lastJudge != null && lastJudge.getJudgeStatus().equals((byte)1)) {
            return lastJudge;
        }
        OccupationalSelfJudgeRecord record = new OccupationalSelfJudgeRecord();
        record.setJudgeStaffInfoId(loginStaffId);
        record.setJudgeStaffName(this.staffInfoServcie.getStaffNameByStaffId(loginStaffId));
        super.add(record, loginStaffId, cid);
        return (OccupationalSelfJudgeRecord)this.getById(record.getId());
    }

    public OccupationalSelfJudgeRecord getLastJudge(Long staffId, Long cid) {
        Example example = new Example(OccupationalSelfJudgeRecord.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true);
        example.setOrderByClause("create_date desc");
        List list = ((OccupationalSelfJudgeRecordMapper)this.dao).selectByExample(example);
        return list == null || list.isEmpty() ? null : (OccupationalSelfJudgeRecord)list.get(0);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void giveUp(Long staffId, Long cid) {
        OccupationalSelfJudgeRecord lastJudge = this.getLastJudge(staffId, cid);
        if (lastJudge != null && lastJudge.getJudgeStatus().equals((byte)1)) {
            super.delete(lastJudge, staffId);
        }
    }

    public PageInfo<OccupationalSelfJudgeRecord> getHistoryList(int pageNum, int pageSize, Long staffId, Long cid) {
        Example example = new Example(OccupationalSelfJudgeRecord.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true).andEqualTo("judgeStatus", (Object)2);
        example.setOrderByClause("create_date desc");
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List list = ((OccupationalSelfJudgeRecordMapper)this.dao).selectByExample(example);
        return new PageInfo(list);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public OccupationalSelfJudgeRecord completeSubmit(Long recordId, Long loginStaffId, Long cid) throws BusinessException {
        OccupationalSelfJudgeRecord record = (OccupationalSelfJudgeRecord)super.getById(recordId);
        if (record.getJudgeStatus().equals((byte)2)) {
            return record;
        }
        boolean checkResult = this.checkDone(record);
        if (!checkResult) {
            throw new BusinessException("\u8fd8\u6709\u8bc4\u5b9a\u9879\u672a\u5b8c\u6210");
        }
        Integer level = this.getResultLevel(record);
        record.setResultLevel(Byte.valueOf(level.byteValue()));
        record.setJudgeStatus(Byte.valueOf((byte)2));
        record.setUpdateBy(loginStaffId);
        record.setUpdateDate(new Date());
        super.updateByPrimaryKey(record, loginStaffId);
        return record;
    }

    private Boolean checkDone(OccupationalSelfJudgeRecord record) {
        PropertyDescriptor[] propertyDescriptors;
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors = PropertyUtils.getPropertyDescriptors((Object)record)) {
            boolean equals = propertyDescriptor.getPropertyType().equals(Byte.class);
            if (!equals) continue;
            byte value = 0;
            try {
                value = (Byte)propertyDescriptor.getReadMethod().invoke((Object)record, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.error("cn.smarthse.modules.health.service.base.impl.selfjudge.OccupationalSelfJudgeRecordServiceImpl.checkDone:" + e.getMessage());
                throw new RuntimeException(e);
            }
            if (value != -1) continue;
            return false;
        }
        return true;
    }

    private Integer getResultLevel(OccupationalSelfJudgeRecord record) {
        if (this.isAllVetoTermPassed(record)) {
            int generalTermPassNum = this.getGeneralTermNum(record);
            if (generalTermPassNum >= 11) {
                return 1;
            }
            if (generalTermPassNum >= 6) {
                return 2;
            }
        }
        return 3;
    }

    public Integer getGeneralTermNum(OccupationalSelfJudgeRecord record) {
        int num = 0;
        if (record.getManagerialSystem() == 1) {
            ++num;
        }
        if (record.getManagerialStaff() == 1) {
            ++num;
        }
        if (record.getSituationEvaluation() == 1) {
            ++num;
        }
        if (record.getOverProofSituation() == 1) {
            ++num;
        }
        if (record.getLocationSetup() == 1) {
            ++num;
        }
        if (record.getCaution() == 1) {
            ++num;
        }
        if (record.getThreeSameTime() == 1) {
            ++num;
        }
        if (record.getContractImpart() == 1) {
            ++num;
        }
        if (record.getFacilitiesEffective() == 1) {
            ++num;
        }
        if (record.getProtectionArticle() == 1) {
            ++num;
        }
        if (record.getUsingManagement() == 1) {
            ++num;
        }
        if (record.getPrincipalTraining() == 1) {
            ++num;
        }
        if (record.getWorkerTraining() == 1) {
            ++num;
        }
        if (record.getUpOffGuardPhysicalExam() == 1) {
            ++num;
        }
        if (record.getWardshipRecord() == 1) {
            ++num;
        }
        return num;
    }

    public Integer getVetoTermNum(OccupationalSelfJudgeRecord record) {
        int num = 0;
        if (record.getManagerialOrg() == 1) {
            ++num;
        }
        if (record.getHarmfulCheck() == 1) {
            ++num;
        }
        if (record.getProperRedistribution() == 1) {
            ++num;
        }
        if (record.getProjectApplication() == 1) {
            ++num;
        }
        if (record.getOnGuardPhysicalExam() == 1) {
            ++num;
        }
        if (record.getOccupationalDisease() == 1) {
            ++num;
        }
        if (record.getGovPunish() == 1) {
            ++num;
        }
        return num;
    }

    public OccupationalSelfJudgeRecord getLastJudge(Long cid, Integer year, Integer status) {
        return ((OccupationalSelfJudgeRecordMapper)this.dao).getLastJudge(cid, year, status);
    }

    public OccupationalSelfJudgeV308 getLastJudgeV308(Long cid, Integer year, Integer status) {
        return ((OccupationalSelfJudgeRecordMapper)this.dao).getLastJudgeV308(cid, year, status);
    }

    private boolean isAllVetoTermPassed(OccupationalSelfJudgeRecord record) {
        return this.getVetoTermNum(record) == 7;
    }
}

