/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.selfjudge;

import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.dao.base.selfjudge.MicroStaffUpdateSelfJudgeTermMapper;
import cn.smarthse.modules.health.entity.base.selfjudge.MicroOccupationalSelfJudgeTermV308;
import cn.smarthse.modules.health.entity.base.selfjudge.MicroStaffUpdateSelfJudgeTerm;
import cn.smarthse.modules.health.service.base.selfjudge.IMicroStaffUpdateSelfJudgeTermService;
import java.time.Year;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class MicroStaffUpdateSelfJudgeTermServiceImpl
extends BaseServiceImpl<MicroStaffUpdateSelfJudgeTermMapper, MicroStaffUpdateSelfJudgeTerm>
implements IMicroStaffUpdateSelfJudgeTermService {
    public List<MicroStaffUpdateSelfJudgeTerm> getStaffUpdateResults(MicroStaffUpdateSelfJudgeTerm staffUpdateSelfJudgeTerm) {
        if (CollectionUtils.isEmpty((Collection)staffUpdateSelfJudgeTerm.getCidList())) {
            throw new HealthException("\u4f01\u4e1aid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Date date = new Date();
        staffUpdateSelfJudgeTerm.setUpdateDate(date);
        return ((MicroStaffUpdateSelfJudgeTermMapper)this.dao).selectStaffUpdateResults(staffUpdateSelfJudgeTerm);
    }

    @Transactional(readOnly=false)
    public void addUpdateSelfJudgeTerm(MicroOccupationalSelfJudgeTermV308 needTerm, Byte status, Long loginStaffId, Long loginStaffCompanyId) {
        if (ObjectUtil.isNull((Object)needTerm) || ObjectUtil.isNull((Object)loginStaffCompanyId) || ObjectUtil.isNull((Object)needTerm.getTermNo())) {
            return;
        }
        Date date = new Date();
        Example example = new Example(MicroStaffUpdateSelfJudgeTerm.class);
        example.createCriteria().andEqualTo("cid", (Object)loginStaffCompanyId).andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("termNo", (Object)needTerm.getTermNo());
        MicroStaffUpdateSelfJudgeTerm staffUpdateSelfJudgeTerm = (MicroStaffUpdateSelfJudgeTerm)this.getOneByExample(example);
        if (ObjectUtil.isNull((Object)staffUpdateSelfJudgeTerm)) {
            staffUpdateSelfJudgeTerm = new MicroStaffUpdateSelfJudgeTerm();
        }
        staffUpdateSelfJudgeTerm.setCid(loginStaffCompanyId);
        staffUpdateSelfJudgeTerm.setSelfId(needTerm.getSelfId());
        staffUpdateSelfJudgeTerm.setYear(Integer.valueOf(Year.now().getValue()));
        staffUpdateSelfJudgeTerm.setTermNo(needTerm.getTermNo());
        staffUpdateSelfJudgeTerm.setCheckResult(Integer.valueOf(needTerm.getCheckResult().byteValue()));
        staffUpdateSelfJudgeTerm.setStatus(Integer.valueOf(status.byteValue()));
        List fileIdList = needTerm.getFileIdList();
        String fileIds = null;
        if (CollectionUtils.isNotEmpty((Collection)fileIdList)) {
            fileIds = fileIdList.stream().map(String::valueOf).collect(Collectors.joining(","));
        }
        staffUpdateSelfJudgeTerm.setFileId(fileIds);
        staffUpdateSelfJudgeTerm.setReportDate(date);
        staffUpdateSelfJudgeTerm.setIsValid(Boolean.valueOf(true));
        staffUpdateSelfJudgeTerm.setCreateBy(loginStaffId);
        staffUpdateSelfJudgeTerm.setUpdateBy(loginStaffId);
        staffUpdateSelfJudgeTerm.setCreateDate(date);
        staffUpdateSelfJudgeTerm.setUpdateDate(date);
        if (ObjectUtil.isNotNull((Object)staffUpdateSelfJudgeTerm.getId())) {
            ((MicroStaffUpdateSelfJudgeTermMapper)this.dao).updateByPrimaryKey(staffUpdateSelfJudgeTerm);
        } else {
            staffUpdateSelfJudgeTerm.setId(Long.valueOf(this.idworker.nextId()));
            ((MicroStaffUpdateSelfJudgeTermMapper)this.dao).insert(staffUpdateSelfJudgeTerm);
        }
    }

    @Transactional(readOnly=false)
    public void setStatusByCids(Byte status, List<Long> cids, List<Long> termNoList, Long loginStaffId) {
        if (ObjectUtil.isNull((Object)status) || CollectionUtils.isEmpty(cids)) {
            return;
        }
        ((MicroStaffUpdateSelfJudgeTermMapper)this.dao).setStatusByCids(status, cids, termNoList, loginStaffId, new Date());
    }
}

