/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.selfjudge;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.enums.CompanyOccTypeEnum;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.entity.base.company.grade.MicroCompanyGradeV3Rec;
import cn.smarthse.modules.health.entity.base.selfjudge.MicroStaffUpdateSelfJudgeTerm;
import cn.smarthse.modules.health.entity.base.selfjudge.dto.MicroKeyFactoryParam;
import cn.smarthse.modules.health.entity.base.selfjudge.vo.MicroSelfJudgeTermResultsVo;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalCheckV3221;
import cn.smarthse.modules.health.entity.work.reform.ReformItemBasic;
import cn.smarthse.modules.health.enums.reform.ReformGenerationSourceEnum;
import cn.smarthse.modules.health.service.base.selfjudge.IMicroStaffUpdateSelfJudgeTermService;
import cn.smarthse.modules.health.service.work.check.checkV3221.IPhcPhysicalCheckV3221Service;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicCommandService;
import cn.smarthse.modules.health.supervise.service.company.grade.IMicroCompanyGradeV3RecService;
import cn.smarthse.modules.health.vo.summary.ReformSearchVo;
import cn.smarthse.services.hfi.api.model.list.CheckPlanList;
import cn.smarthse.services.hfi.api.model.list.CheckPlanListParam;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import cn.smarthse.services.wanda.api.entity.WandaDeclare;
import cn.smarthse.services.wanda.api.service.IWandaDeclareService;
import jakarta.annotation.PostConstruct;
import java.time.LocalDateTime;
import java.time.Year;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MicroFunctionInterfaceStrategy {
    @DubboReference
    private IWandaDeclareService declareService;
    @Autowired
    private IReformItemBasicCommandService reformItemBasicCommandService;
    @DubboReference
    private IMicroCompanyGradeV3RecService gradeV3RecService;
    @DubboReference
    private ICheckPlanService checkPlanService;
    @Autowired
    private IPhcPhysicalCheckV3221Service phcPhysicalCheckV3221Service;
    @Autowired
    private IMicroStaffUpdateSelfJudgeTermService microStaffUpdateSelfJudgeTermService;
    @DubboReference
    private ISysFileProvideService sysFileProvideService;
    private Map<Long, Function<MicroKeyFactoryParam, ResponseData>> operationMap;

    @PostConstruct
    private void init() {
        this.operationMap = new HashMap<Long, Function<MicroKeyFactoryParam, ResponseData>>();
        this.operationMap.put(1L, this::declareData);
        this.operationMap.put(2L, this::hazardFactorsConcentrationIntensity);
        this.operationMap.put(3L, this::hazardDetection);
        this.operationMap.put(4L, this::personnelTrain);
        this.operationMap.put(5L, this::phcCheck);
        this.operationMap.put(6L, this::phcCheckProcess);
        this.operationMap.put(7L, this::protectiveEquipment);
    }

    public ResponseData doOperation(MicroKeyFactoryParam params, Long status) {
        return this.operationMap.get(status).apply(params);
    }

    private ResponseData declareData(MicroKeyFactoryParam param) {
        ArrayList<MicroSelfJudgeTermResultsVo> microSelfJudgeTermResultsVos = new ArrayList<MicroSelfJudgeTermResultsVo>();
        List cidList = param.getCidList();
        if (CollectionUtil.isEmpty((Collection)cidList)) {
            return ResponseData.success(microSelfJudgeTermResultsVos);
        }
        List wandaDeclares = this.declareService.countWandaDeclareValid(cidList);
        Map<Long, WandaDeclare> wandaDeclareCountMap = wandaDeclares.stream().collect(Collectors.toMap(WandaDeclare::getCid, w -> w, (w1, w2) -> w1));
        ReformSearchVo searchVo = new ReformSearchVo();
        searchVo.setCidList(cidList);
        searchVo.setGenerationSource(ReformGenerationSourceEnum.DECLARE.getValue());
        searchVo.setIsCompleted(Boolean.valueOf(false));
        List reformItemBasicList = this.reformItemBasicCommandService.getReformItemBasicList(searchVo);
        Map<Long, List<ReformItemBasic>> reformItemBasicMap = reformItemBasicList.stream().collect(Collectors.groupingBy(ReformItemBasic::getCid));
        for (Long cid : cidList) {
            List<ReformItemBasic> reformItemBasics;
            ArrayList<String> referenceDataList = new ArrayList<String>();
            Integer checkResult = 1;
            WandaDeclare wandaDeclare = wandaDeclareCountMap.get(cid);
            if ((ObjectUtil.isNull((Object)wandaDeclare) || wandaDeclare.getCount() == 0) && CollectionUtil.isNotEmpty(reformItemBasics = reformItemBasicMap.get(cid))) {
                checkResult = 3;
            }
            if (checkResult == 1) {
                referenceDataList.add("\u4f01\u4e1a\u5b58\u5728\u7533\u62a5\u6570\u636e");
            } else {
                referenceDataList.add("\u4f01\u4e1a\u4e0d\u5b58\u5728\u7533\u62a5\u6570\u636e");
            }
            MicroSelfJudgeTermResultsVo microSelfJudgeTermResultsVo = new MicroSelfJudgeTermResultsVo();
            microSelfJudgeTermResultsVo.setCid(cid);
            microSelfJudgeTermResultsVo.setTermNo(Long.valueOf(1L));
            microSelfJudgeTermResultsVo.setTermName("\u804c\u4e1a\u75c5\u5371\u5bb3\u9879\u76ee\u7533\u62a5");
            microSelfJudgeTermResultsVo.setCheckResult(checkResult);
            microSelfJudgeTermResultsVo.setTermScore(Double.valueOf(checkResult == 1 ? 15.0 : 0.0));
            microSelfJudgeTermResultsVo.setCheckResultChangeable(Arrays.asList(1, 2, 3, 4));
            microSelfJudgeTermResultsVo.setReferenceDataList(referenceDataList);
            microSelfJudgeTermResultsVos.add(microSelfJudgeTermResultsVo);
        }
        return ResponseData.success(microSelfJudgeTermResultsVos);
    }

    private ResponseData hazardFactorsConcentrationIntensity(MicroKeyFactoryParam param) {
        ArrayList<MicroSelfJudgeTermResultsVo> microSelfJudgeTermResultsVos = new ArrayList<MicroSelfJudgeTermResultsVo>();
        List cidList = param.getCidList();
        if (CollectionUtil.isEmpty((Collection)cidList)) {
            return ResponseData.success(microSelfJudgeTermResultsVos);
        }
        List resultList = param.getMicroSelfJudgeTermResultsVos();
        if (CollectionUtil.isEmpty((Collection)resultList)) {
            ResponseData responseData = this.hazardDetection(param);
            resultList = (List)responseData.getResult();
        }
        Integer currentYear = Year.now().getValue();
        Map<Long, MicroSelfJudgeTermResultsVo> resultsVoMap = resultList.stream().collect(Collectors.toMap(MicroSelfJudgeTermResultsVo::getCid, r -> r, (r1, r2) -> r1));
        CheckPlanListParam checkPlanListParam = new CheckPlanListParam();
        Date beginTime = DateUtils.getYearFirstTime((int)(currentYear - 3));
        Date endTime = DateUtils.getYearLastTime((int)currentYear);
        checkPlanListParam.setCheckDateBegin(beginTime);
        checkPlanListParam.setCheckDateEnd(endTime);
        checkPlanListParam.setCids(cidList);
        checkPlanListParam.setIfNeedHarms(Boolean.valueOf(false));
        checkPlanListParam.setCheckTypes(Arrays.asList(2, 3, 4));
        checkPlanListParam.setStatus(Arrays.asList(2, 3));
        List checkPlanList = this.checkPlanService.getCheckPlanListByCids(checkPlanListParam);
        Map<Long, List<CheckPlanList>> checkPlanListMap = checkPlanList.stream().collect(Collectors.groupingBy(CheckPlanList::getCid));
        ReformSearchVo searchVo = new ReformSearchVo();
        searchVo.setCidList(cidList);
        searchVo.setGenerationSource(ReformGenerationSourceEnum.JCCB.getValue());
        searchVo.setIsCompleted(Boolean.valueOf(false));
        searchVo.setYearList(Arrays.asList(currentYear - 1, currentYear - 2, currentYear - 3));
        List beforeReformItemBasicList = this.reformItemBasicCommandService.getReformItemBasicList(searchVo);
        Map<Long, List<ReformItemBasic>> beforeReformItemBasicMap = beforeReformItemBasicList.stream().collect(Collectors.groupingBy(ReformItemBasic::getCid));
        searchVo.setYearList(Arrays.asList(currentYear, currentYear - 1, currentYear - 2));
        List currentReformItemBasicList = this.reformItemBasicCommandService.getReformItemBasicList(searchVo);
        Map<Long, List<ReformItemBasic>> currentReformItemBasicMap = currentReformItemBasicList.stream().collect(Collectors.groupingBy(ReformItemBasic::getCid));
        for (Long cid : cidList) {
            ArrayList<String> referenceDataList = new ArrayList<String>();
            Integer checkResult = 1;
            MicroSelfJudgeTermResultsVo resultsVo = resultsVoMap.get(cid);
            List<CheckPlanList> checkPlanLists = checkPlanListMap.get(cid);
            if (ObjectUtil.isNotNull((Object)resultsVo) && resultsVo.getCheckResult() == 3) {
                checkResult = 3;
                referenceDataList.add("\u7b2c3\u9879\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u68c0\u6d4b\u4e3a\u4e0d\u7b26\u5408");
            } else if (CollectionUtil.isNotEmpty(checkPlanLists)) {
                List<ReformItemBasic> cycleReformItemBasics = currentReformItemBasicMap.get(cid);
                Long currentYearCount = checkPlanLists.stream().filter(c -> ObjectUtil.isNotNull((Object)c.getCheckEndTime())).filter(c -> {
                    LocalDateTime dateTime = c.getCheckEndTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
                    return dateTime.getYear() == currentYear.intValue();
                }).count();
                Integer cycleYear = Year.now().getValue();
                if (currentYearCount == 0L) {
                    Integer n = cycleYear;
                    cycleYear = cycleYear - 1;
                    cycleReformItemBasics = beforeReformItemBasicMap.get(cid);
                }
                Date cycleBeginTime = DateUtils.getYearFirstTime((int)(cycleYear - 2));
                Date cycleEndTime = DateUtils.getYearLastTime((int)cycleYear);
                List cycleCheckPlanLists = checkPlanLists.stream().filter(c -> ObjectUtil.isNotNull((Object)c.getCheckBeginTime()) && c.getCheckBeginTime().after(cycleBeginTime) && ObjectUtil.isNotNull((Object)c.getCheckEndTime()) && c.getCheckEndTime().before(cycleEndTime)).collect(Collectors.toList());
                Long count = cycleCheckPlanLists.stream().filter(c -> ObjectUtil.isNotNull((Object)c.getOverPoints()) && c.getOverPoints() > 0).count();
                if (count != 0L) {
                    checkResult = 2;
                    Long riskLevelCount = cycleCheckPlanLists.stream().filter(c -> ObjectUtil.isNotNull((Object)c.getRiskLevel()) && ObjectUtil.isNotNull((Object)c.getOverPoints()) && c.getRiskLevel() == 1 && c.getOverPoints() > 0).count();
                    if (riskLevelCount != 0L || CollectionUtil.isNotEmpty(cycleReformItemBasics)) {
                        checkResult = 3;
                    }
                    if (riskLevelCount != 0L) {
                        referenceDataList.add("\u4e25\u91cd\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u5b58\u5728\u8d85\u6807");
                    }
                    if (CollectionUtil.isNotEmpty(cycleReformItemBasics)) {
                        referenceDataList.add("\u5176\u4ed6\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u8d85\u6807\u68c0\u6d4b\u7ed3\u679c\u672a\u5904\u7f6e");
                    }
                } else if (CollectionUtil.isNotEmpty(cycleReformItemBasics)) {
                    checkResult = 3;
                    referenceDataList.add("\u8d85\u6807\u68c0\u6d4b\u7ed3\u679c\u672a\u5904\u7f6e");
                }
            }
            if (checkResult == 1) {
                referenceDataList.add("\u68c0\u6d4b\u7ed3\u679c\u5168\u90e8\u8fbe\u6807");
            } else if (checkResult == 2) {
                referenceDataList.add("\u4e25\u91cd\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u5168\u90e8\u8fbe\u6807\uff1b\u4e14\u5176\u4ed6\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u5168\u90e8\u8d85\u6807\u68c0\u6d4b\u7ed3\u679c\u5747\u5df2\u5904\u7f6e");
            }
            Double termScore = 15.0;
            if (checkResult == 2) {
                termScore = termScore / 2.0;
            } else if (checkResult == 3) {
                termScore = 0.0;
            }
            MicroSelfJudgeTermResultsVo microSelfJudgeTermResultsVo = new MicroSelfJudgeTermResultsVo();
            microSelfJudgeTermResultsVo.setCid(cid);
            microSelfJudgeTermResultsVo.setTermNo(Long.valueOf(2L));
            microSelfJudgeTermResultsVo.setTermName("\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u6d53\u5ea6\u6216\u5f3a\u5ea6\u548c\u6cbb\u7406\u63aa\u65bd");
            microSelfJudgeTermResultsVo.setCheckResult(checkResult);
            microSelfJudgeTermResultsVo.setTermScore(termScore);
            microSelfJudgeTermResultsVo.setCheckResultChangeable(Arrays.asList(1, 2, 3, 4));
            microSelfJudgeTermResultsVo.setReferenceDataList(referenceDataList);
            microSelfJudgeTermResultsVos.add(microSelfJudgeTermResultsVo);
        }
        return ResponseData.success(microSelfJudgeTermResultsVos);
    }

    private ResponseData hazardDetection(MicroKeyFactoryParam param) {
        ArrayList<MicroSelfJudgeTermResultsVo> microSelfJudgeTermResultsVos = new ArrayList<MicroSelfJudgeTermResultsVo>();
        List cidList = param.getCidList();
        if (CollectionUtil.isEmpty((Collection)cidList)) {
            return ResponseData.success(microSelfJudgeTermResultsVos);
        }
        List gradeByCids = this.gradeV3RecService.getGradeByCids(cidList);
        Map<Long, MicroCompanyGradeV3Rec> companyGradeV3RecMap = gradeByCids.stream().collect(Collectors.toMap(MicroCompanyGradeV3Rec::getCid, c -> c, (c1, c2) -> c1));
        CheckPlanListParam checkPlanListParam = new CheckPlanListParam();
        checkPlanListParam.setCids(cidList);
        checkPlanListParam.setIfNeedHarms(Boolean.valueOf(false));
        checkPlanListParam.setCheckTypes(Arrays.asList(2, 3, 4));
        checkPlanListParam.setStatus(Arrays.asList(2, 3));
        List checkPlanList = this.checkPlanService.getCheckPlanListByCids(checkPlanListParam);
        Map<Long, List<CheckPlanList>> checkPlanMap = checkPlanList.stream().collect(Collectors.groupingBy(CheckPlanList::getCid));
        for (Long cid : cidList) {
            ArrayList<String> referenceDataList = new ArrayList<String>();
            Integer checkResult = 1;
            List<CheckPlanList> checkPlanLists = checkPlanMap.get(cid);
            if (CollectionUtil.isEmpty(checkPlanLists)) {
                checkResult = 3;
                referenceDataList.add("\u6ca1\u6709\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u68c0\u6d4b\u6570\u636e");
            } else {
                Map<Integer, List<CheckPlanList>> checkYearMap = checkPlanLists.stream().filter(c -> ObjectUtil.isNotNull((Object)c.getCheckEndTime())).collect(Collectors.groupingBy(c -> {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(c.getCheckEndTime());
                    return cal.get(1);
                }));
                if (MapUtil.isEmpty(checkYearMap)) {
                    checkResult = 3;
                    referenceDataList.add("\u6ca1\u6709\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u68c0\u6d4b\u6570\u636e");
                } else {
                    MicroCompanyGradeV3Rec companyGradeV3Rec;
                    Integer currentYear = Year.now().getValue();
                    List<CheckPlanList> checkPlanListList = checkYearMap.get(currentYear);
                    if (CollectionUtil.isEmpty(checkPlanListList)) {
                        Integer n = currentYear;
                        currentYear = currentYear - 1;
                    }
                    if (ObjectUtil.isNotNull((Object)(companyGradeV3Rec = companyGradeV3RecMap.get(cid))) && CompanyOccTypeEnum.SERIOUS.getCode().equals(companyGradeV3Rec.getOccType())) {
                        for (int i = 0; i < 3; ++i) {
                            List<CheckPlanList> checkPlanLists1 = checkYearMap.get(currentYear - i);
                            if (!CollectionUtil.isEmpty(checkPlanLists1)) continue;
                            checkResult = 3;
                            referenceDataList.add("\u5371\u5bb3\u4e25\u91cd\u7684\u4f01\u4e1a\u8fd13\u5e74\u4efb\u4e00\u5e74\u4efd\u6ca1\u6709\u5f00\u5c55\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u68c0\u6d4b");
                            break;
                        }
                    } else {
                        List<CheckPlanList> checkPlanLists1 = checkYearMap.get(currentYear);
                        List<CheckPlanList> checkPlanLists2 = checkYearMap.get(currentYear - 1);
                        List<CheckPlanList> checkPlanLists3 = checkYearMap.get(currentYear - 2);
                        if (CollectionUtil.isEmpty(checkPlanLists1) && CollectionUtil.isEmpty(checkPlanLists2) && CollectionUtil.isEmpty(checkPlanLists3)) {
                            checkResult = 3;
                            referenceDataList.add("\u5371\u5bb3\u4e00\u822c\u7684\u4f01\u4e1a\u6ca1\u67093\u5e74\u5185\u7684\u6709\u6548\u68c0\u6d4b\u6570\u636e");
                        }
                    }
                }
            }
            if (checkResult == 1) {
                referenceDataList.add("\u5371\u5bb3\u4e25\u91cd\u7684\u4f01\u4e1a\u6bcf\u5e74\u90fd\u6709\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u68c0\u6d4b\u6570\u636e\uff1b\u5371\u5bb3\u4e00\u822c\u7684\u4f01\u4e1a\u67093\u5e74\u5185\u7684\u6709\u6548\u68c0\u6d4b\u6570\u636e");
            }
            MicroSelfJudgeTermResultsVo microSelfJudgeTermResultsVo = new MicroSelfJudgeTermResultsVo();
            microSelfJudgeTermResultsVo.setCid(cid);
            microSelfJudgeTermResultsVo.setTermNo(Long.valueOf(3L));
            microSelfJudgeTermResultsVo.setTermName("\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u68c0\u6d4b");
            microSelfJudgeTermResultsVo.setCheckResult(checkResult);
            microSelfJudgeTermResultsVo.setTermScore(Double.valueOf(checkResult == 1 ? 15.0 : 0.0));
            microSelfJudgeTermResultsVo.setCheckResultChangeable(Arrays.asList(1, 2, 3, 4));
            microSelfJudgeTermResultsVo.setReferenceDataList(referenceDataList);
            microSelfJudgeTermResultsVos.add(microSelfJudgeTermResultsVo);
        }
        return ResponseData.success(microSelfJudgeTermResultsVos);
    }

    private ResponseData personnelTrain(MicroKeyFactoryParam param) {
        ArrayList<MicroSelfJudgeTermResultsVo> microSelfJudgeTermResultsVos = new ArrayList<MicroSelfJudgeTermResultsVo>();
        List cidList = param.getCidList();
        if (CollectionUtil.isEmpty((Collection)cidList)) {
            return ResponseData.success(microSelfJudgeTermResultsVos);
        }
        ReformSearchVo searchVo = new ReformSearchVo();
        Integer currentYear = Year.now().getValue();
        searchVo.setCidList(cidList);
        searchVo.setGenerationSource(ReformGenerationSourceEnum.TRAIN.getValue());
        searchVo.setIsCompleted(Boolean.valueOf(false));
        searchVo.setYearList(Arrays.asList(currentYear - 1, currentYear - 2, currentYear - 3));
        List reformItemBasicList = this.reformItemBasicCommandService.getReformItemBasicList(searchVo);
        Map<Long, List<ReformItemBasic>> reformItemBasicMap = reformItemBasicList.stream().collect(Collectors.groupingBy(ReformItemBasic::getCid));
        for (Long cid : cidList) {
            ArrayList<String> referenceDataList = new ArrayList<String>();
            Integer checkResult = 1;
            List<ReformItemBasic> reformItemBasics = reformItemBasicMap.get(cid);
            if (CollectionUtil.isNotEmpty(reformItemBasics)) {
                checkResult = 3;
            }
            if (checkResult == 1) {
                referenceDataList.add("\u6700\u8fd1\u4e00\u4e2a\u5468\u671f\u4e0d\u5b58\u5728\u201c\u672a\u6309\u8981\u6c42\u5f00\u5c55\u4e3b\u8981\u8d1f\u8d23\u4eba\u6216\u804c\u4e1a\u536b\u751f\u7ba1\u7406\u4eba\u5458\u57f9\u8bad\u98ce\u9669\u201d\u6216\u98ce\u9669\u5168\u90e8\u201c\u5df2\u6574\u6539\u201d");
            } else if (checkResult == 3) {
                referenceDataList.add("\u6700\u8fd1\u4e00\u4e2a\u5468\u671f\u5185\u4efb\u4e00\u5e74\u4efd\u5b58\u5728\u672a\u6574\u6539\u7684\u201c\u672a\u6309\u8981\u6c42\u5f00\u5c55\u4e3b\u8981\u8d1f\u8d23\u4eba\u6216\u804c\u4e1a\u536b\u751f\u7ba1\u7406\u4eba\u5458\u57f9\u8bad\u98ce\u9669\u201d");
            }
            MicroSelfJudgeTermResultsVo microSelfJudgeTermResultsVo = new MicroSelfJudgeTermResultsVo();
            microSelfJudgeTermResultsVo.setCid(cid);
            microSelfJudgeTermResultsVo.setTermNo(Long.valueOf(4L));
            microSelfJudgeTermResultsVo.setTermName("\u4e3b\u8981\u8d1f\u8d23\u4eba\u548c\u804c\u4e1a\u536b\u751f\u7ba1\u7406\u4eba\u5458\u57f9\u8bad");
            microSelfJudgeTermResultsVo.setCheckResult(checkResult);
            microSelfJudgeTermResultsVo.setTermScore(Double.valueOf(checkResult == 1 ? 15.0 : 0.0));
            microSelfJudgeTermResultsVo.setCheckResultChangeable(Arrays.asList(1, 2, 3, 4));
            microSelfJudgeTermResultsVo.setReferenceDataList(referenceDataList);
            microSelfJudgeTermResultsVos.add(microSelfJudgeTermResultsVo);
        }
        return ResponseData.success(microSelfJudgeTermResultsVos);
    }

    private ResponseData phcCheck(MicroKeyFactoryParam param) {
        ArrayList<MicroSelfJudgeTermResultsVo> microSelfJudgeTermResultsVos = new ArrayList<MicroSelfJudgeTermResultsVo>();
        List cidList = param.getCidList();
        if (CollectionUtil.isEmpty((Collection)cidList)) {
            return ResponseData.success(microSelfJudgeTermResultsVos);
        }
        MicroStaffUpdateSelfJudgeTerm staffUpdateSelfJudgeTerm = new MicroStaffUpdateSelfJudgeTerm();
        staffUpdateSelfJudgeTerm.setCidList(cidList);
        staffUpdateSelfJudgeTerm.setTermNo(Long.valueOf(5L));
        staffUpdateSelfJudgeTerm.setValidData(Boolean.valueOf(true));
        List staffUpdateSelfJudgeTerms = this.microStaffUpdateSelfJudgeTermService.getStaffUpdateResults(staffUpdateSelfJudgeTerm);
        Map<Long, MicroStaffUpdateSelfJudgeTerm> microStaffUpdateSelfJudgeTermMap = staffUpdateSelfJudgeTerms.stream().filter(s -> ObjectUtil.isNotNull((Object)s.getCheckResult())).collect(Collectors.toMap(MicroStaffUpdateSelfJudgeTerm::getCid, m -> m, (m1, m2) -> m1));
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime threeYearsAgo = now.minusYears(3L);
        ReformSearchVo reformSearchVo = new ReformSearchVo();
        reformSearchVo.setCidList(cidList);
        reformSearchVo.setBeginFindDate(threeYearsAgo.format(formatter));
        reformSearchVo.setEndFindDate(now.format(formatter));
        List phcPhysicalCheckV3221s = this.phcPhysicalCheckV3221Service.getAllPhcCheckInfoByCids(reformSearchVo);
        Map<Long, List<PhcPhysicalCheckV3221>> phcMap = phcPhysicalCheckV3221s.stream().collect(Collectors.groupingBy(PhcPhysicalCheckV3221::getCid));
        for (Long cid : cidList) {
            MicroSelfJudgeTermResultsVo microSelfJudgeTermResultsVo = new MicroSelfJudgeTermResultsVo();
            ArrayList<String> referenceDataList = new ArrayList<String>();
            Integer checkResult = 3;
            MicroStaffUpdateSelfJudgeTerm selfJudgeTerm = microStaffUpdateSelfJudgeTermMap.get(cid);
            if (ObjectUtil.isNotNull((Object)selfJudgeTerm)) {
                checkResult = selfJudgeTerm.getCheckResult();
                String fileIds = selfJudgeTerm.getFileId();
                if (StringUtils.isNotEmpty((String)fileIds)) {
                    String[] split = fileIds.split(",");
                    ArrayList<SysFileModel> sysFileModels = new ArrayList<SysFileModel>();
                    for (String fileId : split) {
                        SysFileModel sysFileModel;
                        Boolean creatable = NumberUtils.isCreatable((String)fileId);
                        if (!creatable.booleanValue() || !ObjectUtil.isNotNull((Object)(sysFileModel = this.sysFileProvideService.getFileById(Long.valueOf(fileId))))) continue;
                        sysFileModels.add(sysFileModel);
                    }
                    microSelfJudgeTermResultsVo.setDetailedData(sysFileModels);
                }
                referenceDataList.add("\u4f01\u4e1a\u624b\u52a8\u5224\u65ad");
            } else {
                List<PhcPhysicalCheckV3221> phcPhysicalCheckV3221List = phcMap.get(cid);
                if (CollectionUtil.isNotEmpty(phcPhysicalCheckV3221List)) {
                    Long count = phcPhysicalCheckV3221List.stream().filter(p -> p.getBodyCheckType() == 1).count();
                    if (count != 0L) {
                        Calendar today = Calendar.getInstance();
                        Calendar endDate1 = (Calendar)today.clone();
                        Calendar startDate1 = (Calendar)today.clone();
                        startDate1.add(1, -1);
                        Calendar endDate2 = (Calendar)startDate1.clone();
                        Calendar startDate2 = (Calendar)startDate1.clone();
                        startDate2.add(1, -1);
                        Calendar endDate3 = (Calendar)startDate2.clone();
                        Calendar startDate3 = (Calendar)startDate2.clone();
                        startDate3.add(1, -1);
                        Map<String, List<PhcPhysicalCheckV3221>> phcYearMap = phcPhysicalCheckV3221List.stream().filter(p -> p.getBodyCheckType() == 2).collect(Collectors.groupingBy(p -> {
                            Date checkTime = p.getCheckTime();
                            Calendar cal = Calendar.getInstance();
                            cal.setTime(checkTime);
                            if (checkTime.compareTo(startDate1.getTime()) >= 0 && checkTime.compareTo(endDate1.getTime()) <= 0) {
                                return "period1";
                            }
                            if (checkTime.compareTo(startDate2.getTime()) >= 0 && checkTime.compareTo(endDate2.getTime()) <= 0) {
                                return "period2";
                            }
                            if (checkTime.compareTo(startDate3.getTime()) >= 0 && checkTime.compareTo(endDate3.getTime()) <= 0) {
                                return "period3";
                            }
                            return "other";
                        }));
                        if (MapUtil.isNotEmpty(phcYearMap)) {
                            Boolean hasPeriod1 = CollectionUtil.isNotEmpty((Collection)phcYearMap.get("period1"));
                            Boolean hasPeriod2 = CollectionUtil.isNotEmpty((Collection)phcYearMap.get("period2"));
                            Boolean hasPeriod3 = CollectionUtil.isNotEmpty((Collection)phcYearMap.get("period3"));
                            if (hasPeriod1.booleanValue() && hasPeriod2.booleanValue() && hasPeriod3.booleanValue()) {
                                checkResult = 1;
                                referenceDataList.add("\u8fd13\u5e74\u6709\u4e0a\u5c97\u524d\u4f53\u68c0\u8bb0\u5f55\uff0c\u4e14\u8fd13\u5e74\u6bcf\u5e74\u90fd\u6709\u5728\u5c97\u671f\u95f4\u4f53\u68c0\u8bb0\u5f55");
                            } else {
                                referenceDataList.add("\u8fd13\u5e74\u4e0d\u662f\u6bcf\u5e74\u90fd\u6709\u5728\u5c97\u671f\u95f4\u4f53\u68c0\u6570\u636e");
                            }
                        } else {
                            referenceDataList.add("\u8fd13\u5e74\u6ca1\u6709\u5728\u5c97\u671f\u95f4\u4f53\u68c0\u6570\u636e");
                        }
                    } else {
                        referenceDataList.add("\u8fd13\u5e74\u6ca1\u6709\u4e0a\u5c97\u524d\u4f53\u68c0\u6570\u636e");
                    }
                } else {
                    referenceDataList.add("\u8fd13\u5e74\u6ca1\u6709\u4f53\u68c0\u6570\u636e");
                }
            }
            Double termScore = 15.0;
            if (checkResult == 3 || checkResult == 4) {
                termScore = 0.0;
            }
            microSelfJudgeTermResultsVo.setCid(cid);
            microSelfJudgeTermResultsVo.setTermNo(Long.valueOf(5L));
            microSelfJudgeTermResultsVo.setTermName("\u804c\u4e1a\u5065\u5eb7\u68c0\u67e5");
            microSelfJudgeTermResultsVo.setCheckResult(checkResult);
            microSelfJudgeTermResultsVo.setTermScore(termScore);
            microSelfJudgeTermResultsVo.setCheckResultChangeable(Arrays.asList(2));
            microSelfJudgeTermResultsVo.setReferenceDataList(referenceDataList);
            microSelfJudgeTermResultsVos.add(microSelfJudgeTermResultsVo);
        }
        return ResponseData.success(microSelfJudgeTermResultsVos);
    }

    private ResponseData phcCheckProcess(MicroKeyFactoryParam param) {
        ArrayList<MicroSelfJudgeTermResultsVo> microSelfJudgeTermResultsVos = new ArrayList<MicroSelfJudgeTermResultsVo>();
        List cidList = param.getCidList();
        if (CollectionUtil.isEmpty((Collection)cidList)) {
            return ResponseData.success(microSelfJudgeTermResultsVos);
        }
        List resultList = param.getMicroSelfJudgeTermResultsVos();
        if (CollectionUtil.isEmpty((Collection)resultList)) {
            ResponseData responseData = this.phcCheck(param);
            resultList = (List)responseData.getResult();
        }
        Map<Long, MicroSelfJudgeTermResultsVo> resultsVoMap = resultList.stream().collect(Collectors.toMap(MicroSelfJudgeTermResultsVo::getCid, r -> r, (r1, r2) -> r1));
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime threeYearsAgo = now.minusYears(3L);
        ReformSearchVo searchVo = new ReformSearchVo();
        searchVo.setCidList(cidList);
        searchVo.setGenerationSources(Arrays.asList(ReformGenerationSourceEnum.JJZ.getValue(), ReformGenerationSourceEnum.YSZYB.getValue()));
        searchVo.setBeginFindDate(threeYearsAgo.format(formatter));
        searchVo.setEndFindDate(now.format(formatter));
        searchVo.setIsCompleted(Boolean.valueOf(false));
        List reformItemBasicList = this.reformItemBasicCommandService.getReformItemBasicList(searchVo);
        Map<Long, List<ReformItemBasic>> reformItemBasicMap = reformItemBasicList.stream().collect(Collectors.groupingBy(ReformItemBasic::getCid));
        ReformSearchVo reformSearchVo = new ReformSearchVo();
        reformSearchVo.setCidList(cidList);
        reformSearchVo.setBeginFindDate(threeYearsAgo.format(formatter));
        reformSearchVo.setEndFindDate(now.format(formatter));
        List phcPhysicalCheckV3221s = this.phcPhysicalCheckV3221Service.getAllPhcCheckInfoByCids(reformSearchVo);
        Map<Long, List<PhcPhysicalCheckV3221>> phcMap = phcPhysicalCheckV3221s.stream().collect(Collectors.groupingBy(PhcPhysicalCheckV3221::getCid));
        for (Long cid : cidList) {
            Integer checkResult = 1;
            ArrayList<String> referenceDataList = new ArrayList<String>();
            MicroSelfJudgeTermResultsVo resultsVo = resultsVoMap.get(cid);
            List<ReformItemBasic> reformItemBasics = reformItemBasicMap.get(cid);
            if (ObjectUtil.isNotNull((Object)resultsVo) && resultsVo.getCheckResult() == 3 || CollectionUtil.isNotEmpty(reformItemBasics)) {
                checkResult = 3;
                if (ObjectUtil.isNotNull((Object)resultsVo) && resultsVo.getCheckResult() == 3) {
                    referenceDataList.add("\u7b2c5\u9879\u804c\u4e1a\u5065\u5eb7\u68c0\u67e5\u4e3a\u4e0d\u7b26\u5408");
                } else {
                    referenceDataList.add("\u8fd13\u5e74\u5728\u5c97\u4f53\u68c0\u7ed3\u679c\u5f02\u5e38\u7684\u98ce\u9669\u5b58\u5728\u672a\u6574\u6539\u7684\u60c5\u51b5");
                }
            } else {
                List<PhcPhysicalCheckV3221> phcPhysicalCheckV3221List = phcMap.get(cid);
                if (CollectionUtil.isNotEmpty(phcPhysicalCheckV3221List)) {
                    Double sum = phcPhysicalCheckV3221List.stream().mapToDouble(p -> p.getNumberOfYsjjz() + p.getNumberOfYszyb()).sum();
                    if (sum == 0.0) {
                        checkResult = 4;
                        referenceDataList.add("\u5468\u671f\u5185\u7684\u6240\u6709\u4f53\u68c0\u5747\u65e0\u804c\u4e1a\u7981\u5fcc\u8bc1\u548c\u7591\u4f3c\u804c\u4e1a\u75c5\u7ed3\u8bba");
                    }
                } else {
                    checkResult = 4;
                    referenceDataList.add("\u5468\u671f\u5185\u7684\u6240\u6709\u4f53\u68c0\u5747\u65e0\u804c\u4e1a\u7981\u5fcc\u8bc1\u548c\u7591\u4f3c\u804c\u4e1a\u75c5\u7ed3\u8bba");
                }
            }
            if (checkResult == 1) {
                referenceDataList.add("\u8fd13\u5e74\u5728\u5c97\u4f53\u68c0\u7ed3\u679c\u5f02\u5e38\u7684\u98ce\u9669\u5168\u90e8\u201c\u5df2\u6574\u6539\u201d");
            }
            Double termScore = 15.0;
            if (checkResult == 3 || checkResult == 4) {
                termScore = 0.0;
            }
            MicroSelfJudgeTermResultsVo microSelfJudgeTermResultsVo = new MicroSelfJudgeTermResultsVo();
            microSelfJudgeTermResultsVo.setCid(cid);
            microSelfJudgeTermResultsVo.setTermNo(Long.valueOf(6L));
            microSelfJudgeTermResultsVo.setTermName("\u4f53\u68c0\u7ed3\u679c\u5904\u7f6e\u548c\u544a\u77e5");
            microSelfJudgeTermResultsVo.setCheckResult(checkResult);
            microSelfJudgeTermResultsVo.setTermScore(termScore);
            microSelfJudgeTermResultsVo.setCheckResultChangeable(Arrays.asList(1, 2, 3, 4));
            microSelfJudgeTermResultsVo.setReferenceDataList(referenceDataList);
            microSelfJudgeTermResultsVos.add(microSelfJudgeTermResultsVo);
        }
        return ResponseData.success(microSelfJudgeTermResultsVos);
    }

    private ResponseData protectiveEquipment(MicroKeyFactoryParam param) {
        ArrayList<MicroSelfJudgeTermResultsVo> microSelfJudgeTermResultsVos = new ArrayList<MicroSelfJudgeTermResultsVo>();
        List cidList = param.getCidList();
        if (CollectionUtil.isEmpty((Collection)cidList)) {
            return ResponseData.success(microSelfJudgeTermResultsVos);
        }
        ReformSearchVo searchVo = new ReformSearchVo();
        Integer currentYear = Year.now().getValue();
        searchVo.setCidList(cidList);
        searchVo.setGenerationSource(ReformGenerationSourceEnum.PROTECTION.getValue());
        searchVo.setIsCompleted(Boolean.valueOf(false));
        searchVo.setYearList(Arrays.asList(currentYear - 1, currentYear - 2, currentYear - 3));
        List reformItemBasicList = this.reformItemBasicCommandService.getReformItemBasicList(searchVo);
        Map<Long, List<ReformItemBasic>> reformItemBasicMap = reformItemBasicList.stream().collect(Collectors.groupingBy(ReformItemBasic::getCid));
        for (Long cid : cidList) {
            ArrayList<String> referenceDataList = new ArrayList<String>();
            Integer checkResult = 1;
            List<ReformItemBasic> reformItemBasics = reformItemBasicMap.get(cid);
            if (CollectionUtil.isNotEmpty(reformItemBasics)) {
                checkResult = 3;
            }
            if (checkResult == 1) {
                referenceDataList.add("\u6700\u8fd1\u4e00\u4e2a\u5468\u671f\u4e0d\u5b58\u5728\u201c\u672a\u6309\u8981\u6c42\u914d\u7f6e\u4e2a\u4eba\u9632\u62a4\u7528\u54c1\u98ce\u9669\u201d\u6216\u98ce\u9669\u5168\u90e8\u201c\u5df2\u6574\u6539\u201d");
            } else if (checkResult == 3) {
                referenceDataList.add("\u6700\u8fd1\u4e00\u4e2a\u5468\u671f\u4efb\u4e00\u5e74\u4efd\u7684\u5b58\u5728\u672a\u6574\u6539\u7684\u201c\u672a\u6309\u8981\u6c42\u914d\u7f6e\u4e2a\u4eba\u9632\u62a4\u7528\u54c1\u98ce\u9669\u201d");
            }
            MicroSelfJudgeTermResultsVo microSelfJudgeTermResultsVo = new MicroSelfJudgeTermResultsVo();
            microSelfJudgeTermResultsVo.setCid(cid);
            microSelfJudgeTermResultsVo.setTermNo(Long.valueOf(7L));
            microSelfJudgeTermResultsVo.setTermName("\u9632\u62a4\u7528\u54c1\u914d\u5907");
            microSelfJudgeTermResultsVo.setCheckResult(checkResult);
            microSelfJudgeTermResultsVo.setTermScore(Double.valueOf(checkResult == 1 ? 10.0 : 0.0));
            microSelfJudgeTermResultsVo.setCheckResultChangeable(Arrays.asList(1, 2, 3, 4));
            microSelfJudgeTermResultsVo.setReferenceDataList(referenceDataList);
            microSelfJudgeTermResultsVos.add(microSelfJudgeTermResultsVo);
        }
        return ResponseData.success(microSelfJudgeTermResultsVos);
    }
}

