/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.selfjudge;

import cn.hutool.core.collection.CollectionUtil;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.PageUtil;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.model.system.IndustryModel;
import cn.smarthse.modules.datacentre.model.system.SysParamModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.datacentre.provider.system.ISysParamProvideService;
import cn.smarthse.modules.datacentre.provider.system.IndustryProvideService;
import cn.smarthse.modules.health.dao.base.selfjudge.MicroCompanySelfInspectionRiskAssessmentReportInfoMapper;
import cn.smarthse.modules.health.entity.base.company.CompanyReportInfo;
import cn.smarthse.modules.health.entity.base.selfjudge.MicroCompanyHsePreventionControlSelfJudge;
import cn.smarthse.modules.health.entity.base.selfjudge.MicroCompanySelfInspectionRiskAssessmentReportInfo;
import cn.smarthse.modules.health.entity.base.selfjudge.SelfInspectionTerm;
import cn.smarthse.modules.health.entity.base.selfjudge.vo.MicroCompanySelfInspectionRiskAssessmentReportForm;
import cn.smarthse.modules.health.entity.base.selfjudge.vo.MicroCompanySelfInspectionRiskAssessmentReportV314Vo;
import cn.smarthse.modules.health.enums.company.CompanySizeEnum;
import cn.smarthse.modules.health.enums.selfjudge.HazardsExposureRiskLevelEnum;
import cn.smarthse.modules.health.enums.selfjudge.HazardsRiskClassifyEnum;
import cn.smarthse.modules.health.enums.selfjudge.MicroJudgeResultLevelEnum;
import cn.smarthse.modules.health.service.base.company.CompanyReportInfoService;
import cn.smarthse.modules.health.service.base.selfjudge.IMicroCompanyHsePreventionControlSelfJudgeService;
import cn.smarthse.modules.health.service.base.selfjudge.IMicroCompanySelfInspectionRiskAssessmentReportInfoService;
import cn.smarthse.modules.health.service.base.selfjudge.IMicroOccupationalSelfJudgeTermV308Service;
import cn.smarthse.modules.health.service.base.selfjudge.ISelfInspectionTermService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.supervise.entity.declare.CompanyDeclareInfo;
import cn.smarthse.modules.health.supervise.enums.WorkOperateLogEnum;
import cn.smarthse.modules.health.supervise.service.declare.IDeclareBaseService;
import cn.smarthse.modules.health.supervise.service.operate.IWorkOperateLogService;
import cn.smarthse.modules.health.thirdOrganization.entity.org.ThirdOrganization;
import cn.smarthse.modules.health.thirdOrganization.service.org.IThirdOrganizationService;
import cn.smarthse.services.hfi.api.entity.riskev.MicroCompanyRiskExposeEvaluate;
import cn.smarthse.services.hfi.api.model.riskev.MicroCompanyEvQueryParam;
import cn.smarthse.services.hfi.api.pojo.vo.riskev.MicroCompanyRiskDecisionVo;
import cn.smarthse.services.hfi.api.pojo.vo.riskev.MicroCompanyRiskExposeEvaluateVo;
import cn.smarthse.services.hfi.api.service.riskev.IMicroCompanyRiskExposeEvaluateDataService;
import cn.smarthse.services.hfi.api.service.riskev.IMicroCompanyRiskExposeEvaluateService;
import cn.smarthse.util.common.StringUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class MicroCompanySelfInspectionRiskAssessmentReportInfoServiceImpl
extends BaseServiceImpl<MicroCompanySelfInspectionRiskAssessmentReportInfoMapper, MicroCompanySelfInspectionRiskAssessmentReportInfo>
implements IMicroCompanySelfInspectionRiskAssessmentReportInfoService {
    @Autowired(required=false)
    private IStaffInfoService staffInfoService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideByHSEService companyProvideByHSEService;
    @DubboReference(version="1.0.0")
    private ISysParamProvideService sysParamProvideService;
    @Autowired
    private CompanyReportInfoService companyReportInfoService;
    @Autowired
    private IThirdOrganizationService thirdOrganizationService;
    @DubboReference
    private IDeclareBaseService declareBaseService;
    @DubboReference(version="1.0.0")
    private IndustryProvideService industryProvideService;
    @DubboReference
    private IWorkOperateLogService workOperateLogService;
    @Autowired
    private IMicroCompanyHsePreventionControlSelfJudgeService companyHsePreventionControlSelfJudgeService;
    @Autowired(required=false)
    private IMicroOccupationalSelfJudgeTermV308Service occupationalSelfJudgeTermV308Service;
    @Autowired
    private ISelfInspectionTermService selfInspectionTermService;
    @DubboReference
    private IMicroCompanyRiskExposeEvaluateService riskExposeEvaluateService;
    @DubboReference
    private IMicroCompanyRiskExposeEvaluateDataService riskExposeEvaluateDataService;

    @Transactional(readOnly=false)
    public void deleteReport(Long id, Long loginStaffId) {
        if (id == null) {
            return;
        }
        MicroCompanySelfInspectionRiskAssessmentReportInfo info = new MicroCompanySelfInspectionRiskAssessmentReportInfo();
        info.setId(id);
        this.delete(info, loginStaffId);
        MicroCompanySelfInspectionRiskAssessmentReportInfo info1 = (MicroCompanySelfInspectionRiskAssessmentReportInfo)this.getById(id);
        if (info1.getSelfReportId() != null && Byte.valueOf("2").equals(info1.getReportFromYear()) && StringUtils.isNotEmpty((String)info1.getChangeReason()) && info1.getChangeReason().contains("2")) {
            MicroCompanyHsePreventionControlSelfJudge selfJudge = (MicroCompanyHsePreventionControlSelfJudge)this.companyHsePreventionControlSelfJudgeService.getById(info1.getSelfReportId());
            if (Byte.valueOf("1").equals(selfJudge.getStatus()) || Byte.valueOf("2").equals(selfJudge.getStatus())) {
                this.companyHsePreventionControlSelfJudgeService.deleteSelfJudge(info1.getSelfReportId(), loginStaffId);
            }
        }
    }

    public List<MicroCompanySelfInspectionRiskAssessmentReportInfo> listDataV314EveryCidLatestForSuperviseByDateRange(Date beginDate, Date endDate, List<Long> cids) {
        List<MicroCompanySelfInspectionRiskAssessmentReportInfo> reportInfoList = null;
        reportInfoList = CollectionUtils.isNotEmpty(cids) ? ((MicroCompanySelfInspectionRiskAssessmentReportInfoMapper)this.dao).listDataV314EveryCidLatestForSuperviseByDateRange(beginDate, endDate, cids, 100000) : ((MicroCompanySelfInspectionRiskAssessmentReportInfoMapper)this.dao).listDataV314EveryCidLatestForSuperviseByDateRange(beginDate, endDate, cids, ((MicroCompanySelfInspectionRiskAssessmentReportInfoMapper)this.dao).selectCount(new MicroCompanySelfInspectionRiskAssessmentReportInfo()));
        return reportInfoList;
    }

    public PageInfo<MicroCompanySelfInspectionRiskAssessmentReportV314Vo> listPageDataV314(JqGridParam jqGridParam) {
        PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows());
        List<MicroCompanySelfInspectionRiskAssessmentReportV314Vo> list = ((MicroCompanySelfInspectionRiskAssessmentReportInfoMapper)this.dao).listDataV314(jqGridParam.getCid());
        list.forEach(s -> {
            MicroCompanyHsePreventionControlSelfJudge selfJudge;
            MicroCompanyRiskExposeEvaluate riskExposeEvaluate;
            if (s.getDataSource() != null && s.getDataSource() == 1 && s.getOperatorStaffId() != null) {
                s.setOperatorStaffName(this.staffInfoService.getStaffNameByStaffId(s.getOperatorStaffId()));
            }
            if (s.getExposureReportId() != null && (riskExposeEvaluate = (MicroCompanyRiskExposeEvaluate)this.riskExposeEvaluateService.getById((Serializable)s.getExposureReportId())) != null && riskExposeEvaluate.getRiskLevel() != null) {
                s.setRiskLevel(riskExposeEvaluate.getRiskLevel());
            }
            if (s.getSelfReportId() != null && (selfJudge = (MicroCompanyHsePreventionControlSelfJudge)this.companyHsePreventionControlSelfJudgeService.getById(s.getSelfReportId())) != null && selfJudge.getJudgeLevel() != null) {
                s.setJudgeLevel(Integer.valueOf(selfJudge.getJudgeLevel().intValue()));
            }
            if (s.getJudgeLevel() != null) {
                s.setJudgeLevelName(MicroJudgeResultLevelEnum.getThisEnumByCode((Integer)s.getJudgeLevel()).getName());
            }
            if (s.getRiskLevel() != null) {
                HazardsExposureRiskLevelEnum riskLevelEnum = HazardsExposureRiskLevelEnum.getThisEnumByCode((Integer)s.getRiskLevel());
                s.setRiskLevelName(riskLevelEnum == null ? null : riskLevelEnum.getName());
            }
            if (s.getJudgeLevel() != null && s.getRiskLevel() != null) {
                HazardsRiskClassifyEnum riskClassifyEnum = HazardsRiskClassifyEnum.getThisEnumByJudgeLevelAndRiskLevel((MicroJudgeResultLevelEnum)MicroJudgeResultLevelEnum.getThisEnumByCode((Integer)s.getJudgeLevel()), (HazardsExposureRiskLevelEnum)HazardsExposureRiskLevelEnum.getThisEnumByCode((Integer)s.getRiskLevel()));
                s.setRiskClassify(riskClassifyEnum == null ? null : riskClassifyEnum.getCode());
                s.setRiskClassifyName(riskClassifyEnum == null ? null : riskClassifyEnum.getName());
            }
        });
        return new PageInfo(list);
    }

    @Transactional(readOnly=false)
    public synchronized MicroCompanySelfInspectionRiskAssessmentReportInfo addThisYearSelfInspectionRiskAssessmentReport(List<Long> loginStaffCompanyIdList, Long loginStaffId) {
        int year = DateUtils.getThisYear();
        if (CollectionUtils.isEmpty(loginStaffCompanyIdList)) {
            return null;
        }
        List<MicroCompanySelfInspectionRiskAssessmentReportInfo> reportInfoList = this.getThisYearSelfInspectionRiskAssessmentReportByCid(year, loginStaffCompanyIdList);
        Map<Long, MicroCompanySelfInspectionRiskAssessmentReportInfo> reportInfoMap = reportInfoList.stream().collect(Collectors.toMap(MicroCompanySelfInspectionRiskAssessmentReportInfo::getCid, r -> r, (r1, r2) -> r1));
        ArrayList<MicroCompanySelfInspectionRiskAssessmentReportInfo> reportInfos = new ArrayList<MicroCompanySelfInspectionRiskAssessmentReportInfo>();
        Date date = new Date();
        List companyReportInfoByCidList = this.companyReportInfoService.getCompanyReportInfoByCidList(loginStaffCompanyIdList);
        HashMap<Long, CompanyReportInfo> companyReportInfoMap = new HashMap<Long, CompanyReportInfo>();
        if (CollectionUtils.isNotEmpty((Collection)companyReportInfoByCidList)) {
            companyReportInfoMap.putAll(companyReportInfoByCidList.stream().collect(Collectors.toMap(CompanyReportInfo::getCid, r -> r, (r1, r2) -> r1)));
        }
        List companyByIds = this.companyProvideByHSEService.getCompanyByIds(loginStaffCompanyIdList);
        HashMap<Long, Company> companyMap = new HashMap<Long, Company>();
        if (CollectionUtils.isNotEmpty((Collection)companyByIds)) {
            companyMap.putAll(companyByIds.stream().collect(Collectors.toMap(Company::getId, c -> c, (c1, c2) -> c1)));
        }
        List selfJudgeList = this.companyHsePreventionControlSelfJudgeService.getLatestEntityNoStatusByCids(loginStaffCompanyIdList);
        HashMap<Long, MicroCompanyHsePreventionControlSelfJudge> selfJudgeMap = new HashMap<Long, MicroCompanyHsePreventionControlSelfJudge>();
        if (CollectionUtils.isNotEmpty((Collection)selfJudgeList)) {
            selfJudgeMap.putAll(selfJudgeList.stream().collect(Collectors.toMap(MicroCompanyHsePreventionControlSelfJudge::getCid, c -> c, (c1, c2) -> c1)));
        }
        try {
            for (Long cid : loginStaffCompanyIdList) {
                MicroCompanyHsePreventionControlSelfJudge selfJudge;
                MicroCompanyRiskExposeEvaluate riskExposeEvaluate;
                MicroCompanySelfInspectionRiskAssessmentReportInfo reportInfo = reportInfoMap.get(cid);
                if (reportInfo != null) continue;
                reportInfo = new MicroCompanySelfInspectionRiskAssessmentReportInfo();
                reportInfo.setId(Long.valueOf(this.idworker.nextId()));
                reportInfo.setCidYear("" + cid + year);
                reportInfo.setCid(cid);
                reportInfo.setYear(Long.valueOf(year));
                reportInfo.setReportFromYear(Byte.valueOf((byte)1));
                reportInfo.setSelfTime(new Date());
                reportInfo.setStatus(Byte.valueOf((byte)1));
                reportInfo.setDataSource(Byte.valueOf((byte)1));
                reportInfo.setIsValid(Boolean.valueOf(true));
                reportInfo.setCreateDate(date);
                reportInfo.setCreateBy(loginStaffId);
                reportInfo.setUpdateDate(date);
                reportInfo.setUpdateBy(loginStaffId);
                reportInfo.setSelfTime(date);
                Company cim = (Company)companyMap.get(cid);
                reportInfo.setCompanyName(cim.getName());
                reportInfo.setRegisterAddDetail(cim.getRegisterAddress());
                reportInfo.setLocationAddDetail(cim.getWorkAddress());
                reportInfo.setCompanyScale(StringUtils.isNumber((String)cim.getScale()) ? Long.valueOf(cim.getScale()) : null);
                reportInfo.setIndustryClassification(cim.getIndustryCategory());
                reportInfo.setEconomicType(cim.getRegisterType());
                reportInfo.setContactNumber(cim.getLegalTel());
                reportInfo.setUniformSocialCreditCode(cim.getUnifiedSocialCc());
                reportInfo.setSuperiorUnit(cim.getFatherDept());
                reportInfo.setLocationAddAreaId(cim.getAreaId());
                CompanyReportInfo companyReportInfo = (CompanyReportInfo)companyReportInfoMap.get(cid);
                if (companyReportInfo != null) {
                    reportInfo.setManageOrg(companyReportInfo.getManageOrg());
                    reportInfo.setManageMajorStaffCount(companyReportInfo.getManageMajorStaffCount());
                    reportInfo.setManagePluralityStaffCount(companyReportInfo.getManagePluralityStaffCount());
                    reportInfo.setStaffCount(companyReportInfo.getStaffCount());
                    reportInfo.setHarmStaffCount(companyReportInfo.getHarmStaffCount());
                    reportInfo.setDiseaseOnWorkStaffCount(companyReportInfo.getDiseaseOnWorkStaffCount());
                    CompanyDeclareInfo companyDeclareInfo = this.declareBaseService.getCompanyDeclareInfo(cid);
                    reportInfo.setDiseaseStaffCount(Long.valueOf(companyDeclareInfo != null && companyDeclareInfo.getOccupationalDiseasesNum() != null ? companyDeclareInfo.getOccupationalDiseasesNum().longValue() : 0L));
                    reportInfo.setCheckGoWorkStaffCount(companyReportInfo.getCheckGoWorkStaffCount());
                    reportInfo.setCheckGoWorkStaffRealCount(companyReportInfo.getCheckGoWorkStaffRealCount());
                    reportInfo.setCheckOnWorkStaffCount(companyReportInfo.getCheckOnWorkStaffCount());
                    reportInfo.setCheckOnWorkStaffRealCount(companyReportInfo.getCheckOnWorkStaffRealCount());
                    reportInfo.setCheckLeaveWorkStaffCount(companyReportInfo.getCheckLeaveWorkStaffCount());
                    reportInfo.setCheckLeaveWorkStaffRealCount(companyReportInfo.getCheckLeaveWorkStaffRealCount());
                }
                if ((riskExposeEvaluate = this.riskExposeEvaluateService.getLatestNeedReportEv(cid)) != null) {
                    reportInfo.setExposureReportId(riskExposeEvaluate.getId());
                }
                if ((selfJudge = (MicroCompanyHsePreventionControlSelfJudge)selfJudgeMap.get(cid)) != null) {
                    reportInfo.setSelfReportId(selfJudge.getId());
                }
                reportInfos.add(reportInfo);
            }
        }
        catch (Exception e) {
            this.logger.info("\u521b\u5efa\u62a5\u544a\u5931\u8d25!" + e.getMessage());
        }
        if (CollectionUtil.isNotEmpty(reportInfos)) {
            ((MicroCompanySelfInspectionRiskAssessmentReportInfoMapper)this.dao).insertList2(reportInfos);
            return (MicroCompanySelfInspectionRiskAssessmentReportInfo)reportInfos.get(0);
        }
        return reportInfoList.get(0);
    }

    public PageInfo<MicroCompanyRiskExposeEvaluateVo> pageRiskExposeEvaluateVo(MicroCompanyEvQueryParam param) {
        Long cid = param.getCid();
        MicroCompanyRiskExposeEvaluate riskExposeEvaluate = null;
        List<MicroCompanySelfInspectionRiskAssessmentReportInfo> lastNewReportList = this.listDataV314EveryCidLatestForSuperviseByDateRange(null, null, Arrays.asList(cid));
        if (CollectionUtils.isNotEmpty(lastNewReportList)) {
            MicroCompanySelfInspectionRiskAssessmentReportInfo reportInfo = lastNewReportList.get(0);
            if (Objects.equals(reportInfo.getStatus(), (byte)1)) {
                if (Byte.valueOf("2").equals(reportInfo.getReportFromYear()) && StringUtils.isNotEmpty((String)reportInfo.getChangeReason()) && reportInfo.getChangeReason().contains("1") || Byte.valueOf("1").equals(reportInfo.getReportFromYear())) {
                    riskExposeEvaluate = this.riskExposeEvaluateService.getLatestNeedReportEv(reportInfo.getCid());
                } else if (Byte.valueOf("2").equals(reportInfo.getReportFromYear())) {
                    if (reportInfo.getExposureReportId() == null && reportInfo.getChangeFromId() != null && (beforeReport = (MicroCompanySelfInspectionRiskAssessmentReportInfo)this.getById(reportInfo.getChangeFromId())) != null) {
                        reportInfo.setExposureReportId(beforeReport.getExposureReportId());
                        reportInfo.setExposureReportOldId(beforeReport.getExposureReportId());
                    }
                    if (reportInfo.getExposureReportId() != null) {
                        riskExposeEvaluate = (MicroCompanyRiskExposeEvaluate)this.riskExposeEvaluateService.getById((Serializable)reportInfo.getExposureReportId());
                    }
                }
            } else if (Objects.equals(reportInfo.getStatus(), (byte)2) || Objects.equals(reportInfo.getStatus(), (byte)3)) {
                if (reportInfo.getExposureReportId() == null && reportInfo.getChangeFromId() != null && (beforeReport = (MicroCompanySelfInspectionRiskAssessmentReportInfo)this.getById(reportInfo.getChangeFromId())) != null) {
                    reportInfo.setExposureReportId(beforeReport.getExposureReportId());
                    reportInfo.setExposureReportOldId(beforeReport.getExposureReportId());
                }
                if (reportInfo.getExposureReportId() != null) {
                    riskExposeEvaluate = (MicroCompanyRiskExposeEvaluate)this.riskExposeEvaluateService.getById((Serializable)reportInfo.getExposureReportId());
                }
            } else {
                riskExposeEvaluate = this.riskExposeEvaluateService.getLatestEv(cid, null, Integer.valueOf(2));
            }
        } else {
            riskExposeEvaluate = this.riskExposeEvaluateService.getLatestEv(cid, null, Integer.valueOf(2));
        }
        MicroCompanyEvQueryParam evQueryParam = new MicroCompanyEvQueryParam();
        evQueryParam.setCid(cid);
        evQueryParam.setReportStatusList(Arrays.asList(3, 4));
        evQueryParam.setPage(Integer.valueOf(1));
        evQueryParam.setRows(Integer.valueOf(100));
        List mergerRiskTableIdList = this.riskExposeEvaluateService.getRedundantSourceTablesIdsIsNotNullByCid(cid);
        if (CollectionUtils.isNotEmpty((Collection)mergerRiskTableIdList)) {
            evQueryParam.setSourceIdList(mergerRiskTableIdList);
        }
        PageInfo riskExposeEvaluateVoPageInfo = this.riskExposeEvaluateService.queryPage(evQueryParam);
        if (riskExposeEvaluate != null && !Objects.equals(riskExposeEvaluate.getReportStatus(), 3) && !Objects.equals(riskExposeEvaluate.getReportStatus(), 4)) {
            MicroCompanyRiskExposeEvaluateVo vo = new MicroCompanyRiskExposeEvaluateVo();
            BeanUtils.copyProperties((Object)riskExposeEvaluate, (Object)vo);
            Example example = new Example(MicroCompanySelfInspectionRiskAssessmentReportInfo.class);
            example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true).andIn("status", Arrays.asList(1, 2, 3, 4));
            example.setOrderByClause("update_date desc LIMIT 1");
            MicroCompanySelfInspectionRiskAssessmentReportInfo reportInfo = (MicroCompanySelfInspectionRiskAssessmentReportInfo)((MicroCompanySelfInspectionRiskAssessmentReportInfoMapper)this.dao).selectOneByExample(example);
            if (reportInfo != null && Objects.equals(reportInfo.getStatus(), (byte)4)) {
                vo.setIsIgnore(Boolean.valueOf(true));
            }
            List list = riskExposeEvaluateVoPageInfo.getList();
            list.add(0, vo);
            return PageUtil.getPageInfo((List)list, (int)param.getPage(), (int)param.getRows());
        }
        return PageUtil.getPageInfo((List)riskExposeEvaluateVoPageInfo.getList(), (int)param.getPage(), (int)param.getRows());
    }

    public MicroCompanySelfInspectionRiskAssessmentReportV314Vo getV314VoById(Long id) {
        MicroCompanySelfInspectionRiskAssessmentReportV314Vo v314Vo = new MicroCompanySelfInspectionRiskAssessmentReportV314Vo();
        MicroCompanySelfInspectionRiskAssessmentReportInfo reportInfo = (MicroCompanySelfInspectionRiskAssessmentReportInfo)this.getById(id);
        v314Vo.setReportInfo(reportInfo);
        if (v314Vo.getReportInfo() != null) {
            SysParamModel economicType;
            IndustryModel industryClassification;
            if (v314Vo.getReportInfo().getIndustryClassification() != null && (industryClassification = this.industryProvideService.getIndustryById(v314Vo.getReportInfo().getIndustryClassification())) != null) {
                v314Vo.setIndustryClassificationName(industryClassification.getCode() + "-" + industryClassification.getName());
            }
            if (v314Vo.getReportInfo().getEconomicType() != null && (economicType = this.sysParamProvideService.getById(v314Vo.getReportInfo().getEconomicType())) != null) {
                v314Vo.setEconomicTypeName(economicType.getParamCode() + "-" + economicType.getParamValue());
            }
            if (v314Vo.getReportInfo().getCompanyScale() != null) {
                v314Vo.setScaleName(CompanySizeEnum.getName((Byte)Byte.valueOf("" + v314Vo.getReportInfo().getCompanyScale())));
            }
        }
        if (v314Vo.getReportInfo() != null && v314Vo.getReportInfo().getStatus() != null && v314Vo.getReportInfo().getStatus() == 1) {
            MicroCompanyHsePreventionControlSelfJudge selfJudge;
            if (!Byte.valueOf("2").equals(v314Vo.getReportInfo().getReportFromYear()) && (StringUtils.isEmpty((CharSequence)v314Vo.getReportInfo().getChangeReason()) || !v314Vo.getReportInfo().getChangeReason().contains("2")) || !Byte.valueOf("2").equals(v314Vo.getReportInfo().getReportFromYear()) && v314Vo.getReportInfo().getSelfReportId() == null) {
                selfJudge = this.companyHsePreventionControlSelfJudgeService.getLatestEntityNoStatusByCid(v314Vo.getReportInfo().getCid());
                v314Vo.setSelfJudge(selfJudge);
                if (v314Vo.getSelfJudge() != null) {
                    v314Vo.getReportInfo().setSelfReportId(v314Vo.getSelfJudge().getId());
                    if (v314Vo.getReportInfo().getSelfReportOldId() == null) {
                        v314Vo.getReportInfo().setSelfReportOldId(v314Vo.getSelfJudge().getId());
                    }
                }
            } else if (v314Vo.getReportInfo().getSelfReportId() != null && (selfJudge = (MicroCompanyHsePreventionControlSelfJudge)this.companyHsePreventionControlSelfJudgeService.getById(v314Vo.getReportInfo().getSelfReportId())) != null && selfJudge.getIsValid().booleanValue()) {
                v314Vo.setSelfJudge(selfJudge);
            }
            if (Byte.valueOf("2").equals(v314Vo.getReportInfo().getReportFromYear()) && StringUtils.isNotEmpty((String)v314Vo.getReportInfo().getChangeReason()) && v314Vo.getReportInfo().getChangeReason().contains("1") || Byte.valueOf("1").equals(v314Vo.getReportInfo().getReportFromYear())) {
                MicroCompanyRiskExposeEvaluate riskExposeEvaluate = this.riskExposeEvaluateService.getLatestNeedReportEv(v314Vo.getReportInfo().getCid());
                v314Vo.setRiskExposeEvaluate(riskExposeEvaluate);
                if (v314Vo.getRiskExposeEvaluate() != null) {
                    v314Vo.getReportInfo().setExposureReportId(v314Vo.getRiskExposeEvaluate().getId());
                    if (v314Vo.getReportInfo().getExposureReportOldId() == null) {
                        v314Vo.getReportInfo().setExposureReportOldId(v314Vo.getRiskExposeEvaluate().getId());
                    }
                }
            } else if (Byte.valueOf("2").equals(v314Vo.getReportInfo().getReportFromYear())) {
                MicroCompanySelfInspectionRiskAssessmentReportInfo beforeReport;
                if (v314Vo.getReportInfo().getExposureReportId() == null && v314Vo.getReportInfo().getChangeFromId() != null && (beforeReport = (MicroCompanySelfInspectionRiskAssessmentReportInfo)this.getById(v314Vo.getReportInfo().getChangeFromId())) != null) {
                    v314Vo.getReportInfo().setExposureReportId(beforeReport.getExposureReportId());
                    v314Vo.getReportInfo().setExposureReportOldId(beforeReport.getExposureReportId());
                }
                if (v314Vo.getReportInfo().getExposureReportId() != null) {
                    MicroCompanyRiskExposeEvaluate beforeChange = (MicroCompanyRiskExposeEvaluate)this.riskExposeEvaluateService.getById((Serializable)v314Vo.getReportInfo().getExposureReportId());
                    v314Vo.setRiskExposeEvaluate(beforeChange);
                }
            }
        }
        if (v314Vo.getReportInfo() != null && v314Vo.getReportInfo().getStatus() != null && v314Vo.getReportInfo().getStatus() != 1) {
            if (v314Vo.getReportInfo().getSelfReportId() != null) {
                v314Vo.setSelfJudge((MicroCompanyHsePreventionControlSelfJudge)this.companyHsePreventionControlSelfJudgeService.getById(v314Vo.getReportInfo().getSelfReportId()));
            }
            if (v314Vo.getReportInfo().getExposureReportId() != null) {
                v314Vo.setRiskExposeEvaluate((MicroCompanyRiskExposeEvaluate)this.riskExposeEvaluateService.getById((Serializable)v314Vo.getReportInfo().getExposureReportId()));
            }
        }
        if (v314Vo.getSelfJudge() != null) {
            v314Vo.getSelfJudge().setTerms(this.occupationalSelfJudgeTermV308Service.getListBySelfId(v314Vo.getSelfJudge().getId()));
            if (v314Vo.getSelfJudge().getTerms() != null) {
                List terms = this.selfInspectionTermService.getListByFlag(Integer.valueOf(3));
                v314Vo.getSelfJudge().getTerms().stream().forEach(s -> {
                    SelfInspectionTerm t = terms.stream().filter(s1 -> Long.valueOf(s1.getTermNo().intValue()).equals(s.getTermNo())).findFirst().orElse(null);
                    if (t != null) {
                        s.setTermName(t.getTermName());
                    }
                });
                v314Vo.setRectifyTerms(v314Vo.getSelfJudge().getTerms().stream().filter(s -> s.getCheckResult() != null && (s.getCheckResult() == 2 || s.getCheckResult() == 3)).collect(Collectors.toList()));
                v314Vo.setAbleMissingTerms(v314Vo.getSelfJudge().getTerms().stream().filter(s -> s.getCheckResult() != null && s.getCheckResult() == 4).collect(Collectors.toList()));
            }
            if (v314Vo.getSelfJudge().getJudgeLevel() != null) {
                v314Vo.setJudgeLevel(Integer.valueOf(v314Vo.getSelfJudge().getJudgeLevel().intValue()));
                v314Vo.setJudgeLevelName(MicroJudgeResultLevelEnum.getThisEnumByCode((Integer)v314Vo.getSelfJudge().getJudgeLevel().intValue()).getName());
            }
        }
        if (v314Vo.getRiskExposeEvaluate() != null) {
            ThirdOrganization thirdOrganization;
            MicroCompanyRiskDecisionVo riskDecisionVo = this.riskExposeEvaluateService.queryTouchNumAndLevel(v314Vo.getRiskExposeEvaluate().getId());
            v314Vo.setRiskDecisionVo(riskDecisionVo);
            v314Vo.setEvDataStatModels(this.riskExposeEvaluateDataService.queryEvDataStat(v314Vo.getRiskExposeEvaluate().getId()));
            if (riskDecisionVo != null && riskDecisionVo.getRiskLevel() != null) {
                Integer level = 1;
                String riskLevel = riskDecisionVo.getRiskLevel();
                if ("\u2160\u7ea7".equals(riskLevel)) {
                    level = 1;
                } else if ("\u2161\u7ea7".equals(riskLevel)) {
                    level = 2;
                } else if ("\u2162\u7ea7".equals(riskLevel)) {
                    level = 3;
                }
                v314Vo.setRiskLevel(level);
                v314Vo.setRiskLevelName(riskDecisionVo.getRiskLevel());
            }
            if (v314Vo.getRiskExposeEvaluate().getOrgId() != null && (thirdOrganization = (ThirdOrganization)this.thirdOrganizationService.getById(v314Vo.getRiskExposeEvaluate().getOrgId())) != null) {
                v314Vo.setThirdOrgName(thirdOrganization.getName());
                v314Vo.setThirdOrgId(thirdOrganization.getId());
            }
        }
        if (v314Vo.getJudgeLevel() != null && v314Vo.getRiskLevel() != null) {
            HazardsRiskClassifyEnum riskClassifyEnum = HazardsRiskClassifyEnum.getThisEnumByJudgeLevelAndRiskLevel((MicroJudgeResultLevelEnum)MicroJudgeResultLevelEnum.getThisEnumByCode((Integer)v314Vo.getJudgeLevel()), (HazardsExposureRiskLevelEnum)HazardsExposureRiskLevelEnum.getThisEnumByCode((Integer)v314Vo.getRiskLevel()));
            v314Vo.setRiskClassify(riskClassifyEnum == null ? null : riskClassifyEnum.getCode());
            v314Vo.setRiskClassifyName(riskClassifyEnum == null ? null : riskClassifyEnum.getName());
        }
        return v314Vo;
    }

    private List<MicroCompanySelfInspectionRiskAssessmentReportInfo> getThisYearSelfInspectionRiskAssessmentReportByCid(int year, List<Long> cidList) {
        Example example = new Example(MicroCompanySelfInspectionRiskAssessmentReportInfo.class);
        example.createCriteria().andIn("cid", cidList).andEqualTo("reportFromYear", (Object)1).andEqualTo("isValid", (Object)true);
        List list = ((MicroCompanySelfInspectionRiskAssessmentReportInfoMapper)this.dao).selectByExample(example);
        return list;
    }

    @Transactional(readOnly=false)
    public MicroCompanySelfInspectionRiskAssessmentReportInfo saveSelfReportChangeReason(MicroCompanySelfInspectionRiskAssessmentReportInfo reportInfo, Long cid, Long loginStaffId) {
        MicroCompanySelfInspectionRiskAssessmentReportInfo changeReportInfo = new MicroCompanySelfInspectionRiskAssessmentReportInfo();
        changeReportInfo.setChangeReason(reportInfo.getChangeReason());
        changeReportInfo.setReasonDetail(reportInfo.getReasonDetail());
        changeReportInfo.setPhoneNumber(reportInfo.getPhoneNumber());
        changeReportInfo.setSelfStaffName(reportInfo.getSelfStaffName());
        reportInfo = (MicroCompanySelfInspectionRiskAssessmentReportInfo)this.getById(reportInfo.getId());
        changeReportInfo.setCid(cid);
        changeReportInfo.setYear(Long.valueOf(LocalDate.now().getYear()));
        changeReportInfo.setReportFromYear(Byte.valueOf((byte)2));
        changeReportInfo.setStatus(Byte.valueOf((byte)1));
        changeReportInfo.setDataSource(Byte.valueOf((byte)1));
        changeReportInfo.setSelfTime(new Date());
        changeReportInfo.setIsValid(Boolean.valueOf(true));
        changeReportInfo.setChangeFromId(reportInfo.getId());
        CompanyBaseInfoModel cim = this.companyProvideByHSEService.getCompanyById(cid);
        changeReportInfo.setCompanyName(cim.getName());
        changeReportInfo.setRegisterAddDetail(cim.getRegisterAddress());
        changeReportInfo.setLocationAddDetail(cim.getWorkAddress());
        changeReportInfo.setCompanyScale(StringUtils.isNumber((String)cim.getScale()) ? Long.valueOf(cim.getScale()) : null);
        changeReportInfo.setIndustryClassification(cim.getIndustryCategory());
        changeReportInfo.setEconomicType(cim.getRegisterType());
        changeReportInfo.setContactNumber(cim.getLegalTel());
        changeReportInfo.setLocationAddAreaId(cim.getAreaDetailId());
        CompanyReportInfo companyReportInfo = this.companyReportInfoService.getCompanyReportInfoByCid(cid);
        if (companyReportInfo != null) {
            changeReportInfo.setManageOrg(companyReportInfo.getManageOrg());
            changeReportInfo.setManageMajorStaffCount(companyReportInfo.getManageMajorStaffCount());
            changeReportInfo.setManagePluralityStaffCount(companyReportInfo.getManagePluralityStaffCount());
            changeReportInfo.setStaffCount(companyReportInfo.getStaffCount());
            changeReportInfo.setHarmStaffCount(companyReportInfo.getHarmStaffCount());
            changeReportInfo.setDiseaseOnWorkStaffCount(companyReportInfo.getDiseaseOnWorkStaffCount());
            CompanyDeclareInfo companyDeclareInfo = this.declareBaseService.getCompanyDeclareInfo(cid);
            changeReportInfo.setDiseaseStaffCount(Long.valueOf(companyDeclareInfo != null && companyDeclareInfo.getOccupationalDiseasesNum() != null ? companyDeclareInfo.getOccupationalDiseasesNum().longValue() : 0L));
            changeReportInfo.setCheckGoWorkStaffCount(companyReportInfo.getCheckGoWorkStaffCount());
            changeReportInfo.setCheckGoWorkStaffRealCount(companyReportInfo.getCheckGoWorkStaffRealCount());
            changeReportInfo.setCheckOnWorkStaffCount(companyReportInfo.getCheckOnWorkStaffCount());
            changeReportInfo.setCheckOnWorkStaffRealCount(companyReportInfo.getCheckOnWorkStaffRealCount());
            changeReportInfo.setCheckLeaveWorkStaffCount(companyReportInfo.getCheckLeaveWorkStaffCount());
            changeReportInfo.setCheckLeaveWorkStaffRealCount(companyReportInfo.getCheckLeaveWorkStaffRealCount());
        }
        if (StringUtils.isNotEmpty((String)changeReportInfo.getChangeReason()) && changeReportInfo.getChangeReason().contains("1")) {
            changeReportInfo.setExposureReportOldId(reportInfo.getExposureReportId());
            MicroCompanyRiskExposeEvaluate riskExposeEvaluate = this.riskExposeEvaluateService.getLatestNeedReportEv(cid);
            if (riskExposeEvaluate != null) {
                changeReportInfo.setExposureReportId(riskExposeEvaluate.getId());
            }
        } else {
            changeReportInfo.setExposureReportId(reportInfo.getExposureReportId());
            changeReportInfo.setExposureReportOldId(reportInfo.getExposureReportId());
        }
        if (StringUtils.isNotEmpty((String)changeReportInfo.getChangeReason()) && changeReportInfo.getChangeReason().contains("2")) {
            changeReportInfo.setSelfReportOldId(reportInfo.getSelfReportId());
        } else {
            changeReportInfo.setSelfReportId(reportInfo.getSelfReportId());
            changeReportInfo.setSelfReportOldId(reportInfo.getSelfReportId());
        }
        this.add(changeReportInfo, loginStaffId, cid);
        return changeReportInfo;
    }

    public Long getExposureReportIdByselfJudgeId(Long id) {
        return ((MicroCompanySelfInspectionRiskAssessmentReportInfoMapper)this.dao).getExposureReportIdByselfJudgeId(id);
    }

    @Transactional(readOnly=false)
    public void saveSelfReportSubmit(MicroCompanySelfInspectionRiskAssessmentReportForm form, Long loginStaffId, Long cid) {
        MicroCompanySelfInspectionRiskAssessmentReportInfo info;
        MicroCompanySelfInspectionRiskAssessmentReportInfo history;
        form.getInfo().setIsValid(Boolean.valueOf(true));
        if (form.getInfo().getStatus() != null && form.getInfo().getStatus() == 2) {
            this.workOperateLogService.report(form.getInfo().getId(), WorkOperateLogEnum.selfJudge.getTypeVal(), loginStaffId, form.getOperaterName(), form.getCompanyName());
        }
        this.logger.warn("\u6267\u884c\u8bc4\u4f30\u62a5\u544a\u4fdd\u5b58\u64cd\u4f5c\uff0c cid:{}", (Object)cid);
        this.update(form.getInfo(), loginStaffId);
        if (form.getInfo().getStatus() != null && form.getInfo().getStatus() == 2 && (history = (MicroCompanySelfInspectionRiskAssessmentReportInfo)this.getById((info = (MicroCompanySelfInspectionRiskAssessmentReportInfo)this.getById(form.getInfo().getId())).getSourceId())) != null) {
            Long id = history.getId();
            history.setId(info.getId());
            history.setSourceId(id);
            history.setTableFlag(Byte.valueOf((byte)2));
            history.setIsValid(Boolean.valueOf(false));
            info.setId(id);
            info.setSourceId(null);
            info.setTableFlag(null);
            info.setCidYear(history.getCidYear());
            history.setCidYear(null);
            this.updateByPrimaryKey(history, loginStaffId);
            this.updateByPrimaryKey(info, loginStaffId);
            this.workOperateLogService.report(info.getId(), WorkOperateLogEnum.selfJudge.getTypeVal(), loginStaffId, form.getOperaterName(), form.getCompanyName());
        }
    }

    @Transactional(readOnly=false)
    public int examineAndVerifySelfReportById(MicroCompanySelfInspectionRiskAssessmentReportInfo reportInfo, Long loginUserId) {
        if (reportInfo == null && reportInfo.getId() == null || reportInfo.getStatus() == null || reportInfo.getStatus() == 1 || reportInfo.getStatus() == 2) {
            return 0;
        }
        MicroCompanySelfInspectionRiskAssessmentReportInfo updateReportInfo = new MicroCompanySelfInspectionRiskAssessmentReportInfo();
        updateReportInfo.setId(reportInfo.getId());
        updateReportInfo.setStatus(reportInfo.getStatus());
        updateReportInfo.setBackReason(reportInfo.getBackReason());
        updateReportInfo.setBackReasonDetail(reportInfo.getBackReasonDetail());
        this.update(updateReportInfo, loginUserId);
        if (reportInfo.getStatus() != null && reportInfo.getStatus().intValue() == 3) {
            MicroCompanySelfInspectionRiskAssessmentReportInfo info = (MicroCompanySelfInspectionRiskAssessmentReportInfo)this.getById(reportInfo.getId());
            MicroCompanySelfInspectionRiskAssessmentReportInfo copy = new MicroCompanySelfInspectionRiskAssessmentReportInfo();
            BeanUtils.copyProperties((Object)info, (Object)copy, (String[])new String[]{"id"});
            copy.setId(Long.valueOf(this.idworker.nextId()));
            copy.setSourceId(info.getId());
            copy.setTableFlag(Byte.valueOf((byte)1));
            copy.setChangeFromId(info.getChangeFromId());
            copy.setCidYear(null);
            copy.setCreateBy(loginUserId);
            copy.setCreateDate(new Date());
            copy.setUpdateBy(loginUserId);
            copy.setUpdateDate(new Date());
            info.setSourceId(copy.getId());
            info.setTableFlag(Byte.valueOf((byte)0));
            info.setChangeFromId(null);
            this.updateByPrimaryKey(info, loginUserId);
            this.add(copy);
        }
        return 1;
    }

    @Transactional(readOnly=false)
    public void batchUpdate(List<MicroCompanySelfInspectionRiskAssessmentReportInfo> reportInfos, Long loginStaffId) {
        if (CollectionUtils.isNotEmpty(reportInfos)) {
            this.batchUpdateOrInsert(reportInfos, MicroCompanySelfInspectionRiskAssessmentReportInfoMapper.class, (item, mapper) -> mapper.updateByPrimaryKeySelective(item));
        }
    }

    public List<MicroCompanySelfInspectionRiskAssessmentReportInfo> getRepostInfoByCids(List<Long> changeCids) {
        if (CollectionUtils.isEmpty(changeCids)) {
            return Collections.emptyList();
        }
        return ((MicroCompanySelfInspectionRiskAssessmentReportInfoMapper)this.dao).getRepostInfoByCids(changeCids);
    }

    public List<Long> getDraftRepostCidListInfoByCids(List<Long> changeCids) {
        if (CollectionUtils.isEmpty(changeCids)) {
            return Collections.emptyList();
        }
        return ((MicroCompanySelfInspectionRiskAssessmentReportInfoMapper)this.dao).getDraftRepostCidListInfoByCids(changeCids);
    }

    @Transactional(readOnly=false)
    public void addBatch(List<MicroCompanySelfInspectionRiskAssessmentReportInfo> addReportList) {
        if (CollectionUtils.isEmpty(addReportList)) {
            return;
        }
        ((MicroCompanySelfInspectionRiskAssessmentReportInfoMapper)this.dao).insertList2(addReportList);
    }
}

