/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.selfjudge;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.framework.singletask.singleTask;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.dao.base.selfjudge.MicroCompanyHsePreventionControlSelfJudgeMapper;
import cn.smarthse.modules.health.entity.base.company.CompanyReportInfo;
import cn.smarthse.modules.health.entity.base.selfjudge.MicroCompanyHsePreventionControlSelfJudge;
import cn.smarthse.modules.health.entity.base.selfjudge.MicroCompanySelfInspectionRiskAssessmentReportInfo;
import cn.smarthse.modules.health.entity.base.selfjudge.MicroOccupationalSelfJudgeTermV308;
import cn.smarthse.modules.health.entity.base.selfjudge.MicroStaffUpdateSelfJudgeTerm;
import cn.smarthse.modules.health.entity.base.selfjudge.SelfInspectionTerm;
import cn.smarthse.modules.health.entity.base.selfjudge.dto.MicroKeyFactoryParam;
import cn.smarthse.modules.health.entity.base.selfjudge.vo.MicroCompanyHsePreventionControlSelfJudgeForm;
import cn.smarthse.modules.health.entity.base.selfjudge.vo.MicroCompanyHsePreventionControlSelfJudgeVo;
import cn.smarthse.modules.health.entity.base.selfjudge.vo.MicroSelfJudgeTermResultsVo;
import cn.smarthse.modules.health.enums.selfjudge.MicroJudgeResultLevelEnum;
import cn.smarthse.modules.health.service.base.company.CompanyReportInfoService;
import cn.smarthse.modules.health.service.base.impl.selfjudge.MicroFunctionInterfaceStrategy;
import cn.smarthse.modules.health.service.base.selfjudge.IMicroCompanyHsePreventionControlSelfJudgeService;
import cn.smarthse.modules.health.service.base.selfjudge.IMicroCompanySelfInspectionRiskAssessmentReportInfoService;
import cn.smarthse.modules.health.service.base.selfjudge.IMicroOccupationalSelfJudgeTermV308Service;
import cn.smarthse.modules.health.service.base.selfjudge.IMicroStaffUpdateSelfJudgeTermService;
import cn.smarthse.modules.health.service.base.selfjudge.ISelfInspectionTermService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.supervise.entity.operate.WorkOperateLog;
import cn.smarthse.modules.health.supervise.enums.WorkOperateLogEnum;
import cn.smarthse.modules.health.supervise.enums.WorkOperateLogStatusEnum;
import cn.smarthse.modules.health.supervise.enums.company.grade.CompanyGradeEventSource;
import cn.smarthse.modules.health.supervise.service.company.grade.IMicroCompanyGradeV3RefreshService;
import cn.smarthse.modules.health.supervise.service.operate.IWorkOperateLogService;
import cn.smarthse.services.hfi.api.entity.riskev.MicroCompanyRiskExposeEvaluate;
import cn.smarthse.services.hfi.api.service.riskev.IMicroCompanyRiskExposeEvaluateService;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.xxl.job.core.context.XxlJobHelper;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import tk.mybatis.mapper.entity.Example;

@DubboService
public class MicroCompanyHsePreventionControlSelfJudgeServiceImpl
extends BaseServiceImpl<MicroCompanyHsePreventionControlSelfJudgeMapper, MicroCompanyHsePreventionControlSelfJudge>
implements IMicroCompanyHsePreventionControlSelfJudgeService {
    @Autowired(required=false)
    private IStaffInfoService staffInfoService;
    @Autowired
    private ISelfInspectionTermService selfInspectionTermService;
    @Autowired(required=false)
    private IMicroOccupationalSelfJudgeTermV308Service microOccupationalSelfJudgeTermV308Service;
    @DubboReference
    private IWorkOperateLogService workOperateLogService;
    @Autowired
    private IMicroStaffUpdateSelfJudgeTermService microStaffUpdateSelfJudgeTermService;
    @Autowired
    private MicroFunctionInterfaceStrategy microFunctionInterfaceStrategy;
    @Autowired
    private IMicroCompanySelfInspectionRiskAssessmentReportInfoService microCompanySelfInspectionRiskAssessmentReportInfoService;
    @Autowired(required=false)
    DataSourceTransactionManager transactionManager;
    @DubboReference
    private IMicroCompanyGradeV3RefreshService microCompanyGradeV3RefreshService;
    @DubboReference
    private ISysFileProvideService sysFileProvideService;
    @DubboReference(version="1.0.0", check=false)
    private ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideByHSEService companyProvideByHSEService;
    @Autowired
    private CompanyReportInfoService companyReportInfoService;
    @DubboReference
    private IMicroCompanyRiskExposeEvaluateService riskExposeEvaluateService;

    public PageInfo<MicroCompanyHsePreventionControlSelfJudgeVo> listPageData(JqGridParam jqGridParam) {
        PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows());
        List<MicroCompanyHsePreventionControlSelfJudgeVo> list = ((MicroCompanyHsePreventionControlSelfJudgeMapper)this.dao).listData(jqGridParam.getCid());
        list.forEach(s -> {
            if (s.getDataSource() != null && s.getDataSource() == 1 && s.getOperatorStaffId() != null) {
                s.setOperatorStaffName(this.staffInfoService.getStaffNameByStaffId(s.getOperatorStaffId()));
            }
            if (s.getJudgeLevel() != null) {
                MicroJudgeResultLevelEnum judgeResultLevelEnum = MicroJudgeResultLevelEnum.getThisEnumByCode((Integer)s.getJudgeLevel().intValue());
                s.setJudgeLevelName(judgeResultLevelEnum == null ? null : judgeResultLevelEnum.getName());
            }
        });
        return new PageInfo(list);
    }

    @Transactional(readOnly=false)
    public MicroCompanyHsePreventionControlSelfJudge addThisYearSelfJudge(Long loginStaffCompanyId, Long loginStaffId) {
        int year = DateUtils.getThisYear();
        MicroCompanyHsePreventionControlSelfJudge selfJudge = this.getThisYearSelfJudgeByCid(year, loginStaffCompanyId);
        try {
            if (selfJudge == null) {
                selfJudge = new MicroCompanyHsePreventionControlSelfJudge();
                selfJudge.setCid(loginStaffCompanyId);
                selfJudge.setYear(Long.valueOf(year));
                selfJudge.setCidYear("" + loginStaffCompanyId + year);
                selfJudge.setSelfFromYear(Byte.valueOf((byte)1));
                selfJudge.setStatus(Byte.valueOf((byte)1));
                selfJudge.setDataSource(Byte.valueOf((byte)1));
                selfJudge.setIsValid(Boolean.valueOf(true));
                selfJudge.setSelfTime(new Date());
                selfJudge = this.add(selfJudge, loginStaffId, loginStaffCompanyId);
                List terms = this.selfInspectionTermService.getListByFlag(Integer.valueOf(3));
                MicroCompanyHsePreventionControlSelfJudge finalSelfJudge = selfJudge;
                List judgeTermV308s = terms.stream().map(term -> {
                    MicroOccupationalSelfJudgeTermV308 judgeTermV308 = new MicroOccupationalSelfJudgeTermV308();
                    judgeTermV308.setSelfId(finalSelfJudge.getId());
                    judgeTermV308.setCreateBy(loginStaffId);
                    judgeTermV308.setCreateDate(new Date());
                    judgeTermV308.setUpdateBy(loginStaffId);
                    judgeTermV308.setUpdateDate(new Date());
                    judgeTermV308.setIsValid(Boolean.valueOf(true));
                    judgeTermV308.setCheckResult(Byte.valueOf((byte)3));
                    judgeTermV308.setTermNo(Long.valueOf(term.getTermNo().longValue()));
                    judgeTermV308.setChecked(Boolean.valueOf(false));
                    judgeTermV308.setTermObtainScore(term.getScore() == null ? null : Double.valueOf(0.0));
                    judgeTermV308.setTermScore(term.getScore() == null ? null : Double.valueOf(term.getScore().doubleValue()));
                    return judgeTermV308;
                }).collect(Collectors.toList());
                this.microOccupationalSelfJudgeTermV308Service.addBatch(judgeTermV308s);
            }
        }
        catch (Exception e) {
            this.logger.info("\u521b\u5efa\u81ea\u67e5\u5931\u8d25!" + e.getMessage());
        }
        return selfJudge;
    }

    @Transactional(readOnly=false)
    public void addReturnData(Long loginStaffCompanyId) {
        MicroCompanyHsePreventionControlSelfJudge selfJudge;
        Example example = new Example(MicroCompanyHsePreventionControlSelfJudge.class);
        example.createCriteria().andEqualTo("status", (Object)3).andEqualTo("isValid", (Object)true).andEqualTo("cid", (Object)loginStaffCompanyId);
        List dbList = this.getListByExample(example);
        if (CollectionUtils.isNotEmpty(dbList) && Objects.isNull(selfJudge = (MicroCompanyHsePreventionControlSelfJudge)dbList.stream().filter(item -> item.getTableFlag() != null && item.getTableFlag() == 1).findFirst().orElse(null))) {
            this.copyThisData2Db((MicroCompanyHsePreventionControlSelfJudge)dbList.get(0));
        }
    }

    @Transactional(readOnly=false)
    public void copyThisData2Db(MicroCompanyHsePreventionControlSelfJudge selfJudge) {
        MicroCompanyHsePreventionControlSelfJudge selfJudgeNew = new MicroCompanyHsePreventionControlSelfJudge();
        BeanUtils.copyProperties((Object)selfJudge, (Object)selfJudgeNew);
        selfJudgeNew.setId(null);
        selfJudgeNew.setCidYear(null);
        selfJudgeNew.setTableFlag(Byte.valueOf((byte)1));
        selfJudgeNew.setCreateDate(new Date());
        selfJudgeNew.setSourceId(selfJudge.getId());
        MicroCompanyHsePreventionControlSelfJudge add = this.add(selfJudgeNew);
        List terms = this.microOccupationalSelfJudgeTermV308Service.getListBySelfId(selfJudge.getId());
        terms.forEach(term -> {
            term.setId(null);
            term.setCreateDate(new Date());
            term.setCreateBy(Long.valueOf(0L));
            term.setSelfId(add.getId());
        });
        this.microOccupationalSelfJudgeTermV308Service.addBatch(terms);
    }

    public MicroCompanyHsePreventionControlSelfJudgeVo getVoById(Long id) {
        MicroCompanyHsePreventionControlSelfJudgeVo vo = new MicroCompanyHsePreventionControlSelfJudgeVo();
        vo.setSelfJudge((MicroCompanyHsePreventionControlSelfJudge)this.getById(id));
        vo.setTerms(this.microOccupationalSelfJudgeTermV308Service.getListBySelfId(id));
        if (vo.getSelfJudge() != null && vo.getSelfJudge().getJudgeLevel() != null) {
            MicroJudgeResultLevelEnum judgeResultLevelEnum = MicroJudgeResultLevelEnum.getThisEnumByCode((Integer)vo.getSelfJudge().getJudgeLevel().intValue());
            vo.setJudgeLevelName(judgeResultLevelEnum == null ? null : judgeResultLevelEnum.getName());
        }
        vo.setAbleMissingItemCount(Long.valueOf(0L));
        vo.setRectifyItemCount(Long.valueOf(0L));
        vo.setDisableMissingObtainScore(Double.valueOf(0.0));
        vo.setDisableMissingTotalScore(Double.valueOf(0.0));
        if (vo.getTerms() != null && vo.getTerms().size() > 0) {
            List terms = this.selfInspectionTermService.getListByFlag(Integer.valueOf(3));
            vo.getTerms().stream().forEach(s -> {
                SelfInspectionTerm t;
                if (s.getCheckResult() != null && s.getCheckResult() != 4) {
                    vo.setDisableMissingTotalScore(Double.valueOf(vo.getDisableMissingTotalScore() + (s.getTermScore() == null ? 0.0 : s.getTermScore())));
                    vo.setDisableMissingObtainScore(Double.valueOf(vo.getDisableMissingObtainScore() + (s.getTermObtainScore() == null ? 0.0 : s.getTermObtainScore())));
                }
                if ((t = (SelfInspectionTerm)terms.stream().filter(s1 -> Long.valueOf(s1.getTermNo().intValue()).equals(s.getTermNo())).findFirst().orElse(null)) != null) {
                    s.setTermName(t.getTermName());
                }
            });
            vo.setRectifyItemCount(Long.valueOf(vo.getTerms().stream().filter(s -> s.getCheckResult() != null && (s.getCheckResult() == 2 || s.getCheckResult() == 3) && s.getChecked() != null && s.getChecked() != false).count()));
            vo.setAbleMissingItemCount(Long.valueOf(vo.getTerms().stream().filter(s -> s.getCheckResult() != null && s.getCheckResult() == 4 && s.getChecked() != null && s.getChecked() != false).count()));
            vo.setAbleMissingTerms(vo.getTerms().stream().filter(s -> s.getCheckResult() != null && s.getCheckResult() == 4 && s.getChecked() != null && s.getChecked() != false).collect(Collectors.toList()));
            vo.setRectifyTerms(vo.getTerms().stream().filter(s -> s.getCheckResult() != null && (s.getCheckResult() == 2 || s.getCheckResult() == 3) && s.getChecked() != null && s.getChecked() != false).collect(Collectors.toList()));
        }
        return vo;
    }

    public MicroCompanyHsePreventionControlSelfJudge getLatestSelfJudgeByDateRange(Long cid, Date begin, Date end) {
        return ((MicroCompanyHsePreventionControlSelfJudgeMapper)this.dao).getLatestSelfJudgeByDateRange(cid, begin, end);
    }

    private MicroCompanyHsePreventionControlSelfJudge getThisYearSelfJudgeByCid(int year, Long cid) {
        Example example = new Example(MicroCompanyHsePreventionControlSelfJudge.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("selfFromYear", (Object)1).andEqualTo("isValid", (Object)true);
        List list = ((MicroCompanyHsePreventionControlSelfJudgeMapper)this.dao).selectByExample(example);
        if (list != null && !list.isEmpty()) {
            return (MicroCompanyHsePreventionControlSelfJudge)list.get(0);
        }
        return null;
    }

    private List<MicroCompanyHsePreventionControlSelfJudge> getSelfJudgeByCidList(int year, List<Long> cidList, Integer selfFromType) {
        List<MicroCompanyHsePreventionControlSelfJudge> list = ((MicroCompanyHsePreventionControlSelfJudgeMapper)this.dao).getSelfJudgeByCidList(cidList, selfFromType);
        return list;
    }

    private List<MicroCompanyHsePreventionControlSelfJudge> getChangeYearSelfJudgeByCidList(Integer year, List<Long> cidList) {
        if (CollectionUtils.isEmpty(cidList)) {
            return new ArrayList<MicroCompanyHsePreventionControlSelfJudge>();
        }
        return ((MicroCompanyHsePreventionControlSelfJudgeMapper)this.dao).getChangeYearSelfJudgeByCidList(cidList);
    }

    private List<Long> getChangeYearSelfJudgeCidListByCidList(int year, List<Long> cidList) {
        if (CollectionUtils.isEmpty(cidList)) {
            return new ArrayList<Long>();
        }
        return ((MicroCompanyHsePreventionControlSelfJudgeMapper)this.dao).getChangeYearSelfJudgeCidListByCidList(cidList);
    }

    @Transactional(readOnly=false)
    public void deleteSelfJudge(Long id, Long loginStaffId) {
        if (id != null) {
            MicroCompanyHsePreventionControlSelfJudge info = new MicroCompanyHsePreventionControlSelfJudge();
            info.setId(id);
            this.delete(info, loginStaffId);
        }
    }

    public MicroCompanyHsePreventionControlSelfJudge getLatestEntityNoStatusByCid(Long cid) {
        MicroCompanyHsePreventionControlSelfJudge selfJudge = ((MicroCompanyHsePreventionControlSelfJudgeMapper)this.dao).getLatestEntityNoStatusByCid(cid);
        return selfJudge;
    }

    public List<MicroCompanyHsePreventionControlSelfJudge> getLatestEntityNoStatusByCids(List<Long> cids) {
        if (CollectionUtils.isEmpty(cids)) {
            return new ArrayList<MicroCompanyHsePreventionControlSelfJudge>();
        }
        List<MicroCompanyHsePreventionControlSelfJudge> selfJudgeList = ((MicroCompanyHsePreventionControlSelfJudgeMapper)this.dao).getLatestEntityNoStatusByCids(cids);
        return selfJudgeList;
    }

    @Transactional(readOnly=false)
    @singleTask(expressions={"form.selfJudge.id"})
    public int savePreventionControlSelfJudgeSubmit(MicroCompanyHsePreventionControlSelfJudgeForm form, Long loginStaffId, Long loginStaffCompanyId) {
        try {
            AtomicReference<Double> termObtainScore;
            AtomicReference<Double> totalScore;
            if (form.getSelfJudge().getIsFirst().booleanValue()) {
                form.getSelfJudge().setSelfTime(new Date());
            }
            form.getSelfJudge().setIsValid(Boolean.valueOf(true));
            boolean isNeedUpdate = true;
            if (form.getSelfJudge().getId() == null) {
                MicroCompanyHsePreventionControlSelfJudge selfJudge = this.add(form.getSelfJudge(), loginStaffId, loginStaffCompanyId);
                form.setSelfJudge(selfJudge);
                isNeedUpdate = false;
            }
            ArrayList items = new ArrayList();
            if (form.getTerms() != null) {
                items.addAll(form.getTerms());
            }
            if (items.size() > 0) {
                MicroOccupationalSelfJudgeTermV308 needTerm = items.stream().filter(s -> s.getIsNeeUpdate()).findFirst().orElse(null);
                if (needTerm != null) {
                    Boolean isStaffUpdate = needTerm.getIsStaffUpdate();
                    if (Boolean.TRUE.equals(isStaffUpdate)) {
                        this.microStaffUpdateSelfJudgeTermService.addUpdateSelfJudgeTerm(needTerm, Byte.valueOf((byte)1), loginStaffId, loginStaffCompanyId);
                    }
                    if (Byte.valueOf((byte)4).equals(needTerm.getCheckResult())) {
                        needTerm.setTermObtainScore(Double.valueOf(0.0));
                    } else if (Byte.valueOf((byte)3).equals(needTerm.getCheckResult())) {
                        needTerm.setTermObtainScore(Double.valueOf(0.0));
                    } else if (Byte.valueOf((byte)2).equals(needTerm.getCheckResult())) {
                        if (needTerm.getTermScore() != null) {
                            needTerm.setTermObtainScore(Double.valueOf(needTerm.getTermScore() / 2.0));
                        }
                    } else if (Byte.valueOf((byte)1).equals(needTerm.getCheckResult())) {
                        needTerm.setTermObtainScore(needTerm.getTermScore());
                    }
                    this.microOccupationalSelfJudgeTermV308Service.updateTermBySelfIdAndTermNo(needTerm, loginStaffId);
                }
                totalScore = new AtomicReference<Double>(0.0);
                termObtainScore = new AtomicReference<Double>(0.0);
                items.stream().map(s -> {
                    s.setSelfId(form.getSelfJudge().getId());
                    s.setCreateBy(loginStaffId);
                    s.setCreateDate(new Date());
                    s.setUpdateBy(loginStaffId);
                    s.setUpdateDate(new Date());
                    s.setIsValid(Boolean.valueOf(true));
                    if (!Byte.valueOf((byte)4).equals(s.getCheckResult())) {
                        totalScore.updateAndGet(v -> v + (s.getTermScore() == null ? 0.0 : s.getTermScore()));
                        termObtainScore.updateAndGet(v -> v + (s.getTermObtainScore() == null ? 0.0 : s.getTermObtainScore()));
                    }
                    return s;
                }).collect(Collectors.toList());
                if (totalScore.get() == 0.0 || termObtainScore.get() == 0.0) {
                    form.getSelfJudge().setTotalScore("0.0");
                } else {
                    form.getSelfJudge().setTotalScore(new BigDecimal(termObtainScore.get() * 100.0 / totalScore.get()).setScale(1, 4).toString());
                }
                form.getSelfJudge().setJudgeLevel(Long.valueOf(MicroJudgeResultLevelEnum.getThisEnumByScore((Double)(StringUtils.isNumber((String)form.getSelfJudge().getTotalScore()) ? Double.valueOf(form.getSelfJudge().getTotalScore()) : 0.0)).getCode().longValue()));
            }
            if (isNeedUpdate) {
                Long sourceDataId;
                List terms;
                if (form.getSelfJudge().getStatus() != null && form.getSelfJudge().getStatus() == 2 && CollectionUtils.isNotEmpty((Collection)(terms = this.microOccupationalSelfJudgeTermV308Service.getListBySelfId(form.getSelfJudge().getId())))) {
                    totalScore = new AtomicReference<Double>(0.0);
                    termObtainScore = new AtomicReference<Double>(0.0);
                    terms.stream().map(s -> {
                        s.setSelfId(form.getSelfJudge().getId());
                        if (!Byte.valueOf((byte)4).equals(s.getCheckResult())) {
                            totalScore.updateAndGet(v -> v + (s.getTermScore() == null ? 0.0 : s.getTermScore()));
                            termObtainScore.updateAndGet(v -> v + (s.getTermObtainScore() == null ? 0.0 : s.getTermObtainScore()));
                        }
                        return s;
                    }).collect(Collectors.toList());
                    if (totalScore.get() == 0.0 || termObtainScore.get() == 0.0) {
                        form.getSelfJudge().setTotalScore("0.0");
                    } else {
                        form.getSelfJudge().setTotalScore(new BigDecimal(termObtainScore.get() * 100.0 / totalScore.get()).setScale(1, 4).toString());
                    }
                    if (this.isBest(loginStaffCompanyId)) {
                        form.getSelfJudge().setJudgeLevel(Long.valueOf(1L));
                    } else {
                        form.getSelfJudge().setJudgeLevel(Long.valueOf(MicroJudgeResultLevelEnum.getThisEnumByScore((Double)(StringUtils.isNumber((String)form.getSelfJudge().getTotalScore()) ? Double.valueOf(form.getSelfJudge().getTotalScore()) : 0.0)).getCode().longValue()));
                    }
                }
                if ("1".equalsIgnoreCase(form.getSubmitTotal()) && Objects.nonNull(sourceDataId = this.getSourceDataId(form.getSelfJudge().getId(), loginStaffCompanyId))) {
                    List terms2 = this.microOccupationalSelfJudgeTermV308Service.getListBySelfId(form.getSelfJudge().getId());
                    List oldTerms = this.microOccupationalSelfJudgeTermV308Service.getListBySelfId(sourceDataId);
                    MicroCompanyHsePreventionControlSelfJudge sourceData = (MicroCompanyHsePreventionControlSelfJudge)this.getById(sourceDataId);
                    oldTerms.forEach(item -> item.setIsValid(Boolean.valueOf(false)));
                    terms2.forEach(item -> {
                        item.setSelfId(sourceDataId);
                        item.setIsValid(Boolean.valueOf(true));
                        item.setUpdateDate(new Date());
                    });
                    sourceData.setId(form.getSelfJudge().getId());
                    sourceData.setCidYear(null);
                    sourceData.setTableFlag(Byte.valueOf((byte)2));
                    sourceData.setIsValid(Boolean.valueOf(false));
                    form.getSelfJudge().setId(sourceDataId);
                    form.getSelfJudge().setCidYear(sourceData.getCidYear());
                    form.getSelfJudge().setTableFlag(Byte.valueOf((byte)0));
                    this.update(sourceData, loginStaffId);
                    this.microOccupationalSelfJudgeTermV308Service.updateBatch(oldTerms);
                    this.microOccupationalSelfJudgeTermV308Service.updateBatch(terms2);
                }
                this.update(form.getSelfJudge(), loginStaffId);
                if (form.getSelfJudge().getStatus() != null && form.getSelfJudge().getStatus() == 2) {
                    this.workOperateLogService.report(form.getSelfJudge().getId(), WorkOperateLogEnum.investigationRiskAssessment.getTypeVal(), loginStaffId, form.getOperaterName(), form.getCompanyName());
                }
            }
            return 1;
        }
        catch (Exception e) {
            this.logger.info("\u81ea\u67e5\u66f4\u65b0\u62a5\u9519" + e.getMessage());
            return 0;
        }
    }

    public Long getSourceDataId(Long id, Long cid) {
        Example example = new Example(MicroCompanyHsePreventionControlSelfJudge.class);
        example.createCriteria().andEqualTo("id", (Object)id).andEqualTo("isValid", (Object)Global.TRUE);
        MicroCompanyHsePreventionControlSelfJudge selfJudge = (MicroCompanyHsePreventionControlSelfJudge)this.getOneByExample(example);
        if (selfJudge == null) {
            return null;
        }
        return selfJudge.getSourceId();
    }

    private MicroCompanyHsePreventionControlSelfJudge getLastTimeSelfJudgeById(Long cid, Integer status, Long id) {
        return ((MicroCompanyHsePreventionControlSelfJudgeMapper)this.dao).getLastTimeSelfJudgeById(cid, status, id);
    }

    public MicroCompanyHsePreventionControlSelfJudgeVo getV314VoById(Long id) {
        MicroCompanyHsePreventionControlSelfJudgeVo vo = new MicroCompanyHsePreventionControlSelfJudgeVo();
        vo.setSelfJudge((MicroCompanyHsePreventionControlSelfJudge)this.getById(id));
        vo.setTerms(this.microOccupationalSelfJudgeTermV308Service.getListBySelfId(id));
        if (vo.getSelfJudge() != null && vo.getSelfJudge().getJudgeLevel() != null) {
            MicroJudgeResultLevelEnum judgeResultLevelEnum = MicroJudgeResultLevelEnum.getThisEnumByCode((Integer)vo.getSelfJudge().getJudgeLevel().intValue());
            vo.setJudgeLevelName(judgeResultLevelEnum == null ? null : judgeResultLevelEnum.getName());
        }
        vo.setAbleMissingItemCount(Long.valueOf(0L));
        vo.setRectifyItemCount(Long.valueOf(0L));
        vo.setDisableMissingObtainScore(Double.valueOf(0.0));
        vo.setDisableMissingTotalScore(Double.valueOf(0.0));
        MicroStaffUpdateSelfJudgeTerm staffUpdateSelfJudgeTerm = new MicroStaffUpdateSelfJudgeTerm();
        staffUpdateSelfJudgeTerm.setCidList(Arrays.asList(vo.getSelfJudge().getCid()));
        staffUpdateSelfJudgeTerm.setValidData(Boolean.valueOf(true));
        List staffUpdateResults = this.microStaffUpdateSelfJudgeTermService.getStaffUpdateResults(staffUpdateSelfJudgeTerm);
        Map<Long, MicroStaffUpdateSelfJudgeTerm> selfJudgeTermMap = staffUpdateResults.stream().filter(s -> ObjectUtil.isNotNull((Object)s.getTermNo())).collect(Collectors.toMap(MicroStaffUpdateSelfJudgeTerm::getTermNo, s -> s, (s1, s2) -> s1));
        if (vo.getTerms() != null && vo.getTerms().size() > 0) {
            List terms = this.selfInspectionTermService.getListByFlag(Integer.valueOf(3));
            vo.getTerms().stream().forEach(s -> {
                SelfInspectionTerm t;
                if (s.getCheckResult() != null && s.getCheckResult() != 4) {
                    vo.setDisableMissingTotalScore(Double.valueOf(vo.getDisableMissingTotalScore() + (s.getTermScore() == null ? 0.0 : s.getTermScore())));
                    vo.setDisableMissingObtainScore(Double.valueOf(vo.getDisableMissingObtainScore() + (s.getTermObtainScore() == null ? 0.0 : s.getTermObtainScore())));
                }
                if ((t = (SelfInspectionTerm)terms.stream().filter(s1 -> Long.valueOf(s1.getTermNo().intValue()).equals(s.getTermNo())).findFirst().orElse(null)) != null) {
                    s.setTermName(t.getTermName());
                }
            });
            vo.setRectifyItemCount(Long.valueOf(vo.getTerms().stream().filter(s -> s.getCheckResult() != null && (s.getCheckResult() == 2 || s.getCheckResult() == 3)).count()));
            vo.setAbleMissingItemCount(Long.valueOf(vo.getTerms().stream().filter(s -> s.getCheckResult() != null && s.getCheckResult() == 4).count()));
            vo.setAbleMissingTerms(vo.getTerms().stream().filter(s -> s.getCheckResult() != null && s.getCheckResult() == 4).collect(Collectors.toList()));
            vo.setRectifyTerms(vo.getTerms().stream().filter(s -> s.getCheckResult() != null && (s.getCheckResult() == 2 || s.getCheckResult() == 3)).collect(Collectors.toList()));
            vo.setUserUpdateTerms(vo.getTerms().stream().filter(s -> s.getCheckResult() != null && ObjectUtil.isNotNull(selfJudgeTermMap.get(s.getTermNo())) && Integer.valueOf(s.getCheckResult().byteValue()).equals(((MicroStaffUpdateSelfJudgeTerm)selfJudgeTermMap.get(s.getTermNo())).getCheckResult())).peek(s -> {
                if (StringUtils.isNotEmpty((String)((MicroStaffUpdateSelfJudgeTerm)selfJudgeTermMap.get(s.getTermNo())).getFileId())) {
                    String[] split = ((MicroStaffUpdateSelfJudgeTerm)selfJudgeTermMap.get(s.getTermNo())).getFileId().split(",");
                    ArrayList<SysFileModel> sysFileModels = new ArrayList<SysFileModel>();
                    for (String fileId : split) {
                        SysFileModel sysFileModel;
                        Boolean creatable = NumberUtils.isCreatable((String)fileId);
                        if (!creatable.booleanValue() || !ObjectUtil.isNotNull((Object)(sysFileModel = this.sysFileProvideService.getFileById(Long.valueOf(fileId))))) continue;
                        sysFileModels.add(sysFileModel);
                    }
                    s.setFileModelList(sysFileModels);
                }
            }).collect(Collectors.toList()));
        }
        if (vo.getSelfJudge() != null) {
            vo.setLastYearLatestSelfJudge(this.getLatestSelfJudgeByDateRange(vo.getSelfJudge().getCid(), DateUtils.getYearFirstDay((int)(DateUtils.getThisYear() - 1)), DateUtils.getYearLastDay((int)(DateUtils.getThisYear() - 1))));
            vo.setLastTimeSelfJudge(this.getLastTimeSelfJudgeById(vo.getSelfJudge().getCid(), 4, vo.getSelfJudge().getId()));
        }
        if (vo.getLastYearLatestSelfJudge() != null) {
            vo.setLastYearLatestTerms(this.microOccupationalSelfJudgeTermV308Service.getListBySelfId(vo.getLastYearLatestSelfJudge().getId()));
        }
        if (vo.getLastTimeSelfJudge() != null) {
            vo.setLastTimeTerms(this.microOccupationalSelfJudgeTermV308Service.getListBySelfId(vo.getLastTimeSelfJudge().getId()));
        }
        return vo;
    }

    public List<MicroCompanyHsePreventionControlSelfJudge> listDataV314EveryCidLatestForSuperviseByDateRange(Date beginDate, Date endDate, List<Long> cids) {
        List<MicroCompanyHsePreventionControlSelfJudge> selfJudgeListJudges = null;
        selfJudgeListJudges = CollectionUtils.isNotEmpty(cids) ? ((MicroCompanyHsePreventionControlSelfJudgeMapper)this.dao).listDataV314EveryCidLatestForSuperviseByDateRange(beginDate, endDate, cids, 100000) : ((MicroCompanyHsePreventionControlSelfJudgeMapper)this.dao).listDataV314EveryCidLatestForSuperviseByDateRange(beginDate, endDate, cids, ((MicroCompanyHsePreventionControlSelfJudgeMapper)this.dao).selectCount(new MicroCompanyHsePreventionControlSelfJudge()));
        return selfJudgeListJudges;
    }

    public Map<Long, MicroCompanyHsePreventionControlSelfJudge> queryByIds(List<Long> selfIds) {
        if (selfIds == null || selfIds.isEmpty()) {
            return new HashMap<Long, MicroCompanyHsePreventionControlSelfJudge>();
        }
        Example example = new Example(MicroCompanyHsePreventionControlSelfJudge.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andIn("id", selfIds);
        List list = ((MicroCompanyHsePreventionControlSelfJudgeMapper)this.dao).selectByExample(example);
        if (list == null || list.isEmpty()) {
            return new HashMap<Long, MicroCompanyHsePreventionControlSelfJudge>();
        }
        return list.stream().collect(Collectors.toMap(MicroCompanyHsePreventionControlSelfJudge::getId, s -> s));
    }

    @Transactional(readOnly=false)
    public int examineAndVerifySelfJudgeById(MicroCompanyHsePreventionControlSelfJudge selfJudge, Long loginUserId, String reason, String operater, String companyName) {
        if (selfJudge == null && selfJudge.getId() == null || selfJudge.getStatus() == null || selfJudge.getStatus() == 1 || selfJudge.getStatus() == 2) {
            return 0;
        }
        MicroCompanyHsePreventionControlSelfJudge dbdata = (MicroCompanyHsePreventionControlSelfJudge)this.getById(selfJudge.getId());
        if (dbdata == null) {
            this.logger.warn("\u81ea\u67e5\u5ba1\u6838\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff0cselfJudge:{}", (Object)JSON.toJSONString((Object)selfJudge));
            return 0;
        }
        if (selfJudge.getStatus() == 4) {
            this.microStaffUpdateSelfJudgeTermService.setStatusByCids(selfJudge.getStatus(), Arrays.asList(dbdata.getCid()), null, loginUserId);
        }
        MicroCompanyHsePreventionControlSelfJudge updateSelfJudge = new MicroCompanyHsePreventionControlSelfJudge();
        updateSelfJudge.setId(selfJudge.getId());
        updateSelfJudge.setStatus(selfJudge.getStatus());
        updateSelfJudge.setBackReasonDetail(selfJudge.getBackReasonDetail());
        boolean addLog = true;
        if (Objects.equals(selfJudge.getStatus(), (byte)4) && Objects.equals(selfJudge.getStatus(), dbdata.getStatus())) {
            addLog = false;
        }
        if (addLog) {
            this.update(updateSelfJudge, loginUserId);
        }
        if (!addLog || selfJudge.getStatus() == null || selfJudge.getStatus() == 4) {
            // empty if block
        }
        if (addLog) {
            this.workOperateLogService.addOperateLog(selfJudge.getId(), WorkOperateLogEnum.Responsibility.getTypeVal(), reason, loginUserId, operater, Objects.equals(selfJudge.getStatus(), (byte)4) ? WorkOperateLogStatusEnum.pass : WorkOperateLogStatusEnum.back, companyName);
        }
        return 1;
    }

    public ResponseData doOperation(MicroKeyFactoryParam params, Long status) {
        return this.microFunctionInterfaceStrategy.doOperation(params, status);
    }

    public Boolean isFinishSelf(Long cid) {
        Example example = new Example(MicroCompanyHsePreventionControlSelfJudge.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("status", (Object)4).andEqualTo("isValid", (Object)Global.TRUE);
        List list = this.getListByExample(example);
        return CollectionUtils.isNotEmpty(list);
    }

    @Transactional(readOnly=false)
    public MicroCompanyHsePreventionControlSelfJudge addChangeTypeSelfJudge(MicroCompanyHsePreventionControlSelfJudge selfJudge, Long reportId, Long loginStaffCompanyId, Long loginStaffId) {
        if (selfJudge.getId() == null && Byte.valueOf("2").equals(selfJudge.getSelfFromYear())) {
            int year = DateUtils.getThisYear();
            selfJudge.setCid(loginStaffCompanyId);
            selfJudge.setYear(Long.valueOf(year));
            selfJudge.setSelfTime(new Date());
            selfJudge.setStatus(Byte.valueOf((byte)1));
            selfJudge.setDataSource(Byte.valueOf((byte)1));
            selfJudge.setIsValid(Boolean.valueOf(true));
            selfJudge = this.add(selfJudge, loginStaffId, loginStaffCompanyId);
            List terms = this.selfInspectionTermService.getListByFlag(Integer.valueOf(3));
            MicroCompanyHsePreventionControlSelfJudge finalSelfJudge = selfJudge;
            List judgeTermV308s = terms.stream().map(term -> {
                MicroOccupationalSelfJudgeTermV308 judgeTermV308 = new MicroOccupationalSelfJudgeTermV308();
                judgeTermV308.setSelfId(finalSelfJudge.getId());
                judgeTermV308.setCreateBy(loginStaffId);
                judgeTermV308.setCreateDate(new Date());
                judgeTermV308.setUpdateBy(loginStaffId);
                judgeTermV308.setUpdateDate(new Date());
                judgeTermV308.setIsValid(Boolean.valueOf(true));
                judgeTermV308.setCheckResult(Byte.valueOf((byte)3));
                judgeTermV308.setTermNo(Long.valueOf(term.getTermNo().longValue()));
                judgeTermV308.setTermObtainScore(term.getScore() == null ? null : Double.valueOf(0.0));
                judgeTermV308.setTermScore(term.getScore() == null ? null : Double.valueOf(term.getScore().doubleValue()));
                return judgeTermV308;
            }).collect(Collectors.toList());
            this.microOccupationalSelfJudgeTermV308Service.addBatch(judgeTermV308s);
            if (reportId != null) {
                MicroCompanySelfInspectionRiskAssessmentReportInfo reportInfo = new MicroCompanySelfInspectionRiskAssessmentReportInfo();
                reportInfo.setId(reportId);
                reportInfo.setSelfReportId(selfJudge.getId());
                this.microCompanySelfInspectionRiskAssessmentReportInfoService.update((Object)reportInfo, loginStaffId);
            }
        }
        return selfJudge;
    }

    public Integer microCompanySelfJudgeGenerated(String cids) throws Exception {
        ArrayList<Long> cidList = new ArrayList<Long>();
        if (StringUtils.isNotEmpty((String)cids)) {
            cidList.addAll(Arrays.stream(cids.split(",")).map(String::trim).filter(s -> StringUtils.isNotEmpty((String)s)).map(Long::valueOf).collect(Collectors.toList()));
        }
        if (CollectionUtils.isEmpty(cidList)) {
            cidList.addAll(((MicroCompanyHsePreventionControlSelfJudgeMapper)this.dao).selectYCSmallCids());
        }
        if (CollectionUtils.isEmpty(cidList)) {
            return 0;
        }
        List partitionCidList = ListUtil.partition(cidList, (int)1000);
        XxlJobHelper.log((String)"partitionCidList:{}", (Object[])new Object[]{partitionCidList.size()});
        Integer thisYear = DateUtils.getThisYear();
        for (List cidLongs : partitionCidList) {
            List<MicroCompanyHsePreventionControlSelfJudge> thisYearSelfJudgeByCidList = this.getSelfJudgeByCidList(thisYear, cidLongs, 1);
            List<Long> changeCidList = this.getChangeYearSelfJudgeCidListByCidList(thisYear, cidLongs);
            Map<Long, List<MicroCompanyHsePreventionControlSelfJudge>> selfJudgeMap = thisYearSelfJudgeByCidList.stream().collect(Collectors.groupingBy(MicroCompanyHsePreventionControlSelfJudge::getCid));
            List terms = this.selfInspectionTermService.getListByFlag(Integer.valueOf(3));
            ArrayList<MicroCompanyHsePreventionControlSelfJudge> selfJudgeList = new ArrayList<MicroCompanyHsePreventionControlSelfJudge>();
            ArrayList selfJudgeTermV308List = new ArrayList();
            TransactionStatus status = null;
            MicroKeyFactoryParam keyFactoryParam = new MicroKeyFactoryParam();
            keyFactoryParam.setCidList(cidLongs);
            List resultListNo1 = (List)this.microFunctionInterfaceStrategy.doOperation(keyFactoryParam, 1L).getResult();
            List resultListNo2 = (List)this.microFunctionInterfaceStrategy.doOperation(keyFactoryParam, 2L).getResult();
            List resultListNo3 = (List)this.microFunctionInterfaceStrategy.doOperation(keyFactoryParam, 3L).getResult();
            List resultListNo4 = (List)this.microFunctionInterfaceStrategy.doOperation(keyFactoryParam, 4L).getResult();
            List resultListNo5 = (List)this.microFunctionInterfaceStrategy.doOperation(keyFactoryParam, 5L).getResult();
            List resultListNo6 = (List)this.microFunctionInterfaceStrategy.doOperation(keyFactoryParam, 6L).getResult();
            List resultListNo7 = (List)this.microFunctionInterfaceStrategy.doOperation(keyFactoryParam, 7L).getResult();
            HashMap<Long, Map<Long, MicroSelfJudgeTermResultsVo>> resultsVoMap = new HashMap<Long, Map<Long, MicroSelfJudgeTermResultsVo>>();
            resultsVoMap.put(1L, resultListNo1.stream().collect(Collectors.toMap(MicroSelfJudgeTermResultsVo::getCid, r -> r, (r1, r2) -> r1)));
            resultsVoMap.put(2L, resultListNo2.stream().collect(Collectors.toMap(MicroSelfJudgeTermResultsVo::getCid, r -> r, (r1, r2) -> r1)));
            resultsVoMap.put(3L, resultListNo3.stream().collect(Collectors.toMap(MicroSelfJudgeTermResultsVo::getCid, r -> r, (r1, r2) -> r1)));
            resultsVoMap.put(4L, resultListNo4.stream().collect(Collectors.toMap(MicroSelfJudgeTermResultsVo::getCid, r -> r, (r1, r2) -> r1)));
            resultsVoMap.put(5L, resultListNo5.stream().collect(Collectors.toMap(MicroSelfJudgeTermResultsVo::getCid, r -> r, (r1, r2) -> r1)));
            resultsVoMap.put(6L, resultListNo6.stream().collect(Collectors.toMap(MicroSelfJudgeTermResultsVo::getCid, r -> r, (r1, r2) -> r1)));
            resultsVoMap.put(7L, resultListNo7.stream().collect(Collectors.toMap(MicroSelfJudgeTermResultsVo::getCid, r -> r, (r1, r2) -> r1)));
            try {
                List<Long> yearList;
                if (this.transactionManager != null) {
                    DefaultTransactionDefinition def = new DefaultTransactionDefinition();
                    def.setPropagationBehavior(3);
                    status = this.transactionManager.getTransaction((TransactionDefinition)def);
                    this.logger.info("\u4e8b\u52a1\u72b6\u6001\uff1a{}", (Object)status.toString());
                }
                for (Object cid2 : cidLongs) {
                    Date date = new Date();
                    List<MicroCompanyHsePreventionControlSelfJudge> microCompanyHsePreventionControlSelfJudges = selfJudgeMap.get(cid2);
                    if (!CollectionUtils.isEmpty(microCompanyHsePreventionControlSelfJudges)) continue;
                    MicroCompanyHsePreventionControlSelfJudge selfJudge = new MicroCompanyHsePreventionControlSelfJudge();
                    selfJudge.setId(Long.valueOf(this.idworker.nextId()));
                    selfJudge.setCid((Long)cid2);
                    selfJudge.setYear(Long.valueOf(thisYear.intValue()));
                    selfJudge.setCidYear("" + (Long)cid2 + thisYear);
                    selfJudge.setSelfFromYear(Byte.valueOf((byte)1));
                    selfJudge.setStatus(Byte.valueOf((byte)1));
                    selfJudge.setDataSource(Byte.valueOf((byte)1));
                    selfJudge.setIsValid(Boolean.valueOf(true));
                    selfJudge.setUpdateBy(Long.valueOf(0L));
                    selfJudge.setUpdateDate(date);
                    selfJudge.setCreateBy(Long.valueOf(0L));
                    selfJudge.setCreateDate(date);
                    selfJudge.setSelfTime(date);
                    selfJudgeList.add(selfJudge);
                    List judgeTermV308s = terms.stream().map(term -> {
                        MicroOccupationalSelfJudgeTermV308 judgeTermV308 = new MicroOccupationalSelfJudgeTermV308();
                        judgeTermV308.setSelfId(selfJudge.getId());
                        judgeTermV308.setCreateBy(Long.valueOf(0L));
                        judgeTermV308.setCreateDate(date);
                        judgeTermV308.setUpdateBy(Long.valueOf(0L));
                        judgeTermV308.setUpdateDate(date);
                        judgeTermV308.setIsValid(Boolean.valueOf(true));
                        judgeTermV308.setCheckResult(Byte.valueOf((byte)3));
                        judgeTermV308.setTermNo(Long.valueOf(term.getTermNo().longValue()));
                        judgeTermV308.setChecked(Boolean.valueOf(false));
                        judgeTermV308.setTermObtainScore(term.getScore() == null ? null : Double.valueOf(0.0));
                        judgeTermV308.setTermScore(term.getScore() == null ? null : Double.valueOf(term.getScore().doubleValue()));
                        return judgeTermV308;
                    }).collect(Collectors.toList());
                    selfJudgeTermV308List.addAll(judgeTermV308s);
                }
                if (CollectionUtils.isNotEmpty(selfJudgeList) && CollectionUtils.isNotEmpty(selfJudgeTermV308List)) {
                    Object cid2;
                    ((MicroCompanyHsePreventionControlSelfJudgeMapper)this.dao).insertBatchList(selfJudgeList);
                    List termList = ListUtil.partition(selfJudgeTermV308List, (int)700);
                    cid2 = termList.iterator();
                    while (cid2.hasNext()) {
                        List microOccupationalSelfJudgeTermV308s = (List)cid2.next();
                        this.microOccupationalSelfJudgeTermV308Service.addBatch(microOccupationalSelfJudgeTermV308s);
                    }
                    List reportInfoCidList = selfJudgeList.stream().filter(s -> ObjectUtil.isNotNull((Object)s.getCid())).map(MicroCompanyHsePreventionControlSelfJudge::getCid).distinct().collect(Collectors.toList());
                    this.microCompanySelfInspectionRiskAssessmentReportInfoService.addThisYearSelfInspectionRiskAssessmentReport(reportInfoCidList, null);
                }
                if (CollectionUtils.isNotEmpty(yearList = cidLongs.stream().filter(cid -> !changeCidList.contains(cid)).collect(Collectors.toList()))) {
                    this.updateFirstSelf(yearList, resultsVoMap);
                }
                ArrayList<Long> changeCompanyIdList = new ArrayList<Long>(cidLongs);
                changeCompanyIdList.removeAll(yearList);
                if (CollectionUtils.isNotEmpty(changeCompanyIdList)) {
                    this.updateChangeSelf(changeCompanyIdList, resultsVoMap);
                }
                if (status != null) {
                    this.transactionManager.commit(status);
                    this.logger.info("\u4e8b\u52a1\u63d0\u4ea4");
                }
                XxlJobHelper.log((String)"\u5df2\u7ecf\u5904\u7406\u5b8c\u6210\uff1a{}", (Object[])new Object[]{cidLongs.size()});
                this.microCompanyGradeV3RefreshService.refreshCompanyGradeByCids(cidLongs, CompanyGradeEventSource.SELFCHECK);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.error("\u5237\u65b0\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25\uff1a{},{}", (Object)e.getMessage(), (Object)cidLongs);
                if (status != null) {
                    this.transactionManager.rollback(status);
                    this.logger.info("\u4e8b\u52a1\u56de\u6eda");
                }
                throw new Exception(e.getMessage());
            }
        }
        return cidList.size();
    }

    public boolean isBest(Long cid) {
        Boolean best = ((MicroCompanyHsePreventionControlSelfJudgeMapper)this.dao).isBest(cid);
        this.logger.info("cid:{},isBest:{}", (Object)cid, (Object)best);
        if (!Objects.isNull(best)) {
            return best;
        }
        return false;
    }

    public void updateFirstSelf(List<Long> yearList, Map<Long, Map<Long, MicroSelfJudgeTermResultsVo>> resultsVoMap) {
        List<MicroCompanyHsePreventionControlSelfJudge> microCompanyHsePreventionControlSelfJudges = ((MicroCompanyHsePreventionControlSelfJudgeMapper)this.dao).selectFlushCid(null, yearList);
        if (CollectionUtils.isNotEmpty(microCompanyHsePreventionControlSelfJudges)) {
            Map<Long, MicroCompanyHsePreventionControlSelfJudge> selfJudgeCidMap = microCompanyHsePreventionControlSelfJudges.stream().collect(Collectors.toMap(MicroCompanyHsePreventionControlSelfJudge::getCid, m -> m, (m1, m2) -> m1));
            List<Long> selfJudgeIdList = microCompanyHsePreventionControlSelfJudges.stream().map(MicroCompanyHsePreventionControlSelfJudge::getId).distinct().collect(Collectors.toList());
            ArrayList<Long> flushList = new ArrayList<Long>(selfJudgeCidMap.keySet());
            List<MicroOccupationalSelfJudgeTermV308> judgeTermV308s = ((MicroCompanyHsePreventionControlSelfJudgeMapper)this.dao).selectTermByJudgeIdList(selfJudgeIdList);
            Map<Long, List<MicroOccupationalSelfJudgeTermV308>> judgeTermV308Map = judgeTermV308s.stream().collect(Collectors.groupingBy(MicroOccupationalSelfJudgeTermV308::getSelfId));
            ArrayList<MicroOccupationalSelfJudgeTermV308> updateJudgeTermV308List = new ArrayList<MicroOccupationalSelfJudgeTermV308>();
            ArrayList<MicroCompanyHsePreventionControlSelfJudge> updateSelfJudgeList = new ArrayList<MicroCompanyHsePreventionControlSelfJudge>();
            ArrayList<WorkOperateLog> addWorkOperateLogList = new ArrayList<WorkOperateLog>();
            ArrayList<MicroOccupationalSelfJudgeTermV308> addChangeTermList = new ArrayList<MicroOccupationalSelfJudgeTermV308>();
            ArrayList<MicroCompanyHsePreventionControlSelfJudge> addChangeSelfList = new ArrayList<MicroCompanyHsePreventionControlSelfJudge>();
            for (Long cid : flushList) {
                Integer checkResultOld;
                Integer checkResult;
                MicroSelfJudgeTermResultsVo microSelfJudgeTermResultsVo;
                Map<Long, MicroSelfJudgeTermResultsVo> resultsVoMap1;
                Long termNo;
                AtomicReference<Double> termObtainScore;
                AtomicReference<Double> totalScore;
                Date date = new Date();
                MicroCompanyHsePreventionControlSelfJudge selfJudge = selfJudgeCidMap.get(cid);
                List<MicroOccupationalSelfJudgeTermV308> judgeTermV308List = judgeTermV308Map.get(selfJudge.getId());
                Boolean falg = false;
                Boolean falgLog = false;
                if (selfJudge.getStatus() == 1) {
                    falg = true;
                    falgLog = true;
                    selfJudge.setSelfTime(date);
                    selfJudge.setUpdateDate(date);
                    selfJudge.setPhoneNumber("-");
                    selfJudge.setSelfStaffName("\u7cfb\u7edf\u81ea\u52a8");
                    selfJudge.setReportSignStaff("\u7cfb\u7edf\u81ea\u52a8");
                    selfJudge.setStatus(Byte.valueOf((byte)2));
                    selfJudge.setReportDate(date);
                    totalScore = new AtomicReference<Double>(0.0);
                    termObtainScore = new AtomicReference<Double>(0.0);
                    for (MicroOccupationalSelfJudgeTermV308 judgeTermV308 : judgeTermV308List) {
                        judgeTermV308.setUpdateDate(date);
                        judgeTermV308.setUpdateBy(Long.valueOf(0L));
                        judgeTermV308.setChecked(Boolean.valueOf(true));
                        judgeTermV308.setTermUniformity(Byte.valueOf((byte)1));
                        termNo = judgeTermV308.getTermNo();
                        resultsVoMap1 = resultsVoMap.get(termNo);
                        microSelfJudgeTermResultsVo = resultsVoMap1.get(cid);
                        checkResult = microSelfJudgeTermResultsVo.getCheckResult();
                        checkResultOld = (int)judgeTermV308.getCheckResult();
                        if (!checkResultOld.equals(checkResult)) {
                            if (checkResult == 4) {
                                judgeTermV308.setTermObtainScore(Double.valueOf(0.0));
                            } else if (checkResult == 3) {
                                judgeTermV308.setTermObtainScore(Double.valueOf(0.0));
                            } else if (checkResult == 2) {
                                if (judgeTermV308.getTermScore() != null) {
                                    judgeTermV308.setTermObtainScore(Double.valueOf(judgeTermV308.getTermScore() / 2.0));
                                }
                            } else if (checkResult == 1) {
                                judgeTermV308.setTermObtainScore(judgeTermV308.getTermScore());
                            }
                            judgeTermV308.setCheckResult(Byte.valueOf(checkResult.byteValue()));
                            falg = true;
                        }
                        updateJudgeTermV308List.add(judgeTermV308);
                        if (checkResult == 4) continue;
                        totalScore.updateAndGet(v -> v + (judgeTermV308.getTermScore() == null ? 0.0 : judgeTermV308.getTermScore()));
                        termObtainScore.updateAndGet(v -> v + (judgeTermV308.getTermObtainScore() == null ? 0.0 : judgeTermV308.getTermObtainScore()));
                    }
                    if (totalScore.get() == 0.0 || termObtainScore.get() == 0.0) {
                        selfJudge.setTotalScore("0.0");
                    } else {
                        selfJudge.setTotalScore(new BigDecimal(termObtainScore.get() * 100.0 / totalScore.get()).setScale(1, 4).toString());
                    }
                    if (this.isBest(cid)) {
                        selfJudge.setJudgeLevel(Long.valueOf(1L));
                    } else {
                        selfJudge.setJudgeLevel(Long.valueOf(MicroJudgeResultLevelEnum.getThisEnumByScore((Double)(StringUtils.isNumber((String)selfJudge.getTotalScore()) ? Double.valueOf(selfJudge.getTotalScore()) : 0.0)).getCode().longValue()));
                    }
                }
                if (selfJudge.getStatus() == 2) {
                    totalScore = new AtomicReference<Double>(0.0);
                    termObtainScore = new AtomicReference<Double>(0.0);
                    for (MicroOccupationalSelfJudgeTermV308 judgeTermV308 : judgeTermV308List) {
                        termNo = judgeTermV308.getTermNo();
                        resultsVoMap1 = resultsVoMap.get(termNo);
                        microSelfJudgeTermResultsVo = resultsVoMap1.get(cid);
                        checkResult = microSelfJudgeTermResultsVo.getCheckResult();
                        checkResultOld = (int)judgeTermV308.getCheckResult();
                        if (!checkResultOld.equals(checkResult)) {
                            if (checkResult == 4) {
                                judgeTermV308.setTermObtainScore(Double.valueOf(0.0));
                            } else if (checkResult == 3) {
                                judgeTermV308.setTermObtainScore(Double.valueOf(0.0));
                            } else if (checkResult == 2) {
                                if (judgeTermV308.getTermScore() != null) {
                                    judgeTermV308.setTermObtainScore(Double.valueOf(judgeTermV308.getTermScore() / 2.0));
                                }
                            } else if (checkResult == 1) {
                                judgeTermV308.setTermObtainScore(judgeTermV308.getTermScore());
                            }
                            judgeTermV308.setCheckResult(Byte.valueOf(checkResult.byteValue()));
                            falg = true;
                            judgeTermV308.setUpdateDate(date);
                            judgeTermV308.setUpdateBy(Long.valueOf(0L));
                            updateJudgeTermV308List.add(judgeTermV308);
                        }
                        if (checkResult == 4) continue;
                        totalScore.updateAndGet(v -> v + (judgeTermV308.getTermScore() == null ? 0.0 : judgeTermV308.getTermScore()));
                        termObtainScore.updateAndGet(v -> v + (judgeTermV308.getTermObtainScore() == null ? 0.0 : judgeTermV308.getTermObtainScore()));
                    }
                    if (falg.booleanValue()) {
                        selfJudge.setUpdateDate(date);
                        if (totalScore.get() == 0.0 || termObtainScore.get() == 0.0) {
                            selfJudge.setTotalScore("0.0");
                        } else {
                            selfJudge.setTotalScore(new BigDecimal(termObtainScore.get() * 100.0 / totalScore.get()).setScale(1, 4).toString());
                        }
                        if (this.isBest(cid)) {
                            selfJudge.setJudgeLevel(Long.valueOf(1L));
                        } else {
                            selfJudge.setJudgeLevel(Long.valueOf(MicroJudgeResultLevelEnum.getThisEnumByScore((Double)(StringUtils.isNumber((String)selfJudge.getTotalScore()) ? Double.valueOf(selfJudge.getTotalScore()) : 0.0)).getCode().longValue()));
                        }
                    }
                }
                if (selfJudge.getStatus() == 4) {
                    this.decideIsChange(judgeTermV308List, resultsVoMap, cid, selfJudge, addChangeSelfList, addChangeTermList);
                }
                if (selfJudge.getStatus() == 3) {
                    totalScore = new AtomicReference<Double>(0.0);
                    termObtainScore = new AtomicReference<Double>(0.0);
                    for (MicroOccupationalSelfJudgeTermV308 judgeTermV308 : judgeTermV308List) {
                        termNo = judgeTermV308.getTermNo();
                        resultsVoMap1 = resultsVoMap.get(termNo);
                        microSelfJudgeTermResultsVo = resultsVoMap1.get(cid);
                        checkResult = microSelfJudgeTermResultsVo.getCheckResult();
                        checkResultOld = (int)judgeTermV308.getCheckResult();
                        if (!checkResultOld.equals(checkResult)) {
                            if (checkResult == 4) {
                                judgeTermV308.setTermObtainScore(Double.valueOf(0.0));
                            } else if (checkResult == 3) {
                                judgeTermV308.setTermObtainScore(Double.valueOf(0.0));
                            } else if (checkResult == 2) {
                                if (judgeTermV308.getTermScore() != null) {
                                    judgeTermV308.setTermObtainScore(Double.valueOf(judgeTermV308.getTermScore() / 2.0));
                                }
                            } else if (checkResult == 1) {
                                judgeTermV308.setTermObtainScore(judgeTermV308.getTermScore());
                            }
                            judgeTermV308.setCheckResult(Byte.valueOf(checkResult.byteValue()));
                            falg = true;
                            judgeTermV308.setUpdateDate(date);
                            judgeTermV308.setUpdateBy(Long.valueOf(0L));
                            updateJudgeTermV308List.add(judgeTermV308);
                        }
                        if (checkResult == 4) continue;
                        totalScore.updateAndGet(v -> v + (judgeTermV308.getTermScore() == null ? 0.0 : judgeTermV308.getTermScore()));
                        termObtainScore.updateAndGet(v -> v + (judgeTermV308.getTermObtainScore() == null ? 0.0 : judgeTermV308.getTermObtainScore()));
                    }
                    if (falg.booleanValue()) {
                        selfJudge.setUpdateDate(date);
                        if (totalScore.get() == 0.0 || termObtainScore.get() == 0.0) {
                            selfJudge.setTotalScore("0.0");
                        } else {
                            selfJudge.setTotalScore(new BigDecimal(termObtainScore.get() * 100.0 / totalScore.get()).setScale(1, 4).toString());
                        }
                        if (this.isBest(cid)) {
                            selfJudge.setJudgeLevel(Long.valueOf(1L));
                        } else {
                            selfJudge.setJudgeLevel(Long.valueOf(MicroJudgeResultLevelEnum.getThisEnumByScore((Double)(StringUtils.isNumber((String)selfJudge.getTotalScore()) ? Double.valueOf(selfJudge.getTotalScore()) : 0.0)).getCode().longValue()));
                        }
                    }
                }
                if (!falg.booleanValue()) continue;
                updateSelfJudgeList.add(selfJudge);
                if (!falgLog.booleanValue()) continue;
                WorkOperateLog log = new WorkOperateLog(Long.valueOf(this.idworker.nextId()), WorkOperateLogEnum.investigationRiskAssessment.getTypeVal(), selfJudge.getId(), WorkOperateLogStatusEnum.report.getVal(), "\u7cfb\u7edf\u751f\u6210", date, "\u7cfb\u7edf\u81ea\u52a8", null, date, null, "\u7cfb\u7edf");
                log.setIsValid(Boolean.valueOf(true));
                addWorkOperateLogList.add(log);
            }
            this.createChangeReport(addChangeSelfList, addChangeTermList, addWorkOperateLogList);
            if (CollectionUtils.isNotEmpty(addWorkOperateLogList)) {
                this.workOperateLogService.reportBacth(addWorkOperateLogList);
            }
            this.microOccupationalSelfJudgeTermV308Service.updateBatch(updateJudgeTermV308List);
            if (CollectionUtils.isNotEmpty(updateSelfJudgeList)) {
                this.batchUpdateOrInsert(updateSelfJudgeList, MicroCompanyHsePreventionControlSelfJudgeMapper.class, (item, mapper) -> mapper.updateByPrimaryKeySelective(item));
            }
        }
    }

    public void updateChangeSelf(List<Long> yearList, Map<Long, Map<Long, MicroSelfJudgeTermResultsVo>> resultsVoMap) {
        List<MicroCompanyHsePreventionControlSelfJudge> changeYearSelfJudgeByCidList = this.getChangeYearSelfJudgeByCidList(null, yearList);
        Map<Long, List> changeSelfJudgeMap = changeYearSelfJudgeByCidList.stream().filter(Objects::nonNull).collect(Collectors.groupingBy(MicroCompanyHsePreventionControlSelfJudge::getCid, Collectors.collectingAndThen(Collectors.toList(), entityList -> entityList.stream().sorted((e1, e2) -> {
            if (e1.getReportDate() == null && e2.getReportDate() == null) {
                return 0;
            }
            if (e1.getReportDate() == null) {
                return 1;
            }
            if (e2.getReportDate() == null) {
                return -1;
            }
            return e2.getReportDate().compareTo(e1.getReportDate());
        }).limit(2L).collect(Collectors.toList()))));
        ArrayList<Long> changeCidList = new ArrayList<Long>(changeSelfJudgeMap.keySet());
        if (CollectionUtils.isNotEmpty(changeCidList)) {
            List<Long> changeSelfJudgeIds = changeSelfJudgeMap.values().stream().flatMap(Collection::stream).map(MicroCompanyHsePreventionControlSelfJudge::getId).collect(Collectors.toList());
            List<MicroOccupationalSelfJudgeTermV308> judgeTermV308s = ((MicroCompanyHsePreventionControlSelfJudgeMapper)this.dao).selectTermByJudgeIdList(changeSelfJudgeIds);
            Map<Long, List<MicroOccupationalSelfJudgeTermV308>> judgeTermV308Map = judgeTermV308s.stream().collect(Collectors.groupingBy(MicroOccupationalSelfJudgeTermV308::getSelfId));
            ArrayList<MicroOccupationalSelfJudgeTermV308> updateJudgeTermV308List = new ArrayList<MicroOccupationalSelfJudgeTermV308>();
            ArrayList<MicroCompanyHsePreventionControlSelfJudge> updateSelfJudgeList = new ArrayList<MicroCompanyHsePreventionControlSelfJudge>();
            ArrayList<WorkOperateLog> addWorkOperateLogList = new ArrayList<WorkOperateLog>();
            ArrayList<MicroOccupationalSelfJudgeTermV308> addChangeTermList = new ArrayList<MicroOccupationalSelfJudgeTermV308>();
            ArrayList<MicroCompanyHsePreventionControlSelfJudge> addChangeSelfList = new ArrayList<MicroCompanyHsePreventionControlSelfJudge>();
            for (Long changeCid : changeCidList) {
                Date date = new Date();
                Boolean falg = false;
                Boolean falgLog = false;
                List microCompanyHsePreventionControlSelfJudges = changeSelfJudgeMap.get(changeCid);
                if (!CollectionUtils.isNotEmpty((Collection)microCompanyHsePreventionControlSelfJudges)) continue;
                MicroCompanyHsePreventionControlSelfJudge selfJudge = (MicroCompanyHsePreventionControlSelfJudge)microCompanyHsePreventionControlSelfJudges.get(0);
                List<MicroOccupationalSelfJudgeTermV308> judgeTermV308List = judgeTermV308Map.get(selfJudge.getId());
                if (selfJudge.getStatus() == 2 || selfJudge.getStatus() == 1) {
                    totalScore = new AtomicReference<Double>(0.0);
                    termObtainScore = new AtomicReference<Double>(0.0);
                    for (MicroOccupationalSelfJudgeTermV308 judgeTermV308 : judgeTermV308List) {
                        termNo = judgeTermV308.getTermNo();
                        resultsVoMap1 = resultsVoMap.get(termNo);
                        microSelfJudgeTermResultsVo = resultsVoMap1.get(changeCid);
                        checkResult = microSelfJudgeTermResultsVo.getCheckResult();
                        checkResultOld = (int)judgeTermV308.getCheckResult();
                        if (!checkResultOld.equals(checkResult)) {
                            if (checkResult == 4) {
                                judgeTermV308.setTermObtainScore(Double.valueOf(0.0));
                            } else if (checkResult == 3) {
                                judgeTermV308.setTermObtainScore(Double.valueOf(0.0));
                            } else if (checkResult == 2) {
                                if (judgeTermV308.getTermScore() != null) {
                                    judgeTermV308.setTermObtainScore(Double.valueOf(judgeTermV308.getTermScore() / 2.0));
                                }
                            } else if (checkResult == 1) {
                                judgeTermV308.setTermObtainScore(judgeTermV308.getTermScore());
                            }
                            judgeTermV308.setCheckResult(Byte.valueOf(checkResult.byteValue()));
                            falg = true;
                            judgeTermV308.setUpdateDate(date);
                            judgeTermV308.setUpdateBy(Long.valueOf(0L));
                            updateJudgeTermV308List.add(judgeTermV308);
                        }
                        if (checkResult == 4) continue;
                        totalScore.updateAndGet(v -> v + (judgeTermV308.getTermScore() == null ? 0.0 : judgeTermV308.getTermScore()));
                        termObtainScore.updateAndGet(v -> v + (judgeTermV308.getTermObtainScore() == null ? 0.0 : judgeTermV308.getTermObtainScore()));
                    }
                    if (falg.booleanValue()) {
                        selfJudge.setUpdateDate(date);
                        if (totalScore.get() == 0.0 || termObtainScore.get() == 0.0) {
                            selfJudge.setTotalScore("0.0");
                        } else {
                            selfJudge.setTotalScore(new BigDecimal(termObtainScore.get() * 100.0 / totalScore.get()).setScale(1, 4).toString());
                        }
                        if (this.isBest(changeCid)) {
                            selfJudge.setJudgeLevel(Long.valueOf(1L));
                        } else {
                            selfJudge.setJudgeLevel(Long.valueOf(MicroJudgeResultLevelEnum.getThisEnumByScore((Double)(StringUtils.isNumber((String)selfJudge.getTotalScore()) ? Double.valueOf(selfJudge.getTotalScore()) : 0.0)).getCode().longValue()));
                        }
                    }
                } else if (selfJudge.getStatus() == 4) {
                    this.decideIsChange(judgeTermV308List, resultsVoMap, changeCid, selfJudge, addChangeSelfList, addChangeTermList);
                } else if (selfJudge.getStatus() == 3) {
                    totalScore = new AtomicReference<Double>(0.0);
                    termObtainScore = new AtomicReference<Double>(0.0);
                    for (MicroOccupationalSelfJudgeTermV308 judgeTermV308 : judgeTermV308List) {
                        termNo = judgeTermV308.getTermNo();
                        resultsVoMap1 = resultsVoMap.get(termNo);
                        microSelfJudgeTermResultsVo = resultsVoMap1.get(changeCid);
                        checkResult = microSelfJudgeTermResultsVo.getCheckResult();
                        checkResultOld = (int)judgeTermV308.getCheckResult();
                        if (!checkResultOld.equals(checkResult)) {
                            if (checkResult == 4) {
                                judgeTermV308.setTermObtainScore(Double.valueOf(0.0));
                            } else if (checkResult == 3) {
                                judgeTermV308.setTermObtainScore(Double.valueOf(0.0));
                            } else if (checkResult == 2) {
                                if (judgeTermV308.getTermScore() != null) {
                                    judgeTermV308.setTermObtainScore(Double.valueOf(judgeTermV308.getTermScore() / 2.0));
                                }
                            } else if (checkResult == 1) {
                                judgeTermV308.setTermObtainScore(judgeTermV308.getTermScore());
                            }
                            judgeTermV308.setCheckResult(Byte.valueOf(checkResult.byteValue()));
                            falg = true;
                            judgeTermV308.setUpdateDate(date);
                            judgeTermV308.setUpdateBy(Long.valueOf(0L));
                            updateJudgeTermV308List.add(judgeTermV308);
                        }
                        if (checkResult == 4) continue;
                        totalScore.updateAndGet(v -> v + (judgeTermV308.getTermScore() == null ? 0.0 : judgeTermV308.getTermScore()));
                        termObtainScore.updateAndGet(v -> v + (judgeTermV308.getTermObtainScore() == null ? 0.0 : judgeTermV308.getTermObtainScore()));
                    }
                    if (falg.booleanValue()) {
                        selfJudge.setUpdateDate(date);
                        if (totalScore.get() == 0.0 || termObtainScore.get() == 0.0) {
                            selfJudge.setTotalScore("0.0");
                        } else {
                            selfJudge.setTotalScore(new BigDecimal(termObtainScore.get() * 100.0 / totalScore.get()).setScale(1, 4).toString());
                        }
                        if (this.isBest(changeCid)) {
                            selfJudge.setJudgeLevel(Long.valueOf(1L));
                        } else {
                            selfJudge.setJudgeLevel(Long.valueOf(MicroJudgeResultLevelEnum.getThisEnumByScore((Double)(StringUtils.isNumber((String)selfJudge.getTotalScore()) ? Double.valueOf(selfJudge.getTotalScore()) : 0.0)).getCode().longValue()));
                        }
                    }
                }
                if (!falg.booleanValue()) continue;
                updateSelfJudgeList.add(selfJudge);
                if (!falgLog.booleanValue()) continue;
                WorkOperateLog log = new WorkOperateLog(Long.valueOf(this.idworker.nextId()), WorkOperateLogEnum.investigationRiskAssessment.getTypeVal(), selfJudge.getId(), WorkOperateLogStatusEnum.report.getVal(), "\u7cfb\u7edf\u751f\u6210", date, "\u7cfb\u7edf\u81ea\u52a8", null, date, null, "\u7cfb\u7edf");
                log.setIsValid(Boolean.valueOf(true));
                addWorkOperateLogList.add(log);
            }
            this.createChangeReport(addChangeSelfList, addChangeTermList, addWorkOperateLogList);
            if (CollectionUtils.isNotEmpty(addWorkOperateLogList)) {
                this.workOperateLogService.reportBacth(addWorkOperateLogList);
            }
            this.microOccupationalSelfJudgeTermV308Service.updateBatch(updateJudgeTermV308List);
            if (CollectionUtils.isNotEmpty(updateSelfJudgeList)) {
                this.batchUpdateOrInsert(updateSelfJudgeList, MicroCompanyHsePreventionControlSelfJudgeMapper.class, (item, mapper) -> mapper.updateByPrimaryKeySelective(item));
            }
        }
    }

    private void processedCompanyInfo(MicroCompanySelfInspectionRiskAssessmentReportInfo reportInfo, Long userId) {
        this.companyProvideBySuperviseService.updateAreaIdBycid(reportInfo.getCid(), reportInfo.getLocationAddAreaId(), userId);
        CompanyBaseInfoModel baseInfoModel = new CompanyBaseInfoModel();
        baseInfoModel.setId(reportInfo.getCid());
        baseInfoModel.setName(reportInfo.getCompanyName());
        baseInfoModel.setRegisterAddress(reportInfo.getRegisterAddDetail());
        baseInfoModel.setWorkAddress(reportInfo.getLocationAddDetail());
        if (reportInfo.getCompanyScale() != null) {
            baseInfoModel.setScale("" + reportInfo.getCompanyScale());
        }
        baseInfoModel.setIndustryCategory(reportInfo.getIndustryClassification());
        baseInfoModel.setRegisterType(reportInfo.getEconomicType());
        baseInfoModel.setLegalTel(reportInfo.getContactNumber());
        baseInfoModel.setAreaId(reportInfo.getLocationAddAreaId());
        if (reportInfo != null && reportInfo.getStaffCount() != null) {
            baseInfoModel.setStaffCount(Integer.valueOf(Math.toIntExact(reportInfo.getStaffCount())));
        }
        this.companyProvideByHSEService.updateCompanyBaseInfoModel(baseInfoModel, userId);
        CompanyReportInfo companyReportInfo = new CompanyReportInfo();
        BeanUtils.copyProperties((Object)reportInfo, (Object)companyReportInfo);
        companyReportInfo.setId(null);
        this.companyReportInfoService.addCompanyReportInfo(companyReportInfo, userId, reportInfo.getCid(), null);
    }

    private Boolean decideIsSubmit(MicroCompanySelfInspectionRiskAssessmentReportInfo reportInfo, MicroCompanyHsePreventionControlSelfJudge selfJudge) {
        Integer isFangSheRiskInfoComplete;
        if (ObjectUtil.isNull((Object)reportInfo) || ObjectUtil.isNull((Object)selfJudge)) {
            return Boolean.FALSE;
        }
        MicroCompanyRiskExposeEvaluate riskExposeEvaluate = null;
        String changeReason = reportInfo.getChangeReason();
        if (reportInfo.getStatus() != null && reportInfo.getStatus() == 2) {
            if (StringUtils.isNotEmpty((String)changeReason) && changeReason.contains("1")) {
                riskExposeEvaluate = this.riskExposeEvaluateService.getLatestNeedReportEv(reportInfo.getCid());
                if (ObjectUtil.isNull((Object)riskExposeEvaluate)) {
                    return Boolean.FALSE;
                }
            } else {
                MicroCompanySelfInspectionRiskAssessmentReportInfo beforeReport;
                Long exposureReportId = reportInfo.getExposureReportId();
                if (exposureReportId == null && reportInfo.getChangeFromId() != null && (beforeReport = (MicroCompanySelfInspectionRiskAssessmentReportInfo)this.microCompanySelfInspectionRiskAssessmentReportInfoService.getById(reportInfo.getChangeFromId())) != null) {
                    reportInfo.setExposureReportId(beforeReport.getExposureReportId());
                    reportInfo.setExposureReportOldId(beforeReport.getExposureReportId());
                }
                if (reportInfo.getExposureReportId() != null) {
                    riskExposeEvaluate = (MicroCompanyRiskExposeEvaluate)this.riskExposeEvaluateService.getById((Serializable)reportInfo.getExposureReportId());
                    if (ObjectUtil.isNull((Object)riskExposeEvaluate)) {
                        return Boolean.FALSE;
                    }
                } else {
                    return Boolean.FALSE;
                }
            }
        }
        if (ObjectUtil.isNull((Object)(isFangSheRiskInfoComplete = this.riskExposeEvaluateService.getIsFangSheRiskInfoComplete(riskExposeEvaluate.getId(), reportInfo.getCid())))) {
            return Boolean.FALSE;
        }
        List<Integer> list = Arrays.asList(-1, 0, 1, 2);
        if (list.contains(isFangSheRiskInfoComplete)) {
            return Boolean.FALSE;
        }
        if (reportInfo.getStatus() != 2) {
            return Boolean.FALSE;
        }
        if (ObjectUtil.isNotNull((Object)selfJudge.getStatus()) && (selfJudge.getStatus() == 2 || selfJudge.getStatus() == 4) && ObjectUtil.isNotNull((Object)riskExposeEvaluate.getReportStatus()) && (riskExposeEvaluate.getReportStatus() == 2 || riskExposeEvaluate.getReportStatus() == 4)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void createChangeReport(List<MicroCompanyHsePreventionControlSelfJudge> addChangeSelfList, List<MicroOccupationalSelfJudgeTermV308> addChangeTermList, List<WorkOperateLog> addWorkOperateLogList) {
        List changeCids;
        Integer thisYear = DateUtils.getThisYear();
        if (CollectionUtils.isNotEmpty(addChangeSelfList) && CollectionUtils.isNotEmpty(addChangeTermList) && CollectionUtils.isNotEmpty(changeCids = addChangeSelfList.stream().map(MicroCompanyHsePreventionControlSelfJudge::getCid).distinct().collect(Collectors.toList()))) {
            ArrayList<MicroCompanySelfInspectionRiskAssessmentReportInfo> addReportList = new ArrayList<MicroCompanySelfInspectionRiskAssessmentReportInfo>();
            ArrayList<MicroCompanyHsePreventionControlSelfJudge> addChangeSelfLastList = new ArrayList<MicroCompanyHsePreventionControlSelfJudge>();
            ArrayList addChangeTermLastList = new ArrayList();
            Map<Long, MicroCompanyHsePreventionControlSelfJudge> changeSelfMap = addChangeSelfList.stream().collect(Collectors.toMap(MicroCompanyHsePreventionControlSelfJudge::getCid, r -> r, (r1, r2) -> r1));
            List repostInfoByCids = this.microCompanySelfInspectionRiskAssessmentReportInfoService.getRepostInfoByCids(changeCids);
            Map<Long, List<MicroOccupationalSelfJudgeTermV308>> changeTermMap = addChangeTermList.stream().collect(Collectors.groupingBy(MicroOccupationalSelfJudgeTermV308::getSelfId));
            Map<Long, MicroCompanySelfInspectionRiskAssessmentReportInfo> changeLastReportMap = repostInfoByCids.stream().filter(r -> r.getStatus() == 4 && ObjectUtil.isNull((Object)r.getChildId())).collect(Collectors.toMap(MicroCompanySelfInspectionRiskAssessmentReportInfo::getCid, r -> r, (existing, replacement) -> {
                Date existingTime = existing.getReportDate();
                Date replacementTime = replacement.getReportDate();
                if (existingTime == null && replacementTime == null) {
                    return existing;
                }
                if (existingTime == null) {
                    return replacement;
                }
                if (replacementTime == null) {
                    return existing;
                }
                return replacementTime.after(existingTime) ? replacement : existing;
            }));
            for (Long changeCid : changeCids) {
                Date date = new Date();
                MicroCompanyHsePreventionControlSelfJudge changeSelfJudge = changeSelfMap.get(changeCid);
                MicroCompanySelfInspectionRiskAssessmentReportInfo finishReport = changeLastReportMap.get(changeCid);
                if (ObjectUtil.isNotNull((Object)finishReport)) {
                    MicroCompanySelfInspectionRiskAssessmentReportInfo changeReportInfo = new MicroCompanySelfInspectionRiskAssessmentReportInfo();
                    changeReportInfo.setId(Long.valueOf(this.idworker.nextId()));
                    changeReportInfo.setChangeReason("2");
                    changeReportInfo.setPhoneNumber("-");
                    changeReportInfo.setSelfStaffName("\u7cfb\u7edf\u81ea\u52a8");
                    changeReportInfo.setCid(changeCid);
                    changeReportInfo.setYear(Long.valueOf(thisYear.intValue()));
                    changeReportInfo.setReportFromYear(Byte.valueOf((byte)2));
                    changeReportInfo.setDataSource(Byte.valueOf((byte)1));
                    changeReportInfo.setSelfTime(date);
                    changeReportInfo.setChangeFromId(finishReport.getId());
                    changeReportInfo.setCreateBy(Long.valueOf(0L));
                    changeReportInfo.setCreateDate(date);
                    changeReportInfo.setUpdateBy(Long.valueOf(0L));
                    changeReportInfo.setUpdateDate(date);
                    changeReportInfo.setIsValid(Boolean.valueOf(true));
                    changeReportInfo.setExposureReportId(finishReport.getExposureReportId());
                    changeReportInfo.setExposureReportOldId(finishReport.getExposureReportId());
                    changeReportInfo.setSelfReportOldId(finishReport.getSelfReportId());
                    changeReportInfo.setSelfReportId(changeSelfJudge.getId());
                    String[] includeFields = new String[]{"locationAddAreaId", "companyName", "uniformSocialCreditCode", "registerAddDetail", "locationAddDetail", "companyScale", "industryClassification", "superiorUnit", "economicType", "legalRepresentative", "contactNumber", "manageOrg", "manageMajorStaffCount", "managePluralityStaffCount", "staffCount", "harmStaffCount", "diseaseOnWorkStaffCount", "diseaseStaffCount", "checkGoWorkStaffCount", "checkGoWorkStaffRealCount", "checkOnWorkStaffCount", "checkOnWorkStaffRealCount", "checkLeaveWorkStaffCount", "checkLeaveWorkStaffRealCount"};
                    this.copyReportProperties(finishReport, changeReportInfo);
                    changeReportInfo.setReportDate(date);
                    changeReportInfo.setStatus(Byte.valueOf((byte)2));
                    changeReportInfo.setReportSignStaff("\u7cfb\u7edf\u81ea\u52a8");
                    Boolean submit = this.decideIsSubmit(changeReportInfo, changeSelfJudge);
                    if (submit.booleanValue()) {
                        WorkOperateLog log = new WorkOperateLog(Long.valueOf(this.idworker.nextId()), WorkOperateLogEnum.selfJudge.getTypeVal(), changeReportInfo.getId(), WorkOperateLogStatusEnum.report.getVal(), "\u7cfb\u7edf\u751f\u6210", date, "\u7cfb\u7edf\u81ea\u52a8", null, date, null, "\u7cfb\u7edf");
                        log.setIsValid(Boolean.valueOf(true));
                        addWorkOperateLogList.add(log);
                        addReportList.add(changeReportInfo);
                        WorkOperateLog workOperateLog = new WorkOperateLog(Long.valueOf(this.idworker.nextId()), WorkOperateLogEnum.investigationRiskAssessment.getTypeVal(), changeSelfJudge.getId(), WorkOperateLogStatusEnum.report.getVal(), "\u7cfb\u7edf\u53d8\u66f4", date, "\u7cfb\u7edf\u81ea\u52a8", null, date, null, "\u7cfb\u7edf");
                        workOperateLog.setIsValid(Boolean.valueOf(true));
                        addWorkOperateLogList.add(workOperateLog);
                        addChangeSelfLastList.add(changeSelfJudge);
                        addChangeTermLastList.addAll(changeTermMap.get(changeSelfJudge.getId()));
                        continue;
                    }
                    this.logger.error("\u4f01\u4e1a\u4e0d\u6ee1\u8db3\u53d1\u8d77\u53d8\u66f4\u7efc\u5408\u8bc4\u4f30\u8868\u6761\u4ef6:" + changeCid);
                    continue;
                }
                this.logger.error("\u4f01\u4e1a\u4e0d\u6ee1\u8db3\u53d1\u8d77\u53d8\u66f4\u7efc\u5408\u8bc4\u4f30\u8868\u6761\u4ef6:" + changeCid);
            }
            if (CollectionUtils.isNotEmpty(addReportList) && CollectionUtils.isNotEmpty(addChangeSelfLastList) && CollectionUtils.isNotEmpty(addChangeTermLastList)) {
                ((MicroCompanyHsePreventionControlSelfJudgeMapper)this.dao).insertBatchList(addChangeSelfLastList);
                List termList = ListUtil.partition(addChangeTermLastList, (int)700);
                for (List microOccupationalSelfJudgeTermV308s : termList) {
                    this.microOccupationalSelfJudgeTermV308Service.addBatch(microOccupationalSelfJudgeTermV308s);
                }
                this.microCompanySelfInspectionRiskAssessmentReportInfoService.addBatch(addReportList);
            }
        }
    }

    private void decideIsChange(List<MicroOccupationalSelfJudgeTermV308> judgeTermV308List, Map<Long, Map<Long, MicroSelfJudgeTermResultsVo>> resultsVoMap, Long changeCid, MicroCompanyHsePreventionControlSelfJudge selfJudge, List<MicroCompanyHsePreventionControlSelfJudge> addChangeSelfList, List<MicroOccupationalSelfJudgeTermV308> addChangeTermList) {
        Date date = new Date();
        Integer thisYear = DateUtils.getThisYear();
        AtomicReference<Double> totalScore = new AtomicReference<Double>(0.0);
        AtomicReference<Double> termObtainScore = new AtomicReference<Double>(0.0);
        Boolean isChange = false;
        for (MicroOccupationalSelfJudgeTermV308 judgeTermV308 : judgeTermV308List) {
            Long termNo = judgeTermV308.getTermNo();
            Map<Long, MicroSelfJudgeTermResultsVo> resultsVoMap1 = resultsVoMap.get(termNo);
            MicroSelfJudgeTermResultsVo microSelfJudgeTermResultsVo = resultsVoMap1.get(changeCid);
            Integer checkResult = microSelfJudgeTermResultsVo.getCheckResult();
            Integer checkResultOld = (int)judgeTermV308.getCheckResult();
            if (!checkResultOld.equals(checkResult)) {
                if (checkResult == 4) {
                    judgeTermV308.setTermObtainScore(Double.valueOf(0.0));
                } else if (checkResult == 3) {
                    judgeTermV308.setTermObtainScore(Double.valueOf(0.0));
                } else if (checkResult == 2) {
                    if (judgeTermV308.getTermScore() != null) {
                        judgeTermV308.setTermObtainScore(Double.valueOf(judgeTermV308.getTermScore() / 2.0));
                    }
                } else if (checkResult == 1) {
                    judgeTermV308.setTermObtainScore(judgeTermV308.getTermScore());
                }
                isChange = true;
            }
            if (checkResult == 4) continue;
            totalScore.updateAndGet(v -> v + (judgeTermV308.getTermScore() == null ? 0.0 : judgeTermV308.getTermScore()));
            termObtainScore.updateAndGet(v -> v + (judgeTermV308.getTermObtainScore() == null ? 0.0 : judgeTermV308.getTermObtainScore()));
        }
        if (isChange.booleanValue()) {
            if (totalScore.get() == 0.0 || termObtainScore.get() == 0.0) {
                selfJudge.setTotalScore("0.0");
            } else {
                selfJudge.setTotalScore(new BigDecimal(termObtainScore.get() * 100.0 / totalScore.get()).setScale(1, 4).toString());
            }
            Long oldJudgeLevel = selfJudge.getJudgeLevel();
            Long newJudgeLevel = MicroJudgeResultLevelEnum.getThisEnumByScore((Double)(StringUtils.isNumber((String)selfJudge.getTotalScore()) ? Double.valueOf(selfJudge.getTotalScore()) : 0.0)).getCode().longValue();
            if (this.isBest(changeCid)) {
                newJudgeLevel = 1L;
            }
            if (!oldJudgeLevel.equals(newJudgeLevel)) {
                MicroCompanyHsePreventionControlSelfJudge changeSelfJudge = new MicroCompanyHsePreventionControlSelfJudge();
                changeSelfJudge.setId(Long.valueOf(this.idworker.nextId()));
                changeSelfJudge.setCreateBy(Long.valueOf(0L));
                changeSelfJudge.setCreateDate(date);
                changeSelfJudge.setUpdateBy(Long.valueOf(0L));
                changeSelfJudge.setUpdateDate(date);
                changeSelfJudge.setYear(Long.valueOf(thisYear.intValue()));
                changeSelfJudge.setSelfTime(date);
                changeSelfJudge.setStatus(Byte.valueOf((byte)2));
                changeSelfJudge.setDataSource(Byte.valueOf((byte)1));
                changeSelfJudge.setIsValid(Boolean.valueOf(true));
                changeSelfJudge.setCid(selfJudge.getCid());
                changeSelfJudge.setSelfFromYear(Byte.valueOf((byte)2));
                changeSelfJudge.setPhoneNumber("-");
                changeSelfJudge.setReportDate(date);
                changeSelfJudge.setSelfStaffName("\u7cfb\u7edf\u81ea\u52a8");
                changeSelfJudge.setReportSignStaff("\u7cfb\u7edf\u81ea\u52a8");
                changeSelfJudge.setTotalScore(selfJudge.getTotalScore());
                changeSelfJudge.setJudgeLevel(newJudgeLevel);
                addChangeSelfList.add(changeSelfJudge);
                for (MicroOccupationalSelfJudgeTermV308 microOccupationalSelfJudgeTermV308 : judgeTermV308List) {
                    Long termNo = microOccupationalSelfJudgeTermV308.getTermNo();
                    Map<Long, MicroSelfJudgeTermResultsVo> resultsVoMap1 = resultsVoMap.get(termNo);
                    MicroSelfJudgeTermResultsVo microSelfJudgeTermResultsVo = resultsVoMap1.get(changeCid);
                    MicroOccupationalSelfJudgeTermV308 termV308 = new MicroOccupationalSelfJudgeTermV308();
                    termV308.setSelfId(changeSelfJudge.getId());
                    termV308.setCreateBy(Long.valueOf(0L));
                    termV308.setUpdateBy(Long.valueOf(0L));
                    termV308.setCreateDate(date);
                    termV308.setUpdateDate(date);
                    termV308.setIsValid(Boolean.valueOf(true));
                    termV308.setChecked(Boolean.valueOf(true));
                    termV308.setTermUniformity(Byte.valueOf((byte)1));
                    termV308.setTermNo(microOccupationalSelfJudgeTermV308.getTermNo());
                    termV308.setTermObtainScore(microOccupationalSelfJudgeTermV308.getTermObtainScore() == null ? null : Double.valueOf(0.0));
                    termV308.setTermScore(microOccupationalSelfJudgeTermV308.getTermScore());
                    Integer checkResult = microSelfJudgeTermResultsVo.getCheckResult();
                    if (checkResult == 4) {
                        termV308.setTermObtainScore(Double.valueOf(0.0));
                    } else if (checkResult == 3) {
                        termV308.setTermObtainScore(Double.valueOf(0.0));
                    } else if (checkResult == 2) {
                        if (termV308.getTermScore() != null) {
                            termV308.setTermObtainScore(Double.valueOf(termV308.getTermScore() / 2.0));
                        }
                    } else if (checkResult == 1) {
                        termV308.setTermObtainScore(termV308.getTermScore());
                    }
                    termV308.setCheckResult(Byte.valueOf(checkResult.byteValue()));
                    addChangeTermList.add(termV308);
                }
            }
        }
    }

    private void copyReportProperties(MicroCompanySelfInspectionRiskAssessmentReportInfo finishReport, MicroCompanySelfInspectionRiskAssessmentReportInfo changeReportInfo) {
        changeReportInfo.setLocationAddAreaId(finishReport.getLocationAddAreaId());
        changeReportInfo.setCompanyName(finishReport.getCompanyName());
        changeReportInfo.setUniformSocialCreditCode(finishReport.getUniformSocialCreditCode());
        changeReportInfo.setRegisterAddDetail(finishReport.getRegisterAddDetail());
        changeReportInfo.setLocationAddDetail(finishReport.getLocationAddDetail());
        changeReportInfo.setCompanyScale(finishReport.getCompanyScale());
        changeReportInfo.setIndustryClassification(finishReport.getIndustryClassification());
        changeReportInfo.setSuperiorUnit(finishReport.getSuperiorUnit());
        changeReportInfo.setEconomicType(finishReport.getEconomicType());
        changeReportInfo.setLegalRepresentative(finishReport.getLegalRepresentative());
        changeReportInfo.setContactNumber(finishReport.getContactNumber());
        changeReportInfo.setManageOrg(finishReport.getManageOrg());
        changeReportInfo.setManageMajorStaffCount(finishReport.getManageMajorStaffCount());
        changeReportInfo.setManagePluralityStaffCount(finishReport.getManagePluralityStaffCount());
        changeReportInfo.setStaffCount(finishReport.getStaffCount());
        changeReportInfo.setHarmStaffCount(finishReport.getHarmStaffCount());
        changeReportInfo.setDiseaseOnWorkStaffCount(finishReport.getDiseaseOnWorkStaffCount());
        changeReportInfo.setDiseaseStaffCount(finishReport.getDiseaseStaffCount());
        changeReportInfo.setCheckGoWorkStaffCount(finishReport.getCheckGoWorkStaffCount());
        changeReportInfo.setCheckGoWorkStaffRealCount(finishReport.getCheckGoWorkStaffRealCount());
        changeReportInfo.setCheckOnWorkStaffCount(finishReport.getCheckOnWorkStaffCount());
        changeReportInfo.setCheckOnWorkStaffRealCount(finishReport.getCheckOnWorkStaffRealCount());
        changeReportInfo.setCheckLeaveWorkStaffCount(finishReport.getCheckLeaveWorkStaffCount());
        changeReportInfo.setCheckLeaveWorkStaffRealCount(finishReport.getCheckLeaveWorkStaffRealCount());
    }
}

