/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.selfjudge;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.db.common.entity.BaseEntity;
import cn.smarthse.modules.health.dao.base.selfjudge.MicroCompanySelfInspectionRiskAssessmentReportInfoMapper;
import cn.smarthse.modules.health.entity.base.company.grade.MicroCompanyGradeV3;
import cn.smarthse.modules.health.entity.base.selfjudge.MicroCompanyHsePreventionControlSelfJudge;
import cn.smarthse.modules.health.entity.base.selfjudge.MicroCompanySelfInspectionRiskAssessmentReportInfo;
import cn.smarthse.modules.health.enums.selfjudge.HazardsExposureRiskLevelEnum;
import cn.smarthse.modules.health.enums.selfjudge.HazardsRiskClassifyEnum;
import cn.smarthse.modules.health.enums.selfjudge.JudgeResultLevelEnum;
import cn.smarthse.modules.health.enums.selfjudge.MicroJudgeResultLevelEnum;
import cn.smarthse.modules.health.service.base.selfjudge.IMicroCompanyGradeReportDataService;
import cn.smarthse.modules.health.service.base.selfjudge.IMicroCompanyHsePreventionControlSelfJudgeService;
import cn.smarthse.modules.health.vo.base.company.gradev3.SelfReportCollectVo;
import cn.smarthse.services.hfi.api.entity.riskev.MicroCompanyRiskExposeEvaluate;
import cn.smarthse.services.hfi.api.service.riskev.IMicroCompanyRiskExposeEvaluateService;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;

@DubboService
public class MicroCompanyGradeReportDataServiceImpl
extends BaseServiceImpl<MicroCompanySelfInspectionRiskAssessmentReportInfoMapper, MicroCompanySelfInspectionRiskAssessmentReportInfo>
implements IMicroCompanyGradeReportDataService {
    @DubboReference
    private IMicroCompanyRiskExposeEvaluateService riskExposeEvaluateService;
    @Autowired
    private IMicroCompanyHsePreventionControlSelfJudgeService companyHsePreventionControlSelfJudgeService;
    @Autowired
    private ThreadPoolExecutor executorService;

    public List<SelfReportCollectVo> getSelfReportInfoCollectVoListHasJudgeByRangTimeAndCid(Date beginDate, Date endDate, List<Long> cids) {
        CompletableFuture<List> selfJudgesFutrure = CompletableFuture.supplyAsync(() -> this.companyHsePreventionControlSelfJudgeService.listDataV314EveryCidLatestForSuperviseByDateRange(null, null, cids), this.executorService);
        CompletableFuture<List> riskExposeEvaluateListFutrure = CompletableFuture.supplyAsync(() -> {
            int year = DateUtils.getThisYear() - 3;
            LocalDate of = LocalDate.of(year, 1, 1);
            Date end = DateUtils.addDay((Date)new Date(), (int)1);
            return this.riskExposeEvaluateService.listRiskEvaluateLasted(DateUtil.getDate((LocalDateTime)of.atStartOfDay()), end, cids);
        }, this.executorService);
        CompletableFuture<List> reportInfosFutrure = CompletableFuture.supplyAsync(() -> this.listDataV314EveryCidLatestForSuperviseByDateRange(null, null, cids), this.executorService);
        CompletableFuture.allOf(selfJudgesFutrure, riskExposeEvaluateListFutrure, reportInfosFutrure).join();
        List<MicroCompanyGradeV3> lastCheckedReportGradeLevelList = ((MicroCompanySelfInspectionRiskAssessmentReportInfoMapper)this.dao).listLastCheckedReportGradeLevelInfo(cids);
        List selfJudges = selfJudgesFutrure.get();
        List riskExposeEvaluateList = riskExposeEvaluateListFutrure.get();
        List reportInfos = reportInfosFutrure.get();
        Map<Object, Object> selfJudgeMapTemp = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)selfJudges)) {
            selfJudgeMapTemp = selfJudges.stream().collect(Collectors.toMap(MicroCompanyHsePreventionControlSelfJudge::getId, s -> s));
        }
        Map<Object, Object> riskInfoMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)riskExposeEvaluateList)) {
            riskInfoMap = riskExposeEvaluateList.stream().collect(Collectors.toMap(BaseEntity::getId, s -> s));
        }
        Map<Object, Object> lastCheckedReportGradeLevelMap = new HashMap();
        if (CollectionUtils.isNotEmpty(lastCheckedReportGradeLevelList)) {
            lastCheckedReportGradeLevelMap = lastCheckedReportGradeLevelList.stream().collect(Collectors.toMap(MicroCompanyGradeV3::getCid, s -> s));
        }
        HashMap<Long, SelfReportCollectVo> reportCollectVoMap = new HashMap<Long, SelfReportCollectVo>();
        if (CollectionUtils.isNotEmpty((Collection)selfJudges)) {
            selfJudges.forEach(s -> {
                SelfReportCollectVo vo = reportCollectVoMap.computeIfAbsent(s.getCid(), v -> new SelfReportCollectVo(s.getCid()));
                vo.setSelfId(s.getId());
                if (s.getJudgeLevel() != null) {
                    vo.setJudgeLevel(Integer.valueOf(s.getJudgeLevel().intValue()));
                }
                if (s.getUpdateDate() != null) {
                    vo.setJudgeUpdateDate(s.getUpdateDate());
                }
                if (s.getStatus() != null) {
                    vo.setJudgeCheckState(this.getClassifySuperviseStatus(s.getStatus()));
                }
                if (s.getRealLevel() != null) {
                    vo.setRealJudgelevel(Integer.valueOf(s.getRealLevel().intValue()));
                }
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)riskExposeEvaluateList)) {
            riskExposeEvaluateList.forEach(s -> {
                SelfReportCollectVo vo = reportCollectVoMap.computeIfAbsent(s.getCid(), v -> new SelfReportCollectVo(s.getCid()));
                vo.setRiskId(s.getId());
                if (s.getRiskLevel() != null) {
                    vo.setRiskLevel(s.getRiskLevel());
                }
                if (s.getDataUpdateDate() != null) {
                    vo.setRiskUpdateDate(Date.from(s.getUpdateDate().atZone(ZoneId.systemDefault()).toInstant()));
                }
                if (s.getReportStatus() != null) {
                    vo.setRiskCheckState(this.getClassifySuperviseStatus(s.getReportStatus().byteValue()));
                }
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)reportInfos)) {
            ArrayList<Long> riskIdSet = new ArrayList<Long>();
            ArrayList<Object> selfIdSet = new ArrayList<Object>();
            for (MicroCompanySelfInspectionRiskAssessmentReportInfo reportInfo : reportInfos) {
                Long selfReportId = reportInfo.getSelfReportId();
                Long riskId = reportInfo.getExposureReportId();
                if (!selfJudgeMapTemp.containsKey(selfReportId)) {
                    selfIdSet.add(selfReportId);
                }
                if (!riskInfoMap.containsKey(riskId)) {
                    riskIdSet.add(riskId);
                }
                SelfReportCollectVo vo = reportCollectVoMap.computeIfAbsent(reportInfo.getCid(), v -> new SelfReportCollectVo(reportInfo.getCid()));
                vo.setEvaluateId(reportInfo.getId());
                vo.setEvaluateCheckState(this.getClassifySuperviseStatus(reportInfo.getStatus()));
                vo.setEvaluateUpdateDate(reportInfo.getUpdateDate());
                if (reportInfo.getExposureReportId() != null && reportInfo.getExposureReportOldId() != null && !reportInfo.getExposureReportId().equals(reportInfo.getExposureReportOldId())) {
                    vo.setRiskHasUpdate(Boolean.valueOf(true));
                }
                if (reportInfo.getReportFromYear() != null) {
                    vo.setEvaluateType(Integer.valueOf(reportInfo.getReportFromYear().intValue()));
                }
                vo.setEvaluateChangeReason(reportInfo.getChangeReason());
            }
            Map riskExposeEvaluateMap = this.riskExposeEvaluateService.queryByIds(riskIdSet);
            Map selfJudgeMap = this.companyHsePreventionControlSelfJudgeService.queryByIds(selfIdSet);
            for (MicroCompanySelfInspectionRiskAssessmentReportInfo reportInfo : reportInfos) {
                Long selfReportId = reportInfo.getSelfReportId();
                Long riskId = reportInfo.getExposureReportId();
                SelfReportCollectVo vo = reportCollectVoMap.computeIfAbsent(reportInfo.getCid(), v -> new SelfReportCollectVo(reportInfo.getCid()));
                if (riskExposeEvaluateMap.containsKey(riskId)) {
                    MicroCompanyRiskExposeEvaluate newRisk = (MicroCompanyRiskExposeEvaluate)riskExposeEvaluateMap.get(riskId);
                    vo.setRiskId(newRisk.getId());
                    if (newRisk.getRiskLevel() != null) {
                        vo.setRiskLevel(newRisk.getRiskLevel());
                    }
                    if (newRisk.getDataUpdateDate() != null) {
                        vo.setRiskUpdateDate(Date.from(newRisk.getDataUpdateDate().atZone(ZoneId.systemDefault()).toInstant()));
                    }
                    if (newRisk.getReportStatus() != null) {
                        vo.setRiskCheckState(this.getClassifySuperviseStatus(newRisk.getReportStatus().byteValue()));
                    }
                }
                if (!selfJudgeMap.containsKey(selfReportId)) continue;
                MicroCompanyHsePreventionControlSelfJudge newJudge = (MicroCompanyHsePreventionControlSelfJudge)selfJudgeMap.get(selfReportId);
                vo.setSelfId(newJudge.getId());
                if (newJudge.getJudgeLevel() != null) {
                    vo.setJudgeLevel(Integer.valueOf(newJudge.getJudgeLevel().intValue()));
                }
                if (newJudge.getUpdateDate() != null) {
                    vo.setJudgeUpdateDate(newJudge.getUpdateDate());
                }
                if (newJudge.getStatus() != null) {
                    vo.setJudgeCheckState(this.getClassifySuperviseStatus(newJudge.getStatus()));
                }
                if (newJudge.getRealLevel() == null) continue;
                vo.setRealJudgelevel(Integer.valueOf(newJudge.getRealLevel().intValue()));
            }
        }
        ArrayList selfReportCollectVos = new ArrayList(reportCollectVoMap.values());
        for (SelfReportCollectVo vo : selfReportCollectVos) {
            MicroCompanyGradeV3 lastCheckedLevelInfo;
            if (vo.getJudgeLevel() != null && vo.getRiskLevel() != null) {
                HazardsRiskClassifyEnum riskClassifyEnum = HazardsRiskClassifyEnum.getThisEnumByJudgeLevelAndRiskLevel((MicroJudgeResultLevelEnum)MicroJudgeResultLevelEnum.getThisEnumByCode((Integer)vo.getJudgeLevel()), (HazardsExposureRiskLevelEnum)HazardsExposureRiskLevelEnum.getThisEnumByCode((Integer)vo.getRiskLevel()));
                vo.setGradeLevel(riskClassifyEnum == null ? null : riskClassifyEnum.getCode());
            }
            if ((lastCheckedLevelInfo = (MicroCompanyGradeV3)lastCheckedReportGradeLevelMap.get(vo.getCid())) == null) continue;
            HazardsRiskClassifyEnum riskClassifyEnum = HazardsRiskClassifyEnum.getThisEnumByJudgeLevelAndRiskLevel((JudgeResultLevelEnum)JudgeResultLevelEnum.getThisEnumByCode((Integer)lastCheckedLevelInfo.getJudgeLevel()), (HazardsExposureRiskLevelEnum)HazardsExposureRiskLevelEnum.getThisEnumByCode((Integer)lastCheckedLevelInfo.getRiskLevel()));
            vo.setLastCheckedGradeLevel(riskClassifyEnum == null ? null : riskClassifyEnum.getCode());
        }
        return new ArrayList<SelfReportCollectVo>(reportCollectVoMap.values());
    }

    private Integer getClassifySuperviseStatus(Byte status) {
        if (Byte.valueOf("2").equals(status)) {
            return 0;
        }
        if (Byte.valueOf("3").equals(status) || Byte.valueOf("10").equals(status)) {
            return -1;
        }
        if (Byte.valueOf("4").equals(status)) {
            return 1;
        }
        return null;
    }

    public List<MicroCompanySelfInspectionRiskAssessmentReportInfo> listDataV314EveryCidLatestForSuperviseByDateRange(Date beginDate, Date endDate, List<Long> cids) {
        List<MicroCompanySelfInspectionRiskAssessmentReportInfo> reportInfoList = null;
        reportInfoList = CollectionUtils.isNotEmpty(cids) ? ((MicroCompanySelfInspectionRiskAssessmentReportInfoMapper)this.dao).listDataV314EveryCidLatestForSuperviseByDateRange(beginDate, endDate, cids, 100000) : ((MicroCompanySelfInspectionRiskAssessmentReportInfoMapper)this.dao).listDataV314EveryCidLatestForSuperviseByDateRange(beginDate, endDate, cids, ((MicroCompanySelfInspectionRiskAssessmentReportInfoMapper)this.dao).selectCount(new MicroCompanySelfInspectionRiskAssessmentReportInfo()));
        return reportInfoList;
    }
}

