/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.selfjudge;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.framework.singletask.singleTask;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.health.dao.base.selfjudge.CompanyHsePreventionControlSelfJudgeMapper;
import cn.smarthse.modules.health.entity.base.selfjudge.ClassifySelfExaminationRecord;
import cn.smarthse.modules.health.entity.base.selfjudge.CompanyHseInvestigationRiskAssessmentInfo;
import cn.smarthse.modules.health.entity.base.selfjudge.CompanyHsePreventionControlSelfJudge;
import cn.smarthse.modules.health.entity.base.selfjudge.OccupationalSelfJudgeTermV308;
import cn.smarthse.modules.health.entity.base.selfjudge.SelfInspectionRiskAssessmentReportInfo;
import cn.smarthse.modules.health.entity.base.selfjudge.SelfInspectionTerm;
import cn.smarthse.modules.health.entity.base.selfjudge.vo.CompanyHsePreventionControlSelfJudgeForm;
import cn.smarthse.modules.health.entity.base.selfjudge.vo.CompanyHsePreventionControlSelfJudgeVo;
import cn.smarthse.modules.health.entity.base.selfjudge.vo.CompanyInvestigationAndSelfJudgeStatVo;
import cn.smarthse.modules.health.entity.base.selfjudge.vo.CompanyRiskJudgeV313Vo;
import cn.smarthse.modules.health.entity.base.selfjudge.vo.SelfjudgeSearchVo;
import cn.smarthse.modules.health.entity.work.check.vo.PhcThirdOccupationalDiseaserParamVo;
import cn.smarthse.modules.health.enums.reform.ReformGenerationSourceEnum;
import cn.smarthse.modules.health.enums.reform.ReformSourceLiteEnum;
import cn.smarthse.modules.health.enums.selfjudge.HazardsExposureRiskLevelEnum;
import cn.smarthse.modules.health.enums.selfjudge.HazardsRiskClassifyEnum;
import cn.smarthse.modules.health.enums.selfjudge.JudgeResultLevelEnum;
import cn.smarthse.modules.health.service.base.selfjudge.ICompanyHseInvestigationRiskAssessmentInfoService;
import cn.smarthse.modules.health.service.base.selfjudge.ICompanyHsePreventionControlSelfJudgeService;
import cn.smarthse.modules.health.service.base.selfjudge.IOccupationalSelfJudgeTermV308Service;
import cn.smarthse.modules.health.service.base.selfjudge.ISelfInspectionRiskAssessmentReportInfoService;
import cn.smarthse.modules.health.service.base.selfjudge.ISelfInspectionTermService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckTipService;
import cn.smarthse.modules.health.service.work.harmfactor.IHarmfactorWorkService;
import cn.smarthse.modules.health.service.work.judge.IJudgeEhsClassificationService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicNewService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.supervise.enums.WorkOperateLogEnum;
import cn.smarthse.modules.health.supervise.enums.WorkOperateLogStatusEnum;
import cn.smarthse.modules.health.supervise.service.check.ISupervisePhcPhysicalOdService;
import cn.smarthse.modules.health.supervise.service.company.grade.ICompanyGradeV3RefreshService;
import cn.smarthse.modules.health.supervise.service.company.grade.ICompanyGradeV3Service;
import cn.smarthse.modules.health.supervise.service.operate.IWorkOperateLogService;
import cn.smarthse.modules.health.supervise.service.supervisionlaw.ISupervisionLawService;
import cn.smarthse.modules.health.vo.base.company.gradev3.SelfReportCollectVo;
import cn.smarthse.modules.health.vo.work.judge.ContractInformInfo;
import cn.smarthse.modules.health.vo.work.judge.FunOrganManagerInfo;
import cn.smarthse.modules.health.vo.work.judge.LastHarmFactorTestInfo;
import cn.smarthse.modules.health.vo.work.judge.PhcCheckInfo;
import cn.smarthse.modules.health.vo.work.judge.ShieldSendInfo;
import cn.smarthse.modules.health.vo.work.judge.TrainCertificateInfo;
import cn.smarthse.modules.health.vo.work.reform.ReformAddParam;
import cn.smarthse.snowflake.IdWorker;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class CompanyHsePreventionControlSelfJudgeServiceImpl
extends BaseServiceImpl<CompanyHsePreventionControlSelfJudgeMapper, CompanyHsePreventionControlSelfJudge>
implements ICompanyHsePreventionControlSelfJudgeService {
    @Autowired(required=false)
    private IStaffInfoService staffInfoService;
    @Autowired(required=false)
    private IOccupationalSelfJudgeTermV308Service occupationalSelfJudgeTermV308Service;
    @DubboReference
    private IWorkOperateLogService workOperateLogService;
    @Autowired
    private ICompanyHseInvestigationRiskAssessmentInfoService companyHseInvestigationRiskAssessmentInfoService;
    @Autowired(required=false)
    private IJudgeEhsClassificationService judgeEhsService;
    @Autowired
    private IStaffInfoService staffInfoServcie;
    @Autowired(required=false)
    private ILiteArchiveService liteArchiveService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideByHSEService companyProvideByHSEService;
    @Autowired(required=false)
    private IHarmfactorWorkService harmfactorWorkService;
    @Autowired
    private IPhcPhysicalCheckTipService phcPhysicalCheckTipService;
    @Autowired
    private ISelfInspectionTermService selfInspectionTermService;
    @Autowired
    private ISelfInspectionRiskAssessmentReportInfoService selfInspectionRiskAssessmentReportInfoService;
    @Autowired
    private IReformItemBasicService reformItemBasicService;
    @Autowired
    private IReformItemBasicNewService itemBasicNewService;
    @DubboReference
    private ICompanyGradeV3RefreshService companyGradeV3RefreshService;
    @DubboReference
    private ISupervisionLawService supervisionLawService;
    @DubboReference
    private ISupervisePhcPhysicalOdService supervisePhcPhysicalOdService;
    @DubboReference
    private ICompanyGradeV3Service companyGradeV3Service;
    @Autowired
    protected IdWorker idworker;

    public PageInfo<CompanyHsePreventionControlSelfJudgeVo> listPageData(JqGridParam jqGridParam) {
        PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows());
        List<CompanyHsePreventionControlSelfJudgeVo> list = ((CompanyHsePreventionControlSelfJudgeMapper)this.dao).listData(jqGridParam.getCid());
        list.forEach(s -> {
            if (s.getDataSource() != null && s.getDataSource() == 1 && s.getOperatorStaffId() != null) {
                s.setOperatorStaffName(this.staffInfoService.getStaffNameByStaffId(s.getOperatorStaffId()));
            }
            if (s.getJudgeLevel() != null) {
                JudgeResultLevelEnum judgeResultLevelEnum = JudgeResultLevelEnum.getThisEnumByCode((Integer)s.getJudgeLevel().intValue());
                s.setJudgeLevelName(judgeResultLevelEnum == null ? null : judgeResultLevelEnum.getName());
            }
        });
        return new PageInfo(list);
    }

    public CompanyHsePreventionControlSelfJudgeVo getVoById(Long id) {
        CompanyHsePreventionControlSelfJudgeVo vo = new CompanyHsePreventionControlSelfJudgeVo();
        vo.setSelfJudge((CompanyHsePreventionControlSelfJudge)this.getById(id));
        vo.setTerms(this.occupationalSelfJudgeTermV308Service.getListBySelfId(id));
        if (vo.getSelfJudge() != null && vo.getSelfJudge().getJudgeLevel() != null) {
            JudgeResultLevelEnum judgeResultLevelEnum = JudgeResultLevelEnum.getThisEnumByCode((Integer)vo.getSelfJudge().getJudgeLevel().intValue());
            vo.setJudgeLevelName(judgeResultLevelEnum == null ? null : judgeResultLevelEnum.getName());
        }
        vo.setAbleMissingItemCount(Long.valueOf(0L));
        vo.setRectifyItemCount(Long.valueOf(0L));
        vo.setDisableMissingObtainScore(Double.valueOf(0.0));
        vo.setDisableMissingTotalScore(Double.valueOf(0.0));
        if (vo.getTerms() != null && vo.getTerms().size() > 0) {
            List terms = this.selfInspectionTermService.getListByFlag(Integer.valueOf(1));
            vo.getTerms().stream().forEach(s -> {
                SelfInspectionTerm t;
                if (s.getCheckResult() != null && s.getCheckResult() != 4) {
                    vo.setDisableMissingTotalScore(Double.valueOf(vo.getDisableMissingTotalScore() + (s.getTermScore() == null ? 0.0 : s.getTermScore())));
                    vo.setDisableMissingObtainScore(Double.valueOf(vo.getDisableMissingObtainScore() + (s.getTermObtainScore() == null ? 0.0 : s.getTermObtainScore())));
                }
                if ((t = (SelfInspectionTerm)terms.stream().filter(s1 -> Long.valueOf(s1.getTermNo().intValue()).equals(s.getTermNo())).findFirst().orElse(null)) != null) {
                    s.setTermName(t.getTermName());
                }
            });
            vo.setRectifyItemCount(Long.valueOf(vo.getTerms().stream().filter(s -> s.getCheckResult() != null && (s.getCheckResult() == 2 || s.getCheckResult() == 3) && s.getChecked() != null && s.getChecked() != false).count()));
            vo.setAbleMissingItemCount(Long.valueOf(vo.getTerms().stream().filter(s -> s.getCheckResult() != null && s.getCheckResult() == 4 && s.getChecked() != null && s.getChecked() != false).count()));
            vo.setAbleMissingTerms(vo.getTerms().stream().filter(s -> s.getCheckResult() != null && s.getCheckResult() == 4 && s.getChecked() != null && s.getChecked() != false).collect(Collectors.toList()));
            vo.setRectifyTerms(vo.getTerms().stream().filter(s -> s.getCheckResult() != null && (s.getCheckResult() == 2 || s.getCheckResult() == 3) && s.getChecked() != null && s.getChecked() != false).collect(Collectors.toList()));
        }
        return vo;
    }

    @Transactional(readOnly=false)
    @singleTask(expressions={"form.selfJudge.id"})
    public int savePreventionControlSelfJudgeSubmit(CompanyHsePreventionControlSelfJudgeForm form, Long loginStaffId, Long loginStaffCompanyId) {
        try {
            if (form.getSelfJudge().getIsFirst().booleanValue()) {
                form.getSelfJudge().setSelfTime(new Date());
            }
            form.getSelfJudge().setIsValid(Boolean.valueOf(true));
            boolean isNeedUpdate = true;
            if (form.getSelfJudge().getId() == null) {
                CompanyHsePreventionControlSelfJudge selfJudge = this.add(form.getSelfJudge(), loginStaffId, loginStaffCompanyId);
                form.setSelfJudge(selfJudge);
                isNeedUpdate = false;
            }
            ArrayList items = new ArrayList();
            if (form.getTerms() != null) {
                items.addAll(form.getTerms());
            }
            if (items.size() > 0) {
                OccupationalSelfJudgeTermV308 needTerm = items.stream().filter(s -> s.getIsNeeUpdate()).findFirst().orElse(null);
                if (needTerm != null) {
                    if (Byte.valueOf((byte)4).equals(needTerm.getCheckResult())) {
                        needTerm.setTermObtainScore(Double.valueOf(0.0));
                    } else if (Byte.valueOf((byte)3).equals(needTerm.getCheckResult())) {
                        needTerm.setTermObtainScore(Double.valueOf(0.0));
                    } else if (Byte.valueOf((byte)2).equals(needTerm.getCheckResult())) {
                        if (needTerm.getTermScore() != null) {
                            needTerm.setTermObtainScore(Double.valueOf(needTerm.getTermScore() / 2.0));
                        }
                    } else if (Byte.valueOf((byte)1).equals(needTerm.getCheckResult())) {
                        needTerm.setTermObtainScore(needTerm.getTermScore());
                    }
                    this.occupationalSelfJudgeTermV308Service.updateTermBySelfIdAndTermNo(needTerm, loginStaffId);
                }
                AtomicReference<Boolean> hasKeyTermNoGood = new AtomicReference<Boolean>(false);
                AtomicReference<Double> totalScore = new AtomicReference<Double>(0.0);
                AtomicReference<Double> termObtainScore = new AtomicReference<Double>(0.0);
                items.stream().map(s -> {
                    s.setSelfId(form.getSelfJudge().getId());
                    s.setCreateBy(loginStaffId);
                    s.setCreateDate(new Date());
                    s.setUpdateBy(loginStaffId);
                    s.setUpdateDate(new Date());
                    s.setIsValid(Boolean.valueOf(true));
                    if (s.getTermScore() == null && Byte.valueOf((byte)3).equals(s.getCheckResult())) {
                        hasKeyTermNoGood.set(true);
                    }
                    if (!Byte.valueOf((byte)4).equals(s.getCheckResult())) {
                        totalScore.updateAndGet(v -> v + (s.getTermScore() == null ? 0.0 : s.getTermScore()));
                        termObtainScore.updateAndGet(v -> v + (s.getTermObtainScore() == null ? 0.0 : s.getTermObtainScore()));
                    }
                    return s;
                }).collect(Collectors.toList());
                if (totalScore.get() == 0.0 || termObtainScore.get() == 0.0) {
                    form.getSelfJudge().setTotalScore("0.0");
                } else {
                    form.getSelfJudge().setTotalScore(new BigDecimal(termObtainScore.get() * 100.0 / totalScore.get()).setScale(1, 4).toString());
                }
                if (hasKeyTermNoGood.get().booleanValue()) {
                    form.getSelfJudge().setJudgeLevel(Long.valueOf(3L));
                } else {
                    form.getSelfJudge().setJudgeLevel(Long.valueOf(JudgeResultLevelEnum.getThisEnumByScore((Double)(StringUtils.isNumber((String)form.getSelfJudge().getTotalScore()) ? Double.valueOf(form.getSelfJudge().getTotalScore()) : 0.0)).getCode().longValue()));
                }
            }
            if (isNeedUpdate) {
                Long sourceDataId;
                CompanyHsePreventionControlSelfJudge dbTotalScoreJudge;
                if (form.getSelfJudge().getStatus() != null && form.getSelfJudge().getStatus() == 2 && (dbTotalScoreJudge = ((CompanyHsePreventionControlSelfJudgeMapper)this.dao).getFinalScoreAndJudgeLevelBySelfId(form.getSelfJudge().getId())) != null) {
                    if (this.isBest(loginStaffCompanyId)) {
                        form.getSelfJudge().setJudgeLevel(Long.valueOf(1L));
                    } else {
                        form.getSelfJudge().setJudgeLevel(dbTotalScoreJudge.getJudgeLevel());
                    }
                    form.getSelfJudge().setTotalScore(dbTotalScoreJudge.getTotalScore());
                }
                if ("1".equalsIgnoreCase(form.getSubmitTotal()) && Objects.nonNull(sourceDataId = this.getSourceDataId(form.getSelfJudge().getId(), loginStaffCompanyId))) {
                    List terms = this.occupationalSelfJudgeTermV308Service.getListBySelfId(form.getSelfJudge().getId());
                    List oldTerms = this.occupationalSelfJudgeTermV308Service.getListBySelfId(sourceDataId);
                    CompanyHsePreventionControlSelfJudge sourceData = (CompanyHsePreventionControlSelfJudge)this.getById(sourceDataId);
                    oldTerms.forEach(item -> item.setIsValid(Boolean.valueOf(false)));
                    terms.forEach(item -> {
                        item.setSelfId(sourceDataId);
                        item.setIsValid(Boolean.valueOf(true));
                        item.setUpdateDate(new Date());
                    });
                    sourceData.setId(form.getSelfJudge().getId());
                    sourceData.setCidYear(null);
                    sourceData.setTableFlag(Byte.valueOf((byte)2));
                    sourceData.setIsValid(Boolean.valueOf(false));
                    form.getSelfJudge().setId(sourceDataId);
                    form.getSelfJudge().setCidYear(sourceData.getCidYear());
                    form.getSelfJudge().setTableFlag(Byte.valueOf((byte)0));
                    this.update(sourceData, loginStaffId);
                    this.occupationalSelfJudgeTermV308Service.updateBatch(oldTerms);
                    this.occupationalSelfJudgeTermV308Service.updateBatch(terms);
                }
                this.update(form.getSelfJudge(), loginStaffId);
                if (form.getSelfJudge().getStatus() != null && form.getSelfJudge().getStatus() == 2) {
                    this.workOperateLogService.report(form.getSelfJudge().getId(), WorkOperateLogEnum.investigationRiskAssessment.getTypeVal(), loginStaffId, form.getOperaterName(), form.getCompanyName());
                }
            }
            return 1;
        }
        catch (Exception e) {
            this.logger.info("\u81ea\u67e5\u66f4\u65b0\u62a5\u9519" + e.getMessage());
            return 0;
        }
    }

    public boolean isBest(Long cid) {
        Boolean best = ((CompanyHsePreventionControlSelfJudgeMapper)this.dao).isBest(cid);
        this.logger.info("cid:{},isBest:{}", (Object)cid, (Object)best);
        if (!Objects.isNull(best)) {
            return best;
        }
        return false;
    }

    @Transactional(readOnly=false)
    public void checkAndChangeSelfLevel(String cids, Boolean best) {
        Example example = new Example(CompanyHsePreventionControlSelfJudge.class);
        String[] split = cids.split(",");
        List cidList = Arrays.stream(split).filter(s -> StringUtils.isNumeric((CharSequence)s)).map(s -> {
            s = s.trim();
            return Long.valueOf(s);
        }).collect(Collectors.toList());
        example.createCriteria().andEqualTo("isValid", (Object)Global.TRUE).andIn("cid", cidList);
        List judgeList = ((CompanyHsePreventionControlSelfJudgeMapper)this.dao).selectByExample(example);
        Map<Long, List<CompanyHsePreventionControlSelfJudge>> listMap = judgeList.stream().collect(Collectors.groupingBy(CompanyHsePreventionControlSelfJudge::getCid));
        ArrayList<ClassifySelfExaminationRecord> recordList = new ArrayList<ClassifySelfExaminationRecord>();
        Set<Long> longs = listMap.keySet();
        for (Long cid : longs) {
            for (CompanyHsePreventionControlSelfJudge judge : listMap.get(cid)) {
                ClassifySelfExaminationRecord record;
                CompanyHsePreventionControlSelfJudge dbTotalScoreJudge = ((CompanyHsePreventionControlSelfJudgeMapper)this.dao).getFinalScoreAndJudgeLevelBySelfId(judge.getId());
                if (best.booleanValue()) {
                    judge.setJudgeLevel(Long.valueOf(1L));
                    judge.setRealLevel(dbTotalScoreJudge.getJudgeLevel());
                    record = new ClassifySelfExaminationRecord();
                    record.setCid(judge.getCid());
                    record.setChangeReason("4");
                    record.setChangeTime(new Date());
                    record.setBeforeState(Integer.valueOf(judge.getRealLevel().intValue()));
                    record.setAfterState(Integer.valueOf(judge.getJudgeLevel().intValue()));
                    record.setChangeType(Integer.valueOf(2));
                    record.setSourceId(judge.getId());
                    record.setIsValid(Boolean.valueOf(true));
                    recordList.add(record);
                    continue;
                }
                record = new ClassifySelfExaminationRecord();
                record.setCid(judge.getCid());
                record.setChangeReason("5");
                record.setChangeTime(new Date());
                record.setBeforeState(Integer.valueOf(judge.getJudgeLevel().intValue()));
                record.setAfterState(Integer.valueOf(dbTotalScoreJudge.getJudgeLevel().intValue()));
                record.setChangeType(Integer.valueOf(2));
                record.setSourceId(judge.getId());
                record.setIsValid(Boolean.valueOf(true));
                recordList.add(record);
                judge.setJudgeLevel(dbTotalScoreJudge.getJudgeLevel());
            }
        }
        this.batchUpdateOrInsert(judgeList, CompanyHsePreventionControlSelfJudgeMapper.class, (item, mapper) -> mapper.updateByPrimaryKeySelective(item));
        this.companyGradeV3Service.saveClassifySelfExaminationRecord(recordList);
        this.logger.info("\u81ea\u67e5\u7b49\u7ea7\u4fee\u6539\u6210\u529f");
    }

    @Transactional(readOnly=false)
    public void copyThisData2Db(CompanyHsePreventionControlSelfJudge selfJudge) {
        CompanyHsePreventionControlSelfJudge selfJudgeNew = new CompanyHsePreventionControlSelfJudge();
        BeanUtils.copyProperties((Object)selfJudge, (Object)selfJudgeNew);
        selfJudgeNew.setId(null);
        selfJudgeNew.setCidYear(null);
        selfJudgeNew.setTableFlag(Byte.valueOf((byte)1));
        selfJudgeNew.setCreateDate(new Date());
        selfJudgeNew.setSourceId(selfJudge.getId());
        CompanyHsePreventionControlSelfJudge add = this.add(selfJudgeNew);
        List terms = this.occupationalSelfJudgeTermV308Service.getListBySelfId(selfJudge.getId());
        terms.forEach(term -> {
            term.setId(null);
            term.setCreateDate(new Date());
            term.setCreateBy(Long.valueOf(0L));
            term.setSelfId(add.getId());
        });
        this.occupationalSelfJudgeTermV308Service.addBatch(terms);
    }

    public Long getSourceDataId(Long id, Long cid) {
        Example example = new Example(CompanyHsePreventionControlSelfJudge.class);
        example.createCriteria().andEqualTo("id", (Object)id).andEqualTo("isValid", (Object)Global.TRUE);
        CompanyHsePreventionControlSelfJudge selfJudge = (CompanyHsePreventionControlSelfJudge)this.getOneByExample(example);
        if (selfJudge == null) {
            return null;
        }
        return selfJudge.getSourceId();
    }

    public Boolean isFinishSelf(Long cid) {
        Example example = new Example(CompanyHsePreventionControlSelfJudge.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("status", (Object)4).andEqualTo("isValid", (Object)Global.TRUE);
        List list = this.getListByExample(example);
        return CollectionUtils.isNotEmpty(list);
    }

    @Transactional(readOnly=false)
    public void addReturnData(Long loginStaffCompanyId) {
        CompanyHsePreventionControlSelfJudge selfJudge;
        Example example = new Example(CompanyHsePreventionControlSelfJudge.class);
        example.createCriteria().andEqualTo("status", (Object)3).andEqualTo("isValid", (Object)true).andEqualTo("cid", (Object)loginStaffCompanyId);
        List dbList = this.getListByExample(example);
        if (CollectionUtils.isNotEmpty(dbList) && Objects.isNull(selfJudge = (CompanyHsePreventionControlSelfJudge)dbList.stream().filter(item -> item.getTableFlag() != null && item.getTableFlag() == 1).findFirst().orElse(null))) {
            this.copyThisData2Db((CompanyHsePreventionControlSelfJudge)dbList.get(0));
        }
    }

    @Transactional
    public void resetSelfJudge(Long cid) {
        List<CompanyHsePreventionControlSelfJudgeVo> selfJudgeVoList;
        if (cid == null) {
            cid = 1866739333336113154L;
        }
        if (CollectionUtils.isNotEmpty(selfJudgeVoList = ((CompanyHsePreventionControlSelfJudgeMapper)this.dao).listData(cid))) {
            List idList = selfJudgeVoList.stream().map(CompanyHsePreventionControlSelfJudgeVo::getId).distinct().collect(Collectors.toList());
            Example example = new Example(CompanyHsePreventionControlSelfJudge.class);
            example.createCriteria().andEqualTo("cid", (Object)cid).andIn("id", idList);
            ((CompanyHsePreventionControlSelfJudgeMapper)this.dao).deleteByExample(example);
            this.occupationalSelfJudgeTermV308Service.deleteBySelfIds(idList);
            this.addThisYearSelfJudge(cid, 0L);
        }
    }

    @Transactional(readOnly=false)
    public void deleteSelfJudge(Long id, Long loginStaffId) {
        if (id != null) {
            CompanyHsePreventionControlSelfJudge info = new CompanyHsePreventionControlSelfJudge();
            info.setId(id);
            this.delete(info, loginStaffId);
        }
    }

    public CompanyHsePreventionControlSelfJudge getLatestSelfJudgeByDateRange(Long cid, Date begin, Date end) {
        return ((CompanyHsePreventionControlSelfJudgeMapper)this.dao).getLatestSelfJudgeByDateRange(cid, begin, end);
    }

    @Transactional(readOnly=false)
    public CompanyHsePreventionControlSelfJudge addNotIsValid(CompanyHsePreventionControlSelfJudge selfJudge, Long loginStaffId, Long loginStaffCompanyId) {
        if (selfJudge != null) {
            selfJudge.setCid(loginStaffCompanyId);
            selfJudge.setDataSource(Byte.valueOf((byte)1));
            selfJudge.setStatus(Byte.valueOf((byte)1));
            selfJudge.setIsValid(Boolean.valueOf(false));
            selfJudge.setCreateBy(loginStaffId);
            selfJudge.setUpdateBy(loginStaffId);
            selfJudge.setUpdateDate(new Date());
            selfJudge.setCreateDate(new Date());
            ((CompanyHsePreventionControlSelfJudgeMapper)this.dao).insertSelective(selfJudge);
            return selfJudge;
        }
        return null;
    }

    @Transactional(readOnly=false)
    public int saveTermSituationsSubmit(CompanyHsePreventionControlSelfJudgeForm form, Long loginStaffId, Long loginStaffCompanyId) {
        try {
            if (form.getSelfJudge() == null || form.getSelfJudge().getId() == null) {
                return 0;
            }
            if (form.getTerms() != null && form.getTerms().size() > 0) {
                Map<Long, OccupationalSelfJudgeTermV308> map = form.getTerms().stream().collect(Collectors.toMap(OccupationalSelfJudgeTermV308::getTermNo, s -> s));
                List dataDB = this.occupationalSelfJudgeTermV308Service.getListBySelfId(form.getSelfJudge().getId());
                for (OccupationalSelfJudgeTermV308 termV308 : dataDB) {
                    termV308.setId(null);
                    if (map.get(termV308.getTermNo()) == null) continue;
                    termV308.setSituation(map.get(termV308.getTermNo()).getSituation());
                    termV308.setUpdateBy(loginStaffId);
                    termV308.setUpdateDate(new Date());
                }
                OccupationalSelfJudgeTermV308 termV308 = new OccupationalSelfJudgeTermV308();
                termV308.setSelfId(form.getSelfJudge().getId());
                if (termV308.getSelfId() != null) {
                    this.occupationalSelfJudgeTermV308Service.delete((Object)termV308);
                }
                this.occupationalSelfJudgeTermV308Service.addBatch(dataDB);
            }
            return 1;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public CompanyRiskJudgeV313Vo getLastCompanyRiskJudgeV313VoByCid(Long cid) {
        HazardsRiskClassifyEnum hazardsRiskClassifyEnum;
        CompanyRiskJudgeV313Vo vo = new CompanyRiskJudgeV313Vo();
        CompanyHseInvestigationRiskAssessmentInfo info = this.companyHseInvestigationRiskAssessmentInfoService.getLatestEntityByCid(cid);
        CompanyHsePreventionControlSelfJudge selfJudge = this.getLatestEntityByCid(cid);
        HazardsExposureRiskLevelEnum riskLevelEnum = null;
        if (info != null && info.getRiskLevel() != null) {
            vo.setRiskLevel(info.getRiskLevel());
            riskLevelEnum = HazardsExposureRiskLevelEnum.getThisEnumByCode((Integer)info.getRiskLevel().intValue());
            if (riskLevelEnum != null) {
                vo.setRiskLevelName(riskLevelEnum.getName());
            }
        }
        JudgeResultLevelEnum judgeResultLevelEnum = null;
        if (selfJudge != null && selfJudge.getJudgeLevel() != null) {
            vo.setJudgeResultLevel(Byte.valueOf(selfJudge.getJudgeLevel().byteValue()));
            judgeResultLevelEnum = JudgeResultLevelEnum.getThisEnumByCode((Integer)selfJudge.getJudgeLevel().intValue());
            if (judgeResultLevelEnum != null) {
                vo.setJudgeResultLevelName(judgeResultLevelEnum.getName());
            }
        }
        if (judgeResultLevelEnum != null && riskLevelEnum != null && (hazardsRiskClassifyEnum = HazardsRiskClassifyEnum.getThisEnumByJudgeLevelAndRiskLevel(judgeResultLevelEnum, riskLevelEnum)) != null) {
            vo.setRiskClassify(Long.valueOf(hazardsRiskClassifyEnum.getCode().longValue()));
            vo.setRiskClassifyName(hazardsRiskClassifyEnum.getName());
        }
        return vo;
    }

    public CompanyHsePreventionControlSelfJudge getLatestEntityByCid(Long cid) {
        return ((CompanyHsePreventionControlSelfJudgeMapper)this.dao).getLatestEntityByCid(cid);
    }

    public PageInfo<CompanyHsePreventionControlSelfJudge> getSelfjudgeListV313(JqGridParam jParam, SelfjudgeSearchVo vo) {
        PageHelper.startPage((int)jParam.getPage(), (int)jParam.getRows());
        if (StringUtils.isEmpty((CharSequence)vo.getCompanyName())) {
            vo.setCompanyName(null);
        }
        List<CompanyHsePreventionControlSelfJudge> list = ((CompanyHsePreventionControlSelfJudgeMapper)this.dao).selectBySelfjudgeSearchV313(vo);
        return new PageInfo(list);
    }

    public List<CompanyInvestigationAndSelfJudgeStatVo> getStatEveryCidLatestByDateRange(Date beginDate, Date endDate) {
        ArrayList<CompanyInvestigationAndSelfJudgeStatVo> list = new ArrayList<CompanyInvestigationAndSelfJudgeStatVo>();
        List investigationInfos = this.companyHseInvestigationRiskAssessmentInfoService.listDataEveryCidLatestByDateRange(beginDate, endDate);
        for (CompanyHseInvestigationRiskAssessmentInfo info : investigationInfos) {
            CompanyInvestigationAndSelfJudgeStatVo statVo = list.stream().filter(s -> info.getCid() != null && info.getCid().equals(s.getCid())).findFirst().orElse(null);
            if (statVo == null) {
                statVo = new CompanyInvestigationAndSelfJudgeStatVo();
                list.add(statVo);
            }
            statVo.setCid(info.getCid());
            statVo.setInvestigationId(info.getId());
            statVo.setRiskLevel(info.getRiskLevel());
        }
        List<CompanyHsePreventionControlSelfJudge> selfJudges = this.listDataEveryCidLatestByDateRange(beginDate, endDate);
        for (CompanyHsePreventionControlSelfJudge judge : selfJudges) {
            CompanyInvestigationAndSelfJudgeStatVo statVo = list.stream().filter(s -> judge.getCid() != null && judge.getCid().equals(s.getCid())).findFirst().orElse(null);
            if (statVo == null) {
                statVo = new CompanyInvestigationAndSelfJudgeStatVo();
                list.add(statVo);
            }
            statVo.setCid(judge.getCid());
            statVo.setSelfId(judge.getId());
            statVo.setJudgeLevel(judge.getJudgeLevel());
        }
        list.forEach(s -> {
            if (s.getRiskLevel() != null && s.getJudgeLevel() != null) {
                HazardsRiskClassifyEnum hazardsRiskClassifyEnum;
                JudgeResultLevelEnum judgeResultLevelEnum = JudgeResultLevelEnum.getThisEnumByCode((Integer)s.getJudgeLevel().intValue());
                HazardsExposureRiskLevelEnum riskLevelEnum = HazardsExposureRiskLevelEnum.getThisEnumByCode((Integer)s.getRiskLevel().intValue());
                if (judgeResultLevelEnum != null && riskLevelEnum != null && (hazardsRiskClassifyEnum = HazardsRiskClassifyEnum.getThisEnumByJudgeLevelAndRiskLevel((JudgeResultLevelEnum)judgeResultLevelEnum, (HazardsExposureRiskLevelEnum)riskLevelEnum)) != null) {
                    s.setRiskClassify(Long.valueOf(hazardsRiskClassifyEnum.getCode().longValue()));
                }
            }
        });
        return list;
    }

    public List<CompanyHsePreventionControlSelfJudge> listDataEveryCidLatestByDateRange(Date beginDate, Date endDate) {
        return ((CompanyHsePreventionControlSelfJudgeMapper)this.dao).listDataEveryCidLatestByDateRange(beginDate, endDate, ((CompanyHsePreventionControlSelfJudgeMapper)this.dao).selectCount(new CompanyHsePreventionControlSelfJudge()));
    }

    public List<CompanyHsePreventionControlSelfJudge> listDataV314EveryCidLatestByDateRange(Date beginDate, Date endDate, Long cid) {
        return ((CompanyHsePreventionControlSelfJudgeMapper)this.dao).listDataV314EveryCidLatestByDateRange(beginDate, endDate, cid, ((CompanyHsePreventionControlSelfJudgeMapper)this.dao).selectCount(new CompanyHsePreventionControlSelfJudge()));
    }

    public List<CompanyHsePreventionControlSelfJudge> listDataV314EveryCidLatestForSuperviseByDateRange(Date beginDate, Date endDate, List<Long> cids) {
        List<CompanyHsePreventionControlSelfJudge> selfJudgeListJudges = null;
        selfJudgeListJudges = CollectionUtils.isNotEmpty(cids) ? ((CompanyHsePreventionControlSelfJudgeMapper)this.dao).listDataV314EveryCidLatestForSuperviseByDateRange(beginDate, endDate, cids, 100000) : ((CompanyHsePreventionControlSelfJudgeMapper)this.dao).listDataV314EveryCidLatestForSuperviseByDateRange(beginDate, endDate, cids, ((CompanyHsePreventionControlSelfJudgeMapper)this.dao).selectCount(new CompanyHsePreventionControlSelfJudge()));
        return selfJudgeListJudges;
    }

    @Transactional(readOnly=false)
    public void importCompanyHsePreventionControlSelfJudgeDatas(List<CompanyHsePreventionControlSelfJudge> records) {
        HashMap mapMap = new HashMap();
        for (CompanyHsePreventionControlSelfJudge occupationalSelfJudge : records) {
            this.add(occupationalSelfJudge, occupationalSelfJudge.getCreateBy(), occupationalSelfJudge.getCid());
            if (mapMap.get(occupationalSelfJudge.getCid()) == null) {
                mapMap.put(occupationalSelfJudge.getCid(), new HashMap());
                Long i = 1L;
                while (i <= 22L) {
                    ((Map)mapMap.get(occupationalSelfJudge.getCid())).put(i, true);
                    Long l = i;
                    i = i + 1L;
                }
            }
            for (OccupationalSelfJudgeTermV308 s : occupationalSelfJudge.getTerms()) {
                if (s.getCheckResult() == null) {
                    s.setCheckResult(Byte.valueOf((byte)1));
                }
                s.setCreateBy(occupationalSelfJudge.getCreateBy());
                s.setCreateDate(new Date());
                s.setUpdateBy(occupationalSelfJudge.getCreateBy());
                s.setUpdateDate(new Date());
                s.setIsValid(Boolean.valueOf(true));
                s.setSelfId(occupationalSelfJudge.getId());
            }
        }
        new Thread(() -> {
            this.termUniformityHandleV313(mapMap);
            for (CompanyHsePreventionControlSelfJudge judgeV308 : records) {
                for (OccupationalSelfJudgeTermV308 termV308 : judgeV308.getTerms()) {
                    termV308.setTermUniformity(Byte.valueOf((byte)1));
                    boolean isRight = (Boolean)((Map)mapMap.get(judgeV308.getCid())).get(termV308.getTermNo());
                    if (termV308.getTermNo() == 4L || termV308.getTermNo() == 7L || termV308.getTermNo() == 10L || termV308.getTermNo() == 13L || termV308.getTermNo() == 14L || termV308.getTermNo() == 21L || (isRight || termV308.getCheckResult() != 1) && (!isRight || termV308.getCheckResult() != 3)) continue;
                    termV308.setTermUniformity(Byte.valueOf((byte)2));
                }
                this.occupationalSelfJudgeTermV308Service.addBatch(judgeV308.getTerms());
            }
        }).start();
        for (CompanyHsePreventionControlSelfJudge v308 : records) {
            this.workOperateLogService.report(v308.getId(), WorkOperateLogEnum.selfJudge.getTypeVal(), v308.getCreateBy(), v308.getRegistrant(), v308.getThirdOrgName());
        }
    }

    @Transactional(readOnly=false)
    public void saveOrgSelfJudge(CompanyHsePreventionControlSelfJudge selfJudge) {
    }

    @Transactional(readOnly=false)
    public CompanyHsePreventionControlSelfJudge addThisYearSelfJudge(Long loginStaffCompanyId, Long loginStaffId) {
        int year = DateUtils.getThisYear();
        CompanyHsePreventionControlSelfJudge selfJudge = this.getThisYearSelfJudgeByCid(year, loginStaffCompanyId);
        try {
            if (selfJudge == null) {
                selfJudge = new CompanyHsePreventionControlSelfJudge();
                selfJudge.setCid(loginStaffCompanyId);
                selfJudge.setYear(Long.valueOf(year));
                selfJudge.setCidYear("" + loginStaffCompanyId + year);
                selfJudge.setSelfFromYear(Byte.valueOf((byte)1));
                selfJudge.setStatus(Byte.valueOf((byte)1));
                selfJudge.setDataSource(Byte.valueOf((byte)1));
                selfJudge.setIsValid(Boolean.valueOf(true));
                selfJudge.setSelfTime(new Date());
                selfJudge = this.add(selfJudge, loginStaffId, loginStaffCompanyId);
                List terms = this.selfInspectionTermService.getListByFlag(Integer.valueOf(1));
                CompanyHsePreventionControlSelfJudge finalSelfJudge = selfJudge;
                List judgeTermV308s = terms.stream().map(term -> {
                    OccupationalSelfJudgeTermV308 judgeTermV308 = new OccupationalSelfJudgeTermV308();
                    judgeTermV308.setSelfId(finalSelfJudge.getId());
                    judgeTermV308.setCreateBy(loginStaffId);
                    judgeTermV308.setCreateDate(new Date());
                    judgeTermV308.setUpdateBy(loginStaffId);
                    judgeTermV308.setUpdateDate(new Date());
                    judgeTermV308.setIsValid(Boolean.valueOf(true));
                    judgeTermV308.setCheckResult(Byte.valueOf((byte)3));
                    judgeTermV308.setTermNo(Long.valueOf(term.getTermNo().longValue()));
                    judgeTermV308.setChecked(Boolean.valueOf(false));
                    judgeTermV308.setTermObtainScore(term.getScore() == null ? null : Double.valueOf(0.0));
                    judgeTermV308.setTermScore(term.getScore() == null ? null : Double.valueOf(term.getScore().doubleValue()));
                    return judgeTermV308;
                }).collect(Collectors.toList());
                this.occupationalSelfJudgeTermV308Service.addBatch(judgeTermV308s);
            }
        }
        catch (Exception e) {
            this.logger.info("\u521b\u5efa\u81ea\u67e5\u5931\u8d25!" + e.getMessage());
        }
        return selfJudge;
    }

    public CompanyHsePreventionControlSelfJudge getThisYearLatestSelfJudge(Long loginStaffCompanyId, Integer year) {
        CompanyHsePreventionControlSelfJudge selfJudge = ((CompanyHsePreventionControlSelfJudgeMapper)this.dao).getThisYearLatestSelfJudge(loginStaffCompanyId, year);
        if (selfJudge != null) {
            selfJudge.setTerms(this.occupationalSelfJudgeTermV308Service.getListBySelfId(selfJudge.getId()));
        }
        return selfJudge;
    }

    public List<SelfReportCollectVo> getSelfJudgeCollectVosByRangTime(Date beginDate, Date endDate) {
        List<CompanyHsePreventionControlSelfJudge> listAll = this.getAllDataByRangeTime(beginDate, endDate, null);
        Map map = listAll.stream().collect(Collectors.groupingBy(s -> s.getCid(), Collectors.toList()));
        ArrayList<SelfReportCollectVo> results = new ArrayList<SelfReportCollectVo>();
        for (Long cid : map.keySet()) {
            SelfReportCollectVo vo = new SelfReportCollectVo();
            vo.setCid(cid);
            List everylist = map.get(cid).stream().sorted(Comparator.comparing(CompanyHsePreventionControlSelfJudge::getUpdateDate).reversed()).collect(Collectors.toList());
            ArrayList statusList = new ArrayList();
            CompanyHsePreventionControlSelfJudge reportInfo = everylist.stream().filter(s -> {
                statusList.add(s.getStatus());
                return Long.valueOf(4L).equals(s.getStatus());
            }).findFirst().orElse(null);
            if (reportInfo != null) {
                vo.setSelfId(reportInfo.getId());
                if (reportInfo.getJudgeLevel() != null) {
                    vo.setJudgeLevel(Integer.valueOf(reportInfo.getJudgeLevel().intValue()));
                }
                vo.setJudgeUpdateDate(reportInfo.getUpdateDate());
            }
            if (statusList.contains(Byte.valueOf("2"))) {
                vo.setJudgeCheckState(Integer.valueOf(0));
                continue;
            }
            if (statusList.contains(Byte.valueOf("3"))) {
                vo.setJudgeCheckState(Integer.valueOf(-1));
                continue;
            }
            if (!statusList.contains(Byte.valueOf("4"))) continue;
            vo.setJudgeCheckState(Integer.valueOf(1));
        }
        return results;
    }

    public SelfReportCollectVo getSelfJudgeCollectVosByRangTimeAndCid(Date beginDate, Date endDate, Long cid) {
        List<CompanyHsePreventionControlSelfJudge> listAll = this.getAllDataByRangeTime(beginDate, endDate, cid);
        SelfReportCollectVo vo = new SelfReportCollectVo();
        vo.setCid(cid);
        if (cid == null || listAll == null || listAll.size() == 0) {
            return vo;
        }
        List everylist = listAll.stream().sorted(Comparator.comparing(CompanyHsePreventionControlSelfJudge::getUpdateDate).reversed()).collect(Collectors.toList());
        ArrayList statusList = new ArrayList();
        CompanyHsePreventionControlSelfJudge reportInfo = everylist.stream().filter(s -> {
            statusList.add(s.getStatus());
            return Long.valueOf(4L).equals(s.getStatus());
        }).findFirst().orElse(null);
        if (reportInfo != null) {
            vo.setSelfId(reportInfo.getId());
            if (reportInfo.getJudgeLevel() != null) {
                vo.setJudgeLevel(Integer.valueOf(reportInfo.getJudgeLevel().intValue()));
            }
            vo.setJudgeUpdateDate(reportInfo.getUpdateDate());
        }
        if (statusList.contains(Byte.valueOf("2"))) {
            vo.setJudgeCheckState(Integer.valueOf(0));
        } else if (statusList.contains(Byte.valueOf("3"))) {
            vo.setJudgeCheckState(Integer.valueOf(-1));
        } else if (statusList.contains(Byte.valueOf("4"))) {
            vo.setJudgeCheckState(Integer.valueOf(1));
        }
        return vo;
    }

    public CompanyHsePreventionControlSelfJudge getLatestEntityNoStatusByCid(Long cid) {
        CompanyHsePreventionControlSelfJudge selfJudge = ((CompanyHsePreventionControlSelfJudgeMapper)this.dao).getLatestEntityNoStatusByCid(cid);
        return selfJudge;
    }

    public CompanyHsePreventionControlSelfJudgeVo getV314VoById(Long id) {
        CompanyHsePreventionControlSelfJudgeVo vo = new CompanyHsePreventionControlSelfJudgeVo();
        vo.setSelfJudge((CompanyHsePreventionControlSelfJudge)this.getById(id));
        vo.setTerms(this.occupationalSelfJudgeTermV308Service.getListBySelfId(id));
        if (vo.getSelfJudge() != null && vo.getSelfJudge().getJudgeLevel() != null) {
            JudgeResultLevelEnum judgeResultLevelEnum = JudgeResultLevelEnum.getThisEnumByCode((Integer)vo.getSelfJudge().getJudgeLevel().intValue());
            vo.setJudgeLevelName(judgeResultLevelEnum == null ? null : judgeResultLevelEnum.getName());
        }
        vo.setAbleMissingItemCount(Long.valueOf(0L));
        vo.setRectifyItemCount(Long.valueOf(0L));
        vo.setDisableMissingObtainScore(Double.valueOf(0.0));
        vo.setDisableMissingTotalScore(Double.valueOf(0.0));
        if (vo.getTerms() != null && vo.getTerms().size() > 0) {
            List terms = this.selfInspectionTermService.getListByFlag(Integer.valueOf(1));
            vo.getTerms().stream().forEach(s -> {
                SelfInspectionTerm t;
                if (s.getCheckResult() != null && s.getCheckResult() != 4) {
                    vo.setDisableMissingTotalScore(Double.valueOf(vo.getDisableMissingTotalScore() + (s.getTermScore() == null ? 0.0 : s.getTermScore())));
                    vo.setDisableMissingObtainScore(Double.valueOf(vo.getDisableMissingObtainScore() + (s.getTermObtainScore() == null ? 0.0 : s.getTermObtainScore())));
                }
                if ((t = (SelfInspectionTerm)terms.stream().filter(s1 -> Long.valueOf(s1.getTermNo().intValue()).equals(s.getTermNo())).findFirst().orElse(null)) != null) {
                    s.setTermName(t.getTermName());
                }
            });
            vo.setRectifyItemCount(Long.valueOf(vo.getTerms().stream().filter(s -> s.getCheckResult() != null && (s.getCheckResult() == 2 || s.getCheckResult() == 3)).count()));
            vo.setAbleMissingItemCount(Long.valueOf(vo.getTerms().stream().filter(s -> s.getCheckResult() != null && s.getCheckResult() == 4).count()));
            vo.setAbleMissingTerms(vo.getTerms().stream().filter(s -> s.getCheckResult() != null && s.getCheckResult() == 4).collect(Collectors.toList()));
            vo.setRectifyTerms(vo.getTerms().stream().filter(s -> s.getCheckResult() != null && (s.getCheckResult() == 2 || s.getCheckResult() == 3)).collect(Collectors.toList()));
        }
        if (vo.getSelfJudge() != null) {
            vo.setLastYearLatestSelfJudge(this.getLatestSelfJudgeByDateRange(vo.getSelfJudge().getCid(), DateUtils.getYearFirstDay((int)(DateUtils.getThisYear() - 1)), DateUtils.getYearLastDay((int)(DateUtils.getThisYear() - 1))));
            vo.setLastTimeSelfJudge(this.getLastTimeSelfJudgeById(vo.getSelfJudge().getCid(), 4, vo.getSelfJudge().getId()));
        }
        if (vo.getLastYearLatestSelfJudge() != null) {
            vo.setLastYearLatestTerms(this.occupationalSelfJudgeTermV308Service.getListBySelfId(vo.getLastYearLatestSelfJudge().getId()));
        }
        if (vo.getLastTimeSelfJudge() != null) {
            vo.setLastTimeTerms(this.occupationalSelfJudgeTermV308Service.getListBySelfId(vo.getLastTimeSelfJudge().getId()));
        }
        return vo;
    }

    @Transactional(readOnly=false)
    public int examineAndVerifySelfJudgeById(CompanyHsePreventionControlSelfJudge selfJudge, Long loginUserId, String reason, String operater, String companyName) {
        if (selfJudge == null && selfJudge.getId() == null || selfJudge.getStatus() == null || selfJudge.getStatus() == 1 || selfJudge.getStatus() == 2) {
            return 0;
        }
        CompanyHsePreventionControlSelfJudge dbdata = (CompanyHsePreventionControlSelfJudge)this.getById(selfJudge.getId());
        if (dbdata == null) {
            this.logger.warn("\u81ea\u67e5\u5ba1\u6838\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff0cselfJudge:{}", (Object)JSON.toJSONString((Object)selfJudge));
            return 0;
        }
        CompanyHsePreventionControlSelfJudge updateSelfJudge = new CompanyHsePreventionControlSelfJudge();
        updateSelfJudge.setId(selfJudge.getId());
        updateSelfJudge.setStatus(selfJudge.getStatus());
        updateSelfJudge.setBackReasonDetail(selfJudge.getBackReasonDetail());
        boolean addLog = true;
        if (Objects.equals(selfJudge.getStatus(), (byte)4) && Objects.equals(selfJudge.getStatus(), dbdata.getStatus())) {
            addLog = false;
        }
        if (addLog) {
            this.update(updateSelfJudge, loginUserId);
        }
        if (addLog && selfJudge.getStatus() != null && selfJudge.getStatus() == 4) {
            new Thread(() -> {
                if (new Date().getTime() > DateUtils.parseDate((Object)"2025-10-01 00:00:00").getTime()) {
                    return;
                }
                CompanyHsePreventionControlSelfJudge selfJudgedb = (CompanyHsePreventionControlSelfJudge)this.getById(selfJudge.getId());
                List termV308s = this.occupationalSelfJudgeTermV308Service.getListBySelfId(selfJudge.getId());
                List terms = this.selfInspectionTermService.getListByFlag(Integer.valueOf(1));
                termV308s = termV308s.stream().filter(s -> {
                    SelfInspectionTerm t = terms.stream().filter(s1 -> Long.valueOf(s1.getTermNo().intValue()).equals(s.getTermNo())).findFirst().orElse(null);
                    if (t != null) {
                        s.setTermName(t.getTermName());
                    }
                    return s.getTermNo() != 6L && (s.getCheckResult() == 3 || s.getCheckResult() == 2);
                }).collect(Collectors.toList());
                List refromList = termV308s.stream().map(s -> {
                    String result = "\u4e0d\u7b26\u5408\u8981\u6c42";
                    if (s.getCheckResult() == 2) {
                        result = "\u57fa\u672c\u7b26\u5408";
                    }
                    ReformGenerationSourceEnum sourceEnum = ReformGenerationSourceEnum.ZRZC;
                    if (s.getTermNo() == 3L) {
                        sourceEnum = ReformGenerationSourceEnum.ARCHIVES;
                    }
                    if (s.getTermNo() == 4L) {
                        sourceEnum = ReformGenerationSourceEnum.DECLARE;
                    }
                    if (s.getTermNo() == 5L) {
                        sourceEnum = ReformGenerationSourceEnum.THREE_TIME;
                    }
                    if (s.getTermNo() == 8L) {
                        sourceEnum = ReformGenerationSourceEnum.DETECTION;
                    }
                    if (s.getTermNo() == 12L) {
                        sourceEnum = ReformGenerationSourceEnum.PROTECTION;
                    }
                    if (s.getTermNo() == 16L) {
                        sourceEnum = ReformGenerationSourceEnum.WARNING_SIGNS;
                    }
                    if (s.getTermNo() == 17L) {
                        sourceEnum = ReformGenerationSourceEnum.TRAIN;
                    }
                    if (s.getTermNo() == 19L) {
                        sourceEnum = ReformGenerationSourceEnum.TJ;
                    }
                    ReformAddParam addParam = new ReformAddParam();
                    addParam.setCid(selfJudge.getCid());
                    addParam.setFinderName(selfJudgedb.getSelfStaffName());
                    addParam.setName(s.getTermNo() + "-" + s.getTermName() + "-" + result);
                    addParam.setReformItemSource(ReformSourceLiteEnum.FZZRZC.getValue());
                    addParam.setReformItemSourceId(selfJudge.getId());
                    addParam.setGenerationSource(sourceEnum.getValue());
                    return addParam;
                }).collect(Collectors.toList());
                this.itemBasicNewService.generateReform(refromList);
            }).start();
        }
        if (addLog) {
            this.workOperateLogService.addOperateLog(selfJudge.getId(), WorkOperateLogEnum.Responsibility.getTypeVal(), reason, loginUserId, operater, Objects.equals(selfJudge.getStatus(), (byte)4) ? WorkOperateLogStatusEnum.pass : WorkOperateLogStatusEnum.back, companyName);
        }
        return 1;
    }

    @Transactional(readOnly=false)
    public CompanyHsePreventionControlSelfJudge addChangeTypeSelfJudge(CompanyHsePreventionControlSelfJudge selfJudge, Long reportId, Long loginStaffCompanyId, Long loginStaffId) {
        if (selfJudge.getId() == null && Byte.valueOf("2").equals(selfJudge.getSelfFromYear())) {
            int year = DateUtils.getThisYear();
            selfJudge.setCid(loginStaffCompanyId);
            selfJudge.setYear(Long.valueOf(year));
            selfJudge.setSelfTime(new Date());
            selfJudge.setStatus(Byte.valueOf((byte)1));
            selfJudge.setDataSource(Byte.valueOf((byte)1));
            selfJudge.setIsValid(Boolean.valueOf(true));
            selfJudge = this.add(selfJudge, loginStaffId, loginStaffCompanyId);
            List terms = this.selfInspectionTermService.getListByFlag(Integer.valueOf(1));
            CompanyHsePreventionControlSelfJudge finalSelfJudge = selfJudge;
            List judgeTermV308s = terms.stream().map(term -> {
                OccupationalSelfJudgeTermV308 judgeTermV308 = new OccupationalSelfJudgeTermV308();
                judgeTermV308.setSelfId(finalSelfJudge.getId());
                judgeTermV308.setCreateBy(loginStaffId);
                judgeTermV308.setCreateDate(new Date());
                judgeTermV308.setUpdateBy(loginStaffId);
                judgeTermV308.setUpdateDate(new Date());
                judgeTermV308.setIsValid(Boolean.valueOf(true));
                judgeTermV308.setCheckResult(Byte.valueOf((byte)3));
                judgeTermV308.setTermNo(Long.valueOf(term.getTermNo().longValue()));
                judgeTermV308.setTermObtainScore(term.getScore() == null ? null : Double.valueOf(0.0));
                judgeTermV308.setTermScore(term.getScore() == null ? null : Double.valueOf(term.getScore().doubleValue()));
                return judgeTermV308;
            }).collect(Collectors.toList());
            this.occupationalSelfJudgeTermV308Service.addBatch(judgeTermV308s);
            if (reportId != null) {
                SelfInspectionRiskAssessmentReportInfo reportInfo = new SelfInspectionRiskAssessmentReportInfo();
                reportInfo.setId(reportId);
                reportInfo.setSelfReportId(selfJudge.getId());
                this.selfInspectionRiskAssessmentReportInfoService.update((Object)reportInfo, loginStaffId);
            }
        }
        return selfJudge;
    }

    public Map<Long, CompanyHsePreventionControlSelfJudge> queryByIds(List<Long> selfIds) {
        if (selfIds == null || selfIds.isEmpty()) {
            return new HashMap<Long, CompanyHsePreventionControlSelfJudge>();
        }
        Example example = new Example(CompanyHsePreventionControlSelfJudge.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andIn("id", selfIds);
        List list = ((CompanyHsePreventionControlSelfJudgeMapper)this.dao).selectByExample(example);
        if (list == null || list.isEmpty()) {
            return new HashMap<Long, CompanyHsePreventionControlSelfJudge>();
        }
        return list.stream().collect(Collectors.toMap(CompanyHsePreventionControlSelfJudge::getId, s -> s));
    }

    private CompanyHsePreventionControlSelfJudge getLastTimeSelfJudgeById(Long cid, Integer status, Long id) {
        return ((CompanyHsePreventionControlSelfJudgeMapper)this.dao).getLastTimeSelfJudgeById(cid, status, id);
    }

    private List<CompanyHsePreventionControlSelfJudge> getAllDataByRangeTime(Date beginDate, Date endDate, Long cid) {
        Example example = new Example(CompanyHsePreventionControlSelfJudge.class);
        example.createCriteria().andBetween("updateDate", (Object)beginDate, (Object)endDate).andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true);
        List list = ((CompanyHsePreventionControlSelfJudgeMapper)this.dao).selectByExample(example);
        return list;
    }

    private CompanyHsePreventionControlSelfJudge getThisYearSelfJudgeByCid(int year, Long cid) {
        Example example = new Example(CompanyHsePreventionControlSelfJudge.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("selfFromYear", (Object)1).andEqualTo("isValid", (Object)true);
        List list = ((CompanyHsePreventionControlSelfJudgeMapper)this.dao).selectByExample(example);
        if (list != null && !list.isEmpty()) {
            return (CompanyHsePreventionControlSelfJudge)list.get(0);
        }
        return null;
    }

    private void termUniformityHandleV313(Map<Long, Map<Long, Boolean>> cidMap) {
        for (Long cid : cidMap.keySet()) {
            Map<Long, Boolean> termsMap = cidMap.get(cid);
            int msInfoCountHasFile = this.judgeEhsService.getMsInfoCountHasFile(cid);
            int msPohopCount = this.judgeEhsService.getMsPohopCount(cid);
            termsMap.put(1L, msInfoCountHasFile > 0 && msPohopCount > 0);
            SysFileModel establishFile = this.judgeEhsService.getEstablishFile(cid);
            if (establishFile == null) {
                establishFile = new SysFileModel();
            }
            FunOrganManagerInfo funOrganMangerInfo = this.judgeEhsService.getFunOrganMangerInfo(cid);
            termsMap.put(2L, establishFile.getId() != null && funOrganMangerInfo.isHasEmployFile());
            Map archiveStatusMap = this.liteArchiveService.getArchiveStatus(cid, "" + Calendar.getInstance().get(1));
            termsMap.put(3L, archiveStatusMap.values().stream().filter(s -> s == 3).collect(Collectors.toList()).size() == 6);
            List thirdTimeInfo = this.judgeEhsService.getThirdTimeInfo(cid);
            termsMap.put(5L, thirdTimeInfo != null && thirdTimeInfo.size() > 0);
            LastHarmFactorTestInfo lastHarmFactorInfo = this.judgeEhsService.getLastHarmFactorInfo(cid);
            termsMap.put(6L, lastHarmFactorInfo == null || lastHarmFactorInfo.getInconformityNum() == 0);
            boolean isFinishedHarmFactorRegularCheck = this.judgeEhsService.isFinishedHarmFactorRegularCheck(cid, Calendar.getInstance().get(1));
            termsMap.put(8L, isFinishedHarmFactorRegularCheck);
            CompanyBaseInfoModel company = this.companyProvideByHSEService.getCompanyById(cid);
            int deviceOccupationalDiseaseNum = this.judgeEhsService.getDeviceOccupationalDiseaseNum(cid);
            termsMap.put(11L, deviceOccupationalDiseaseNum > 0);
            ShieldSendInfo shieldSendInfo = this.judgeEhsService.getShieldSendInfo(cid);
            List shieldPurchaseList = this.judgeEhsService.getShieldPurchaseList(cid);
            termsMap.put(12L, shieldSendInfo.getSendNum() > 0 || shieldPurchaseList != null && shieldPurchaseList.size() > 0);
            ContractInformInfo contractInformInfo = this.judgeEhsService.getContractInformInfo(cid);
            termsMap.put(15L, contractInformInfo != null && contractInformInfo.getInformNum() > 0);
            TrainCertificateInfo trainCertificateInfo = this.judgeEhsService.getTrainCertificateInfo(cid);
            termsMap.put(17L, trainCertificateInfo != null && trainCertificateInfo.getEhsTrainCertificateNum() > 0);
            PhcCheckInfo phcCheckInfo = this.judgeEhsService.getPhcCheckInfo(cid);
            int phcCheckNumJobing = this.judgeEhsService.getPhcCheckNumJobing(cid);
            termsMap.put(19L, phcCheckInfo.getPhcCheckNumPreJob() > 0 || phcCheckInfo.getPhcCheckNumLeftJob() > 0 || phcCheckNumJobing > 0);
            int undealAbnormalCount = this.phcPhysicalCheckTipService.undealAbnormalCount(cid);
            termsMap.put(20L, undealAbnormalCount == 0);
            int occupationalDiseasesNum = this.judgeEhsService.getOccupationalDiseasesNum(cid);
            termsMap.put(22L, occupationalDiseasesNum == 0);
        }
    }

    public void unreliableCompanyJudge(Long cid, Long loginStaffId) {
        CompanyHsePreventionControlSelfJudge selfJudge = ((CompanyHsePreventionControlSelfJudgeMapper)this.dao).getLastTimeSelfJudgeByCidAndStatus(cid, (byte)4);
        if (selfJudge == null) {
            return;
        }
        int result = this.getCountForSettingCheckResult(cid);
        CompanyBaseInfoModel company = this.companyProvideByHSEService.getCompanyById(cid);
        if (result > 0) {
            CompanyHsePreventionControlSelfJudgeVo vo = this.getVoById(selfJudge.getId());
            vo.getTerms().stream().forEach(s -> {
                if (s.getTermNo() == 22L && s.getCheckResult() != 3) {
                    company.setIsReliable(Global.FALSE);
                }
            });
        } else {
            company.setIsReliable(Global.TRUE);
        }
        this.companyProvideByHSEService.updateCompanyBaseInfoModel(company, loginStaffId);
    }

    public int getCountForSettingCheckResult(Long cid) {
        if (cid == null) {
            return 0;
        }
        PhcThirdOccupationalDiseaserParamVo paramVo = new PhcThirdOccupationalDiseaserParamVo();
        this.settingQueryParam(cid, paramVo);
        int checkNum = this.supervisePhcPhysicalOdService.getCheckNum(paramVo);
        int count = this.supervisionLawService.getCountByCidAndYear(cid, Integer.valueOf(LocalDateTime.now().getYear() - 1));
        return checkNum + count;
    }

    private void settingQueryParam(Long cid, PhcThirdOccupationalDiseaserParamVo paramVo) {
        Calendar calendar = Calendar.getInstance();
        int beYear = calendar.get(1) - 2;
        int yeYear = calendar.get(1) - 1;
        calendar.clear();
        calendar.set(1, beYear);
        paramVo.setBeginTime(calendar.getTime());
        calendar.clear();
        calendar.set(1, yeYear);
        calendar.roll(6, -1);
        paramVo.setEndTime(calendar.getTime());
        paramVo.setCid(cid);
        paramVo.setReportStatus(Byte.valueOf((byte)9));
    }

    @Transactional(readOnly=false)
    public String editToBeReviewedInfo() {
        ArrayList<Byte> statusList = new ArrayList<Byte>();
        statusList.add((byte)1);
        statusList.add((byte)2);
        statusList.add((byte)3);
        Example example = new Example(CompanyHsePreventionControlSelfJudge.class);
        example.createCriteria().andIn("status", statusList).andEqualTo("isValid", (Object)true).andEqualTo("id", (Object)3486497776731136L);
        List selfJudgeList = ((CompanyHsePreventionControlSelfJudgeMapper)this.dao).selectByExample(example);
        ArrayList<CompanyHsePreventionControlSelfJudge> newSelfJudgeList = new ArrayList<CompanyHsePreventionControlSelfJudge>();
        ArrayList<OccupationalSelfJudgeTermV308> newTermList = new ArrayList<OccupationalSelfJudgeTermV308>();
        for (CompanyHsePreventionControlSelfJudge selfJudge : selfJudgeList) {
            this.logger.info("\u4fee\u6539\u524did:{},totalScore:{},level:{}", new Object[]{selfJudge.getId(), selfJudge.getTotalScore(), selfJudge.getJudgeLevel()});
            selfJudge.setTerms(this.occupationalSelfJudgeTermV308Service.getListBySelfId(selfJudge.getId()));
            ((OccupationalSelfJudgeTermV308)((CompanyHsePreventionControlSelfJudge)selfJudgeList.get(0)).getTerms().get(0)).setTermObtainScore(Double.valueOf(20.0));
            ((OccupationalSelfJudgeTermV308)((CompanyHsePreventionControlSelfJudge)selfJudgeList.get(0)).getTerms().get(1)).setTermObtainScore(Double.valueOf(20.0));
            ((OccupationalSelfJudgeTermV308)((CompanyHsePreventionControlSelfJudge)selfJudgeList.get(0)).getTerms().get(0)).setTermScore(Double.valueOf(20.0));
            ((OccupationalSelfJudgeTermV308)((CompanyHsePreventionControlSelfJudge)selfJudgeList.get(0)).getTerms().get(1)).setTermScore(Double.valueOf(20.0));
            if (!CollectionUtils.isNotEmpty((Collection)selfJudge.getTerms())) continue;
            selfJudge.getTerms().sort(Comparator.comparing(OccupationalSelfJudgeTermV308::getTermNo));
            ((OccupationalSelfJudgeTermV308)selfJudge.getTerms().get(0)).setTermScore(new Double(Double.parseDouble("" + ((OccupationalSelfJudgeTermV308)selfJudge.getTerms().get(0)).getTermScore() * 0.75)));
            ((OccupationalSelfJudgeTermV308)selfJudge.getTerms().get(1)).setTermScore(new Double(Double.parseDouble("" + ((OccupationalSelfJudgeTermV308)selfJudge.getTerms().get(1)).getTermScore() * 0.75)));
            ((OccupationalSelfJudgeTermV308)selfJudge.getTerms().get(0)).setTermObtainScore(new Double(Double.parseDouble("" + ((OccupationalSelfJudgeTermV308)selfJudge.getTerms().get(0)).getTermObtainScore() * 0.75)));
            ((OccupationalSelfJudgeTermV308)selfJudge.getTerms().get(1)).setTermObtainScore(new Double(Double.parseDouble("" + ((OccupationalSelfJudgeTermV308)selfJudge.getTerms().get(1)).getTermObtainScore() * 0.75)));
            double totalScore = 0.0;
            double obtainScore = 0.0;
            for (OccupationalSelfJudgeTermV308 term : selfJudge.getTerms()) {
                if (Objects.isNull(term.getTermScore()) || term.getCheckResult() == 4) continue;
                totalScore += term.getTermScore().doubleValue();
                obtainScore += term.getTermObtainScore().doubleValue();
            }
            BigDecimal bigDecimal = new BigDecimal(obtainScore * 100.0 / totalScore);
            String s = bigDecimal.setScale(1, 4).toString();
            selfJudge.setTotalScore(s);
            if (this.isBest(selfJudge.getCid())) {
                selfJudge.setJudgeLevel(Long.valueOf(1L));
            } else {
                selfJudge.setJudgeLevel(Long.valueOf(JudgeResultLevelEnum.getThisEnumByScore((Double)(StringUtils.isNumber((String)selfJudge.getTotalScore()) ? Double.valueOf(selfJudge.getTotalScore()) : 0.0)).getCode().longValue()));
            }
            this.logger.info("\u4fee\u6539\u540eid:{},totalScore:{},level:{}", new Object[]{selfJudge.getId(), selfJudge.getTotalScore(), selfJudge.getJudgeLevel()});
            newSelfJudgeList.add(selfJudge);
            newTermList.add((OccupationalSelfJudgeTermV308)selfJudge.getTerms().get(0));
            newTermList.add((OccupationalSelfJudgeTermV308)selfJudge.getTerms().get(1));
        }
        return "success";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNewRule(Date selfTime) {
        boolean isNewRule = true;
        try {
            SimpleDateFormat dateFormat2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = dateFormat2.parse("2022-11-1 00:00:00");
            if (date.after(selfTime)) {
                isNewRule = false;
                return isNewRule;
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        finally {
            return isNewRule;
        }
    }
}

