/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.selfjudge;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.datacentre.provider.system.ISysParamProvideService;
import cn.smarthse.modules.health.dao.base.selfjudge.CompanyHseInvestigationRiskAssessmentInfoMapper;
import cn.smarthse.modules.health.entity.base.selfjudge.CompanyHseInvestigationRiskAssessmentInfo;
import cn.smarthse.modules.health.entity.base.selfjudge.vo.CompanyHseInvestigationRiskAssessmentInfoForm;
import cn.smarthse.modules.health.entity.base.selfjudge.vo.CompanyHseInvestigationRiskAssessmentInfoVo;
import cn.smarthse.modules.health.enums.selfjudge.HazardsExposureRiskLevelEnum;
import cn.smarthse.modules.health.service.base.selfjudge.ICompanyHseInvestigationRiskAssessmentInfoService;
import cn.smarthse.modules.health.service.base.selfjudge.ICompanyHseInvestigationService;
import cn.smarthse.modules.health.service.base.selfjudge.ICompanyHseRiskAssessmentService;
import cn.smarthse.modules.health.service.base.selfjudge.IOccupationalSelfJudgeV308Service;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.supervise.enums.WorkOperateLogEnum;
import cn.smarthse.modules.health.supervise.service.operate.IWorkOperateLogService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class CompanyHseInvestigationRiskAssessmentInfoServiceImpl
extends BaseServiceImpl<CompanyHseInvestigationRiskAssessmentInfoMapper, CompanyHseInvestigationRiskAssessmentInfo>
implements ICompanyHseInvestigationRiskAssessmentInfoService {
    @Autowired(required=false)
    private ICompanyHseInvestigationService companyHseInvestigationService;
    @Autowired(required=false)
    private ICompanyHseRiskAssessmentService companyHseRiskAssessmentService;
    @Autowired(required=false)
    private IStaffInfoService staffInfoService;
    @Autowired(required=false)
    private IOccupationalSelfJudgeV308Service occupationalSelfJudgeV308Service;
    @DubboReference(version="1.0.0")
    private ISysParamProvideService sysParamProvideService;
    @DubboReference
    private IWorkOperateLogService workOperateLogService;

    @Transactional(readOnly=false)
    public int saveInvestigationRiskAssessmentSubmit(CompanyHseInvestigationRiskAssessmentInfoForm form, Long loginStaffId, Long loginStaffCompanyId) {
        try {
            form.getInfo().setIsValid(Boolean.valueOf(true));
            if (form.getInfo().getStatus() != null && form.getInfo().getStatus() == 2) {
                this.workOperateLogService.report(form.getInfo().getId(), WorkOperateLogEnum.investigationRiskAssessment.getTypeVal(), loginStaffId, form.getOperaterName(), form.getCompanyName());
            }
            if (form.getInfo().getId() == null) {
                form.setInfo(this.add(form.getInfo(), loginStaffId, loginStaffCompanyId));
            } else {
                this.update(form.getInfo(), loginStaffId);
            }
            ArrayList investigations = new ArrayList();
            if (form.getCompanyHseInvestigations() != null) {
                investigations.addAll(form.getCompanyHseInvestigations());
            }
            investigations.forEach(s -> s.setInfoId(form.getInfo().getId()));
            this.companyHseInvestigationService.addList(investigations, loginStaffId, loginStaffCompanyId);
            form.getCompanyHseRiskAssessment().setInfoId(form.getInfo().getId());
            this.companyHseRiskAssessmentService.addEntity(form.getCompanyHseRiskAssessment(), loginStaffId, loginStaffCompanyId);
            return 1;
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Transactional(readOnly=false)
    public CompanyHseInvestigationRiskAssessmentInfo addCompanyHseInvestigationRiskAssessmentInfo(CompanyHseInvestigationRiskAssessmentInfo info) {
        return this.add(info);
    }

    public PageInfo<CompanyHseInvestigationRiskAssessmentInfoVo> listPageData(JqGridParam jqGridParam) {
        PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows());
        List<CompanyHseInvestigationRiskAssessmentInfoVo> list = ((CompanyHseInvestigationRiskAssessmentInfoMapper)this.dao).listData(jqGridParam.getCid());
        list.forEach(s -> {
            if (s.getDataSource() != null && s.getDataSource() == 1 && s.getOperatorStaffId() != null) {
                s.setOperatorStaffName(this.staffInfoService.getStaffNameByStaffId(s.getOperatorStaffId()));
            }
            if (s.getRiskLevel() != null) {
                HazardsExposureRiskLevelEnum riskLevelEnum = HazardsExposureRiskLevelEnum.getThisEnumByCode((Integer)s.getRiskLevel());
                s.setRiskLevelName(riskLevelEnum == null ? null : riskLevelEnum.getName());
            }
        });
        return new PageInfo(list);
    }

    public CompanyHseInvestigationRiskAssessmentInfoVo getVoById(Long id) {
        HazardsExposureRiskLevelEnum riskLevelEnum;
        CompanyHseInvestigationRiskAssessmentInfoVo vo = new CompanyHseInvestigationRiskAssessmentInfoVo();
        vo.setInfo((CompanyHseInvestigationRiskAssessmentInfo)this.getById(id));
        vo.setCompanyHseInvestigations(this.companyHseInvestigationService.getListByInfoId(id));
        if (vo.getInfo() != null && vo.getInfo().getRiskLevel() != null && (riskLevelEnum = HazardsExposureRiskLevelEnum.getThisEnumByCode((Integer)vo.getInfo().getRiskLevel().intValue())) != null) {
            vo.setRiskLevel(Integer.valueOf(vo.getInfo().getRiskLevel().intValue()));
            vo.setRiskLevelName(riskLevelEnum.getName());
        }
        return vo;
    }

    @Transactional(readOnly=false)
    public void deleteInfo(Long id, Long loginStaffId) {
        if (id != null) {
            CompanyHseInvestigationRiskAssessmentInfo info = new CompanyHseInvestigationRiskAssessmentInfo();
            info.setId(id);
            this.delete(info, loginStaffId);
            this.companyHseInvestigationService.deleteByInfoId(id, loginStaffId);
            this.companyHseRiskAssessmentService.deleteByInfoId(id, loginStaffId);
        }
    }

    public CompanyHseInvestigationRiskAssessmentInfo getLatestEntityByCid(Long cid) {
        return ((CompanyHseInvestigationRiskAssessmentInfoMapper)this.dao).getLatestEntityByCid(cid);
    }

    public List<CompanyHseInvestigationRiskAssessmentInfo> listDataEveryCidLatestByDateRange(Date beginDate, Date endDate) {
        return ((CompanyHseInvestigationRiskAssessmentInfoMapper)this.dao).listDataEveryCidLatestByDateRange(beginDate, endDate, ((CompanyHseInvestigationRiskAssessmentInfoMapper)this.dao).selectCount(new CompanyHseInvestigationRiskAssessmentInfo()));
    }

    public Long getExposureReportIdByselfJudgeId(Long id) {
        return ((CompanyHseInvestigationRiskAssessmentInfoMapper)this.dao).getExposureReportIdByselfJudgeId(id);
    }

    public Long getExposureReportIdByselfJudgeNewId(Long id) {
        return ((CompanyHseInvestigationRiskAssessmentInfoMapper)this.dao).getExposureReportIdByselfJudgeNewId(id);
    }
}

