/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.occriskfactor;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.dao.base.occriskfactor.OccupationalRiskFactorsMapper;
import cn.smarthse.modules.health.entity.base.occriskfactor.OccupationalRiskFactors;
import cn.smarthse.modules.health.entity.work.harmfactor.Vo.HarmfactorWorkDiseaseVo;
import cn.smarthse.modules.health.entity.work.shield.vo.HarmfactorWorkInfo;
import cn.smarthse.modules.health.service.base.occriskfactor.IOccupationalRiskFactorsService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class OccupationalRiskFactorsServiceImpl
extends BaseServiceImpl<OccupationalRiskFactorsMapper, OccupationalRiskFactors>
implements IOccupationalRiskFactorsService {
    @Autowired
    OccupationalRiskFactorsMapper occupationalRiskFactorsMapper;

    @Transactional
    public OccupationalRiskFactors saveOrUpdateOccupationalRiskFactors(OccupationalRiskFactors occupationalRiskFactors, Long loginStaffId, Long cid) throws Exception {
        if (occupationalRiskFactors == null) {
            throw new Exception("occupationalRiskFactors \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (occupationalRiskFactors.getId() == null) {
            return this.add(occupationalRiskFactors, loginStaffId, cid);
        }
        this.update(occupationalRiskFactors, loginStaffId);
        return occupationalRiskFactors;
    }

    public List<OccupationalRiskFactors> selectList(Long cid, String keyword, String harmTypes) {
        List<String> harmTypesList = null;
        if (StringUtils.isNotBlank((CharSequence)harmTypes)) {
            harmTypesList = Arrays.asList(StringUtils.splitByWholeSeparator((String)harmTypes, (String)","));
        }
        return this.occupationalRiskFactorsMapper.selectList(cid, keyword, harmTypesList);
    }

    public OccupationalRiskFactors getOneOccupationalRiskFactorsByParamCode(String paramCode) {
        Example example = new Example(OccupationalRiskFactors.class);
        example.createCriteria().andEqualTo("paramcode", (Object)paramCode);
        return (OccupationalRiskFactors)this.getOneByExample(example);
    }

    public List<OccupationalRiskFactors> getOccupationalRiskFactorsListByCid(String type, String searchKey, Long cid) {
        List<OccupationalRiskFactors> list = this.occupationalRiskFactorsMapper.getOccupationalRiskFactorsByTypeAndSearch(type, searchKey, cid);
        return list;
    }

    public OccupationalRiskFactors getOccupationalRiskFactorsByNameCh(String name) {
        Example example = new Example(OccupationalRiskFactors.class);
        example.createCriteria().andEqualTo("nameCh", (Object)name).andEqualTo("isValid", (Object)true);
        List list = this.occupationalRiskFactorsMapper.selectByExample(example);
        if (list.size() > 0) {
            return (OccupationalRiskFactors)list.get(0);
        }
        return new OccupationalRiskFactors();
    }

    @Transactional(readOnly=false)
    public Map<Boolean, OccupationalRiskFactors> addOtherOccupationalRiskFactorsSubmit(OccupationalRiskFactors factors, Long loginStaffId, Long cid) {
        Example example = new Example(OccupationalRiskFactors.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("nameCh", (Object)("\u5176\u4ed6" + factors.getType() + "(" + factors.getNameCh() + ")")).andEqualTo("cid", (Object)cid).andEqualTo("type", (Object)factors.getType());
        List list = this.occupationalRiskFactorsMapper.selectByExample(example);
        HashMap<Boolean, OccupationalRiskFactors> map = new HashMap<Boolean, OccupationalRiskFactors>();
        if (list.size() > 0) {
            map.put(Boolean.TRUE, (OccupationalRiskFactors)list.get(0));
        } else {
            factors.setCid(cid);
            factors.setNameCh("\u5176\u4ed6" + factors.getType() + "(" + factors.getNameCh() + ")");
            this.add(factors);
            map.put(Boolean.FALSE, factors);
        }
        return map;
    }

    @Transactional(readOnly=false)
    public Long parseHarmName(String harmName, Long cid) {
        if (StringUtils.isBlank((CharSequence)harmName)) {
            return null;
        }
        List<OccupationalRiskFactors> harmfactorByNameCidList = this.getHarmfactorByNameCid(cid, harmName = StringUtils.toDBC((String)harmName));
        if (CollectionUtils.isEmpty(harmfactorByNameCidList)) {
            String harmType = "";
            if (harmName.startsWith("\u5176\u4ed6\u7c89\u5c18")) {
                harmType = "\u7c89\u5c18";
            } else if (harmName.startsWith("\u5176\u4ed6\u5316\u5b66\u56e0\u7d20")) {
                harmType = "\u5316\u5b66\u56e0\u7d20";
            } else if (harmName.startsWith("\u5176\u4ed6\u751f\u7269\u56e0\u7d20")) {
                harmType = "\u751f\u7269\u56e0\u7d20";
            } else if (harmName.startsWith("\u5176\u4ed6\u7269\u7406\u56e0\u7d20")) {
                harmType = "\u7269\u7406\u56e0\u7d20";
            }
            if (StringUtils.isBlank((CharSequence)harmType)) {
                return null;
            }
            OccupationalRiskFactors factors = new OccupationalRiskFactors();
            factors.setNameCh(harmName);
            factors.setType(harmType);
            factors.setCid(cid);
            try {
                OccupationalRiskFactors occupationalRiskFactors = this.addOtherOccupationalRiskFactorsSubmit2(factors, null, cid);
                return occupationalRiskFactors.getId();
            }
            catch (HealthException healthException) {}
        } else {
            return harmfactorByNameCidList.get(0).getId();
        }
        return null;
    }

    public List<OccupationalRiskFactors> getAll() {
        return this.occupationalRiskFactorsMapper.getAll();
    }

    public List<OccupationalRiskFactors> getByIds(String ids) {
        if (ids != null) {
            ArrayList<OccupationalRiskFactors> list = new ArrayList<OccupationalRiskFactors>();
            List idList = StringUtils.parseToLongList((String)ids, (String)",");
            for (Long id : idList) {
                OccupationalRiskFactors fac = (OccupationalRiskFactors)this.getById(id);
                if (fac == null) continue;
                list.add(fac);
            }
            return list;
        }
        return null;
    }

    public String getHarmNamesByIds(String ids) {
        if (ids != null) {
            StringBuilder harmNames = null;
            List idList = StringUtils.parseToLongList((String)ids, (String)",");
            for (Long id : idList) {
                OccupationalRiskFactors fac = (OccupationalRiskFactors)this.getById(id);
                if (fac == null || fac.getNameCh() == null) continue;
                if (harmNames != null) {
                    harmNames.append("\uff1b").append(fac.getNameCh());
                    continue;
                }
                harmNames = new StringBuilder(fac.getNameCh());
            }
            if (harmNames != null) {
                return harmNames.toString();
            }
        }
        return null;
    }

    public String getIdsByNames(String names) {
        if (names != null) {
            List nameList = StringUtils.parseToStringList((String)names, (String)"\uff1b");
            StringBuilder harmIds = null;
            for (String name : nameList) {
                OccupationalRiskFactors fac = this.getOccupationalRiskFactorsByNameCh(name);
                if (fac == null || fac.getId() == null) continue;
                if (harmIds != null) {
                    harmIds.append(",").append(fac.getId());
                    continue;
                }
                harmIds = new StringBuilder(fac.getId().toString());
            }
            if (harmIds != null) {
                return harmIds.toString();
            }
        }
        return null;
    }

    @Transactional(readOnly=false)
    public OccupationalRiskFactors addOtherOccupationalRiskFactorsSubmit2(OccupationalRiskFactors factors, Long loginStaffId, Long cid) {
        Example example = new Example(OccupationalRiskFactors.class);
        String nameCh = StringUtils.toDBC((String)factors.getNameCh());
        example.createCriteria().andEqualTo("nameCh", (Object)nameCh).andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true).andEqualTo("type", (Object)factors.getType());
        List list = this.occupationalRiskFactorsMapper.selectByExample(example);
        if (list.size() > 0) {
            throw new HealthException("\u5df2\u7ecf\u5b58\u5728\u8be5\u5371\u5bb3\u56e0\u7d20\u540d\u79f0");
        }
        factors.setCid(cid);
        factors.setBelongGbz22019(Integer.valueOf(1));
        factors = this.add(factors, loginStaffId, cid);
        return factors;
    }

    @Transactional(readOnly=false)
    public void deleteOtherOccupationalRiskFactorsById(Long id) {
        if (id != null) {
            OccupationalRiskFactors occ = new OccupationalRiskFactors();
            occ.setId(id);
            occ.setIsValid(Boolean.valueOf(false));
            this.occupationalRiskFactorsMapper.updateByPrimaryKeySelective(occ);
        }
    }

    public String getWarnings(Long id) {
        OccupationalRiskFactors risk = (OccupationalRiskFactors)this.getById(id);
        if (risk != null && risk.getWarningSignsRecommend() != null) {
            return risk.getWarningSignsRecommend();
        }
        return "";
    }

    public OccupationalRiskFactors getOccupationalRiskFactorsAutoCompleteByNameCh(String type, String name, Long cid) {
        List<OccupationalRiskFactors> list = this.occupationalRiskFactorsMapper.getOccupationalRiskFactorsAutoCompleteByNameCh(type, name, cid);
        if (list.size() > 0) {
            return list.get(0);
        }
        return new OccupationalRiskFactors();
    }

    public HarmfactorWorkInfo getHarmInfoById(HarmfactorWorkInfo param) {
        return ((OccupationalRiskFactorsMapper)this.dao).getHarmInfoById(param);
    }

    public List<HarmfactorWorkInfo> selectShieldHarmList(Long cid, String keyword) {
        return this.occupationalRiskFactorsMapper.selectShieldHarmList(cid, keyword);
    }

    public List<HarmfactorWorkDiseaseVo> getHarmfactorAndDieaseListByHarmIds(List<Long> harmIds) {
        if (harmIds == null || harmIds.isEmpty()) {
            return null;
        }
        return ((OccupationalRiskFactorsMapper)this.dao).getHarmfactorAndDieaseListByHarmIds(harmIds);
    }

    public List<OccupationalRiskFactors> getHarmfactorByNameCid(Long cid, String nameCh) {
        if (cid == null || StringUtils.isBlank((CharSequence)nameCh)) {
            return null;
        }
        return ((OccupationalRiskFactorsMapper)this.dao).getHarmfactorByNameCid(cid, nameCh);
    }
}

