/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.ms;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.dao.base.ms.MsPohopUploadFileMapper;
import cn.smarthse.modules.health.entity.base.ms.MsPohop;
import cn.smarthse.modules.health.entity.base.ms.MsPohopUploadFile;
import cn.smarthse.modules.health.service.base.ms.IMsPohopUploadFileService;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class MsPohopUploadFileServiceImpl
extends BaseServiceImpl<MsPohopUploadFileMapper, MsPohopUploadFile>
implements IMsPohopUploadFileService {
    @DubboReference
    ISysFileProvideService sysFileServiceImpl;
    @Autowired
    MsPohopUploadFileMapper msPohopUploadFileMapper;

    public List<MsPohopUploadFile> getByPohopId(Long id) {
        Example example = new Example(MsPohopUploadFile.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("pohopId", (Object)id).andEqualTo("isValid", (Object)Global.TRUE);
        example.setOrderByClause("id asc");
        List<MsPohopUploadFile> list = this.getListByExample(example);
        return list;
    }

    public List<MsPohop> setMsPohopUploadFileIdAndName(List<MsPohop> list, Long cid) {
        for (MsPohop msPohop : list) {
            SysFileModel sysFile;
            if (msPohop.getFileId() == null || (sysFile = this.sysFileServiceImpl.getFileById(msPohop.getFileId())) == null) continue;
            msPohop.setFileId(sysFile.getId());
            msPohop.setFileName(sysFile.getFileName());
        }
        return list;
    }

    @Transactional(readOnly=false)
    public void editFile(MsPohop msPohop, Long cid, Long staffid) {
        List<MsPohopUploadFile> list = this.getByPohopId(msPohop.getId());
        for (MsPohopUploadFile msPohopUploadFile : list) {
            msPohopUploadFile.setIsValid(Boolean.valueOf(false));
            this.update(msPohopUploadFile, staffid);
        }
        if (msPohop.getFileIds() != null && msPohop.getFileIds().length > 0) {
            for (Long fileId : msPohop.getFileIds()) {
                MsPohopUploadFile msPohopUploadFile = new MsPohopUploadFile();
                msPohopUploadFile.setPohopId(msPohop.getId());
                msPohopUploadFile.setFileId(fileId);
                this.add(msPohopUploadFile, staffid, cid);
            }
        }
    }
}

